/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.StretchBend;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class StretchBendPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(StretchBendPotentialEnergy.class.getName());
    private final List<StretchBend> stretchBends = new ArrayList<StretchBend>();

    public StretchBendPotentialEnergy(String name) {
        super(name);
    }

    public StretchBendPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public StretchBendPotentialEnergy(String name, int forceGroup, List<StretchBend> stretchBends) {
        super(name, forceGroup);
        if (stretchBends != null) {
            Collections.sort(stretchBends);
            this.stretchBends.addAll(stretchBends);
            logger.info(String.format("  Stretch-Bends:                     %10d", this.getNumberOfStretchBends()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfStretchBends();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getStretchBendArray();
    }

    public StretchBendPotentialEnergy(String name, Collection<StretchBend> stretchBends) {
        super(name);
        if (stretchBends != null) {
            this.stretchBends.addAll(stretchBends);
        }
    }

    public boolean addStretchBend(StretchBend stretchBend) {
        if (stretchBend == null) {
            return false;
        }
        return this.stretchBends.add(stretchBend);
    }

    public boolean addStretchBends(StretchBend[] stretchBends) {
        if (stretchBends == null) {
            return false;
        }
        Collections.addAll(this.stretchBends, stretchBends);
        return true;
    }

    public boolean addStretchBends(List<StretchBend> stretchBends) {
        if (stretchBends == null) {
            return false;
        }
        this.stretchBends.addAll(stretchBends);
        return true;
    }

    public boolean removeStretchBend(StretchBend stretchBend) {
        if (stretchBend == null) {
            return false;
        }
        return this.stretchBends.remove(stretchBend);
    }

    public StretchBend getStretchBend(int index) {
        return this.stretchBends.get(index);
    }

    public List<StretchBend> getStretchBends() {
        return Collections.unmodifiableList(this.stretchBends);
    }

    public StretchBend[] getStretchBendArray() {
        return this.stretchBends.toArray(new StretchBend[0]);
    }

    public int getNumberOfStretchBends() {
        return this.stretchBends.size();
    }

    public static String getStretchBendEnergyString() {
        return String.format("(k1*(distance(p1,p2)-r12) + k2*(distance(p2,p3)-r23))*(%.15g*(angle(p1,p2,p3)-theta0))", 57.29577951308232);
    }

    @Override
    public void log() {
        if (this.getNumberOfStretchBends() <= 0) {
            return;
        }
        logger.info("\n Stretch-Bend Interactions:");
        for (StretchBend stretchBend : this.getStretchBends()) {
            logger.info(" Stretch-Bend \t" + stretchBend.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfStretchBends() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "STRETCH-BEND               : ", this.getEnergy(), this.getNumberOfStretchBends());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Stretch-Bend      ", this.getEnergy(), this.getNumberOfStretchBends(), this.getTime());
    }
}

