/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.crystal.Crystal;
import ffx.numerics.switching.ConstantSwitch;
import ffx.numerics.switching.UnivariateFunctionFactory;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.RestrainDistance;
import ffx.potential.parameters.BondType;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.CompositeConfiguration;

public class RestrainDistancePotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(RestrainDistancePotentialEnergy.class.getName());
    private final List<RestrainDistance> restrainDistances = new ArrayList<RestrainDistance>();

    @Override
    public void log() {
        if (this.getNumberOfRestrainDistances() <= 0) {
            return;
        }
        logger.info("\n Restrain Distance Interactions:");
        for (RestrainDistance restrainDistance : this.getRestrainDistances()) {
            logger.info(" Restrain Distance \t" + restrainDistance.toString());
        }
    }

    public RestrainDistancePotentialEnergy(String name) {
        super(name);
    }

    public RestrainDistancePotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public RestrainDistancePotentialEnergy(String name, int forceGroup, List<RestrainDistance> restrainDistances) {
        super(name, forceGroup);
        if (restrainDistances != null) {
            Collections.sort(restrainDistances);
            this.restrainDistances.addAll(restrainDistances);
            logger.info(String.format("  Restrain Distances:                 %10d", this.getNumberOfRestrainDistances()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfRestrainDistances();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getRestrainDistanceArray();
    }

    public RestrainDistancePotentialEnergy(String name, Collection<RestrainDistance> restrainDistances) {
        super(name);
        if (restrainDistances != null) {
            this.restrainDistances.addAll(restrainDistances);
        }
    }

    public boolean addRestrainDistance(RestrainDistance restrainDistance) {
        if (restrainDistance == null) {
            return false;
        }
        return this.restrainDistances.add(restrainDistance);
    }

    public boolean addRestrainDistances(RestrainDistance[] restrainDistances) {
        if (restrainDistances == null) {
            return false;
        }
        Collections.addAll(this.restrainDistances, restrainDistances);
        return true;
    }

    public boolean addRestrainDistances(List<RestrainDistance> restrainDistances) {
        if (restrainDistances == null) {
            return false;
        }
        this.restrainDistances.addAll(restrainDistances);
        return true;
    }

    public boolean removeRestrainDistance(RestrainDistance restrainDistance) {
        if (restrainDistance == null) {
            return false;
        }
        return this.restrainDistances.remove(restrainDistance);
    }

    public RestrainDistance getRestrainDistance(int index) {
        return this.restrainDistances.get(index);
    }

    public List<RestrainDistance> getRestrainDistances() {
        return Collections.unmodifiableList(this.restrainDistances);
    }

    public RestrainDistance[] getRestrainDistanceArray() {
        return this.restrainDistances.toArray(new RestrainDistance[0]);
    }

    public int getNumberOfRestrainDistances() {
        return this.restrainDistances.size();
    }

    public List<RestrainDistance> getRestrainDistances(@Nullable BondType.BondFunction bondFunction) {
        if (bondFunction == null) {
            return this.restrainDistances;
        }
        ArrayList<RestrainDistance> list = new ArrayList<RestrainDistance>();
        for (RestrainDistance restrainDistance : this.restrainDistances) {
            if (restrainDistance.getBondType().bondFunction != bondFunction) continue;
            list.add(restrainDistance);
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfRestrainDistances() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "RESTRAIN DISTANCE          : ", this.getEnergy(), this.getNumberOfRestrainDistances());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Restrain Distance ", this.getEnergy(), this.getNumberOfRestrainDistances(), this.getTime());
    }

    public static RestrainDistance[] configureRestrainDistances(CompositeConfiguration properties, Atom[] atoms, Crystal crystal, boolean lambdaTerm) {
        String[] bondRestraints;
        ArrayList<RestrainDistance> restrainDistanceList = new ArrayList<RestrainDistance>();
        for (String bondRest : bondRestraints = properties.getStringArray("restrain-distance")) {
            try {
                ConstantSwitch switchF;
                double dist;
                String[] toks = bondRest.split("\\s+");
                if (toks.length < 2) {
                    throw new IllegalArgumentException(String.format(" restrain-distance value %s could not be parsed!", bondRest));
                }
                int at1 = Integer.parseInt(toks[0]) - 1;
                int at2 = Integer.parseInt(toks[1]) - 1;
                double forceConst = 100.0;
                double flatBottomRadius = 0.0;
                Atom a1 = atoms[at1];
                Atom a2 = atoms[at2];
                if (toks.length > 2) {
                    forceConst = Double.parseDouble(toks[2]);
                }
                switch (toks.length) {
                    case 2: 
                    case 3: {
                        double[] xyz1 = new double[3];
                        xyz1 = a1.getXYZ(xyz1);
                        double[] xyz2 = new double[3];
                        xyz2 = a2.getXYZ(xyz2);
                        dist = crystal.minDistOverSymOps(xyz1, xyz2);
                        break;
                    }
                    case 4: {
                        dist = Double.parseDouble(toks[3]);
                        break;
                    }
                    default: {
                        double minDist = Double.parseDouble(toks[3]);
                        double maxDist = Double.parseDouble(toks[4]);
                        dist = 0.5 * (minDist + maxDist);
                        flatBottomRadius = 0.5 * Math.abs(maxDist - minDist);
                    }
                }
                double lamStart = 0.75;
                double lamEnd = 1.0;
                if (toks.length > 5) {
                    int offset = 5;
                    if (toks[5].matches("^[01](?:\\.[0-9]*)?")) {
                        offset = 6;
                        lamStart = Double.parseDouble(toks[5]);
                        if (toks[6].matches("^[01](?:\\.[0-9]*)?")) {
                            offset = 7;
                            lamEnd = Double.parseDouble(toks[6]);
                        }
                    }
                    switchF = UnivariateFunctionFactory.parseUSF((String[])toks, (int)offset);
                } else {
                    switchF = new ConstantSwitch();
                }
                RestrainDistance restrainDistance = RestrainDistancePotentialEnergy.createRestrainDistance(a1, a2, dist, forceConst, flatBottomRadius, lamStart, lamEnd, (UnivariateSwitchingFunction)switchF, lambdaTerm, crystal);
                restrainDistanceList.add(restrainDistance);
            }
            catch (Exception ex) {
                logger.info(String.format(" Exception in parsing restrain-distance: %s", ex));
            }
        }
        if (!restrainDistanceList.isEmpty()) {
            return restrainDistanceList.toArray(new RestrainDistance[0]);
        }
        return null;
    }

    private static RestrainDistance createRestrainDistance(Atom a1, Atom a2, double distance, double forceConstant, double flatBottom, double lamStart, double lamEnd, UnivariateSwitchingFunction switchingFunction, boolean lambdaTerm, Crystal crystal) {
        boolean rbLambda = !(switchingFunction instanceof ConstantSwitch) && lambdaTerm;
        RestrainDistance restrainDistance = new RestrainDistance(a1, a2, crystal, rbLambda, lamStart, lamEnd, switchingFunction);
        int[] classes = new int[]{a1.getAtomType().atomClass, a2.getAtomType().atomClass};
        if (flatBottom != 0.0) {
            BondType bondType = new BondType(classes, forceConstant, distance, BondType.BondFunction.FLAT_BOTTOM_HARMONIC, flatBottom);
            restrainDistance.setBondType(bondType);
        } else {
            BondType bondType = new BondType(classes, forceConstant, distance, BondType.BondFunction.HARMONIC);
            restrainDistance.setBondType(bondType);
        }
        return restrainDistance;
    }
}

