/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.parameters.OutOfPlaneBendType;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class OutOfPlaneBendPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(OutOfPlaneBendPotentialEnergy.class.getName());
    private final List<OutOfPlaneBend> outOfPlaneBends = new ArrayList<OutOfPlaneBend>();

    public OutOfPlaneBendPotentialEnergy(String name) {
        super(name);
    }

    public OutOfPlaneBendPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public OutOfPlaneBendPotentialEnergy(String name, int forceGroup, List<OutOfPlaneBend> outOfPlaneBends) {
        super(name, forceGroup);
        if (outOfPlaneBends != null) {
            Collections.sort(outOfPlaneBends);
            this.outOfPlaneBends.addAll(outOfPlaneBends);
            logger.info(String.format("  Out-of-Plane Bends:                %10d", this.getNumberOfOutOfPlaneBends()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfOutOfPlaneBends();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getOutOfPlaneBendArray();
    }

    public OutOfPlaneBendPotentialEnergy(String name, Collection<OutOfPlaneBend> outOfPlaneBends) {
        super(name);
        if (outOfPlaneBends != null) {
            this.outOfPlaneBends.addAll(outOfPlaneBends);
        }
    }

    public boolean addOutOfPlaneBend(OutOfPlaneBend outOfPlaneBend) {
        if (outOfPlaneBend == null) {
            return false;
        }
        return this.outOfPlaneBends.add(outOfPlaneBend);
    }

    public boolean addOutOfPlaneBends(OutOfPlaneBend[] outOfPlaneBends) {
        if (outOfPlaneBends == null) {
            return false;
        }
        Collections.addAll(this.outOfPlaneBends, outOfPlaneBends);
        return true;
    }

    public boolean addOutOfPlaneBends(List<OutOfPlaneBend> outOfPlaneBends) {
        if (outOfPlaneBends == null) {
            return false;
        }
        this.outOfPlaneBends.addAll(outOfPlaneBends);
        return true;
    }

    public boolean removeOutOfPlaneBend(OutOfPlaneBend outOfPlaneBend) {
        if (outOfPlaneBend == null) {
            return false;
        }
        return this.outOfPlaneBends.remove(outOfPlaneBend);
    }

    public OutOfPlaneBend getOutOfPlaneBend(int index) {
        return this.outOfPlaneBends.get(index);
    }

    public List<OutOfPlaneBend> getOutOfPlaneBends() {
        return Collections.unmodifiableList(this.outOfPlaneBends);
    }

    public OutOfPlaneBend[] getOutOfPlaneBendArray() {
        return this.outOfPlaneBends.toArray(new OutOfPlaneBend[0]);
    }

    public int getNumberOfOutOfPlaneBends() {
        return this.outOfPlaneBends.size();
    }

    public String getOutOfPlaneEnergyString() {
        OutOfPlaneBendType outOfPlaneBendType = this.outOfPlaneBends.getFirst().outOfPlaneBendType;
        String energy = String.format("k*(theta^2 + %.15g*theta^3 + %.15g*theta^4 + %.15g*theta^5 + %.15g*theta^6);\ntheta = %.15g*pointangle(x2, y2, z2, x4, y4, z4, projx, projy, projz);\nprojx = x2-nx*dot;\nprojy = y2-ny*dot;\nprojz = z2-nz*dot;\ndot = nx*(x2-x3) + ny*(y2-y3) + nz*(z2-z3);\nnx = px/norm;\nny = py/norm;\nnz = pz/norm;\nnorm = sqrt(px*px + py*py + pz*pz);\npx = (d1y*d2z-d1z*d2y);\npy = (d1z*d2x-d1x*d2z);\npz = (d1x*d2y-d1y*d2x);\nd1x = x1-x4;\nd1y = y1-y4;\nd1z = z1-z4;\nd2x = x3-x4;\nd2y = y3-y4;\nd2z = z3-z4\n", outOfPlaneBendType.cubic, outOfPlaneBendType.quartic, outOfPlaneBendType.pentic, outOfPlaneBendType.sextic, 57.29577951308232);
        return energy;
    }

    @Override
    public void log() {
        if (this.getNumberOfOutOfPlaneBends() <= 0) {
            return;
        }
        logger.info("\n Out-of-Plane Bend Interactions:");
        for (OutOfPlaneBend outOfPlaneBend : this.getOutOfPlaneBends()) {
            logger.info(" Out-of-Plane Bend \t" + outOfPlaneBend.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfOutOfPlaneBends() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "OUT-OF-PLANE BEND          : ", this.getEnergy(), this.getNumberOfOutOfPlaneBends());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Out-of-Plane Bend ", this.getEnergy(), this.getNumberOfOutOfPlaneBends(), this.getTime());
    }
}

