/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class ImproperTorsionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(ImproperTorsionPotentialEnergy.class.getName());
    private final List<ImproperTorsion> improperTorsions = new ArrayList<ImproperTorsion>();

    public ImproperTorsionPotentialEnergy(String name) {
        super(name);
    }

    public ImproperTorsionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public ImproperTorsionPotentialEnergy(String name, int forceGroup, List<ImproperTorsion> improperTorsions) {
        super(name, forceGroup);
        if (improperTorsions != null) {
            Collections.sort(improperTorsions);
            this.improperTorsions.addAll(improperTorsions);
            logger.info(String.format("  Improper Torsions:                 %10d", this.getNumberOfImproperTorsions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfImproperTorsions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getImproperTorsionArray();
    }

    public ImproperTorsionPotentialEnergy(String name, Collection<ImproperTorsion> improperTorsions) {
        super(name);
        if (improperTorsions != null) {
            this.improperTorsions.addAll(improperTorsions);
        }
    }

    public boolean addImproperTorsion(ImproperTorsion improperTorsion) {
        if (improperTorsion == null) {
            return false;
        }
        return this.improperTorsions.add(improperTorsion);
    }

    public boolean addImproperTorsions(ImproperTorsion[] improperTorsions) {
        if (improperTorsions == null) {
            return false;
        }
        Collections.addAll(this.improperTorsions, improperTorsions);
        return true;
    }

    public boolean addImproperTorsions(List<ImproperTorsion> improperTorsions) {
        if (improperTorsions == null) {
            return false;
        }
        this.improperTorsions.addAll(improperTorsions);
        return true;
    }

    public boolean removeImproperTorsion(ImproperTorsion improperTorsion) {
        if (improperTorsion == null) {
            return false;
        }
        return this.improperTorsions.remove(improperTorsion);
    }

    public ImproperTorsion getImproperTorsion(int index) {
        return this.improperTorsions.get(index);
    }

    public List<ImproperTorsion> getImproperTorsions() {
        return Collections.unmodifiableList(this.improperTorsions);
    }

    public ImproperTorsion[] getImproperTorsionArray() {
        return this.improperTorsions.toArray(new ImproperTorsion[0]);
    }

    public int getNumberOfImproperTorsions() {
        return this.improperTorsions.size();
    }

    @Override
    public void log() {
        if (this.getNumberOfImproperTorsions() <= 0) {
            return;
        }
        logger.info("\n Improper Interactions:");
        for (ImproperTorsion improperTorsion : this.getImproperTorsions()) {
            logger.info(" Improper \t" + improperTorsion.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfImproperTorsions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "IMPROPER TORSION           : ", this.getEnergy(), this.getNumberOfImproperTorsions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Improper Torsion  ", this.getEnergy(), this.getNumberOfImproperTorsions(), this.getTime());
    }
}

