/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.Potential;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.ForceField;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class EnergyTermRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(EnergyTermRegion.class.getName());
    private final Atom[] atoms;
    private final int nAtoms;
    private boolean gradient = false;
    private boolean initAtomGradients = true;
    private Potential.STATE state = Potential.STATE.BOTH;
    protected boolean checkAlchemicalAtoms = true;
    protected boolean lambdaBondedTerms = false;
    protected boolean lambdaAllBondedTerms = false;
    private final List<EnergyTerm> energyTerms = new ArrayList<EnergyTerm>();
    private final BondedTermLoop[] bondedTermLoops;
    private final GradInitLoop[] gradInitLoops;
    private final GradReduceLoop[] gradReduceLoops;
    private final AtomicDoubleArray3D grad;
    private final AtomicDoubleArray3D lambdaGrad;

    public EnergyTermRegion(ParallelTeam parallelTeam, MolecularAssembly molecularAssembly, boolean lambdaTerm) {
        this.atoms = molecularAssembly.getAtomArray();
        this.nAtoms = this.atoms.length;
        AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI;
        ForceField forceField = molecularAssembly.getForceField();
        int nThreads = parallelTeam.getThreadCount();
        this.bondedTermLoops = new BondedTermLoop[nThreads];
        this.gradInitLoops = new GradInitLoop[nThreads];
        this.gradReduceLoops = new GradReduceLoop[nThreads];
        for (int i = 0; i < nThreads; ++i) {
            this.bondedTermLoops[i] = new BondedTermLoop(this);
            this.gradInitLoops[i] = new GradInitLoop(this);
            this.gradReduceLoops[i] = new GradReduceLoop(this);
        }
        String value = forceField.getString("ARRAY_REDUCTION", "MULTI");
        try {
            atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.valueOf((String)ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            logger.info(String.format(" Unrecognized ARRAY-REDUCTION %s; defaulting to %s", value, atomicDoubleArrayImpl));
        }
        logger.fine(String.format("  Bonded using %s arrays.", atomicDoubleArrayImpl));
        int nAtoms = molecularAssembly.getAtomArray().length;
        this.grad = new AtomicDoubleArray3D(atomicDoubleArrayImpl, nAtoms, nThreads);
        this.lambdaGrad = lambdaTerm ? new AtomicDoubleArray3D(atomicDoubleArrayImpl, nAtoms, nThreads) : null;
    }

    public void setCheckAlchemicalAtoms(boolean checkAlchemicalAtoms) {
        this.checkAlchemicalAtoms = checkAlchemicalAtoms;
    }

    public boolean getCheckAlchemicalAtoms() {
        return this.checkAlchemicalAtoms;
    }

    public void setLambdaBondedTerms(boolean lambdaBondedTerms) {
        this.lambdaBondedTerms = lambdaBondedTerms;
    }

    public boolean getLambdaBondedTerms() {
        return this.lambdaBondedTerms;
    }

    public void setLambdaAllBondedTerms(boolean lambdaAllBondedTerms) {
        this.lambdaAllBondedTerms = lambdaAllBondedTerms;
    }

    public boolean getLambdaAllBondedTerms() {
        return this.lambdaAllBondedTerms;
    }

    public void setInitAtomGradients(boolean initAtomGradients) {
        this.initAtomGradients = initAtomGradients;
    }

    public boolean getInitAtomGradients() {
        return this.initAtomGradients;
    }

    public double getEnergy() {
        double energy = 0.0;
        for (EnergyTerm term : this.energyTerms) {
            energy += term.getEnergy();
        }
        return energy;
    }

    public void log() {
        for (EnergyTerm term : this.energyTerms) {
            term.log();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (EnergyTerm term : this.energyTerms) {
            sb.append(term.toString());
        }
        return sb.toString();
    }

    public String toPDBString() {
        StringBuilder sb = new StringBuilder();
        for (EnergyTerm term : this.energyTerms) {
            sb.append(term.toPDBString());
        }
        return sb.toString();
    }

    public void setState(Potential.STATE state) {
        if (state == null) {
            throw new IllegalArgumentException("Potential state cannot be null.");
        }
        this.state = state;
    }

    public void setGradient(boolean gradient) {
        this.gradient = gradient;
    }

    public boolean getGradient() {
        return this.gradient;
    }

    public boolean addEnergyTerm(EnergyTerm term) {
        if (term == null) {
            return false;
        }
        return this.energyTerms.add(term);
    }

    public boolean removeEnergyTerm(EnergyTerm term) {
        if (term == null) {
            return false;
        }
        return this.energyTerms.remove(term);
    }

    public EnergyTerm getEnergyTerm(int index) {
        return this.energyTerms.get(index);
    }

    public List<EnergyTerm> getEnergyTerms() {
        return Collections.unmodifiableList(this.energyTerms);
    }

    public void start() {
        for (EnergyTerm term : this.energyTerms) {
            term.setEnergy(0.0);
            term.setRMSD(0.0);
        }
    }

    public void run() throws Exception {
        int threadIndex = this.getThreadIndex();
        if (this.gradient) {
            this.execute(0, this.nAtoms - 1, this.gradInitLoops[threadIndex]);
        }
        if (this.state == Potential.STATE.BOTH || this.state == Potential.STATE.FAST) {
            BondedTermLoop bondedTermLoop = this.bondedTermLoops[threadIndex];
            for (EnergyTerm term : this.energyTerms) {
                if (threadIndex == 0) {
                    term.startTime();
                }
                bondedTermLoop.setEnergyTerm(term);
                this.execute(0, term.getNumberOfTerms() - 1, bondedTermLoop);
                if (threadIndex != 0) continue;
                term.stopTime();
            }
        }
        if (this.gradient) {
            this.execute(0, this.nAtoms - 1, this.gradReduceLoops[threadIndex]);
        }
    }

    private class BondedTermLoop
    extends IntegerForLoop {
        private EnergyTerm energyTerm;
        final /* synthetic */ EnergyTermRegion this$0;

        private BondedTermLoop(EnergyTermRegion energyTermRegion) {
            EnergyTermRegion energyTermRegion2 = energyTermRegion;
            Objects.requireNonNull(energyTermRegion2);
            this.this$0 = energyTermRegion2;
        }

        public void setEnergyTerm(EnergyTerm terms) {
            this.energyTerm = terms;
        }

        public void run(int first, int last) {
            int threadIndex = this.getThreadIndex();
            double localEnergy = 0.0;
            double localRMSD = 0.0;
            BondedTerm[] bondedTerms = this.energyTerm.getBondedTermsArray();
            for (int i = first; i <= last; ++i) {
                BondedTerm term = bondedTerms[i];
                boolean used = true;
                if (this.this$0.checkAlchemicalAtoms) {
                    boolean bl = used = !this.this$0.lambdaBondedTerms || this.this$0.lambdaAllBondedTerms || term.applyLambda() && !term.isLambdaScaled();
                }
                if (!used) continue;
                localEnergy += term.energy(this.this$0.gradient, threadIndex, this.this$0.grad, this.this$0.lambdaGrad);
                double value = term.getValue();
                localRMSD += value * value;
            }
            this.energyTerm.addAndGetEnergy(localEnergy);
            this.energyTerm.addAndGetRMSD(localRMSD);
        }
    }

    private class GradInitLoop
    extends IntegerForLoop {
        final /* synthetic */ EnergyTermRegion this$0;

        private GradInitLoop(EnergyTermRegion energyTermRegion) {
            EnergyTermRegion energyTermRegion2 = energyTermRegion;
            Objects.requireNonNull(energyTermRegion2);
            this.this$0 = energyTermRegion2;
        }

        public void run(int first, int last) {
            int i;
            int threadID = this.getThreadIndex();
            if (this.this$0.gradient) {
                this.this$0.grad.reset(threadID, first, last);
                if (this.this$0.initAtomGradients) {
                    for (i = first; i <= last; ++i) {
                        this.this$0.atoms[i].setXYZGradient(0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.this$0.lambdaGrad != null) {
                this.this$0.lambdaGrad.reset(threadID, first, last);
                if (this.this$0.initAtomGradients) {
                    for (i = first; i <= last; ++i) {
                        this.this$0.atoms[i].setLambdaXYZGradient(0.0, 0.0, 0.0);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }

    private class GradReduceLoop
    extends IntegerForLoop {
        final /* synthetic */ EnergyTermRegion this$0;

        private GradReduceLoop(EnergyTermRegion energyTermRegion) {
            EnergyTermRegion energyTermRegion2 = energyTermRegion;
            Objects.requireNonNull(energyTermRegion2);
            this.this$0 = energyTermRegion2;
        }

        public void run(int first, int last) {
            Atom a;
            int i;
            if (this.this$0.gradient) {
                this.this$0.grad.reduce(first, last);
                for (i = first; i <= last; ++i) {
                    a = this.this$0.atoms[i];
                    a.addToXYZGradient(this.this$0.grad.getX(i), this.this$0.grad.getY(i), this.this$0.grad.getZ(i));
                }
            }
            if (this.this$0.lambdaGrad != null) {
                this.this$0.lambdaGrad.reduce(first, last);
                for (i = first; i <= last; ++i) {
                    a = this.this$0.atoms[i];
                    a.addToLambdaXYZGradient(this.this$0.lambdaGrad.getX(i), this.this$0.lambdaGrad.getY(i), this.this$0.lambdaGrad.getZ(i));
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

