/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PDBMLFilter
implements ErrorHandler {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String PDBX_XSD = "pdbx.xsd";
    private File pdbxFile = null;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java PDBXFilter name.xml");
        }
        PDBMLFilter pdbx = new PDBMLFilter();
        File pdbxFile = new File(args[0]);
        pdbx.parse(pdbxFile);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.parseMessage(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.parseMessage(e);
    }

    public void parseMessage(Exception e) {
        System.out.println("Could not parse: " + String.valueOf(this.pdbxFile) + "\n" + String.valueOf(e));
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.parseMessage(e);
    }

    private void parse(File pdbxml) {
        this.pdbxFile = pdbxml;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, new File(PDBX_XSD));
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(this);
            Document doc = db.parse(this.pdbxFile);
            NodeList list = doc.getElementsByTagName("PDBx:atom_site");
            System.out.println("Number of Atoms: " + list.getLength());
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException e) {
            this.parseMessage(e);
        }
    }
}

