/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.crystal.Crystal;
import ffx.crystal.SpaceGroup;
import ffx.crystal.SpaceGroupDefinitions;
import ffx.crystal.SpaceGroupInfo;
import ffx.crystal.SymOp;
import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Molecule;
import ffx.potential.bonded.NamingUtils;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.PolymerUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.SystemFilter;
import ffx.utilities.Hybrid36;
import ffx.utilities.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public final class PDBFilter
extends SystemFilter {
    private static final Logger logger = Logger.getLogger(PDBFilter.class.getName());
    private static final Set<String> backboneNames;
    private static final Set<String> constantPhBackboneNames;
    private static final Set<String> naBackboneNames;
    private final Map<Character, String[]> seqRes = new HashMap<Character, String[]>();
    private final Map<Character, int[]> dbRef = new HashMap<Character, int[]>();
    private final List<Character> altLocs = new ArrayList<Character>();
    private final List<String> segIDs = new ArrayList<String>();
    private final Map<Character, List<String>> segidMap = new HashMap<Character, List<String>>();
    private final Map<Character, Integer> insertionCodeCount = new HashMap<Character, Integer>();
    private final Map<String, String> pdbToNewResMap = new HashMap<String, String>();
    private final Map<String, String> modRes = new HashMap<String, String>();
    private final HashMap<Integer, Atom> atoms = new HashMap();
    private final Map<MolecularAssembly, BufferedReader> readers = new HashMap<MolecularAssembly, BufferedReader>();
    private Character currentAltLoc = Character.valueOf('A');
    private Character currentChainID = null;
    private String currentSegID = null;
    private boolean mutate = false;
    private List<Mutation> mutations = null;
    private List<Integer> resNumberList = null;
    private boolean printMissingFields = true;
    private int nSymOp = -1;
    private int lValue = -1;
    private int mValue = -1;
    private int nValue = -1;
    private int serialP1 = 0;
    private PDBFileStandard fileStandard = PDBFileStandard.VERSION3_3;
    private boolean logWrites = true;
    private int modelsRead = 1;
    private int modelsWritten = -1;
    private int[] lmn = new int[]{1, 1, 1};
    private final File readFile;
    private List<String> remarkLines = Collections.emptyList();
    private double lastReadLambda = Double.NaN;
    private boolean constantPH = false;
    private boolean rotamerTitration = false;
    private static final HashMap<AminoAcidUtils.AminoAcid3, AminoAcidUtils.AminoAcid3> constantPHResidueMap;
    private static final HashMap<AminoAcidUtils.AminoAcid3, AminoAcidUtils.AminoAcid3> rotamerResidueMap;

    public PDBFilter(List<File> files, MolecularAssembly molecularAssembly, ForceField forceField, CompositeConfiguration properties) {
        super(files, molecularAssembly, forceField, properties);
        this.bondList = new ArrayList();
        this.fileType = Utilities.FileType.PDB;
        this.readFile = files.getFirst();
    }

    public PDBFilter(File file, MolecularAssembly molecularAssembly, ForceField forceField, CompositeConfiguration properties) {
        super(file, molecularAssembly, forceField, properties);
        this.bondList = new ArrayList();
        this.fileType = Utilities.FileType.PDB;
        this.readFile = file;
    }

    public PDBFilter(File file, List<MolecularAssembly> molecularAssemblies, ForceField forceField, CompositeConfiguration properties) {
        super(file, molecularAssemblies, forceField, properties);
        this.bondList = new ArrayList();
        this.fileType = Utilities.FileType.PDB;
        this.readFile = file;
    }

    public PDBFilter(File file, MolecularAssembly molecularAssembly, ForceField forceField, CompositeConfiguration properties, List<Integer> resNumberList) {
        super(file, molecularAssembly, forceField, properties);
        this.bondList = new ArrayList();
        this.fileType = Utilities.FileType.PDB;
        this.readFile = file;
        this.resNumberList = resNumberList;
    }

    public static String toPDBAtomLine(Atom atom) {
        StringBuilder sb = atom.isHetero() ? new StringBuilder("HETATM") : new StringBuilder("ATOM  ");
        sb.append(org.apache.commons.lang3.StringUtils.repeat((String)" ", (int)74));
        Object name = atom.getName();
        int nameLength = ((String)name).length();
        if (nameLength > 4) {
            name = ((String)name).substring(0, 4);
        } else if (nameLength == 1) {
            name = (String)name + "  ";
        } else if (nameLength == 2) {
            name = (String)name + " ";
        }
        int serial = atom.getXyzIndex();
        sb.replace(6, 16, String.format("%5s " + StringUtils.padLeft((String)((String)name).toUpperCase(), (int)4), Hybrid36.encode((int)5, (int)serial)));
        Character altLoc = atom.getAltLoc();
        if (altLoc != null) {
            sb.setCharAt(16, altLoc.charValue());
        } else {
            char blankChar = ' ';
            sb.setCharAt(16, blankChar);
        }
        String resName = atom.getResidueName();
        sb.replace(17, 20, StringUtils.padLeft((String)resName.toUpperCase(), (int)3));
        char chain = atom.getChainID().charValue();
        sb.setCharAt(21, chain);
        int resID = atom.getResidueNumber();
        sb.replace(22, 26, String.format("%4s", Hybrid36.encode((int)4, (int)resID)));
        double[] xyz = atom.getXYZ(null);
        StringBuilder decimals = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            try {
                decimals.append(StringUtils.fwFpDec((double)xyz[i], (int)8, (int)3));
                continue;
            }
            catch (IllegalArgumentException ex) {
                String newValue = StringUtils.fwFpTrunc((double)xyz[i], (int)8, (int)3);
                logger.info(String.format(" XYZ coordinate %8.3f for atom %s overflowed PDB format and is truncated to %s.", xyz[i], atom, newValue));
                decimals.append(newValue);
            }
        }
        try {
            decimals.append(StringUtils.fwFpDec((double)atom.getOccupancy(), (int)6, (int)2));
        }
        catch (IllegalArgumentException ex) {
            logger.severe(String.format(" Occupancy %6.2f for atom %s must be between 0 and 1.", atom.getOccupancy(), atom));
        }
        try {
            decimals.append(StringUtils.fwFpDec((double)atom.getTempFactor(), (int)6, (int)2));
        }
        catch (IllegalArgumentException ex) {
            String newValue = StringUtils.fwFpTrunc((double)atom.getTempFactor(), (int)6, (int)2);
            logger.info(String.format(" B-factor %6.2f for atom %s overflowed the PDB format and is truncated to %s.", atom.getTempFactor(), atom, newValue));
            decimals.append(newValue);
        }
        sb.replace(30, 66, decimals.toString());
        sb.replace(78, 80, String.format("%2d", 0));
        sb.append("\n");
        return sb.toString();
    }

    public void setConstantPH(boolean constantPH) {
        this.constantPH = constantPH;
    }

    public void setRotamerTitration(boolean rotamerTitration) {
        this.rotamerTitration = rotamerTitration;
    }

    public void clearSegIDs() {
        this.segIDs.clear();
    }

    @Override
    public void closeReader() {
        for (MolecularAssembly system : this.systems) {
            BufferedReader br = this.readers.get(system);
            if (br == null) continue;
            try {
                br.close();
            }
            catch (IOException ex) {
                logger.warning(String.format(" Exception in closing system %s: %s", system.toString(), ex));
            }
        }
    }

    @Override
    public int countNumModels() {
        Set files = this.systems.stream().map(MolecularAssembly::getFile).map(File::toString).distinct().map(File::new).collect(Collectors.toSet());
        return files.parallelStream().mapToInt(fi -> {
            int nModelsLocal = 0;
            try (BufferedReader br = new BufferedReader(new FileReader((File)fi));){
                String line = br.readLine();
                while (line != null) {
                    if (line.startsWith("MODEL")) {
                        ++nModelsLocal;
                    }
                    line = br.readLine();
                }
                nModelsLocal = Math.max(1, nModelsLocal);
            }
            catch (IOException ex) {
                logger.info(String.format(" Exception in parsing file %s: %s", fi, ex));
            }
            return nModelsLocal;
        }).sum();
    }

    public List<Character> getAltLocs() {
        return this.altLocs;
    }

    @Override
    public OptionalDouble getLastReadLambda() {
        return Double.isNaN(this.lastReadLambda) ? OptionalDouble.empty() : OptionalDouble.of(this.lastReadLambda);
    }

    @Override
    public String[] getRemarkLines() {
        int nRemarks = this.remarkLines.size();
        return this.remarkLines.toArray(new String[nRemarks]);
    }

    @Override
    public int getSnapshot() {
        return this.modelsRead;
    }

    public void mutate(List<Mutation> mutations) {
        this.mutate = true;
        if (this.mutations == null) {
            this.mutations = new ArrayList<Mutation>();
        }
        this.mutations.addAll(mutations);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readFile() {
        this.remarkLines = new ArrayList<String>();
        xyzIndex = 1;
        this.setFileRead(false);
        this.systems.add(this.activeMolecularAssembly);
        conects = new ArrayList<String>();
        links = new ArrayList<String>();
        ssbonds = new ArrayList<String>();
        structs = new ArrayList<String>();
        try {
            var6_6 = this.files.iterator();
            while (var6_6.hasNext()) {
                this.currentFile = file = (File)var6_6.next();
                if (this.mutate) {
                    chainIDs = new ArrayList<Character>();
                    try {
                        br = new BufferedReader(new FileReader(file));
                        try {
                            line = br.readLine();
                            while (line != null) {
                                line = line.replaceAll("\t", "    ");
                                identity = line;
                                if (line.length() > 6) {
                                    identity = line.substring(0, 6);
                                }
                                identity = identity.trim().toUpperCase();
                                try {
                                    record = Record.valueOf((String)identity);
                                }
                                catch (Exception e) {
                                    line = br.readLine();
                                    continue;
                                }
                                switch (record.ordinal()) {
                                    case 0: 
                                    case 1: 
                                    case 9: {
                                        c22 = line.charAt(21);
                                        idFound = false;
                                        for (Character chainID : chainIDs) {
                                            if (c22 != chainID.charValue()) continue;
                                            idFound = true;
                                            break;
                                        }
                                        if (idFound) break;
                                        chainIDs.add(Character.valueOf(c22));
                                        break;
                                    }
                                }
                                line = br.readLine();
                            }
                            for (Mutation mtn : this.mutations) {
                                if (chainIDs.contains(Character.valueOf(mtn.chainChar))) continue;
                                if (chainIDs.size() == 1) {
                                    PDBFilter.logger.warning(String.format(" Chain ID %c for mutation not found: only one chain %c found.", new Object[]{Character.valueOf(mtn.chainChar), chainIDs.getFirst()}));
                                    continue;
                                }
                                PDBFilter.logger.warning(String.format(" Chain ID %c for mutation not found: mutation will not proceed.", new Object[]{Character.valueOf(mtn.chainChar)}));
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (IOException ioException) {
                        PDBFilter.logger.fine(String.format(" Exception %s in parsing file to find chain IDs", new Object[]{ioException}));
                    }
                }
                if (this.currentFile == null) return false;
                if (this.currentFile.exists() == false) return false;
                if (!this.currentFile.canRead()) {
                    return false;
                }
                try {
                    br = new BufferedReader(new FileReader(this.currentFile));
                    try {
                        if (this.currentAltLoc.charValue() == 'A') {
                            PDBFilter.logger.info(String.format(" Reading %s", new Object[]{this.currentFile.getName()}));
                        } else {
                            PDBFilter.logger.info(String.format(" Reading %s alternate location %s", new Object[]{this.currentFile.getName(), this.currentAltLoc}));
                        }
                        this.activeMolecularAssembly.setAlternateLocation(this.currentAltLoc);
                        this.currentChainID = null;
                        this.currentSegID = null;
                        containsInsCode = false;
                        line = br.readLine();
                        block50: while (line != null) {
                            line = line.replaceAll("\t", "    ");
                            identity = line;
                            if (line.length() > 6) {
                                identity = line.substring(0, 6);
                            }
                            identity = identity.trim().toUpperCase();
                            try {
                                record = Record.valueOf((String)identity);
                            }
                            catch (Exception e) {
                                line = br.readLine();
                                continue;
                            }
                            switch (record.ordinal()) {
                                case 5: 
                                case 7: {
                                    line = null;
                                    continue block50;
                                }
                                case 4: {
                                    chainID = Character.valueOf(line.substring(12, 13).toUpperCase().charAt(0));
                                    seqBegin = Integer.parseInt(line.substring(14, 18).trim());
                                    seqEnd = Integer.parseInt(line.substring(20, 24).trim());
                                    seqRange = this.dbRef.computeIfAbsent(chainID, (Function<Character, int[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$readFile$0(java.lang.Character ), (Ljava/lang/Character;)[I)());
                                    seqRange[0] = seqBegin;
                                    seqRange[1] = seqEnd;
                                    break;
                                }
                                case 15: {
                                    this.activeMolecularAssembly.addHeaderLine(line);
                                    chainID = Character.valueOf(line.substring(11, 12).toUpperCase().charAt(0));
                                    serNum = Integer.parseInt(line.substring(7, 10).trim());
                                    chain = this.seqRes.get(chainID);
                                    numRes = Integer.parseInt(line.substring(13, 17).trim());
                                    if (chain == null) {
                                        chain = new String[numRes];
                                        this.seqRes.put(chainID, chain);
                                    }
                                    resID = (serNum - 1) * 13;
                                    end = line.length();
                                    start = 19;
                                    while (start + 3 <= end && !(res = line.substring(start, start + 3).trim()).isEmpty()) {
                                        chain[resID++] = res;
                                        start += 4;
                                    }
                                    break;
                                }
                                case 14: {
                                    modResName = line.substring(12, 15).trim();
                                    stdName = line.substring(24, 27).trim();
                                    this.modRes.put(modResName.toUpperCase(), stdName.toUpperCase());
                                    this.activeMolecularAssembly.addHeaderLine(line);
                                    break;
                                }
                                case 0: {
                                    deleteAnisou = this.properties.getBoolean("delete-anisou", false);
                                    resetBfactors = this.properties.getDouble("reset-bfactors", -1.0);
                                    if (deleteAnisou || resetBfactors >= 0.0) break;
                                    serial = Hybrid36.decode((int)5, (String)line.substring(6, 11));
                                    altLoc = Character.valueOf(line.substring(16, 17).toUpperCase().charAt(0));
                                    if (!this.altLocs.contains(altLoc)) {
                                        this.altLocs.add(altLoc);
                                    }
                                    if (!altLoc.equals(Character.valueOf(' ')) && !altLoc.equals(Character.valueOf('A')) && !altLoc.equals(this.currentAltLoc)) break;
                                    adp = new double[]{(double)Integer.parseInt(line.substring(28, 35).trim()) * 1.0E-4, (double)Integer.parseInt(line.substring(35, 42).trim()) * 1.0E-4, (double)Integer.parseInt(line.substring(42, 49).trim()) * 1.0E-4, (double)Integer.parseInt(line.substring(49, 56).trim()) * 1.0E-4, (double)Integer.parseInt(line.substring(56, 63).trim()) * 1.0E-4, (double)Integer.parseInt(line.substring(63, 70).trim()) * 1.0E-4};
                                    if (this.atoms.containsKey(serial)) {
                                        a = this.atoms.get(serial);
                                        a.setAltLoc(altLoc);
                                        a.setAnisou(adp);
                                        break;
                                    }
                                    PDBFilter.logger.info(String.format(" No ATOM record for ANISOU serial number %d has been found.", new Object[]{serial}));
                                    PDBFilter.logger.info(String.format(" This ANISOU record will be ignored:\n %s", new Object[]{line}));
                                    break;
                                }
                                case 1: {
                                    serial = Hybrid36.decode((int)5, (String)line.substring(6, 11));
                                    name = line.substring(12, 16).trim();
                                    if (name.toUpperCase().contains("1H") || name.toUpperCase().contains("2H") || name.toUpperCase().contains("3H")) {
                                        this.fileStandard = PDBFileStandard.VERSION3_2;
                                    }
                                    if (!this.altLocs.contains(altLoc = Character.valueOf(line.substring(16, 17).toUpperCase().charAt(0)))) {
                                        this.altLocs.add(altLoc);
                                    }
                                    if (!altLoc.equals(Character.valueOf(' ')) && !altLoc.equals(Character.valueOf('A')) && !altLoc.equals(this.currentAltLoc)) break;
                                    resName = line.substring(17, 20).trim();
                                    chainID = Character.valueOf(line.substring(21, 22).charAt(0));
                                    segID = this.getSegID(chainID);
                                    resSeq = Hybrid36.decode((int)4, (String)line.substring(22, 26));
                                    insertionCode = line.charAt(26);
                                    if (insertionCode != ' ' && !containsInsCode) {
                                        containsInsCode = true;
                                        PDBFilter.logger.warning(" FFX support for files with insertion codes is experimental. Residues will be renumbered to eliminate insertion codes (52A becomes 53, 53 becomes 54, etc)");
                                    }
                                    offset = this.insertionCodeCount.getOrDefault(chainID, 0);
                                    pdbResNum = String.format("%c%d%c", new Object[]{chainID, resSeq, Character.valueOf(insertionCode)});
                                    if (!this.pdbToNewResMap.containsKey(pdbResNum)) {
                                        if (insertionCode != ' ') {
                                            this.insertionCodeCount.put(chainID, ++offset);
                                        }
                                        resSeq += offset;
                                        if (offset != 0) {
                                            PDBFilter.logger.info(String.format(" Chain %c residue %s-%s renumbered to %c %s-%d", new Object[]{chainID, pdbResNum.substring(1).trim(), resName, chainID, resName, resSeq}));
                                        }
                                        newNum = String.format("%c%d", new Object[]{chainID, resSeq});
                                        this.pdbToNewResMap.put(pdbResNum, newNum);
                                    } else {
                                        resSeq += offset;
                                    }
                                    printAtom = false;
                                    if (this.mutate) {
                                        doBreak = false;
                                        for (Mutation mtn : this.mutations) {
                                            if (chainID.charValue() != mtn.chainChar || resSeq != mtn.resID) continue;
                                            mtn.origResName = resName;
                                            resName = mtn.resName;
                                            atomName = name.toUpperCase();
                                            isAA = AminoAcidUtils.getAminoAcidNumber(resName);
                                            isNA = NucleicAcidUtils.getNucleicAcidNumber(resName);
                                            if (isNA != -1 && PDBFilter.naBackboneNames.contains(atomName) || isAA != -1 && PDBFilter.backboneNames.contains(atomName)) {
                                                printAtom = true;
                                                continue;
                                            }
                                            alchAtoms = mtn.getAlchemicalAtoms(false);
                                            if (alchAtoms == null) {
                                                newName = mtn.isNonAlchemicalAtom(atomName);
                                                if (newName != null) {
                                                    printAtom = true;
                                                    if (newName.startsWith("~")) {
                                                        name = newName.substring(1);
                                                        PDBFilter.logger.info(String.format(" DELETING atom %d %s of %s %d in chain %s", new Object[]{serial, atomName, resName, resSeq, chainID}));
                                                    } else {
                                                        name = newName;
                                                    }
                                                    doBreak = false;
                                                    break;
                                                }
                                                if (!atomName.contains("'")) {
                                                    PDBFilter.logger.info(String.format(" DELETING atom %d %s of %s %d in chain %s", new Object[]{serial, atomName, resName, resSeq, chainID}));
                                                    doBreak = true;
                                                    break;
                                                }
                                                printAtom = true;
                                                doBreak = false;
                                                break;
                                            }
                                            if (alchAtoms.contains(atomName) && !atomName.contains("'")) {
                                                PDBFilter.logger.info(String.format(" DELETING atom %d %s of %s %d in chain %s", new Object[]{serial, atomName, resName, resSeq, chainID}));
                                                doBreak = true;
                                                break;
                                            }
                                            printAtom = true;
                                            doBreak = false;
                                            break;
                                        }
                                        if (doBreak) break;
                                    }
                                    if (!this.constantPH) ** GOTO lbl229
                                    aa3 = AminoAcidUtils.getAminoAcid(resName.toUpperCase());
                                    if (!PDBFilter.constantPHResidueMap.containsKey((Object)aa3)) ** GOTO lbl232
                                    atomName = name.toUpperCase();
                                    aa3PH = PDBFilter.constantPHResidueMap.get((Object)aa3);
                                    resName = aa3PH.name();
                                    if (!PDBFilter.constantPhBackboneNames.contains(atomName)) ** GOTO lbl224
                                    PDBFilter.logger.info(String.format(" %s-%d %s", new Object[]{resName, resSeq, atomName}));
                                    ** GOTO lbl232
lbl224:
                                    // 1 sources

                                    if (!atomName.startsWith("H")) {
                                        PDBFilter.logger.info(String.format(" %s-%d %s", new Object[]{resName, resSeq, atomName}));
                                    } else {
                                        PDBFilter.logger.info(String.format(" %s-%d %s skipped", new Object[]{resName, resSeq, atomName}));
                                        break;
                                    }
lbl229:
                                    // 1 sources

                                    if (this.rotamerTitration && PDBFilter.rotamerResidueMap.containsKey((Object)(aa3 = AminoAcidUtils.getAminoAcid(resName.toUpperCase()))) && this.resNumberList.contains(resSeq)) {
                                        aa3rotamer = PDBFilter.rotamerResidueMap.get((Object)aa3);
                                        resName = aa3rotamer.name();
                                    }
lbl232:
                                    // 6 sources

                                    d = new double[]{Double.parseDouble(line.substring(30, 38).trim()), Double.parseDouble(line.substring(38, 46).trim()), Double.parseDouble(line.substring(46, 54).trim())};
                                    occupancy = 1.0;
                                    tempFactor = 1.0;
                                    try {
                                        occupancy = Double.parseDouble(line.substring(54, 60).trim());
                                        tempFactor = Double.parseDouble(line.substring(60, 66).trim());
                                    }
                                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                                        if (this.printMissingFields) {
                                            PDBFilter.logger.info(" Missing occupancy and b-factors set to 1.0.");
                                            this.printMissingFields = false;
                                        }
                                        if (!PDBFilter.logger.isLoggable(Level.FINE)) ** GOTO lbl246
                                        PDBFilter.logger.fine(" Missing occupancy and b-factors set to 1.0.");
                                    }
lbl246:
                                    // 4 sources

                                    bfactor = this.properties.getDouble("reset-bfactors", -1.0);
                                    if (bfactor >= 0.0) {
                                        tempFactor = bfactor;
                                    }
                                    newAtom = new Atom(0, name, altLoc, d, resName, resSeq, chainID, occupancy, tempFactor, segID);
                                    if (this.modRes.containsKey(resName.toUpperCase())) {
                                        newAtom.setModRes(true);
                                    }
                                    if ((returnedAtom = (Atom)this.activeMolecularAssembly.addMSNode(newAtom)) != newAtom) {
                                        this.atoms.put(serial, returnedAtom);
                                        if (!PDBFilter.logger.isLoggable(Level.FINE)) break;
                                        PDBFilter.logger.fine(String.valueOf(returnedAtom) + " has been retained over\n" + String.valueOf(newAtom));
                                        break;
                                    }
                                    this.atoms.put(serial, newAtom);
                                    if (newAtom.getIndex() == 0) {
                                        newAtom.setXyzIndex(xyzIndex++);
                                    }
                                    if (!printAtom) break;
                                    PDBFilter.logger.info(newAtom.toString());
                                    break;
                                }
                                case 9: {
                                    serial = Hybrid36.decode((int)5, (String)line.substring(6, 11));
                                    name = line.substring(12, 16).trim();
                                    altLoc = Character.valueOf(line.substring(16, 17).toUpperCase().charAt(0));
                                    if (!this.altLocs.contains(altLoc)) {
                                        this.altLocs.add(altLoc);
                                    }
                                    if (!altLoc.equals(Character.valueOf(' ')) && !altLoc.equals(this.currentAltLoc)) break;
                                    resName = line.substring(17, 20).trim();
                                    chainID = Character.valueOf(line.substring(21, 22).charAt(0));
                                    segID = this.getSegID(chainID);
                                    resSeq = Hybrid36.decode((int)4, (String)line.substring(22, 26));
                                    insertionCode = line.charAt(26);
                                    if (insertionCode != ' ' && !containsInsCode) {
                                        containsInsCode = true;
                                        PDBFilter.logger.warning(" FFX support for files with insertion codes is experimental. Residues will be renumbered to eliminate insertion codes (52A becomes 53, 53 becomes 54, etc)");
                                    }
                                    offset = this.insertionCodeCount.getOrDefault(chainID, 0);
                                    pdbResNum = String.format("%c%d%c", new Object[]{chainID, resSeq, Character.valueOf(insertionCode)});
                                    if (!this.pdbToNewResMap.containsKey(pdbResNum)) {
                                        if (insertionCode != ' ') {
                                            this.insertionCodeCount.put(chainID, ++offset);
                                        }
                                        resSeq += offset;
                                        if (offset != 0) {
                                            PDBFilter.logger.info(String.format(" Chain %c molecule %s-%s renumbered to %c %s-%d", new Object[]{chainID, pdbResNum.substring(1).trim(), resName, chainID, resName, resSeq}));
                                        }
                                        newNum = String.format("%c%d", new Object[]{chainID, resSeq});
                                        this.pdbToNewResMap.put(pdbResNum, newNum);
                                    } else {
                                        resSeq += offset;
                                    }
                                    d = new double[]{Double.parseDouble(line.substring(30, 38).trim()), Double.parseDouble(line.substring(38, 46).trim()), Double.parseDouble(line.substring(46, 54).trim())};
                                    occupancy = 1.0;
                                    tempFactor = 1.0;
                                    try {
                                        occupancy = Double.parseDouble(line.substring(54, 60).trim());
                                        tempFactor = Double.parseDouble(line.substring(60, 66).trim());
                                    }
                                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                                        if (this.printMissingFields) {
                                            PDBFilter.logger.info(" Missing occupancy and b-factors set to 1.0.");
                                            this.printMissingFields = false;
                                        }
                                        if (!PDBFilter.logger.isLoggable(Level.FINE)) ** GOTO lbl309
                                        PDBFilter.logger.fine(" Missing occupancy and b-factors set to 1.0.");
                                    }
lbl309:
                                    // 4 sources

                                    bfactor = this.properties.getDouble("reset-bfactors", -1.0);
                                    if (bfactor >= 0.0) {
                                        tempFactor = bfactor;
                                    }
                                    newAtom = new Atom(0, name, altLoc, d, resName, resSeq, chainID, occupancy, tempFactor, segID);
                                    newAtom.setHetero(true);
                                    if (this.modRes.containsKey(resName.toUpperCase())) {
                                        newAtom.setModRes(true);
                                    }
                                    if ((returnedAtom = (Atom)this.activeMolecularAssembly.addMSNode(newAtom)) != newAtom) {
                                        this.atoms.put(serial, returnedAtom);
                                        if (!PDBFilter.logger.isLoggable(Level.FINE)) break;
                                        PDBFilter.logger.fine(String.valueOf(returnedAtom) + " has been retained over\n" + String.valueOf(newAtom));
                                        break;
                                    }
                                    this.atoms.put(serial, newAtom);
                                    newAtom.setXyzIndex(xyzIndex++);
                                    break;
                                }
                                case 3: {
                                    if (line.length() < 55) {
                                        PDBFilter.logger.severe(" CRYST1 record is improperly formatted.");
                                    }
                                    aaxis = Double.parseDouble(line.substring(6, 15).trim());
                                    baxis = Double.parseDouble(line.substring(15, 24).trim());
                                    caxis = Double.parseDouble(line.substring(24, 33).trim());
                                    alpha = Double.parseDouble(line.substring(33, 40).trim());
                                    beta = Double.parseDouble(line.substring(40, 47).trim());
                                    gamma = Double.parseDouble(line.substring(47, 54).trim());
                                    limit = FastMath.min((int)line.length(), (int)66);
                                    sg = line.substring(55, limit).trim();
                                    this.properties.addProperty("a-axis", (Object)aaxis);
                                    this.properties.addProperty("b-axis", (Object)baxis);
                                    this.properties.addProperty("c-axis", (Object)caxis);
                                    this.properties.addProperty("alpha", (Object)alpha);
                                    this.properties.addProperty("beta", (Object)beta);
                                    this.properties.addProperty("gamma", (Object)gamma);
                                    this.properties.addProperty("spacegroup", (Object)SpaceGroupInfo.pdb2ShortName((String)sg));
                                    break;
                                }
                                case 2: {
                                    conects.add(line);
                                    break;
                                }
                                case 10: {
                                    a1 = line.charAt(16);
                                    a2 = line.charAt(46);
                                    if (a1 != a2) break;
                                    if (this.currentAltLoc.charValue() == 'A') {
                                        if (a1 != ' ' && a1 != 'A' || a2 != ' ' && a2 != 'A') break;
                                        links.add(line);
                                        break;
                                    }
                                    if (a1 != this.currentAltLoc.charValue() || a2 != this.currentAltLoc.charValue()) break;
                                    links.add(line);
                                    break;
                                }
                                case 17: {
                                    ssbonds.add(line);
                                    break;
                                }
                                case 8: 
                                case 16: {
                                    structs.add(line);
                                    break;
                                }
                                case 6: {
                                    break;
                                }
                                case 11: {
                                    MTRX1 = new StringBuilder(line.substring(11, 55));
                                    this.properties.addProperty("MTRIX1", (Object)MTRX1);
                                    break;
                                }
                                case 12: {
                                    MTRX2 = new StringBuilder(line.substring(11, 55));
                                    this.properties.addProperty("MTRIX2", (Object)MTRX2);
                                    break;
                                }
                                case 13: {
                                    MTRX3 = new StringBuilder(line.substring(11, 55));
                                    this.properties.addProperty("MTRIX3", (Object)MTRX3);
                                    break;
                                }
                                case 18: {
                                    this.remarkLines.add(line.trim());
                                    if (line.contains("Lambda:") && (m = PDBFilter.lambdaPattern.matcher(line)).find()) {
                                        this.lastReadLambda = Double.parseDouble(m.group(1));
                                    }
                                    if (line.length() < 68 || !(remarkType = line.substring(7, 10).trim()).matches("\\d+") || Integer.parseInt(remarkType) != 350 || !line.substring(13, 18).equalsIgnoreCase("BIOMT")) break;
                                    this.properties.addProperty("BIOMTn", (Object)new StringBuilder(line.substring(24, 68)));
                                    break;
                                }
                            }
                            line = br.readLine();
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    PDBFilter.logger.log(Level.SEVERE, " PDB file not found", fileNotFoundException);
                }
            }
            --xyzIndex;
            this.setFileRead(true);
        }
        catch (IOException e) {
            PDBFilter.logger.exiting(PDBFilter.class.getName(), "readFile", e);
            return false;
        }
        ssBondList = PolymerUtils.locateDisulfideBonds(ssbonds, this.activeMolecularAssembly, this.pdbToNewResMap);
        pdbAtoms = this.activeMolecularAssembly.getAtomArray().length;
        this.removeInappropriateHydrogen();
        PolymerUtils.buildMissingResidues(xyzIndex, this.activeMolecularAssembly, this.seqRes, this.dbRef);
        this.bondList = PolymerUtils.assignAtomTypes(this.activeMolecularAssembly, this.fileStandard);
        PolymerUtils.buildDisulfideBonds(ssBondList, this.activeMolecularAssembly, this.bondList);
        currentN = this.activeMolecularAssembly.getAtomArray().length;
        renumber = this.forceField.getBoolean("renumber-pdb", false);
        if (pdbAtoms != currentN) {
            PDBFilter.logger.info(String.format(" Renumbering PDB file due to built atoms (%d vs %d)", new Object[]{currentN, pdbAtoms}));
            BondedUtils.numberAtoms(this.activeMolecularAssembly);
            return true;
        }
        if (renumber == false) return true;
        PDBFilter.logger.info(" Renumbering PDB file due to renumber-pdb flag.");
        BondedUtils.numberAtoms(this.activeMolecularAssembly);
        return true;
    }

    public void removeInappropriateHydrogen() {
        StringBuilder sb = new StringBuilder();
        int numRemoved = 0;
        for (Residue residue : this.activeMolecularAssembly.getResidueList()) {
            String trueResName;
            if (residue.getName().equals("ACE") || residue.getName().equals("NME") || residue.getResidueType() != Residue.ResidueType.AA) continue;
            Atom atom = switch (trueResName = residue.getAtomByName("CA", true).getResidueName()) {
                case "HID", "GLU" -> residue.getAtomByName("HE2", true);
                case "HIE" -> residue.getAtomByName("HD1", true);
                case "ASP" -> residue.getAtomByName("HD2", true);
                case "LYD" -> residue.getAtomByName("HZ3", true);
                case "CYD" -> residue.getAtomByName("HG", true);
                default -> null;
            };
            if (atom == null) continue;
            MSNode atoms = residue.getAtomNode();
            atoms.remove(atom);
            residue.setName(trueResName);
            sb.append(" Removed ").append(atom);
            ++numRemoved;
        }
        if (numRemoved > 0) {
            logger.info(String.format(" Removed %d Inappropriate Hydrogen", numRemoved));
            logger.info(sb.toString());
        }
    }

    @Override
    public boolean readNext() {
        return this.readNext(false);
    }

    @Override
    public boolean readNext(boolean resetPosition) {
        return this.readNext(resetPosition, false);
    }

    @Override
    public boolean readNext(boolean resetPosition, boolean print) {
        return this.readNext(resetPosition, print, true);
    }

    @Override
    public boolean readNext(boolean resetPosition, boolean print, boolean parse) {
        int n = this.modelsRead = resetPosition ? 1 : this.modelsRead + 1;
        if (!parse) {
            if (print) {
                logger.info(String.format(" Skipped Model %d.", this.modelsRead));
            }
            return true;
        }
        this.remarkLines = new ArrayList<String>(this.remarkLines.size());
        Pattern modelPatt = Pattern.compile("^MODEL\\s+(\\d+)");
        boolean eof = true;
        for (MolecularAssembly system : this.systems) {
            try {
                BufferedReader currentReader;
                if (this.readers.containsKey(system)) {
                    currentReader = this.readers.get(system);
                    try {
                        if (!currentReader.ready()) {
                            currentReader = new BufferedReader(new FileReader(this.readFile));
                            currentReader.mark(0);
                            this.readers.remove(system);
                            this.readers.put(system, currentReader);
                        } else if (resetPosition) {
                            currentReader.reset();
                        }
                    }
                    catch (Exception exception) {
                        currentReader = new BufferedReader(new FileReader(this.readFile));
                        currentReader.mark(0);
                        this.readers.remove(system);
                        this.readers.put(system, currentReader);
                    }
                } else {
                    currentReader = new BufferedReader(new FileReader(this.readFile));
                    currentReader.mark(0);
                    this.readers.put(system, currentReader);
                }
                String line = currentReader.readLine();
                while (line != null) {
                    int modelNum;
                    Matcher m = modelPatt.matcher(line = line.trim());
                    if (m.find() && (modelNum = Integer.parseInt(m.group(1))) == this.modelsRead) {
                        if (print) {
                            logger.log(Level.INFO, String.format(" Reading model %d for %s", modelNum, this.currentFile));
                        }
                        eof = false;
                        break;
                    }
                    line = currentReader.readLine();
                }
                if (eof) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, String.format("\n End of file reached for %s", this.readFile));
                    }
                    currentReader.close();
                    return false;
                }
                this.currentChainID = null;
                this.currentSegID = null;
                boolean modelDone = false;
                line = currentReader.readLine();
                while (line != null) {
                    line = line.trim();
                    String recID = line.substring(0, Math.min(6, line.length())).trim();
                    try {
                        Record record = Record.valueOf(recID);
                        boolean hetatm = true;
                        switch (record.ordinal()) {
                            case 1: {
                                hetatm = false;
                            }
                            case 9: {
                                Atom returnedAtom;
                                Character altLoc;
                                String name = line.substring(12, 16).trim();
                                if (name.toUpperCase().contains("1H") || name.toUpperCase().contains("2H") || name.toUpperCase().contains("3H")) {
                                    this.fileStandard = PDBFileStandard.VERSION3_2;
                                }
                                if (!(altLoc = Character.valueOf(line.substring(16, 17).toUpperCase().charAt(0))).equals(Character.valueOf(' ')) && !altLoc.equals(this.currentAltLoc)) break;
                                String resName = line.substring(17, 20).trim();
                                Character chainID = Character.valueOf(line.substring(21, 22).charAt(0));
                                String segID = this.getExistingSegID(chainID);
                                int resSeq = Hybrid36.decode((int)4, (String)line.substring(22, 26));
                                double[] d = new double[]{Double.parseDouble(line.substring(30, 38).trim()), Double.parseDouble(line.substring(38, 46).trim()), Double.parseDouble(line.substring(46, 54).trim())};
                                double occupancy = 1.0;
                                double tempFactor = 1.0;
                                Atom newAtom = new Atom(0, name, altLoc, d, resName, resSeq, chainID, occupancy, tempFactor, segID);
                                newAtom.setHetero(hetatm);
                                if (this.modRes.containsKey(resName.toUpperCase())) {
                                    newAtom.setModRes(true);
                                }
                                if ((returnedAtom = this.activeMolecularAssembly.findAtom(newAtom)) != null) {
                                    returnedAtom.setXYZ(d);
                                    double[] retXYZ = new double[3];
                                    returnedAtom.getXYZ(retXYZ);
                                    break;
                                }
                                String message = String.format(" Could not find atom %s in assembly", newAtom);
                                if (this.dieOnMissingAtom) {
                                    logger.severe(message);
                                    break;
                                }
                                logger.warning(message);
                                break;
                            }
                            case 3: {
                                logger.fine(" Crystal record found.");
                                if (line.length() < 55) {
                                    logger.severe(" CRYST1 record is improperly formatted.");
                                }
                                double aaxis = Double.parseDouble(line.substring(6, 15).trim());
                                double baxis = Double.parseDouble(line.substring(15, 24).trim());
                                double caxis = Double.parseDouble(line.substring(24, 33).trim());
                                double alpha = Double.parseDouble(line.substring(33, 40).trim());
                                double beta = Double.parseDouble(line.substring(40, 47).trim());
                                double gamma = Double.parseDouble(line.substring(47, 54).trim());
                                int limit = FastMath.min((int)line.length(), (int)66);
                                String sg = line.substring(55, limit).trim();
                                Crystal crystal = this.activeMolecularAssembly.getCrystal();
                                SpaceGroup spaceGroup = SpaceGroupDefinitions.spaceGroupFactory((String)sg);
                                if (Objects.equals(crystal.spaceGroup.shortName, spaceGroup.shortName)) {
                                    crystal.changeUnitCellParameters(aaxis, baxis, caxis, alpha, beta, gamma);
                                    break;
                                }
                                logger.warning(String.format(" Original space group %s could not be changed to %s", crystal.spaceGroup.shortName, spaceGroup.shortName));
                                break;
                            }
                            case 5: 
                            case 7: {
                                logger.log(Level.FINE, String.format(" Model %d successfully read", this.modelsRead));
                                modelDone = true;
                                break;
                            }
                            case 18: {
                                this.remarkLines.add(line.trim());
                                if (!line.contains("Lambda:")) break;
                                Matcher m = lambdaPattern.matcher(line);
                                if (m.find()) {
                                    this.lastReadLambda = Double.parseDouble(m.group(1));
                                }
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (modelDone) break;
                    line = currentReader.readLine();
                }
                return true;
            }
            catch (IOException ex) {
                logger.info(String.format(" Exception in parsing frame %d of %s: %s", this.modelsRead, system.toString(), ex));
            }
        }
        return false;
    }

    public void setAltID(MolecularAssembly molecularAssembly, Character altLoc) {
        this.setMolecularSystem(molecularAssembly);
        this.currentAltLoc = altLoc;
    }

    public void setLogWrites(boolean logWrites) {
        this.logWrites = logWrites;
    }

    public void setModelNumbering(int modelsWritten) {
        this.modelsWritten = modelsWritten;
    }

    public void setLMN(int[] lmn) {
        this.lmn = lmn[0] >= 1 && lmn[1] >= 1 && lmn[2] >= 1 ? lmn : new int[]{1, 1, 1};
    }

    public void setSymOp(int symOp) {
        this.nSymOp = symOp;
    }

    public boolean writeFileAsP1(File file) {
        int l = this.lmn[0];
        int m = this.lmn[1];
        int n = this.lmn[2];
        Crystal crystal = this.activeMolecularAssembly.getCrystal();
        int nSymOps = crystal.getUnitCell().spaceGroup.getNumberOfSymOps();
        if (nSymOps == 1 && l <= 1 && m <= 1 && n <= 1) {
            if (!this.writeFile(file, false)) {
                logger.info(String.format(" Save failed for %s", this.activeMolecularAssembly));
                return false;
            }
            return true;
        }
        Polymer[] polymers = this.activeMolecularAssembly.getChains();
        int chainCount = 0;
        for (Polymer polymer : polymers) {
            Character chainID = Character.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz".charAt(chainCount++));
            polymer.setChainID(chainID);
            polymer.setSegID(chainID.toString());
        }
        this.nSymOp = 0;
        this.logWrites = false;
        boolean writeEnd = false;
        if (!this.writeFile(file, false, false, writeEnd)) {
            logger.info(String.format(" Save failed for %s", this.activeMolecularAssembly));
            return false;
        }
        for (int i = 0; i < l; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < n; ++k) {
                    this.lValue = i;
                    this.mValue = j;
                    this.nValue = k;
                    for (int iSym = 0; iSym < nSymOps; ++iSym) {
                        this.nSymOp = iSym;
                        for (Polymer polymer : polymers) {
                            Character chainID = Character.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz".charAt(chainCount++));
                            polymer.setChainID(chainID);
                            polymer.setSegID(chainID.toString());
                        }
                        boolean bl = writeEnd = iSym == nSymOps - 1 && i == l - 1 && j == m - 1 && k == n - 1;
                        if (this.writeFile(file, true, false, writeEnd)) continue;
                        logger.info(String.format(" Save failed for %s", this.activeMolecularAssembly));
                        return false;
                    }
                }
            }
        }
        chainCount = 0;
        for (Polymer polymer : polymers) {
            Character chainID = Character.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz".charAt(chainCount++));
            polymer.setChainID(chainID);
            polymer.setSegID(chainID.toString());
        }
        return true;
    }

    public boolean writeFile(File saveFile, boolean append, boolean printLinear, boolean writeEnd) {
        return this.writeFile(saveFile, append, Collections.emptySet(), writeEnd, true);
    }

    public boolean writeFile(File saveFile, boolean append, Set<Atom> toExclude, boolean writeEnd, boolean versioning) {
        return this.writeFile(saveFile, append, toExclude, writeEnd, versioning, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeFile(File saveFile, boolean append, Set<Atom> toExclude, boolean writeEnd, boolean versioning, String[] extraLines) {
        Set<Object> atomExclusions;
        if (this.standardizeAtomNames) {
            String name;
            logger.info(" Setting atom names to PDB standard.");
            ArrayList<Atom> deuteriumAtoms = new ArrayList<Atom>();
            for (Atom atom : this.activeMolecularAssembly.getAtomArray()) {
                if (!atom.getName().startsWith("D")) continue;
                name = atom.getName().replaceFirst("D", "H");
                atom.setName(name);
                deuteriumAtoms.add(atom);
            }
            NamingUtils.renameAtomsToPDBStandard(this.activeMolecularAssembly);
            for (Atom atom : this.activeMolecularAssembly.getAtomArray()) {
                if (!deuteriumAtoms.contains(atom) || !atom.getName().startsWith("H")) continue;
                name = atom.getName().replaceFirst("H", "D");
                atom.setName(name);
            }
        }
        Set<Object> set = atomExclusions = toExclude == null ? Collections.emptySet() : toExclude;
        if (saveFile == null) {
            return false;
        }
        if (this.vdwH) {
            logger.info(" Saving hydrogen to van der Waals centers instead of nuclear locations.");
        }
        if (this.nSymOp > -1) {
            logger.info(String.format(" Saving atoms using the symmetry operator:\n%s\n", this.activeMolecularAssembly.getCrystal().getUnitCell().spaceGroup.getSymOp(this.nSymOp).toString()));
        }
        StringBuilder sb = new StringBuilder("ATOM  ");
        StringBuilder anisouSB = new StringBuilder("ANISOU");
        StringBuilder terSB = new StringBuilder("TER   ");
        StringBuilder model = null;
        for (int i = 6; i < 80; ++i) {
            sb.append(' ');
            anisouSB.append(' ');
            terSB.append(' ');
        }
        File newFile = saveFile;
        if (!append) {
            if (versioning) {
                newFile = PDBFilter.version(saveFile);
            }
        } else if (this.modelsWritten >= 0) {
            model = new StringBuilder(String.format("MODEL     %-4d", ++this.modelsWritten));
            model.append(org.apache.commons.lang3.StringUtils.repeat((String)" ", (int)65));
        }
        this.activeMolecularAssembly.setFile(newFile);
        if (this.activeMolecularAssembly.getName() == null) {
            this.activeMolecularAssembly.setName(newFile.getName());
        }
        if (this.logWrites) {
            logger.log(Level.INFO, " Saving {0}", newFile.getName());
        }
        try (FileWriter fw = new FileWriter(newFile, append);
             BufferedWriter bw = new BufferedWriter(fw);){
            Character altLoc;
            Crystal crystal;
            String[] headerLines;
            for (String line : headerLines = this.activeMolecularAssembly.getHeaderLines()) {
                bw.write(String.format("%s\n", line));
            }
            if (extraLines != null) {
                if (this.rotamerTitration && extraLines[0].contains("REMARK")) {
                    for (String line : extraLines) {
                        bw.write(line + "\n");
                    }
                } else {
                    for (String line : extraLines) {
                        bw.write(String.format("REMARK 999 %s\n", line));
                    }
                }
            }
            if (model != null) {
                bw.write(model.toString());
                bw.newLine();
            }
            if (this.nSymOp < 0) {
                crystal = this.activeMolecularAssembly.getCrystal();
                if (crystal != null && !crystal.aperiodic()) {
                    Crystal c = crystal.getUnitCell();
                    if (this.lmn[0] > 0 || this.lmn[1] > 0 || this.lmn[2] > 0) {
                        c.a *= (double)this.lmn[0];
                        c.b *= (double)this.lmn[1];
                        c.c *= (double)this.lmn[2];
                    }
                    bw.write(c.toCRYST1());
                }
            } else if (this.nSymOp == 0 && (crystal = this.activeMolecularAssembly.getCrystal()) != null && !crystal.aperiodic()) {
                Crystal c = crystal.getUnitCell();
                Crystal p1 = new Crystal(this.lmn[0] > 0 ? c.a * (double)this.lmn[0] : c.a, this.lmn[1] > 0 ? c.b * (double)this.lmn[1] : c.b, this.lmn[2] > 0 ? c.c * (double)this.lmn[2] : c.c, c.alpha, c.beta, c.gamma, "P1");
                bw.write(p1.toCRYST1());
            }
            int serNum = 1;
            Polymer[] polymers = this.activeMolecularAssembly.getChains();
            if (polymers != null) {
                for (Polymer polymer : polymers) {
                    List<Residue> residues = polymer.getResidues();
                    for (Residue residue : residues) {
                        if (!residue.getName().equalsIgnoreCase("CYS")) continue;
                        List<Atom> cysAtoms = residue.getAtomList().stream().filter(a -> !atomExclusions.contains(a)).toList();
                        Object SG1 = null;
                        Iterator<Atom> iterator = cysAtoms.iterator();
                        while (iterator.hasNext()) {
                            Atom atom = iterator.next();
                            String atName = atom.getName().toUpperCase();
                            if (!atName.equals("SG") && !atName.equals("SH") && atom.getAtomType().atomicNumber != 16) continue;
                            SG1 = atom;
                            break;
                        }
                        List<Bond> bonds = ((Atom)SG1).getBonds();
                        for (Bond bond : bonds) {
                            Atom atom = bond.get1_2((Atom)SG1);
                            if (atom.getAtomType().atomicNumber != 16 || atomExclusions.contains(atom) || ((Atom)SG1).getIndex() >= atom.getIndex()) continue;
                            bond.energy(false);
                            bw.write(String.format("SSBOND %3d CYS %1s %4s    CYS %1s %4s %36s %5.2f\n", serNum++, ((Atom)SG1).getChainID().toString(), Hybrid36.encode((int)4, (int)((Atom)SG1).getResidueNumber()), atom.getChainID().toString(), Hybrid36.encode((int)4, (int)atom.getResidueNumber()), "", bond.getValue()));
                        }
                    }
                }
            }
            MolecularAssembly[] molecularAssemblies = this.getMolecularAssemblyArray();
            int serial = 1;
            if (this.nSymOp > 0) {
                serial = this.serialP1;
            }
            if (polymers != null) {
                for (Polymer polymer : polymers) {
                    this.currentSegID = polymer.getName();
                    this.currentChainID = polymer.getChainID();
                    sb.setCharAt(21, this.currentChainID.charValue());
                    List<Residue> residues = polymer.getResidues();
                    for (Residue residue : residues) {
                        void var31_88;
                        String resName = residue.getName();
                        if (resName.length() > 3) {
                            resName = resName.substring(0, 3);
                        }
                        int resID = residue.getResidueNumber();
                        sb.replace(17, 20, StringUtils.padLeft((String)resName.toUpperCase(), (int)3));
                        sb.replace(22, 26, String.format("%4s", Hybrid36.encode((int)4, (int)resID)));
                        List<Object> residueAtoms = residue.getAtomList().stream().filter(a -> !atomExclusions.contains(a)).collect(Collectors.toList());
                        boolean bl = false;
                        for (Atom atom : residueAtoms) {
                            if (this.mutate) {
                                for (Mutation mutation : this.mutations) {
                                    if (resID != mutation.resID || this.currentChainID.charValue() != mutation.chainChar) continue;
                                    mutation.addTors(atom, serial);
                                    ArrayList<String> arrayList = mutation.getAlchemicalAtoms(true);
                                    if (arrayList != null) {
                                        if (!residue.getBackboneAtoms().contains(atom) || !arrayList.contains(atom.getName())) continue;
                                        logger.info(String.format(" MUTATION atom is %d chain %s", serial, this.currentChainID));
                                        continue;
                                    }
                                    if (!residue.getBackboneAtoms().contains(atom)) continue;
                                    logger.info(String.format(" MUTATION atom is %d chain %s", serial, this.currentChainID));
                                }
                            }
                            this.writeAtom(atom, serial++, sb, anisouSB, bw);
                            altLoc = atom.getAltLoc();
                            if (altLoc == null || altLoc.equals(Character.valueOf(' '))) continue;
                            bl = true;
                        }
                        if (!bl) continue;
                        boolean bl2 = true;
                        while (var31_88 < molecularAssemblies.length) {
                            void var34_114;
                            MolecularAssembly molecularAssembly = molecularAssemblies[var31_88];
                            Polymer altPolymer = molecularAssembly.getPolymer(this.currentChainID, this.currentSegID, false);
                            Residue residue2 = altPolymer.getResidue(resName, resID, false, Residue.ResidueType.AA);
                            if (residue2 == null) {
                                resName = AminoAcidUtils.AminoAcid3.UNK.name();
                                Residue residue3 = altPolymer.getResidue(resName, resID, false, Residue.ResidueType.AA);
                            }
                            residueAtoms = var34_114.getAtomList().stream().filter(a -> !atomExclusions.contains(a)).toList();
                            for (Atom atom : residueAtoms) {
                                if (atom.getAltLoc() == null || atom.getAltLoc().equals(Character.valueOf(' ')) || atom.getAltLoc().equals(Character.valueOf('A'))) continue;
                                sb.replace(17, 20, StringUtils.padLeft((String)atom.getResidueName().toUpperCase(), (int)3));
                                this.writeAtom(atom, serial++, sb, anisouSB, bw);
                            }
                            ++var31_88;
                        }
                    }
                    terSB.replace(6, 11, String.format("%5s", Hybrid36.encode((int)5, (int)serial++)));
                    terSB.replace(12, 16, "    ");
                    terSB.replace(16, 26, sb.substring(16, 26));
                    bw.write(terSB.toString());
                    bw.newLine();
                }
            }
            sb.replace(0, 6, "HETATM");
            sb.setCharAt(21, 'A');
            Character chainID = Character.valueOf('A');
            if (polymers != null) {
                chainID = polymers[0].getChainID();
            }
            this.activeMolecularAssembly.setChainIDAndRenumberMolecules(chainID);
            List<MSNode> molecules = this.activeMolecularAssembly.getMolecules();
            int numMolecules = molecules.size();
            for (int i = 0; i < numMolecules; ++i) {
                Molecule molecule = (Molecule)molecules.get(i);
                chainID = molecule.getChainID();
                sb.setCharAt(21, chainID.charValue());
                String resName = molecule.getResidueName();
                int resID = molecule.getResidueNumber();
                if (resName.length() > 3) {
                    resName = resName.substring(0, 3);
                }
                sb.replace(17, 20, StringUtils.padLeft((String)resName.toUpperCase(), (int)3));
                sb.replace(22, 26, String.format("%4s", Hybrid36.encode((int)4, (int)resID)));
                List<Object> moleculeAtoms = molecule.getAtomList().stream().filter(a -> !atomExclusions.contains(a)).collect(Collectors.toList());
                boolean altLocFound = false;
                for (Atom atom : moleculeAtoms) {
                    this.writeAtom(atom, serial++, sb, anisouSB, bw);
                    Character c = atom.getAltLoc();
                    if (c == null || c.equals(Character.valueOf(' '))) continue;
                    altLocFound = true;
                }
                if (!altLocFound) continue;
                for (int ma = 1; ma < molecularAssemblies.length; ++ma) {
                    MolecularAssembly molecularAssembly = molecularAssemblies[ma];
                    MSNode mSNode = molecularAssembly.getMolecules().get(i);
                    moleculeAtoms = mSNode.getAtomList();
                    for (Object atom : moleculeAtoms) {
                        if (((Atom)atom).getAltLoc() == null || ((Atom)atom).getAltLoc().equals(Character.valueOf(' ')) || ((Atom)atom).getAltLoc().equals(Character.valueOf('A'))) continue;
                        this.writeAtom((Atom)atom, serial++, sb, anisouSB, bw);
                    }
                }
            }
            List<MSNode> ions = this.activeMolecularAssembly.getIons();
            for (int i = 0; i < ions.size(); ++i) {
                void var30_84;
                Molecule ion = (Molecule)ions.get(i);
                chainID = ion.getChainID();
                sb.setCharAt(21, chainID.charValue());
                String resName = ion.getResidueName();
                int resID = ion.getResidueNumber();
                if (resName.length() > 3) {
                    resName = resName.substring(0, 3);
                }
                sb.replace(17, 20, StringUtils.padLeft((String)resName.toUpperCase(), (int)3));
                sb.replace(22, 26, String.format("%4s", Hybrid36.encode((int)4, (int)resID)));
                List<Object> ionAtoms = ion.getAtomList().stream().filter(a -> !atomExclusions.contains(a)).collect(Collectors.toList());
                boolean altLocFound = false;
                for (Atom atom : ionAtoms) {
                    this.writeAtom(atom, serial++, sb, anisouSB, bw);
                    Character c = atom.getAltLoc();
                    if (c == null || c.equals(Character.valueOf(' '))) continue;
                    altLocFound = true;
                }
                if (!altLocFound) continue;
                boolean bl = true;
                while (var30_84 < molecularAssemblies.length) {
                    MolecularAssembly molecularAssembly = molecularAssemblies[var30_84];
                    MSNode mSNode = molecularAssembly.getIons().get(i);
                    ionAtoms = mSNode.getAtomList();
                    for (Atom atom : ionAtoms) {
                        if (atom.getAltLoc() == null || atom.getAltLoc().equals(Character.valueOf(' ')) || atom.getAltLoc().equals(Character.valueOf('A'))) continue;
                        this.writeAtom(atom, serial++, sb, anisouSB, bw);
                    }
                    ++var30_84;
                }
            }
            List<MSNode> water = this.activeMolecularAssembly.getWater();
            for (int i = 0; i < water.size(); ++i) {
                void var31_97;
                Molecule wat = (Molecule)water.get(i);
                chainID = wat.getChainID();
                sb.setCharAt(21, chainID.charValue());
                String resName = wat.getResidueName();
                int resID = wat.getResidueNumber();
                if (resName.length() > 3) {
                    resName = resName.substring(0, 3);
                }
                sb.replace(17, 20, StringUtils.padLeft((String)resName.toUpperCase(), (int)3));
                sb.replace(22, 26, String.format("%4s", Hybrid36.encode((int)4, (int)resID)));
                List<Object> waterAtoms = wat.getAtomList().stream().filter(a -> !atomExclusions.contains(a)).collect(Collectors.toList());
                boolean bl = false;
                for (Atom atom : waterAtoms) {
                    this.writeAtom(atom, serial++, sb, anisouSB, bw);
                    altLoc = atom.getAltLoc();
                    if (altLoc == null || altLoc.equals(Character.valueOf(' '))) continue;
                    bl = true;
                }
                if (!bl) continue;
                boolean bl3 = true;
                while (var31_97 < molecularAssemblies.length) {
                    MolecularAssembly molecularAssembly = molecularAssemblies[var31_97];
                    MSNode altwater = molecularAssembly.getWater().get(i);
                    waterAtoms = altwater.getAtomList();
                    for (Atom atom : waterAtoms) {
                        if (atom.getAltLoc() == null || atom.getAltLoc().equals(Character.valueOf(' ')) || atom.getAltLoc().equals(Character.valueOf('A'))) continue;
                        this.writeAtom(atom, serial++, sb, anisouSB, bw);
                    }
                    ++var31_97;
                }
            }
            if (model != null) {
                bw.write("ENDMDL");
                bw.newLine();
            }
            if (writeEnd) {
                bw.write("END");
                bw.newLine();
            }
            if (this.nSymOp >= 0) {
                this.serialP1 = serial;
            }
        }
        catch (Exception e) {
            String message = "Exception writing to file: " + String.valueOf(saveFile);
            logger.log(Level.WARNING, message, e);
            return false;
        }
        return true;
    }

    @Override
    public boolean writeFile(File saveFile, boolean append) {
        return this.writeFile(saveFile, append, false, true);
    }

    @Override
    public boolean writeFile(File saveFile, boolean append, String[] extraLines) {
        return this.writeFile(saveFile, append, Collections.emptySet(), false, !append, extraLines);
    }

    public boolean writeFile(File saveFile, boolean append, boolean versioning) {
        return this.writeFile(saveFile, append, Collections.emptySet(), true, versioning);
    }

    public boolean writeFileWithHeader(File saveFile, String header, boolean append) {
        if (this.standardizeAtomNames) {
            String name;
            ArrayList<Atom> deuteriumAtoms = new ArrayList<Atom>();
            for (Atom atom : this.activeMolecularAssembly.getAtomArray()) {
                if (!atom.getName().startsWith("D")) continue;
                name = atom.getName().replaceFirst("D", "H");
                atom.setName(name);
                deuteriumAtoms.add(atom);
            }
            logger.info(" Setting atom names to PDB standard.");
            NamingUtils.renameAtomsToPDBStandard(this.activeMolecularAssembly);
            for (Atom atom : this.activeMolecularAssembly.getAtomArray()) {
                if (!deuteriumAtoms.contains(atom) || !atom.getName().startsWith("H")) continue;
                name = atom.getName().replaceFirst("H", "D");
                atom.setName(name);
            }
        }
        this.activeMolecularAssembly.setFile(saveFile);
        this.activeMolecularAssembly.setName(saveFile.getName());
        try (FileWriter fw = new FileWriter(saveFile, append);
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(header);
            bw.newLine();
        }
        catch (Exception e) {
            String message = " Exception writing to file: " + String.valueOf(saveFile);
            logger.log(Level.WARNING, message, e);
            return false;
        }
        if (this.writeFile(saveFile, true)) {
            logger.log(Level.INFO, " Wrote PDB to file {0}", saveFile.getPath());
            return true;
        }
        logger.log(Level.INFO, " Error writing to file {0}", saveFile.getPath());
        return false;
    }

    public boolean writeFileWithHeader(File saveFile, String header) {
        return this.writeFileWithHeader(saveFile, header, true);
    }

    public boolean writeFileWithHeader(File saveFile, StringBuilder header) {
        return this.writeFileWithHeader(saveFile, header.toString());
    }

    private String getExistingSegID(Character c) {
        if (c.equals(Character.valueOf(' '))) {
            c = Character.valueOf('A');
        }
        if (c.equals(this.currentChainID)) {
            return this.currentSegID;
        }
        this.currentChainID = null;
        List<String> segIDs = this.segidMap.get(c);
        if (segIDs != null) {
            if (segIDs.size() > 1) {
                if (this.currentSegID == null) {
                    this.currentChainID = c;
                    this.currentSegID = segIDs.getFirst();
                    return segIDs.getFirst();
                }
                if (this.currentSegID.length() == 1) {
                    this.currentChainID = c;
                    this.currentSegID = segIDs.get(1);
                    return segIDs.get(1);
                }
                if (this.currentSegID.length() == 2) {
                    String s = this.currentSegID.substring(0, 1);
                    int num = -2;
                    try {
                        num = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        logger.severe(" SegID of length 2 does not start with an integer.");
                    }
                    this.currentChainID = c;
                    this.currentSegID = segIDs.get(num + 1);
                    return segIDs.get(num + 1);
                }
                logger.info(" Too many repeated chains. Using single letter for segID.");
            }
            return segIDs.get(0);
        }
        logger.log(Level.INFO, String.format(" Creating SegID for to chain %s", c));
        return this.getSegID(c);
    }

    private String getSegID(Character c) {
        if (c.equals(Character.valueOf(' '))) {
            c = Character.valueOf('A');
        }
        if (c.equals(this.currentChainID)) {
            return this.currentSegID;
        }
        int count = 0;
        for (String segID : this.segIDs) {
            if (!segID.endsWith(c.toString())) continue;
            ++count;
        }
        Object newSegID = count == 0 ? c.toString() : count + c.toString();
        this.segIDs.add((String)newSegID);
        this.currentChainID = c;
        this.currentSegID = newSegID;
        if (this.segidMap.containsKey(c)) {
            this.segidMap.get(c).add((String)newSegID);
        } else {
            ArrayList<Object> newChainList = new ArrayList<Object>();
            newChainList.add(newSegID);
            this.segidMap.put(c, newChainList);
        }
        return newSegID;
    }

    private void writeAtom(Atom atom, int serial, StringBuilder sb, StringBuilder anisouSB, BufferedWriter bw) throws IOException {
        double[] xyz;
        Object name = atom.getName();
        int nameLength = ((String)name).length();
        if (nameLength > 4) {
            name = ((String)name).substring(0, 4);
        } else if (nameLength == 1) {
            name = (String)name + "  ";
        } else if (nameLength == 2) {
            name = atom.getAtomType().valence == 0 ? (String)name + "  " : (String)name + " ";
        }
        double[] dArray = xyz = this.vdwH ? atom.getRedXYZ() : atom.getXYZ(null);
        if (this.nSymOp >= 0) {
            Crystal crystal = this.activeMolecularAssembly.getCrystal().getUnitCell();
            SymOp symOp = crystal.spaceGroup.getSymOp(this.nSymOp);
            double[] newXYZ = new double[xyz.length];
            crystal.applySymOp(xyz, newXYZ, symOp);
            if (this.lValue > 0 || this.mValue > 0 || this.nValue > 0) {
                double[] translation = new double[]{this.lValue, this.mValue, this.nValue};
                crystal.getUnitCell().toCartesianCoordinates(translation, translation);
                newXYZ[0] = newXYZ[0] + translation[0];
                newXYZ[1] = newXYZ[1] + translation[1];
                newXYZ[2] = newXYZ[2] + translation[2];
            }
            xyz = newXYZ;
        }
        sb.replace(6, 16, String.format("%5s " + StringUtils.padLeft((String)((String)name).toUpperCase(), (int)4), Hybrid36.encode((int)5, (int)serial)));
        Character altLoc = atom.getAltLoc();
        sb.setCharAt(16, Objects.requireNonNullElse(altLoc, Character.valueOf(' ')).charValue());
        StringBuilder decimals = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            try {
                decimals.append(StringUtils.fwFpDec((double)xyz[i], (int)8, (int)3));
                continue;
            }
            catch (IllegalArgumentException ex) {
                String newValue = StringUtils.fwFpTrunc((double)xyz[i], (int)8, (int)3);
                logger.info(String.format(" XYZ %d coordinate %8.3f for atom %s overflowed bounds of 8.3f string specified by PDB format; truncating value to %s", i, xyz[i], atom, newValue));
                decimals.append(newValue);
            }
        }
        try {
            decimals.append(StringUtils.fwFpDec((double)atom.getOccupancy(), (int)6, (int)2));
        }
        catch (IllegalArgumentException ex) {
            logger.severe(String.format(" Occupancy %f for atom %s is impossible; value must be between 0 and 1", atom.getOccupancy(), atom));
        }
        try {
            decimals.append(StringUtils.fwFpDec((double)atom.getTempFactor(), (int)6, (int)2));
        }
        catch (IllegalArgumentException ex) {
            String newValue = StringUtils.fwFpTrunc((double)atom.getTempFactor(), (int)6, (int)2);
            logger.info(String.format(" Atom temp factor %6.2f for atom %s overflowed bounds of 6.2f string specified by PDB format; truncating value to %s", atom.getTempFactor(), atom, newValue));
            decimals.append(newValue);
        }
        sb.replace(30, 66, decimals.toString());
        name = Atom.ElementSymbol.values()[atom.getAtomicNumber() - 1].toString();
        name = ((String)name).toUpperCase();
        if (atom.isDeuterium()) {
            name = "D";
        }
        sb.replace(76, 78, StringUtils.padLeft((String)name, (int)2));
        sb.replace(78, 80, String.format("%2d", 0));
        bw.write(sb.toString());
        bw.newLine();
        double[] anisou = atom.getAnisou(null);
        if (anisou != null) {
            anisouSB.replace(6, 80, sb.substring(6, 80));
            anisouSB.replace(28, 70, String.format("%7d%7d%7d%7d%7d%7d", (int)(anisou[0] * 10000.0), (int)(anisou[1] * 10000.0), (int)(anisou[2] * 10000.0), (int)(anisou[3] * 10000.0), (int)(anisou[4] * 10000.0), (int)(anisou[5] * 10000.0)));
            bw.write(anisouSB.toString());
            bw.newLine();
        }
    }

    private static /* synthetic */ int[] lambda$readFile$0(Character k) {
        return new int[2];
    }

    static {
        String[] names = new String[]{"C", "CA", "N", "O", "OXT", "OT2"};
        backboneNames = Set.of(names);
        String[] constantPhNames = new String[]{"C", "CA", "N", "O", "OXT", "OT2", "H", "HA", "H1", "H2", "H3"};
        constantPhBackboneNames = Set.of(constantPhNames);
        String[] naNames = new String[]{"P", "OP1", "OP2", "O5'", "C5'", "C4'", "O4'", "C3'", "O3'", "C2'", "C1'"};
        naBackboneNames = Set.of(naNames);
        constantPHResidueMap = new HashMap();
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.LYD, AminoAcidUtils.AminoAcid3.LYS);
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.CYD, AminoAcidUtils.AminoAcid3.CYS);
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.HID, AminoAcidUtils.AminoAcid3.HIS);
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.HIE, AminoAcidUtils.AminoAcid3.HIS);
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.ASP, AminoAcidUtils.AminoAcid3.ASD);
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.ASH, AminoAcidUtils.AminoAcid3.ASD);
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.GLU, AminoAcidUtils.AminoAcid3.GLD);
        constantPHResidueMap.put(AminoAcidUtils.AminoAcid3.GLH, AminoAcidUtils.AminoAcid3.GLD);
        rotamerResidueMap = new HashMap();
        rotamerResidueMap.put(AminoAcidUtils.AminoAcid3.LYD, AminoAcidUtils.AminoAcid3.LYS);
        rotamerResidueMap.put(AminoAcidUtils.AminoAcid3.HID, AminoAcidUtils.AminoAcid3.HIS);
        rotamerResidueMap.put(AminoAcidUtils.AminoAcid3.HIE, AminoAcidUtils.AminoAcid3.HIS);
        rotamerResidueMap.put(AminoAcidUtils.AminoAcid3.ASP, AminoAcidUtils.AminoAcid3.ASH);
        rotamerResidueMap.put(AminoAcidUtils.AminoAcid3.GLU, AminoAcidUtils.AminoAcid3.GLH);
        rotamerResidueMap.put(AminoAcidUtils.AminoAcid3.CYD, AminoAcidUtils.AminoAcid3.CYS);
    }

    public static enum PDBFileStandard {
        VERSION2_3,
        VERSION3_0,
        VERSION3_1,
        VERSION3_2,
        VERSION3_3;

    }

    private static enum Record {
        ANISOU,
        ATOM,
        CONECT,
        CRYST1,
        DBREF,
        END,
        MODEL,
        ENDMDL,
        HELIX,
        HETATM,
        LINK,
        MTRIX1,
        MTRIX2,
        MTRIX3,
        MODRES,
        SEQRES,
        SHEET,
        SSBOND,
        REMARK;

    }

    public static class Mutation {
        final int resID;
        final String resName;
        final char chainChar;
        String origResName;
        double[][] glyco = new double[4][3];
        int[] glycoAtomIndex = new int[4];
        int indCorr;

        public Mutation(int resID, char chainChar, String newResName) {
            newResName = newResName.toUpperCase();
            if (newResName.length() != 3) {
                logger.log(Level.WARNING, String.format("Invalid mutation target: %s.", newResName));
            }
            int isAA = AminoAcidUtils.getAminoAcidNumber(newResName);
            int isNA = NucleicAcidUtils.getNucleicAcidNumber(newResName);
            if (isAA == -1 && isNA == -1) {
                logger.log(Level.WARNING, String.format("Invalid mutation target: %s.", newResName));
            }
            this.resID = resID;
            this.chainChar = chainChar;
            this.resName = newResName;
            String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            this.indCorr = alphabet.indexOf(chainChar);
        }

        public String isNonAlchemicalAtom(String atomName) {
            if (this.isWtPurine()) {
                if (atomName.equals("N9")) {
                    if (this.isMtnPyrimidine()) {
                        return "~N1";
                    }
                    return atomName;
                }
                if (atomName.equals("C4")) {
                    if (this.isMtnPyrimidine()) {
                        return "~C2";
                    }
                    return atomName;
                }
                return null;
            }
            if (this.isWtPyrimidine()) {
                if (atomName.equals("N1")) {
                    if (this.isMtnPurine()) {
                        return "~N9";
                    }
                    return atomName;
                }
                if (atomName.equals("C2")) {
                    if (this.isMtnPurine()) {
                        return "~C4";
                    }
                    return atomName;
                }
                return null;
            }
            return null;
        }

        public ArrayList<String> getAlchemicalAtoms(boolean isWriting) {
            boolean purpur;
            if (this.resName.equals(this.origResName)) {
                logger.severe("Desired Mutation residue is the same as the original.");
                return null;
            }
            if (this.isMtnPurine() && this.isWtPurine()) {
                purpur = true;
            } else if (this.isMtnPyrimidine() && this.isWtPyrimidine()) {
                purpur = false;
            } else {
                return null;
            }
            String res = isWriting ? this.resName : this.origResName;
            ArrayList<String> list = new ArrayList<String>();
            if (purpur) {
                if (res.equals("DAD") || res.equals("DA")) {
                    list.add("N6");
                    list.add("H61");
                    list.add("H62");
                    list.add("H2");
                } else {
                    list.add("H1");
                    list.add("N2");
                    list.add("H21");
                    list.add("H22");
                    list.add("O6");
                }
            } else if (res.equals("DTY") || res.equals("DT")) {
                list.add("H3");
                list.add("O4");
                list.add("C7");
                list.add("H71");
                list.add("H72");
                list.add("H73");
            } else {
                list.add("N4");
                list.add("H41");
                list.add("H42");
                list.add("H5");
            }
            return list;
        }

        public boolean isMtnPurine() {
            return this.resName.equals("DA") || this.resName.equals("DG") || this.resName.equals("DAD") || this.resName.equals("DGU");
        }

        public boolean isMtnPyrimidine() {
            return this.resName.equals("DC") || this.resName.equals("DT") || this.resName.equals("DCY") || this.resName.equals("DTY");
        }

        public boolean isWtPurine() {
            return this.origResName.equals("DA") || this.origResName.equals("DG") || this.origResName.equals("DAD") || this.origResName.equals("DGU");
        }

        public boolean isWtPyrimidine() {
            return this.origResName.equals("DT") || this.origResName.equals("DC") || this.origResName.equals("DTY") || this.origResName.equals("DCY");
        }

        public void addTors(Atom atom, int index) {
            String name = atom.getName();
            if (name.equals("O4'")) {
                atom.getXYZ(this.glyco[0]);
                this.glycoAtomIndex[0] = index - this.indCorr;
            } else if (name.equals("C1'")) {
                atom.getXYZ(this.glyco[1]);
                this.glycoAtomIndex[1] = index - this.indCorr;
            } else if (name.equals("N9") || name.equals("N1") && this.isMtnPyrimidine()) {
                atom.getXYZ(this.glyco[2]);
                this.glycoAtomIndex[2] = index - this.indCorr;
            } else if (name.equals("C4") && this.isMtnPurine() || name.equals("C2") && this.isMtnPyrimidine()) {
                atom.getXYZ(this.glyco[3]);
                this.glycoAtomIndex[3] = index - this.indCorr;
            }
        }

        public void calculateTorsion() {
            double tors = FastMath.toDegrees((double)DoubleMath.dihedralAngle((double[])this.glyco[0], (double[])this.glyco[1], (double[])this.glyco[2], (double[])this.glyco[3]));
            double delta = tors > 0.0 ? tors - 180.0 : tors + 180.0;
            logger.info(String.format("restrain-torsion %d %d %d %d  5.000  %f 1", this.glycoAtomIndex[0], this.glycoAtomIndex[1], this.glycoAtomIndex[2], this.glycoAtomIndex[3], delta));
        }
    }
}

