/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.potential.parameters.AngleTorsionType;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BioType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.OutOfPlaneBendType;
import ffx.potential.parameters.PiOrbitalTorsionType;
import ffx.potential.parameters.StretchBendType;
import ffx.potential.parameters.StretchTorsionType;
import ffx.potential.parameters.TorsionTorsionType;
import ffx.potential.parameters.TorsionType;
import ffx.potential.parameters.UreyBradleyType;
import ffx.potential.parameters.VDWType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenMMXmlFilter {
    private static final Logger logger = Logger.getLogger(OpenMMXmlFilter.class.getName());
    private final ForceField forceField;
    private String outputName;

    public OpenMMXmlFilter(ForceField forceField) {
        this.forceField = forceField;
    }

    public OpenMMXmlFilter(ForceField forceField, String saveName) {
        this.forceField = forceField;
        this.outputName = saveName;
    }

    public void toXML() throws Exception {
        Element ureyBradleyForce;
        Element multipoleForce;
        Element vdwForce;
        Element torsionTorsionForce;
        Element stretchBendForce;
        Element angleTorsionForce;
        Element stretchTorsionForce;
        Element piOrbitalTorsionForce;
        Element torsionForce;
        Element outOfPlaneBendForce;
        Element angleForce;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElement("ForceField");
        doc.appendChild(rootElement);
        Element infoNode = doc.createElement("Info");
        rootElement.appendChild(infoNode);
        Element srcNode = doc.createElement("Source");
        srcNode.setTextContent(this.forceField.getString("forcefield", "UNKNOWN"));
        infoNode.appendChild(srcNode);
        Element dateNode = doc.createElement("DateGenerated");
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        String date = ft.format(new Date());
        dateNode.setTextContent(date);
        infoNode.appendChild(dateNode);
        Element atomTypes = AtomType.getXMLAtomTypes(doc, this.forceField);
        if (atomTypes == null) {
            throw new Exception(" The force field defines no atom types.");
        }
        rootElement.appendChild(atomTypes);
        Map<String, BioType> bioTypes = this.forceField.getBioTypeMap();
        if (!bioTypes.values().isEmpty()) {
            HashMap<String, ArrayList<BioType>> moleculeDict = new HashMap<String, ArrayList<BioType>>();
            for (BioType bioType : bioTypes.values()) {
                if (!moleculeDict.containsKey(bioType.moleculeName)) {
                    moleculeDict.put(bioType.moleculeName, new ArrayList());
                }
                ArrayList moleculeBioTypes = (ArrayList)moleculeDict.get(bioType.moleculeName);
                moleculeBioTypes.add(bioType);
            }
            Element residuesNode = doc.createElement("Residues");
            OpenMMXmlFilter.buildExtraResidues(moleculeDict, doc, residuesNode);
            rootElement.appendChild(residuesNode);
        } else {
            logger.info("WARNING: No BioTypes defined for force field, therefore no OpenMM residues are created.");
        }
        Element bondForce = BondType.getXMLForce(doc, this.forceField);
        if (bondForce != null) {
            rootElement.appendChild(bondForce);
        }
        if ((angleForce = AngleType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(angleForce);
        }
        if ((outOfPlaneBendForce = OutOfPlaneBendType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(outOfPlaneBendForce);
        }
        if ((torsionForce = TorsionType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(torsionForce);
        }
        if ((piOrbitalTorsionForce = PiOrbitalTorsionType.getXMLElement(doc, this.forceField)) != null) {
            rootElement.appendChild(piOrbitalTorsionForce);
        }
        if ((stretchTorsionForce = StretchTorsionType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(stretchTorsionForce);
        }
        if ((angleTorsionForce = AngleTorsionType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(angleTorsionForce);
        }
        if ((stretchBendForce = StretchBendType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(stretchBendForce);
        }
        if ((torsionTorsionForce = TorsionTorsionType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(torsionTorsionForce);
        }
        if ((vdwForce = VDWType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(vdwForce);
        }
        if ((multipoleForce = MultipoleType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(multipoleForce);
        }
        if ((ureyBradleyForce = UreyBradleyType.getXMLForce(doc, this.forceField)) != null) {
            rootElement.appendChild(ureyBradleyForce);
        }
        this.writeXML(doc);
    }

    private static void buildExtraResidues(Map<String, ArrayList<BioType>> moleculeDict, Document doc, Element residuesNode) {
        for (String mol : moleculeDict.keySet()) {
            Element resNode = doc.createElement("Residue");
            resNode.setAttribute("name", mol);
            residuesNode.appendChild(resNode);
            ArrayList<String> order = new ArrayList<String>();
            ArrayList<String> froms = new ArrayList<String>();
            ArrayList<String> tos = new ArrayList<String>();
            int atomCount = 0;
            int bondCount = 0;
            for (BioType bioType : moleculeDict.get(mol)) {
                String[] bonds;
                String atom = bioType.atomName;
                Element atomNode = doc.createElement("Atom");
                atomNode.setAttribute("name", atom);
                atomNode.setAttribute("type", String.valueOf(bioType.atomType));
                resNode.appendChild(atomNode);
                ++atomCount;
                for (String bond : bonds = bioType.bonds) {
                    BioType bondBioType = null;
                    for (BioType bioType2 : moleculeDict.get(mol)) {
                        if (!bioType2.atomName.equals(bond)) continue;
                        bondBioType = bioType2;
                        break;
                    }
                    if (bioType.index >= bondBioType.index) continue;
                    froms.add(atom);
                    tos.add(bond);
                    ++bondCount;
                }
                order.add(atom);
            }
            for (int i = 0; i < froms.size(); ++i) {
                Element bondNode = doc.createElement("Bond");
                bondNode.setAttribute("from", String.valueOf(order.indexOf(froms.get(i))));
                bondNode.setAttribute("to", String.valueOf(order.indexOf(tos.get(i))));
                resNode.appendChild(bondNode);
            }
            logger.info(" Added " + atomCount + " atoms and " + bondCount + " bonds to residue " + mol + ".");
        }
    }

    private void writeXML(Document doc) throws TransformerException {
        String saveName = this.outputName != null ? this.outputName : this.forceField.getString("forcefield", "UNKNOWN");
        TransformerFactory tfFactory = TransformerFactory.newInstance();
        Transformer transformer = tfFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(doc);
        StreamResult result = new StreamResult(saveName + ".xml");
        transformer.transform(src, result);
    }
}

