/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public final class INTFileFilter
extends FileFilter {
    public static boolean isINT(File file) {
        return new INTFileFilter().accept(file);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String ext = FilenameUtils.getExtension((String)file.getName());
        return ext.toUpperCase().startsWith("INT");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acceptDeep(File parm) {
        if (parm == null) return false;
        if (parm.isDirectory()) return false;
        if (!parm.canRead()) {
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(parm));){
            if (!br.ready()) {
                boolean bl = false;
                return bl;
            }
            String rawdata = br.readLine();
            String[] header = rawdata.trim().split(" +");
            if (header.length == 0) {
                boolean bl = false;
                return bl;
            }
            try {
                Integer.parseInt(header[0]);
            }
            catch (Exception e) {
                boolean bl = false;
                br.close();
                return bl;
            }
            String firstAtom = br.readLine();
            if (firstAtom == null) {
                boolean bl = false;
                return bl;
            }
            String[] data = firstAtom.trim().split(" +");
            if (data.length != 3) {
                boolean bl = false;
                return bl;
            }
            try {
                Integer.parseInt(data[0]);
            }
            catch (Exception e) {
                boolean bl = false;
                br.close();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public String getDescription() {
        return "TINKER Internal Coordinates (*.INT)";
    }
}

