/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="strbnd", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[3 integers and 2 reals]\nProvides the values for a single stretch-bend cross term potential parameter.\nThe integer modifiers give the atom class numbers for the three kinds of atoms involved in the angle which is to be defined.\nThe real number modifiers give the force constant values for the first bond (first two atom classes) with the angle, and the second bond with the angle, respectively.\nThe default units for the stretch-bend force constant are kcal/mole/Ang-radian, but this can be controlled via the strbndunit keyword.\n")
public final class StretchBendType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_STRBND_UNIT = Math.PI / 180;
    @FFXProperty(name="strbndunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="(Pi/180)", description="Sets the scale factor needed to convert the energy value computed by the bond stretching-angle bending cross\nterm potential into units of kcal/mole. The correct value is force field dependent and typically provided\nin the header of the master force field parameter file.\n")
    public double strbndunit = Math.PI / 180;
    private static final Logger logger = Logger.getLogger(StretchBendType.class.getName());
    public final int[] atomClasses;
    public final double[] forceConstants;

    public StretchBendType(int[] atomClasses, double[] forceConstants) {
        super(ForceField.ForceFieldType.STRBND, StretchBendType.sortKey(Arrays.copyOf(atomClasses, 3)));
        if (atomClasses[0] > atomClasses[2]) {
            int temp = atomClasses[0];
            double f = forceConstants[0];
            atomClasses[0] = atomClasses[2];
            forceConstants[0] = forceConstants[1];
            atomClasses[2] = temp;
            forceConstants[1] = f;
        }
        this.atomClasses = atomClasses;
        this.forceConstants = forceConstants;
    }

    public static StretchBendType average(StretchBendType stretchBendType1, StretchBendType stretchBendType2, int[] atomClasses) {
        if (stretchBendType1 == null || stretchBendType2 == null || atomClasses == null) {
            return null;
        }
        int len = stretchBendType1.forceConstants.length;
        if (len != stretchBendType2.forceConstants.length) {
            return null;
        }
        double[] forceConstants = new double[len];
        for (int i = 0; i < len; ++i) {
            forceConstants[i] = (stretchBendType1.forceConstants[i] + stretchBendType2.forceConstants[i]) / 2.0;
        }
        return new StretchBendType(atomClasses, forceConstants);
    }

    public static StretchBendType parse(String input, String[] tokens) {
        if (tokens.length < 6) {
            logger.log(Level.WARNING, "Invalid STRBND type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3])};
                double[] forceConstants = new double[]{Double.parseDouble(tokens[4]), Double.parseDouble(tokens[5])};
                return new StretchBendType(atomClasses, forceConstants);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing STRBND type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String sortKey(int[] c) {
        if (c == null || c.length != 3) {
            return null;
        }
        if (c[0] > c[2]) {
            int temp = c[0];
            c[0] = c[2];
            c[2] = temp;
        }
        return c[0] + " " + c[1] + " " + c[2];
    }

    @Override
    public int compare(String key1, String key2) {
        String[] keys1 = key1.split(" ");
        String[] keys2 = key2.split(" ");
        int[] c1 = new int[3];
        int[] c2 = new int[3];
        for (int i = 0; i < 3; ++i) {
            c1[i] = Integer.parseInt(keys1[i]);
            c2[i] = Integer.parseInt(keys2[i]);
        }
        if (c1[1] < c2[1]) {
            return -1;
        }
        if (c1[1] > c2[1]) {
            return 1;
        }
        if (c1[0] < c2[0]) {
            return -1;
        }
        if (c1[0] > c2[0]) {
            return 1;
        }
        if (c1[2] < c2[2]) {
            return -1;
        }
        if (c1[2] > c2[2]) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StretchBendType stretchBendType = (StretchBendType)o;
        return Arrays.equals(this.atomClasses, stretchBendType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(StretchBendType.sortKey(this.atomClasses));
    }

    public StretchBendType patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        int len = this.atomClasses.length;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count == 1 || count == 2) {
            int[] newClasses = Arrays.copyOf(this.atomClasses, len);
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < len; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    newClasses[i] = knownType.atomClass;
                }
            }
            return new StretchBendType(newClasses, this.forceConstants);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("strbnd  %5d  %5d  %5d  %6.2f  %6.2f", this.atomClasses[0], this.atomClasses[1], this.atomClasses[2], this.forceConstants[0], this.forceConstants[1]);
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, StretchBendType> types = forceField.getStretchBendTypes();
        if (!types.values().isEmpty()) {
            Element node = doc.createElement("AmoebaStretchBendForce");
            node.setAttribute("stretchBendUnit", String.valueOf(forceField.getDouble("strbndunit", Math.PI / 180) * 57.29577951308232));
            for (StretchBendType stretchBendType : types.values()) {
                node.appendChild(stretchBendType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("StretchBend");
        node.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        node.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        node.setAttribute("class3", String.format("%d", this.atomClasses[2]));
        node.setAttribute("k1", String.format("%.17f", this.forceConstants[0] * 4.184 / 5.729577951308233));
        node.setAttribute("k2", String.format("%.17f", this.forceConstants[1] * 4.184 / 5.729577951308233));
        return node;
    }
}

