/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Comparator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

@FFXProperty(name="biotype", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[integer, name, quoted string and integer]\nProvides the values to define the correspondence between a single bio-polymer atom type and its force field atom type.\n")
public final class BioType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(BioType.class.getName());
    public final String atomName;
    public final String moleculeName;
    public final String[] bonds;
    public int index;
    public int atomType;

    public BioType(int index, String atomName, String moleculeName, int atomType, String[] bonds) {
        super(ForceField.ForceFieldType.BIOTYPE, Integer.toString(index));
        this.index = index;
        this.atomName = atomName;
        this.moleculeName = moleculeName != null ? moleculeName.replace(',', ' ').replace('\"', ' ').trim() : null;
        this.atomType = atomType;
        this.bonds = bonds;
    }

    public static BioType parse(String input, String[] tokens) {
        if (tokens.length < 5) {
            logger.log(Level.WARNING, "Invalid BIOTYPE type:\n{0}", input);
        } else {
            try {
                int index = Integer.parseInt(tokens[1]);
                String atomName = tokens[2];
                int first = input.indexOf("\"");
                int last = input.lastIndexOf("\"");
                if (first >= last) {
                    logger.log(Level.WARNING, "Invalid BIOTYPE type:\n{0}", input);
                    return null;
                }
                String moleculeName = input.substring(first, last + 1).intern();
                tokens = input.substring(last + 1).trim().split(" +");
                int atomType = Integer.parseInt(tokens[0]);
                int bondCount = tokens.length - 1;
                String[] bonds = null;
                if (bondCount > 0) {
                    bonds = new String[bondCount];
                    System.arraycopy(tokens, 1, bonds, 0, bondCount);
                }
                return new BioType(index, atomName, moleculeName, atomType, bonds);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing BIOTYPE type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    @Override
    public int compare(String s1, String s2) {
        int t1 = Integer.parseInt(s1);
        int t2 = Integer.parseInt(s2);
        return Integer.compare(t1, t2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BioType bioType = (BioType)o;
        return bioType.index == this.index;
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("biotype  %5d  %-4s  \"%s\"  %5d", this.index, this.atomName, this.moleculeName, this.atomType));
        if (this.bonds != null) {
            for (String bond : this.bonds) {
                sb.append(String.format("  %-4s", bond));
            }
        }
        return sb.toString();
    }

    void incrementIndexAndType(int indexIncrement, int typeIncrement) {
        this.index += indexIncrement;
        this.atomType += typeIncrement;
        this.setKey(Integer.toString(this.index));
    }
}

