/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperties;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperties(value={@FFXProperty(name="angle", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[3 integers and 4 reals]\nProvides the values for a single bond angle bending parameter.\nThe integer modifiers give the atom class numbers for the three kinds of atoms involved in the angle which is to be defined.\nThe real number modifiers give the force constant value for the angle and up to three ideal bond angles in degrees.\nIn most cases only one ideal bond angle is given, and that value is used for all occurrences of the specified bond angle.\nIf all three ideal angles are given, the values apply when the central atom of the angle is attached to 0, 1 or 2 additional hydrogen atoms, respectively.\nThis \"hydrogen environment\" option is provided to implement the corresponding feature of the AMOEBA force field.\nThe default units for the force constant are kcal/mole/radian^2, but this can be controlled via the angleunit keyword.\n"), @FFXProperty(name="anglep", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[3 integers and 3 reals]\nProvides the values for a single projected in-plane bond angle bending parameter.\nThe integer modifiers give the atom class numbers for the three kinds of atoms involved in the angle which is to be defined.\nThe real number modifiers give the force constant value for the angle and up to two ideal bond angles in degrees.\nIn most cases only one ideal bond angle is given, and that value is used for all occurrences of the specified bond angle.\nIf all two ideal angles are given, the values apply when the central atom of the angle is attached to 0 or 1 additional hydrogen atoms, respectively.\nThis \"hydrogen environment\" option is provided to implement the corresponding feature of the AMOEBA force field.\nThe default units for the force constant are kcal/mole/radian^2, but this can be controlled via the angleunit keyword.\n")})
public final class AngleType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_ANGLE_UNIT = FastMath.pow((double)(Math.PI / 180), (double)2.0);
    public static final double DEFAULT_ANGLE_CUBIC = 0.0;
    public static final double DEFAULT_ANGLE_QUARTIC = 0.0;
    public static final double DEFAULT_ANGLE_PENTIC = 0.0;
    public static final double DEFAULT_ANGLE_SEXTIC = 0.0;
    @FFXProperty(name="angleunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="(Pi/180)^2", description="Sets the scale factor needed to convert the energy value computed by the bond angle bending potential into units of kcal/mole.\nThe correct value is force field dependent and typically provided in the header of the master force field parameter file.\n")
    public double angleUnit = DEFAULT_ANGLE_UNIT;
    @FFXProperty(name="angle-cubic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the cubic term in the Taylor series expansion form of the bond angle bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the angle bending energy unit conversion factor, the force constant,\nand the cube of the deviation of the bond angle from its ideal value gives the cubic contribution to the angle bending energy.\nThe default value in the absence of the angle-cubic keyword is zero; i.e., the cubic angle bending term is omitted.\n")
    public double cubic = 0.0;
    @FFXProperty(name="angle-quartic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the quartic term in the Taylor series expansion form of the bond angle bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the angle bending energy unit conversion factor, the force constant,\nand the forth power of the deviation of the bond angle from its ideal value gives the quartic contribution to the angle bending energy.\nThe default value in the absence of the angle-quartic keyword is zero; i.e., the quartic angle bending term is omitted.\n")
    public double quartic = 0.0;
    @FFXProperty(name="angle-pentic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the fifth power term in the Taylor series expansion form of the bond angle bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the angle bending energy unit conversion factor, the force constant,\nand the fifth power of the deviation of the bond angle from its ideal value gives the pentic contribution to the angle bending energy.\nThe default value in the absence of the angle-pentic keyword is zero; i.e., the pentic angle bending term is omitted.\n")
    public double pentic = 0.0;
    @FFXProperty(name="angle-sextic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the sixth power term in the Taylor series expansion form of the bond angle bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the angle bending energy unit conversion factor, the force constant,\nand the sixth power of the deviation of the bond angle from its ideal value gives the sextic contribution to the angle bending energy.\nThe default value in the absence of the angle-sextic keyword is zero; i.e., the sextic angle bending term is omitted.\n")
    public double sextic = 0.0;
    private static final Logger logger = Logger.getLogger(AngleType.class.getName());
    public final int[] atomClasses;
    public final double forceConstant;
    public final double[] angle;
    public final AngleMode angleMode;
    public AngleFunction angleFunction;

    public AngleType(int[] atomClasses, double forceConstant, double[] angle) {
        this(atomClasses, forceConstant, angle, AngleMode.NORMAL);
    }

    public AngleType(int[] atomClasses, double forceConstant, double[] angle, AngleMode angleMode) {
        this(atomClasses, forceConstant, angle, angleMode, AngleFunction.SEXTIC);
    }

    public AngleType(int[] atomClasses, double forceConstant, double[] angle, AngleMode angleMode, AngleFunction angleFunction) {
        super(ForceField.ForceFieldType.ANGLE, AngleType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        this.forceConstant = forceConstant;
        this.angle = angle;
        this.angleMode = angleMode;
        this.angleFunction = angleFunction;
        if (angleMode == AngleMode.IN_PLANE) {
            this.forceFieldType = ForceField.ForceFieldType.ANGLEP;
        }
    }

    public static AngleType average(@Nullable AngleType angleType1, @Nullable AngleType angleType2, @Nullable int[] atomClasses) {
        if (angleType1 == null || angleType2 == null || atomClasses == null) {
            return null;
        }
        AngleMode angleMode = angleType1.angleMode;
        if (angleMode != angleType2.angleMode) {
            return null;
        }
        AngleFunction angleFunction = angleType1.angleFunction;
        if (angleFunction != angleType2.angleFunction) {
            return null;
        }
        int len = angleType1.angle.length;
        if (len != angleType2.angle.length) {
            return null;
        }
        double forceConstant = (angleType1.forceConstant + angleType2.forceConstant) / 2.0;
        double[] angle = new double[len];
        for (int i = 0; i < len; ++i) {
            angle[i] = (angleType1.angle[i] + angleType2.angle[i]) / 2.0;
        }
        return new AngleType(atomClasses, forceConstant, angle, angleMode, angleFunction);
    }

    public static AngleType parse(String input, String[] tokens) {
        if (tokens.length >= 6) {
            double[] bondAngle;
            int angles;
            double forceConstant;
            int[] atomClasses = new int[3];
            try {
                atomClasses[0] = Integer.parseInt(tokens[1]);
                atomClasses[1] = Integer.parseInt(tokens[2]);
                atomClasses[2] = Integer.parseInt(tokens[3]);
                forceConstant = Double.parseDouble(tokens[4]);
                angles = tokens.length - 5;
                bondAngle = new double[angles];
                for (int i = 0; i < angles; ++i) {
                    bondAngle[i] = Double.parseDouble(tokens[5 + i]);
                }
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing ANGLE type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
                return null;
            }
            double[] newBondAngle = new double[angles];
            System.arraycopy(bondAngle, 0, newBondAngle, 0, angles);
            return new AngleType(atomClasses, forceConstant, newBondAngle);
        }
        logger.log(Level.WARNING, "Invalid ANGLE type:\n{0}", input);
        return null;
    }

    public static AngleType parseInPlane(String input, String[] tokens) {
        if (tokens.length >= 6) {
            double[] bondAngle;
            int angles;
            double forceConstant;
            int[] atomClasses = new int[3];
            try {
                atomClasses[0] = Integer.parseInt(tokens[1]);
                atomClasses[1] = Integer.parseInt(tokens[2]);
                atomClasses[2] = Integer.parseInt(tokens[3]);
                forceConstant = Double.parseDouble(tokens[4]);
                angles = tokens.length - 5;
                bondAngle = new double[angles];
                for (int i = 0; i < angles; ++i) {
                    bondAngle[i] = Double.parseDouble(tokens[5 + i]);
                }
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing ANGLEP type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
                return null;
            }
            double[] newBondAngle = new double[angles];
            System.arraycopy(bondAngle, 0, newBondAngle, 0, angles);
            return new AngleType(atomClasses, forceConstant, newBondAngle, AngleMode.IN_PLANE);
        }
        logger.log(Level.WARNING, "Invalid ANGLEP type:\n{0}", input);
        return null;
    }

    public static String sortKey(int[] c) {
        if (c == null || c.length != 3) {
            return null;
        }
        if (c[0] > c[2]) {
            int temp = c[0];
            c[0] = c[2];
            c[2] = temp;
        }
        return c[0] + " " + c[1] + " " + c[2];
    }

    @Override
    public int compare(String key1, String key2) {
        String[] keys1 = key1.split(" ");
        String[] keys2 = key2.split(" ");
        int[] c1 = new int[3];
        int[] c2 = new int[3];
        for (int i = 0; i < 3; ++i) {
            c1[i] = Integer.parseInt(keys1[i]);
            c2[i] = Integer.parseInt(keys2[i]);
        }
        if (c1[1] < c2[1]) {
            return -1;
        }
        if (c1[1] > c2[1]) {
            return 1;
        }
        if (c1[0] < c2[0]) {
            return -1;
        }
        if (c1[0] > c2[0]) {
            return 1;
        }
        if (c1[2] < c2[2]) {
            return -1;
        }
        if (c1[2] > c2[2]) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AngleType angleType = (AngleType)o;
        return Arrays.equals(this.atomClasses, angleType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(AngleType.sortKey(this.atomClasses));
    }

    public AngleType patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        int len = this.atomClasses.length;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count == 1 || count == 2) {
            int[] newClasses = Arrays.copyOf(this.atomClasses, len);
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < len; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    newClasses[i] = knownType.atomClass;
                }
            }
            return new AngleType(newClasses, this.forceConstant, this.angle, this.angleMode, this.angleFunction);
        }
        return null;
    }

    public void setAngleFunction(AngleFunction angleFunction) {
        this.angleFunction = angleFunction;
    }

    @Override
    public String toString() {
        StringBuilder angleString = this.angleMode == AngleMode.NORMAL ? new StringBuilder(String.format("angle  %5d  %5d  %5d  %6.2f", this.atomClasses[0], this.atomClasses[1], this.atomClasses[2], this.forceConstant)) : new StringBuilder(String.format("anglep  %5d  %5d  %5d  %6.2f", this.atomClasses[0], this.atomClasses[1], this.atomClasses[2], this.forceConstant));
        for (double eq : this.angle) {
            angleString.append(String.format("  %6.2f", eq));
        }
        return angleString.toString();
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, AngleType> angMap = forceField.getAngleTypes();
        angMap.putAll(forceField.getAnglepTypes());
        if (!angMap.values().isEmpty()) {
            Element node = doc.createElement("AmoebaAngleForce");
            node.setAttribute("angle-cubic", String.valueOf(forceField.getDouble("angle-cubic", 0.0)));
            node.setAttribute("angle-quartic", String.valueOf(forceField.getDouble("angle-quartic", 0.0)));
            node.setAttribute("angle-pentic", String.valueOf(forceField.getDouble("angle-pentic", 0.0)));
            node.setAttribute("angle-sextic", String.valueOf(forceField.getDouble("angle-sextic", 0.0)));
            for (AngleType angleType : angMap.values()) {
                node.appendChild(angleType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Angle");
        node.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        node.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        node.setAttribute("class3", String.format("%d", this.atomClasses[2]));
        node.setAttribute("k", String.format("%.17f", this.forceConstant * 4.184 / 3282.806350011744));
        int i = 1;
        for (double eq : this.angle) {
            node.setAttribute(String.format("angle%d", i), String.format("%f", eq));
            ++i;
        }
        if (this.angleMode == AngleMode.NORMAL) {
            node.setAttribute("inPlane", "False");
        } else {
            node.setAttribute("inPlane", "True");
        }
        return node;
    }

    public static enum AngleMode {
        NORMAL,
        IN_PLANE;

    }

    public static enum AngleFunction {
        HARMONIC,
        SEXTIC;

    }
}

