/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Force;
import ffx.openmm.PeriodicTorsionForce;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Torsion;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TorsionType;
import ffx.potential.terms.TorsionPotentialEnergy;
import java.util.logging.Logger;

public class TorsionForce
extends PeriodicTorsionForce {
    private static final Logger logger = Logger.getLogger(TorsionForce.class.getName());
    private final boolean manyBodyTitration;

    public TorsionForce(TorsionPotentialEnergy torsionPotentialEnergy, OpenMMEnergy openMMEnergy) {
        Torsion[] torsions;
        ForceField forceField = openMMEnergy.getMolecularAssembly().getForceField();
        this.manyBodyTitration = forceField.getBoolean("MANYBODY_TITRATION", false);
        for (Torsion torsion : torsions = torsionPotentialEnergy.getTorsionArray()) {
            int j;
            int a1 = torsion.getAtom(0).getArrayIndex();
            int a2 = torsion.getAtom(1).getArrayIndex();
            int a3 = torsion.getAtom(2).getArrayIndex();
            int a4 = torsion.getAtom(3).getArrayIndex();
            TorsionType torsionType = torsion.torsionType;
            int nTerms = torsionType.phase.length;
            for (j = 0; j < nTerms; ++j) {
                double k = torsion.getTorsionScale() * torsionType.torsionUnit * torsionType.amplitude[j];
                this.addTorsion(a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), 4.184 * k);
            }
            if (!this.manyBodyTitration) continue;
            for (j = nTerms; j < 6; ++j) {
                this.addTorsion(a1, a2, a3, a4, j + 1, 0.0, 0.0);
            }
        }
        int forceGroup = torsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Torsions:                          %10d", torsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public TorsionForce(TorsionPotentialEnergy torsionPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ForceField forceField = forceFieldEnergy.getMolecularAssembly().getForceField();
        this.manyBodyTitration = forceField.getBoolean("MANYBODY_TITRATION", false);
        if (this.manyBodyTitration) {
            logger.severe("OpenMM Dual Topology does not suppport many body titration.");
        }
        Torsion[] torsions = torsionPotentialEnergy.getTorsionArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        for (Torsion torsion : torsions) {
            int a1 = torsion.getAtom(0).getArrayIndex();
            int a2 = torsion.getAtom(1).getArrayIndex();
            int a3 = torsion.getAtom(2).getArrayIndex();
            int a4 = torsion.getAtom(3).getArrayIndex();
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            TorsionType torsionType = torsion.torsionType;
            int nTerms = torsionType.phase.length;
            for (int j = 0; j < nTerms; ++j) {
                double k = torsion.getTorsionScale() * torsionType.torsionUnit * torsionType.amplitude[j];
                if (!torsion.applyLambda()) {
                    k *= scale;
                }
                this.addTorsion(a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), 4.184 * k);
            }
        }
        int forceGroup = torsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Torsions:                          %10d", torsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        TorsionPotentialEnergy torsionPotentialEnergy = openMMEnergy.getTorsionPotentialEnergy();
        if (torsionPotentialEnergy == null) {
            return null;
        }
        return new TorsionForce(torsionPotentialEnergy, openMMEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        TorsionPotentialEnergy torsionPotentialEnergy = forceFieldEnergy.getTorsionPotentialEnergy();
        if (torsionPotentialEnergy == null) {
            return null;
        }
        return new TorsionForce(torsionPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        TorsionPotentialEnergy torsionPotentialEnergy = openMMEnergy.getTorsionPotentialEnergy();
        if (torsionPotentialEnergy == null) {
            return;
        }
        Torsion[] torsions = torsionPotentialEnergy.getTorsionArray();
        int index = 0;
        for (Torsion torsion : torsions) {
            int j;
            TorsionType torsionType = torsion.torsionType;
            int nTerms = torsionType.phase.length;
            int a1 = torsion.getAtom(0).getArrayIndex();
            int a2 = torsion.getAtom(1).getArrayIndex();
            int a3 = torsion.getAtom(2).getArrayIndex();
            int a4 = torsion.getAtom(3).getArrayIndex();
            for (j = 0; j < nTerms; ++j) {
                double k = torsion.getTorsionScale() * torsionType.torsionUnit * torsionType.amplitude[j];
                this.setTorsionParameters(index++, a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), 4.184 * k);
            }
            if (!this.manyBodyTitration) continue;
            for (j = nTerms; j < 6; ++j) {
                this.setTorsionParameters(index++, a1, a2, a3, a4, j + 1, 0.0, 0.0);
            }
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        TorsionPotentialEnergy torsionPotentialEnergy = forceFieldEnergy.getTorsionPotentialEnergy();
        if (torsionPotentialEnergy == null) {
            return;
        }
        Torsion[] torsions = torsionPotentialEnergy.getTorsionArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        int index = 0;
        for (Torsion torsion : torsions) {
            TorsionType torsionType = torsion.torsionType;
            int nTerms = torsionType.phase.length;
            int a1 = torsion.getAtom(0).getArrayIndex();
            int a2 = torsion.getAtom(1).getArrayIndex();
            int a3 = torsion.getAtom(2).getArrayIndex();
            int a4 = torsion.getAtom(3).getArrayIndex();
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            for (int j = 0; j < nTerms; ++j) {
                double k = torsion.getTorsionScale() * torsionType.torsionUnit * torsionType.amplitude[j];
                if (!torsion.applyLambda()) {
                    k *= scale;
                }
                this.setTorsionParameters(index++, a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), 4.184 * k);
            }
        }
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

