/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomCompoundBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.OutOfPlaneBendType;
import ffx.potential.terms.OutOfPlaneBendPotentialEnergy;
import java.util.logging.Logger;

public class OutOfPlaneBendForce
extends CustomCompoundBondForce {
    private static final Logger logger = Logger.getLogger(OutOfPlaneBendForce.class.getName());

    public OutOfPlaneBendForce(OutOfPlaneBendPotentialEnergy outOfPlaneBendPotentialEnergy) {
        super(4, outOfPlaneBendPotentialEnergy.getOutOfPlaneEnergyString());
        OutOfPlaneBend[] outOfPlaneBends = outOfPlaneBendPotentialEnergy.getOutOfPlaneBendArray();
        this.addPerBondParameter("k");
        this.setName("OutOfPlaneBend");
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (OutOfPlaneBend outOfPlaneBend : outOfPlaneBends) {
            OutOfPlaneBendType outOfPlaneBendType = outOfPlaneBend.outOfPlaneBendType;
            int i1 = outOfPlaneBend.getAtom(0).getArrayIndex();
            int i2 = outOfPlaneBend.getAtom(1).getArrayIndex();
            int i3 = outOfPlaneBend.getAtom(2).getArrayIndex();
            int i4 = outOfPlaneBend.getAtom(3).getArrayIndex();
            double k = 4.184 * outOfPlaneBendType.forceConstant * outOfPlaneBendType.opBendUnit;
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(k);
            this.addBond(particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        int forceGroup = outOfPlaneBendPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Out-of-Plane Bends:                %10d", outOfPlaneBends.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public OutOfPlaneBendForce(OutOfPlaneBendPotentialEnergy outOfPlaneBendPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(4, outOfPlaneBendPotentialEnergy.getOutOfPlaneEnergyString());
        OutOfPlaneBend[] outOfPlaneBends = outOfPlaneBendPotentialEnergy.getOutOfPlaneBendArray();
        this.addPerBondParameter("k");
        this.setName("OutOfPlaneBend");
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (OutOfPlaneBend outOfPlaneBend : outOfPlaneBends) {
            OutOfPlaneBendType outOfPlaneBendType = outOfPlaneBend.outOfPlaneBendType;
            int i1 = outOfPlaneBend.getAtom(0).getArrayIndex();
            int i2 = outOfPlaneBend.getAtom(1).getArrayIndex();
            int i3 = outOfPlaneBend.getAtom(2).getArrayIndex();
            int i4 = outOfPlaneBend.getAtom(3).getArrayIndex();
            double k = 4.184 * outOfPlaneBendType.forceConstant * outOfPlaneBendType.opBendUnit;
            if (!outOfPlaneBend.applyLambda()) {
                k *= scale;
            }
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            i4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i4);
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(k);
            this.addBond(particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        int forceGroup = outOfPlaneBendPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Out-of-Plane Bends:                %10d", outOfPlaneBends.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        OutOfPlaneBendPotentialEnergy outOfPlaneBendPotentialEnergy = openMMEnergy.getOutOfPlaneBendPotentialEnergy();
        if (outOfPlaneBendPotentialEnergy == null) {
            return null;
        }
        return new OutOfPlaneBendForce(outOfPlaneBendPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        OutOfPlaneBendPotentialEnergy outOfPlaneBendPotentialEnergy = forceFieldEnergy.getOutOfPlaneBendPotentialEnergy();
        if (outOfPlaneBendPotentialEnergy == null) {
            return null;
        }
        return new OutOfPlaneBendForce(outOfPlaneBendPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        OutOfPlaneBendPotentialEnergy outOfPlaneBendPotentialEnergy = openMMEnergy.getOutOfPlaneBendPotentialEnergy();
        if (outOfPlaneBendPotentialEnergy == null) {
            return;
        }
        OutOfPlaneBend[] outOfPlaneBends = outOfPlaneBendPotentialEnergy.getOutOfPlaneBendArray();
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (OutOfPlaneBend outOfPlaneBend : outOfPlaneBends) {
            OutOfPlaneBendType outOfPlaneBendType = outOfPlaneBend.outOfPlaneBendType;
            int i1 = outOfPlaneBend.getAtom(0).getArrayIndex();
            int i2 = outOfPlaneBend.getAtom(1).getArrayIndex();
            int i3 = outOfPlaneBend.getAtom(2).getArrayIndex();
            int i4 = outOfPlaneBend.getAtom(3).getArrayIndex();
            double k = 4.184 * outOfPlaneBendType.forceConstant * outOfPlaneBendType.opBendUnit;
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(k);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        OutOfPlaneBendPotentialEnergy forceFieldEnergyOutOfPlaneBend = forceFieldEnergy.getOutOfPlaneBendPotentialEnergy();
        if (forceFieldEnergyOutOfPlaneBend == null) {
            return;
        }
        OutOfPlaneBend[] outOfPlaneBends = forceFieldEnergyOutOfPlaneBend.getOutOfPlaneBendArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (OutOfPlaneBend outOfPlaneBend : outOfPlaneBends) {
            OutOfPlaneBendType outOfPlaneBendType = outOfPlaneBend.outOfPlaneBendType;
            int i1 = outOfPlaneBend.getAtom(0).getArrayIndex();
            int i2 = outOfPlaneBend.getAtom(1).getArrayIndex();
            int i3 = outOfPlaneBend.getAtom(2).getArrayIndex();
            int i4 = outOfPlaneBend.getAtom(3).getArrayIndex();
            double k = 4.184 * outOfPlaneBendType.forceConstant * outOfPlaneBendType.opBendUnit;
            if (!outOfPlaneBend.applyLambda()) {
                k *= scale;
            }
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            i4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i4);
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(k);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

