/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomGBForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.MultipoleType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixedChargeGBForce
extends CustomGBForce {
    private static final Logger logger = Logger.getLogger(FixedChargeGBForce.class.getName());

    public FixedChargeGBForce(OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null) {
            this.destroy();
            return;
        }
        double sTens = 0.0;
        if (gk.getNonPolarModel() == GeneralizedKirkwood.NonPolarModel.BORN_SOLV || gk.getNonPolarModel() == GeneralizedKirkwood.NonPolarModel.BORN_CAV_DISP) {
            sTens = gk.getSurfaceTension();
            sTens *= 4.184;
            sTens *= 100.0;
        }
        this.addPerParticleParameter("q");
        this.addPerParticleParameter("radius");
        this.addPerParticleParameter("scale");
        this.addPerParticleParameter("surfaceTension");
        this.addGlobalParameter("solventDielectric", gk.getSolventPermittivity());
        this.addGlobalParameter("soluteDielectric", 1.0);
        this.addGlobalParameter("dOffset", gk.getDielecOffset() * 0.1);
        this.addGlobalParameter("probeRadius", gk.getProbeRadius() * 0.1);
        this.addComputedValue("I", "0.5*((1/L^3-1/U^3)/3.0+(1/U^4-1/L^4)/8.0*(r-sr2*sr2/r)+0.25*(1/U^2-1/L^2)/r+C);\nU=r+sr2;\nC=2/3*(1/or1^3-1/L^3)*step(sr2-r-or1);\nL = step(sr2 - r1r)*sr2mr + (1 - step(sr2 - r1r))*L;\nsr2mr = sr2 - r;\nr1r = radius1 + r;\nL = step(r1sr2 - r)*radius1 + (1 - step(r1sr2 - r))*L;\nr1sr2 = radius1 + sr2;\nL = r - sr2;\nsr2 = scale2 * radius2;\nor1 = radius1;\nor2 = radius2;\n", 2);
        this.addComputedValue("B", "step(BB-radius)*BB + (1 - step(BB-radius))*radius;\nBB = 1 / ( (3.0*III)^(1.0/3.0) );\nIII = step(II)*II + (1 - step(II))*1.0e-9/3.0;\nII = maxI - I;\nmaxI = 1/(3.0*radius^3);\n", 0);
        this.addEnergyTerm("surfaceTension*(radius+probeRadius+dOffset)^2*((radius+dOffset)/B)^6/6-0.5*138.935456*(1/soluteDielectric-1/solventDielectric)*q^2/B", 0);
        this.addEnergyTerm("-138.935456*(1/soluteDielectric-1/solventDielectric)*q1*q2/f;\nf=sqrt(r^2+B1*B2*exp(-r^2/(2.455*B1*B2)));\n", 1);
        double[] baseRadii = gk.getBaseRadii();
        double[] overlapScale = gk.getOverlapScale();
        DoubleArray doubleArray = new DoubleArray(0);
        MolecularAssembly molecularAssembly = openMMEnergy.getMolecularAssembly();
        Atom[] atoms = molecularAssembly.getAtomArray();
        int nAtoms = atoms.length;
        for (int i = 0; i < nAtoms; ++i) {
            MultipoleType multipoleType = atoms[i].getMultipoleType();
            doubleArray.append(multipoleType.charge);
            doubleArray.append(0.1 * baseRadii[i]);
            doubleArray.append(overlapScale[i]);
            doubleArray.append(sTens);
            this.addParticle(doubleArray);
            doubleArray.resize(0);
        }
        doubleArray.destroy();
        double cut = gk.getCutoff();
        this.setCutoffDistance(0.1 * cut);
        int forceGroup = molecularAssembly.getForceField().getInteger("GK_FORCE_GROUP", 1);
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  Custom generalized Born force \t%d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null) {
            return null;
        }
        return new FixedChargeGBForce(openMMEnergy);
    }

    public void updateForce(Atom[] atoms, OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        double[] baseRadii = gk.getBaseRadii();
        double[] overlapScale = gk.getOverlapScale();
        boolean nea = gk.getNativeEnvironmentApproximation();
        double sTens = 0.0;
        if (gk.getNonPolarModel() == GeneralizedKirkwood.NonPolarModel.BORN_SOLV || gk.getNonPolarModel() == GeneralizedKirkwood.NonPolarModel.BORN_CAV_DISP) {
            sTens = gk.getSurfaceTension();
            sTens *= 4.184;
            sTens *= 100.0;
        }
        DoubleArray parameters = new DoubleArray(0);
        double lambdaElec = openMMEnergy.getPmeNode().getAlchemicalParameters().permLambda;
        for (Atom atom : atoms) {
            int index = atom.getXyzIndex() - 1;
            double chargeUseFactor = 1.0;
            if (!atom.getUse() || !atom.getElectrostatics()) {
                chargeUseFactor = 0.0;
            }
            double lambdaScale = lambdaElec;
            if (!atom.applyLambda()) {
                lambdaScale = 1.0;
            }
            MultipoleType multipoleType = atom.getMultipoleType();
            double charge = multipoleType.charge * (chargeUseFactor *= lambdaScale);
            double surfaceTension = sTens * chargeUseFactor;
            double overlapScaleUseFactor = nea ? 1.0 : chargeUseFactor;
            double oScale = overlapScale[index] * overlapScaleUseFactor;
            double baseRadius = baseRadii[index];
            parameters.append(charge);
            parameters.append(0.1 * baseRadius);
            parameters.append(oScale);
            parameters.append(surfaceTension);
            this.setParticleParameters(index, parameters);
            parameters.resize(0);
        }
        parameters.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }
}

