/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import ffx.crystal.Crystal;
import ffx.openmm.CustomBondForce;
import ffx.openmm.CustomNonbondedForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.IntSet;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.NonbondedCutoff;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.nonbonded.VanDerWaalsForm;
import ffx.potential.openmm.FixedChargeNonbondedForce;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.openmm.OpenMMSystem;
import ffx.potential.openmm.RestrainPositionsForce;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixedChargeAlchemicalForces {
    private static final Logger logger = Logger.getLogger(RestrainPositionsForce.class.getName());
    private CustomNonbondedForce fixedChargeSoftcoreForce;
    private CustomBondForce alchemicalAlchemicalStericsForce;
    private CustomBondForce nonAlchemicalAlchemicalStericsForce;

    public FixedChargeAlchemicalForces(OpenMMEnergy openMMEnergy, FixedChargeNonbondedForce fixedChargeNonBondedForce) {
        Atom[] atoms;
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        if (vdW == null) {
            return;
        }
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        if (vdwForm.vdwType != VDWType.VDW_TYPE.LENNARD_JONES || vdwForm.radiusRule != VDWType.RADIUS_RULE.ARITHMETIC || vdwForm.epsilonRule != VDWType.EPSILON_RULE.GEOMETRIC) {
            logger.info(String.format(" VDW Type:         %s", new Object[]{vdwForm.vdwType}));
            logger.info(String.format(" VDW Radius Rule:  %s", new Object[]{vdwForm.radiusRule}));
            logger.info(String.format(" VDW Epsilon Rule: %s", new Object[]{vdwForm.epsilonRule}));
            logger.log(Level.SEVERE, " Unsupported van der Waals functional form.");
            return;
        }
        Object stericsMixingRules = " epsilon = sqrt(epsilon1*epsilon2);";
        stericsMixingRules = (String)stericsMixingRules + " rmin = 0.5 * (sigma1 + sigma2) * 1.122462048309372981;";
        Object stericsEnergyExpression = "(vdw_lambda^beta)*epsilon*x*(x-2.0);";
        stericsEnergyExpression = (String)stericsEnergyExpression + " x = 1.0 / (alpha*(1.0-vdw_lambda)^2.0 + (r/rmin)^6.0);";
        String energyExpression = (String)stericsEnergyExpression + (String)stericsMixingRules;
        this.fixedChargeSoftcoreForce = new CustomNonbondedForce(energyExpression);
        OpenMMSystem openMMSystem = openMMEnergy.getSystem();
        double alpha = vdW.getAlpha();
        double beta = vdW.getBeta();
        this.fixedChargeSoftcoreForce.addGlobalParameter("vdw_lambda", 1.0);
        this.fixedChargeSoftcoreForce.addGlobalParameter("alpha", alpha);
        this.fixedChargeSoftcoreForce.addGlobalParameter("beta", beta);
        this.fixedChargeSoftcoreForce.addPerParticleParameter("sigma");
        this.fixedChargeSoftcoreForce.addPerParticleParameter("epsilon");
        IntSet alchemicalGroup = new IntSet();
        IntSet nonAlchemicalGroup = new IntSet();
        DoubleByReference charge = new DoubleByReference();
        DoubleByReference sigma = new DoubleByReference();
        DoubleByReference eps = new DoubleByReference();
        int index = 0;
        DoubleArray parameters = new DoubleArray(0);
        for (Atom atom : atoms = openMMEnergy.getMolecularAssembly().getAtomArray()) {
            if (atom.applyLambda()) {
                alchemicalGroup.insert(index);
            } else {
                nonAlchemicalGroup.insert(index);
            }
            fixedChargeNonBondedForce.getParticleParameters(index, charge, sigma, eps);
            double sigmaValue = sigma.getValue();
            double epsValue = eps.getValue();
            if (sigmaValue == 0.0) {
                sigmaValue = 1.0;
                epsValue = 0.0;
            }
            parameters.append(sigmaValue);
            parameters.append(epsValue);
            this.fixedChargeSoftcoreForce.addParticle(parameters);
            parameters.resize(0);
            ++index;
        }
        parameters.destroy();
        this.fixedChargeSoftcoreForce.addInteractionGroup(alchemicalGroup, alchemicalGroup);
        this.fixedChargeSoftcoreForce.addInteractionGroup(alchemicalGroup, nonAlchemicalGroup);
        alchemicalGroup.destroy();
        nonAlchemicalGroup.destroy();
        Crystal crystal = openMMEnergy.getCrystal();
        if (crystal.aperiodic()) {
            this.fixedChargeSoftcoreForce.setNonbondedMethod(0);
        } else {
            this.fixedChargeSoftcoreForce.setNonbondedMethod(2);
        }
        NonbondedCutoff nonbondedCutoff = vdW.getNonbondedCutoff();
        double off = nonbondedCutoff.off;
        double cut = nonbondedCutoff.cut;
        if (cut == off) {
            logger.warning(" OpenMM does not properly handle cutoffs where cut == off!");
            if (cut == Double.MAX_VALUE || cut == Double.POSITIVE_INFINITY) {
                logger.info(" Detected infinite or max-value cutoff; setting cut to 1E+40 for OpenMM.");
                cut = 1.0E40;
            } else {
                logger.info(String.format(" Detected cut %8.4g == off %8.4g; scaling cut to 0.99 of off for OpenMM.", cut, off));
                cut *= 0.99;
            }
        }
        this.fixedChargeSoftcoreForce.setCutoffDistance(0.1 * off);
        this.fixedChargeSoftcoreForce.setUseSwitchingFunction(1);
        this.fixedChargeSoftcoreForce.setSwitchingDistance(0.1 * cut);
        ForceField forceField = openMMEnergy.getMolecularAssembly().getForceField();
        int forceGroup = forceField.getInteger("VDW_FORCE_GROUP", 1);
        this.fixedChargeSoftcoreForce.setForceGroup(forceGroup);
        this.alchemicalAlchemicalStericsForce = new CustomBondForce((String)stericsEnergyExpression);
        this.nonAlchemicalAlchemicalStericsForce = new CustomBondForce((String)stericsEnergyExpression);
        this.alchemicalAlchemicalStericsForce.addPerBondParameter("rmin");
        this.alchemicalAlchemicalStericsForce.addPerBondParameter("epsilon");
        this.alchemicalAlchemicalStericsForce.addGlobalParameter("vdw_lambda", 1.0);
        this.alchemicalAlchemicalStericsForce.addGlobalParameter("alpha", alpha);
        this.alchemicalAlchemicalStericsForce.addGlobalParameter("beta", beta);
        this.nonAlchemicalAlchemicalStericsForce.addPerBondParameter("rmin");
        this.nonAlchemicalAlchemicalStericsForce.addPerBondParameter("epsilon");
        this.nonAlchemicalAlchemicalStericsForce.addGlobalParameter("vdw_lambda", 1.0);
        this.nonAlchemicalAlchemicalStericsForce.addGlobalParameter("alpha", alpha);
        this.nonAlchemicalAlchemicalStericsForce.addGlobalParameter("beta", beta);
        int range = fixedChargeNonBondedForce.getNumExceptions();
        IntByReference atomi = new IntByReference();
        IntByReference atomj = new IntByReference();
        int[][] torsionMask = vdW.getMask14();
        for (int i = 0; i < range; ++i) {
            fixedChargeNonBondedForce.getExceptionParameters(i, atomi, atomj, charge, sigma, eps);
            this.fixedChargeSoftcoreForce.addExclusion(atomi.getValue(), atomj.getValue());
            int[] maskI = torsionMask[atomi.getValue()];
            int jID = atomj.getValue();
            boolean epsException = false;
            for (int mask : maskI) {
                if (mask != jID) continue;
                epsException = true;
                break;
            }
            if (!epsException) continue;
            Atom atom1 = atoms[atomi.getValue()];
            Atom atom2 = atoms[atomj.getValue()];
            boolean bothAlchemical = false;
            boolean oneAlchemical = false;
            if (atom1.applyLambda() && atom2.applyLambda()) {
                bothAlchemical = true;
            } else if (atom1.applyLambda() && !atom2.applyLambda() || !atom1.applyLambda() && atom2.applyLambda()) {
                oneAlchemical = true;
            }
            if (!bothAlchemical && !oneAlchemical) continue;
            DoubleArray bondParameters = new DoubleArray(0);
            bondParameters.append(sigma.getValue() * 1.122462048309373);
            bondParameters.append(eps.getValue());
            if (bothAlchemical) {
                this.alchemicalAlchemicalStericsForce.addBond(atomi.getValue(), atomj.getValue(), bondParameters);
            } else {
                this.nonAlchemicalAlchemicalStericsForce.addBond(atomi.getValue(), atomj.getValue(), bondParameters);
            }
            bondParameters.destroy();
        }
        this.alchemicalAlchemicalStericsForce.setForceGroup(forceGroup);
        this.nonAlchemicalAlchemicalStericsForce.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  Added fixed charge softcore force \t%d", forceGroup));
        logger.log(Level.INFO, String.format("   Alpha = %8.6f and beta = %8.6f", alpha, beta));
    }

    public CustomNonbondedForce getFixedChargeSoftcoreForce() {
        return this.fixedChargeSoftcoreForce;
    }

    public CustomBondForce getAlchemicalAlchemicalStericsForce() {
        return this.alchemicalAlchemicalStericsForce;
    }

    public CustomBondForce getNonAlchemicalAlchemicalStericsForce() {
        return this.nonAlchemicalAlchemicalStericsForce;
    }
}

