/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomAngleForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.ForceField;
import ffx.potential.terms.AnglePotentialEnergy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AngleForce
extends CustomAngleForce {
    private static final Logger logger = Logger.getLogger(AngleForce.class.getName());
    private int nAngles = 0;
    private final boolean manyBodyTitration;
    private final boolean rigidHydrogenAngles;

    public AngleForce(AnglePotentialEnergy anglePotentialEnergy, OpenMMEnergy openMMEnergy) {
        super(anglePotentialEnergy.getAngleEnergyString());
        Angle[] angles;
        ForceField forceField = openMMEnergy.getMolecularAssembly().getForceField();
        this.manyBodyTitration = forceField.getBoolean("MANYBODY_TITRATION", false);
        this.rigidHydrogenAngles = forceField.getBoolean("RIGID_HYDROGEN_ANGLES", false);
        this.addPerAngleParameter("theta0");
        this.addPerAngleParameter("k");
        this.setName("Angle");
        DoubleArray parameters = new DoubleArray(0);
        for (Angle angle : angles = anglePotentialEnergy.getAngleArray()) {
            AngleType angleType = angle.getAngleType();
            AngleType.AngleMode angleMode = angleType.angleMode;
            if (!this.manyBodyTitration && angleMode == AngleType.AngleMode.IN_PLANE) continue;
            if (this.isHydrogenAngle(angle) && this.rigidHydrogenAngles) {
                logger.log(Level.INFO, " Constrained angle %s was not added the AngleForce.", angle);
                continue;
            }
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            double theta0 = angleType.angle[angle.nh];
            double k = 4.184 * angleType.angleUnit * angleType.forceConstant;
            if (angleMode == AngleType.AngleMode.IN_PLANE) {
                k = 0.0;
            }
            parameters.append(theta0);
            parameters.append(k);
            this.addAngle(i1, i2, i3, parameters);
            ++this.nAngles;
            parameters.resize(0);
        }
        parameters.destroy();
        if (this.nAngles > 0) {
            int forceGroup = anglePotentialEnergy.getForceGroup();
            this.setForceGroup(forceGroup);
            logger.info(String.format("  Angles:                            %10d", this.nAngles));
            logger.fine(String.format("   Force Group:                      %10d", forceGroup));
        }
    }

    public AngleForce(AnglePotentialEnergy anglePotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(anglePotentialEnergy.getAngleEnergyString());
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        this.addPerAngleParameter("theta0");
        this.addPerAngleParameter("k");
        this.setName("Angle");
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ForceField forceField = forceFieldEnergy.getMolecularAssembly().getForceField();
        this.manyBodyTitration = forceField.getBoolean("MANYBODY_TITRATION", false);
        this.rigidHydrogenAngles = forceField.getBoolean("RIGID_HYDROGEN_ANGLES", false);
        if (this.manyBodyTitration || this.rigidHydrogenAngles) {
            logger.severe("Dual Topology does not support rigid hydrogen angles or many body titration.");
        }
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        DoubleArray parameters = new DoubleArray(0);
        for (Angle angle : angles) {
            AngleType angleType = angle.angleType;
            AngleType.AngleMode angleMode = angleType.angleMode;
            if (angleMode == AngleType.AngleMode.IN_PLANE) continue;
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            double theta0 = angleType.angle[angle.nh];
            double k = 4.184 * angleType.angleUnit * angleType.forceConstant;
            if (!angle.applyLambda()) {
                k *= scale;
            }
            parameters.append(theta0);
            parameters.append(k);
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            this.addAngle(i1, i2, i3, parameters);
            ++this.nAngles;
            parameters.resize(0);
        }
        parameters.destroy();
        if (this.nAngles > 0) {
            int forceGroup = anglePotentialEnergy.getForceGroup();
            this.setForceGroup(forceGroup);
            logger.info(String.format("  Angles:                            %10d", this.nAngles));
            logger.fine(String.format("   Force Group:                      %10d", forceGroup));
        }
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        AnglePotentialEnergy anglePotentialEnergy = openMMEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return null;
        }
        AngleForce angleForce = new AngleForce(anglePotentialEnergy, openMMEnergy);
        if (angleForce.nAngles > 0) {
            return angleForce;
        }
        angleForce.destroy();
        return null;
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        AnglePotentialEnergy anglePotentialEnergy = forceFieldEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return null;
        }
        AngleForce angleForce = new AngleForce(anglePotentialEnergy, topology, openMMDualTopologyEnergy);
        if (angleForce.nAngles > 0) {
            return angleForce;
        }
        angleForce.destroy();
        return null;
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        AnglePotentialEnergy anglePotentialEnergy = openMMEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return;
        }
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (Angle angle : angles) {
            AngleType.AngleMode angleMode = angle.angleType.angleMode;
            if (!this.manyBodyTitration && angleMode == AngleType.AngleMode.IN_PLANE || this.rigidHydrogenAngles && this.isHydrogenAngle(angle)) continue;
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            double theta0 = angle.angleType.angle[angle.nh];
            double k = 4.184 * angle.angleType.angleUnit * angle.angleType.forceConstant;
            if (angleMode == AngleType.AngleMode.IN_PLANE) {
                k = 0.0;
            }
            parameters.append(theta0);
            parameters.append(k);
            this.setAngleParameters(index++, i1, i2, i3, parameters);
            parameters.resize(0);
        }
        parameters.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        AnglePotentialEnergy anglePotentialEnergy = forceFieldEnergy.getAnglePotentialEnergy();
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        if (angles == null || angles.length < 1) {
            return;
        }
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (Angle angle : angles) {
            AngleType.AngleMode angleMode = angle.angleType.angleMode;
            if (angleMode == AngleType.AngleMode.IN_PLANE) continue;
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            double theta0 = angle.angleType.angle[angle.nh];
            double k = 4.184 * angle.angleType.angleUnit * angle.angleType.forceConstant;
            if (!angle.applyLambda()) {
                k *= scale;
            }
            if (angleMode == AngleType.AngleMode.IN_PLANE) {
                k = 0.0;
            }
            parameters.append(theta0);
            parameters.append(k);
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            this.setAngleParameters(index++, i1, i2, i3, parameters);
            parameters.resize(0);
        }
        parameters.destroy();
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }

    private boolean isHydrogenAngle(Angle angle) {
        double angleVal;
        if (angle.containsHydrogen() && (angleVal = angle.angleType.angle[angle.nh]) < 160.0) {
            Atom atom1 = angle.getAtom(0);
            Atom atom2 = angle.getAtom(1);
            Atom atom3 = angle.getAtom(2);
            return atom1.isHydrogen() && atom3.isHydrogen() && !atom2.isHydrogen();
        }
        return false;
    }
}

