/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import ffx.potential.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum SCFAlgorithm {
    SOR(true, true),
    CG(true, true),
    EPT(true, true);

    private final List<Platform> supportedPlatforms;

    private SCFAlgorithm(boolean ffx, boolean openMM) {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        if (ffx) {
            platforms.add(Platform.FFX);
        }
        if (openMM) {
            platforms.add(Platform.OMM);
            platforms.add(Platform.OMM_CUDA);
            platforms.add(Platform.OMM_OPENCL);
            platforms.add(Platform.OMM_REF);
        }
        this.supportedPlatforms = Collections.unmodifiableList(platforms);
    }

    public boolean isSupported(Platform platform) {
        return this.supportedPlatforms.contains((Object)platform);
    }
}

