/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.SharedDouble;
import ffx.potential.bonded.Atom;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolarizationEnergyRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(PolarizationEnergyRegion.class.getName());
    private final double electric;
    private final PolarizationEnergyLoop[] polarizationLoop;
    private final SharedDouble polarizationEnergy = new SharedDouble();
    private Atom[] atoms;
    private double[] polarizability;
    private double[][][] inducedDipole;
    private double[][] directDipoleCR;
    private double polarizationScale;

    public PolarizationEnergyRegion(int nt, double electric) {
        this.electric = electric;
        this.polarizationLoop = new PolarizationEnergyLoop[nt];
    }

    public void finish() {
        double energy = this.polarizationEnergy.get();
        this.polarizationEnergy.set(energy * this.polarizationScale * this.electric);
    }

    public double getPolarizationEnergy() {
        return this.polarizationEnergy.get();
    }

    public void setPolarizationEnergy(double energy) {
        this.polarizationEnergy.set(energy);
    }

    public void init(Atom[] atoms, double[] polarizability, double[][][] inducedDipole, double[][] directDipoleCR, double polarizationScale) {
        this.atoms = atoms;
        this.polarizability = polarizability;
        this.inducedDipole = inducedDipole;
        this.directDipoleCR = directDipoleCR;
        this.polarizationScale = polarizationScale;
    }

    public void run() throws Exception {
        try {
            int ti = this.getThreadIndex();
            if (this.polarizationLoop[ti] == null) {
                this.polarizationLoop[ti] = new PolarizationEnergyLoop(this);
            }
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.polarizationLoop[ti]);
        }
        catch (RuntimeException ex) {
            logger.warning("Runtime exception computing polarization energy in thread " + this.getThreadIndex());
            throw ex;
        }
        catch (Exception e) {
            String message = "Fatal exception computing polarization energy in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void start() {
        this.polarizationEnergy.set(0.0);
    }

    private class PolarizationEnergyLoop
    extends IntegerForLoop {
        final /* synthetic */ PolarizationEnergyRegion this$0;

        private PolarizationEnergyLoop(PolarizationEnergyRegion polarizationEnergyRegion) {
            PolarizationEnergyRegion polarizationEnergyRegion2 = polarizationEnergyRegion;
            Objects.requireNonNull(polarizationEnergyRegion2);
            this.this$0 = polarizationEnergyRegion2;
        }

        public void run(int lb, int ub) throws Exception {
            double energy = 0.0;
            for (int i = lb; i <= ub; ++i) {
                if (this.this$0.polarizability[i] == 0.0) continue;
                double uix = this.this$0.inducedDipole[0][i][0];
                double uiy = this.this$0.inducedDipole[0][i][1];
                double uiz = this.this$0.inducedDipole[0][i][2];
                double pix = this.this$0.directDipoleCR[i][0];
                double piy = this.this$0.directDipoleCR[i][1];
                double piz = this.this$0.directDipoleCR[i][2];
                energy += (uix * pix + uiy * piy + uiz * piz) / this.this$0.polarizability[i];
            }
            this.this$0.polarizationEnergy.addAndGet(-0.5 * energy);
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

