/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedInteger;
import edu.rit.util.Range;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.special.Erf;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.MaskingInterface;
import ffx.potential.nonbonded.ReciprocalSpace;
import ffx.potential.nonbonded.pme.EwaldParameters;
import ffx.potential.nonbonded.pme.LambdaMode;
import ffx.potential.nonbonded.pme.PCGSolver;
import ffx.potential.nonbonded.pme.PMETimings;
import ffx.potential.nonbonded.pme.RealSpaceNeighborParameters;
import ffx.potential.nonbonded.pme.ScaleParameters;
import ffx.potential.parameters.ForceField;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class PermanentFieldRegion
extends ParallelRegion
implements MaskingInterface {
    private static final Logger logger = Logger.getLogger(PermanentFieldRegion.class.getName());
    private static final double oneThird = 0.3333333333333333;
    private final boolean intermolecularSoftcore;
    private final boolean intramolecularSoftcore;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    protected int[][] ip11;
    private Atom[] atoms;
    private Crystal crystal;
    private double[][][] coordinates;
    private double[][][] globalMultipole;
    private int[][][] neighborLists;
    private int[][][] preconditionerLists;
    private int[][] preconditionerCounts;
    private boolean[] use;
    private int[] molecule;
    private double[] ipdamp;
    private double[] thole;
    private int[][] mask12;
    private int[][] mask13;
    private int[][] mask14;
    private LambdaMode lambdaMode = LambdaMode.OFF;
    private ReciprocalSpace reciprocalSpace;
    private boolean reciprocalSpaceTerm;
    private double off2;
    private double preconditionerCutoff;
    private double an0;
    private double an1;
    private double an2;
    private double aewald;
    private int[][][] realSpaceLists;
    private int[][] realSpaceCounts;
    private Range[] realSpaceRanges;
    private IntegerSchedule permanentSchedule;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private ScaleParameters scaleParameters;
    private final PermanentRealSpaceFieldSection permanentRealSpaceFieldSection;
    private final PermanentReciprocalSection permanentReciprocalSection;
    private PMETimings pmeTimings;

    public PermanentFieldRegion(ParallelTeam pt, ForceField forceField, boolean lambdaTerm) {
        this.permanentRealSpaceFieldSection = new PermanentRealSpaceFieldSection(this, pt);
        this.permanentReciprocalSection = new PermanentReciprocalSection(this);
        if (lambdaTerm) {
            this.intermolecularSoftcore = forceField.getBoolean("INTERMOLECULAR_SOFTCORE", false);
            this.intramolecularSoftcore = forceField.getBoolean("INTRAMOLECULAR_SOFTCORE", false);
        } else {
            this.intermolecularSoftcore = false;
            this.intramolecularSoftcore = false;
        }
    }

    @Override
    public void applyMask(int i, boolean[] is14, double[] ... masks) {
        if (this.ip11[i] != null) {
            int[] m14;
            int[] m13;
            int[] m12;
            double[] energyMask = masks[0];
            for (int value : m12 = this.mask12[i]) {
                energyMask[value] = this.scaleParameters.p12scale;
            }
            for (int value : m13 = this.mask13[i]) {
                energyMask[value] = this.scaleParameters.p13scale;
            }
            block2: for (int value : m14 = this.mask14[i]) {
                energyMask[value] = this.scaleParameters.p14scale;
                for (int k : this.ip11[i]) {
                    if (k != value) continue;
                    energyMask[value] = this.scaleParameters.intra14Scale * this.scaleParameters.p14scale;
                    continue block2;
                }
            }
            double[] inductionMask = masks[1];
            for (int index : this.ip11[i]) {
                inductionMask[index] = this.scaleParameters.d11scale;
            }
        }
    }

    public void initTimings() {
        this.permanentRealSpaceFieldSection.initTimings();
    }

    public long getRealSpacePermTime() {
        return this.permanentRealSpaceFieldSection.time;
    }

    public long getInitTime(int threadId) {
        return this.permanentRealSpaceFieldSection.permanentRealSpaceFieldRegion.initializationLoop[threadId].time;
    }

    public long getPermTime(int threadId) {
        return this.permanentRealSpaceFieldSection.permanentRealSpaceFieldRegion.permanentRealSpaceFieldLoop[threadId].time;
    }

    public void init(Atom[] atoms, Crystal crystal, double[][][] coordinates, double[][][] globalMultipole, double[][][] inducedDipole, double[][][] inducedDipoleCR, int[][][] neighborLists, ScaleParameters scaleParameters, boolean[] use, int[] molecule, double[] ipdamp, double[] thole, int[][] ip11, int[][] mask12, int[][] mask13, int[][] mask14, LambdaMode lambdaMode, boolean reciprocalSpaceTerm, ReciprocalSpace reciprocalSpace, EwaldParameters ewaldParameters, PCGSolver pcgSolver, IntegerSchedule permanentSchedule, RealSpaceNeighborParameters realSpaceNeighborParameters, AtomicDoubleArray3D field, AtomicDoubleArray3D fieldCR) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.coordinates = coordinates;
        this.globalMultipole = globalMultipole;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.neighborLists = neighborLists;
        this.scaleParameters = scaleParameters;
        this.use = use;
        this.molecule = molecule;
        this.ipdamp = ipdamp;
        this.thole = thole;
        this.ip11 = ip11;
        this.mask12 = mask12;
        this.mask13 = mask13;
        this.mask14 = mask14;
        this.lambdaMode = lambdaMode;
        this.reciprocalSpaceTerm = reciprocalSpaceTerm;
        this.reciprocalSpace = reciprocalSpace;
        if (pcgSolver != null) {
            this.preconditionerCutoff = pcgSolver.getPreconditionerCutoff();
            this.preconditionerLists = pcgSolver.getPreconditionerLists();
            this.preconditionerCounts = pcgSolver.getPreconditionerCounts();
        }
        this.aewald = ewaldParameters.aewald;
        this.an0 = ewaldParameters.an0;
        this.an1 = ewaldParameters.an1;
        this.an2 = ewaldParameters.an2;
        this.off2 = ewaldParameters.off2;
        this.permanentSchedule = permanentSchedule;
        this.realSpaceLists = realSpaceNeighborParameters.realSpaceLists;
        this.realSpaceCounts = realSpaceNeighborParameters.realSpaceCounts;
        this.realSpaceRanges = realSpaceNeighborParameters.realSpaceRanges;
        this.field = field;
        this.fieldCR = fieldCR;
    }

    @Override
    public void removeMask(int i, boolean[] is14, double[] ... masks) {
        if (this.ip11[i] != null) {
            int[] m14;
            int[] m13;
            int[] m12;
            double[] energyMask = masks[0];
            for (int value : m12 = this.mask12[i]) {
                energyMask[value] = 1.0;
            }
            for (int value : m13 = this.mask13[i]) {
                energyMask[value] = 1.0;
            }
            block2: for (int value : m14 = this.mask14[i]) {
                energyMask[value] = 1.0;
                for (int k : this.ip11[i]) {
                    if (k != value) continue;
                    energyMask[value] = 1.0;
                    continue block2;
                }
            }
            double[] inductionMask = masks[1];
            for (int index : this.ip11[i]) {
                inductionMask[index] = 1.0;
            }
        }
    }

    public void run() {
        try {
            this.execute(this.permanentRealSpaceFieldSection, this.permanentReciprocalSection);
        }
        catch (RuntimeException e) {
            String message = "Runtime exception computing the permanent multipole field.\n";
            logger.log(Level.WARNING, message, e);
            throw e;
        }
        catch (Exception e) {
            String message = "Fatal exception computing the permanent multipole field.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class PermanentRealSpaceFieldSection
    extends ParallelSection {
        private final PermanentRealSpaceFieldRegion permanentRealSpaceFieldRegion;
        private final ParallelTeam parallelTeam;
        protected long time;

        PermanentRealSpaceFieldSection(PermanentFieldRegion permanentFieldRegion, ParallelTeam pt) {
            Objects.requireNonNull(permanentFieldRegion);
            this.parallelTeam = pt;
            int nt = pt.getThreadCount();
            this.permanentRealSpaceFieldRegion = new PermanentRealSpaceFieldRegion(permanentFieldRegion, nt);
        }

        public void initTimings() {
            this.time = 0L;
            this.permanentRealSpaceFieldRegion.initTimings();
        }

        public void run() {
            try {
                this.time -= System.nanoTime();
                this.parallelTeam.execute((ParallelRegion)this.permanentRealSpaceFieldRegion);
                this.time += System.nanoTime();
            }
            catch (RuntimeException e) {
                String message = "Fatal exception computing the real space field.\n";
                logger.log(Level.WARNING, message, e);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the real space field.\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
    }

    private class PermanentReciprocalSection
    extends ParallelSection {
        final /* synthetic */ PermanentFieldRegion this$0;

        private PermanentReciprocalSection(PermanentFieldRegion permanentFieldRegion) {
            PermanentFieldRegion permanentFieldRegion2 = permanentFieldRegion;
            Objects.requireNonNull(permanentFieldRegion2);
            this.this$0 = permanentFieldRegion2;
        }

        public void run() {
            if (this.this$0.reciprocalSpaceTerm && this.this$0.aewald > 0.0) {
                this.this$0.reciprocalSpace.performConvolution();
            }
        }
    }

    private class PermanentRealSpaceFieldRegion
    extends ParallelRegion {
        private final InitializationLoop[] initializationLoop;
        private final PermanentRealSpaceFieldLoop[] permanentRealSpaceFieldLoop;
        private final SharedInteger sharedCount;
        private final int threadCount;
        final /* synthetic */ PermanentFieldRegion this$0;

        PermanentRealSpaceFieldRegion(PermanentFieldRegion permanentFieldRegion, int nt) {
            PermanentFieldRegion permanentFieldRegion2 = permanentFieldRegion;
            Objects.requireNonNull(permanentFieldRegion2);
            this.this$0 = permanentFieldRegion2;
            this.threadCount = nt;
            this.initializationLoop = new InitializationLoop[this.threadCount];
            this.permanentRealSpaceFieldLoop = new PermanentRealSpaceFieldLoop[this.threadCount];
            this.sharedCount = new SharedInteger();
            for (int i = 0; i < this.threadCount; ++i) {
                this.initializationLoop[i] = new InitializationLoop(this);
                this.permanentRealSpaceFieldLoop[i] = new PermanentRealSpaceFieldLoop(this);
            }
        }

        public void initTimings() {
            for (int i = 0; i < this.threadCount; ++i) {
                this.permanentRealSpaceFieldLoop[i].time = 0L;
                this.initializationLoop[i].time = 0L;
            }
        }

        public void finish() {
            if (this.this$0.realSpaceRanges == null) {
                logger.severe(" RealSpaceRange array is null");
            }
            int nAtoms = this.this$0.atoms.length;
            int id = 0;
            int goal = this.sharedCount.get() / this.threadCount;
            int num = 0;
            int start = 0;
            for (int i = 0; i < nAtoms; ++i) {
                int j;
                List symOps = this.this$0.crystal.spaceGroup.symOps;
                int nSymm = symOps.size();
                for (int iSymm = 0; iSymm < nSymm; ++iSymm) {
                    num += this.this$0.realSpaceCounts[iSymm][i];
                }
                if (num >= goal) {
                    if (id == this.threadCount - 1) {
                        this.this$0.realSpaceRanges[id] = new Range(start, nAtoms - 1);
                        break;
                    }
                    this.this$0.realSpaceRanges[id] = new Range(start, i);
                    num = 0;
                    ++id;
                    start = i + 1;
                    if (start != nAtoms) continue;
                    for (j = id; j < this.threadCount; ++j) {
                        this.this$0.realSpaceRanges[j] = null;
                    }
                    break;
                }
                if (i != nAtoms - 1) continue;
                this.this$0.realSpaceRanges[id] = new Range(start, nAtoms - 1);
                for (j = id + 1; j < this.threadCount; ++j) {
                    this.this$0.realSpaceRanges[j] = null;
                }
            }
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            try {
                int nAtoms = this.this$0.atoms.length;
                this.execute(0, nAtoms - 1, this.initializationLoop[threadIndex]);
                this.execute(0, nAtoms - 1, this.permanentRealSpaceFieldLoop[threadIndex]);
            }
            catch (RuntimeException e) {
                String message = "Runtime exception computing the real space field.\n";
                logger.log(Level.SEVERE, message, e);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the real space field in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        public void start() {
            this.sharedCount.set(0);
        }

        private class InitializationLoop
        extends IntegerForLoop {
            protected long time;
            final /* synthetic */ PermanentRealSpaceFieldRegion this$1;

            private InitializationLoop(PermanentRealSpaceFieldRegion permanentRealSpaceFieldRegion) {
                PermanentRealSpaceFieldRegion permanentRealSpaceFieldRegion2 = permanentRealSpaceFieldRegion;
                Objects.requireNonNull(permanentRealSpaceFieldRegion2);
                this.this$1 = permanentRealSpaceFieldRegion2;
            }

            public void start() {
                this.time -= System.nanoTime();
            }

            public void finish() {
                this.time += System.nanoTime();
            }

            public void run(int lb, int ub) {
                List symOps = this.this$1.this$0.crystal.spaceGroup.symOps;
                int nSymm = symOps.size();
                for (int iSymm = 0; iSymm < nSymm; ++iSymm) {
                    double[][] ind0 = this.this$1.this$0.inducedDipole[0];
                    double[][] indCR0 = this.this$1.this$0.inducedDipoleCR[0];
                    for (int i = lb; i <= ub; ++i) {
                        double[] ind = ind0[i];
                        double[] indCR = indCR0[i];
                        ind[0] = 0.0;
                        ind[1] = 0.0;
                        ind[2] = 0.0;
                        indCR[0] = 0.0;
                        indCR[1] = 0.0;
                        indCR[2] = 0.0;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }
        }

        private class PermanentRealSpaceFieldLoop
        extends IntegerForLoop {
            protected long time;
            private final double[] dx_local;
            private final double[][] transOp;
            private int threadID;
            private double[] inductionMaskLocal;
            private double[] energyMaskLocal;
            private int count;
            final /* synthetic */ PermanentRealSpaceFieldRegion this$1;

            PermanentRealSpaceFieldLoop(PermanentRealSpaceFieldRegion permanentRealSpaceFieldRegion) {
                PermanentRealSpaceFieldRegion permanentRealSpaceFieldRegion2 = permanentRealSpaceFieldRegion;
                Objects.requireNonNull(permanentRealSpaceFieldRegion2);
                this.this$1 = permanentRealSpaceFieldRegion2;
                this.dx_local = new double[3];
                this.transOp = new double[3][3];
            }

            public void finish() {
                this.this$1.sharedCount.addAndGet(this.count);
                this.time += System.nanoTime();
            }

            public void run(int lb, int ub) {
                int[][] lists = this.this$1.this$0.neighborLists[0];
                int[][] ewalds = this.this$1.this$0.realSpaceLists[0];
                int[] counts = this.this$1.this$0.realSpaceCounts[0];
                int[][] preLists = this.this$1.this$0.preconditionerLists[0];
                int[] preCounts = this.this$1.this$0.preconditionerCounts[0];
                double[] x = this.this$1.this$0.coordinates[0][0];
                double[] y = this.this$1.this$0.coordinates[0][1];
                double[] z = this.this$1.this$0.coordinates[0][2];
                double[][] mpole = this.this$1.this$0.globalMultipole[0];
                for (int i = lb; i <= ub; ++i) {
                    if (!this.this$1.this$0.use[i]) continue;
                    double fix = 0.0;
                    double fiy = 0.0;
                    double fiz = 0.0;
                    double fixCR = 0.0;
                    double fiyCR = 0.0;
                    double fizCR = 0.0;
                    int moleculei = this.this$1.this$0.molecule[i];
                    double pdi = this.this$1.this$0.ipdamp[i];
                    double pti = this.this$1.this$0.thole[i];
                    double xi = x[i];
                    double yi = y[i];
                    double zi = z[i];
                    double[] globalMultipolei = mpole[i];
                    double ci = globalMultipolei[0];
                    double dix = globalMultipolei[1];
                    double diy = globalMultipolei[2];
                    double diz = globalMultipolei[3];
                    double qixx = globalMultipolei[4] * 0.3333333333333333;
                    double qiyy = globalMultipolei[5] * 0.3333333333333333;
                    double qizz = globalMultipolei[6] * 0.3333333333333333;
                    double qixy = globalMultipolei[7] * 0.3333333333333333;
                    double qixz = globalMultipolei[8] * 0.3333333333333333;
                    double qiyz = globalMultipolei[9] * 0.3333333333333333;
                    this.this$1.this$0.applyMask(i, null, this.energyMaskLocal, this.inductionMaskLocal);
                    int[] list = lists[i];
                    counts[i] = 0;
                    preCounts[i] = 0;
                    int[] ewald = ewalds[i];
                    int[] preList = preLists[i];
                    for (int k : list) {
                        double rdamp;
                        if (!this.this$1.this$0.use[k]) continue;
                        if (this.this$1.this$0.lambdaMode == LambdaMode.VAPOR) {
                            boolean sameMolecule;
                            boolean bl = sameMolecule = moleculei == this.this$1.this$0.molecule[k];
                            if (this.this$1.this$0.intermolecularSoftcore && !sameMolecule || this.this$1.this$0.intramolecularSoftcore && sameMolecule) continue;
                        }
                        double xk = x[k];
                        double yk = y[k];
                        double zk = z[k];
                        this.dx_local[0] = xk - xi;
                        this.dx_local[1] = yk - yi;
                        this.dx_local[2] = zk - zi;
                        double r2 = this.this$1.this$0.crystal.image(this.dx_local);
                        if (!(r2 <= this.this$1.this$0.off2)) continue;
                        ++this.count;
                        if (ewald.length <= counts[i]) {
                            int len = ewald.length;
                            ewalds[i] = Arrays.copyOf(ewald, len + 10);
                            ewald = ewalds[i];
                        }
                        int n = i;
                        int n2 = counts[n];
                        counts[n] = n2 + 1;
                        ewald[n2] = k;
                        double xr = this.dx_local[0];
                        double yr = this.dx_local[1];
                        double zr = this.dx_local[2];
                        double pdk = this.this$1.this$0.ipdamp[k];
                        double ptk = this.this$1.this$0.thole[k];
                        double[] globalMultipolek = mpole[k];
                        double ck = globalMultipolek[0];
                        double dkx = globalMultipolek[1];
                        double dky = globalMultipolek[2];
                        double dkz = globalMultipolek[3];
                        double qkxx = globalMultipolek[4] * 0.3333333333333333;
                        double qkyy = globalMultipolek[5] * 0.3333333333333333;
                        double qkzz = globalMultipolek[6] * 0.3333333333333333;
                        double qkxy = globalMultipolek[7] * 0.3333333333333333;
                        double qkxz = globalMultipolek[8] * 0.3333333333333333;
                        double qkyz = globalMultipolek[9] * 0.3333333333333333;
                        double r = FastMath.sqrt((double)r2);
                        if (r < this.this$1.this$0.preconditionerCutoff) {
                            if (preList.length <= preCounts[i]) {
                                int len = preList.length;
                                preLists[i] = Arrays.copyOf(preList, len + 10);
                                preList = preLists[i];
                            }
                            int n3 = i;
                            int n4 = preCounts[n3];
                            preCounts[n3] = n4 + 1;
                            preList[n4] = k;
                        }
                        double ralpha = this.this$1.this$0.aewald * r;
                        double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                        double rr1 = 1.0 / r;
                        double rr2 = rr1 * rr1;
                        double bn0 = Erf.erfc((double)ralpha) * rr1;
                        double bn1 = (bn0 + this.this$1.this$0.an0 * exp2a) * rr2;
                        double bn2 = (3.0 * bn1 + this.this$1.this$0.an1 * exp2a) * rr2;
                        double bn3 = (5.0 * bn2 + this.this$1.this$0.an2 * exp2a) * rr2;
                        double scale3 = 1.0;
                        double scale5 = 1.0;
                        double scale7 = 1.0;
                        double damp = pdi * pdk;
                        double pgamma = FastMath.min((double)pti, (double)ptk);
                        damp = -pgamma * (rdamp = r * damp) * rdamp * rdamp;
                        if (damp > -50.0) {
                            double expdamp = FastMath.exp((double)damp);
                            scale3 = 1.0 - expdamp;
                            scale5 = 1.0 - expdamp * (1.0 - damp);
                            scale7 = 1.0 - expdamp * (1.0 - damp + 0.6 * damp * damp);
                        }
                        double scale = this.inductionMaskLocal[k];
                        double scalep = this.energyMaskLocal[k];
                        double dsc3 = scale3 * scale;
                        double dsc5 = scale5 * scale;
                        double dsc7 = scale7 * scale;
                        double psc3 = scale3 * scalep;
                        double psc5 = scale5 * scalep;
                        double psc7 = scale7 * scalep;
                        double rr3 = rr1 * rr2;
                        double rr5 = 3.0 * rr3 * rr2;
                        double rr7 = 5.0 * rr5 * rr2;
                        double drr3 = (1.0 - dsc3) * rr3;
                        double drr5 = (1.0 - dsc5) * rr5;
                        double drr7 = (1.0 - dsc7) * rr7;
                        double prr3 = (1.0 - psc3) * rr3;
                        double prr5 = (1.0 - psc5) * rr5;
                        double prr7 = (1.0 - psc7) * rr7;
                        double dir = dix * xr + diy * yr + diz * zr;
                        double qix = 2.0 * (qixx * xr + qixy * yr + qixz * zr);
                        double qiy = 2.0 * (qixy * xr + qiyy * yr + qiyz * zr);
                        double qiz = 2.0 * (qixz * xr + qiyz * yr + qizz * zr);
                        double qir = (qix * xr + qiy * yr + qiz * zr) * 0.5;
                        double bn123i = bn1 * ci + bn2 * dir + bn3 * qir;
                        double fkmx = xr * bn123i - bn1 * dix - bn2 * qix;
                        double fkmy = yr * bn123i - bn1 * diy - bn2 * qiy;
                        double fkmz = zr * bn123i - bn1 * diz - bn2 * qiz;
                        double ddr357i = drr3 * ci + drr5 * dir + drr7 * qir;
                        double fkdx = xr * ddr357i - drr3 * dix - drr5 * qix;
                        double fkdy = yr * ddr357i - drr3 * diy - drr5 * qiy;
                        double fkdz = zr * ddr357i - drr3 * diz - drr5 * qiz;
                        this.this$1.this$0.field.add(this.threadID, k, fkmx - fkdx, fkmy - fkdy, fkmz - fkdz);
                        double prr357i = prr3 * ci + prr5 * dir + prr7 * qir;
                        double fkpx = xr * prr357i - prr3 * dix - prr5 * qix;
                        double fkpy = yr * prr357i - prr3 * diy - prr5 * qiy;
                        double fkpz = zr * prr357i - prr3 * diz - prr5 * qiz;
                        this.this$1.this$0.fieldCR.add(this.threadID, k, fkmx - fkpx, fkmy - fkpy, fkmz - fkpz);
                        double dkr = dkx * xr + dky * yr + dkz * zr;
                        double qkx = 2.0 * (qkxx * xr + qkxy * yr + qkxz * zr);
                        double qky = 2.0 * (qkxy * xr + qkyy * yr + qkyz * zr);
                        double qkz = 2.0 * (qkxz * xr + qkyz * yr + qkzz * zr);
                        double qkr = (qkx * xr + qky * yr + qkz * zr) * 0.5;
                        double bn123k = bn1 * ck - bn2 * dkr + bn3 * qkr;
                        double fimx = -xr * bn123k - bn1 * dkx + bn2 * qkx;
                        double fimy = -yr * bn123k - bn1 * dky + bn2 * qky;
                        double fimz = -zr * bn123k - bn1 * dkz + bn2 * qkz;
                        double drr357k = drr3 * ck - drr5 * dkr + drr7 * qkr;
                        double fidx = -xr * drr357k - drr3 * dkx + drr5 * qkx;
                        double fidy = -yr * drr357k - drr3 * dky + drr5 * qky;
                        double fidz = -zr * drr357k - drr3 * dkz + drr5 * qkz;
                        fix += fimx - fidx;
                        fiy += fimy - fidy;
                        fiz += fimz - fidz;
                        double prr357k = prr3 * ck - prr5 * dkr + prr7 * qkr;
                        double fipx = -xr * prr357k - prr3 * dkx + prr5 * qkx;
                        double fipy = -yr * prr357k - prr3 * dky + prr5 * qky;
                        double fipz = -zr * prr357k - prr3 * dkz + prr5 * qkz;
                        fixCR += fimx - fipx;
                        fiyCR += fimy - fipy;
                        fizCR += fimz - fipz;
                    }
                    this.this$1.this$0.field.add(this.threadID, i, fix, fiy, fiz);
                    this.this$1.this$0.fieldCR.add(this.threadID, i, fixCR, fiyCR, fizCR);
                    this.this$1.this$0.removeMask(i, null, this.energyMaskLocal, this.inductionMaskLocal);
                }
                List symOps = this.this$1.this$0.crystal.spaceGroup.symOps;
                int nSymm = symOps.size();
                for (int iSymm = 1; iSymm < nSymm; ++iSymm) {
                    SymOp symOp = this.this$1.this$0.crystal.spaceGroup.getSymOp(iSymm);
                    this.this$1.this$0.crystal.getTransformationOperator(symOp, this.transOp);
                    lists = this.this$1.this$0.neighborLists[iSymm];
                    ewalds = this.this$1.this$0.realSpaceLists[iSymm];
                    counts = this.this$1.this$0.realSpaceCounts[iSymm];
                    preLists = this.this$1.this$0.preconditionerLists[iSymm];
                    preCounts = this.this$1.this$0.preconditionerCounts[iSymm];
                    double[] xs = this.this$1.this$0.coordinates[iSymm][0];
                    double[] ys = this.this$1.this$0.coordinates[iSymm][1];
                    double[] zs = this.this$1.this$0.coordinates[iSymm][2];
                    double[][] mpoles = this.this$1.this$0.globalMultipole[iSymm];
                    for (int i = lb; i <= ub; ++i) {
                        if (!this.this$1.this$0.use[i]) continue;
                        double fix = 0.0;
                        double fiy = 0.0;
                        double fiz = 0.0;
                        double pdi = this.this$1.this$0.ipdamp[i];
                        double pti = this.this$1.this$0.thole[i];
                        double[] multipolei = mpole[i];
                        double ci = multipolei[0];
                        double dix = multipolei[1];
                        double diy = multipolei[2];
                        double diz = multipolei[3];
                        double qixx = multipolei[4] * 0.3333333333333333;
                        double qiyy = multipolei[5] * 0.3333333333333333;
                        double qizz = multipolei[6] * 0.3333333333333333;
                        double qixy = multipolei[7] * 0.3333333333333333;
                        double qixz = multipolei[8] * 0.3333333333333333;
                        double qiyz = multipolei[9] * 0.3333333333333333;
                        double xi = x[i];
                        double yi = y[i];
                        double zi = z[i];
                        int[] list = lists[i];
                        counts[i] = 0;
                        preCounts[i] = 0;
                        int[] ewald = ewalds[i];
                        int[] preList = preLists[i];
                        for (int k : list) {
                            double rdamp;
                            if (!this.this$1.this$0.use[k]) continue;
                            double xk = xs[k];
                            double yk = ys[k];
                            double zk = zs[k];
                            this.dx_local[0] = xk - xi;
                            this.dx_local[1] = yk - yi;
                            this.dx_local[2] = zk - zi;
                            double r2 = this.this$1.this$0.crystal.image(this.dx_local);
                            if (!(r2 <= this.this$1.this$0.off2)) continue;
                            ++this.count;
                            if (ewald.length <= counts[i]) {
                                int len = ewald.length;
                                ewalds[i] = Arrays.copyOf(ewald, len + 10);
                                ewald = ewalds[i];
                            }
                            int n = i;
                            int n5 = counts[n];
                            counts[n] = n5 + 1;
                            ewald[n5] = k;
                            double selfScale = 1.0;
                            if (i == k) {
                                selfScale = 0.5;
                            }
                            double xr = this.dx_local[0];
                            double yr = this.dx_local[1];
                            double zr = this.dx_local[2];
                            double pdk = this.this$1.this$0.ipdamp[k];
                            double ptk = this.this$1.this$0.thole[k];
                            double[] multipolek = mpoles[k];
                            double ck = multipolek[0];
                            double dkx = multipolek[1];
                            double dky = multipolek[2];
                            double dkz = multipolek[3];
                            double qkxx = multipolek[4] * 0.3333333333333333;
                            double qkyy = multipolek[5] * 0.3333333333333333;
                            double qkzz = multipolek[6] * 0.3333333333333333;
                            double qkxy = multipolek[7] * 0.3333333333333333;
                            double qkxz = multipolek[8] * 0.3333333333333333;
                            double qkyz = multipolek[9] * 0.3333333333333333;
                            double r = FastMath.sqrt((double)r2);
                            if (r < this.this$1.this$0.preconditionerCutoff) {
                                if (preList.length <= preCounts[i]) {
                                    int len = preList.length;
                                    preLists[i] = Arrays.copyOf(preList, len + 10);
                                    preList = preLists[i];
                                }
                                int n6 = i;
                                int n7 = preCounts[n6];
                                preCounts[n6] = n7 + 1;
                                preList[n7] = k;
                            }
                            double ralpha = this.this$1.this$0.aewald * r;
                            double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                            double rr1 = 1.0 / r;
                            double rr2 = rr1 * rr1;
                            double bn0 = Erf.erfc((double)ralpha) * rr1;
                            double bn1 = (bn0 + this.this$1.this$0.an0 * exp2a) * rr2;
                            double bn2 = (3.0 * bn1 + this.this$1.this$0.an1 * exp2a) * rr2;
                            double bn3 = (5.0 * bn2 + this.this$1.this$0.an2 * exp2a) * rr2;
                            double scale3 = 1.0;
                            double scale5 = 1.0;
                            double scale7 = 1.0;
                            double damp = pdi * pdk;
                            double pgamma = FastMath.min((double)pti, (double)ptk);
                            damp = -pgamma * (rdamp = r * damp) * rdamp * rdamp;
                            if (damp > -50.0) {
                                double expdamp = FastMath.exp((double)damp);
                                scale3 = 1.0 - expdamp;
                                scale5 = 1.0 - expdamp * (1.0 - damp);
                                scale7 = 1.0 - expdamp * (1.0 - damp + 0.6 * damp * damp);
                            }
                            double dsc3 = scale3;
                            double dsc5 = scale5;
                            double dsc7 = scale7;
                            double rr3 = rr1 * rr2;
                            double rr5 = 3.0 * rr3 * rr2;
                            double rr7 = 5.0 * rr5 * rr2;
                            double drr3 = (1.0 - dsc3) * rr3;
                            double drr5 = (1.0 - dsc5) * rr5;
                            double drr7 = (1.0 - dsc7) * rr7;
                            double dkr = dkx * xr + dky * yr + dkz * zr;
                            double qkx = 2.0 * (qkxx * xr + qkxy * yr + qkxz * zr);
                            double qky = 2.0 * (qkxy * xr + qkyy * yr + qkyz * zr);
                            double qkz = 2.0 * (qkxz * xr + qkyz * yr + qkzz * zr);
                            double qkr = (qkx * xr + qky * yr + qkz * zr) * 0.5;
                            double bn123k = bn1 * ck - bn2 * dkr + bn3 * qkr;
                            double drr357k = drr3 * ck - drr5 * dkr + drr7 * qkr;
                            double fimx = -xr * bn123k - bn1 * dkx + bn2 * qkx;
                            double fimy = -yr * bn123k - bn1 * dky + bn2 * qky;
                            double fimz = -zr * bn123k - bn1 * dkz + bn2 * qkz;
                            double fidx = -xr * drr357k - drr3 * dkx + drr5 * qkx;
                            double fidy = -yr * drr357k - drr3 * dky + drr5 * qky;
                            double fidz = -zr * drr357k - drr3 * dkz + drr5 * qkz;
                            double dir = dix * xr + diy * yr + diz * zr;
                            double qix = 2.0 * (qixx * xr + qixy * yr + qixz * zr);
                            double qiy = 2.0 * (qixy * xr + qiyy * yr + qiyz * zr);
                            double qiz = 2.0 * (qixz * xr + qiyz * yr + qizz * zr);
                            double qir = (qix * xr + qiy * yr + qiz * zr) * 0.5;
                            double bn123i = bn1 * ci + bn2 * dir + bn3 * qir;
                            double ddr357i = drr3 * ci + drr5 * dir + drr7 * qir;
                            double fkmx = xr * bn123i - bn1 * dix - bn2 * qix;
                            double fkmy = yr * bn123i - bn1 * diy - bn2 * qiy;
                            double fkmz = zr * bn123i - bn1 * diz - bn2 * qiz;
                            double fkdx = xr * ddr357i - drr3 * dix - drr5 * qix;
                            double fkdy = yr * ddr357i - drr3 * diy - drr5 * qiy;
                            double fkdz = zr * ddr357i - drr3 * diz - drr5 * qiz;
                            fix += selfScale * (fimx - fidx);
                            fiy += selfScale * (fimy - fidy);
                            fiz += selfScale * (fimz - fidz);
                            double xc = selfScale * (fkmx - fkdx);
                            double yc = selfScale * (fkmy - fkdy);
                            double zc = selfScale * (fkmz - fkdz);
                            double fkx = xc * this.transOp[0][0] + yc * this.transOp[1][0] + zc * this.transOp[2][0];
                            double fky = xc * this.transOp[0][1] + yc * this.transOp[1][1] + zc * this.transOp[2][1];
                            double fkz = xc * this.transOp[0][2] + yc * this.transOp[1][2] + zc * this.transOp[2][2];
                            this.this$1.this$0.field.add(this.threadID, k, fkx, fky, fkz);
                            this.this$1.this$0.fieldCR.add(this.threadID, k, fkx, fky, fkz);
                        }
                        this.this$1.this$0.field.add(this.threadID, i, fix, fiy, fiz);
                        this.this$1.this$0.fieldCR.add(this.threadID, i, fix, fiy, fiz);
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.permanentSchedule;
            }

            public void start() {
                this.time = -System.nanoTime();
                this.threadID = this.getThreadIndex();
                this.count = 0;
                int nAtoms = this.this$1.this$0.atoms.length;
                if (this.inductionMaskLocal == null || this.inductionMaskLocal.length < nAtoms) {
                    this.inductionMaskLocal = new double[nAtoms];
                    this.energyMaskLocal = new double[nAtoms];
                    Arrays.fill(this.inductionMaskLocal, 1.0);
                    Arrays.fill(this.energyMaskLocal, 1.0);
                }
            }
        }
    }
}

