/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.multipole.GKSource;
import ffx.potential.bonded.Atom;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class PermanentGKFieldRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(PermanentGKFieldRegion.class.getName());
    private static final double oneThird = 0.3333333333333333;
    private final double gkc;
    private final double fc;
    private final double fd;
    private final double fq;
    private final PermanentGKFieldLoop[] permanentGKFieldLoop;
    protected Atom[] atoms;
    private double[][][] globalMultipole;
    private Crystal crystal;
    private double[][][] sXYZ;
    private int[][][] neighborLists;
    private boolean[] use = null;
    private double cut2;
    private double[] born;
    private AtomicDoubleArray3D sharedGKField;

    public PermanentGKFieldRegion(int nt, double soluteDieletric, double solventDieletric, double gkc) {
        this.fc = GKSource.cn((int)0, (double)soluteDieletric, (double)solventDieletric);
        this.fd = GKSource.cn((int)1, (double)soluteDieletric, (double)solventDieletric);
        this.fq = GKSource.cn((int)2, (double)soluteDieletric, (double)solventDieletric);
        this.gkc = gkc;
        this.permanentGKFieldLoop = new PermanentGKFieldLoop[nt];
        for (int i = 0; i < nt; ++i) {
            this.permanentGKFieldLoop[i] = new PermanentGKFieldLoop(this);
        }
    }

    public void init(Atom[] atoms, double[][][] globalMultipole, Crystal crystal, double[][][] sXYZ, int[][][] neighborLists, boolean[] use, double cut2, double[] born, AtomicDoubleArray3D sharedGKField) {
        this.atoms = atoms;
        this.globalMultipole = globalMultipole;
        this.crystal = crystal;
        this.sXYZ = sXYZ;
        this.neighborLists = neighborLists;
        this.use = use;
        this.cut2 = cut2;
        this.born = born;
        this.sharedGKField = sharedGKField;
    }

    public void run() {
        try {
            int threadIndex = this.getThreadIndex();
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.permanentGKFieldLoop[threadIndex]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing GK Energy in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class PermanentGKFieldLoop
    extends IntegerForLoop {
        private final double[][] a;
        private final double[] gc;
        private final double[] gux;
        private final double[] guy;
        private final double[] guz;
        private final double[] gqxx;
        private final double[] gqyy;
        private final double[] gqzz;
        private final double[] gqxy;
        private final double[] gqxz;
        private final double[] gqyz;
        private final double[] dx_local;
        private int threadID;
        private double xi;
        private double yi;
        private double zi;
        private double ci;
        private double uxi;
        private double uyi;
        private double uzi;
        private double qxxi;
        private double qxyi;
        private double qxzi;
        private double qyyi;
        private double qyzi;
        private double qzzi;
        private double rbi;
        private int iSymm;
        private double[][] transOp;
        final /* synthetic */ PermanentGKFieldRegion this$0;

        PermanentGKFieldLoop(PermanentGKFieldRegion permanentGKFieldRegion) {
            PermanentGKFieldRegion permanentGKFieldRegion2 = permanentGKFieldRegion;
            Objects.requireNonNull(permanentGKFieldRegion2);
            this.this$0 = permanentGKFieldRegion2;
            this.a = new double[4][3];
            this.gc = new double[11];
            this.gux = new double[11];
            this.guy = new double[11];
            this.guz = new double[11];
            this.gqxx = new double[11];
            this.gqyy = new double[11];
            this.gqzz = new double[11];
            this.gqxy = new double[11];
            this.gqxz = new double[11];
            this.gqyz = new double[11];
            this.dx_local = new double[3];
            this.transOp = new double[3][3];
        }

        public void run(int lb, int ub) {
            this.threadID = this.getThreadIndex();
            double[] x = this.this$0.sXYZ[0][0];
            double[] y = this.this$0.sXYZ[0][1];
            double[] z = this.this$0.sXYZ[0][2];
            int nSymm = this.this$0.crystal.spaceGroup.symOps.size();
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            this.iSymm = 0;
            while (this.iSymm < nSymm) {
                SymOp symOp = (SymOp)symOps.get(this.iSymm);
                this.this$0.crystal.getTransformationOperator(symOp, this.transOp);
                for (int i = lb; i <= ub; ++i) {
                    int[] list;
                    if (!this.this$0.use[i]) continue;
                    this.xi = x[i];
                    this.yi = y[i];
                    this.zi = z[i];
                    double[] multipolei = this.this$0.globalMultipole[0][i];
                    this.ci = multipolei[0];
                    this.uxi = multipolei[1];
                    this.uyi = multipolei[2];
                    this.uzi = multipolei[3];
                    this.qxxi = multipolei[4] * 0.3333333333333333;
                    this.qxyi = multipolei[7] * 0.3333333333333333;
                    this.qxzi = multipolei[8] * 0.3333333333333333;
                    this.qyyi = multipolei[5] * 0.3333333333333333;
                    this.qyzi = multipolei[9] * 0.3333333333333333;
                    this.qzzi = multipolei[6] * 0.3333333333333333;
                    this.rbi = this.this$0.born[i];
                    for (int k : list = this.this$0.neighborLists[this.iSymm][i]) {
                        if (!this.this$0.use[k]) continue;
                        this.permanentGKField(i, k);
                    }
                    if (this.iSymm != 0) continue;
                    this.permanentGKField(i, i);
                }
                ++this.iSymm;
            }
        }

        private void permanentGKField(int i, int k) {
            this.dx_local[0] = this.this$0.sXYZ[this.iSymm][0][k] - this.xi;
            this.dx_local[1] = this.this$0.sXYZ[this.iSymm][1][k] - this.yi;
            this.dx_local[2] = this.this$0.sXYZ[this.iSymm][2][k] - this.zi;
            double r2 = this.this$0.crystal.image(this.dx_local);
            if (r2 > this.this$0.cut2) {
                return;
            }
            double xr = this.dx_local[0];
            double yr = this.dx_local[1];
            double zr = this.dx_local[2];
            double xr2 = xr * xr;
            double yr2 = yr * yr;
            double zr2 = zr * zr;
            double rbk = this.this$0.born[k];
            double[] multipolek = this.this$0.globalMultipole[this.iSymm][k];
            double ck = multipolek[0];
            double uxk = multipolek[1];
            double uyk = multipolek[2];
            double uzk = multipolek[3];
            double qxxk = multipolek[4] * 0.3333333333333333;
            double qxyk = multipolek[7] * 0.3333333333333333;
            double qxzk = multipolek[8] * 0.3333333333333333;
            double qyyk = multipolek[5] * 0.3333333333333333;
            double qyzk = multipolek[9] * 0.3333333333333333;
            double qzzk = multipolek[6] * 0.3333333333333333;
            double rb2 = this.rbi * rbk;
            double expterm = FastMath.exp((double)(-r2 / (this.this$0.gkc * rb2)));
            double expc = expterm / this.this$0.gkc;
            double expc1 = 1.0 - expc;
            double dexpc = -2.0 / (this.this$0.gkc * rb2);
            double expcdexpc = -expc * dexpc;
            double gf2 = 1.0 / (r2 + rb2 * expterm);
            double gf = FastMath.sqrt((double)gf2);
            double gf3 = gf2 * gf;
            double gf5 = gf3 * gf2;
            double gf7 = gf5 * gf2;
            this.a[0][0] = gf;
            this.a[1][0] = -gf3;
            this.a[2][0] = 3.0 * gf5;
            this.a[3][0] = -15.0 * gf7;
            this.a[0][1] = expc1 * this.a[1][0];
            this.a[1][1] = expc1 * this.a[2][0];
            this.a[2][1] = expc1 * this.a[3][0];
            this.a[1][2] = expc1 * this.a[2][1] + expcdexpc * this.a[2][0];
            this.a[0][1] = this.this$0.fc * this.a[0][1];
            this.a[1][0] = this.this$0.fd * this.a[1][0];
            this.a[1][1] = this.this$0.fd * this.a[1][1];
            this.a[1][2] = this.this$0.fd * this.a[1][2];
            this.a[2][0] = this.this$0.fq * this.a[2][0];
            this.a[2][1] = this.this$0.fq * this.a[2][1];
            this.gux[1] = xr * this.a[1][0];
            this.guy[1] = yr * this.a[1][0];
            this.guz[1] = zr * this.a[1][0];
            this.gc[2] = xr * this.a[0][1];
            this.gc[3] = yr * this.a[0][1];
            this.gc[4] = zr * this.a[0][1];
            this.gux[2] = this.a[1][0] + xr2 * this.a[1][1];
            this.gux[3] = xr * yr * this.a[1][1];
            this.gux[4] = xr * zr * this.a[1][1];
            this.guy[2] = this.gux[3];
            this.guy[3] = this.a[1][0] + yr2 * this.a[1][1];
            this.guy[4] = yr * zr * this.a[1][1];
            this.guz[2] = this.gux[4];
            this.guz[3] = this.guy[4];
            this.guz[4] = this.a[1][0] + zr2 * this.a[1][1];
            this.gqxx[2] = xr * (2.0 * this.a[2][0] + xr2 * this.a[2][1]);
            this.gqxx[3] = yr * xr2 * this.a[2][1];
            this.gqxx[4] = zr * xr2 * this.a[2][1];
            this.gqyy[2] = xr * yr2 * this.a[2][1];
            this.gqyy[3] = yr * (2.0 * this.a[2][0] + yr2 * this.a[2][1]);
            this.gqyy[4] = zr * yr2 * this.a[2][1];
            this.gqzz[2] = xr * zr2 * this.a[2][1];
            this.gqzz[3] = yr * zr2 * this.a[2][1];
            this.gqzz[4] = zr * (2.0 * this.a[2][0] + zr2 * this.a[2][1]);
            this.gqxy[2] = yr * (this.a[2][0] + xr2 * this.a[2][1]);
            this.gqxy[3] = xr * (this.a[2][0] + yr2 * this.a[2][1]);
            this.gqxy[4] = zr * xr * yr * this.a[2][1];
            this.gqxz[2] = zr * (this.a[2][0] + xr2 * this.a[2][1]);
            this.gqxz[3] = this.gqxy[4];
            this.gqxz[4] = xr * (this.a[2][0] + zr2 * this.a[2][1]);
            this.gqyz[2] = this.gqxy[4];
            this.gqyz[3] = zr * (this.a[2][0] + yr2 * this.a[2][1]);
            this.gqyz[4] = yr * (this.a[2][0] + zr2 * this.a[2][1]);
            this.gux[5] = xr * (3.0 * this.a[1][1] + xr2 * this.a[1][2]);
            this.gux[6] = yr * (this.a[1][1] + xr2 * this.a[1][2]);
            this.gux[7] = zr * (this.a[1][1] + xr2 * this.a[1][2]);
            this.gux[8] = xr * (this.a[1][1] + yr2 * this.a[1][2]);
            this.gux[9] = zr * xr * yr * this.a[1][2];
            this.gux[10] = xr * (this.a[1][1] + zr2 * this.a[1][2]);
            this.guy[5] = yr * (this.a[1][1] + xr2 * this.a[1][2]);
            this.guy[6] = xr * (this.a[1][1] + yr2 * this.a[1][2]);
            this.guy[7] = this.gux[9];
            this.guy[8] = yr * (3.0 * this.a[1][1] + yr2 * this.a[1][2]);
            this.guy[9] = zr * (this.a[1][1] + yr2 * this.a[1][2]);
            this.guy[10] = yr * (this.a[1][1] + zr2 * this.a[1][2]);
            this.guz[5] = zr * (this.a[1][1] + xr2 * this.a[1][2]);
            this.guz[6] = this.gux[9];
            this.guz[7] = xr * (this.a[1][1] + zr2 * this.a[1][2]);
            this.guz[8] = zr * (this.a[1][1] + yr2 * this.a[1][2]);
            this.guz[9] = yr * (this.a[1][1] + zr2 * this.a[1][2]);
            this.guz[10] = zr * (3.0 * this.a[1][1] + zr2 * this.a[1][2]);
            double fix = uxk * this.gux[2] + uyk * this.gux[3] + uzk * this.gux[4] + 0.5 * (ck * this.gux[1] + qxxk * this.gux[5] + qyyk * this.gux[8] + qzzk * this.gux[10] + 2.0 * (qxyk * this.gux[6] + qxzk * this.gux[7] + qyzk * this.gux[9])) + 0.5 * (ck * this.gc[2] + qxxk * this.gqxx[2] + qyyk * this.gqyy[2] + qzzk * this.gqzz[2] + 2.0 * (qxyk * this.gqxy[2] + qxzk * this.gqxz[2] + qyzk * this.gqyz[2]));
            double fiy = uxk * this.guy[2] + uyk * this.guy[3] + uzk * this.guy[4] + 0.5 * (ck * this.guy[1] + qxxk * this.guy[5] + qyyk * this.guy[8] + qzzk * this.guy[10] + 2.0 * (qxyk * this.guy[6] + qxzk * this.guy[7] + qyzk * this.guy[9])) + 0.5 * (ck * this.gc[3] + qxxk * this.gqxx[3] + qyyk * this.gqyy[3] + qzzk * this.gqzz[3] + 2.0 * (qxyk * this.gqxy[3] + qxzk * this.gqxz[3] + qyzk * this.gqyz[3]));
            double fiz = uxk * this.guz[2] + uyk * this.guz[3] + uzk * this.guz[4] + 0.5 * (ck * this.guz[1] + qxxk * this.guz[5] + qyyk * this.guz[8] + qzzk * this.guz[10] + 2.0 * (qxyk * this.guz[6] + qxzk * this.guz[7] + qyzk * this.guz[9])) + 0.5 * (ck * this.gc[4] + qxxk * this.gqxx[4] + qyyk * this.gqyy[4] + qzzk * this.gqzz[4] + 2.0 * (qxyk * this.gqxy[4] + qxzk * this.gqxz[4] + qyzk * this.gqyz[4]));
            double fkx = this.uxi * this.gux[2] + this.uyi * this.gux[3] + this.uzi * this.gux[4] - 0.5 * (this.ci * this.gux[1] + this.qxxi * this.gux[5] + this.qyyi * this.gux[8] + this.qzzi * this.gux[10] + 2.0 * (this.qxyi * this.gux[6] + this.qxzi * this.gux[7] + this.qyzi * this.gux[9])) - 0.5 * (this.ci * this.gc[2] + this.qxxi * this.gqxx[2] + this.qyyi * this.gqyy[2] + this.qzzi * this.gqzz[2] + 2.0 * (this.qxyi * this.gqxy[2] + this.qxzi * this.gqxz[2] + this.qyzi * this.gqyz[2]));
            double fky = this.uxi * this.guy[2] + this.uyi * this.guy[3] + this.uzi * this.guy[4] - 0.5 * (this.ci * this.guy[1] + this.qxxi * this.guy[5] + this.qyyi * this.guy[8] + this.qzzi * this.guy[10] + 2.0 * (this.qxyi * this.guy[6] + this.qxzi * this.guy[7] + this.qyzi * this.guy[9])) - 0.5 * (this.ci * this.gc[3] + this.qxxi * this.gqxx[3] + this.qyyi * this.gqyy[3] + this.qzzi * this.gqzz[3] + 2.0 * (this.qxyi * this.gqxy[3] + this.qxzi * this.gqxz[3] + this.qyzi * this.gqyz[3]));
            double fkz = this.uxi * this.guz[2] + this.uyi * this.guz[3] + this.uzi * this.guz[4] - 0.5 * (this.ci * this.guz[1] + this.qxxi * this.guz[5] + this.qyyi * this.guz[8] + this.qzzi * this.guz[10] + 2.0 * (this.qxyi * this.guz[6] + this.qxzi * this.guz[7] + this.qyzi * this.guz[9])) - 0.5 * (this.ci * this.gc[4] + this.qxxi * this.gqxx[4] + this.qyyi * this.gqyy[4] + this.qzzi * this.gqzz[4] + 2.0 * (this.qxyi * this.gqxy[4] + this.qxzi * this.gqxz[4] + this.qyzi * this.gqyz[4]));
            if (i == k) {
                fix *= 0.5;
                fiy *= 0.5;
                fiz *= 0.5;
                fkx *= 0.5;
                fky *= 0.5;
                fkz *= 0.5;
            }
            double xc = fkx;
            double yc = fky;
            double zc = fkz;
            fkx = xc * this.transOp[0][0] + yc * this.transOp[1][0] + zc * this.transOp[2][0];
            fky = xc * this.transOp[0][1] + yc * this.transOp[1][1] + zc * this.transOp[2][1];
            fkz = xc * this.transOp[0][2] + yc * this.transOp[1][2] + zc * this.transOp[2][2];
            this.this$0.sharedGKField.add(this.threadID, i, fix, fiy, fiz);
            this.this$0.sharedGKField.add(this.threadID, k, fkx, fky, fkz);
        }
    }
}

