/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class NeckIntegral {
    private static final Logger logger = Logger.getLogger(NeckIntegral.class.getName());
    private static final double[] radArray = new double[]{0.8, 0.85, 0.9, 0.95, 1.0, 1.05, 1.1, 1.15, 1.2, 1.25, 1.3, 1.35, 1.4, 1.45, 1.5, 1.55, 1.6, 1.65, 1.7, 1.75, 1.8, 1.85, 1.9, 1.95, 2.0, 2.05, 2.1, 2.15, 2.2, 2.25, 2.3, 2.35, 2.4, 2.45, 2.5, 2.55, 2.6, 2.65, 2.7, 2.75, 2.8, 2.85, 2.9, 2.95, 3.0};
    private static final double MINIMUM_RADIUS = 0.8;
    private static final double MAXIMUM_RADIUS = 3.0;
    private static final double SPACING = 0.05;
    private static final int NUM_POINTS = radArray.length;
    private static final double[][] Aij = new double[][]{{5.77616E-5, 5.84661E-5, 3.63925E-5, 3.95472E-5, 4.43202E-5, 4.85507E-5, 4.30862E-5, 4.85067E-5, 2.44504E-5, 2.78293E-5, 3.29908E-5, 2.92135E-5, 3.43621E-5, 3.93724E-5, 3.52501E-5, 3.03823E-5, 3.60595E-5, 4.1869E-5, 3.65804E-5, 2.48824E-5, 3.75656E-5, 4.28918E-5, 3.7745E-5, 4.4716E-5, 3.95375E-5, 3.45934E-5, 5.36114E-5, 4.70958E-5, 5.42111E-5, 3.60263E-5, 5.53398E-5, 4.83197E-5, 5.55466E-5, 3.7429E-5, 3.27412E-5, 3.86635E-5, 5.78345E-5, 5.13194E-5, 5.81077E-5, 3.94022E-5, 5.99546E-5, 3.92112E-5, 5.97613E-5, 4.03186E-5, 6.15149E-5}, {4.46374E-5, 4.60309E-5, 4.75714E-5, 2.25974E-5, 3.18052E-5, 2.75537E-5, 2.96576E-5, 3.39157E-5, 2.95595E-5, 3.44661E-5, 3.95587E-5, 1.97502E-5, 3.00923E-5, 2.72524E-5, 1.87561E-5, 2.7268E-5, 2.47659E-5, 2.14933E-5, 2.5285E-5, 2.23386E-5, 2.61633E-5, 3.98363E-5, 3.63492E-5, 4.12599E-5, 3.63327E-5, 4.22768E-5, 3.67723E-5, 4.25282E-5, 3.74607E-5, 3.25975E-5, 3.83563E-5, 2.53707E-5, 3.01193E-5, 2.00866E-5, 2.99808E-5, 2.63514E-5, 3.0424E-5, 3.49497E-5, 4.08533E-5, 2.68003E-5, 4.07538E-5, 3.57651E-5, 4.18473E-5, 2.78226E-5, 4.19066E-5}, {3.60721E-5, 3.65794E-5, 3.72415E-5, 3.03637E-5, 3.19835E-5, 2.67215E-5, 1.71087E-5, 2.52702E-5, 2.21094E-5, 1.87747E-5, 2.12341E-5, 2.51617E-5, 2.15761E-5, 1.91079E-5, 2.91389E-5, 1.99177E-5, 2.88958E-5, 2.60343E-5, 1.79669E-5, 2.10581E-5, 1.7882E-5, 2.15615E-5, 2.43911E-5, 2.20007E-5, 2.49689E-5, 2.95075E-5, 2.60062E-5, 2.9705E-5, 2.03093E-5, 3.05802E-5, 2.02272E-5, 3.08984E-5, 2.0793E-5, 3.16764E-5, 2.77135E-5, 3.16983E-5, 2.19362E-5, 3.26865E-5, 2.86724E-5, 3.32929E-5, 2.20858E-5, 3.32871E-5, 2.94921E-5, 3.48374E-5, 2.30989E-5}, {3.98429E-5, 2.23074E-5, 2.98279E-5, 3.15221E-5, 1.87855E-5, 2.64807E-5, 1.69459E-5, 1.80824E-5, 1.62496E-5, 2.33148E-5, 1.57394E-5, 1.74931E-5, 1.52866E-5, 2.3062E-5, 2.05539E-5, 2.34872E-5, 2.13273E-5, 1.81123E-5, 2.10938E-5, 1.86307E-5, 2.16437E-5, 1.46084E-5, 2.2285E-5, 1.49429E-5, 1.70964E-5, 1.53536E-5, 1.77037E-5, 2.08958E-5, 2.37412E-5, 1.64214E-5, 2.39561E-5, 1.66849E-5, 1.88702E-5, 1.67221E-5, 1.88448E-5, 1.72644E-5, 1.94706E-5, 1.74585E-5, 2.59642E-5, 1.77409E-5, 1.99219E-5, 2.3599E-5, 2.02504E-5, 2.34495E-5, 1.56052E-5}, {4.35754E-5, 2.45527E-5, 3.18302E-5, 1.88461E-5, 1.92238E-5, 2.08396E-5, 1.69209E-5, 1.83816E-5, 2.04363E-5, 1.31412E-5, 1.93141E-5, 9.7655E-6, 1.10841E-5, 1.29627E-5, 1.12003E-5, 1.30467E-5, 1.13669E-5, 1.68195E-5, 1.17549E-5, 1.34876E-5, 1.18881E-5, 1.80528E-5, 1.59126E-5, 1.81928E-5, 1.2594E-5, 1.83351E-5, 1.25678E-5, 1.45035E-5, 1.31847E-5, 1.44906E-5, 1.2984E-5, 1.50912E-5, 1.76485E-5, 1.53063E-5, 1.78114E-5, 1.57934E-5, 1.80763E-5, 1.57725E-5, 1.86835E-5, 1.21847E-5, 1.85069E-5, 1.619E-5, 1.91223E-5, 1.26643E-5, 1.92108E-5}, {5.0558E-5, 2.64633E-5, 2.05166E-5, 1.95164E-5, 2.04987E-5, 1.60556E-5, 1.27648E-5, 1.37952E-5, 1.55458E-5, 1.764E-5, 1.46241E-5, 1.24027E-5, 1.03247E-5, 1.20745E-5, 1.05222E-5, 1.24882E-5, 1.40152E-5, 9.5449E-6, 1.41168E-5, 7.4383E-6, 1.42994E-5, 9.8671E-6, 1.12045E-5, 1.32832E-5, 1.13876E-5, 1.35139E-5, 1.16918E-5, 1.37152E-5, 1.18068E-5, 1.40495E-5, 9.3075E-6, 1.44645E-5, 1.26001E-5, 1.42255E-5, 1.28571E-5, 1.48412E-5, 1.28819E-5, 1.52166E-5, 9.9735E-6, 1.51882E-5, 1.33944E-5, 1.54829E-5, 1.35105E-5, 1.54771E-5, 1.06154E-5}, {4.49657E-5, 2.30612E-5, 2.21541E-5, 1.66532E-5, 1.71555E-5, 2.27174E-5, 1.82899E-5, 1.93198E-5, 1.18768E-5, 1.30396E-5, 1.13361E-5, 9.3799E-6, 1.08573E-5, 1.20843E-5, 1.06342E-5, 1.17938E-5, 8.0569E-6, 9.1361E-6, 1.07718E-5, 1.23647E-5, 1.06453E-5, 1.23678E-5, 1.09954E-5, 1.26151E-5, 1.45692E-5, 1.28038E-5, 1.46248E-5, 9.9091E-6, 1.142E-5, 5.9787E-6, 1.17991E-5, 1.3637E-5, 1.1983E-5, 8.088E-6, 1.20147E-5, 1.0897E-5, 1.61522E-5, 8.3711E-6, 9.498E-6, 1.12647E-5, 9.6319E-6, 1.13677E-5, 1.27823E-5, 1.14549E-5, 1.00471E-5}, {2.8051E-5, 2.66023E-5, 1.44227E-5, 1.88499E-5, 1.84712E-5, 1.46008E-5, 1.95724E-5, 1.61268E-5, 7.3492E-6, 1.37704E-5, 1.11866E-5, 7.2795E-6, 8.1037E-6, 9.2319E-6, 7.8144E-6, 8.9354E-6, 1.02556E-5, 9.0005E-6, 5.9425E-6, 9.0194E-6, 8.0186E-6, 6.9127E-6, 8.2105E-6, 9.3797E-6, 8.2401E-6, 9.3675E-6, 8.2671E-6, 7.1727E-6, 6.4889E-6, 9.7376E-6, 8.7729E-6, 9.8019E-6, 8.8064E-6, 5.9057E-6, 8.9896E-6, 7.7635E-6, 7.0336E-6, 4.787E-6, 9.4273E-6, 8.0466E-6, 9.3429E-6, 8.3051E-6, 9.6725E-6, 1.09657E-5, 9.7148E-6}, {3.25317E-5, 2.95175E-5, 2.13868E-5, 2.08878E-5, 1.53087E-5, 1.16695E-5, 9.1353E-6, 1.28753E-5, 1.02693E-5, 1.07086E-5, 8.85E-6, 9.8955E-6, 8.1413E-6, 5.2255E-6, 7.8083E-6, 6.7997E-6, 9.8737E-6, 6.6979E-6, 9.8507E-6, 5.1252E-6, 7.4307E-6, 6.7922E-6, 5.7491E-6, 6.8223E-6, 5.892E-6, 7.042E-6, 6.0742E-6, 6.9635E-6, 6.2687E-6, 5.4473E-6, 6.1911E-6, 7.3394E-6, 3.7836E-6, 7.4661E-6, 8.4983E-6, 7.3838E-6, 8.7027E-6, 7.6952E-6, 8.8636E-6, 1.02208E-5, 9.0108E-6, 1.04452E-5, 9.0944E-6, 1.04765E-5, 7.0232E-6}, {2.89111E-5, 1.98943E-5, 2.41993E-5, 2.38536E-5, 1.82705E-5, 1.29878E-5, 7.6255E-6, 1.02719E-5, 1.12418E-5, 6.7659E-6, 7.1756E-6, 1.00155E-5, 6.53E-6, 7.1811E-6, 6.0818E-6, 6.6768E-6, 5.9369E-6, 6.5993E-6, 7.6971E-6, 6.3984E-6, 5.7069E-6, 8.6185E-6, 7.6581E-6, 5.1018E-6, 5.7661E-6, 5.1292E-6, 5.8121E-6, 5.0955E-6, 7.9236E-6, 6.9082E-6, 6.0582E-6, 4.1682E-6, 8.0245E-6, 4.2302E-6, 8.2046E-6, 5.6029E-6, 4.828E-6, 5.7624E-6, 6.5014E-6, 5.8246E-6, 4.9969E-6, 5.8491E-6, 6.6001E-6, 5.9999E-6, 8.8507E-6}, {2.65006E-5, 3.02279E-5, 2.15102E-5, 2.03741E-5, 1.95197E-5, 1.14271E-5, 1.10442E-5, 1.13577E-5, 6.7378E-6, 7.2687E-6, 7.4058E-6, 4.7733E-6, 6.7184E-6, 7.6291E-6, 6.2951E-6, 5.1957E-6, 4.4871E-6, 5.0768E-6, 4.4211E-6, 4.988E-6, 4.3518E-6, 4.8796E-6, 5.7445E-6, 4.9576E-6, 5.7224E-6, 3.7798E-6, 4.3883E-6, 6.6161E-6, 4.4279E-6, 5.058E-6, 4.5758E-6, 5.1723E-6, 4.6936E-6, 5.2703E-6, 4.7182E-6, 4.1352E-6, 6.3088E-6, 4.1672E-6, 6.3473E-6, 5.5519E-6, 4.921E-6, 3.3576E-6, 4.9766E-6, 3.3829E-6, 5.122E-6}, {3.93068E-5, 2.05177E-5, 2.54533E-5, 2.29604E-5, 1.29838E-5, 1.26427E-5, 9.6583E-6, 1.2367E-5, 1.00764E-5, 1.00625E-5, 4.7514E-6, 4.9466E-6, 4.1283E-6, 5.9449E-6, 6.5208E-6, 7.2136E-6, 4.5347E-6, 3.9272E-6, 3.3654E-6, 3.8633E-6, 3.2913E-6, 3.8211E-6, 4.1976E-6, 3.786E-6, 4.2838E-6, 3.7697E-6, 4.3641E-6, 3.8556E-6, 3.3089E-6, 3.9242E-6, 4.3859E-6, 5.1678E-6, 3.4265E-6, 4.0012E-6, 3.5224E-6, 5.311E-6, 4.6531E-6, 5.3869E-6, 3.6188E-6, 5.4308E-6, 4.8054E-6, 5.5242E-6, 4.8512E-6, 5.6159E-6, 3.7853E-6}, {3.40677E-5, 3.07596E-5, 2.23668E-5, 1.52946E-5, 1.46712E-5, 1.06255E-5, 1.06032E-5, 8.1832E-6, 8.6244E-6, 4.9411E-6, 6.7545E-6, 4.0421E-6, 4.4178E-6, 3.6241E-6, 5.2208E-6, 3.2905E-6, 4.878E-6, 5.3199E-6, 4.6459E-6, 3.944E-6, 2.6124E-6, 5.0097E-6, 2.6014E-6, 2.9505E-6, 3.271E-6, 3.798E-6, 4.341E-6, 3.774E-6, 3.3662E-6, 5.0175E-6, 3.3958E-6, 5.1015E-6, 3.4086E-6, 3.0335E-6, 3.4235E-6, 3.9828E-6, 4.5344E-6, 3.1386E-6, 4.6458E-6, 4.1624E-6, 3.6086E-6, 4.1947E-6, 2.8209E-6, 3.346E-6, 2.8613E-6}, {3.05973E-5, 2.72968E-5, 1.42276E-5, 1.79127E-5, 9.7246E-6, 1.27507E-5, 7.0473E-6, 9.0593E-6, 9.2161E-6, 7.4076E-6, 7.4685E-6, 5.8617E-6, 4.7016E-6, 5.1588E-6, 5.6952E-6, 3.573E-6, 3.8387E-6, 4.2402E-6, 3.5579E-6, 1.8248E-6, 4.6133E-6, 3.937E-6, 4.5159E-6, 2.9244E-6, 1.971E-6, 2.2822E-6, 2.5439E-6, 2.8944E-6, 2.5756E-6, 2.925E-6, 3.426E-6, 5.0361E-6, 3.4605E-6, 3.8688E-6, 2.6949E-6, 1.4049E-6, 2.7321E-6, 2.3567E-6, 2.7913E-6, 3.1218E-6, 2.7763E-6, 3.1969E-6, 3.7163E-6, 3.2316E-6, 3.7723E-6}, {3.63524E-5, 1.85238E-5, 2.23944E-5, 1.56641E-5, 1.46928E-5, 1.0777E-5, 1.05276E-5, 1.0218E-5, 7.9337E-6, 7.858E-6, 6.2276E-6, 6.6384E-6, 3.9738E-6, 5.5727E-6, 6.0414E-6, 3.7461E-6, 2.3444E-6, 3.3734E-6, 2.8739E-6, 3.2262E-6, 2.6725E-6, 3.0603E-6, 2.5932E-6, 3.0096E-6, 1.9791E-6, 2.9386E-6, 3.3334E-6, 2.9324E-6, 2.5033E-6, 1.7645E-6, 1.4959E-6, 2.2899E-6, 2.5847E-6, 3.0273E-6, 2.6349E-6, 3.9712E-6, 2.6279E-6, 4.0671E-6, 2.0776E-6, 2.3832E-6, 2.0939E-6, 2.4085E-6, 2.1149E-6, 4.1807E-6, 1.6785E-6}, {5.31068E-5, 2.06882E-5, 2.59899E-5, 1.78808E-5, 1.68038E-5, 1.28055E-5, 1.19227E-5, 6.9103E-6, 9.0425E-6, 6.8286E-6, 6.9793E-6, 3.1585E-6, 4.2989E-6, 2.7028E-6, 3.6738E-6, 3.1193E-6, 4.3434E-6, 3.5227E-6, 3.0391E-6, 2.4934E-6, 2.7944E-6, 2.4067E-6, 2.7907E-6, 2.3644E-6, 2.6945E-6, 2.2659E-6, 2.0013E-6, 2.9627E-6, 2.6172E-6, 1.7442E-6, 2.598E-6, 1.7461E-6, 2.0037E-6, 1.7818E-6, 2.6313E-6, 2.3219E-6, 2.6522E-6, 2.3901E-6, 2.6985E-6, 1.4157E-6, 2.7079E-6, 1.8522E-6, 1.6312E-6, 1.9179E-6, 1.6703E-6}, {4.71466E-5, 3.21678E-5, 2.21166E-5, 2.10526E-5, 1.1491E-5, 1.08287E-5, 8.0777E-6, 1.04203E-5, 1.01134E-5, 5.8443E-6, 4.5067E-6, 4.5975E-6, 2.7454E-6, 3.7782E-6, 3.9918E-6, 4.3093E-6, 4.6405E-6, 2.9403E-6, 2.3896E-6, 2.0792E-6, 2.9414E-6, 1.4845E-6, 1.639E-6, 1.8155E-6, 2.06E-6, 1.8173E-6, 2.0305E-6, 1.8045E-6, 2.0275E-6, 2.3056E-6, 2.638E-6, 2.2906E-6, 1.5633E-6, 2.2861E-6, 1.5702E-6, 2.2925E-6, 1.5926E-6, 1.7741E-6, 1.5991E-6, 1.7969E-6, 2.1445E-6, 1.8491E-6, 2.1663E-6, 1.8937E-6, 2.1829E-6}, {4.15033E-5, 3.75035E-5, 2.57317E-5, 1.81483E-5, 1.70401E-5, 1.65719E-5, 9.1912E-6, 8.9667E-6, 6.6295E-6, 5.166E-6, 5.1868E-6, 5.1552E-6, 4.1581E-6, 4.1949E-6, 4.4142E-6, 3.5882E-6, 2.9449E-6, 3.1798E-6, 2.0273E-6, 2.169E-6, 2.4377E-6, 2.6775E-6, 2.968E-6, 1.4909E-6, 2.148E-6, 1.869E-6, 2.7312E-6, 1.415E-6, 2.0266E-6, 1.3942E-6, 1.5678E-6, 1.4176E-6, 1.5601E-6, 1.828E-6, 2.0424E-6, 2.3951E-6, 1.5782E-6, 2.4117E-6, 1.6197E-6, 1.4155E-6, 1.2558E-6, 1.8686E-6, 1.6359E-6, 1.8949E-6, 1.0017E-6}, {4.68296E-5, 3.30068E-5, 2.37247E-5, 1.65336E-5, 1.5052E-5, 1.09676E-5, 1.03584E-5, 5.9806E-6, 7.5019E-6, 7.5639E-6, 7.5577E-6, 4.4171E-6, 3.5406E-6, 2.7896E-6, 3.8483E-6, 3.0165E-6, 2.4502E-6, 2.0229E-6, 3.7725E-6, 2.3248E-6, 2.5725E-6, 1.6526E-6, 1.8416E-6, 2.0307E-6, 2.3292E-6, 1.9462E-6, 2.2344E-6, 1.4452E-6, 1.6743E-6, 2.4751E-6, 2.1503E-6, 1.0914E-6, 1.6308E-6, 1.857E-6, 2.1221E-6, 1.0982E-6, 1.6425E-6, 1.1133E-6, 2.1459E-6, 1.896E-6, 2.1557E-6, 1.136E-6, 1.2755E-6, 1.1503E-6, 1.2923E-6}, {3.26803E-5, 2.95857E-5, 1.54475E-5, 1.95504E-5, 1.33752E-5, 1.30826E-5, 9.3108E-6, 9.0846E-6, 5.1384E-6, 6.5258E-6, 4.9655E-6, 5.0318E-6, 3.9301E-6, 3.1064E-6, 1.8937E-6, 3.3983E-6, 2.7192E-6, 2.1941E-6, 2.3262E-6, 1.1684E-6, 1.5864E-6, 1.7653E-6, 1.9394E-6, 2.1477E-6, 1.8003E-6, 1.5654E-6, 1.7271E-6, 1.9541E-6, 1.2911E-6, 8.739E-7, 1.6831E-6, 1.1063E-6, 1.6687E-6, 1.4377E-6, 1.6576E-6, 1.0945E-6, 1.282E-6, 1.0911E-6, 7.782E-7, 1.4342E-6, 1.3165E-6, 1.8913E-6, 1.317E-6, 8.899E-7, 1.3269E-6}, {3.81583E-5, 2.64565E-5, 1.36612E-5, 2.12466E-5, 1.53348E-5, 1.45316E-5, 1.38739E-5, 6.0648E-6, 7.6347E-6, 7.4893E-6, 4.3282E-6, 5.7183E-6, 3.384E-6, 4.5556E-6, 3.5441E-6, 2.8461E-6, 2.2853E-6, 3.1916E-6, 2.6005E-6, 2.1084E-6, 1.3651E-6, 2.4956E-6, 1.611E-6, 1.775E-6, 1.488E-6, 1.6813E-6, 1.0862E-6, 1.6184E-6, 1.3616E-6, 1.5542E-6, 1.7206E-6, 1.5449E-6, 1.3086E-6, 1.5137E-6, 1.2941E-6, 1.1585E-6, 1.2793E-6, 8.977E-7, 9.98E-7, 1.1586E-6, 1.0254E-6, 1.1655E-6, 1.0218E-6, 1.1671E-6, 1.032E-6}, {4.35206E-5, 3.94602E-5, 2.80329E-5, 1.43528E-5, 1.03966E-5, 9.9195E-6, 1.23591E-5, 7.0629E-6, 8.7274E-6, 6.609E-6, 4.8718E-6, 3.8172E-6, 5.0202E-6, 2.981E-6, 4.0378E-6, 2.4193E-6, 2.4874E-6, 1.5771E-6, 1.6403E-6, 1.7939E-6, 1.9398E-6, 1.2193E-6, 1.7244E-6, 8.475E-7, 9.524E-7, 8.041E-7, 1.1807E-6, 9.651E-7, 1.1501E-6, 1.2202E-6, 1.0892E-6, 1.1977E-6, 1.0599E-6, 1.5547E-6, 1.0348E-6, 1.1765E-6, 1.0241E-6, 9.188E-7, 7.943E-7, 9.237E-7, 1.0314E-6, 9.055E-7, 1.0352E-6, 9.196E-7, 1.3384E-6}, {3.79248E-5, 3.53934E-5, 2.41508E-5, 1.68891E-5, 2.10529E-5, 8.6678E-6, 8.351E-6, 1.06765E-5, 5.8348E-6, 5.7662E-6, 7.4621E-6, 4.3406E-6, 3.3715E-6, 4.4195E-6, 2.0552E-6, 2.7516E-6, 1.6638E-6, 2.2213E-6, 2.3581E-6, 1.9527E-6, 1.6003E-6, 1.7368E-6, 8.516E-7, 9.2E-7, 1.6828E-6, 8.623E-7, 9.286E-7, 6.197E-7, 1.1498E-6, 7.848E-7, 6.628E-7, 9.788E-7, 1.0822E-6, 1.2385E-6, 8.152E-7, 9.435E-7, 1.0686E-6, 1.2014E-6, 6.276E-7, 7.03E-7, 1.0605E-6, 1.2119E-6, 6.389E-7, 7.195E-7, 6.456E-7}, {4.57913E-5, 3.08903E-5, 2.82516E-5, 1.97423E-5, 1.39036E-5, 7.6554E-6, 1.01164E-5, 9.2286E-6, 6.8324E-6, 5.2054E-6, 5.0091E-6, 4.9163E-6, 3.9143E-6, 2.9462E-6, 3.9499E-6, 3.1099E-6, 2.4405E-6, 1.4864E-6, 1.2048E-6, 2.1759E-6, 1.3931E-6, 1.4556E-6, 9.208E-7, 1.7108E-6, 1.1004E-6, 1.1923E-6, 7.721E-7, 6.708E-7, 5.731E-7, 8.092E-7, 9.072E-7, 7.914E-7, 8.763E-7, 7.716E-7, 6.536E-7, 7.653E-7, 8.561E-7, 9.956E-7, 8.472E-7, 7.539E-7, 8.319E-7, 5.765E-7, 8.451E-7, 9.713E-7, 8.48E-7}, {5.14751E-5, 2.74557E-5, 2.41481E-5, 1.74373E-5, 1.61298E-5, 1.16871E-5, 8.4217E-6, 8.1004E-6, 5.8484E-6, 5.6938E-6, 5.7532E-6, 4.3019E-6, 3.2347E-6, 2.5748E-6, 3.4234E-6, 2.6896E-6, 1.6029E-6, 1.6452E-6, 2.3736E-6, 1.3932E-6, 1.1273E-6, 9.5E-7, 1.3052E-6, 1.075E-6, 1.2044E-6, 1.0077E-6, 1.1046E-6, 7.011E-7, 1.0268E-6, 8.714E-7, 1.2822E-6, 1.0702E-6, 7.283E-7, 1.0366E-6, 5.479E-7, 7.812E-7, 5.332E-7, 7.67E-7, 6.899E-7, 7.7E-7, 6.826E-7, 7.637E-7, 8.807E-7, 4.626E-7, 6.769E-7}, {3.47279E-5, 3.26038E-5, 2.22389E-5, 2.03032E-5, 1.86389E-5, 1.35396E-5, 7.4878E-6, 9.3982E-6, 6.9447E-6, 5.1305E-6, 3.8953E-6, 4.972E-6, 3.8543E-6, 3.8303E-6, 1.7387E-6, 1.3908E-6, 1.8492E-6, 1.8676E-6, 1.1554E-6, 1.6034E-6, 9.913E-7, 1.0369E-6, 1.103E-6, 1.567E-6, 1.3066E-6, 1.1031E-6, 9.195E-7, 7.778E-7, 1.0981E-6, 9.562E-7, 1.0346E-6, 1.1776E-6, 7.583E-7, 5.111E-7, 5.726E-7, 1.1004E-6, 9.317E-7, 4.887E-7, 5.5E-7, 8.051E-7, 5.53E-7, 4.756E-7, 5.513E-7, 6.031E-7, 5.515E-7}, {4.04627E-5, 2.79374E-5, 2.54737E-5, 1.73416E-5, 1.66276E-5, 9.0743E-6, 8.4501E-6, 1.08659E-5, 8.0225E-6, 4.5088E-6, 4.4169E-6, 5.7245E-6, 3.3186E-6, 4.366E-6, 3.4171E-6, 1.5607E-6, 2.0522E-6, 1.2726E-6, 1.6999E-6, 1.3417E-6, 1.8688E-6, 1.5245E-6, 9.452E-7, 7.794E-7, 8.405E-7, 1.1825E-6, 7.598E-7, 8.21E-7, 7.108E-7, 7.647E-7, 6.612E-7, 7.339E-7, 8.145E-7, 7.04E-7, 6.095E-7, 8.74E-7, 3.513E-7, 6.717E-7, 5.66E-7, 4.997E-7, 9.522E-7, 5.06E-7, 5.619E-7, 5.063E-7, 4.323E-7}, {4.72063E-5, 3.23179E-5, 2.94752E-5, 2.07416E-5, 1.13045E-5, 1.36112E-5, 1.29076E-5, 7.1735E-6, 9.1135E-6, 5.2733E-6, 3.9191E-6, 3.8507E-6, 2.2739E-6, 2.9313E-6, 1.7476E-6, 2.9817E-6, 1.7682E-6, 1.4044E-6, 1.8903E-6, 1.1418E-6, 1.5945E-6, 9.87E-7, 1.0526E-6, 1.116E-6, 1.1997E-6, 1.311E-6, 1.083E-6, 6.98E-7, 9.891E-7, 6.386E-7, 5.495E-7, 6.04E-7, 6.782E-7, 4.347E-7, 4.971E-7, 4.232E-7, 4.838E-7, 6.935E-7, 3.617E-7, 4.015E-7, 3.611E-7, 3.155E-7, 5.902E-7, 3.968E-7, 4.545E-7}, {5.34708E-5, 3.73744E-5, 1.96796E-5, 1.37544E-5, 1.29458E-5, 1.19235E-5, 8.8305E-6, 1.11632E-5, 6.2367E-6, 5.9625E-6, 3.4417E-6, 4.4561E-6, 3.3301E-6, 2.5232E-6, 1.9586E-6, 2.7071E-6, 1.5804E-6, 1.2263E-6, 1.6555E-6, 1.7219E-6, 1.0458E-6, 8.561E-7, 6.975E-7, 9.6E-7, 1.3346E-6, 8.501E-7, 4.21E-7, 5.776E-7, 8.267E-7, 9.169E-7, 4.551E-7, 5.061E-7, 7.113E-7, 6.128E-7, 6.79E-7, 4.531E-7, 5.155E-7, 5.74E-7, 6.449E-7, 2.634E-7, 4.837E-7, 5.547E-7, 4.79E-7, 4.165E-7, 4.781E-7}, {4.71509E-5, 3.31027E-5, 2.26179E-5, 1.61311E-5, 1.44893E-5, 1.07687E-5, 1.04009E-5, 1.28476E-5, 7.1831E-6, 5.3734E-6, 3.044E-6, 5.1224E-6, 3.965E-6, 2.2452E-6, 1.7674E-6, 1.743E-6, 1.7813E-6, 1.4173E-6, 1.8887E-6, 8.757E-7, 1.2001E-6, 1.6279E-6, 1.2946E-6, 4.971E-7, 8.642E-7, 5.591E-7, 6.041E-7, 6.461E-7, 5.27E-7, 7.557E-7, 4.882E-7, 7.062E-7, 5.94E-7, 8.734E-7, 5.615E-7, 4.848E-7, 4.202E-7, 4.705E-7, 4.021E-7, 4.565E-7, 3.96E-7, 4.488E-7, 4.998E-7, 5.792E-7, 3.821E-7}, {4.08712E-5, 2.90825E-5, 2.01809E-5, 1.84693E-5, 1.27543E-5, 1.22856E-5, 8.9579E-6, 8.7349E-6, 4.8255E-6, 6.2188E-6, 5.9289E-6, 4.4984E-6, 1.9907E-6, 3.3642E-6, 3.4197E-6, 2.6227E-6, 1.2039E-6, 1.5836E-6, 9.945E-7, 1.3051E-6, 1.7849E-6, 1.0646E-6, 5.24E-7, 7.062E-7, 5.767E-7, 6.087E-7, 8.726E-7, 5.467E-7, 7.758E-7, 6.348E-7, 7.039E-7, 3.514E-7, 6.567E-7, 2.671E-7, 6.217E-7, 6.907E-7, 5.847E-7, 1.47E-7, 4.367E-7, 3.746E-7, 3.283E-7, 3.639E-7, 4.146E-7, 3.63E-7, 4.069E-7}, {3.65867E-5, 3.34092E-5, 2.33935E-5, 2.11266E-5, 1.48841E-5, 1.45388E-5, 1.02065E-5, 9.9718E-6, 9.512E-6, 4.1586E-6, 5.2071E-6, 3.0423E-6, 3.0232E-6, 2.2968E-6, 2.3E-6, 3.0274E-6, 2.2943E-6, 1.0722E-6, 1.1058E-6, 1.4789E-6, 9.014E-7, 9.248E-7, 9.83E-7, 1.0354E-6, 1.4149E-6, 1.1942E-6, 5.606E-7, 6.027E-7, 5.065E-7, 4.217E-7, 5.883E-7, 5.132E-7, 3.302E-7, 4.589E-7, 6.648E-7, 3.397E-7, 4.773E-7, 3.19E-7, 4.559E-7, 3.103E-7, 5.849E-7, 3.016E-7, 5.635E-7, 3.806E-7, 2.617E-7}, {4.2474E-5, 2.99616E-5, 2.74655E-5, 1.88374E-5, 1.75698E-5, 1.26091E-5, 8.9948E-6, 6.8101E-6, 8.3814E-6, 4.8968E-6, 6.0247E-6, 5.9532E-6, 2.0417E-6, 4.4737E-6, 2.5919E-6, 2.0128E-6, 2.0369E-6, 1.2489E-6, 1.6173E-6, 1.2975E-6, 1.3224E-6, 1.0382E-6, 8.39E-7, 8.79E-7, 9.452E-7, 9.921E-7, 6.307E-7, 6.689E-7, 3.338E-7, 7.868E-7, 5.076E-7, 4.219E-7, 3.654E-7, 8.632E-7, 4.278E-7, 3.612E-7, 2.445E-7, 5.864E-7, 2.315E-7, 4.357E-7, 2.247E-7, 4.156E-7, 2.193E-7, 3.178E-7, 2.73E-7}, {5.03599E-5, 4.51538E-5, 3.16354E-5, 2.17532E-5, 2.02497E-5, 1.44337E-5, 1.04958E-5, 1.00705E-5, 7.4034E-6, 5.4909E-6, 4.1189E-6, 4.0598E-6, 3.0289E-6, 3.0085E-6, 2.9895E-6, 2.3332E-6, 1.8003E-6, 1.3931E-6, 1.8829E-6, 1.463E-6, 6.967E-7, 9.205E-7, 1.2416E-6, 7.812E-7, 1.0583E-6, 6.536E-7, 9.038E-7, 4.477E-7, 1.0522E-6, 6.597E-7, 5.567E-7, 4.616E-7, 6.575E-7, 3.344E-7, 2.766E-7, 3.963E-7, 5.688E-7, 1.793E-7, 4.153E-7, 4.62E-7, 3.992E-7, 4.404E-7, 2.976E-7, 4.364E-7, 3.74E-7}, {4.30595E-5, 3.97799E-5, 2.71616E-5, 1.43472E-5, 1.76142E-5, 1.68235E-5, 9.35E-6, 6.7329E-6, 6.6446E-6, 8.2213E-6, 6.139E-6, 4.6372E-6, 3.4811E-6, 3.4735E-6, 2.673E-6, 2.6634E-6, 1.5581E-6, 2.1099E-6, 1.2381E-6, 1.6679E-6, 1.0186E-6, 1.0483E-6, 8.241E-7, 1.129E-6, 5.475E-7, 5.724E-7, 4.661E-7, 6.409E-7, 4.075E-7, 5.66E-7, 4.676E-7, 6.678E-7, 5.536E-7, 4.588E-7, 3.086E-7, 2.6E-7, 2.221E-7, 4.089E-7, 5.91E-7, 2.319E-7, 3.286E-7, 2.849E-7, 3.188E-7, 1.718E-7, 3.117E-7}, {5.03956E-5, 2.62755E-5, 1.8469E-5, 1.69051E-5, 1.5756E-5, 1.13206E-5, 1.08187E-5, 7.9141E-6, 7.5536E-6, 5.514E-6, 5.454E-6, 4.0614E-6, 3.9965E-6, 2.3509E-6, 3.0468E-6, 1.8116E-6, 2.3451E-6, 1.389E-6, 1.4094E-6, 1.1387E-6, 1.1426E-6, 7.091E-7, 9.704E-7, 7.647E-7, 8.029E-7, 1.1008E-6, 3.155E-7, 4.312E-7, 4.596E-7, 4.817E-7, 5.269E-7, 5.676E-7, 3.706E-7, 4.006E-7, 4.315E-7, 4.775E-7, 3.098E-7, 3.407E-7, 4.886E-7, 4.152E-7, 1.682E-7, 3.093E-7, 2.068E-7, 2.292E-7, 2.008E-7}, {3.34173E-5, 3.09726E-5, 2.18877E-5, 1.96442E-5, 1.38546E-5, 1.30794E-5, 9.4927E-6, 6.8714E-6, 8.6744E-6, 6.3898E-6, 3.7817E-6, 4.8166E-6, 4.6345E-6, 2.661E-6, 1.5855E-6, 2.0759E-6, 2.7141E-6, 2.0849E-6, 1.6433E-6, 1.2979E-6, 7.813E-7, 1.0596E-6, 4.958E-7, 8.546E-7, 8.928E-7, 5.593E-7, 9.962E-7, 6.205E-7, 6.694E-7, 4.27E-7, 4.437E-7, 3.712E-7, 5.299E-7, 3.383E-7, 4.823E-7, 2.425E-7, 4.443E-7, 4.843E-7, 4.11E-7, 1.667E-7, 1.831E-7, 1.992E-7, 2.251E-7, 3.165E-7, 1.686E-7}, {3.89225E-5, 3.56628E-5, 2.46098E-5, 2.3481E-5, 1.58826E-5, 1.54517E-5, 1.09594E-5, 6.1715E-6, 7.7203E-6, 5.7494E-6, 7.2006E-6, 3.1528E-6, 3.2123E-6, 2.4479E-6, 2.3896E-6, 2.3499E-6, 1.8589E-6, 1.0985E-6, 1.4288E-6, 1.1269E-6, 1.5138E-6, 1.172E-6, 9.382E-7, 9.879E-7, 6.065E-7, 8.389E-7, 5.19E-7, 7.012E-7, 5.724E-7, 4.774E-7, 3.925E-7, 5.365E-7, 2.703E-7, 4.855E-7, 4.093E-7, 3.496E-7, 3.709E-7, 2.481E-7, 2.089E-7, 1.81E-7, 1.978E-7, 1.719E-7, 3.092E-7, 1.622E-7, 2.294E-7}, {3.37803E-5, 4.04714E-5, 2.8407E-5, 1.98125E-5, 1.83754E-5, 1.74965E-5, 1.26377E-5, 1.21499E-5, 8.6656E-6, 5.1637E-6, 6.3642E-6, 3.68E-6, 2.7442E-6, 4.6261E-6, 2.7739E-6, 2.0991E-6, 2.7411E-6, 1.5953E-6, 1.6454E-6, 1.0057E-6, 1.3415E-6, 1.0441E-6, 8.211E-7, 1.1139E-6, 4.134E-7, 4.295E-7, 5.796E-7, 3.604E-7, 4.939E-7, 3.153E-7, 4.36E-7, 4.611E-7, 3.9E-7, 5.448E-7, 3.467E-7, 4.915E-7, 2.45E-7, 2.082E-7, 2.35E-7, 2.486E-7, 2.168E-7, 2.377E-7, 1.597E-7, 2.236E-7, 1.948E-7}, {5.13067E-5, 4.71119E-5, 3.28458E-5, 1.32586E-5, 2.11621E-5, 1.54592E-5, 8.583E-6, 1.06377E-5, 6.014E-6, 5.8815E-6, 7.382E-6, 4.2029E-6, 5.4567E-6, 4.1212E-6, 1.8646E-6, 2.3994E-6, 1.4275E-6, 1.8493E-6, 1.1151E-6, 1.1543E-6, 9.245E-7, 1.2066E-6, 7.246E-7, 7.519E-7, 4.803E-7, 8.191E-7, 5.011E-7, 4.138E-7, 4.368E-7, 3.569E-7, 6.387E-7, 5.261E-7, 4.315E-7, 2.781E-7, 3.871E-7, 1.946E-7, 3.503E-7, 2.314E-7, 2.482E-7, 2.172E-7, 3.055E-7, 1.223E-7, 2.858E-7, 1.905E-7, 2.117E-7}, {4.50816E-5, 4.08154E-5, 2.82845E-5, 1.55178E-5, 1.38761E-5, 1.75937E-5, 9.8262E-6, 1.21258E-5, 6.9414E-6, 6.6229E-6, 2.9233E-6, 4.8194E-6, 3.7116E-6, 3.6148E-6, 2.7563E-6, 1.6149E-6, 9.741E-7, 1.2561E-6, 1.2827E-6, 1.6831E-6, 1.0254E-6, 1.0378E-6, 1.4009E-6, 8.403E-7, 8.877E-7, 9.243E-7, 9.675E-7, 3.626E-7, 4.818E-7, 3.92E-7, 3.302E-7, 4.548E-7, 2.25E-7, 3.083E-7, 3.321E-7, 3.601E-7, 1.838E-7, 2.508E-7, 1.319E-7, 3.035E-7, 9.66E-8, 1.703E-7, 2.389E-7, 2.086E-7, 8.73E-8}, {5.16615E-5, 3.59046E-5, 2.50255E-5, 1.76967E-5, 1.62043E-5, 1.17023E-5, 1.115E-5, 8.3372E-6, 8.0845E-6, 5.776E-6, 5.7683E-6, 4.2198E-6, 4.2307E-6, 3.1731E-6, 1.8613E-6, 1.8786E-6, 1.8362E-6, 1.888E-6, 1.1419E-6, 1.9392E-6, 1.5208E-6, 5.532E-7, 5.717E-7, 5.781E-7, 7.821E-7, 4.847E-7, 5.016E-7, 4.026E-7, 5.57E-7, 7.553E-7, 3.651E-7, 2.375E-7, 4.137E-7, 4.454E-7, 3.721E-7, 3.077E-7, 2.562E-7, 1.692E-7, 1.437E-7, 3.38E-7, 1.705E-7, 2.396E-7, 1.596E-7, 2.284E-7, 1.911E-7}, {3.45441E-5, 3.16241E-5, 2.86584E-5, 2.06648E-5, 1.86795E-5, 1.36872E-5, 9.7047E-6, 9.6665E-6, 9.1419E-6, 6.7531E-6, 3.8985E-6, 4.8445E-6, 2.8978E-6, 3.7146E-6, 2.155E-6, 2.1547E-6, 1.6273E-6, 9.96E-7, 1.2967E-6, 1.3308E-6, 8.052E-7, 1.064E-6, 8.348E-7, 8.528E-7, 8.847E-7, 3.357E-7, 4.374E-7, 5.905E-7, 2.889E-7, 5.062E-7, 5.427E-7, 3.357E-7, 3.624E-7, 2.976E-7, 4.179E-7, 2.635E-7, 3.711E-7, 1.854E-7, 3.373E-7, 1.698E-7, 2.4E-7, 1.599E-7, 1.739E-7, 1.177E-7, 2.124E-7}, {4.08929E-5, 3.65974E-5, 3.38537E-5, 2.39837E-5, 2.19789E-5, 1.59079E-5, 1.48083E-5, 6.4093E-6, 4.7381E-6, 6.0372E-6, 5.8068E-6, 5.6862E-6, 3.2968E-6, 2.4911E-6, 2.4593E-6, 1.9073E-6, 1.9128E-6, 1.9005E-6, 1.4645E-6, 9.027E-7, 8.974E-7, 1.2109E-6, 7.36E-7, 5.796E-7, 7.748E-7, 3.802E-7, 5.085E-7, 4.071E-7, 4.279E-7, 4.439E-7, 3.642E-7, 2.963E-7, 3.129E-7, 3.366E-7, 3.574E-7, 1.793E-7, 1.519E-7, 2.667E-7, 1.76E-7, 2.482E-7, 1.261E-7, 2.263E-7, 1.493E-7, 2.143E-7, 8.69E-8}, {4.60894E-5, 4.23271E-5, 2.97879E-5, 2.05531E-5, 1.9303E-5, 1.78901E-5, 1.30914E-5, 9.6919E-6, 9.1541E-6, 5.2562E-6, 3.9234E-6, 3.8485E-6, 2.9218E-6, 2.8777E-6, 2.1609E-6, 2.1577E-6, 2.2213E-6, 1.2807E-6, 1.0154E-6, 7.967E-7, 6.264E-7, 8.077E-7, 6.542E-7, 6.707E-7, 6.786E-7, 5.617E-7, 4.357E-7, 5.927E-7, 4.775E-7, 3.001E-7, 3.137E-7, 2.632E-7, 2.739E-7, 2.881E-7, 3.141E-7, 2.009E-7, 2.152E-7, 3.873E-7, 1.959E-7, 1.287E-7, 2.305E-7, 1.938E-7, 2.115E-7, 3.004E-7, 1.533E-7}};
    private static final double[][] Bij = new double[][]{{-1.2, -1.05, -1.3, -1.15, -1.0, -0.85, -0.9, -0.75, -1.2, -1.05, -0.9, -0.95, -0.8, -0.65, -0.7, -0.75, -0.6, -0.45, -0.5, -0.75, -0.4, -0.25, -0.3, -0.15, -0.2, -0.25, 0.1, 0.05, 0.2, -0.05, 0.3, 0.25, 0.4, 0.15, 0.1, 0.25, 0.6, 0.55, 0.7, 0.45, 0.8, 0.55, 0.9, 0.65, 1.0}, {-1.25, -1.1, -0.95, -1.4, -1.05, -1.1, -0.95, -0.8, -0.85, -0.7, -0.55, -1.0, -0.65, -0.7, -0.95, -0.6, -0.65, -0.7, -0.55, -0.6, -0.45, -0.1, -0.15, 0.0, -0.05, 0.1, 0.05, 0.2, 0.15, 0.1, 0.25, 0.0, 0.15, -0.1, 0.25, 0.2, 0.35, 0.5, 0.65, 0.4, 0.75, 0.7, 0.85, 0.6, 0.95}, {-1.3, -1.15, -1.0, -1.05, -0.9, -0.95, -1.2, -0.85, -0.9, -0.95, -0.8, -0.65, -0.7, -0.75, -0.4, -0.65, -0.3, -0.35, -0.6, -0.45, -0.5, -0.35, -0.2, -0.25, -0.1, 0.05, 0.0, 0.15, -0.1, 0.25, 0.0, 0.35, 0.1, 0.45, 0.4, 0.55, 0.3, 0.65, 0.6, 0.75, 0.5, 0.85, 0.8, 0.95, 0.7}, {-1.15, -1.4, -1.05, -0.9, -1.15, -0.8, -1.05, -0.9, -0.95, -0.6, -0.85, -0.7, -0.75, -0.4, -0.45, -0.3, -0.35, -0.4, -0.25, -0.3, -0.15, -0.4, -0.05, -0.3, -0.15, -0.2, -0.05, 0.1, 0.25, 0.0, 0.35, 0.1, 0.25, 0.2, 0.35, 0.3, 0.45, 0.4, 0.75, 0.5, 0.65, 0.8, 0.75, 0.9, 0.65}, {-1.0, -1.25, -0.9, -1.15, -1.0, -0.85, -0.9, -0.75, -0.6, -0.85, -0.5, -0.95, -0.8, -0.65, -0.7, -0.55, -0.6, -0.25, -0.5, -0.35, -0.4, -0.05, -0.1, 0.05, -0.2, 0.15, -0.1, 0.05, 0.0, 0.15, 0.1, 0.25, 0.4, 0.35, 0.5, 0.45, 0.6, 0.55, 0.7, 0.45, 0.8, 0.75, 0.9, 0.65, 1.0}, {-0.85, -1.1, -1.15, -1.0, -0.85, -0.9, -0.95, -0.8, -0.65, -0.5, -0.55, -0.6, -0.65, -0.5, -0.55, -0.4, -0.25, -0.5, -0.15, -0.6, -0.05, -0.3, -0.15, 0.0, -0.05, 0.1, 0.05, 0.2, 0.15, 0.3, 0.05, 0.4, 0.35, 0.5, 0.45, 0.6, 0.55, 0.7, 0.45, 0.8, 0.75, 0.9, 0.85, 1.0, 0.75}, {-0.9, -1.15, -1.0, -1.05, -0.9, -0.55, -0.6, -0.45, -0.7, -0.55, -0.6, -0.65, -0.5, -0.35, -0.4, -0.25, -0.5, -0.35, -0.2, -0.05, -0.1, 0.05, 0.0, 0.15, 0.3, 0.25, 0.4, 0.15, 0.3, -0.15, 0.4, 0.55, 0.5, 0.25, 0.6, 0.55, 0.9, 0.45, 0.6, 0.75, 0.7, 0.85, 1.0, 0.95, 0.9}, {-1.15, -1.0, -1.25, -0.9, -0.75, -0.8, -0.45, -0.5, -0.95, -0.4, -0.45, -0.7, -0.55, -0.4, -0.45, -0.3, -0.15, -0.2, -0.45, -0.1, -0.15, -0.2, -0.05, 0.1, 0.05, 0.2, 0.15, 0.1, 0.05, 0.4, 0.35, 0.5, 0.45, 0.2, 0.55, 0.5, 0.45, 0.2, 0.75, 0.7, 0.85, 0.8, 0.95, 1.1, 1.05}, {-1.0, -0.85, -0.9, -0.75, -0.8, -0.85, -0.9, -0.55, -0.6, -0.45, -0.5, -0.35, -0.4, -0.65, -0.3, -0.35, 0.0, -0.25, 0.1, -0.35, 0.0, -0.05, -0.1, 0.05, 0.0, 0.15, 0.1, 0.25, 0.2, 0.15, 0.3, 0.45, 0.0, 0.55, 0.7, 0.65, 0.8, 0.75, 0.9, 1.05, 1.0, 1.15, 1.1, 1.25, 1.0}, {-1.05, -1.1, -0.75, -0.6, -0.65, -0.7, -0.95, -0.6, -0.45, -0.7, -0.55, -0.2, -0.45, -0.3, -0.35, -0.2, -0.25, -0.1, 0.05, 0.0, -0.05, 0.3, 0.25, 0.0, 0.15, 0.1, 0.25, 0.2, 0.55, 0.5, 0.45, 0.2, 0.75, 0.3, 0.85, 0.6, 0.55, 0.7, 0.85, 0.8, 0.75, 0.9, 1.05, 1.0, 1.35}, {-1.1, -0.75, -0.8, -0.65, -0.5, -0.75, -0.6, -0.45, -0.7, -0.55, -0.4, -0.65, -0.3, -0.15, -0.2, -0.25, -0.3, -0.15, -0.2, -0.05, -0.1, 0.05, 0.2, 0.15, 0.3, 0.05, 0.2, 0.55, 0.3, 0.45, 0.4, 0.55, 0.5, 0.65, 0.6, 0.55, 0.9, 0.65, 1.0, 0.95, 0.9, 0.65, 1.0, 0.75, 1.1}, {-0.75, -1.0, -0.65, -0.5, -0.75, -0.6, -0.65, -0.3, -0.35, -0.2, -0.65, -0.5, -0.55, -0.2, -0.05, 0.1, -0.15, -0.2, -0.25, -0.1, -0.15, 0.0, 0.15, 0.1, 0.25, 0.2, 0.35, 0.3, 0.25, 0.4, 0.55, 0.7, 0.45, 0.6, 0.55, 0.9, 0.85, 1.0, 0.75, 1.1, 1.05, 1.2, 1.15, 1.3, 1.05}, {-0.8, -0.65, -0.7, -0.75, -0.6, -0.65, -0.5, -0.55, -0.4, -0.65, -0.3, -0.55, -0.4, -0.45, -0.1, -0.35, 0.0, 0.15, 0.1, 0.05, -0.2, 0.35, -0.1, 0.05, 0.2, 0.35, 0.5, 0.45, 0.4, 0.75, 0.5, 0.85, 0.6, 0.55, 0.7, 0.85, 1.0, 0.75, 1.1, 1.05, 1.0, 1.15, 0.9, 1.05, 1.0}, {-0.85, -0.7, -0.95, -0.6, -0.85, -0.5, -0.75, -0.4, -0.25, -0.3, -0.15, -0.2, -0.25, -0.1, 0.05, -0.2, -0.05, 0.1, 0.05, -0.4, 0.35, 0.3, 0.45, 0.2, -0.05, 0.1, 0.25, 0.4, 0.35, 0.5, 0.65, 1.0, 0.75, 0.9, 0.65, 0.2, 0.75, 0.7, 0.85, 1.0, 0.95, 1.1, 1.25, 1.2, 1.35}, {-0.7, -0.95, -0.6, -0.65, -0.5, -0.55, -0.4, -0.25, -0.3, -0.15, -0.2, -0.05, -0.3, 0.05, 0.2, -0.05, -0.3, 0.05, 0.0, 0.15, 0.1, 0.25, 0.2, 0.35, 0.1, 0.45, 0.6, 0.55, 0.5, 0.25, 0.2, 0.55, 0.7, 0.85, 0.8, 1.15, 0.9, 1.25, 0.8, 0.95, 0.9, 1.05, 1.0, 1.55, 0.9}, {-0.35, -0.8, -0.45, -0.5, -0.35, -0.4, -0.25, -0.5, -0.15, -0.2, -0.05, -0.5, -0.15, -0.4, -0.05, -0.1, 0.25, 0.2, 0.15, 0.1, 0.25, 0.2, 0.35, 0.3, 0.45, 0.4, 0.35, 0.7, 0.65, 0.4, 0.75, 0.5, 0.65, 0.6, 0.95, 0.9, 1.05, 1.0, 1.15, 0.7, 1.25, 1.0, 0.95, 1.1, 1.05}, {-0.4, -0.45, -0.5, -0.35, -0.6, -0.45, -0.5, -0.15, 0.0, -0.25, -0.3, -0.15, -0.4, -0.05, 0.1, 0.25, 0.4, 0.15, 0.1, 0.05, 0.4, -0.05, 0.1, 0.25, 0.4, 0.35, 0.5, 0.45, 0.6, 0.75, 0.9, 0.85, 0.6, 0.95, 0.7, 1.05, 0.8, 0.95, 0.9, 1.05, 1.2, 1.15, 1.3, 1.25, 1.4}, {-0.45, -0.3, -0.35, -0.4, -0.25, -0.1, -0.35, -0.2, -0.25, -0.3, -0.15, 0.0, -0.05, 0.1, 0.25, 0.2, 0.15, 0.3, 0.05, 0.2, 0.35, 0.5, 0.65, 0.2, 0.55, 0.5, 0.85, 0.4, 0.75, 0.5, 0.65, 0.6, 0.75, 0.9, 1.05, 1.2, 0.95, 1.3, 1.05, 1.0, 0.95, 1.3, 1.25, 1.4, 0.95}, {-0.3, -0.35, -0.4, -0.45, -0.3, -0.35, -0.2, -0.45, -0.1, 0.05, 0.2, -0.05, -0.1, -0.15, 0.2, 0.15, 0.1, 0.05, 0.6, 0.35, 0.5, 0.25, 0.4, 0.55, 0.7, 0.65, 0.8, 0.55, 0.7, 1.05, 1.0, 0.55, 0.9, 1.05, 1.2, 0.75, 1.1, 0.85, 1.4, 1.35, 1.5, 1.05, 1.2, 1.15, 1.3}, {-0.55, -0.4, -0.65, -0.3, -0.35, -0.2, -0.25, -0.1, -0.35, 0.0, -0.05, 0.1, 0.05, 0.0, -0.25, 0.3, 0.25, 0.2, 0.35, -0.1, 0.25, 0.4, 0.55, 0.7, 0.65, 0.6, 0.75, 0.9, 0.65, 0.4, 0.95, 0.7, 1.05, 1.0, 1.15, 0.9, 1.05, 1.0, 0.75, 1.3, 1.25, 1.6, 1.35, 1.1, 1.45}, {-0.4, -0.45, -0.7, -0.15, -0.2, -0.05, 0.1, -0.35, 0.0, 0.15, -0.1, 0.25, 0.0, 0.35, 0.3, 0.25, 0.2, 0.55, 0.5, 0.45, 0.2, 0.75, 0.5, 0.65, 0.6, 0.75, 0.5, 0.85, 0.8, 0.95, 1.1, 1.05, 1.0, 1.15, 1.1, 1.05, 1.2, 0.95, 1.1, 1.25, 1.2, 1.35, 1.3, 1.45, 1.4}, {-0.25, -0.1, -0.15, -0.4, -0.45, -0.3, 0.05, -0.2, 0.15, 0.1, 0.05, 0.0, 0.35, 0.1, 0.45, 0.2, 0.35, 0.1, 0.25, 0.4, 0.55, 0.3, 0.65, 0.2, 0.35, 0.3, 0.65, 0.6, 0.75, 0.9, 0.85, 1.0, 0.95, 1.3, 1.05, 1.2, 1.15, 1.1, 1.05, 1.2, 1.35, 1.3, 1.45, 1.4, 1.75}, {-0.3, -0.15, -0.2, -0.25, 0.1, -0.35, -0.2, 0.15, -0.1, 0.05, 0.4, 0.15, 0.1, 0.45, 0.0, 0.35, 0.1, 0.45, 0.6, 0.55, 0.5, 0.65, 0.2, 0.35, 0.9, 0.45, 0.6, 0.35, 0.9, 0.65, 0.6, 0.95, 1.1, 1.25, 1.0, 1.15, 1.3, 1.45, 1.0, 1.15, 1.5, 1.65, 1.2, 1.35, 1.3}, {-0.15, -0.2, -0.05, -0.1, -0.15, -0.4, -0.05, 0.1, 0.05, 0.0, 0.15, 0.3, 0.25, 0.2, 0.55, 0.5, 0.45, 0.2, 0.15, 0.7, 0.45, 0.6, 0.35, 0.9, 0.65, 0.8, 0.55, 0.5, 0.45, 0.8, 0.95, 0.9, 1.05, 1.0, 0.95, 1.1, 1.25, 1.4, 1.35, 1.3, 1.45, 1.2, 1.55, 1.7, 1.65}, {0.0, -0.25, -0.1, -0.15, 0.0, -0.05, -0.1, 0.05, 0.0, 0.15, 0.3, 0.25, 0.2, 0.15, 0.5, 0.45, 0.2, 0.35, 0.7, 0.45, 0.4, 0.35, 0.7, 0.65, 0.8, 0.75, 0.9, 0.65, 1.0, 0.95, 1.3, 1.25, 1.0, 1.35, 0.9, 1.25, 1.0, 1.35, 1.3, 1.45, 1.4, 1.55, 1.7, 1.25, 1.6}, {-0.25, -0.1, -0.15, 0.0, 0.15, 0.1, -0.15, 0.2, 0.15, 0.1, 0.05, 0.4, 0.35, 0.5, 0.05, 0.0, 0.35, 0.5, 0.25, 0.6, 0.35, 0.5, 0.65, 1.0, 0.95, 0.9, 0.85, 0.8, 1.15, 1.1, 1.25, 1.4, 1.15, 0.9, 1.05, 1.6, 1.55, 1.1, 1.25, 1.6, 1.35, 1.3, 1.45, 1.6, 1.55}, {-0.1, -0.15, 0.0, -0.05, 0.1, -0.15, 0.0, 0.35, 0.3, 0.05, 0.2, 0.55, 0.3, 0.65, 0.6, 0.15, 0.5, 0.25, 0.6, 0.55, 0.9, 0.85, 0.6, 0.55, 0.7, 1.05, 0.8, 0.95, 0.9, 1.05, 1.0, 1.15, 1.3, 1.25, 1.2, 1.55, 0.9, 1.45, 1.4, 1.35, 1.9, 1.45, 1.6, 1.55, 1.5}, {0.05, 0.0, 0.15, 0.1, -0.15, 0.2, 0.35, 0.1, 0.45, 0.2, 0.15, 0.3, 0.05, 0.4, 0.15, 0.7, 0.45, 0.4, 0.75, 0.5, 0.85, 0.6, 0.75, 0.9, 1.05, 1.2, 1.15, 0.9, 1.25, 1.0, 0.95, 1.1, 1.25, 1.0, 1.15, 1.1, 1.25, 1.6, 1.15, 1.3, 1.25, 1.2, 1.75, 1.5, 1.65}, {0.2, 0.15, -0.1, -0.15, 0.0, 0.15, 0.1, 0.45, 0.2, 0.35, 0.1, 0.45, 0.4, 0.35, 0.3, 0.65, 0.4, 0.35, 0.7, 0.85, 0.6, 0.55, 0.5, 0.85, 1.2, 0.95, 0.5, 0.85, 1.2, 1.35, 0.9, 1.05, 1.4, 1.35, 1.5, 1.25, 1.4, 1.55, 1.7, 1.05, 1.6, 1.75, 1.7, 1.65, 1.8}, {0.15, 0.1, 0.05, 0.0, 0.15, 0.1, 0.25, 0.6, 0.35, 0.3, 0.05, 0.6, 0.55, 0.3, 0.25, 0.4, 0.55, 0.5, 0.85, 0.4, 0.75, 1.1, 1.05, 0.4, 0.95, 0.7, 0.85, 1.0, 0.95, 1.3, 1.05, 1.4, 1.35, 1.7, 1.45, 1.4, 1.35, 1.5, 1.45, 1.6, 1.55, 1.7, 1.85, 2.0, 1.75}, {0.1, 0.05, 0.0, 0.15, 0.1, 0.25, 0.2, 0.35, 0.1, 0.45, 0.6, 0.55, 0.1, 0.65, 0.8, 0.75, 0.3, 0.65, 0.4, 0.75, 1.1, 0.85, 0.4, 0.75, 0.7, 0.85, 1.2, 0.95, 1.3, 1.25, 1.4, 0.95, 1.5, 0.85, 1.6, 1.75, 1.7, 0.65, 1.6, 1.55, 1.5, 1.65, 1.8, 1.75, 1.9}, {0.05, 0.2, 0.15, 0.3, 0.25, 0.4, 0.35, 0.5, 0.65, 0.2, 0.55, 0.3, 0.45, 0.4, 0.55, 0.9, 0.85, 0.4, 0.55, 0.9, 0.65, 0.8, 0.95, 1.1, 1.45, 1.4, 0.95, 1.1, 1.05, 1.0, 1.35, 1.3, 1.05, 1.4, 1.75, 1.3, 1.65, 1.4, 1.75, 1.5, 2.05, 1.6, 2.15, 1.9, 1.65}, {0.2, 0.15, 0.3, 0.25, 0.4, 0.35, 0.3, 0.25, 0.6, 0.35, 0.7, 0.85, 0.2, 0.95, 0.7, 0.65, 0.8, 0.55, 0.9, 0.85, 1.0, 0.95, 0.9, 1.05, 1.2, 1.35, 1.1, 1.25, 0.8, 1.55, 1.3, 1.25, 1.2, 1.95, 1.5, 1.45, 1.2, 1.95, 1.3, 1.85, 1.4, 1.95, 1.5, 1.85, 1.8}, {0.35, 0.5, 0.45, 0.4, 0.55, 0.5, 0.45, 0.6, 0.55, 0.5, 0.45, 0.6, 0.55, 0.7, 0.85, 0.8, 0.75, 0.7, 1.05, 1.0, 0.55, 0.9, 1.25, 1.0, 1.35, 1.1, 1.45, 1.0, 1.75, 1.5, 1.45, 1.4, 1.75, 1.3, 1.25, 1.6, 1.95, 1.1, 1.85, 2.0, 1.95, 2.1, 1.85, 2.2, 2.15}, {0.3, 0.45, 0.4, 0.15, 0.5, 0.65, 0.4, 0.35, 0.5, 0.85, 0.8, 0.75, 0.7, 0.85, 0.8, 0.95, 0.7, 1.05, 0.8, 1.15, 0.9, 1.05, 1.0, 1.35, 0.9, 1.05, 1.0, 1.35, 1.1, 1.45, 1.4, 1.75, 1.7, 1.65, 1.4, 1.35, 1.3, 1.85, 2.2, 1.55, 1.9, 1.85, 2.0, 1.55, 2.1}, {0.45, 0.2, 0.15, 0.3, 0.45, 0.4, 0.55, 0.5, 0.65, 0.6, 0.75, 0.7, 0.85, 0.6, 0.95, 0.7, 1.05, 0.8, 0.95, 0.9, 1.05, 0.8, 1.15, 1.1, 1.25, 1.6, 0.75, 1.1, 1.25, 1.4, 1.55, 1.7, 1.45, 1.6, 1.75, 1.9, 1.65, 1.8, 2.15, 2.1, 1.45, 2.0, 1.75, 1.9, 1.85}, {0.2, 0.35, 0.3, 0.45, 0.4, 0.55, 0.5, 0.45, 0.8, 0.75, 0.5, 0.85, 1.0, 0.75, 0.5, 0.85, 1.2, 1.15, 1.1, 1.05, 0.8, 1.15, 0.7, 1.25, 1.4, 1.15, 1.7, 1.45, 1.6, 1.35, 1.5, 1.45, 1.8, 1.55, 1.9, 1.45, 2.0, 2.15, 2.1, 1.45, 1.6, 1.75, 1.9, 2.25, 1.8}, {0.35, 0.5, 0.45, 0.6, 0.55, 0.7, 0.65, 0.4, 0.75, 0.7, 1.05, 0.6, 0.75, 0.7, 0.85, 1.0, 0.95, 0.7, 1.05, 1.0, 1.35, 1.3, 1.25, 1.4, 1.15, 1.5, 1.25, 1.6, 1.55, 1.5, 1.45, 1.8, 1.35, 1.9, 1.85, 1.8, 1.95, 1.7, 1.65, 1.6, 1.75, 1.7, 2.25, 1.8, 2.15}, {0.3, 0.65, 0.6, 0.55, 0.7, 0.85, 0.8, 0.95, 0.9, 0.65, 1.0, 0.75, 0.7, 1.25, 1.0, 0.95, 1.3, 1.05, 1.2, 0.95, 1.3, 1.25, 1.2, 1.55, 0.9, 1.05, 1.4, 1.15, 1.5, 1.25, 1.6, 1.75, 1.7, 2.05, 1.8, 2.15, 1.7, 1.65, 1.8, 1.95, 1.9, 2.05, 1.8, 2.15, 2.1}, {0.65, 0.8, 0.75, 0.3, 0.85, 0.8, 0.55, 0.9, 0.65, 0.8, 1.15, 0.9, 1.25, 1.2, 0.75, 1.1, 0.85, 1.2, 0.95, 1.1, 1.05, 1.4, 1.15, 1.3, 1.05, 1.6, 1.35, 1.3, 1.45, 1.4, 1.95, 1.9, 1.85, 1.6, 1.95, 1.5, 2.05, 1.8, 1.95, 1.9, 2.25, 1.6, 2.35, 2.1, 2.25}, {0.6, 0.75, 0.7, 0.45, 0.6, 0.95, 0.7, 1.05, 0.8, 0.95, 0.5, 1.05, 1.0, 1.15, 1.1, 0.85, 0.6, 0.95, 1.1, 1.45, 1.2, 1.35, 1.7, 1.45, 1.6, 1.75, 1.9, 1.25, 1.6, 1.55, 1.5, 1.85, 1.4, 1.75, 1.9, 2.05, 1.6, 1.95, 1.5, 2.25, 1.4, 1.95, 2.3, 2.25, 1.6}, {0.75, 0.7, 0.65, 0.6, 0.75, 0.7, 0.85, 0.8, 0.95, 0.9, 1.05, 1.0, 1.15, 1.1, 0.85, 1.0, 1.15, 1.3, 1.05, 1.6, 1.55, 0.9, 1.05, 1.2, 1.55, 1.3, 1.45, 1.4, 1.75, 2.1, 1.65, 1.4, 1.95, 2.1, 2.05, 2.0, 1.95, 1.7, 1.65, 2.4, 1.95, 2.3, 2.05, 2.4, 2.35}, {0.5, 0.65, 0.8, 0.75, 0.9, 0.85, 0.8, 0.95, 1.1, 1.05, 0.8, 1.15, 0.9, 1.25, 1.0, 1.15, 1.1, 0.85, 1.2, 1.35, 1.1, 1.45, 1.4, 1.55, 1.7, 1.05, 1.4, 1.75, 1.3, 1.85, 2.0, 1.75, 1.9, 1.85, 2.2, 1.95, 2.3, 1.85, 2.4, 1.95, 2.3, 2.05, 2.2, 1.95, 2.5}, {0.65, 0.8, 0.95, 0.9, 1.05, 1.0, 1.15, 0.7, 0.65, 1.0, 1.15, 1.3, 1.05, 1.0, 1.15, 1.1, 1.25, 1.4, 1.35, 1.1, 1.25, 1.6, 1.35, 1.3, 1.65, 1.2, 1.55, 1.5, 1.65, 1.8, 1.75, 1.7, 1.85, 2.0, 2.15, 1.7, 1.65, 2.2, 1.95, 2.3, 1.85, 2.4, 2.15, 2.5, 1.85}, {0.8, 0.95, 0.9, 0.85, 1.0, 1.15, 1.1, 1.05, 1.2, 0.95, 0.9, 1.05, 1.0, 1.15, 1.1, 1.25, 1.4, 1.15, 1.1, 1.05, 1.0, 1.35, 1.3, 1.45, 1.6, 1.55, 1.5, 1.85, 1.8, 1.55, 1.7, 1.65, 1.8, 1.95, 2.1, 1.85, 2.0, 2.55, 2.1, 1.85, 2.4, 2.35, 2.5, 2.85, 2.4}};
    private static final double[][] AijOrig = new double[][]{{9.47808E-5, 1.13702E-4, 1.00118E-4, 1.1959E-4, 1.05063E-4, 9.2201E-5, 1.09939E-4, 9.61817E-5, 1.14342E-4, 9.99772E-5, 1.18465E-4, 1.03549E-4, 1.22727E-4}, {7.89821E-5, 9.48444E-5, 8.36245E-5, 7.33297E-5, 8.78314E-5, 7.69799E-5, 9.19335E-5, 8.04789E-5, 9.58057E-5, 8.39558E-5, 9.97966E-5, 8.70743E-5, 1.03175E-4}, {6.65366E-5, 7.99715E-5, 7.0372E-5, 8.42561E-5, 7.40921E-5, 6.49757E-5, 7.75663E-5, 6.81323E-5, 8.1172E-5, 7.08781E-5, 8.42888E-5, 7.35226E-5, 8.72208E-5}, {5.6064E-5, 6.73256E-5, 5.93409E-5, 5.23516E-5, 6.25504E-5, 5.49136E-5, 6.56357E-5, 7.82465E-5, 6.85443E-5, 5.99304E-5, 7.12967E-5, 6.22049E-5, 7.38641E-5}, {4.76864E-5, 5.73346E-5, 5.05739E-5, 6.0643E-5, 5.34346E-5, 6.3894E-5, 5.60721E-5, 6.68434E-5, 5.85494E-5, 5.11473E-5, 6.08988E-5, 5.31489E-5, 6.32062E-5}, {4.06501E-5, 4.89724E-5, 4.3243E-5, 5.19647E-5, 4.5615E-5, 5.45524E-5, 4.78982E-5, 5.71349E-5, 5.00254E-5, 4.37652E-5, 5.21263E-5, 4.5533E-5, 5.40793E-5}, {3.49541E-5, 4.21574E-5, 3.7092E-5, 4.45857E-5, 3.91597E-5, 4.69342E-5, 4.11581E-5, 4.91397E-5, 4.30438E-5, 5.12731E-5, 4.48652E-5, 3.92138E-5, 4.66779E-5}, {4.11296E-5, 3.629E-5, 3.19527E-5, 3.84631E-5, 3.37429E-5, 4.04799E-5, 3.55183E-5, 4.2431E-5, 3.71662E-5, 4.43414E-5, 3.88286E-5, 4.61746E-5, 4.03668E-5}, {3.55236E-5, 3.13722E-5, 2.76089E-5, 3.3268E-5, 2.92288E-5, 3.50426E-5, 3.07676E-5, 3.67966E-5, 3.23063E-5, 3.85546E-5, 3.37092E-5, 4.00815E-5, 3.50018E-5}, {3.09168E-5, 2.7294E-5, 2.4068E-5, 2.89772E-5, 2.54577E-5, 3.05399E-5, 2.68793E-5, 3.21616E-5, 2.81553E-5, 3.36062E-5, 2.94027E-5, 3.49824E-5, 3.05618E-5}, {2.69536E-5, 2.37946E-5, 2.87199E-5, 2.52553E-5, 2.22642E-5, 2.66807E-5, 2.34688E-5, 2.80674E-5, 2.45787E-5, 2.93847E-5, 2.56658E-5, 3.05777E-5, 2.67274E-5}, {2.3628E-5, 2.08424E-5, 2.51832E-5, 2.21566E-5, 1.95124E-5, 2.34327E-5, 2.05702E-5, 2.46477E-5, 2.15557E-5, 2.57936E-5, 2.25548E-5, 2.68717E-5, 2.34796E-5}, {2.07603E-5, 1.82939E-5, 1.61523E-5, 1.9505E-5, 2.34519E-5, 2.06073E-5, 1.8054E-5, 2.16798E-5, 1.89606E-5, 2.26817E-5, 1.98338E-5, 2.36529E-5, 2.06561E-5}};
    private static final double[][] BijOrig = new double[][]{{0.0, 0.15, 0.1, 0.25, 0.2, 0.15, 0.3, 0.25, 0.4, 0.35, 0.5, 0.45, 0.6}, {0.05, 0.2, 0.15, 0.1, 0.25, 0.2, 0.35, 0.3, 0.45, 0.4, 0.55, 0.5, 0.65}, {0.1, 0.25, 0.2, 0.35, 0.3, 0.25, 0.4, 0.35, 0.5, 0.45, 0.6, 0.55, 0.7}, {0.15, 0.3, 0.25, 0.2, 0.35, 0.3, 0.45, 0.6, 0.55, 0.5, 0.65, 0.6, 0.75}, {0.2, 0.35, 0.3, 0.45, 0.4, 0.55, 0.5, 0.65, 0.6, 0.55, 0.7, 0.65, 0.8}, {0.25, 0.4, 0.35, 0.5, 0.45, 0.6, 0.55, 0.7, 0.65, 0.6, 0.75, 0.7, 0.85}, {0.3, 0.45, 0.4, 0.55, 0.5, 0.65, 0.6, 0.75, 0.7, 0.85, 0.8, 0.75, 0.9}, {0.55, 0.5, 0.45, 0.6, 0.55, 0.7, 0.65, 0.8, 0.75, 0.9, 0.85, 1.0, 0.95}, {0.6, 0.55, 0.5, 0.65, 0.6, 0.75, 0.7, 0.85, 0.8, 0.95, 0.9, 1.05, 1.0}, {0.65, 0.6, 0.55, 0.7, 0.65, 0.8, 0.75, 0.9, 0.85, 1.0, 0.95, 1.1, 1.05}, {0.7, 0.65, 0.8, 0.75, 0.7, 0.85, 0.8, 0.95, 0.9, 1.05, 1.0, 1.15, 1.1}, {0.75, 0.7, 0.85, 0.8, 0.75, 0.9, 0.85, 1.0, 0.95, 1.1, 1.05, 1.2, 1.15}, {0.8, 0.75, 0.7, 0.85, 1.0, 0.95, 0.9, 1.05, 1.0, 1.15, 1.1, 1.25, 1.2}};

    private static int[] getBounds(double rho) {
        double calculateIndex = (rho - 0.8) / 0.05;
        int below = (int)FastMath.floor((double)calculateIndex);
        int above = below + 1;
        if (above >= NUM_POINTS) {
            below = NUM_POINTS - 1;
            above = NUM_POINTS - 2;
        } else if (below < 0) {
            below = 0;
            above = 1;
        }
        return new int[]{below, above};
    }

    public static double[] getNeckConstants(double rhoDescreened, double rhoDescreening) {
        int[] boundsI = NeckIntegral.getBounds(rhoDescreened);
        int[] boundsJ = NeckIntegral.getBounds(rhoDescreening);
        int lowI = boundsI[0];
        int highI = boundsI[1];
        int lowJ = boundsJ[0];
        int highJ = boundsJ[1];
        double aij = NeckIntegral.interpolate2D(radArray[lowI], radArray[highI], radArray[lowJ], radArray[highJ], rhoDescreened, rhoDescreening, Aij[lowI][lowJ], Aij[highI][lowJ], Aij[lowI][highJ], Aij[highI][highJ]);
        double bij = NeckIntegral.interpolate2D(radArray[lowI], radArray[highI], radArray[lowJ], radArray[highJ], rhoDescreened, rhoDescreening, Bij[lowI][lowJ], Bij[highI][lowJ], Bij[lowI][highJ], Bij[highI][highJ]);
        if (aij < 0.0) {
            logger.warning(String.format(" Aij is less than zero (%2.10f) in NeckIntegral for radii: %16.8f %16.8f.", aij, rhoDescreened, rhoDescreening));
            aij = 0.0;
        }
        return new double[]{aij, bij};
    }

    private static double interpolate1D(double y1, double y2, double y, double fxy1, double fxy2) {
        double frac1 = (y2 - y) / (y2 - y1);
        double frac2 = (y - y1) / (y2 - y1);
        double product1 = frac1 * fxy1;
        double product2 = frac2 * fxy2;
        return product1 + product2;
    }

    private static double interpolate2D(double x1, double x2, double y1, double y2, double x, double y, double fx1y1, double fx2y1, double fx1y2, double fx2y2) {
        double fxy1 = (x2 - x) / (x2 - x1) * fx1y1 + (x - x1) / (x2 - x1) * fx2y1;
        double fxy2 = (x2 - x) / (x2 - x1) * fx1y2 + (x - x1) / (x2 - x1) * fx2y2;
        return (y2 - y) / (y2 - y1) * fxy1 + (y - y1) / (y2 - y1) * fxy2;
    }
}

