/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.multipole.GKSource;
import ffx.potential.bonded.Atom;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class InducedGKFieldRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(InducedGKFieldRegion.class.getName());
    private final double gkc;
    private final double fd;
    private final double fq;
    private final InducedGKFieldLoop[] inducedGKFieldLoop;
    protected Atom[] atoms;
    private Crystal crystal;
    private double[][][] inducedDipole;
    private double[][][] inducedDipoleCR;
    private double[][][] sXYZ;
    private int[][][] neighborLists;
    private boolean[] use = null;
    private double cut2;
    private double[] born;
    private AtomicDoubleArray3D sharedGKField;
    private AtomicDoubleArray3D sharedGKFieldCR;

    public InducedGKFieldRegion(int nt, double soluteDieletric, double solventDieletric, double gkc) {
        this.fd = GKSource.cn((int)1, (double)soluteDieletric, (double)solventDieletric);
        this.fq = GKSource.cn((int)2, (double)soluteDieletric, (double)solventDieletric);
        this.gkc = gkc;
        this.inducedGKFieldLoop = new InducedGKFieldLoop[nt];
        for (int i = 0; i < nt; ++i) {
            this.inducedGKFieldLoop[i] = new InducedGKFieldLoop(this);
        }
    }

    public void init(Atom[] atoms, double[][][] inducedDipole, double[][][] inducedDipoleCR, Crystal crystal, double[][][] sXYZ, int[][][] neighborLists, boolean[] use, double cut2, double[] born, AtomicDoubleArray3D sharedGKField, AtomicDoubleArray3D sharedGKFieldCR) {
        this.atoms = atoms;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.crystal = crystal;
        this.sXYZ = sXYZ;
        this.neighborLists = neighborLists;
        this.use = use;
        this.cut2 = cut2;
        this.born = born;
        this.sharedGKField = sharedGKField;
        this.sharedGKFieldCR = sharedGKFieldCR;
    }

    public void run() {
        try {
            int nAtoms = this.atoms.length;
            int threadIndex = this.getThreadIndex();
            this.execute(0, nAtoms - 1, this.inducedGKFieldLoop[threadIndex]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing GK field in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class InducedGKFieldLoop
    extends IntegerForLoop {
        private final double[][] a;
        private final double[] gux;
        private final double[] guy;
        private final double[] guz;
        private final double[] dx_local;
        private int threadID;
        private double xi;
        private double yi;
        private double zi;
        private double uix;
        private double uiy;
        private double uiz;
        private double uixCR;
        private double uiyCR;
        private double uizCR;
        private double rbi;
        private int iSymm;
        private double[][] transOp;
        final /* synthetic */ InducedGKFieldRegion this$0;

        InducedGKFieldLoop(InducedGKFieldRegion inducedGKFieldRegion) {
            InducedGKFieldRegion inducedGKFieldRegion2 = inducedGKFieldRegion;
            Objects.requireNonNull(inducedGKFieldRegion2);
            this.this$0 = inducedGKFieldRegion2;
            this.a = new double[3][2];
            this.gux = new double[5];
            this.guy = new double[5];
            this.guz = new double[5];
            this.dx_local = new double[3];
            this.transOp = new double[3][3];
        }

        public void run(int lb, int ub) {
            this.threadID = this.getThreadIndex();
            double[] x = this.this$0.sXYZ[0][0];
            double[] y = this.this$0.sXYZ[0][1];
            double[] z = this.this$0.sXYZ[0][2];
            int nSymm = this.this$0.crystal.spaceGroup.symOps.size();
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            this.iSymm = 0;
            while (this.iSymm < nSymm) {
                SymOp symOp = (SymOp)symOps.get(this.iSymm);
                this.this$0.crystal.getTransformationOperator(symOp, this.transOp);
                for (int i = lb; i <= ub; ++i) {
                    int[] list;
                    if (!this.this$0.use[i]) continue;
                    this.xi = x[i];
                    this.yi = y[i];
                    this.zi = z[i];
                    this.uix = this.this$0.inducedDipole[0][i][0];
                    this.uiy = this.this$0.inducedDipole[0][i][1];
                    this.uiz = this.this$0.inducedDipole[0][i][2];
                    this.uixCR = this.this$0.inducedDipoleCR[0][i][0];
                    this.uiyCR = this.this$0.inducedDipoleCR[0][i][1];
                    this.uizCR = this.this$0.inducedDipoleCR[0][i][2];
                    this.rbi = this.this$0.born[i];
                    for (int k : list = this.this$0.neighborLists[this.iSymm][i]) {
                        if (!this.this$0.use[k]) continue;
                        this.inducedGKField(i, k);
                    }
                    if (this.iSymm != 0) continue;
                    this.inducedGKField(i, i);
                }
                ++this.iSymm;
            }
        }

        private void inducedGKField(int i, int k) {
            this.dx_local[0] = this.this$0.sXYZ[this.iSymm][0][k] - this.xi;
            this.dx_local[1] = this.this$0.sXYZ[this.iSymm][1][k] - this.yi;
            this.dx_local[2] = this.this$0.sXYZ[this.iSymm][2][k] - this.zi;
            double r2 = this.this$0.crystal.image(this.dx_local);
            if (r2 > this.this$0.cut2) {
                return;
            }
            double xr = this.dx_local[0];
            double yr = this.dx_local[1];
            double zr = this.dx_local[2];
            double xr2 = xr * xr;
            double yr2 = yr * yr;
            double zr2 = zr * zr;
            double ukx = this.this$0.inducedDipole[this.iSymm][k][0];
            double uky = this.this$0.inducedDipole[this.iSymm][k][1];
            double ukz = this.this$0.inducedDipole[this.iSymm][k][2];
            double ukxCR = this.this$0.inducedDipoleCR[this.iSymm][k][0];
            double ukyCR = this.this$0.inducedDipoleCR[this.iSymm][k][1];
            double ukzCR = this.this$0.inducedDipoleCR[this.iSymm][k][2];
            double rbk = this.this$0.born[k];
            double rb2 = this.rbi * rbk;
            double expterm = FastMath.exp((double)(-r2 / (this.this$0.gkc * rb2)));
            double expc = expterm / this.this$0.gkc;
            double expc1 = 1.0 - expc;
            double gf2 = 1.0 / (r2 + rb2 * expterm);
            double gf = FastMath.sqrt((double)gf2);
            double gf3 = gf2 * gf;
            double gf5 = gf3 * gf2;
            this.a[1][0] = -gf3;
            this.a[2][0] = 3.0 * gf5;
            this.a[1][1] = expc1 * this.a[2][0];
            this.a[1][0] = this.this$0.fd * this.a[1][0];
            this.a[1][1] = this.this$0.fd * this.a[1][1];
            this.a[2][0] = this.this$0.fq * this.a[2][0];
            this.gux[2] = this.a[1][0] + xr2 * this.a[1][1];
            this.gux[3] = xr * yr * this.a[1][1];
            this.gux[4] = xr * zr * this.a[1][1];
            this.guy[2] = this.gux[3];
            this.guy[3] = this.a[1][0] + yr2 * this.a[1][1];
            this.guy[4] = yr * zr * this.a[1][1];
            this.guz[2] = this.gux[4];
            this.guz[3] = this.guy[4];
            this.guz[4] = this.a[1][0] + zr2 * this.a[1][1];
            double fix = ukx * this.gux[2] + uky * this.guy[2] + ukz * this.guz[2];
            double fiy = ukx * this.gux[3] + uky * this.guy[3] + ukz * this.guz[3];
            double fiz = ukx * this.gux[4] + uky * this.guy[4] + ukz * this.guz[4];
            double fkx = this.uix * this.gux[2] + this.uiy * this.guy[2] + this.uiz * this.guz[2];
            double fky = this.uix * this.gux[3] + this.uiy * this.guy[3] + this.uiz * this.guz[3];
            double fkz = this.uix * this.gux[4] + this.uiy * this.guy[4] + this.uiz * this.guz[4];
            double fixCR = ukxCR * this.gux[2] + ukyCR * this.guy[2] + ukzCR * this.guz[2];
            double fiyCR = ukxCR * this.gux[3] + ukyCR * this.guy[3] + ukzCR * this.guz[3];
            double fizCR = ukxCR * this.gux[4] + ukyCR * this.guy[4] + ukzCR * this.guz[4];
            double fkxCR = this.uixCR * this.gux[2] + this.uiyCR * this.guy[2] + this.uizCR * this.guz[2];
            double fkyCR = this.uixCR * this.gux[3] + this.uiyCR * this.guy[3] + this.uizCR * this.guz[3];
            double fkzCR = this.uixCR * this.gux[4] + this.uiyCR * this.guy[4] + this.uizCR * this.guz[4];
            if (i == k) {
                fix *= 0.5;
                fiy *= 0.5;
                fiz *= 0.5;
                fkx *= 0.5;
                fky *= 0.5;
                fkz *= 0.5;
                fixCR *= 0.5;
                fiyCR *= 0.5;
                fizCR *= 0.5;
                fkxCR *= 0.5;
                fkyCR *= 0.5;
                fkzCR *= 0.5;
            }
            double xc = fkx;
            double yc = fky;
            double zc = fkz;
            fkx = xc * this.transOp[0][0] + yc * this.transOp[1][0] + zc * this.transOp[2][0];
            fky = xc * this.transOp[0][1] + yc * this.transOp[1][1] + zc * this.transOp[2][1];
            fkz = xc * this.transOp[0][2] + yc * this.transOp[1][2] + zc * this.transOp[2][2];
            this.this$0.sharedGKField.add(this.threadID, i, fix, fiy, fiz);
            this.this$0.sharedGKField.add(this.threadID, k, fkx, fky, fkz);
            xc = fkxCR;
            yc = fkyCR;
            zc = fkzCR;
            fkxCR = xc * this.transOp[0][0] + yc * this.transOp[1][0] + zc * this.transOp[2][0];
            fkyCR = xc * this.transOp[0][1] + yc * this.transOp[1][1] + zc * this.transOp[2][1];
            fkzCR = xc * this.transOp[0][2] + yc * this.transOp[1][2] + zc * this.transOp[2][2];
            this.this$0.sharedGKFieldCR.add(this.threadID, i, fixCR, fiyCR, fizCR);
            this.this$0.sharedGKFieldCR.add(this.threadID, k, fkxCR, fkyCR, fkzCR);
        }
    }
}

