/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.pj.reduction.SharedInteger;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.multipole.GKEnergyQI;
import ffx.numerics.multipole.GKEnergyQISIMD;
import ffx.numerics.multipole.GKSource;
import ffx.numerics.multipole.PolarizableMultipole;
import ffx.numerics.multipole.PolarizableMultipoleSIMD;
import ffx.numerics.multipole.QIFrame;
import ffx.numerics.multipole.QIFrameSIMD;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.pme.Polarization;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.util.FastMath;

public class GKEnergyRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(GKEnergyRegion.class.getName());
    protected static final double oneThird = 0.3333333333333333;
    protected final double electric;
    protected final Polarization polarization;
    protected final GeneralizedKirkwood.NonPolarModel nonPolarModel;
    private final double soluteDielectric;
    private final double solventDielectric;
    protected final double dOffset = 0.09;
    protected final double surfaceTension;
    protected final double gkc;
    private final double fc;
    private final double fd;
    private final double fq;
    private final double probe;
    private final SharedDouble sharedPermanentGKEnergy;
    private final SharedDouble sharedPolarizationGKEnergy;
    private final SharedDouble sharedGKEnergy;
    private final SharedInteger sharedInteractions;
    private final IntegerForLoop[] gkEnergyLoop;
    private Atom[] atoms;
    private double[][][] inducedDipole;
    private double[][][] inducedDipoleCR;
    private double[][][] globalMultipole;
    private Crystal crystal;
    private double[][][] sXYZ;
    private int[][][] neighborLists;
    private boolean[] use = null;
    private double cut2;
    private double[] baseRadius;
    private double[] born;
    private boolean gradient = false;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray sharedBornGrad;
    private AtomicDoubleArray selfEnergy;
    private AtomicDoubleArray crossEnergy;

    public GKEnergyRegion(int nt, Polarization polarization, GeneralizedKirkwood.NonPolarModel nonPolarModel, double surfaceTension, double probe, double electric, double soluteDieletric, double solventDieletric, double gkc, boolean gkQI) {
        this.soluteDielectric = soluteDieletric;
        this.solventDielectric = solventDieletric;
        this.fc = GKSource.cn((int)0, (double)soluteDieletric, (double)solventDieletric);
        this.fd = GKSource.cn((int)1, (double)soluteDieletric, (double)solventDieletric);
        this.fq = GKSource.cn((int)2, (double)soluteDieletric, (double)solventDieletric);
        this.gkc = gkc;
        this.polarization = polarization;
        this.nonPolarModel = nonPolarModel;
        this.surfaceTension = surfaceTension;
        this.probe = probe;
        this.electric = electric;
        this.gkEnergyLoop = new IntegerForLoop[nt];
        for (int i = 0; i < nt; ++i) {
            this.gkEnergyLoop[i] = gkQI ? new GKEnergyLoopQI(this) : new GKEnergyLoop(this);
        }
        this.sharedPermanentGKEnergy = new SharedDouble();
        this.sharedPolarizationGKEnergy = new SharedDouble();
        this.sharedGKEnergy = new SharedDouble();
        this.sharedInteractions = new SharedInteger();
    }

    public double getEnergy() {
        return this.sharedGKEnergy.get();
    }

    public double getPermanentEnergy() {
        return this.sharedPermanentGKEnergy.get();
    }

    public double getPolarizationEnergy() {
        return this.sharedPolarizationGKEnergy.get();
    }

    public AtomicDoubleArray getSelfEnergy() {
        int nAtoms = this.atoms.length;
        this.selfEnergy.reduce(0, nAtoms - 1);
        return this.selfEnergy;
    }

    public int getInteractions() {
        return this.sharedInteractions.get();
    }

    public void init(Atom[] atoms, double[][][] globalMultipole, double[][][] inducedDipole, double[][][] inducedDipoleCR, Crystal crystal, double[][][] sXYZ, int[][][] neighborLists, boolean[] use, double cut2, double[] baseRadius, double[] born, boolean gradient, ParallelTeam parallelTeam, AtomicDoubleArray3D grad, AtomicDoubleArray3D torque, AtomicDoubleArray sharedBornGrad) {
        this.atoms = atoms;
        this.globalMultipole = globalMultipole;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.crystal = crystal;
        this.sXYZ = sXYZ;
        this.neighborLists = neighborLists;
        this.use = use;
        this.cut2 = cut2;
        this.baseRadius = baseRadius;
        this.born = born;
        this.gradient = gradient;
        this.grad = grad;
        this.torque = torque;
        this.sharedBornGrad = sharedBornGrad;
        int nAtoms = atoms.length;
        int nThreads = this.gkEnergyLoop.length;
        if (this.selfEnergy == null || this.selfEnergy.size() != atoms.length) {
            this.selfEnergy = AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI.createInstance(nThreads, nAtoms);
            this.crossEnergy = AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI.createInstance(nThreads, nAtoms);
        } else {
            this.selfEnergy.reset(parallelTeam, 0, nAtoms - 1);
            this.crossEnergy.reset(parallelTeam, 0, nAtoms - 1);
        }
    }

    public void run() {
        try {
            int nAtoms = this.atoms.length;
            int threadIndex = this.getThreadIndex();
            this.execute(0, nAtoms - 1, this.gkEnergyLoop[threadIndex]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing GK Energy in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void start() {
        this.sharedPermanentGKEnergy.set(0.0);
        this.sharedPolarizationGKEnergy.set(0.0);
        this.sharedGKEnergy.set(0.0);
        this.sharedInteractions.set(0);
    }

    public void finish() {
        if (logger.isLoggable(Level.FINER)) {
            int nAtoms = this.atoms.length;
            this.selfEnergy.reduce(0, nAtoms - 1);
            this.crossEnergy.reduce(0, nAtoms - 1);
            logger.finer(" Generalized Kirkwood Self-Energies and Cross-Energies\n");
            double selfSum = 0.0;
            double crossSum = 0.0;
            for (int i = 0; i < nAtoms; ++i) {
                double self = this.selfEnergy.get(i);
                double cross = this.crossEnergy.get(i);
                logger.finer(String.format("GKSELF   %5d %16.8f %16.8f", i, self, cross));
                selfSum += self;
                crossSum += cross;
            }
            logger.finer(String.format("       %16.8f %16.8f %16.8f\n", selfSum, crossSum, selfSum + crossSum));
        }
    }

    private class GKEnergyLoopQI
    extends IntegerForLoop {
        private final double[] dx_local;
        private final double[] gradI;
        private final double[] torqueI;
        private final double[] torqueK;
        private final double[] gI;
        private final double[] tI;
        private final double[] tK;
        private double rbi;
        PolarizableMultipole mI;
        PolarizableMultipole mK;
        QIFrame qiFrame;
        GKEnergyQI gkEnergyQI;
        private double xi;
        private double yi;
        private double zi;
        private double dedxi;
        private double dedyi;
        private double dedzi;
        private double dborni;
        private double trqxi;
        private double trqyi;
        private double trqzi;
        private int count;
        private int iSymm;
        private int threadID;
        private final double[][] transOp;
        private double gkEnergy;
        private double gkPermanentEnergy;
        private double gkPolarizationEnergy;
        final /* synthetic */ GKEnergyRegion this$0;

        GKEnergyLoopQI(GKEnergyRegion gKEnergyRegion) {
            GKEnergyRegion gKEnergyRegion2 = gKEnergyRegion;
            Objects.requireNonNull(gKEnergyRegion2);
            this.this$0 = gKEnergyRegion2;
            this.gradI = new double[3];
            this.torqueI = new double[3];
            this.torqueK = new double[3];
            this.gI = new double[3];
            this.tI = new double[3];
            this.tK = new double[3];
            this.mI = new PolarizableMultipole();
            this.mK = new PolarizableMultipole();
            this.qiFrame = new QIFrame();
            this.dx_local = new double[3];
            this.transOp = new double[3][3];
        }

        public void start() {
            this.gkEnergy = 0.0;
            this.gkPermanentEnergy = 0.0;
            this.gkPolarizationEnergy = 0.0;
            this.count = 0;
            this.threadID = this.getThreadIndex();
            this.gkEnergyQI = new GKEnergyQI(this.this$0.soluteDielectric, this.this$0.solventDielectric, this.this$0.gkc, this.this$0.gradient);
        }

        public void finish() {
            this.this$0.sharedInteractions.addAndGet(this.count);
            this.this$0.sharedGKEnergy.addAndGet(this.gkEnergy);
            this.this$0.sharedPermanentGKEnergy.addAndGet(this.gkPermanentEnergy);
            this.this$0.sharedPolarizationGKEnergy.addAndGet(this.gkPolarizationEnergy);
        }

        public void run(int lb, int ub) {
            double[] x = this.this$0.sXYZ[0][0];
            double[] y = this.this$0.sXYZ[0][1];
            double[] z = this.this$0.sXYZ[0][2];
            int nSymm = this.this$0.crystal.spaceGroup.symOps.size();
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            this.iSymm = 0;
            while (this.iSymm < nSymm) {
                SymOp symOp = (SymOp)symOps.get(this.iSymm);
                this.this$0.crystal.getTransformationOperator(symOp, this.transOp);
                for (int i = lb; i <= ub; ++i) {
                    int[] list;
                    if (!this.this$0.use[i]) continue;
                    this.dedxi = 0.0;
                    this.dedyi = 0.0;
                    this.dedzi = 0.0;
                    this.trqxi = 0.0;
                    this.trqyi = 0.0;
                    this.trqzi = 0.0;
                    this.dborni = 0.0;
                    this.xi = x[i];
                    this.yi = y[i];
                    this.zi = z[i];
                    this.rbi = this.this$0.born[i];
                    for (int k : list = this.this$0.neighborLists[this.iSymm][i]) {
                        if (!this.this$0.use[k]) continue;
                        this.interaction(i, k);
                    }
                    if (this.iSymm == 0) {
                        this.interaction(i, i);
                        switch (this.this$0.nonPolarModel) {
                            case BORN_SOLV: 
                            case BORN_CAV_DISP: {
                                double r = this.this$0.baseRadius[i] + 0.09 + this.this$0.probe;
                                double ratio = (this.this$0.baseRadius[i] + 0.09) / this.this$0.born[i];
                                ratio *= ratio;
                                ratio *= ratio * ratio;
                                double saTerm = this.this$0.surfaceTension * r * r * ratio / 6.0;
                                this.gkEnergy += saTerm;
                                this.this$0.sharedBornGrad.sub(this.threadID, i, 6.0 * saTerm / this.this$0.born[i]);
                                break;
                            }
                        }
                    }
                    if (!this.this$0.gradient) continue;
                    this.this$0.grad.add(this.threadID, i, this.dedxi, this.dedyi, this.dedzi);
                    this.this$0.torque.add(this.threadID, i, this.trqxi, this.trqyi, this.trqzi);
                    this.this$0.sharedBornGrad.add(this.threadID, i, this.dborni);
                }
                ++this.iSymm;
            }
        }

        private void interaction(int i, int k) {
            double eik;
            this.dx_local[0] = this.this$0.sXYZ[this.iSymm][0][k] - this.xi;
            this.dx_local[1] = this.this$0.sXYZ[this.iSymm][1][k] - this.yi;
            this.dx_local[2] = this.this$0.sXYZ[this.iSymm][2][k] - this.zi;
            double r2 = this.this$0.crystal.image(this.dx_local);
            if (r2 > this.this$0.cut2) {
                return;
            }
            this.mI.setPermanentMultipole(this.this$0.globalMultipole[0][i]);
            this.mI.setInducedDipole(this.this$0.inducedDipole[0][i], this.this$0.inducedDipoleCR[0][i]);
            this.mK.setPermanentMultipole(this.this$0.globalMultipole[this.iSymm][k]);
            this.mK.setInducedDipole(this.this$0.inducedDipole[this.iSymm][k], this.this$0.inducedDipoleCR[this.iSymm][k]);
            double selfScale = 1.0;
            if (i == k) {
                selfScale = 0.5;
            } else {
                this.qiFrame.setAndRotate(this.dx_local, this.mI, this.mK);
            }
            double rbk = this.this$0.born[k];
            this.gkEnergyQI.initPotential(this.dx_local, r2, this.rbi, rbk);
            if (!this.this$0.gradient) {
                eik = this.this$0.electric * selfScale * this.gkEnergyQI.multipoleEnergy(this.mI, this.mK);
                this.gkPermanentEnergy += eik;
                if (this.this$0.polarization != Polarization.NONE) {
                    double ep = this.this$0.electric * selfScale * this.gkEnergyQI.polarizationEnergy(this.mI, this.mK);
                    this.gkPolarizationEnergy += ep;
                    eik += ep;
                }
            } else if (i == k) {
                eik = this.this$0.electric * selfScale * this.gkEnergyQI.multipoleEnergy(this.mI, this.mK);
                this.gkPermanentEnergy += eik;
                if (this.this$0.polarization != Polarization.NONE) {
                    double mutualMask = 1.0;
                    if (this.this$0.polarization == Polarization.DIRECT) {
                        mutualMask = 0.0;
                    }
                    double ep = this.this$0.electric * selfScale * this.gkEnergyQI.polarizationEnergyAndGradient(this.mI, this.mK, mutualMask, this.gradI, this.torqueI, this.torqueK);
                    this.gkPolarizationEnergy += ep;
                    eik += ep;
                    this.trqxi += this.this$0.electric * selfScale * this.torqueI[0];
                    this.trqyi += this.this$0.electric * selfScale * this.torqueI[1];
                    this.trqzi += this.this$0.electric * selfScale * this.torqueI[2];
                    double tkx = this.this$0.electric * selfScale * this.torqueK[0];
                    double tky = this.this$0.electric * selfScale * this.torqueK[1];
                    double tkz = this.this$0.electric * selfScale * this.torqueK[2];
                    double rtkx = tkx * this.transOp[0][0] + tky * this.transOp[1][0] + tkz * this.transOp[2][0];
                    double rtky = tkx * this.transOp[0][1] + tky * this.transOp[1][1] + tkz * this.transOp[2][1];
                    double rtkz = tkx * this.transOp[0][2] + tky * this.transOp[1][2] + tkz * this.transOp[2][2];
                    this.this$0.torque.add(this.threadID, k, rtkx, rtky, rtkz);
                }
                this.gkEnergyQI.initBorn(this.dx_local, r2, this.rbi, rbk);
                double db = this.gkEnergyQI.multipoleEnergyBornGrad(this.mI, this.mK);
                if (this.this$0.polarization != Polarization.NONE) {
                    db += this.gkEnergyQI.polarizationEnergyBornGrad(this.mI, this.mK, this.this$0.polarization == Polarization.MUTUAL);
                }
                this.dborni += this.this$0.electric * this.rbi * db;
            } else {
                eik = this.this$0.electric * this.gkEnergyQI.multipoleEnergyAndGradient(this.mI, this.mK, this.gradI, this.torqueI, this.torqueK);
                this.gkPermanentEnergy += eik;
                if (this.this$0.polarization != Polarization.NONE) {
                    double mutualMask = 1.0;
                    if (this.this$0.polarization == Polarization.DIRECT) {
                        mutualMask = 0.0;
                    }
                    double ep = this.this$0.electric * this.gkEnergyQI.polarizationEnergyAndGradient(this.mI, this.mK, mutualMask, this.gI, this.tI, this.tK);
                    eik += ep;
                    this.gkPolarizationEnergy += ep;
                    for (int j = 0; j < 3; ++j) {
                        int n = j;
                        this.gradI[n] = this.gradI[n] + this.gI[j];
                        int n2 = j;
                        this.torqueI[n2] = this.torqueI[n2] + this.tI[j];
                        int n3 = j;
                        this.torqueK[n3] = this.torqueK[n3] + this.tK[j];
                    }
                }
                int j = 0;
                while (j < 3) {
                    int n = j;
                    this.gradI[n] = this.gradI[n] * this.this$0.electric;
                    int n4 = j;
                    this.torqueI[n4] = this.torqueI[n4] * this.this$0.electric;
                    int n5 = j++;
                    this.torqueK[n5] = this.torqueK[n5] * this.this$0.electric;
                }
                this.qiFrame.toGlobal(this.gradI);
                this.qiFrame.toGlobal(this.torqueI);
                this.qiFrame.toGlobal(this.torqueK);
                this.dedxi += this.gradI[0];
                this.dedyi += this.gradI[1];
                this.dedzi += this.gradI[2];
                this.trqxi += this.torqueI[0];
                this.trqyi += this.torqueI[1];
                this.trqzi += this.torqueI[2];
                double dedx = -this.gradI[0];
                double dedy = -this.gradI[1];
                double dedz = -this.gradI[2];
                double dedxk = dedx * this.transOp[0][0] + dedy * this.transOp[1][0] + dedz * this.transOp[2][0];
                double dedyk = dedx * this.transOp[0][1] + dedy * this.transOp[1][1] + dedz * this.transOp[2][1];
                double dedzk = dedx * this.transOp[0][2] + dedy * this.transOp[1][2] + dedz * this.transOp[2][2];
                double tkx = this.torqueK[0];
                double tky = this.torqueK[1];
                double tkz = this.torqueK[2];
                double rtkx = tkx * this.transOp[0][0] + tky * this.transOp[1][0] + tkz * this.transOp[2][0];
                double rtky = tkx * this.transOp[0][1] + tky * this.transOp[1][1] + tkz * this.transOp[2][1];
                double rtkz = tkx * this.transOp[0][2] + tky * this.transOp[1][2] + tkz * this.transOp[2][2];
                this.this$0.grad.add(this.threadID, k, dedxk, dedyk, dedzk);
                this.this$0.torque.add(this.threadID, k, rtkx, rtky, rtkz);
                this.gkEnergyQI.initBorn(this.dx_local, r2, this.rbi, rbk);
                double db = this.gkEnergyQI.multipoleEnergyBornGrad(this.mI, this.mK);
                if (this.this$0.polarization != Polarization.NONE) {
                    db += this.gkEnergyQI.polarizationEnergyBornGrad(this.mI, this.mK, this.this$0.polarization == Polarization.MUTUAL);
                }
                this.dborni += rbk * (db *= this.this$0.electric);
                this.this$0.sharedBornGrad.add(this.threadID, k, this.rbi * db);
            }
            if (i == k) {
                this.this$0.selfEnergy.add(this.threadID, i, eik);
            } else {
                double half = 0.5 * eik;
                this.this$0.crossEnergy.add(this.threadID, i, half);
                this.this$0.crossEnergy.add(this.threadID, k, half);
            }
            this.gkEnergy += eik;
            ++this.count;
        }
    }

    private class GKEnergyLoop
    extends IntegerForLoop {
        private final double[][] a;
        private final double[][] b;
        private final double[] gc;
        private final double[] gux;
        private final double[] guy;
        private final double[] guz;
        private final double[] gqxx;
        private final double[] gqyy;
        private final double[] gqzz;
        private final double[] gqxy;
        private final double[] gqxz;
        private final double[] gqyz;
        private final double[] dx_local;
        private double ci;
        private double uxi;
        private double uyi;
        private double uzi;
        private double qxxi;
        private double qxyi;
        private double qxzi;
        private double qyyi;
        private double qyzi;
        private double qzzi;
        private double ck;
        private double uxk;
        private double uyk;
        private double uzk;
        private double qxxk;
        private double qxyk;
        private double qxzk;
        private double qyyk;
        private double qyzk;
        private double qzzk;
        private double dxi;
        private double dyi;
        private double dzi;
        private double pxi;
        private double pyi;
        private double pzi;
        private double sxi;
        private double syi;
        private double szi;
        private double dxk;
        private double dyk;
        private double dzk;
        private double pxk;
        private double pyk;
        private double pzk;
        private double sxk;
        private double syk;
        private double szk;
        private double xr;
        private double yr;
        private double zr;
        private double xr2;
        private double yr2;
        private double zr2;
        private double rbi;
        private double rbk;
        private double xi;
        private double yi;
        private double zi;
        private double dedxi;
        private double dedyi;
        private double dedzi;
        private double dborni;
        private double trqxi;
        private double trqyi;
        private double trqzi;
        private int count;
        private int iSymm;
        private int threadID;
        private final double[][] transOp;
        private double gkPermanentEnergy;
        private double gkPolarizationEnergy;
        private double gkEnergy;
        final /* synthetic */ GKEnergyRegion this$0;

        GKEnergyLoop(GKEnergyRegion gKEnergyRegion) {
            GKEnergyRegion gKEnergyRegion2 = gKEnergyRegion;
            Objects.requireNonNull(gKEnergyRegion2);
            this.this$0 = gKEnergyRegion2;
            this.a = new double[6][4];
            this.b = new double[5][3];
            this.gc = new double[31];
            this.gux = new double[31];
            this.guy = new double[31];
            this.guz = new double[31];
            this.gqxx = new double[31];
            this.gqyy = new double[31];
            this.gqzz = new double[31];
            this.gqxy = new double[31];
            this.gqxz = new double[31];
            this.gqyz = new double[31];
            this.dx_local = new double[3];
            this.transOp = new double[3][3];
        }

        public void finish() {
            this.this$0.sharedInteractions.addAndGet(this.count);
            this.this$0.sharedGKEnergy.addAndGet(this.gkEnergy);
            this.this$0.sharedPermanentGKEnergy.addAndGet(this.gkPermanentEnergy);
            this.this$0.sharedPolarizationGKEnergy.addAndGet(this.gkPolarizationEnergy);
        }

        public void run(int lb, int ub) {
            double[] x = this.this$0.sXYZ[0][0];
            double[] y = this.this$0.sXYZ[0][1];
            double[] z = this.this$0.sXYZ[0][2];
            int nSymm = this.this$0.crystal.spaceGroup.symOps.size();
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            this.iSymm = 0;
            while (this.iSymm < nSymm) {
                SymOp symOp = (SymOp)symOps.get(this.iSymm);
                this.this$0.crystal.getTransformationOperator(symOp, this.transOp);
                for (int i = lb; i <= ub; ++i) {
                    int[] list;
                    if (!this.this$0.use[i]) continue;
                    this.dedxi = 0.0;
                    this.dedyi = 0.0;
                    this.dedzi = 0.0;
                    this.dborni = 0.0;
                    this.trqxi = 0.0;
                    this.trqyi = 0.0;
                    this.trqzi = 0.0;
                    this.xi = x[i];
                    this.yi = y[i];
                    this.zi = z[i];
                    double[] multipolei = this.this$0.globalMultipole[0][i];
                    this.ci = multipolei[0];
                    this.uxi = multipolei[1];
                    this.uyi = multipolei[2];
                    this.uzi = multipolei[3];
                    this.qxxi = multipolei[4] * 0.3333333333333333;
                    this.qyyi = multipolei[5] * 0.3333333333333333;
                    this.qzzi = multipolei[6] * 0.3333333333333333;
                    this.qxyi = multipolei[7] * 0.3333333333333333;
                    this.qxzi = multipolei[8] * 0.3333333333333333;
                    this.qyzi = multipolei[9] * 0.3333333333333333;
                    this.dxi = this.this$0.inducedDipole[0][i][0];
                    this.dyi = this.this$0.inducedDipole[0][i][1];
                    this.dzi = this.this$0.inducedDipole[0][i][2];
                    this.pxi = this.this$0.inducedDipoleCR[0][i][0];
                    this.pyi = this.this$0.inducedDipoleCR[0][i][1];
                    this.pzi = this.this$0.inducedDipoleCR[0][i][2];
                    this.sxi = this.dxi + this.pxi;
                    this.syi = this.dyi + this.pyi;
                    this.szi = this.dzi + this.pzi;
                    this.rbi = this.this$0.born[i];
                    for (int k : list = this.this$0.neighborLists[this.iSymm][i]) {
                        if (!this.this$0.use[k]) continue;
                        this.interaction(i, k);
                    }
                    if (this.iSymm == 0) {
                        this.interaction(i, i);
                        switch (this.this$0.nonPolarModel) {
                            case BORN_SOLV: 
                            case BORN_CAV_DISP: {
                                double r = this.this$0.baseRadius[i] + 0.09 + this.this$0.probe;
                                double ratio = (this.this$0.baseRadius[i] + 0.09) / this.this$0.born[i];
                                ratio *= ratio;
                                ratio *= ratio * ratio;
                                double saTerm = this.this$0.surfaceTension * r * r * ratio / 6.0;
                                this.gkEnergy += saTerm;
                                this.this$0.sharedBornGrad.sub(this.threadID, i, 6.0 * saTerm / this.this$0.born[i]);
                                break;
                            }
                        }
                    }
                    if (!this.this$0.gradient) continue;
                    this.this$0.grad.add(this.threadID, i, this.dedxi, this.dedyi, this.dedzi);
                    this.this$0.torque.add(this.threadID, i, this.trqxi, this.trqyi, this.trqzi);
                    this.this$0.sharedBornGrad.add(this.threadID, i, this.dborni);
                }
                ++this.iSymm;
            }
        }

        public void start() {
            this.gkEnergy = 0.0;
            this.gkPermanentEnergy = 0.0;
            this.gkPolarizationEnergy = 0.0;
            this.count = 0;
            this.threadID = this.getThreadIndex();
        }

        private void interaction(int i, int k) {
            this.dx_local[0] = this.this$0.sXYZ[this.iSymm][0][k] - this.xi;
            this.dx_local[1] = this.this$0.sXYZ[this.iSymm][1][k] - this.yi;
            this.dx_local[2] = this.this$0.sXYZ[this.iSymm][2][k] - this.zi;
            double r2 = this.this$0.crystal.image(this.dx_local);
            if (r2 > this.this$0.cut2) {
                return;
            }
            this.xr = this.dx_local[0];
            this.yr = this.dx_local[1];
            this.zr = this.dx_local[2];
            this.xr2 = this.xr * this.xr;
            this.yr2 = this.yr * this.yr;
            this.zr2 = this.zr * this.zr;
            this.rbk = this.this$0.born[k];
            double[] multipolek = this.this$0.globalMultipole[this.iSymm][k];
            this.ck = multipolek[0];
            this.uxk = multipolek[1];
            this.uyk = multipolek[2];
            this.uzk = multipolek[3];
            this.qxxk = multipolek[4] * 0.3333333333333333;
            this.qyyk = multipolek[5] * 0.3333333333333333;
            this.qzzk = multipolek[6] * 0.3333333333333333;
            this.qxyk = multipolek[7] * 0.3333333333333333;
            this.qxzk = multipolek[8] * 0.3333333333333333;
            this.qyzk = multipolek[9] * 0.3333333333333333;
            this.dxk = this.this$0.inducedDipole[this.iSymm][k][0];
            this.dyk = this.this$0.inducedDipole[this.iSymm][k][1];
            this.dzk = this.this$0.inducedDipole[this.iSymm][k][2];
            this.pxk = this.this$0.inducedDipoleCR[this.iSymm][k][0];
            this.pyk = this.this$0.inducedDipoleCR[this.iSymm][k][1];
            this.pzk = this.this$0.inducedDipoleCR[this.iSymm][k][2];
            this.sxk = this.dxk + this.pxk;
            this.syk = this.dyk + this.pyk;
            this.szk = this.dzk + this.pzk;
            double rb2 = this.rbi * this.rbk;
            double expterm = FastMath.exp((double)(-r2 / (this.this$0.gkc * rb2)));
            double expc = expterm / this.this$0.gkc;
            double expc1 = 1.0 - expc;
            double expcr = r2 * expterm / (this.this$0.gkc * this.this$0.gkc * rb2 * rb2);
            double dexpc = -2.0 / (this.this$0.gkc * rb2);
            double expcdexpc = -expc * dexpc;
            double dexpcr = 2.0 / (this.this$0.gkc * rb2 * rb2);
            double dgfdr = 0.5 * expterm * (1.0 + r2 / (rb2 * this.this$0.gkc));
            double gf2 = 1.0 / (r2 + rb2 * expterm);
            double gf = FastMath.sqrt((double)gf2);
            double gf3 = gf2 * gf;
            double gf5 = gf3 * gf2;
            double gf7 = gf5 * gf2;
            double gf9 = gf7 * gf2;
            double gf11 = gf9 * gf2;
            this.a[0][0] = gf;
            this.a[1][0] = -gf3;
            this.a[2][0] = 3.0 * gf5;
            this.a[3][0] = -15.0 * gf7;
            this.a[4][0] = 105.0 * gf9;
            this.a[5][0] = -945.0 * gf11;
            this.a[0][1] = expc1 * this.a[1][0];
            this.a[1][1] = expc1 * this.a[2][0];
            this.a[2][1] = expc1 * this.a[3][0];
            this.a[3][1] = expc1 * this.a[4][0];
            this.a[4][1] = expc1 * this.a[5][0];
            this.a[0][2] = expc1 * this.a[1][1] + expcdexpc * this.a[1][0];
            this.a[1][2] = expc1 * this.a[2][1] + expcdexpc * this.a[2][0];
            this.a[2][2] = expc1 * this.a[3][1] + expcdexpc * this.a[3][0];
            this.a[3][2] = expc1 * this.a[4][1] + expcdexpc * this.a[4][0];
            if (this.this$0.gradient) {
                expcdexpc = 2.0 * expcdexpc;
                this.a[0][3] = expc1 * this.a[1][2] + expcdexpc * this.a[1][1];
                this.a[1][3] = expc1 * this.a[2][2] + expcdexpc * this.a[2][1];
                this.a[2][3] = expc1 * this.a[3][2] + expcdexpc * this.a[3][1];
                expcdexpc = -expc * dexpc * dexpc;
                this.a[0][3] = this.a[0][3] + expcdexpc * this.a[1][0];
                this.a[1][3] = this.a[1][3] + expcdexpc * this.a[2][0];
                this.a[2][3] = this.a[2][3] + expcdexpc * this.a[3][0];
                this.b[0][0] = dgfdr * this.a[1][0];
                this.b[1][0] = dgfdr * this.a[2][0];
                this.b[2][0] = dgfdr * this.a[3][0];
                this.b[3][0] = dgfdr * this.a[4][0];
                this.b[4][0] = dgfdr * this.a[5][0];
                this.b[0][1] = this.b[1][0] - expcr * this.a[1][0] - expc * this.b[1][0];
                this.b[1][1] = this.b[2][0] - expcr * this.a[2][0] - expc * this.b[2][0];
                this.b[2][1] = this.b[3][0] - expcr * this.a[3][0] - expc * this.b[3][0];
                this.b[3][1] = this.b[4][0] - expcr * this.a[4][0] - expc * this.b[4][0];
                this.b[0][2] = this.b[1][1] - (expcr * (this.a[1][1] + dexpc * this.a[1][0]) + expc * (this.b[1][1] + dexpcr * this.a[1][0] + dexpc * this.b[1][0]));
                this.b[1][2] = this.b[2][1] - (expcr * (this.a[2][1] + dexpc * this.a[2][0]) + expc * (this.b[2][1] + dexpcr * this.a[2][0] + dexpc * this.b[2][0]));
                this.b[2][2] = this.b[3][1] - (expcr * (this.a[3][1] + dexpc * this.a[3][0]) + expc * (this.b[3][1] + dexpcr * this.a[3][0] + dexpc * this.b[3][0]));
                this.b[0][0] = this.this$0.electric * this.this$0.fc * this.b[0][0];
                this.b[0][1] = this.this$0.electric * this.this$0.fc * this.b[0][1];
                this.b[0][2] = this.this$0.electric * this.this$0.fc * this.b[0][2];
                this.b[1][0] = this.this$0.electric * this.this$0.fd * this.b[1][0];
                this.b[1][1] = this.this$0.electric * this.this$0.fd * this.b[1][1];
                this.b[1][2] = this.this$0.electric * this.this$0.fd * this.b[1][2];
                this.b[2][0] = this.this$0.electric * this.this$0.fq * this.b[2][0];
                this.b[2][1] = this.this$0.electric * this.this$0.fq * this.b[2][1];
                this.b[2][2] = this.this$0.electric * this.this$0.fq * this.b[2][2];
            }
            this.a[0][0] = this.this$0.electric * this.this$0.fc * this.a[0][0];
            this.a[0][1] = this.this$0.electric * this.this$0.fc * this.a[0][1];
            this.a[0][2] = this.this$0.electric * this.this$0.fc * this.a[0][2];
            this.a[0][3] = this.this$0.electric * this.this$0.fc * this.a[0][3];
            this.a[1][0] = this.this$0.electric * this.this$0.fd * this.a[1][0];
            this.a[1][1] = this.this$0.electric * this.this$0.fd * this.a[1][1];
            this.a[1][2] = this.this$0.electric * this.this$0.fd * this.a[1][2];
            this.a[1][3] = this.this$0.electric * this.this$0.fd * this.a[1][3];
            this.a[2][0] = this.this$0.electric * this.this$0.fq * this.a[2][0];
            this.a[2][1] = this.this$0.electric * this.this$0.fq * this.a[2][1];
            this.a[2][2] = this.this$0.electric * this.this$0.fq * this.a[2][2];
            this.a[2][3] = this.this$0.electric * this.this$0.fq * this.a[2][3];
            this.energyTensors();
            double eik = this.energy(i, k);
            this.gkEnergy += eik;
            ++this.count;
            if (this.this$0.gradient) {
                this.gradientTensors();
                this.permanentEnergyGradient(i, k);
                if (this.this$0.polarization != Polarization.NONE) {
                    this.polarizationEnergyGradient(i, k);
                }
            }
        }

        private void energyTensors() {
            this.gc[1] = this.a[0][0];
            this.gux[1] = this.xr * this.a[1][0];
            this.guy[1] = this.yr * this.a[1][0];
            this.guz[1] = this.zr * this.a[1][0];
            this.gqxx[1] = this.xr2 * this.a[2][0];
            this.gqyy[1] = this.yr2 * this.a[2][0];
            this.gqzz[1] = this.zr2 * this.a[2][0];
            this.gqxy[1] = this.xr * this.yr * this.a[2][0];
            this.gqxz[1] = this.xr * this.zr * this.a[2][0];
            this.gqyz[1] = this.yr * this.zr * this.a[2][0];
            this.gc[2] = this.xr * this.a[0][1];
            this.gc[3] = this.yr * this.a[0][1];
            this.gc[4] = this.zr * this.a[0][1];
            this.gux[2] = this.a[1][0] + this.xr2 * this.a[1][1];
            this.gux[3] = this.xr * this.yr * this.a[1][1];
            this.gux[4] = this.xr * this.zr * this.a[1][1];
            this.guy[2] = this.gux[3];
            this.guy[3] = this.a[1][0] + this.yr2 * this.a[1][1];
            this.guy[4] = this.yr * this.zr * this.a[1][1];
            this.guz[2] = this.gux[4];
            this.guz[3] = this.guy[4];
            this.guz[4] = this.a[1][0] + this.zr2 * this.a[1][1];
            this.gqxx[2] = this.xr * (2.0 * this.a[2][0] + this.xr2 * this.a[2][1]);
            this.gqxx[3] = this.yr * this.xr2 * this.a[2][1];
            this.gqxx[4] = this.zr * this.xr2 * this.a[2][1];
            this.gqyy[2] = this.xr * this.yr2 * this.a[2][1];
            this.gqyy[3] = this.yr * (2.0 * this.a[2][0] + this.yr2 * this.a[2][1]);
            this.gqyy[4] = this.zr * this.yr2 * this.a[2][1];
            this.gqzz[2] = this.xr * this.zr2 * this.a[2][1];
            this.gqzz[3] = this.yr * this.zr2 * this.a[2][1];
            this.gqzz[4] = this.zr * (2.0 * this.a[2][0] + this.zr2 * this.a[2][1]);
            this.gqxy[2] = this.yr * (this.a[2][0] + this.xr2 * this.a[2][1]);
            this.gqxy[3] = this.xr * (this.a[2][0] + this.yr2 * this.a[2][1]);
            this.gqxy[4] = this.zr * this.xr * this.yr * this.a[2][1];
            this.gqxz[2] = this.zr * (this.a[2][0] + this.xr2 * this.a[2][1]);
            this.gqxz[3] = this.gqxy[4];
            this.gqxz[4] = this.xr * (this.a[2][0] + this.zr2 * this.a[2][1]);
            this.gqyz[2] = this.gqxy[4];
            this.gqyz[3] = this.zr * (this.a[2][0] + this.yr2 * this.a[2][1]);
            this.gqyz[4] = this.yr * (this.a[2][0] + this.zr2 * this.a[2][1]);
            this.gc[5] = this.a[0][1] + this.xr2 * this.a[0][2];
            this.gc[6] = this.xr * this.yr * this.a[0][2];
            this.gc[7] = this.xr * this.zr * this.a[0][2];
            this.gc[8] = this.a[0][1] + this.yr2 * this.a[0][2];
            this.gc[9] = this.yr * this.zr * this.a[0][2];
            this.gc[10] = this.a[0][1] + this.zr2 * this.a[0][2];
            this.gux[5] = this.xr * (3.0 * this.a[1][1] + this.xr2 * this.a[1][2]);
            this.gux[6] = this.yr * (this.a[1][1] + this.xr2 * this.a[1][2]);
            this.gux[7] = this.zr * (this.a[1][1] + this.xr2 * this.a[1][2]);
            this.gux[8] = this.xr * (this.a[1][1] + this.yr2 * this.a[1][2]);
            this.gux[9] = this.zr * this.xr * this.yr * this.a[1][2];
            this.gux[10] = this.xr * (this.a[1][1] + this.zr2 * this.a[1][2]);
            this.guy[5] = this.yr * (this.a[1][1] + this.xr2 * this.a[1][2]);
            this.guy[6] = this.xr * (this.a[1][1] + this.yr2 * this.a[1][2]);
            this.guy[7] = this.gux[9];
            this.guy[8] = this.yr * (3.0 * this.a[1][1] + this.yr2 * this.a[1][2]);
            this.guy[9] = this.zr * (this.a[1][1] + this.yr2 * this.a[1][2]);
            this.guy[10] = this.yr * (this.a[1][1] + this.zr2 * this.a[1][2]);
            this.guz[5] = this.zr * (this.a[1][1] + this.xr2 * this.a[1][2]);
            this.guz[6] = this.gux[9];
            this.guz[7] = this.xr * (this.a[1][1] + this.zr2 * this.a[1][2]);
            this.guz[8] = this.zr * (this.a[1][1] + this.yr2 * this.a[1][2]);
            this.guz[9] = this.yr * (this.a[1][1] + this.zr2 * this.a[1][2]);
            this.guz[10] = this.zr * (3.0 * this.a[1][1] + this.zr2 * this.a[1][2]);
            this.gqxx[5] = 2.0 * this.a[2][0] + this.xr2 * (5.0 * this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqxx[6] = this.yr * this.xr * (2.0 * this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqxx[7] = this.zr * this.xr * (2.0 * this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqxx[8] = this.xr2 * (this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqxx[9] = this.zr * this.yr * this.xr2 * this.a[2][2];
            this.gqxx[10] = this.xr2 * (this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqyy[5] = this.yr2 * (this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqyy[6] = this.xr * this.yr * (2.0 * this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqyy[7] = this.xr * this.zr * this.yr2 * this.a[2][2];
            this.gqyy[8] = 2.0 * this.a[2][0] + this.yr2 * (5.0 * this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqyy[9] = this.yr * this.zr * (2.0 * this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqyy[10] = this.yr2 * (this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqzz[5] = this.zr2 * (this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqzz[6] = this.xr * this.yr * this.zr2 * this.a[2][2];
            this.gqzz[7] = this.xr * this.zr * (2.0 * this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqzz[8] = this.zr2 * (this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqzz[9] = this.yr * this.zr * (2.0 * this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqzz[10] = 2.0 * this.a[2][0] + this.zr2 * (5.0 * this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqxy[5] = this.xr * this.yr * (3.0 * this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqxy[6] = this.a[2][0] + (this.xr2 + this.yr2) * this.a[2][1] + this.xr2 * this.yr2 * this.a[2][2];
            this.gqxy[7] = this.zr * this.yr * (this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqxy[8] = this.xr * this.yr * (3.0 * this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqxy[9] = this.zr * this.xr * (this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqxy[10] = this.xr * this.yr * (this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqxz[5] = this.xr * this.zr * (3.0 * this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqxz[6] = this.yr * this.zr * (this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqxz[7] = this.a[2][0] + (this.xr2 + this.zr2) * this.a[2][1] + this.xr2 * this.zr2 * this.a[2][2];
            this.gqxz[8] = this.xr * this.zr * (this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqxz[9] = this.xr * this.yr * (this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqxz[10] = this.xr * this.zr * (3.0 * this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqyz[5] = this.zr * this.yr * (this.a[2][1] + this.xr2 * this.a[2][2]);
            this.gqyz[6] = this.xr * this.zr * (this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqyz[7] = this.xr * this.yr * (this.a[2][1] + this.zr2 * this.a[2][2]);
            this.gqyz[8] = this.yr * this.zr * (3.0 * this.a[2][1] + this.yr2 * this.a[2][2]);
            this.gqyz[9] = this.a[2][0] + (this.yr2 + this.zr2) * this.a[2][1] + this.yr2 * this.zr2 * this.a[2][2];
            this.gqyz[10] = this.yr * this.zr * (3.0 * this.a[2][1] + this.zr2 * this.a[2][2]);
        }

        private double energy(int i, int k) {
            double esym = this.ci * this.ck * this.gc[1] - (this.uxi * (this.uxk * this.gux[2] + this.uyk * this.guy[2] + this.uzk * this.guz[2]) + this.uyi * (this.uxk * this.gux[3] + this.uyk * this.guy[3] + this.uzk * this.guz[3]) + this.uzi * (this.uxk * this.gux[4] + this.uyk * this.guy[4] + this.uzk * this.guz[4]));
            double ewi = this.ci * (this.uxk * this.gc[2] + this.uyk * this.gc[3] + this.uzk * this.gc[4]) - this.ck * (this.uxi * this.gux[1] + this.uyi * this.guy[1] + this.uzi * this.guz[1]) + this.ci * (this.qxxk * this.gc[5] + this.qyyk * this.gc[8] + this.qzzk * this.gc[10] + 2.0 * (this.qxyk * this.gc[6] + this.qxzk * this.gc[7] + this.qyzk * this.gc[9])) + this.ck * (this.qxxi * this.gqxx[1] + this.qyyi * this.gqyy[1] + this.qzzi * this.gqzz[1] + 2.0 * (this.qxyi * this.gqxy[1] + this.qxzi * this.gqxz[1] + this.qyzi * this.gqyz[1])) - this.uxi * (this.qxxk * this.gux[5] + this.qyyk * this.gux[8] + this.qzzk * this.gux[10] + 2.0 * (this.qxyk * this.gux[6] + this.qxzk * this.gux[7] + this.qyzk * this.gux[9])) - this.uyi * (this.qxxk * this.guy[5] + this.qyyk * this.guy[8] + this.qzzk * this.guy[10] + 2.0 * (this.qxyk * this.guy[6] + this.qxzk * this.guy[7] + this.qyzk * this.guy[9])) - this.uzi * (this.qxxk * this.guz[5] + this.qyyk * this.guz[8] + this.qzzk * this.guz[10] + 2.0 * (this.qxyk * this.guz[6] + this.qxzk * this.guz[7] + this.qyzk * this.guz[9])) + this.uxk * (this.qxxi * this.gqxx[2] + this.qyyi * this.gqyy[2] + this.qzzi * this.gqzz[2] + 2.0 * (this.qxyi * this.gqxy[2] + this.qxzi * this.gqxz[2] + this.qyzi * this.gqyz[2])) + this.uyk * (this.qxxi * this.gqxx[3] + this.qyyi * this.gqyy[3] + this.qzzi * this.gqzz[3] + 2.0 * (this.qxyi * this.gqxy[3] + this.qxzi * this.gqxz[3] + this.qyzi * this.gqyz[3])) + this.uzk * (this.qxxi * this.gqxx[4] + this.qyyi * this.gqyy[4] + this.qzzi * this.gqzz[4] + 2.0 * (this.qxyi * this.gqxy[4] + this.qxzi * this.gqxz[4] + this.qyzi * this.gqyz[4])) + this.qxxi * (this.qxxk * this.gqxx[5] + this.qyyk * this.gqxx[8] + this.qzzk * this.gqxx[10] + 2.0 * (this.qxyk * this.gqxx[6] + this.qxzk * this.gqxx[7] + this.qyzk * this.gqxx[9])) + this.qyyi * (this.qxxk * this.gqyy[5] + this.qyyk * this.gqyy[8] + this.qzzk * this.gqyy[10] + 2.0 * (this.qxyk * this.gqyy[6] + this.qxzk * this.gqyy[7] + this.qyzk * this.gqyy[9])) + this.qzzi * (this.qxxk * this.gqzz[5] + this.qyyk * this.gqzz[8] + this.qzzk * this.gqzz[10] + 2.0 * (this.qxyk * this.gqzz[6] + this.qxzk * this.gqzz[7] + this.qyzk * this.gqzz[9])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxy[5] + this.qyyk * this.gqxy[8] + this.qzzk * this.gqxy[10] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxy[7] + this.qyzk * this.gqxy[9])) + this.qxzi * (this.qxxk * this.gqxz[5] + this.qyyk * this.gqxz[8] + this.qzzk * this.gqxz[10] + 2.0 * (this.qxyk * this.gqxz[6] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqxz[9])) + this.qyzi * (this.qxxk * this.gqyz[5] + this.qyyk * this.gqyz[8] + this.qzzk * this.gqyz[10] + 2.0 * (this.qxyk * this.gqyz[6] + this.qxzk * this.gqyz[7] + this.qyzk * this.gqyz[9])));
            double ewk = this.ci * (this.uxk * this.gux[1] + this.uyk * this.guy[1] + this.uzk * this.guz[1]) - this.ck * (this.uxi * this.gc[2] + this.uyi * this.gc[3] + this.uzi * this.gc[4]) + this.ci * (this.qxxk * this.gqxx[1] + this.qyyk * this.gqyy[1] + this.qzzk * this.gqzz[1] + 2.0 * (this.qxyk * this.gqxy[1] + this.qxzk * this.gqxz[1] + this.qyzk * this.gqyz[1])) + this.ck * (this.qxxi * this.gc[5] + this.qyyi * this.gc[8] + this.qzzi * this.gc[10] + 2.0 * (this.qxyi * this.gc[6] + this.qxzi * this.gc[7] + this.qyzi * this.gc[9])) - this.uxi * (this.qxxk * this.gqxx[2] + this.qyyk * this.gqyy[2] + this.qzzk * this.gqzz[2] + 2.0 * (this.qxyk * this.gqxy[2] + this.qxzk * this.gqxz[2] + this.qyzk * this.gqyz[2])) - this.uyi * (this.qxxk * this.gqxx[3] + this.qyyk * this.gqyy[3] + this.qzzk * this.gqzz[3] + 2.0 * (this.qxyk * this.gqxy[3] + this.qxzk * this.gqxz[3] + this.qyzk * this.gqyz[3])) - this.uzi * (this.qxxk * this.gqxx[4] + this.qyyk * this.gqyy[4] + this.qzzk * this.gqzz[4] + 2.0 * (this.qxyk * this.gqxy[4] + this.qxzk * this.gqxz[4] + this.qyzk * this.gqyz[4])) + this.uxk * (this.qxxi * this.gux[5] + this.qyyi * this.gux[8] + this.qzzi * this.gux[10] + 2.0 * (this.qxyi * this.gux[6] + this.qxzi * this.gux[7] + this.qyzi * this.gux[9])) + this.uyk * (this.qxxi * this.guy[5] + this.qyyi * this.guy[8] + this.qzzi * this.guy[10] + 2.0 * (this.qxyi * this.guy[6] + this.qxzi * this.guy[7] + this.qyzi * this.guy[9])) + this.uzk * (this.qxxi * this.guz[5] + this.qyyi * this.guz[8] + this.qzzi * this.guz[10] + 2.0 * (this.qxyi * this.guz[6] + this.qxzi * this.guz[7] + this.qyzi * this.guz[9])) + this.qxxi * (this.qxxk * this.gqxx[5] + this.qyyk * this.gqyy[5] + this.qzzk * this.gqzz[5] + 2.0 * (this.qxyk * this.gqxy[5] + this.qxzk * this.gqxz[5] + this.qyzk * this.gqyz[5])) + this.qyyi * (this.qxxk * this.gqxx[8] + this.qyyk * this.gqyy[8] + this.qzzk * this.gqzz[8] + 2.0 * (this.qxyk * this.gqxy[8] + this.qxzk * this.gqxz[8] + this.qyzk * this.gqyz[8])) + this.qzzi * (this.qxxk * this.gqxx[10] + this.qyyk * this.gqyy[10] + this.qzzk * this.gqzz[10] + 2.0 * (this.qxyk * this.gqxy[10] + this.qxzk * this.gqxz[10] + this.qyzk * this.gqyz[10])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxx[6] + this.qyyk * this.gqyy[6] + this.qzzk * this.gqzz[6] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxz[6] + this.qyzk * this.gqyz[6])) + this.qxzi * (this.qxxk * this.gqxx[7] + this.qyyk * this.gqyy[7] + this.qzzk * this.gqzz[7] + 2.0 * (this.qxyk * this.gqxy[7] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqyz[7])) + this.qyzi * (this.qxxk * this.gqxx[9] + this.qyyk * this.gqyy[9] + this.qzzk * this.gqzz[9] + 2.0 * (this.qxyk * this.gqxy[9] + this.qxzk * this.gqxz[9] + this.qyzk * this.gqyz[9])));
            double e = esym + 0.5 * (ewi + ewk);
            double ei = 0.0;
            if (this.this$0.polarization != Polarization.NONE) {
                double esymi = -this.uxi * (this.dxk * this.gux[2] + this.dyk * this.guy[2] + this.dzk * this.guz[2]) - this.uyi * (this.dxk * this.gux[3] + this.dyk * this.guy[3] + this.dzk * this.guz[3]) - this.uzi * (this.dxk * this.gux[4] + this.dyk * this.guy[4] + this.dzk * this.guz[4]) - this.uxk * (this.dxi * this.gux[2] + this.dyi * this.guy[2] + this.dzi * this.guz[2]) - this.uyk * (this.dxi * this.gux[3] + this.dyi * this.guy[3] + this.dzi * this.guz[3]) - this.uzk * (this.dxi * this.gux[4] + this.dyi * this.guy[4] + this.dzi * this.guz[4]);
                double ewii = this.ci * (this.dxk * this.gc[2] + this.dyk * this.gc[3] + this.dzk * this.gc[4]) - this.ck * (this.dxi * this.gux[1] + this.dyi * this.guy[1] + this.dzi * this.guz[1]) - this.dxi * (this.qxxk * this.gux[5] + this.qyyk * this.gux[8] + this.qzzk * this.gux[10] + 2.0 * (this.qxyk * this.gux[6] + this.qxzk * this.gux[7] + this.qyzk * this.gux[9])) - this.dyi * (this.qxxk * this.guy[5] + this.qyyk * this.guy[8] + this.qzzk * this.guy[10] + 2.0 * (this.qxyk * this.guy[6] + this.qxzk * this.guy[7] + this.qyzk * this.guy[9])) - this.dzi * (this.qxxk * this.guz[5] + this.qyyk * this.guz[8] + this.qzzk * this.guz[10] + 2.0 * (this.qxyk * this.guz[6] + this.qxzk * this.guz[7] + this.qyzk * this.guz[9])) + this.dxk * (this.qxxi * this.gqxx[2] + this.qyyi * this.gqyy[2] + this.qzzi * this.gqzz[2] + 2.0 * (this.qxyi * this.gqxy[2] + this.qxzi * this.gqxz[2] + this.qyzi * this.gqyz[2])) + this.dyk * (this.qxxi * this.gqxx[3] + this.qyyi * this.gqyy[3] + this.qzzi * this.gqzz[3] + 2.0 * (this.qxyi * this.gqxy[3] + this.qxzi * this.gqxz[3] + this.qyzi * this.gqyz[3])) + this.dzk * (this.qxxi * this.gqxx[4] + this.qyyi * this.gqyy[4] + this.qzzi * this.gqzz[4] + 2.0 * (this.qxyi * this.gqxy[4] + this.qxzi * this.gqxz[4] + this.qyzi * this.gqyz[4]));
                double ewki = this.ci * (this.dxk * this.gux[1] + this.dyk * this.guy[1] + this.dzk * this.guz[1]) - this.ck * (this.dxi * this.gc[2] + this.dyi * this.gc[3] + this.dzi * this.gc[4]) - this.dxi * (this.qxxk * this.gqxx[2] + this.qyyk * this.gqyy[2] + this.qzzk * this.gqzz[2] + 2.0 * (this.qxyk * this.gqxy[2] + this.qxzk * this.gqxz[2] + this.qyzk * this.gqyz[2])) - this.dyi * (this.qxxk * this.gqxx[3] + this.qyyk * this.gqyy[3] + this.qzzk * this.gqzz[3] + 2.0 * (this.qxyk * this.gqxy[3] + this.qxzk * this.gqxz[3] + this.qyzk * this.gqyz[3])) - this.dzi * (this.qxxk * this.gqxx[4] + this.qyyk * this.gqyy[4] + this.qzzk * this.gqzz[4] + 2.0 * (this.qxyk * this.gqxy[4] + this.qxzk * this.gqxz[4] + this.qyzk * this.gqyz[4])) + this.dxk * (this.qxxi * this.gux[5] + this.qyyi * this.gux[8] + this.qzzi * this.gux[10] + 2.0 * (this.qxyi * this.gux[6] + this.qxzi * this.gux[7] + this.qyzi * this.gux[9])) + this.dyk * (this.qxxi * this.guy[5] + this.qyyi * this.guy[8] + this.qzzi * this.guy[10] + 2.0 * (this.qxyi * this.guy[6] + this.qxzi * this.guy[7] + this.qyzi * this.guy[9])) + this.dzk * (this.qxxi * this.guz[5] + this.qyyi * this.guz[8] + this.qzzi * this.guz[10] + 2.0 * (this.qxyi * this.guz[6] + this.qxzi * this.guz[7] + this.qyzi * this.guz[9]));
                ei = 0.5 * (esymi + 0.5 * (ewii + ewki));
            }
            if (i == k) {
                this.this$0.selfEnergy.add(this.threadID, i, (e *= 0.5) + (ei *= 0.5));
            } else {
                double half = 0.5 * (e + ei);
                this.this$0.crossEnergy.add(this.threadID, i, half);
                this.this$0.crossEnergy.add(this.threadID, k, half);
            }
            this.gkPermanentEnergy += e;
            this.gkPolarizationEnergy += ei;
            return e + ei;
        }

        private void gradientTensors() {
            this.gc[21] = this.b[0][0];
            this.gux[21] = this.xr * this.b[1][0];
            this.guy[21] = this.yr * this.b[1][0];
            this.guz[21] = this.zr * this.b[1][0];
            this.gqxx[21] = this.xr2 * this.b[2][0];
            this.gqyy[21] = this.yr2 * this.b[2][0];
            this.gqzz[21] = this.zr2 * this.b[2][0];
            this.gqxy[21] = this.xr * this.yr * this.b[2][0];
            this.gqxz[21] = this.xr * this.zr * this.b[2][0];
            this.gqyz[21] = this.yr * this.zr * this.b[2][0];
            this.gc[22] = this.xr * this.b[0][1];
            this.gc[23] = this.yr * this.b[0][1];
            this.gc[24] = this.zr * this.b[0][1];
            this.gux[22] = this.b[1][0] + this.xr2 * this.b[1][1];
            this.gux[23] = this.xr * this.yr * this.b[1][1];
            this.gux[24] = this.xr * this.zr * this.b[1][1];
            this.guy[22] = this.gux[23];
            this.guy[23] = this.b[1][0] + this.yr2 * this.b[1][1];
            this.guy[24] = this.yr * this.zr * this.b[1][1];
            this.guz[22] = this.gux[24];
            this.guz[23] = this.guy[24];
            this.guz[24] = this.b[1][0] + this.zr2 * this.b[1][1];
            this.gqxx[22] = this.xr * (2.0 * this.b[2][0] + this.xr2 * this.b[2][1]);
            this.gqxx[23] = this.yr * this.xr2 * this.b[2][1];
            this.gqxx[24] = this.zr * this.xr2 * this.b[2][1];
            this.gqyy[22] = this.xr * this.yr2 * this.b[2][1];
            this.gqyy[23] = this.yr * (2.0 * this.b[2][0] + this.yr2 * this.b[2][1]);
            this.gqyy[24] = this.zr * this.yr2 * this.b[2][1];
            this.gqzz[22] = this.xr * this.zr2 * this.b[2][1];
            this.gqzz[23] = this.yr * this.zr2 * this.b[2][1];
            this.gqzz[24] = this.zr * (2.0 * this.b[2][0] + this.zr2 * this.b[2][1]);
            this.gqxy[22] = this.yr * (this.b[2][0] + this.xr2 * this.b[2][1]);
            this.gqxy[23] = this.xr * (this.b[2][0] + this.yr2 * this.b[2][1]);
            this.gqxy[24] = this.zr * this.xr * this.yr * this.b[2][1];
            this.gqxz[22] = this.zr * (this.b[2][0] + this.xr2 * this.b[2][1]);
            this.gqxz[23] = this.gqxy[24];
            this.gqxz[24] = this.xr * (this.b[2][0] + this.zr2 * this.b[2][1]);
            this.gqyz[22] = this.gqxy[24];
            this.gqyz[23] = this.zr * (this.b[2][0] + this.yr2 * this.b[2][1]);
            this.gqyz[24] = this.yr * (this.b[2][0] + this.zr2 * this.b[2][1]);
            this.gc[25] = this.b[0][1] + this.xr2 * this.b[0][2];
            this.gc[26] = this.xr * this.yr * this.b[0][2];
            this.gc[27] = this.xr * this.zr * this.b[0][2];
            this.gc[28] = this.b[0][1] + this.yr2 * this.b[0][2];
            this.gc[29] = this.yr * this.zr * this.b[0][2];
            this.gc[30] = this.b[0][1] + this.zr2 * this.b[0][2];
            this.gux[25] = this.xr * (3.0 * this.b[1][1] + this.xr2 * this.b[1][2]);
            this.gux[26] = this.yr * (this.b[1][1] + this.xr2 * this.b[1][2]);
            this.gux[27] = this.zr * (this.b[1][1] + this.xr2 * this.b[1][2]);
            this.gux[28] = this.xr * (this.b[1][1] + this.yr2 * this.b[1][2]);
            this.gux[29] = this.zr * this.xr * this.yr * this.b[1][2];
            this.gux[30] = this.xr * (this.b[1][1] + this.zr2 * this.b[1][2]);
            this.guy[25] = this.yr * (this.b[1][1] + this.xr2 * this.b[1][2]);
            this.guy[26] = this.xr * (this.b[1][1] + this.yr2 * this.b[1][2]);
            this.guy[27] = this.gux[29];
            this.guy[28] = this.yr * (3.0 * this.b[1][1] + this.yr2 * this.b[1][2]);
            this.guy[29] = this.zr * (this.b[1][1] + this.yr2 * this.b[1][2]);
            this.guy[30] = this.yr * (this.b[1][1] + this.zr2 * this.b[1][2]);
            this.guz[25] = this.zr * (this.b[1][1] + this.xr2 * this.b[1][2]);
            this.guz[26] = this.gux[29];
            this.guz[27] = this.xr * (this.b[1][1] + this.zr2 * this.b[1][2]);
            this.guz[28] = this.zr * (this.b[1][1] + this.yr2 * this.b[1][2]);
            this.guz[29] = this.yr * (this.b[1][1] + this.zr2 * this.b[1][2]);
            this.guz[30] = this.zr * (3.0 * this.b[1][1] + this.zr2 * this.b[1][2]);
            this.gqxx[25] = 2.0 * this.b[2][0] + this.xr2 * (5.0 * this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqxx[26] = this.yr * this.xr * (2.0 * this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqxx[27] = this.zr * this.xr * (2.0 * this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqxx[28] = this.xr2 * (this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqxx[29] = this.zr * this.yr * this.xr2 * this.b[2][2];
            this.gqxx[30] = this.xr2 * (this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqyy[25] = this.yr2 * (this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqyy[26] = this.xr * this.yr * (2.0 * this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqyy[27] = this.xr * this.zr * this.yr2 * this.b[2][2];
            this.gqyy[28] = 2.0 * this.b[2][0] + this.yr2 * (5.0 * this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqyy[29] = this.yr * this.zr * (2.0 * this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqyy[30] = this.yr2 * (this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqzz[25] = this.zr2 * (this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqzz[26] = this.xr * this.yr * this.zr2 * this.b[2][2];
            this.gqzz[27] = this.xr * this.zr * (2.0 * this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqzz[28] = this.zr2 * (this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqzz[29] = this.yr * this.zr * (2.0 * this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqzz[30] = 2.0 * this.b[2][0] + this.zr2 * (5.0 * this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqxy[25] = this.xr * this.yr * (3.0 * this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqxy[26] = this.b[2][0] + (this.xr2 + this.yr2) * this.b[2][1] + this.xr2 * this.yr2 * this.b[2][2];
            this.gqxy[27] = this.zr * this.yr * (this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqxy[28] = this.xr * this.yr * (3.0 * this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqxy[29] = this.zr * this.xr * (this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqxy[30] = this.xr * this.yr * (this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqxz[25] = this.xr * this.zr * (3.0 * this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqxz[26] = this.yr * this.zr * (this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqxz[27] = this.b[2][0] + (this.xr2 + this.zr2) * this.b[2][1] + this.xr2 * this.zr2 * this.b[2][2];
            this.gqxz[28] = this.xr * this.zr * (this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqxz[29] = this.xr * this.yr * (this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqxz[30] = this.xr * this.zr * (3.0 * this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqyz[25] = this.zr * this.yr * (this.b[2][1] + this.xr2 * this.b[2][2]);
            this.gqyz[26] = this.xr * this.zr * (this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqyz[27] = this.xr * this.yr * (this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gqyz[28] = this.yr * this.zr * (3.0 * this.b[2][1] + this.yr2 * this.b[2][2]);
            this.gqyz[29] = this.b[2][0] + (this.yr2 + this.zr2) * this.b[2][1] + this.yr2 * this.zr2 * this.b[2][2];
            this.gqyz[30] = this.yr * this.zr * (3.0 * this.b[2][1] + this.zr2 * this.b[2][2]);
            this.gc[11] = this.xr * (3.0 * this.a[0][2] + this.xr2 * this.a[0][3]);
            this.gc[12] = this.yr * (this.a[0][2] + this.xr2 * this.a[0][3]);
            this.gc[13] = this.zr * (this.a[0][2] + this.xr2 * this.a[0][3]);
            this.gc[14] = this.xr * (this.a[0][2] + this.yr2 * this.a[0][3]);
            this.gc[15] = this.xr * this.yr * this.zr * this.a[0][3];
            this.gc[16] = this.xr * (this.a[0][2] + this.zr2 * this.a[0][3]);
            this.gc[17] = this.yr * (3.0 * this.a[0][2] + this.yr2 * this.a[0][3]);
            this.gc[18] = this.zr * (this.a[0][2] + this.yr2 * this.a[0][3]);
            this.gc[19] = this.yr * (this.a[0][2] + this.zr2 * this.a[0][3]);
            this.gc[20] = this.zr * (3.0 * this.a[0][2] + this.zr2 * this.a[0][3]);
            this.gux[11] = 3.0 * this.a[1][1] + this.xr2 * (6.0 * this.a[1][2] + this.xr2 * this.a[1][3]);
            this.gux[12] = this.xr * this.yr * (3.0 * this.a[1][2] + this.xr2 * this.a[1][3]);
            this.gux[13] = this.xr * this.zr * (3.0 * this.a[1][2] + this.xr2 * this.a[1][3]);
            this.gux[14] = this.a[1][1] + (this.xr2 + this.yr2) * this.a[1][2] + this.xr2 * this.yr2 * this.a[1][3];
            this.gux[15] = this.yr * this.zr * (this.a[1][2] + this.xr2 * this.a[1][3]);
            this.gux[16] = this.a[1][1] + (this.xr2 + this.zr2) * this.a[1][2] + this.xr2 * this.zr2 * this.a[1][3];
            this.gux[17] = this.xr * this.yr * (3.0 * this.a[1][2] + this.yr2 * this.a[1][3]);
            this.gux[18] = this.xr * this.zr * (this.a[1][2] + this.yr2 * this.a[1][3]);
            this.gux[19] = this.xr * this.yr * (this.a[1][2] + this.zr2 * this.a[1][3]);
            this.gux[20] = this.xr * this.zr * (3.0 * this.a[1][2] + this.zr2 * this.a[1][3]);
            this.guy[11] = this.gux[12];
            this.guy[12] = this.gux[14];
            this.guy[13] = this.gux[15];
            this.guy[14] = this.gux[17];
            this.guy[15] = this.gux[18];
            this.guy[16] = this.gux[19];
            this.guy[17] = 3.0 * this.a[1][1] + this.yr2 * (6.0 * this.a[1][2] + this.yr2 * this.a[1][3]);
            this.guy[18] = this.yr * this.zr * (3.0 * this.a[1][2] + this.yr2 * this.a[1][3]);
            this.guy[19] = this.a[1][1] + (this.yr2 + this.zr2) * this.a[1][2] + this.yr2 * this.zr2 * this.a[1][3];
            this.guy[20] = this.yr * this.zr * (3.0 * this.a[1][2] + this.zr2 * this.a[1][3]);
            this.guz[11] = this.gux[13];
            this.guz[12] = this.gux[15];
            this.guz[13] = this.gux[16];
            this.guz[14] = this.gux[18];
            this.guz[15] = this.gux[19];
            this.guz[16] = this.gux[20];
            this.guz[17] = this.guy[18];
            this.guz[18] = this.guy[19];
            this.guz[19] = this.guy[20];
            this.guz[20] = 3.0 * this.a[1][1] + this.zr2 * (6.0 * this.a[1][2] + this.zr2 * this.a[1][3]);
            this.gqxx[11] = this.xr * (12.0 * this.a[2][1] + this.xr2 * (9.0 * this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqxx[12] = this.yr * (2.0 * this.a[2][1] + this.xr2 * (5.0 * this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqxx[13] = this.zr * (2.0 * this.a[2][1] + this.xr2 * (5.0 * this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqxx[14] = this.xr * (2.0 * this.a[2][1] + this.yr2 * 2.0 * this.a[2][2] + this.xr2 * (this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqxx[15] = this.xr * this.yr * this.zr * (2.0 * this.a[2][2] + this.xr2 * this.a[2][3]);
            this.gqxx[16] = this.xr * (2.0 * this.a[2][1] + this.zr2 * 2.0 * this.a[2][2] + this.xr2 * (this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqxx[17] = this.yr * this.xr2 * (3.0 * this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqxx[18] = this.zr * this.xr2 * (this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqxx[19] = this.yr * this.xr2 * (this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqxx[20] = this.zr * this.xr2 * (3.0 * this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqxy[11] = this.yr * (3.0 * this.a[2][1] + this.xr2 * (6.0 * this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqxy[12] = this.xr * (3.0 * (this.a[2][1] + this.yr2 * this.a[2][2]) + this.xr2 * (this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqxy[13] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.xr2 * this.a[2][3]);
            this.gqxy[14] = this.yr * (3.0 * (this.a[2][1] + this.xr2 * this.a[2][2]) + this.yr2 * (this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqxy[15] = this.zr * (this.a[2][1] + (this.yr2 + this.xr2) * this.a[2][2] + this.yr2 * this.xr2 * this.a[2][3]);
            this.gqxy[16] = this.yr * (this.a[2][1] + (this.xr2 + this.zr2) * this.a[2][2] + this.xr2 * this.zr2 * this.a[2][3]);
            this.gqxy[17] = this.xr * (3.0 * (this.a[2][1] + this.yr2 * this.a[2][2]) + this.yr2 * (3.0 * this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqxy[18] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqxy[19] = this.xr * (this.a[2][1] + (this.yr2 + this.zr2) * this.a[2][2] + this.yr2 * this.zr2 * this.a[2][3]);
            this.gqxy[20] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqxz[11] = this.zr * (3.0 * this.a[2][1] + this.xr2 * (6.0 * this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqxz[12] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.xr2 * this.a[2][3]);
            this.gqxz[13] = this.xr * (3.0 * (this.a[2][1] + this.zr2 * this.a[2][2]) + this.xr2 * (this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqxz[14] = this.zr * (this.a[2][1] + (this.xr2 + this.yr2) * this.a[2][2] + this.xr2 * this.yr2 * this.a[2][3]);
            this.gqxz[15] = this.yr * (this.a[2][1] + (this.xr2 + this.zr2) * this.a[2][2] + this.zr2 * this.xr2 * this.a[2][3]);
            this.gqxz[16] = this.zr * (3.0 * (this.a[2][1] + this.xr2 * this.a[2][2]) + this.zr2 * (this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqxz[17] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqxz[18] = this.xr * (this.a[2][1] + (this.zr2 + this.yr2) * this.a[2][2] + this.zr2 * this.yr2 * this.a[2][3]);
            this.gqxz[19] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqxz[20] = this.xr * (3.0 * this.a[2][1] + this.zr2 * (6.0 * this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqyy[11] = this.xr * this.yr2 * (3.0 * this.a[2][2] + this.xr2 * this.a[2][3]);
            this.gqyy[12] = this.yr * (2.0 * this.a[2][1] + this.xr2 * 2.0 * this.a[2][2] + this.yr2 * (this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqyy[13] = this.zr * this.yr2 * (this.a[2][2] + this.xr2 * this.a[2][3]);
            this.gqyy[14] = this.xr * (2.0 * this.a[2][1] + this.yr2 * (5.0 * this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqyy[15] = this.xr * this.yr * this.zr * (2.0 * this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqyy[16] = this.xr * this.yr2 * (this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqyy[17] = this.yr * (12.0 * this.a[2][1] + this.yr2 * (9.0 * this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqyy[18] = this.zr * (2.0 * this.a[2][1] + this.yr2 * (5.0 * this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqyy[19] = this.yr * (2.0 * this.a[2][1] + this.zr2 * 2.0 * this.a[2][2] + this.yr2 * (this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqyy[20] = this.zr * this.yr2 * (3.0 * this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqyz[11] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.xr2 * this.a[2][3]);
            this.gqyz[12] = this.zr * (this.a[2][1] + (this.xr2 + this.yr2) * this.a[2][2] + this.xr2 * this.yr2 * this.a[2][3]);
            this.gqyz[13] = this.yr * (this.a[2][1] + (this.xr2 + this.zr2) * this.a[2][2] + this.xr2 * this.zr2 * this.a[2][3]);
            this.gqyz[14] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqyz[15] = this.xr * (this.a[2][1] + (this.yr2 + this.zr2) * this.a[2][2] + this.yr2 * this.zr2 * this.a[2][3]);
            this.gqyz[16] = this.xr * this.yr * this.zr * (3.0 * this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqyz[17] = this.zr * (3.0 * this.a[2][1] + this.yr2 * (6.0 * this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqyz[18] = this.yr * (3.0 * (this.a[2][1] + this.zr2 * this.a[2][2]) + this.yr2 * (this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqyz[19] = this.zr * (3.0 * (this.a[2][1] + this.yr2 * this.a[2][2]) + this.zr2 * (this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqyz[20] = this.yr * (3.0 * this.a[2][1] + this.zr2 * (6.0 * this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqzz[11] = this.xr * this.zr2 * (3.0 * this.a[2][2] + this.xr2 * this.a[2][3]);
            this.gqzz[12] = this.yr * (this.zr2 * this.a[2][2] + this.xr2 * (this.zr2 * this.a[2][3]));
            this.gqzz[13] = this.zr * (2.0 * this.a[2][1] + this.xr2 * 2.0 * this.a[2][2] + this.zr2 * (this.a[2][2] + this.xr2 * this.a[2][3]));
            this.gqzz[14] = this.xr * this.zr2 * (this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqzz[15] = this.xr * this.yr * this.zr * (2.0 * this.a[2][2] + this.zr2 * this.a[2][3]);
            this.gqzz[16] = this.xr * (2.0 * this.a[2][1] + this.zr2 * (5.0 * this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqzz[17] = this.yr * this.zr2 * (3.0 * this.a[2][2] + this.yr2 * this.a[2][3]);
            this.gqzz[18] = this.zr * (2.0 * this.a[2][1] + this.yr2 * 2.0 * this.a[2][2] + this.zr2 * (this.a[2][2] + this.yr2 * this.a[2][3]));
            this.gqzz[19] = this.yr * (2.0 * this.a[2][1] + this.zr2 * (5.0 * this.a[2][2] + this.zr2 * this.a[2][3]));
            this.gqzz[20] = this.zr * (12.0 * this.a[2][1] + this.zr2 * (9.0 * this.a[2][2] + this.zr2 * this.a[2][3]));
        }

        private void permanentEnergyGradient(int i, int k) {
            double desymdr = this.ci * this.ck * this.gc[21] - (this.uxi * (this.uxk * this.gux[22] + this.uyk * this.guy[22] + this.uzk * this.guz[22]) + this.uyi * (this.uxk * this.gux[23] + this.uyk * this.guy[23] + this.uzk * this.guz[23]) + this.uzi * (this.uxk * this.gux[24] + this.uyk * this.guy[24] + this.uzk * this.guz[24]));
            double dewidr = this.ci * (this.uxk * this.gc[22] + this.uyk * this.gc[23] + this.uzk * this.gc[24]) - this.ck * (this.uxi * this.gux[21] + this.uyi * this.guy[21] + this.uzi * this.guz[21]) + this.ci * (this.qxxk * this.gc[25] + this.qyyk * this.gc[28] + this.qzzk * this.gc[30] + 2.0 * (this.qxyk * this.gc[26] + this.qxzk * this.gc[27] + this.qyzk * this.gc[29])) + this.ck * (this.qxxi * this.gqxx[21] + this.qyyi * this.gqyy[21] + this.qzzi * this.gqzz[21] + 2.0 * (this.qxyi * this.gqxy[21] + this.qxzi * this.gqxz[21] + this.qyzi * this.gqyz[21])) - this.uxi * (this.qxxk * this.gux[25] + this.qyyk * this.gux[28] + this.qzzk * this.gux[30] + 2.0 * (this.qxyk * this.gux[26] + this.qxzk * this.gux[27] + this.qyzk * this.gux[29])) - this.uyi * (this.qxxk * this.guy[25] + this.qyyk * this.guy[28] + this.qzzk * this.guy[30] + 2.0 * (this.qxyk * this.guy[26] + this.qxzk * this.guy[27] + this.qyzk * this.guy[29])) - this.uzi * (this.qxxk * this.guz[25] + this.qyyk * this.guz[28] + this.qzzk * this.guz[30] + 2.0 * (this.qxyk * this.guz[26] + this.qxzk * this.guz[27] + this.qyzk * this.guz[29])) + this.uxk * (this.qxxi * this.gqxx[22] + this.qyyi * this.gqyy[22] + this.qzzi * this.gqzz[22] + 2.0 * (this.qxyi * this.gqxy[22] + this.qxzi * this.gqxz[22] + this.qyzi * this.gqyz[22])) + this.uyk * (this.qxxi * this.gqxx[23] + this.qyyi * this.gqyy[23] + this.qzzi * this.gqzz[23] + 2.0 * (this.qxyi * this.gqxy[23] + this.qxzi * this.gqxz[23] + this.qyzi * this.gqyz[23])) + this.uzk * (this.qxxi * this.gqxx[24] + this.qyyi * this.gqyy[24] + this.qzzi * this.gqzz[24] + 2.0 * (this.qxyi * this.gqxy[24] + this.qxzi * this.gqxz[24] + this.qyzi * this.gqyz[24])) + this.qxxi * (this.qxxk * this.gqxx[25] + this.qyyk * this.gqxx[28] + this.qzzk * this.gqxx[30] + 2.0 * (this.qxyk * this.gqxx[26] + this.qxzk * this.gqxx[27] + this.qyzk * this.gqxx[29])) + this.qyyi * (this.qxxk * this.gqyy[25] + this.qyyk * this.gqyy[28] + this.qzzk * this.gqyy[30] + 2.0 * (this.qxyk * this.gqyy[26] + this.qxzk * this.gqyy[27] + this.qyzk * this.gqyy[29])) + this.qzzi * (this.qxxk * this.gqzz[25] + this.qyyk * this.gqzz[28] + this.qzzk * this.gqzz[30] + 2.0 * (this.qxyk * this.gqzz[26] + this.qxzk * this.gqzz[27] + this.qyzk * this.gqzz[29])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxy[25] + this.qyyk * this.gqxy[28] + this.qzzk * this.gqxy[30] + 2.0 * (this.qxyk * this.gqxy[26] + this.qxzk * this.gqxy[27] + this.qyzk * this.gqxy[29])) + this.qxzi * (this.qxxk * this.gqxz[25] + this.qyyk * this.gqxz[28] + this.qzzk * this.gqxz[30] + 2.0 * (this.qxyk * this.gqxz[26] + this.qxzk * this.gqxz[27] + this.qyzk * this.gqxz[29])) + this.qyzi * (this.qxxk * this.gqyz[25] + this.qyyk * this.gqyz[28] + this.qzzk * this.gqyz[30] + 2.0 * (this.qxyk * this.gqyz[26] + this.qxzk * this.gqyz[27] + this.qyzk * this.gqyz[29])));
            double dewkdr = this.ci * (this.uxk * this.gux[21] + this.uyk * this.guy[21] + this.uzk * this.guz[21]) - this.ck * (this.uxi * this.gc[22] + this.uyi * this.gc[23] + this.uzi * this.gc[24]) + this.ci * (this.qxxk * this.gqxx[21] + this.qyyk * this.gqyy[21] + this.qzzk * this.gqzz[21] + 2.0 * (this.qxyk * this.gqxy[21] + this.qxzk * this.gqxz[21] + this.qyzk * this.gqyz[21])) + this.ck * (this.qxxi * this.gc[25] + this.qyyi * this.gc[28] + this.qzzi * this.gc[30] + 2.0 * (this.qxyi * this.gc[26] + this.qxzi * this.gc[27] + this.qyzi * this.gc[29])) - this.uxi * (this.qxxk * this.gqxx[22] + this.qyyk * this.gqyy[22] + this.qzzk * this.gqzz[22] + 2.0 * (this.qxyk * this.gqxy[22] + this.qxzk * this.gqxz[22] + this.qyzk * this.gqyz[22])) - this.uyi * (this.qxxk * this.gqxx[23] + this.qyyk * this.gqyy[23] + this.qzzk * this.gqzz[23] + 2.0 * (this.qxyk * this.gqxy[23] + this.qxzk * this.gqxz[23] + this.qyzk * this.gqyz[23])) - this.uzi * (this.qxxk * this.gqxx[24] + this.qyyk * this.gqyy[24] + this.qzzk * this.gqzz[24] + 2.0 * (this.qxyk * this.gqxy[24] + this.qxzk * this.gqxz[24] + this.qyzk * this.gqyz[24])) + this.uxk * (this.qxxi * this.gux[25] + this.qyyi * this.gux[28] + this.qzzi * this.gux[30] + 2.0 * (this.qxyi * this.gux[26] + this.qxzi * this.gux[27] + this.qyzi * this.gux[29])) + this.uyk * (this.qxxi * this.guy[25] + this.qyyi * this.guy[28] + this.qzzi * this.guy[30] + 2.0 * (this.qxyi * this.guy[26] + this.qxzi * this.guy[27] + this.qyzi * this.guy[29])) + this.uzk * (this.qxxi * this.guz[25] + this.qyyi * this.guz[28] + this.qzzi * this.guz[30] + 2.0 * (this.qxyi * this.guz[26] + this.qxzi * this.guz[27] + this.qyzi * this.guz[29])) + this.qxxi * (this.qxxk * this.gqxx[25] + this.qyyk * this.gqyy[25] + this.qzzk * this.gqzz[25] + 2.0 * (this.qxyk * this.gqxy[25] + this.qxzk * this.gqxz[25] + this.qyzk * this.gqyz[25])) + this.qyyi * (this.qxxk * this.gqxx[28] + this.qyyk * this.gqyy[28] + this.qzzk * this.gqzz[28] + 2.0 * (this.qxyk * this.gqxy[28] + this.qxzk * this.gqxz[28] + this.qyzk * this.gqyz[28])) + this.qzzi * (this.qxxk * this.gqxx[30] + this.qyyk * this.gqyy[30] + this.qzzk * this.gqzz[30] + 2.0 * (this.qxyk * this.gqxy[30] + this.qxzk * this.gqxz[30] + this.qyzk * this.gqyz[30])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxx[26] + this.qyyk * this.gqyy[26] + this.qzzk * this.gqzz[26] + 2.0 * (this.qxyk * this.gqxy[26] + this.qxzk * this.gqxz[26] + this.qyzk * this.gqyz[26])) + this.qxzi * (this.qxxk * this.gqxx[27] + this.qyyk * this.gqyy[27] + this.qzzk * this.gqzz[27] + 2.0 * (this.qxyk * this.gqxy[27] + this.qxzk * this.gqxz[27] + this.qyzk * this.gqyz[27])) + this.qyzi * (this.qxxk * this.gqxx[29] + this.qyyk * this.gqyy[29] + this.qzzk * this.gqzz[29] + 2.0 * (this.qxyk * this.gqxy[29] + this.qxzk * this.gqxz[29] + this.qyzk * this.gqyz[29])));
            double dsumdr = desymdr + 0.5 * (dewidr + dewkdr);
            double drbi = this.rbk * dsumdr;
            double drbk = this.rbi * dsumdr;
            double selfScale = 1.0;
            if (i == k) {
                if (this.iSymm == 0) {
                    this.this$0.sharedBornGrad.add(this.threadID, i, drbi);
                    return;
                }
                selfScale = 0.5;
            }
            double dedx = selfScale * this.dEdX();
            double dedy = selfScale * this.dEdY();
            double dedz = selfScale * this.dEdZ();
            this.dedxi -= dedx;
            this.dedyi -= dedy;
            this.dedzi -= dedz;
            this.dborni += selfScale * drbi;
            double dedxk = dedx * this.transOp[0][0] + dedy * this.transOp[1][0] + dedz * this.transOp[2][0];
            double dedyk = dedx * this.transOp[0][1] + dedy * this.transOp[1][1] + dedz * this.transOp[2][1];
            double dedzk = dedx * this.transOp[0][2] + dedy * this.transOp[1][2] + dedz * this.transOp[2][2];
            this.this$0.grad.add(this.threadID, k, dedxk, dedyk, dedzk);
            this.this$0.sharedBornGrad.add(this.threadID, k, selfScale * drbk);
            this.permanentEnergyTorque(i, k);
        }

        private double dEdZ() {
            double desymdz = this.ci * this.ck * this.gc[4] - (this.uxi * (this.uxk * this.gux[7] + this.uyk * this.guy[7] + this.uzk * this.guz[7]) + this.uyi * (this.uxk * this.gux[9] + this.uyk * this.guy[9] + this.uzk * this.guz[9]) + this.uzi * (this.uxk * this.gux[10] + this.uyk * this.guy[10] + this.uzk * this.guz[10]));
            double dewidz = this.ci * (this.uxk * this.gc[7] + this.uyk * this.gc[9] + this.uzk * this.gc[10]) - this.ck * (this.uxi * this.gux[4] + this.uyi * this.guy[4] + this.uzi * this.guz[4]) + this.ci * (this.qxxk * this.gc[13] + this.qyyk * this.gc[18] + this.qzzk * this.gc[20] + 2.0 * (this.qxyk * this.gc[15] + this.qxzk * this.gc[16] + this.qyzk * this.gc[19])) + this.ck * (this.qxxi * this.gqxx[4] + this.qyyi * this.gqyy[4] + this.qzzi * this.gqzz[4] + 2.0 * (this.qxyi * this.gqxy[4] + this.qxzi * this.gqxz[4] + this.qyzi * this.gqyz[4])) - this.uxi * (this.qxxk * this.gux[13] + this.qyyk * this.gux[18] + this.qzzk * this.gux[20] + 2.0 * (this.qxyk * this.gux[15] + this.qxzk * this.gux[16] + this.qyzk * this.gux[19])) - this.uyi * (this.qxxk * this.guy[13] + this.qyyk * this.guy[18] + this.qzzk * this.guy[20] + 2.0 * (this.qxyk * this.guy[15] + this.qxzk * this.guy[16] + this.qyzk * this.guy[19])) - this.uzi * (this.qxxk * this.guz[13] + this.qyyk * this.guz[18] + this.qzzk * this.guz[20] + 2.0 * (this.qxyk * this.guz[15] + this.qxzk * this.guz[16] + this.qyzk * this.guz[19])) + this.uxk * (this.qxxi * this.gqxx[7] + this.qyyi * this.gqyy[7] + this.qzzi * this.gqzz[7] + 2.0 * (this.qxyi * this.gqxy[7] + this.qxzi * this.gqxz[7] + this.qyzi * this.gqyz[7])) + this.uyk * (this.qxxi * this.gqxx[9] + this.qyyi * this.gqyy[9] + this.qzzi * this.gqzz[9] + 2.0 * (this.qxyi * this.gqxy[9] + this.qxzi * this.gqxz[9] + this.qyzi * this.gqyz[9])) + this.uzk * (this.qxxi * this.gqxx[10] + this.qyyi * this.gqyy[10] + this.qzzi * this.gqzz[10] + 2.0 * (this.qxyi * this.gqxy[10] + this.qxzi * this.gqxz[10] + this.qyzi * this.gqyz[10])) + this.qxxi * (this.qxxk * this.gqxx[13] + this.qyyk * this.gqxx[18] + this.qzzk * this.gqxx[20] + 2.0 * (this.qxyk * this.gqxx[15] + this.qxzk * this.gqxx[16] + this.qyzk * this.gqxx[19])) + this.qyyi * (this.qxxk * this.gqyy[13] + this.qyyk * this.gqyy[18] + this.qzzk * this.gqyy[20] + 2.0 * (this.qxyk * this.gqyy[15] + this.qxzk * this.gqyy[16] + this.qyzk * this.gqyy[19])) + this.qzzi * (this.qxxk * this.gqzz[13] + this.qyyk * this.gqzz[18] + this.qzzk * this.gqzz[20] + 2.0 * (this.qxyk * this.gqzz[15] + this.qxzk * this.gqzz[16] + this.qyzk * this.gqzz[19])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxy[13] + this.qyyk * this.gqxy[18] + this.qzzk * this.gqxy[20] + 2.0 * (this.qxyk * this.gqxy[15] + this.qxzk * this.gqxy[16] + this.qyzk * this.gqxy[19])) + this.qxzi * (this.qxxk * this.gqxz[13] + this.qyyk * this.gqxz[18] + this.qzzk * this.gqxz[20] + 2.0 * (this.qxyk * this.gqxz[15] + this.qxzk * this.gqxz[16] + this.qyzk * this.gqxz[19])) + this.qyzi * (this.qxxk * this.gqyz[13] + this.qyyk * this.gqyz[18] + this.qzzk * this.gqyz[20] + 2.0 * (this.qxyk * this.gqyz[15] + this.qxzk * this.gqyz[16] + this.qyzk * this.gqyz[19])));
            double dewkdz = this.ci * (this.uxk * this.gux[4] + this.uyk * this.guy[4] + this.uzk * this.guz[4]) - this.ck * (this.uxi * this.gc[7] + this.uyi * this.gc[9] + this.uzi * this.gc[10]) + this.ci * (this.qxxk * this.gqxx[4] + this.qyyk * this.gqyy[4] + this.qzzk * this.gqzz[4] + 2.0 * (this.qxyk * this.gqxy[4] + this.qxzk * this.gqxz[4] + this.qyzk * this.gqyz[4])) + this.ck * (this.qxxi * this.gc[13] + this.qyyi * this.gc[18] + this.qzzi * this.gc[20] + 2.0 * (this.qxyi * this.gc[15] + this.qxzi * this.gc[16] + this.qyzi * this.gc[19])) - this.uxi * (this.qxxk * this.gqxx[7] + this.qyyk * this.gqyy[7] + this.qzzk * this.gqzz[7] + 2.0 * (this.qxyk * this.gqxy[7] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqyz[7])) - this.uyi * (this.qxxk * this.gqxx[9] + this.qyyk * this.gqyy[9] + this.qzzk * this.gqzz[9] + 2.0 * (this.qxyk * this.gqxy[9] + this.qxzk * this.gqxz[9] + this.qyzk * this.gqyz[9])) - this.uzi * (this.qxxk * this.gqxx[10] + this.qyyk * this.gqyy[10] + this.qzzk * this.gqzz[10] + 2.0 * (this.qxyk * this.gqxy[10] + this.qxzk * this.gqxz[10] + this.qyzk * this.gqyz[10])) + this.uxk * (this.qxxi * this.gux[13] + this.qyyi * this.gux[18] + this.qzzi * this.gux[20] + 2.0 * (this.qxyi * this.gux[15] + this.qxzi * this.gux[16] + this.qyzi * this.gux[19])) + this.uyk * (this.qxxi * this.guy[13] + this.qyyi * this.guy[18] + this.qzzi * this.guy[20] + 2.0 * (this.qxyi * this.guy[15] + this.qxzi * this.guy[16] + this.qyzi * this.guy[19])) + this.uzk * (this.qxxi * this.guz[13] + this.qyyi * this.guz[18] + this.qzzi * this.guz[20] + 2.0 * (this.qxyi * this.guz[15] + this.qxzi * this.guz[16] + this.qyzi * this.guz[19])) + this.qxxi * (this.qxxk * this.gqxx[13] + this.qyyk * this.gqyy[13] + this.qzzk * this.gqzz[13] + 2.0 * (this.qxyk * this.gqxy[13] + this.qxzk * this.gqxz[13] + this.qyzk * this.gqyz[13])) + this.qyyi * (this.qxxk * this.gqxx[18] + this.qyyk * this.gqyy[18] + this.qzzk * this.gqzz[18] + 2.0 * (this.qxyk * this.gqxy[18] + this.qxzk * this.gqxz[18] + this.qyzk * this.gqyz[18])) + this.qzzi * (this.qxxk * this.gqxx[20] + this.qyyk * this.gqyy[20] + this.qzzk * this.gqzz[20] + 2.0 * (this.qxyk * this.gqxy[20] + this.qxzk * this.gqxz[20] + this.qyzk * this.gqyz[20])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxx[15] + this.qyyk * this.gqyy[15] + this.qzzk * this.gqzz[15] + 2.0 * (this.qxyk * this.gqxy[15] + this.qxzk * this.gqxz[15] + this.qyzk * this.gqyz[15])) + this.qxzi * (this.qxxk * this.gqxx[16] + this.qyyk * this.gqyy[16] + this.qzzk * this.gqzz[16] + 2.0 * (this.qxyk * this.gqxy[16] + this.qxzk * this.gqxz[16] + this.qyzk * this.gqyz[16])) + this.qyzi * (this.qxxk * this.gqxx[19] + this.qyyk * this.gqyy[19] + this.qzzk * this.gqzz[19] + 2.0 * (this.qxyk * this.gqxy[19] + this.qxzk * this.gqxz[19] + this.qyzk * this.gqyz[19])));
            return desymdz + 0.5 * (dewidz + dewkdz);
        }

        private double dEdY() {
            double desymdy = this.ci * this.ck * this.gc[3] - (this.uxi * (this.uxk * this.gux[6] + this.uyk * this.guy[6] + this.uzk * this.guz[6]) + this.uyi * (this.uxk * this.gux[8] + this.uyk * this.guy[8] + this.uzk * this.guz[8]) + this.uzi * (this.uxk * this.gux[9] + this.uyk * this.guy[9] + this.uzk * this.guz[9]));
            double dewidy = this.ci * (this.uxk * this.gc[6] + this.uyk * this.gc[8] + this.uzk * this.gc[9]) - this.ck * (this.uxi * this.gux[3] + this.uyi * this.guy[3] + this.uzi * this.guz[3]) + this.ci * (this.qxxk * this.gc[12] + this.qyyk * this.gc[17] + this.qzzk * this.gc[19] + 2.0 * (this.qxyk * this.gc[14] + this.qxzk * this.gc[15] + this.qyzk * this.gc[18])) + this.ck * (this.qxxi * this.gqxx[3] + this.qyyi * this.gqyy[3] + this.qzzi * this.gqzz[3] + 2.0 * (this.qxyi * this.gqxy[3] + this.qxzi * this.gqxz[3] + this.qyzi * this.gqyz[3])) - this.uxi * (this.qxxk * this.gux[12] + this.qyyk * this.gux[17] + this.qzzk * this.gux[19] + 2.0 * (this.qxyk * this.gux[14] + this.qxzk * this.gux[15] + this.qyzk * this.gux[18])) - this.uyi * (this.qxxk * this.guy[12] + this.qyyk * this.guy[17] + this.qzzk * this.guy[19] + 2.0 * (this.qxyk * this.guy[14] + this.qxzk * this.guy[15] + this.qyzk * this.guy[18])) - this.uzi * (this.qxxk * this.guz[12] + this.qyyk * this.guz[17] + this.qzzk * this.guz[19] + 2.0 * (this.qxyk * this.guz[14] + this.qxzk * this.guz[15] + this.qyzk * this.guz[18])) + this.uxk * (this.qxxi * this.gqxx[6] + this.qyyi * this.gqyy[6] + this.qzzi * this.gqzz[6] + 2.0 * (this.qxyi * this.gqxy[6] + this.qxzi * this.gqxz[6] + this.qyzi * this.gqyz[6])) + this.uyk * (this.qxxi * this.gqxx[8] + this.qyyi * this.gqyy[8] + this.qzzi * this.gqzz[8] + 2.0 * (this.qxyi * this.gqxy[8] + this.qxzi * this.gqxz[8] + this.qyzi * this.gqyz[8])) + this.uzk * (this.qxxi * this.gqxx[9] + this.qyyi * this.gqyy[9] + this.qzzi * this.gqzz[9] + 2.0 * (this.qxyi * this.gqxy[9] + this.qxzi * this.gqxz[9] + this.qyzi * this.gqyz[9])) + this.qxxi * (this.qxxk * this.gqxx[12] + this.qyyk * this.gqxx[17] + this.qzzk * this.gqxx[19] + 2.0 * (this.qxyk * this.gqxx[14] + this.qxzk * this.gqxx[15] + this.qyzk * this.gqxx[18])) + this.qyyi * (this.qxxk * this.gqyy[12] + this.qyyk * this.gqyy[17] + this.qzzk * this.gqyy[19] + 2.0 * (this.qxyk * this.gqyy[14] + this.qxzk * this.gqyy[15] + this.qyzk * this.gqyy[18])) + this.qzzi * (this.qxxk * this.gqzz[12] + this.qyyk * this.gqzz[17] + this.qzzk * this.gqzz[19] + 2.0 * (this.qxyk * this.gqzz[14] + this.qxzk * this.gqzz[15] + this.qyzk * this.gqzz[18])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxy[12] + this.qyyk * this.gqxy[17] + this.qzzk * this.gqxy[19] + 2.0 * (this.qxyk * this.gqxy[14] + this.qxzk * this.gqxy[15] + this.qyzk * this.gqxy[18])) + this.qxzi * (this.qxxk * this.gqxz[12] + this.qyyk * this.gqxz[17] + this.qzzk * this.gqxz[19] + 2.0 * (this.qxyk * this.gqxz[14] + this.qxzk * this.gqxz[15] + this.qyzk * this.gqxz[18])) + this.qyzi * (this.qxxk * this.gqyz[12] + this.qyyk * this.gqyz[17] + this.qzzk * this.gqyz[19] + 2.0 * (this.qxyk * this.gqyz[14] + this.qxzk * this.gqyz[15] + this.qyzk * this.gqyz[18])));
            double dewkdy = this.ci * (this.uxk * this.gux[3] + this.uyk * this.guy[3] + this.uzk * this.guz[3]) - this.ck * (this.uxi * this.gc[6] + this.uyi * this.gc[8] + this.uzi * this.gc[9]) + this.ci * (this.qxxk * this.gqxx[3] + this.qyyk * this.gqyy[3] + this.qzzk * this.gqzz[3] + 2.0 * (this.qxyk * this.gqxy[3] + this.qxzk * this.gqxz[3] + this.qyzk * this.gqyz[3])) + this.ck * (this.qxxi * this.gc[12] + this.qyyi * this.gc[17] + this.qzzi * this.gc[19] + 2.0 * (this.qxyi * this.gc[14] + this.qxzi * this.gc[15] + this.qyzi * this.gc[18])) - this.uxi * (this.qxxk * this.gqxx[6] + this.qyyk * this.gqyy[6] + this.qzzk * this.gqzz[6] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxz[6] + this.qyzk * this.gqyz[6])) - this.uyi * (this.qxxk * this.gqxx[8] + this.qyyk * this.gqyy[8] + this.qzzk * this.gqzz[8] + 2.0 * (this.qxyk * this.gqxy[8] + this.qxzk * this.gqxz[8] + this.qyzk * this.gqyz[8])) - this.uzi * (this.qxxk * this.gqxx[9] + this.qyyk * this.gqyy[9] + this.qzzk * this.gqzz[9] + 2.0 * (this.qxyk * this.gqxy[9] + this.qxzk * this.gqxz[9] + this.qyzk * this.gqyz[9])) + this.uxk * (this.qxxi * this.gux[12] + this.qyyi * this.gux[17] + this.qzzi * this.gux[19] + 2.0 * (this.qxyi * this.gux[14] + this.qxzi * this.gux[15] + this.qyzi * this.gux[18])) + this.uyk * (this.qxxi * this.guy[12] + this.qyyi * this.guy[17] + this.qzzi * this.guy[19] + 2.0 * (this.qxyi * this.guy[14] + this.qxzi * this.guy[15] + this.qyzi * this.guy[18])) + this.uzk * (this.qxxi * this.guz[12] + this.qyyi * this.guz[17] + this.qzzi * this.guz[19] + 2.0 * (this.qxyi * this.guz[14] + this.qxzi * this.guz[15] + this.qyzi * this.guz[18])) + this.qxxi * (this.qxxk * this.gqxx[12] + this.qyyk * this.gqyy[12] + this.qzzk * this.gqzz[12] + 2.0 * (this.qxyk * this.gqxy[12] + this.qxzk * this.gqxz[12] + this.qyzk * this.gqyz[12])) + this.qyyi * (this.qxxk * this.gqxx[17] + this.qyyk * this.gqyy[17] + this.qzzk * this.gqzz[17] + 2.0 * (this.qxyk * this.gqxy[17] + this.qxzk * this.gqxz[17] + this.qyzk * this.gqyz[17])) + this.qzzi * (this.qxxk * this.gqxx[19] + this.qyyk * this.gqyy[19] + this.qzzk * this.gqzz[19] + 2.0 * (this.qxyk * this.gqxy[19] + this.qxzk * this.gqxz[19] + this.qyzk * this.gqyz[19])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxx[14] + this.qyyk * this.gqyy[14] + this.qzzk * this.gqzz[14] + 2.0 * (this.qxyk * this.gqxy[14] + this.qxzk * this.gqxz[14] + this.qyzk * this.gqyz[14])) + this.qxzi * (this.qxxk * this.gqxx[15] + this.qyyk * this.gqyy[15] + this.qzzk * this.gqzz[15] + 2.0 * (this.qxyk * this.gqxy[15] + this.qxzk * this.gqxz[15] + this.qyzk * this.gqyz[15])) + this.qyzi * (this.qxxk * this.gqxx[18] + this.qyyk * this.gqyy[18] + this.qzzk * this.gqzz[18] + 2.0 * (this.qxyk * this.gqxy[18] + this.qxzk * this.gqxz[18] + this.qyzk * this.gqyz[18])));
            return desymdy + 0.5 * (dewidy + dewkdy);
        }

        private double dEdX() {
            double desymdx = this.ci * this.ck * this.gc[2] - (this.uxi * (this.uxk * this.gux[5] + this.uyk * this.guy[5] + this.uzk * this.guz[5]) + this.uyi * (this.uxk * this.gux[6] + this.uyk * this.guy[6] + this.uzk * this.guz[6]) + this.uzi * (this.uxk * this.gux[7] + this.uyk * this.guy[7] + this.uzk * this.guz[7]));
            double dewidx = this.ci * (this.uxk * this.gc[5] + this.uyk * this.gc[6] + this.uzk * this.gc[7]) - this.ck * (this.uxi * this.gux[2] + this.uyi * this.guy[2] + this.uzi * this.guz[2]) + this.ci * (this.qxxk * this.gc[11] + this.qyyk * this.gc[14] + this.qzzk * this.gc[16] + 2.0 * (this.qxyk * this.gc[12] + this.qxzk * this.gc[13] + this.qyzk * this.gc[15])) + this.ck * (this.qxxi * this.gqxx[2] + this.qyyi * this.gqyy[2] + this.qzzi * this.gqzz[2] + 2.0 * (this.qxyi * this.gqxy[2] + this.qxzi * this.gqxz[2] + this.qyzi * this.gqyz[2])) - this.uxi * (this.qxxk * this.gux[11] + this.qyyk * this.gux[14] + this.qzzk * this.gux[16] + 2.0 * (this.qxyk * this.gux[12] + this.qxzk * this.gux[13] + this.qyzk * this.gux[15])) - this.uyi * (this.qxxk * this.guy[11] + this.qyyk * this.guy[14] + this.qzzk * this.guy[16] + 2.0 * (this.qxyk * this.guy[12] + this.qxzk * this.guy[13] + this.qyzk * this.guy[15])) - this.uzi * (this.qxxk * this.guz[11] + this.qyyk * this.guz[14] + this.qzzk * this.guz[16] + 2.0 * (this.qxyk * this.guz[12] + this.qxzk * this.guz[13] + this.qyzk * this.guz[15])) + this.uxk * (this.qxxi * this.gqxx[5] + this.qyyi * this.gqyy[5] + this.qzzi * this.gqzz[5] + 2.0 * (this.qxyi * this.gqxy[5] + this.qxzi * this.gqxz[5] + this.qyzi * this.gqyz[5])) + this.uyk * (this.qxxi * this.gqxx[6] + this.qyyi * this.gqyy[6] + this.qzzi * this.gqzz[6] + 2.0 * (this.qxyi * this.gqxy[6] + this.qxzi * this.gqxz[6] + this.qyzi * this.gqyz[6])) + this.uzk * (this.qxxi * this.gqxx[7] + this.qyyi * this.gqyy[7] + this.qzzi * this.gqzz[7] + 2.0 * (this.qxyi * this.gqxy[7] + this.qxzi * this.gqxz[7] + this.qyzi * this.gqyz[7])) + this.qxxi * (this.qxxk * this.gqxx[11] + this.qyyk * this.gqxx[14] + this.qzzk * this.gqxx[16] + 2.0 * (this.qxyk * this.gqxx[12] + this.qxzk * this.gqxx[13] + this.qyzk * this.gqxx[15])) + this.qyyi * (this.qxxk * this.gqyy[11] + this.qyyk * this.gqyy[14] + this.qzzk * this.gqyy[16] + 2.0 * (this.qxyk * this.gqyy[12] + this.qxzk * this.gqyy[13] + this.qyzk * this.gqyy[15])) + this.qzzi * (this.qxxk * this.gqzz[11] + this.qyyk * this.gqzz[14] + this.qzzk * this.gqzz[16] + 2.0 * (this.qxyk * this.gqzz[12] + this.qxzk * this.gqzz[13] + this.qyzk * this.gqzz[15])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxy[11] + this.qyyk * this.gqxy[14] + this.qzzk * this.gqxy[16] + 2.0 * (this.qxyk * this.gqxy[12] + this.qxzk * this.gqxy[13] + this.qyzk * this.gqxy[15])) + this.qxzi * (this.qxxk * this.gqxz[11] + this.qyyk * this.gqxz[14] + this.qzzk * this.gqxz[16] + 2.0 * (this.qxyk * this.gqxz[12] + this.qxzk * this.gqxz[13] + this.qyzk * this.gqxz[15])) + this.qyzi * (this.qxxk * this.gqyz[11] + this.qyyk * this.gqyz[14] + this.qzzk * this.gqyz[16] + 2.0 * (this.qxyk * this.gqyz[12] + this.qxzk * this.gqyz[13] + this.qyzk * this.gqyz[15])));
            double dewkdx = this.ci * (this.uxk * this.gux[2] + this.uyk * this.guy[2] + this.uzk * this.guz[2]) - this.ck * (this.uxi * this.gc[5] + this.uyi * this.gc[6] + this.uzi * this.gc[7]) + this.ci * (this.qxxk * this.gqxx[2] + this.qyyk * this.gqyy[2] + this.qzzk * this.gqzz[2] + 2.0 * (this.qxyk * this.gqxy[2] + this.qxzk * this.gqxz[2] + this.qyzk * this.gqyz[2])) + this.ck * (this.qxxi * this.gc[11] + this.qyyi * this.gc[14] + this.qzzi * this.gc[16] + 2.0 * (this.qxyi * this.gc[12] + this.qxzi * this.gc[13] + this.qyzi * this.gc[15])) - this.uxi * (this.qxxk * this.gqxx[5] + this.qyyk * this.gqyy[5] + this.qzzk * this.gqzz[5] + 2.0 * (this.qxyk * this.gqxy[5] + this.qxzk * this.gqxz[5] + this.qyzk * this.gqyz[5])) - this.uyi * (this.qxxk * this.gqxx[6] + this.qyyk * this.gqyy[6] + this.qzzk * this.gqzz[6] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxz[6] + this.qyzk * this.gqyz[6])) - this.uzi * (this.qxxk * this.gqxx[7] + this.qyyk * this.gqyy[7] + this.qzzk * this.gqzz[7] + 2.0 * (this.qxyk * this.gqxy[7] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqyz[7])) + this.uxk * (this.qxxi * this.gux[11] + this.qyyi * this.gux[14] + this.qzzi * this.gux[16] + 2.0 * (this.qxyi * this.gux[12] + this.qxzi * this.gux[13] + this.qyzi * this.gux[15])) + this.uyk * (this.qxxi * this.guy[11] + this.qyyi * this.guy[14] + this.qzzi * this.guy[16] + 2.0 * (this.qxyi * this.guy[12] + this.qxzi * this.guy[13] + this.qyzi * this.guy[15])) + this.uzk * (this.qxxi * this.guz[11] + this.qyyi * this.guz[14] + this.qzzi * this.guz[16] + 2.0 * (this.qxyi * this.guz[12] + this.qxzi * this.guz[13] + this.qyzi * this.guz[15])) + this.qxxi * (this.qxxk * this.gqxx[11] + this.qyyk * this.gqyy[11] + this.qzzk * this.gqzz[11] + 2.0 * (this.qxyk * this.gqxy[11] + this.qxzk * this.gqxz[11] + this.qyzk * this.gqyz[11])) + this.qyyi * (this.qxxk * this.gqxx[14] + this.qyyk * this.gqyy[14] + this.qzzk * this.gqzz[14] + 2.0 * (this.qxyk * this.gqxy[14] + this.qxzk * this.gqxz[14] + this.qyzk * this.gqyz[14])) + this.qzzi * (this.qxxk * this.gqxx[16] + this.qyyk * this.gqyy[16] + this.qzzk * this.gqzz[16] + 2.0 * (this.qxyk * this.gqxy[16] + this.qxzk * this.gqxz[16] + this.qyzk * this.gqyz[16])) + 2.0 * (this.qxyi * (this.qxxk * this.gqxx[12] + this.qyyk * this.gqyy[12] + this.qzzk * this.gqzz[12] + 2.0 * (this.qxyk * this.gqxy[12] + this.qxzk * this.gqxz[12] + this.qyzk * this.gqyz[12])) + this.qxzi * (this.qxxk * this.gqxx[13] + this.qyyk * this.gqyy[13] + this.qzzk * this.gqzz[13] + 2.0 * (this.qxyk * this.gqxy[13] + this.qxzk * this.gqxz[13] + this.qyzk * this.gqyz[13])) + this.qyzi * (this.qxxk * this.gqxx[15] + this.qyyk * this.gqyy[15] + this.qzzk * this.gqzz[15] + 2.0 * (this.qxyk * this.gqxy[15] + this.qxzk * this.gqxz[15] + this.qyzk * this.gqyz[15])));
            return desymdx + 0.5 * (dewidx + dewkdx);
        }

        private void permanentEnergyTorque(int i, int k) {
            double ix = this.uxk * this.gux[2] + this.uyk * this.gux[3] + this.uzk * this.gux[4] + 0.5 * (this.ck * this.gux[1] + this.qxxk * this.gux[5] + this.qyyk * this.gux[8] + this.qzzk * this.gux[10] + 2.0 * (this.qxyk * this.gux[6] + this.qxzk * this.gux[7] + this.qyzk * this.gux[9]) + this.ck * this.gc[2] + this.qxxk * this.gqxx[2] + this.qyyk * this.gqyy[2] + this.qzzk * this.gqzz[2] + 2.0 * (this.qxyk * this.gqxy[2] + this.qxzk * this.gqxz[2] + this.qyzk * this.gqyz[2]));
            double iy = this.uxk * this.guy[2] + this.uyk * this.guy[3] + this.uzk * this.guy[4] + 0.5 * (this.ck * this.guy[1] + this.qxxk * this.guy[5] + this.qyyk * this.guy[8] + this.qzzk * this.guy[10] + 2.0 * (this.qxyk * this.guy[6] + this.qxzk * this.guy[7] + this.qyzk * this.guy[9]) + this.ck * this.gc[3] + this.qxxk * this.gqxx[3] + this.qyyk * this.gqyy[3] + this.qzzk * this.gqzz[3] + 2.0 * (this.qxyk * this.gqxy[3] + this.qxzk * this.gqxz[3] + this.qyzk * this.gqyz[3]));
            double iz = this.uxk * this.guz[2] + this.uyk * this.guz[3] + this.uzk * this.guz[4] + 0.5 * (this.ck * this.guz[1] + this.qxxk * this.guz[5] + this.qyyk * this.guz[8] + this.qzzk * this.guz[10] + 2.0 * (this.qxyk * this.guz[6] + this.qxzk * this.guz[7] + this.qyzk * this.guz[9]) + this.ck * this.gc[4] + this.qxxk * this.gqxx[4] + this.qyyk * this.gqyy[4] + this.qzzk * this.gqzz[4] + 2.0 * (this.qxyk * this.gqxy[4] + this.qxzk * this.gqxz[4] + this.qyzk * this.gqyz[4]));
            double kx = this.uxi * this.gux[2] + this.uyi * this.gux[3] + this.uzi * this.gux[4] - 0.5 * (this.ci * this.gux[1] + this.qxxi * this.gux[5] + this.qyyi * this.gux[8] + this.qzzi * this.gux[10] + 2.0 * (this.qxyi * this.gux[6] + this.qxzi * this.gux[7] + this.qyzi * this.gux[9]) + this.ci * this.gc[2] + this.qxxi * this.gqxx[2] + this.qyyi * this.gqyy[2] + this.qzzi * this.gqzz[2] + 2.0 * (this.qxyi * this.gqxy[2] + this.qxzi * this.gqxz[2] + this.qyzi * this.gqyz[2]));
            double ky = this.uxi * this.guy[2] + this.uyi * this.guy[3] + this.uzi * this.guy[4] - 0.5 * (this.ci * this.guy[1] + this.qxxi * this.guy[5] + this.qyyi * this.guy[8] + this.qzzi * this.guy[10] + 2.0 * (this.qxyi * this.guy[6] + this.qxzi * this.guy[7] + this.qyzi * this.guy[9]) + this.ci * this.gc[3] + this.qxxi * this.gqxx[3] + this.qyyi * this.gqyy[3] + this.qzzi * this.gqzz[3] + 2.0 * (this.qxyi * this.gqxy[3] + this.qxzi * this.gqxz[3] + this.qyzi * this.gqyz[3]));
            double kz = this.uxi * this.guz[2] + this.uyi * this.guz[3] + this.uzi * this.guz[4] - 0.5 * (this.ci * this.guz[1] + this.qxxi * this.guz[5] + this.qyyi * this.guz[8] + this.qzzi * this.guz[10] + 2.0 * (this.qxyi * this.guz[6] + this.qxzi * this.guz[7] + this.qyzi * this.guz[9]) + this.ci * this.gc[4] + this.qxxi * this.gqxx[4] + this.qyyi * this.gqyy[4] + this.qzzi * this.gqzz[4] + 2.0 * (this.qxyi * this.gqxy[4] + this.qxzi * this.gqxz[4] + this.qyzi * this.gqyz[4]));
            double tix = this.uyi * iz - this.uzi * iy;
            double tiy = this.uzi * ix - this.uxi * iz;
            double tiz = this.uxi * iy - this.uyi * ix;
            double tkx = this.uyk * kz - this.uzk * ky;
            double tky = this.uzk * kx - this.uxk * kz;
            double tkz = this.uxk * ky - this.uyk * kx;
            double ixx = -0.5 * (this.ck * this.gqxx[1] + this.uxk * this.gqxx[2] + this.uyk * this.gqxx[3] + this.uzk * this.gqxx[4] + this.qxxk * this.gqxx[5] + this.qyyk * this.gqxx[8] + this.qzzk * this.gqxx[10] + 2.0 * (this.qxyk * this.gqxx[6] + this.qxzk * this.gqxx[7] + this.qyzk * this.gqxx[9]) + this.ck * this.gc[5] + this.uxk * this.gux[5] + this.uyk * this.guy[5] + this.uzk * this.guz[5] + this.qxxk * this.gqxx[5] + this.qyyk * this.gqyy[5] + this.qzzk * this.gqzz[5] + 2.0 * (this.qxyk * this.gqxy[5] + this.qxzk * this.gqxz[5] + this.qyzk * this.gqyz[5]));
            double ixy = -0.5 * (this.ck * this.gqxy[1] + this.uxk * this.gqxy[2] + this.uyk * this.gqxy[3] + this.uzk * this.gqxy[4] + this.qxxk * this.gqxy[5] + this.qyyk * this.gqxy[8] + this.qzzk * this.gqxy[10] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxy[7] + this.qyzk * this.gqxy[9]) + this.ck * this.gc[6] + this.uxk * this.gux[6] + this.uyk * this.guy[6] + this.uzk * this.guz[6] + this.qxxk * this.gqxx[6] + this.qyyk * this.gqyy[6] + this.qzzk * this.gqzz[6] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxz[6] + this.qyzk * this.gqyz[6]));
            double ixz = -0.5 * (this.ck * this.gqxz[1] + this.uxk * this.gqxz[2] + this.uyk * this.gqxz[3] + this.uzk * this.gqxz[4] + this.qxxk * this.gqxz[5] + this.qyyk * this.gqxz[8] + this.qzzk * this.gqxz[10] + 2.0 * (this.qxyk * this.gqxz[6] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqxz[9]) + this.ck * this.gc[7] + this.uxk * this.gux[7] + this.uyk * this.guy[7] + this.uzk * this.guz[7] + this.qxxk * this.gqxx[7] + this.qyyk * this.gqyy[7] + this.qzzk * this.gqzz[7] + 2.0 * (this.qxyk * this.gqxy[7] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqyz[7]));
            double iyy = -0.5 * (this.ck * this.gqyy[1] + this.uxk * this.gqyy[2] + this.uyk * this.gqyy[3] + this.uzk * this.gqyy[4] + this.qxxk * this.gqyy[5] + this.qyyk * this.gqyy[8] + this.qzzk * this.gqyy[10] + 2.0 * (this.qxyk * this.gqyy[6] + this.qxzk * this.gqyy[7] + this.qyzk * this.gqyy[9]) + this.ck * this.gc[8] + this.uxk * this.gux[8] + this.uyk * this.guy[8] + this.uzk * this.guz[8] + this.qxxk * this.gqxx[8] + this.qyyk * this.gqyy[8] + this.qzzk * this.gqzz[8] + 2.0 * (this.qxyk * this.gqxy[8] + this.qxzk * this.gqxz[8] + this.qyzk * this.gqyz[8]));
            double iyz = -0.5 * (this.ck * this.gqyz[1] + this.uxk * this.gqyz[2] + this.uyk * this.gqyz[3] + this.uzk * this.gqyz[4] + this.qxxk * this.gqyz[5] + this.qyyk * this.gqyz[8] + this.qzzk * this.gqyz[10] + 2.0 * (this.qxyk * this.gqyz[6] + this.qxzk * this.gqyz[7] + this.qyzk * this.gqyz[9]) + this.ck * this.gc[9] + this.uxk * this.gux[9] + this.uyk * this.guy[9] + this.uzk * this.guz[9] + this.qxxk * this.gqxx[9] + this.qyyk * this.gqyy[9] + this.qzzk * this.gqzz[9] + 2.0 * (this.qxyk * this.gqxy[9] + this.qxzk * this.gqxz[9] + this.qyzk * this.gqyz[9]));
            double izz = -0.5 * (this.ck * this.gqzz[1] + this.uxk * this.gqzz[2] + this.uyk * this.gqzz[3] + this.uzk * this.gqzz[4] + this.qxxk * this.gqzz[5] + this.qyyk * this.gqzz[8] + this.qzzk * this.gqzz[10] + 2.0 * (this.qxyk * this.gqzz[6] + this.qxzk * this.gqzz[7] + this.qyzk * this.gqzz[9]) + this.ck * this.gc[10] + this.uxk * this.gux[10] + this.uyk * this.guy[10] + this.uzk * this.guz[10] + this.qxxk * this.gqxx[10] + this.qyyk * this.gqyy[10] + this.qzzk * this.gqzz[10] + 2.0 * (this.qxyk * this.gqxy[10] + this.qxzk * this.gqxz[10] + this.qyzk * this.gqyz[10]));
            double iyx = ixy;
            double izx = ixz;
            double izy = iyz;
            double kxx = -0.5 * (this.ci * this.gqxx[1] - this.uxi * this.gqxx[2] - this.uyi * this.gqxx[3] - this.uzi * this.gqxx[4] + this.qxxi * this.gqxx[5] + this.qyyi * this.gqxx[8] + this.qzzi * this.gqxx[10] + 2.0 * (this.qxyi * this.gqxx[6] + this.qxzi * this.gqxx[7] + this.qyzi * this.gqxx[9]) + this.ci * this.gc[5] - this.uxi * this.gux[5] - this.uyi * this.guy[5] - this.uzi * this.guz[5] + this.qxxi * this.gqxx[5] + this.qyyi * this.gqyy[5] + this.qzzi * this.gqzz[5] + 2.0 * (this.qxyi * this.gqxy[5] + this.qxzi * this.gqxz[5] + this.qyzi * this.gqyz[5]));
            double kxy = -0.5 * (this.ci * this.gqxy[1] - this.uxi * this.gqxy[2] - this.uyi * this.gqxy[3] - this.uzi * this.gqxy[4] + this.qxxi * this.gqxy[5] + this.qyyi * this.gqxy[8] + this.qzzi * this.gqxy[10] + 2.0 * (this.qxyi * this.gqxy[6] + this.qxzi * this.gqxy[7] + this.qyzi * this.gqxy[9]) + this.ci * this.gc[6] - this.uxi * this.gux[6] - this.uyi * this.guy[6] - this.uzi * this.guz[6] + this.qxxi * this.gqxx[6] + this.qyyi * this.gqyy[6] + this.qzzi * this.gqzz[6] + 2.0 * (this.qxyi * this.gqxy[6] + this.qxzi * this.gqxz[6] + this.qyzi * this.gqyz[6]));
            double kxz = -0.5 * (this.ci * this.gqxz[1] - this.uxi * this.gqxz[2] - this.uyi * this.gqxz[3] - this.uzi * this.gqxz[4] + this.qxxi * this.gqxz[5] + this.qyyi * this.gqxz[8] + this.qzzi * this.gqxz[10] + 2.0 * (this.qxyi * this.gqxz[6] + this.qxzi * this.gqxz[7] + this.qyzi * this.gqxz[9]) + this.ci * this.gc[7] - this.uxi * this.gux[7] - this.uyi * this.guy[7] - this.uzi * this.guz[7] + this.qxxi * this.gqxx[7] + this.qyyi * this.gqyy[7] + this.qzzi * this.gqzz[7] + 2.0 * (this.qxyi * this.gqxy[7] + this.qxzi * this.gqxz[7] + this.qyzi * this.gqyz[7]));
            double kyy = -0.5 * (this.ci * this.gqyy[1] - this.uxi * this.gqyy[2] - this.uyi * this.gqyy[3] - this.uzi * this.gqyy[4] + this.qxxi * this.gqyy[5] + this.qyyi * this.gqyy[8] + this.qzzi * this.gqyy[10] + 2.0 * (this.qxyi * this.gqyy[6] + this.qxzi * this.gqyy[7] + this.qyzi * this.gqyy[9]) + this.ci * this.gc[8] - this.uxi * this.gux[8] - this.uyi * this.guy[8] - this.uzi * this.guz[8] + this.qxxi * this.gqxx[8] + this.qyyi * this.gqyy[8] + this.qzzi * this.gqzz[8] + 2.0 * (this.qxyi * this.gqxy[8] + this.qxzi * this.gqxz[8] + this.qyzi * this.gqyz[8]));
            double kyz = -0.5 * (this.ci * this.gqyz[1] - this.uxi * this.gqyz[2] - this.uyi * this.gqyz[3] - this.uzi * this.gqyz[4] + this.qxxi * this.gqyz[5] + this.qyyi * this.gqyz[8] + this.qzzi * this.gqyz[10] + 2.0 * (this.qxyi * this.gqyz[6] + this.qxzi * this.gqyz[7] + this.qyzi * this.gqyz[9]) + this.ci * this.gc[9] - this.uxi * this.gux[9] - this.uyi * this.guy[9] - this.uzi * this.guz[9] + this.qxxi * this.gqxx[9] + this.qyyi * this.gqyy[9] + this.qzzi * this.gqzz[9] + 2.0 * (this.qxyi * this.gqxy[9] + this.qxzi * this.gqxz[9] + this.qyzi * this.gqyz[9]));
            double kzz = -0.5 * (this.ci * this.gqzz[1] - this.uxi * this.gqzz[2] - this.uyi * this.gqzz[3] - this.uzi * this.gqzz[4] + this.qxxi * this.gqzz[5] + this.qyyi * this.gqzz[8] + this.qzzi * this.gqzz[10] + 2.0 * (this.qxyi * this.gqzz[6] + this.qxzi * this.gqzz[7] + this.qyzi * this.gqzz[9]) + this.ci * this.gc[10] - this.uxi * this.gux[10] - this.uyi * this.guy[10] - this.uzi * this.guz[10] + this.qxxi * this.gqxx[10] + this.qyyi * this.gqyy[10] + this.qzzi * this.gqzz[10] + 2.0 * (this.qxyi * this.gqxy[10] + this.qxzi * this.gqxz[10] + this.qyzi * this.gqyz[10]));
            double kyx = kxy;
            double kzx = kxz;
            double kzy = kyz;
            tix += 2.0 * (this.qxyi * ixz + this.qyyi * iyz + this.qyzi * izz - this.qxzi * ixy - this.qyzi * iyy - this.qzzi * izy);
            tiy += 2.0 * (this.qxzi * ixx + this.qyzi * iyx + this.qzzi * izx - this.qxxi * ixz - this.qxyi * iyz - this.qxzi * izz);
            tiz += 2.0 * (this.qxxi * ixy + this.qxyi * iyy + this.qxzi * izy - this.qxyi * ixx - this.qyyi * iyx - this.qyzi * izx);
            tkx += 2.0 * (this.qxyk * kxz + this.qyyk * kyz + this.qyzk * kzz - this.qxzk * kxy - this.qyzk * kyy - this.qzzk * kzy);
            tky += 2.0 * (this.qxzk * kxx + this.qyzk * kyx + this.qzzk * kzx - this.qxxk * kxz - this.qxyk * kyz - this.qxzk * kzz);
            tkz += 2.0 * (this.qxxk * kxy + this.qxyk * kyy + this.qxzk * kzy - this.qxyk * kxx - this.qyyk * kyx - this.qyzk * kzx);
            if (i == k) {
                double selfScale = 0.5;
                tix *= selfScale;
                tiy *= selfScale;
                tiz *= selfScale;
                tkx *= selfScale;
                tky *= selfScale;
                tkz *= selfScale;
            }
            this.trqxi += tix;
            this.trqyi += tiy;
            this.trqzi += tiz;
            double rtkx = tkx * this.transOp[0][0] + tky * this.transOp[1][0] + tkz * this.transOp[2][0];
            double rtky = tkx * this.transOp[0][1] + tky * this.transOp[1][1] + tkz * this.transOp[2][1];
            double rtkz = tkx * this.transOp[0][2] + tky * this.transOp[1][2] + tkz * this.transOp[2][2];
            this.this$0.torque.add(this.threadID, k, rtkx, rtky, rtkz);
        }

        private void polarizationEnergyGradient(int i, int k) {
            double dpsymdx = -this.uxi * (this.sxk * this.gux[5] + this.syk * this.guy[5] + this.szk * this.guz[5]) - this.uyi * (this.sxk * this.gux[6] + this.syk * this.guy[6] + this.szk * this.guz[6]) - this.uzi * (this.sxk * this.gux[7] + this.syk * this.guy[7] + this.szk * this.guz[7]) - this.uxk * (this.sxi * this.gux[5] + this.syi * this.guy[5] + this.szi * this.guz[5]) - this.uyk * (this.sxi * this.gux[6] + this.syi * this.guy[6] + this.szi * this.guz[6]) - this.uzk * (this.sxi * this.gux[7] + this.syi * this.guy[7] + this.szi * this.guz[7]);
            double dpwidx = this.ci * (this.sxk * this.gc[5] + this.syk * this.gc[6] + this.szk * this.gc[7]) - this.ck * (this.sxi * this.gux[2] + this.syi * this.guy[2] + this.szi * this.guz[2]) - this.sxi * (this.qxxk * this.gux[11] + this.qyyk * this.gux[14] + this.qzzk * this.gux[16] + 2.0 * (this.qxyk * this.gux[12] + this.qxzk * this.gux[13] + this.qyzk * this.gux[15])) - this.syi * (this.qxxk * this.guy[11] + this.qyyk * this.guy[14] + this.qzzk * this.guy[16] + 2.0 * (this.qxyk * this.guy[12] + this.qxzk * this.guy[13] + this.qyzk * this.guy[15])) - this.szi * (this.qxxk * this.guz[11] + this.qyyk * this.guz[14] + this.qzzk * this.guz[16] + 2.0 * (this.qxyk * this.guz[12] + this.qxzk * this.guz[13] + this.qyzk * this.guz[15])) + this.sxk * (this.qxxi * this.gqxx[5] + this.qyyi * this.gqyy[5] + this.qzzi * this.gqzz[5] + 2.0 * (this.qxyi * this.gqxy[5] + this.qxzi * this.gqxz[5] + this.qyzi * this.gqyz[5])) + this.syk * (this.qxxi * this.gqxx[6] + this.qyyi * this.gqyy[6] + this.qzzi * this.gqzz[6] + 2.0 * (this.qxyi * this.gqxy[6] + this.qxzi * this.gqxz[6] + this.qyzi * this.gqyz[6])) + this.szk * (this.qxxi * this.gqxx[7] + this.qyyi * this.gqyy[7] + this.qzzi * this.gqzz[7] + 2.0 * (this.qxyi * this.gqxy[7] + this.qxzi * this.gqxz[7] + this.qyzi * this.gqyz[7]));
            double dpwkdx = this.ci * (this.sxk * this.gux[2] + this.syk * this.guy[2] + this.szk * this.guz[2]) - this.ck * (this.sxi * this.gc[5] + this.syi * this.gc[6] + this.szi * this.gc[7]) - this.sxi * (this.qxxk * this.gqxx[5] + this.qyyk * this.gqyy[5] + this.qzzk * this.gqzz[5] + 2.0 * (this.qxyk * this.gqxy[5] + this.qxzk * this.gqxz[5] + this.qyzk * this.gqyz[5])) - this.syi * (this.qxxk * this.gqxx[6] + this.qyyk * this.gqyy[6] + this.qzzk * this.gqzz[6] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxz[6] + this.qyzk * this.gqyz[6])) - this.szi * (this.qxxk * this.gqxx[7] + this.qyyk * this.gqyy[7] + this.qzzk * this.gqzz[7] + 2.0 * (this.qxyk * this.gqxy[7] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqyz[7])) + this.sxk * (this.qxxi * this.gux[11] + this.qyyi * this.gux[14] + this.qzzi * this.gux[16] + 2.0 * (this.qxyi * this.gux[12] + this.qxzi * this.gux[13] + this.qyzi * this.gux[15])) + this.syk * (this.qxxi * this.guy[11] + this.qyyi * this.guy[14] + this.qzzi * this.guy[16] + 2.0 * (this.qxyi * this.guy[12] + this.qxzi * this.guy[13] + this.qyzi * this.guy[15])) + this.szk * (this.qxxi * this.guz[11] + this.qyyi * this.guz[14] + this.qzzi * this.guz[16] + 2.0 * (this.qxyi * this.guz[12] + this.qxzi * this.guz[13] + this.qyzi * this.guz[15]));
            double dpsymdy = -this.uxi * (this.sxk * this.gux[6] + this.syk * this.guy[6] + this.szk * this.guz[6]) - this.uyi * (this.sxk * this.gux[8] + this.syk * this.guy[8] + this.szk * this.guz[8]) - this.uzi * (this.sxk * this.gux[9] + this.syk * this.guy[9] + this.szk * this.guz[9]) - this.uxk * (this.sxi * this.gux[6] + this.syi * this.guy[6] + this.szi * this.guz[6]) - this.uyk * (this.sxi * this.gux[8] + this.syi * this.guy[8] + this.szi * this.guz[8]) - this.uzk * (this.sxi * this.gux[9] + this.syi * this.guy[9] + this.szi * this.guz[9]);
            double dpwidy = this.ci * (this.sxk * this.gc[6] + this.syk * this.gc[8] + this.szk * this.gc[9]) - this.ck * (this.sxi * this.gux[3] + this.syi * this.guy[3] + this.szi * this.guz[3]) - this.sxi * (this.qxxk * this.gux[12] + this.qyyk * this.gux[17] + this.qzzk * this.gux[19] + 2.0 * (this.qxyk * this.gux[14] + this.qxzk * this.gux[15] + this.qyzk * this.gux[18])) - this.syi * (this.qxxk * this.guy[12] + this.qyyk * this.guy[17] + this.qzzk * this.guy[19] + 2.0 * (this.qxyk * this.guy[14] + this.qxzk * this.guy[15] + this.qyzk * this.guy[18])) - this.szi * (this.qxxk * this.guz[12] + this.qyyk * this.guz[17] + this.qzzk * this.guz[19] + 2.0 * (this.qxyk * this.guz[14] + this.qxzk * this.guz[15] + this.qyzk * this.guz[18])) + this.sxk * (this.qxxi * this.gqxx[6] + this.qyyi * this.gqyy[6] + this.qzzi * this.gqzz[6] + 2.0 * (this.qxyi * this.gqxy[6] + this.qxzi * this.gqxz[6] + this.qyzi * this.gqyz[6])) + this.syk * (this.qxxi * this.gqxx[8] + this.qyyi * this.gqyy[8] + this.qzzi * this.gqzz[8] + 2.0 * (this.qxyi * this.gqxy[8] + this.qxzi * this.gqxz[8] + this.qyzi * this.gqyz[8])) + this.szk * (this.qxxi * this.gqxx[9] + this.qyyi * this.gqyy[9] + this.qzzi * this.gqzz[9] + 2.0 * (this.qxyi * this.gqxy[9] + this.qxzi * this.gqxz[9] + this.qyzi * this.gqyz[9]));
            double dpwkdy = this.ci * (this.sxk * this.gux[3] + this.syk * this.guy[3] + this.szk * this.guz[3]) - this.ck * (this.sxi * this.gc[6] + this.syi * this.gc[8] + this.szi * this.gc[9]) - this.sxi * (this.qxxk * this.gqxx[6] + this.qyyk * this.gqyy[6] + this.qzzk * this.gqzz[6] + 2.0 * (this.qxyk * this.gqxy[6] + this.qxzk * this.gqxz[6] + this.qyzk * this.gqyz[6])) - this.syi * (this.qxxk * this.gqxx[8] + this.qyyk * this.gqyy[8] + this.qzzk * this.gqzz[8] + 2.0 * (this.qxyk * this.gqxy[8] + this.qxzk * this.gqxz[8] + this.qyzk * this.gqyz[8])) - this.szi * (this.qxxk * this.gqxx[9] + this.qyyk * this.gqyy[9] + this.qzzk * this.gqzz[9] + 2.0 * (this.qxyk * this.gqxy[9] + this.qxzk * this.gqxz[9] + this.qyzk * this.gqyz[9])) + this.sxk * (this.qxxi * this.gux[12] + this.qyyi * this.gux[17] + this.qzzi * this.gux[19] + 2.0 * (this.qxyi * this.gux[14] + this.qxzi * this.gux[15] + this.qyzi * this.gux[18])) + this.syk * (this.qxxi * this.guy[12] + this.qyyi * this.guy[17] + this.qzzi * this.guy[19] + 2.0 * (this.qxyi * this.guy[14] + this.qxzi * this.guy[15] + this.qyzi * this.guy[18])) + this.szk * (this.qxxi * this.guz[12] + this.qyyi * this.guz[17] + this.qzzi * this.guz[19] + 2.0 * (this.qxyi * this.guz[14] + this.qxzi * this.guz[15] + this.qyzi * this.guz[18]));
            double dpsymdz = -this.uxi * (this.sxk * this.gux[7] + this.syk * this.guy[7] + this.szk * this.guz[7]) - this.uyi * (this.sxk * this.gux[9] + this.syk * this.guy[9] + this.szk * this.guz[9]) - this.uzi * (this.sxk * this.gux[10] + this.syk * this.guy[10] + this.szk * this.guz[10]) - this.uxk * (this.sxi * this.gux[7] + this.syi * this.guy[7] + this.szi * this.guz[7]) - this.uyk * (this.sxi * this.gux[9] + this.syi * this.guy[9] + this.szi * this.guz[9]) - this.uzk * (this.sxi * this.gux[10] + this.syi * this.guy[10] + this.szi * this.guz[10]);
            double dpwidz = this.ci * (this.sxk * this.gc[7] + this.syk * this.gc[9] + this.szk * this.gc[10]) - this.ck * (this.sxi * this.gux[4] + this.syi * this.guy[4] + this.szi * this.guz[4]) - this.sxi * (this.qxxk * this.gux[13] + this.qyyk * this.gux[18] + this.qzzk * this.gux[20] + 2.0 * (this.qxyk * this.gux[15] + this.qxzk * this.gux[16] + this.qyzk * this.gux[19])) - this.syi * (this.qxxk * this.guy[13] + this.qyyk * this.guy[18] + this.qzzk * this.guy[20] + 2.0 * (this.qxyk * this.guy[15] + this.qxzk * this.guy[16] + this.qyzk * this.guy[19])) - this.szi * (this.qxxk * this.guz[13] + this.qyyk * this.guz[18] + this.qzzk * this.guz[20] + 2.0 * (this.qxyk * this.guz[15] + this.qxzk * this.guz[16] + this.qyzk * this.guz[19])) + this.sxk * (this.qxxi * this.gqxx[7] + this.qyyi * this.gqyy[7] + this.qzzi * this.gqzz[7] + 2.0 * (this.qxyi * this.gqxy[7] + this.qxzi * this.gqxz[7] + this.qyzi * this.gqyz[7])) + this.syk * (this.qxxi * this.gqxx[9] + this.qyyi * this.gqyy[9] + this.qzzi * this.gqzz[9] + 2.0 * (this.qxyi * this.gqxy[9] + this.qxzi * this.gqxz[9] + this.qyzi * this.gqyz[9])) + this.szk * (this.qxxi * this.gqxx[10] + this.qyyi * this.gqyy[10] + this.qzzi * this.gqzz[10] + 2.0 * (this.qxyi * this.gqxy[10] + this.qxzi * this.gqxz[10] + this.qyzi * this.gqyz[10]));
            double dpwkdz = this.ci * (this.sxk * this.gux[4] + this.syk * this.guy[4] + this.szk * this.guz[4]) - this.ck * (this.sxi * this.gc[7] + this.syi * this.gc[9] + this.szi * this.gc[10]) - this.sxi * (this.qxxk * this.gqxx[7] + this.qyyk * this.gqyy[7] + this.qzzk * this.gqzz[7] + 2.0 * (this.qxyk * this.gqxy[7] + this.qxzk * this.gqxz[7] + this.qyzk * this.gqyz[7])) - this.syi * (this.qxxk * this.gqxx[9] + this.qyyk * this.gqyy[9] + this.qzzk * this.gqzz[9] + 2.0 * (this.qxyk * this.gqxy[9] + this.qxzk * this.gqxz[9] + this.qyzk * this.gqyz[9])) - this.szi * (this.qxxk * this.gqxx[10] + this.qyyk * this.gqyy[10] + this.qzzk * this.gqzz[10] + 2.0 * (this.qxyk * this.gqxy[10] + this.qxzk * this.gqxz[10] + this.qyzk * this.gqyz[10])) + this.sxk * (this.qxxi * this.gux[13] + this.qyyi * this.gux[18] + this.qzzi * this.gux[20] + 2.0 * (this.qxyi * this.gux[15] + this.qxzi * this.gux[16] + this.qyzi * this.gux[19])) + this.syk * (this.qxxi * this.guy[13] + this.qyyi * this.guy[18] + this.qzzi * this.guy[20] + 2.0 * (this.qxyi * this.guy[15] + this.qxzi * this.guy[16] + this.qyzi * this.guy[19])) + this.szk * (this.qxxi * this.guz[13] + this.qyyi * this.guz[18] + this.qzzi * this.guz[20] + 2.0 * (this.qxyi * this.guz[15] + this.qxzi * this.guz[16] + this.qyzi * this.guz[19]));
            double dsymdr = -this.uxi * (this.sxk * this.gux[22] + this.syk * this.guy[22] + this.szk * this.guz[22]) - this.uyi * (this.sxk * this.gux[23] + this.syk * this.guy[23] + this.szk * this.guz[23]) - this.uzi * (this.sxk * this.gux[24] + this.syk * this.guy[24] + this.szk * this.guz[24]) - this.uxk * (this.sxi * this.gux[22] + this.syi * this.guy[22] + this.szi * this.guz[22]) - this.uyk * (this.sxi * this.gux[23] + this.syi * this.guy[23] + this.szi * this.guz[23]) - this.uzk * (this.sxi * this.gux[24] + this.syi * this.guy[24] + this.szi * this.guz[24]);
            double dwipdr = this.ci * (this.sxk * this.gc[22] + this.syk * this.gc[23] + this.szk * this.gc[24]) - this.ck * (this.sxi * this.gux[21] + this.syi * this.guy[21] + this.szi * this.guz[21]) - this.sxi * (this.qxxk * this.gux[25] + this.qyyk * this.gux[28] + this.qzzk * this.gux[30] + 2.0 * (this.qxyk * this.gux[26] + this.qxzk * this.gux[27] + this.qyzk * this.gux[29])) - this.syi * (this.qxxk * this.guy[25] + this.qyyk * this.guy[28] + this.qzzk * this.guy[30] + 2.0 * (this.qxyk * this.guy[26] + this.qxzk * this.guy[27] + this.qyzk * this.guy[29])) - this.szi * (this.qxxk * this.guz[25] + this.qyyk * this.guz[28] + this.qzzk * this.guz[30] + 2.0 * (this.qxyk * this.guz[26] + this.qxzk * this.guz[27] + this.qyzk * this.guz[29])) + this.sxk * (this.qxxi * this.gqxx[22] + this.qyyi * this.gqyy[22] + this.qzzi * this.gqzz[22] + 2.0 * (this.qxyi * this.gqxy[22] + this.qxzi * this.gqxz[22] + this.qyzi * this.gqyz[22])) + this.syk * (this.qxxi * this.gqxx[23] + this.qyyi * this.gqyy[23] + this.qzzi * this.gqzz[23] + 2.0 * (this.qxyi * this.gqxy[23] + this.qxzi * this.gqxz[23] + this.qyzi * this.gqyz[23])) + this.szk * (this.qxxi * this.gqxx[24] + this.qyyi * this.gqyy[24] + this.qzzi * this.gqzz[24] + 2.0 * (this.qxyi * this.gqxy[24] + this.qxzi * this.gqxz[24] + this.qyzi * this.gqyz[24]));
            double dwkpdr = this.ci * (this.sxk * this.gux[21] + this.syk * this.guy[21] + this.szk * this.guz[21]) - this.ck * (this.sxi * this.gc[22] + this.syi * this.gc[23] + this.szi * this.gc[24]) - this.sxi * (this.qxxk * this.gqxx[22] + this.qyyk * this.gqyy[22] + this.qzzk * this.gqzz[22] + 2.0 * (this.qxyk * this.gqxy[22] + this.qxzk * this.gqxz[22] + this.qyzk * this.gqyz[22])) - this.syi * (this.qxxk * this.gqxx[23] + this.qyyk * this.gqyy[23] + this.qzzk * this.gqzz[23] + 2.0 * (this.qxyk * this.gqxy[23] + this.qxzk * this.gqxz[23] + this.qyzk * this.gqyz[23])) - this.szi * (this.qxxk * this.gqxx[24] + this.qyyk * this.gqyy[24] + this.qzzk * this.gqzz[24] + 2.0 * (this.qxyk * this.gqxy[24] + this.qxzk * this.gqxz[24] + this.qyzk * this.gqyz[24])) + this.sxk * (this.qxxi * this.gux[25] + this.qyyi * this.gux[28] + this.qzzi * this.gux[30] + 2.0 * (this.qxyi * this.gux[26] + this.qxzi * this.gux[27] + this.qyzi * this.gux[29])) + this.syk * (this.qxxi * this.guy[25] + this.qyyi * this.guy[28] + this.qzzi * this.guy[30] + 2.0 * (this.qxyi * this.guy[26] + this.qxzi * this.guy[27] + this.qyzi * this.guy[29])) + this.szk * (this.qxxi * this.guz[25] + this.qyyi * this.guz[28] + this.qzzi * this.guz[30] + 2.0 * (this.qxyi * this.guz[26] + this.qxzi * this.guz[27] + this.qyzi * this.guz[29]));
            double dpdx = 0.5 * (dpsymdx + 0.5 * (dpwidx + dpwkdx));
            double dpdy = 0.5 * (dpsymdy + 0.5 * (dpwidy + dpwkdy));
            double dpdz = 0.5 * (dpsymdz + 0.5 * (dpwidz + dpwkdz));
            double dsumdri = dsymdr + 0.5 * (dwipdr + dwkpdr);
            double dbi = 0.5 * this.rbk * dsumdri;
            double dbk = 0.5 * this.rbi * dsumdri;
            if (this.this$0.polarization == Polarization.MUTUAL) {
                dpdx -= 0.5 * (this.dxi * (this.pxk * this.gux[5] + this.pyk * this.gux[6] + this.pzk * this.gux[7]) + this.dyi * (this.pxk * this.guy[5] + this.pyk * this.guy[6] + this.pzk * this.guy[7]) + this.dzi * (this.pxk * this.guz[5] + this.pyk * this.guz[6] + this.pzk * this.guz[7]) + this.dxk * (this.pxi * this.gux[5] + this.pyi * this.gux[6] + this.pzi * this.gux[7]) + this.dyk * (this.pxi * this.guy[5] + this.pyi * this.guy[6] + this.pzi * this.guy[7]) + this.dzk * (this.pxi * this.guz[5] + this.pyi * this.guz[6] + this.pzi * this.guz[7]));
                dpdy -= 0.5 * (this.dxi * (this.pxk * this.gux[6] + this.pyk * this.gux[8] + this.pzk * this.gux[9]) + this.dyi * (this.pxk * this.guy[6] + this.pyk * this.guy[8] + this.pzk * this.guy[9]) + this.dzi * (this.pxk * this.guz[6] + this.pyk * this.guz[8] + this.pzk * this.guz[9]) + this.dxk * (this.pxi * this.gux[6] + this.pyi * this.gux[8] + this.pzi * this.gux[9]) + this.dyk * (this.pxi * this.guy[6] + this.pyi * this.guy[8] + this.pzi * this.guy[9]) + this.dzk * (this.pxi * this.guz[6] + this.pyi * this.guz[8] + this.pzi * this.guz[9]));
                dpdz -= 0.5 * (this.dxi * (this.pxk * this.gux[7] + this.pyk * this.gux[9] + this.pzk * this.gux[10]) + this.dyi * (this.pxk * this.guy[7] + this.pyk * this.guy[9] + this.pzk * this.guy[10]) + this.dzi * (this.pxk * this.guz[7] + this.pyk * this.guz[9] + this.pzk * this.guz[10]) + this.dxk * (this.pxi * this.gux[7] + this.pyi * this.gux[9] + this.pzi * this.gux[10]) + this.dyk * (this.pxi * this.guy[7] + this.pyi * this.guy[9] + this.pzi * this.guy[10]) + this.dzk * (this.pxi * this.guz[7] + this.pyi * this.guz[9] + this.pzi * this.guz[10]));
                double duvdr = this.dxi * (this.pxk * this.gux[22] + this.pyk * this.gux[23] + this.pzk * this.gux[24]) + this.dyi * (this.pxk * this.guy[22] + this.pyk * this.guy[23] + this.pzk * this.guy[24]) + this.dzi * (this.pxk * this.guz[22] + this.pyk * this.guz[23] + this.pzk * this.guz[24]) + this.dxk * (this.pxi * this.gux[22] + this.pyi * this.gux[23] + this.pzi * this.gux[24]) + this.dyk * (this.pxi * this.guy[22] + this.pyi * this.guy[23] + this.pzi * this.guy[24]) + this.dzk * (this.pxi * this.guz[22] + this.pyi * this.guz[23] + this.pzi * this.guz[24]);
                dbi -= 0.5 * this.rbk * duvdr;
                dbk -= 0.5 * this.rbi * duvdr;
            }
            if (i == k && this.iSymm == 0) {
                this.dborni += dbi;
            } else {
                if (i == k) {
                    dpdx *= 0.5;
                    dpdy *= 0.5;
                    dpdz *= 0.5;
                    dbi *= 0.5;
                    dbk *= 0.5;
                }
                this.dedxi -= dpdx;
                this.dedyi -= dpdy;
                this.dedzi -= dpdz;
                this.dborni += dbi;
                double rdpdx = dpdx * this.transOp[0][0] + dpdy * this.transOp[1][0] + dpdz * this.transOp[2][0];
                double rdpdy = dpdx * this.transOp[0][1] + dpdy * this.transOp[1][1] + dpdz * this.transOp[2][1];
                double rdpdz = dpdx * this.transOp[0][2] + dpdy * this.transOp[1][2] + dpdz * this.transOp[2][2];
                this.this$0.grad.add(this.threadID, k, rdpdx, rdpdy, rdpdz);
                this.this$0.sharedBornGrad.add(this.threadID, k, dbk);
            }
            this.polarizationEnergyTorque(i, k);
        }

        private void polarizationEnergyTorque(int i, int k) {
            double fix = 0.5 * (this.sxk * this.gux[2] + this.syk * this.guy[2] + this.szk * this.guz[2]);
            double fiy = 0.5 * (this.sxk * this.gux[3] + this.syk * this.guy[3] + this.szk * this.guz[3]);
            double fiz = 0.5 * (this.sxk * this.gux[4] + this.syk * this.guy[4] + this.szk * this.guz[4]);
            double fkx = 0.5 * (this.sxi * this.gux[2] + this.syi * this.guy[2] + this.szi * this.guz[2]);
            double fky = 0.5 * (this.sxi * this.gux[3] + this.syi * this.guy[3] + this.szi * this.guz[3]);
            double fkz = 0.5 * (this.sxi * this.gux[4] + this.syi * this.guy[4] + this.szi * this.guz[4]);
            double fixx = -0.25 * (this.sxk * this.gqxx[2] + this.syk * this.gqxx[3] + this.szk * this.gqxx[4] + (this.sxk * this.gux[5] + this.syk * this.guy[5] + this.szk * this.guz[5]));
            double fixy = -0.25 * (this.sxk * this.gqxy[2] + this.syk * this.gqxy[3] + this.szk * this.gqxy[4] + (this.sxk * this.gux[6] + this.syk * this.guy[6] + this.szk * this.guz[6]));
            double fixz = -0.25 * (this.sxk * this.gqxz[2] + this.syk * this.gqxz[3] + this.szk * this.gqxz[4] + (this.sxk * this.gux[7] + this.syk * this.guy[7] + this.szk * this.guz[7]));
            double fiyy = -0.25 * (this.sxk * this.gqyy[2] + this.syk * this.gqyy[3] + this.szk * this.gqyy[4] + (this.sxk * this.gux[8] + this.syk * this.guy[8] + this.szk * this.guz[8]));
            double fiyz = -0.25 * (this.sxk * this.gqyz[2] + this.syk * this.gqyz[3] + this.szk * this.gqyz[4] + (this.sxk * this.gux[9] + this.syk * this.guy[9] + this.szk * this.guz[9]));
            double fizz = -0.25 * (this.sxk * this.gqzz[2] + this.syk * this.gqzz[3] + this.szk * this.gqzz[4] + (this.sxk * this.gux[10] + this.syk * this.guy[10] + this.szk * this.guz[10]));
            double fiyx = fixy;
            double fizx = fixz;
            double fizy = fiyz;
            double fkxx = 0.25 * (this.sxi * this.gqxx[2] + this.syi * this.gqxx[3] + this.szi * this.gqxx[4] + (this.sxi * this.gux[5] + this.syi * this.guy[5] + this.szi * this.guz[5]));
            double fkxy = 0.25 * (this.sxi * this.gqxy[2] + this.syi * this.gqxy[3] + this.szi * this.gqxy[4] + (this.sxi * this.gux[6] + this.syi * this.guy[6] + this.szi * this.guz[6]));
            double fkxz = 0.25 * (this.sxi * this.gqxz[2] + this.syi * this.gqxz[3] + this.szi * this.gqxz[4] + (this.sxi * this.gux[7] + this.syi * this.guy[7] + this.szi * this.guz[7]));
            double fkyy = 0.25 * (this.sxi * this.gqyy[2] + this.syi * this.gqyy[3] + this.szi * this.gqyy[4] + (this.sxi * this.gux[8] + this.syi * this.guy[8] + this.szi * this.guz[8]));
            double fkyz = 0.25 * (this.sxi * this.gqyz[2] + this.syi * this.gqyz[3] + this.szi * this.gqyz[4] + (this.sxi * this.gux[9] + this.syi * this.guy[9] + this.szi * this.guz[9]));
            double fkzz = 0.25 * (this.sxi * this.gqzz[2] + this.syi * this.gqzz[3] + this.szi * this.gqzz[4] + (this.sxi * this.gux[10] + this.syi * this.guy[10] + this.szi * this.guz[10]));
            double fkyx = fkxy;
            double fkzx = fkxz;
            double fkzy = fkyz;
            if (i == k) {
                fix *= 0.5;
                fiy *= 0.5;
                fiz *= 0.5;
                fkx *= 0.5;
                fky *= 0.5;
                fkz *= 0.5;
                fixx *= 0.5;
                fixy *= 0.5;
                fixz *= 0.5;
                fiyx *= 0.5;
                fiyy *= 0.5;
                fiyz *= 0.5;
                fizx *= 0.5;
                fizy *= 0.5;
                fizz *= 0.5;
                fkxx *= 0.5;
                fkxy *= 0.5;
                fkxz *= 0.5;
                fkyx *= 0.5;
                fkyy *= 0.5;
                fkyz *= 0.5;
                fkzx *= 0.5;
                fkzy *= 0.5;
                fkzz *= 0.5;
            }
            double tix = this.uyi * fiz - this.uzi * fiy;
            double tiy = this.uzi * fix - this.uxi * fiz;
            double tiz = this.uxi * fiy - this.uyi * fix;
            double tkx = this.uyk * fkz - this.uzk * fky;
            double tky = this.uzk * fkx - this.uxk * fkz;
            double tkz = this.uxk * fky - this.uyk * fkx;
            tix += 2.0 * (this.qxyi * fixz + this.qyyi * fiyz + this.qyzi * fizz - this.qxzi * fixy - this.qyzi * fiyy - this.qzzi * fizy);
            tiy += 2.0 * (this.qxzi * fixx + this.qyzi * fiyx + this.qzzi * fizx - this.qxxi * fixz - this.qxyi * fiyz - this.qxzi * fizz);
            tiz += 2.0 * (this.qxxi * fixy + this.qxyi * fiyy + this.qxzi * fizy - this.qxyi * fixx - this.qyyi * fiyx - this.qyzi * fizx);
            tkx += 2.0 * (this.qxyk * fkxz + this.qyyk * fkyz + this.qyzk * fkzz - this.qxzk * fkxy - this.qyzk * fkyy - this.qzzk * fkzy);
            tky += 2.0 * (this.qxzk * fkxx + this.qyzk * fkyx + this.qzzk * fkzx - this.qxxk * fkxz - this.qxyk * fkyz - this.qxzk * fkzz);
            tkz += 2.0 * (this.qxxk * fkxy + this.qxyk * fkyy + this.qxzk * fkzy - this.qxyk * fkxx - this.qyyk * fkyx - this.qyzk * fkzx);
            this.trqxi += tix;
            this.trqyi += tiy;
            this.trqzi += tiz;
            double rx = tkx;
            double ry = tky;
            double rz = tkz;
            tkx = rx * this.transOp[0][0] + ry * this.transOp[1][0] + rz * this.transOp[2][0];
            tky = rx * this.transOp[0][1] + ry * this.transOp[1][1] + rz * this.transOp[2][1];
            tkz = rx * this.transOp[0][2] + ry * this.transOp[1][2] + rz * this.transOp[2][2];
            this.this$0.torque.add(this.threadID, k, tkx, tky, tkz);
        }
    }

    private class GKEnergyLoopQISIMD
    extends IntegerForLoop {
        private final DoubleVector zero;
        private final int simdN;
        private double[] r2;
        private double[] dx;
        private double[] dy;
        private double[] dz;
        private double[][] mpoleI;
        private double[][] mpoleK;
        private double[][] indI;
        private double[][] indK;
        private double[][] indICR;
        private double[][] indKCR;
        private double[] bornK;
        private final double[] dx_local;
        private final double[] gradI;
        private final double[] torqueI;
        private final double[] torqueK;
        private final double[] gI;
        private final double[] tI;
        private final double[] tK;
        private final DoubleVector[] dxVec;
        private DoubleVector rbiVec;
        PolarizableMultipoleSIMD mI;
        PolarizableMultipoleSIMD mK;
        QIFrameSIMD qiFrame;
        GKEnergyQISIMD gkEnergyQI;
        private double xi;
        private double yi;
        private double zi;
        private double dedxi;
        private double dedyi;
        private double dedzi;
        private double dborni;
        private double trqxi;
        private double trqyi;
        private double trqzi;
        private int count;
        private int iSymm;
        private int threadID;
        private final double[][] transOp;
        private double gkEnergy;
        private double gkPermanentEnergy;
        private double gkPolarizationEnergy;
        final /* synthetic */ GKEnergyRegion this$0;

        GKEnergyLoopQISIMD(GKEnergyRegion gKEnergyRegion) {
            GKEnergyRegion gKEnergyRegion2 = gKEnergyRegion;
            Objects.requireNonNull(gKEnergyRegion2);
            this.this$0 = gKEnergyRegion2;
            this.zero = DoubleVector.zero((VectorSpecies)DoubleVector.SPECIES_PREFERRED);
            this.simdN = this.zero.length();
            this.r2 = new double[this.simdN];
            this.dx = new double[this.simdN];
            this.dy = new double[this.simdN];
            this.dz = new double[this.simdN];
            this.mpoleI = new double[10][this.simdN];
            this.mpoleK = new double[10][this.simdN];
            this.indI = new double[3][this.simdN];
            this.indK = new double[3][this.simdN];
            this.indICR = new double[3][this.simdN];
            this.indKCR = new double[3][this.simdN];
            this.bornK = new double[this.simdN];
            this.gradI = new double[3];
            this.torqueI = new double[3];
            this.torqueK = new double[3];
            this.gI = new double[3];
            this.tI = new double[3];
            this.tK = new double[3];
            this.dxVec = new DoubleVector[3];
            this.mI = new PolarizableMultipoleSIMD();
            this.mK = new PolarizableMultipoleSIMD();
            this.qiFrame = new QIFrameSIMD();
            this.dx_local = new double[3];
            this.transOp = new double[3][3];
            logger.info("GK QI SIMD length: " + this.simdN);
        }

        public void start() {
            this.gkEnergy = 0.0;
            this.gkPermanentEnergy = 0.0;
            this.gkPolarizationEnergy = 0.0;
            this.count = 0;
            this.threadID = this.getThreadIndex();
            this.gkEnergyQI = new GKEnergyQISIMD(this.this$0.soluteDielectric, this.this$0.solventDielectric, this.this$0.gkc, this.this$0.gradient);
        }

        public void finish() {
            this.this$0.sharedInteractions.addAndGet(this.count);
            this.this$0.sharedGKEnergy.addAndGet(this.gkEnergy);
            this.this$0.sharedPermanentGKEnergy.addAndGet(this.gkPermanentEnergy);
            this.this$0.sharedPolarizationGKEnergy.addAndGet(this.gkPolarizationEnergy);
        }

        public void run(int lb, int ub) {
            double[] x = this.this$0.sXYZ[0][0];
            double[] y = this.this$0.sXYZ[0][1];
            double[] z = this.this$0.sXYZ[0][2];
            int nSymm = this.this$0.crystal.spaceGroup.symOps.size();
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            this.iSymm = 0;
            while (this.iSymm < nSymm) {
                SymOp symOp = (SymOp)symOps.get(this.iSymm);
                this.this$0.crystal.getTransformationOperator(symOp, this.transOp);
                for (int i = lb; i <= ub; ++i) {
                    int m;
                    if (!this.this$0.use[i]) continue;
                    this.dedxi = 0.0;
                    this.dedyi = 0.0;
                    this.dedzi = 0.0;
                    this.trqxi = 0.0;
                    this.trqyi = 0.0;
                    this.trqzi = 0.0;
                    this.dborni = 0.0;
                    this.xi = x[i];
                    this.yi = y[i];
                    this.zi = z[i];
                    this.rbiVec = DoubleVector.broadcast((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double)this.this$0.born[i]);
                    for (m = 0; m < 10; ++m) {
                        Arrays.fill(this.mpoleI[m], this.this$0.globalMultipole[0][i][m]);
                    }
                    for (m = 0; m < 3; ++m) {
                        Arrays.fill(this.indI[m], this.this$0.inducedDipole[0][i][m]);
                        Arrays.fill(this.indICR[m], this.this$0.inducedDipoleCR[0][i][m]);
                    }
                    int[] list = this.this$0.neighborLists[this.iSymm][i];
                    int n = list.length;
                    int slot = 0;
                    for (int k : list) {
                        if (this.load(k, slot)) {
                            ++slot;
                        }
                        if (slot == this.simdN) {
                            this.interactions();
                            slot = 0;
                            continue;
                        }
                        if (k != n - 1) continue;
                        this.clearAtomData(slot);
                        this.interactions();
                        slot = 0;
                    }
                    if (this.iSymm == 0) {
                        switch (this.this$0.nonPolarModel) {
                            case BORN_SOLV: 
                            case BORN_CAV_DISP: {
                                double r = this.this$0.baseRadius[i] + 0.09 + this.this$0.probe;
                                double ratio = (this.this$0.baseRadius[i] + 0.09) / this.this$0.born[i];
                                ratio *= ratio;
                                ratio *= ratio * ratio;
                                double saTerm = this.this$0.surfaceTension * r * r * ratio / 6.0;
                                this.gkEnergy += saTerm;
                                this.this$0.sharedBornGrad.sub(this.threadID, i, 6.0 * saTerm / this.this$0.born[i]);
                                break;
                            }
                        }
                    }
                    if (!this.this$0.gradient) continue;
                    this.this$0.grad.add(this.threadID, i, this.dedxi, this.dedyi, this.dedzi);
                    this.this$0.torque.add(this.threadID, i, this.trqxi, this.trqyi, this.trqzi);
                    this.this$0.sharedBornGrad.add(this.threadID, i, this.dborni);
                }
                ++this.iSymm;
            }
        }

        private void clearAtomData(int slot) {
            int m;
            Arrays.fill(this.r2, slot, this.simdN, 2.0);
            Arrays.fill(this.dx, slot, this.simdN, 0.0);
            Arrays.fill(this.dy, slot, this.simdN, 0.0);
            Arrays.fill(this.dz, slot, this.simdN, 2.0);
            for (m = 0; m < 10; ++m) {
                Arrays.fill(this.mpoleK[m], slot, this.simdN, 0.0);
            }
            for (m = 0; m < 3; ++m) {
                Arrays.fill(this.indK[m], slot, this.simdN, 0.0);
                Arrays.fill(this.indKCR[m], slot, this.simdN, 0.0);
            }
            Arrays.fill(this.bornK, slot, this.simdN, 2.0);
        }

        private boolean load(int k, int slot) {
            int m;
            if (!this.this$0.use[k]) {
                return false;
            }
            this.dx_local[0] = this.this$0.sXYZ[this.iSymm][0][k] - this.xi;
            this.dx_local[1] = this.this$0.sXYZ[this.iSymm][1][k] - this.yi;
            this.dx_local[2] = this.this$0.sXYZ[this.iSymm][2][k] - this.zi;
            double rSquared = this.this$0.crystal.image(this.dx_local);
            if (rSquared > this.this$0.cut2) {
                return false;
            }
            this.r2[slot] = rSquared;
            this.dx[slot] = this.dx_local[0];
            this.dy[slot] = this.dx_local[1];
            this.dz[slot] = this.dx_local[2];
            for (m = 0; m < 10; ++m) {
                this.mpoleK[m][slot] = this.this$0.globalMultipole[this.iSymm][k][m];
            }
            for (m = 0; m < 3; ++m) {
                this.indK[m][slot] = this.this$0.inducedDipole[this.iSymm][k][m];
                this.indKCR[m][slot] = this.this$0.inducedDipoleCR[this.iSymm][k][m];
            }
            this.bornK[slot] = this.this$0.born[k];
            return true;
        }

        private void interactions() {
            DoubleVector r2Vec = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])this.r2, (int)0);
            this.dxVec[0] = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])this.dx, (int)0);
            this.dxVec[1] = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])this.dy, (int)0);
            this.dxVec[2] = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])this.dz, (int)0);
            DoubleVector rbkVec = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])this.bornK, (int)0);
            this.mI.set(this.mpoleI, this.indI, this.indICR);
            this.mK.set(this.mpoleK, this.indK, this.indKCR);
            this.qiFrame.setAndRotate(this.dxVec, this.mI, this.mK);
            this.gkEnergyQI.initPotential(this.dxVec, r2Vec, this.rbiVec, rbkVec);
            double eik = this.this$0.electric * this.gkEnergyQI.multipoleEnergy(this.mI, this.mK).reduceLanes(VectorOperators.ADD);
            this.gkPermanentEnergy += eik;
            if (this.this$0.polarization != Polarization.NONE) {
                double ep = this.this$0.electric * this.gkEnergyQI.polarizationEnergy(this.mI, this.mK).reduceLanes(VectorOperators.ADD);
                this.gkPolarizationEnergy += ep;
                eik += ep;
            }
            this.gkEnergy += eik;
            ++this.count;
        }
    }
}

