/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.implicit.BornRadiiRegion;
import ffx.potential.nonbonded.implicit.BornTanhRescaling;
import ffx.potential.nonbonded.implicit.NeckIntegral;
import ffx.potential.utils.EnergyException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class BornGradRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(BornRadiiRegion.class.getName());
    private static final double PI4_3 = 4.1887902047863905;
    private static final double oneThird = 0.3333333333333333;
    private final BornCRLoop[] bornCRLoop;
    protected Atom[] atoms;
    private Crystal crystal;
    private double[][][] sXYZ;
    private int[][][] neighborLists;
    private double[] baseRadius;
    private double[] descreenRadius;
    private double[] overlapScale;
    private double[] neckScale;
    private double descreenOffset;
    private final boolean perfectHCTScale;
    private boolean[] use;
    private double cut2;
    private boolean nativeEnvironmentApproximation;
    private double[] born;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray sharedBornGrad;
    private final double factor = -FastMath.pow((double)Math.PI, (double)0.3333333333333333) * FastMath.pow((double)6.0, (double)0.6666666666666666) / 9.0;
    private double[] term;
    private final boolean neckCorrection;
    private final boolean tanhCorrection;
    private double[] unscaledBornIntegral;

    public BornGradRegion(int nt, boolean neckCorrection, boolean tanhCorrection, boolean perfectHCTScale) {
        this.bornCRLoop = new BornCRLoop[nt];
        for (int i = 0; i < nt; ++i) {
            this.bornCRLoop[i] = new BornCRLoop(this);
        }
        this.neckCorrection = neckCorrection;
        this.tanhCorrection = tanhCorrection;
        this.perfectHCTScale = perfectHCTScale;
    }

    public void executeWith(ParallelTeam parallelTeam) {
        this.sharedBornGrad.reduce(parallelTeam, 0, this.atoms.length - 1);
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Exception evaluating Born radii chain rule gradient.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void init(Atom[] atoms, Crystal crystal, double[][][] sXYZ, int[][][] neighborLists, double[] baseRadius, double[] descreenRadius, double[] overlapScale, double[] neckScale, double descreenOffset, double[] unscaledBornIntegral, boolean[] use, double cut2, boolean nativeEnvironmentApproximation, double[] born, AtomicDoubleArray3D grad, AtomicDoubleArray sharedBornGrad) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.sXYZ = sXYZ;
        this.neighborLists = neighborLists;
        this.baseRadius = baseRadius;
        this.descreenRadius = descreenRadius;
        this.overlapScale = overlapScale;
        this.neckScale = neckScale;
        this.descreenOffset = descreenOffset;
        this.unscaledBornIntegral = unscaledBornIntegral;
        this.use = use;
        this.cut2 = cut2;
        this.nativeEnvironmentApproximation = nativeEnvironmentApproximation;
        this.born = born;
        this.grad = grad;
        this.sharedBornGrad = sharedBornGrad;
    }

    public void start() {
        int nAtoms = this.atoms.length;
        if (this.term == null || this.term.length < nAtoms) {
            this.term = new double[nAtoms];
        }
        for (int i = 0; i < nAtoms; ++i) {
            double rbi = this.born[i];
            this.term[i] = 4.1887902047863905 / (rbi * rbi * rbi);
            this.term[i] = this.factor / FastMath.pow((double)this.term[i], (double)1.3333333333333333);
            if (!this.tanhCorrection) continue;
            this.term[i] = this.term[i] * BornTanhRescaling.tanhRescalingChainRule(this.unscaledBornIntegral[i], this.baseRadius[i]);
        }
    }

    public void run() {
        try {
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.bornCRLoop[this.getThreadIndex()]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing Born radii chain rule term in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class BornCRLoop
    extends IntegerForLoop {
        private final double[] dx_local;
        private int threadID;
        final /* synthetic */ BornGradRegion this$0;

        BornCRLoop(BornGradRegion bornGradRegion) {
            BornGradRegion bornGradRegion2 = bornGradRegion;
            Objects.requireNonNull(bornGradRegion2);
            this.this$0 = bornGradRegion2;
            this.dx_local = new double[3];
        }

        public void run(int lb, int ub) {
            double[] x = this.this$0.sXYZ[0][0];
            double[] y = this.this$0.sXYZ[0][1];
            double[] z = this.this$0.sXYZ[0][2];
            int nSymm = this.this$0.crystal.spaceGroup.symOps.size();
            for (int iSymOp = 0; iSymOp < nSymm; ++iSymOp) {
                SymOp symOp = (SymOp)this.this$0.crystal.spaceGroup.symOps.get(iSymOp);
                double[][] transOp = new double[3][3];
                double[][] xyz = this.this$0.sXYZ[iSymOp];
                this.this$0.crystal.getTransformationOperator(symOp, transOp);
                for (int i = lb; i <= ub; ++i) {
                    int[] list;
                    if (!this.this$0.nativeEnvironmentApproximation && !this.this$0.use[i]) continue;
                    double bornGrad = this.this$0.sharedBornGrad.get(i);
                    if (Double.isInfinite(bornGrad) || Double.isNaN(bornGrad)) {
                        throw new EnergyException(String.format(" %s\n Born radii CR %d %8.3f", this.this$0.atoms[i], i, bornGrad), true);
                    }
                    double integralStartI = FastMath.max((double)this.this$0.baseRadius[i], (double)this.this$0.descreenRadius[i]) + this.this$0.descreenOffset;
                    double descreenRi = this.this$0.descreenRadius[i];
                    double xi = x[i];
                    double yi = y[i];
                    double zi = z[i];
                    double rbi = this.this$0.born[i];
                    for (int k : list = this.this$0.neighborLists[iSymOp][i]) {
                        double dbr;
                        double de;
                        double r2;
                        if (!this.this$0.nativeEnvironmentApproximation && !this.this$0.use[k]) continue;
                        double integralStartK = FastMath.max((double)this.this$0.baseRadius[k], (double)this.this$0.descreenRadius[k]) + this.this$0.descreenOffset;
                        double descreenRk = this.this$0.descreenRadius[k];
                        double mixedNeckScale = 0.5 * (this.this$0.neckScale[i] + this.this$0.neckScale[k]);
                        if (k != i) {
                            this.dx_local[0] = xyz[0][k] - xi;
                            this.dx_local[1] = xyz[1][k] - yi;
                            this.dx_local[2] = xyz[2][k] - zi;
                            r2 = this.this$0.crystal.image(this.dx_local);
                            if (r2 > this.this$0.cut2) continue;
                            double xr = this.dx_local[0];
                            double yr = this.dx_local[1];
                            double zr = this.dx_local[2];
                            double r = FastMath.sqrt((double)r2);
                            double sk = this.this$0.overlapScale[k];
                            if (sk > 0.0 && rbi < 50.0 && descreenRk > 0.0) {
                                de = this.descreenDerivative(r, r2, integralStartI, descreenRk, sk);
                                if (this.this$0.neckCorrection) {
                                    de += this.neckDescreenDerivative(r, integralStartI, descreenRk, mixedNeckScale);
                                }
                                if (Double.isInfinite(de) || Double.isNaN(de)) {
                                    logger.warning(String.format(" Born radii chain rule term is unstable %d %d %16.8f", i, k, de));
                                }
                                dbr = this.this$0.term[i] * de / r;
                                de = dbr * this.this$0.sharedBornGrad.get(i);
                                this.incrementGradient(i, k, de, xr, yr, zr, transOp);
                            }
                            double rbk = this.this$0.born[k];
                            double si = this.this$0.overlapScale[i];
                            if (!(si > 0.0) || !(rbk < 50.0) || !(descreenRi > 0.0)) continue;
                            double de2 = this.descreenDerivative(r, r2, integralStartK, descreenRi, si);
                            if (this.this$0.neckCorrection) {
                                de2 += this.neckDescreenDerivative(r, integralStartK, descreenRi, mixedNeckScale);
                            }
                            if (Double.isInfinite(de2) || Double.isNaN(de2)) {
                                logger.warning(String.format(" Born radii chain rule term is unstable %d %d %16.8f", k, i, de2));
                            }
                            double dbr2 = this.this$0.term[k] * de2 / r;
                            de2 = dbr2 * this.this$0.sharedBornGrad.get(k);
                            this.incrementGradient(i, k, de2, xr, yr, zr, transOp);
                            continue;
                        }
                        if (iSymOp <= 0 || !(rbi < 50.0)) continue;
                        this.dx_local[0] = xyz[0][k] - xi;
                        this.dx_local[1] = xyz[1][k] - yi;
                        this.dx_local[2] = xyz[2][k] - zi;
                        r2 = this.this$0.crystal.image(this.dx_local);
                        double sk = this.this$0.overlapScale[k];
                        if (!(sk > 0.0) || !(r2 < this.this$0.cut2) || !(descreenRk > 0.0)) continue;
                        double xr = this.dx_local[0];
                        double yr = this.dx_local[1];
                        double zr = this.dx_local[2];
                        double r = FastMath.sqrt((double)r2);
                        de = this.descreenDerivative(r, r2, integralStartI, descreenRk, sk);
                        if (this.this$0.neckCorrection) {
                            de += this.neckDescreenDerivative(r, integralStartI, descreenRk, mixedNeckScale);
                        }
                        if (Double.isInfinite(de) || Double.isNaN(de)) {
                            logger.warning(String.format(" Born radii chain rule term is unstable %d %d %d %16.8f", iSymOp, i, k, de));
                        }
                        dbr = this.this$0.term[i] * de / r;
                        de = dbr * this.this$0.sharedBornGrad.get(i);
                        this.incrementGradient(i, k, de, xr, yr, zr, transOp);
                    }
                }
            }
        }

        public void start() {
            this.threadID = this.getThreadIndex();
        }

        private double neckDescreenDerivative(double r, double radius, double radiusK, double sneck) {
            double radiusWater = 1.4;
            if (r > radius + radiusK + 2.0 * radiusWater) {
                return 0.0;
            }
            double[] constants = NeckIntegral.getNeckConstants(radius, radiusK);
            double Aij = constants[0];
            double Bij = constants[1];
            double rMinusBij = r - Bij;
            double rMinusBij3 = rMinusBij * rMinusBij * rMinusBij;
            double rMinusBij4 = rMinusBij3 * rMinusBij;
            double radiiMinusr = radius + radiusK + 2.0 * radiusWater - r;
            double radiiMinusr3 = radiiMinusr * radiiMinusr * radiiMinusr;
            double radiiMinusr4 = radiiMinusr3 * radiiMinusr;
            return 16.755160819145562 * (sneck * Aij * rMinusBij3 * radiiMinusr4 - sneck * Aij * rMinusBij4 * radiiMinusr3);
        }

        private double descreenDerivative(double r, double r2, double radius, double radiusK, double hctScale) {
            if (this.this$0.perfectHCTScale) {
                return this.perfectHCTIntegralDerivative(r, r2, radius, radiusK, hctScale);
            }
            return this.integralDerivative(r, r2, radius, radiusK * hctScale);
        }

        private double integralDerivative(double r, double r2, double radius, double scaledRadius) {
            double de = 0.0;
            if (scaledRadius > 0.0 && radius < r + scaledRadius) {
                if (radius + r < scaledRadius) {
                    double uik = scaledRadius - r;
                    double uik2 = uik * uik;
                    double uik4 = uik2 * uik2;
                    de = Math.PI * -4 / uik4;
                }
                double sk2 = scaledRadius * scaledRadius;
                if (radius + r < scaledRadius) {
                    lik = scaledRadius - r;
                    lik2 = lik * lik;
                    lik4 = lik2 * lik2;
                    de += 0.7853981633974483 * (sk2 - 4.0 * scaledRadius * r + 17.0 * r2) / (r2 * lik4);
                } else if (r < radius + scaledRadius) {
                    lik = radius;
                    lik2 = lik * lik;
                    lik4 = lik2 * lik2;
                    de += 0.7853981633974483 * (2.0 * radius * radius - sk2 - r2) / (r2 * lik4);
                } else {
                    lik = r - scaledRadius;
                    lik2 = lik * lik;
                    lik4 = lik2 * lik2;
                    de += 0.7853981633974483 * (sk2 - 4.0 * scaledRadius * r + r2) / (r2 * lik4);
                }
                double uik = r + scaledRadius;
                double uik2 = uik * uik;
                double uik4 = uik2 * uik2;
                de -= 0.7853981633974483 * (sk2 + 4.0 * scaledRadius * r + r2) / (r2 * uik4);
            }
            return de;
        }

        private double perfectHCTIntegralDerivative(double r, double r2, double radius, double radiusK, double perfectHCT) {
            double de = 0.0;
            if (radiusK > 0.0 && radius < r + radiusK) {
                if (radius + r < radiusK) {
                    double uik = radiusK - r;
                    double uik2 = uik * uik;
                    double uik4 = uik2 * uik2;
                    de = Math.PI * -4 / uik4;
                }
                double sk2 = radiusK * radiusK;
                if (radius + r < radiusK) {
                    lik = radiusK - r;
                    lik2 = lik * lik;
                    lik4 = lik2 * lik2;
                    de += 0.7853981633974483 * (sk2 - 4.0 * radiusK * r + 17.0 * r2) / (r2 * lik4);
                } else if (r < radius + radiusK) {
                    lik = radius;
                    lik2 = lik * lik;
                    lik4 = lik2 * lik2;
                    de += 0.7853981633974483 * (2.0 * radius * radius - sk2 - r2) / (r2 * lik4);
                } else {
                    lik = r - radiusK;
                    lik2 = lik * lik;
                    lik4 = lik2 * lik2;
                    de += 0.7853981633974483 * (sk2 - 4.0 * radiusK * r + r2) / (r2 * lik4);
                }
                double uik = r + radiusK;
                double uik2 = uik * uik;
                double uik4 = uik2 * uik2;
                de -= 0.7853981633974483 * (sk2 + 4.0 * radiusK * r + r2) / (r2 * uik4);
            }
            return perfectHCT * de;
        }

        private void incrementGradient(int i, int k, double dE, double xr, double yr, double zr, double[][] transOp) {
            double dedx = dE * xr;
            double dedy = dE * yr;
            double dedz = dE * zr;
            this.this$0.grad.add(this.threadID, i, dedx, dedy, dedz);
            double dedxk = dedx * transOp[0][0] + dedy * transOp[1][0] + dedz * transOp[2][0];
            double dedyk = dedx * transOp[0][1] + dedy * transOp[1][1] + dedz * transOp[2][1];
            double dedzk = dedx * transOp[0][2] + dedy * transOp[1][2] + dedz * transOp[2][2];
            this.this$0.grad.sub(this.threadID, k, dedxk, dedyk, dedzk);
        }
    }
}

