/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import ffx.crystal.Crystal;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.SpatialDensityLoop;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class SpatialDensityRegion
extends ParallelRegion {
    protected static final Logger logger = Logger.getLogger(SpatialDensityRegion.class.getName());
    public final int nThreads;
    protected final int nSymm;
    public int[] actualCount;
    public int nAtoms;
    protected int nA;
    protected int nB;
    protected int nC;
    protected int actualWork;
    protected double[][][] coordinates;
    protected boolean[][] select;
    protected Crystal crystal;
    protected SpatialDensityLoop[] spatialDensityLoop;
    int[] actualA;
    int[] actualB;
    int[] actualC;
    int[][] cellList;
    int[][] cellCount;
    int[][] cellStart;
    private int basisSize;
    private int minWork;
    private int nAB;
    private int nCells;
    private int nWork;
    private int[][] cellIndex;
    private int[] workA;
    private int[] workB;
    private int[] workC;
    private int[][] cellOffset;
    private double[] xf;
    private double[] yf;
    private double[] zf;
    private int gridSize;
    private double[] grid = null;
    private DoubleBuffer gridBuffer;
    private double initValue = 0.0;
    private GridInitLoop gridInitLoop;

    public SpatialDensityRegion(int gX, int gY, int gZ, double[] grid, int basisSize, int nSymm, int minWork, int threadCount, Crystal crystal, Atom[] atoms, double[][][] coordinates) {
        this(gX, gY, gZ, basisSize, nSymm, minWork, threadCount, crystal, atoms, coordinates);
        this.grid = grid;
        if (grid != null) {
            this.gridBuffer = DoubleBuffer.wrap(grid);
        }
    }

    private SpatialDensityRegion(int gX, int gY, int gZ, int basisSize, int nSymm, int minWork, int threadCount, Crystal crystal, Atom[] atoms, double[][][] coordinates) {
        this.coordinates = coordinates;
        this.nSymm = nSymm;
        this.nAtoms = atoms.length;
        this.nThreads = threadCount;
        this.basisSize = basisSize;
        this.minWork = minWork;
        this.gridInitLoop = new GridInitLoop(this);
        this.setCrystal(crystal.getUnitCell(), gX, gY, gZ);
    }

    public void assignAtomsToCells() {
        this.selectAtoms();
        for (int iSymm = 0; iSymm < this.nSymm; ++iSymm) {
            int i1;
            int index;
            int i;
            int[] cellIndexs = this.cellIndex[iSymm];
            int[] cellCounts = this.cellCount[iSymm];
            int[] cellStarts = this.cellStart[iSymm];
            int[] cellLists = this.cellList[iSymm];
            int[] cellOffsets = this.cellOffset[iSymm];
            boolean[] selected = this.select[iSymm];
            for (int i2 = 0; i2 < this.nCells; ++i2) {
                cellCounts[i2] = 0;
            }
            double[][] xyz = this.coordinates[iSymm];
            double[] x = xyz[0];
            double[] y = xyz[1];
            double[] z = xyz[2];
            this.crystal.toFractionalCoordinates(this.nAtoms, x, y, z, this.xf, this.yf, this.zf);
            for (i = 0; i < this.nAtoms; ++i) {
                if (!selected[i]) continue;
                cellIndexs[i] = index = this.getCellIndex(i);
                int n = index;
                cellCounts[n] = cellCounts[n] + 1;
            }
            cellStarts[0] = 0;
            for (i = 1; i < this.nCells; ++i) {
                i1 = i - 1;
                cellStarts[i] = cellStarts[i1] + cellCounts[i1];
            }
            for (i = 0; i < this.nAtoms; ++i) {
                if (!selected[i]) continue;
                int n = index = cellIndexs[i];
                int n2 = cellStarts[n];
                cellStarts[n] = n2 + 1;
                cellLists[n2] = i;
            }
            cellStarts[0] = 0;
            for (i = 1; i < this.nCells; ++i) {
                i1 = i - 1;
                cellStarts[i] = cellStarts[i1] + cellCounts[i1];
            }
        }
        this.actualWork = 0;
        for (int icell = 0; icell < this.nWork; ++icell) {
            int ia = this.workA[icell];
            int ib = this.workB[icell];
            int ic = this.workC[icell];
            int ii = this.count(ia, ib, ic);
            if (this.nC > 1) {
                ii += this.count(ia, ib, ic + 1);
                if (this.nB > 1) {
                    ii += this.count(ia, ib + 1, ic);
                    ii += this.count(ia, ib + 1, ic + 1);
                    if (this.nA > 1) {
                        ii += this.count(ia + 1, ib, ic);
                        ii += this.count(ia + 1, ib, ic + 1);
                        ii += this.count(ia + 1, ib + 1, ic);
                        ii += this.count(ia + 1, ib + 1, ic + 1);
                    }
                }
            }
            if (ii <= 0) continue;
            this.actualA[this.actualWork] = ia;
            this.actualB[this.actualWork] = ib;
            this.actualC[this.actualWork] = ic;
            this.actualCount[this.actualWork++] = ii;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format(" Empty chunks: %d out of %d.", this.nWork - this.actualWork, this.nWork));
        }
    }

    private int getCellIndex(int i) {
        double xu;
        double yu = this.yf[i];
        double zu = this.zf[i];
        for (xu = this.xf[i]; xu >= 1.0; xu -= 1.0) {
        }
        while (xu < 0.0) {
            xu += 1.0;
        }
        while (yu >= 1.0) {
            yu -= 1.0;
        }
        while (yu < 0.0) {
            yu += 1.0;
        }
        while (zu >= 1.0) {
            zu -= 1.0;
        }
        while (zu < 0.0) {
            zu += 1.0;
        }
        int a = (int)FastMath.floor((double)(xu * (double)this.nA));
        int b = (int)FastMath.floor((double)(yu * (double)this.nB));
        int c = (int)FastMath.floor((double)(zu * (double)this.nC));
        if (a >= this.nA) {
            a = this.nA - 1;
        }
        if (b >= this.nB) {
            b = this.nB - 1;
        }
        if (c >= this.nC) {
            c = this.nC - 1;
        }
        int index = a + b * this.nA + c * this.nAB;
        return index;
    }

    public double[] getGrid() {
        return this.grid;
    }

    public int getNsymm() {
        return this.nSymm;
    }

    public int index(int ia, int ib, int ic) {
        return ia + ib * this.nA + ic * this.nAB;
    }

    public void run() {
        int ti = this.getThreadIndex();
        int actualWork1 = this.actualWork - 1;
        SpatialDensityLoop loop = this.spatialDensityLoop[ti];
        loop.setNsymm(this.nSymm);
        try {
            this.execute(0, this.gridSize - 1, this.gridInitLoop);
            this.execute(0, actualWork1, loop.setOctant(0));
            if (this.nC > 1) {
                this.execute(0, actualWork1, loop.setOctant(1));
                if (this.nB > 1) {
                    this.execute(0, actualWork1, loop.setOctant(2));
                    this.execute(0, actualWork1, loop.setOctant(3));
                    if (this.nA > 1) {
                        this.execute(0, actualWork1, loop.setOctant(4));
                        this.execute(0, actualWork1, loop.setOctant(5));
                        this.execute(0, actualWork1, loop.setOctant(6));
                        this.execute(0, actualWork1, loop.setOctant(7));
                    }
                }
            }
        }
        catch (Exception e) {
            String message = " Exception in SpatialDensityRegion.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void selectAtoms() {
    }

    public void setAtoms(Atom[] atoms) {
        this.nAtoms = atoms.length;
        if (this.select == null || this.select.length < this.nSymm || this.select[0].length < this.nAtoms) {
            this.select = new boolean[this.nSymm][this.nAtoms];
            for (int i = 0; i < this.nSymm; ++i) {
                Arrays.fill(this.select[i], true);
            }
            this.cellList = new int[this.nSymm][this.nAtoms];
            this.cellIndex = new int[this.nSymm][this.nAtoms];
            this.cellOffset = new int[this.nSymm][this.nAtoms];
        }
        if (this.xf == null || this.xf.length < this.nAtoms) {
            this.xf = new double[this.nAtoms];
            this.yf = new double[this.nAtoms];
            this.zf = new double[this.nAtoms];
        }
    }

    public final void setCrystal(Crystal crystal, int gX, int gY, int gZ) {
        if (this.crystal != null && this.crystal.equals((Object)crystal.getUnitCell())) {
            return;
        }
        this.crystal = crystal.getUnitCell();
        if (this.xf == null || this.xf.length < this.nAtoms) {
            this.xf = new double[this.nAtoms];
            this.yf = new double[this.nAtoms];
            this.zf = new double[this.nAtoms];
        }
        this.gridSize = gX * gY * gZ * 2;
        int nX = gX / this.basisSize;
        int nY = gY / this.basisSize;
        int nZ = gZ / this.basisSize;
        if (this.nThreads > 1 && nZ > 1) {
            if (nZ % 2 != 0) {
                --nZ;
            }
            this.nC = nZ;
            int div = 2;
            int currentWork = this.nC / div / this.nThreads;
            if (currentWork >= this.minWork || nY < 2) {
                this.nA = 1;
                this.nB = 1;
                while (currentWork >= 2 * this.minWork) {
                    this.nC -= 2;
                    currentWork = this.nC / div / this.nThreads;
                }
            } else {
                if (nY % 2 != 0) {
                    --nY;
                }
                this.nB = nY;
                div = 4;
                currentWork = this.nB * this.nC / div / this.nThreads;
                if (currentWork >= this.minWork || nX < 2) {
                    this.nA = 1;
                    while (currentWork >= 2 * this.minWork) {
                        this.nB -= 2;
                        currentWork = this.nB * this.nC / div / this.nThreads;
                    }
                } else {
                    if (nX % 2 != 0) {
                        --nX;
                    }
                    this.nA = nX;
                    div = 8;
                    currentWork = this.nA * this.nB * this.nC / div / this.nThreads;
                    while (currentWork >= 2 * this.minWork) {
                        this.nA -= 2;
                        currentWork = this.nA * this.nB * this.nC / div / this.nThreads;
                    }
                }
            }
            this.nAB = this.nA * this.nB;
            this.nCells = this.nAB * this.nC;
            this.nWork = this.nCells / div;
        } else {
            this.nA = 1;
            this.nB = 1;
            this.nC = 1;
            this.nAB = 1;
            this.nCells = 1;
            this.nWork = 1;
        }
        logger.fine(String.format("   Spatial cells:                 (%3d,%3d,%3d)", this.nA, this.nB, this.nC));
        logger.fine(String.format("   Spatial work:                           %4d", this.nWork));
        if (this.workA == null || this.workA.length < this.nWork) {
            this.workA = new int[this.nWork];
            this.workB = new int[this.nWork];
            this.workC = new int[this.nWork];
            this.actualA = new int[this.nWork];
            this.actualB = new int[this.nWork];
            this.actualC = new int[this.nWork];
            this.actualCount = new int[this.nWork];
            int index = 0;
            for (int h = 0; h < this.nA; h += 2) {
                for (int k = 0; k < this.nB; k += 2) {
                    for (int l = 0; l < this.nC; l += 2) {
                        this.workA[index] = h;
                        this.workB[index] = k;
                        this.workC[index++] = l;
                    }
                }
            }
        }
        if (this.select == null || this.select.length < this.nSymm || this.select[0].length < this.nAtoms) {
            this.select = new boolean[this.nSymm][this.nAtoms];
            for (int i = 0; i < this.nSymm; ++i) {
                Arrays.fill(this.select[i], true);
            }
            this.cellList = new int[this.nSymm][this.nAtoms];
            this.cellIndex = new int[this.nSymm][this.nAtoms];
            this.cellOffset = new int[this.nSymm][this.nAtoms];
        }
        if (this.cellStart == null || this.cellStart.length < this.nSymm || this.cellStart[0].length < this.nCells) {
            this.cellStart = new int[this.nSymm][this.nCells];
            this.cellCount = new int[this.nSymm][this.nCells];
        }
    }

    public void setDensityLoop(SpatialDensityLoop[] loops) {
        this.spatialDensityLoop = loops;
    }

    public void setInitValue(double initValue) {
        this.initValue = initValue;
    }

    void setGridBuffer(DoubleBuffer grid) {
        this.gridBuffer = grid;
    }

    private int count(int ia, int ib, int ic) {
        int count = 0;
        for (int iSymm = 0; iSymm < this.nSymm; ++iSymm) {
            int index = this.index(ia, ib, ic);
            int start = this.cellStart[iSymm][index];
            int stop = start + this.cellCount[iSymm][index];
            count += stop - start;
        }
        return count;
    }

    private class GridInitLoop
    extends IntegerForLoop {
        private final IntegerSchedule schedule;
        final /* synthetic */ SpatialDensityRegion this$0;

        private GridInitLoop(SpatialDensityRegion spatialDensityRegion) {
            SpatialDensityRegion spatialDensityRegion2 = spatialDensityRegion;
            Objects.requireNonNull(spatialDensityRegion2);
            this.this$0 = spatialDensityRegion2;
            this.schedule = IntegerSchedule.fixed();
        }

        public void run(int lb, int ub) {
            if (this.this$0.gridBuffer != null) {
                for (int i = lb; i <= ub; ++i) {
                    this.this$0.gridBuffer.put(i, this.this$0.initValue);
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.schedule;
        }
    }
}

