/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.util.Range;
import ffx.crystal.Crystal;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.multipole.MultipoleUtilities;
import ffx.potential.Platform;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.NeighborList;
import ffx.potential.nonbonded.ReciprocalSpace;
import ffx.potential.nonbonded.pme.AlchemicalParameters;
import ffx.potential.nonbonded.pme.DirectRegion;
import ffx.potential.nonbonded.pme.EwaldParameters;
import ffx.potential.nonbonded.pme.ExpandInducedDipolesRegion;
import ffx.potential.nonbonded.pme.InducedDipoleFieldReduceRegion;
import ffx.potential.nonbonded.pme.InducedDipoleFieldRegion;
import ffx.potential.nonbonded.pme.InitializationRegion;
import ffx.potential.nonbonded.pme.LambdaMode;
import ffx.potential.nonbonded.pme.OPTRegion;
import ffx.potential.nonbonded.pme.PCGSolver;
import ffx.potential.nonbonded.pme.PMETimings;
import ffx.potential.nonbonded.pme.PermanentFieldRegion;
import ffx.potential.nonbonded.pme.Polarization;
import ffx.potential.nonbonded.pme.RealSpaceEnergyRegion;
import ffx.potential.nonbonded.pme.RealSpaceNeighborParameters;
import ffx.potential.nonbonded.pme.ReciprocalEnergyRegion;
import ffx.potential.nonbonded.pme.ReduceRegion;
import ffx.potential.nonbonded.pme.SCFAlgorithm;
import ffx.potential.nonbonded.pme.SCFPredictor;
import ffx.potential.nonbonded.pme.SCFPredictorParameters;
import ffx.potential.nonbonded.pme.SORRegion;
import ffx.potential.nonbonded.pme.ScaleParameters;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.PolarizeType;
import ffx.potential.utils.EnergyException;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

public class ParticleMeshEwald
implements LambdaInterface {
    private static final Logger logger = Logger.getLogger(ParticleMeshEwald.class.getName());
    private static final int tensorCount = MultipoleUtilities.tensorCount((int)3);
    private final boolean lambdaTerm;
    private final boolean nnTerm;
    private final boolean reciprocalSpaceTerm;
    private final ForceField forceField;
    private static final double DEFAULT_POLAR_EPS = 1.0E-6;
    @FFXProperty(name="polar-eps", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0e-6", description="Sets the convergence criterion applied during computation of self-consistent induced dipoles.\nThe calculation is deemed to have converged when the rms change in Debyes in\nthe induced dipole at all polarizable sites is less than the value specified with this property.\nThe default value in the absence of the keyword is 1.0e-6 Debyes.\n")
    private final double poleps;
    private final boolean sorFallback;
    private final double sorFallBackPolarSOR = 0.65;
    private final boolean directFallback;
    private final SCFPredictorParameters scfPredictorParameters;
    private final EwaldParameters ewaldParameters;
    private final ScaleParameters scaleParameters;
    private final AlchemicalParameters alchemicalParameters;
    private final RealSpaceNeighborParameters realSpaceNeighborParameters;
    private final PMETimings pmeTimings;
    private final int maxThreads;
    private final ParallelTeam parallelTeam;
    private final ParallelTeam sectionTeam;
    private final ParallelTeam realSpaceTeam;
    private final ParallelTeam fftTeam;
    private final NeighborList neighborList;
    private final InitializationRegion initializationRegion;
    private final PermanentFieldRegion permanentFieldRegion;
    private final InducedDipoleFieldRegion inducedDipoleFieldRegion;
    private final InducedDipoleFieldReduceRegion inducedDipoleFieldReduceRegion;
    private final ExpandInducedDipolesRegion expandInducedDipolesRegion;
    private final DirectRegion directRegion;
    private final SORRegion sorRegion;
    private final OPTRegion optRegion;
    private final PCGSolver pcgSolver;
    private final ReciprocalSpace reciprocalSpace;
    private final ReciprocalEnergyRegion reciprocalEnergyRegion;
    private final RealSpaceEnergyRegion realSpaceEnergyRegion;
    private final ReduceRegion reduceRegion;
    private final GeneralizedKirkwood generalizedKirkwood;
    public Polarization polarization;
    public double[][][] coordinates;
    public int[][][] neighborLists;
    public double[][][] globalMultipole;
    public double[][][] fractionalMultipole;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    public double[][] directDipole;
    public double[][] directDipoleCR;
    public double[][] directField;
    public double[][] directFieldCR;
    public double[][][] vacuumInducedDipole;
    public double[][][] vacuumInducedDipoleCR;
    public double[][] vacuumDirectDipole;
    public double[][] vacuumDirectDipoleCR;
    @FFXProperty(name="electric", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="332.063713", description="Specifies a value for the so-called \"electric constant\" allowing conversion unit of electrostatic\npotential energy values from electrons^2/Angstrom to kcal/mol. Internally, FFX stores a default value\nfor this constant as 332.063713 based on CODATA reference values. Since different force fields are\nintended for use with slightly different values, this keyword allows overriding the default value.\n")
    public double electric;
    public double soluteDielectric;
    protected Atom[] atoms;
    protected int nAtoms;
    protected int[][] ip11;
    protected int[][] ip12;
    protected int[][] ip13;
    protected double totalMultipoleEnergy;
    protected double permanentMultipoleEnergy;
    protected double permanentRealSpaceEnergy;
    protected double permanentSelfEnergy;
    protected double permanentReciprocalEnergy;
    protected double permanentChargeCorrectionEnergy;
    protected double polarizationEnergy;
    protected double inducedRealSpaceEnergy;
    protected double inducedSelfEnergy;
    protected double inducedReciprocalEnergy;
    protected SCFAlgorithm scfAlgorithm;
    private final SharedDouble shareddEdLambda;
    private final SharedDouble sharedd2EdLambda2;
    private final ForceField.ELEC_FORM elecForm;
    private Crystal crystal;
    private int nSymm;
    private boolean generalizedKirkwoodTerm;
    private boolean gradient = false;
    private int interactions;
    private int gkInteractions;
    private double solvationEnergy;
    private LambdaMode lambdaMode = LambdaMode.OFF;
    private double lambda = 1.0;
    private double[][] localMultipole;
    private MultipoleType.MultipoleFrameDefinition[] frame;
    private int[][] axisAtom;
    private double[] ipdamp;
    private double[] thole;
    private double[] polarizability;
    private int[][] mask12;
    private int[][] mask13;
    private int[][] mask14;
    private int[][] mask15;
    private boolean[] isSoft;
    private int[] molecule;
    private boolean[] use;
    private IntegerSchedule permanentSchedule;
    private double[][] cartesianMultipolePhi;
    private double[][] fracMultipolePhi;
    private double[][] cartesianInducedDipolePhi;
    private double[][] cartesianInducedDipolePhiCR;
    private double[][] fractionalInducedDipolePhi;
    private double[][] fractionalInducedDipolePhiCR;
    private double[][] cartesianVacuumDipolePhi;
    private double[][] cartesianVacuumDipolePhiCR;
    private double[][] fractionalVacuumDipolePhi;
    private double[][] fractionalVacuumDipolePhiCR;
    private AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray3D lambdaGrad;
    private AtomicDoubleArray3D lambdaTorque;
    private boolean esvTerm = false;
    private ExtendedSystem extendedSystem = null;
    double[] perAtomTitrationESV = null;
    double[][][] dMultipoledTirationESV = null;
    double[][][] dMultipoledTautomerESV = null;
    double[] dPolardTitrationESV = null;
    double[] dPolardTautomerESV = null;
    LambdaFactors[] lambdaFactors = null;
    public final LambdaFactors LambdaDefaults = new LambdaFactors(this);

    public ParticleMeshEwald(Atom[] atoms, int[] molecule, ForceField forceField, Crystal crystal, NeighborList neighborList, ForceField.ELEC_FORM elecForm, double ewaldCutoff, double gkCutoff, ParallelTeam parallelTeam) {
        boolean concurrent;
        boolean polarizationTerm;
        SCFPredictor scfPredictor;
        this.atoms = atoms;
        this.molecule = molecule;
        this.forceField = forceField;
        this.crystal = crystal;
        this.parallelTeam = parallelTeam;
        this.neighborList = neighborList;
        this.elecForm = elecForm;
        this.neighborLists = neighborList.getNeighborList();
        this.permanentSchedule = neighborList.getPairwiseSchedule();
        this.nAtoms = atoms.length;
        this.nSymm = crystal.spaceGroup.getNumberOfSymOps();
        this.maxThreads = parallelTeam.getThreadCount();
        this.electric = forceField.getDouble("ELECTRIC", 332.0637133);
        this.soluteDielectric = forceField.getDouble("SOLUTE_DIELECTRIC", 1.0);
        if (this.soluteDielectric > 1.0) {
            this.electric /= this.soluteDielectric;
        } else {
            this.soluteDielectric = 1.0;
        }
        this.poleps = forceField.getDouble("POLAR_EPS", 1.0E-6);
        this.lambdaTerm = forceField.getBoolean("ELEC_LAMBDATERM", forceField.getBoolean("LAMBDATERM", false));
        this.nnTerm = forceField.getBoolean("NNTERM", false);
        if (this.nnTerm && this.lambdaTerm) {
            logger.severe(" Use a neural network potential with alchemical simulations is not yet supported.");
        }
        double aewald = forceField.getDouble("EWALD_ALPHA", 0.545);
        this.ewaldParameters = new EwaldParameters(ewaldCutoff, aewald);
        this.scaleParameters = new ScaleParameters(elecForm, forceField);
        this.reciprocalSpaceTerm = forceField.getBoolean("RECIPTERM", true);
        try {
            String predictor = forceField.getString("SCF_PREDICTOR", "NONE");
            predictor = predictor.replaceAll("-", "_").toUpperCase();
            scfPredictor = SCFPredictor.valueOf(predictor);
        }
        catch (Exception e) {
            scfPredictor = SCFPredictor.NONE;
        }
        this.scfPredictorParameters = new SCFPredictorParameters(scfPredictor, this.nAtoms);
        if (scfPredictor != SCFPredictor.NONE) {
            this.scfPredictorParameters.init(forceField);
        }
        String algorithm = forceField.getString("SCF_ALGORITHM", "CG");
        try {
            algorithm = algorithm.replaceAll("-", "_").toUpperCase();
            this.scfAlgorithm = SCFAlgorithm.valueOf(algorithm);
        }
        catch (Exception e) {
            this.scfAlgorithm = SCFAlgorithm.CG;
        }
        this.sorFallback = forceField.getBoolean("SOR_SCF_FALLBACK", true);
        this.directFallback = forceField.getBoolean("DIRECT_SCF_FALLBACK", !this.sorFallback);
        String value = forceField.getString("ARRAY_REDUCTION", "MULTI");
        try {
            this.atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.valueOf((String)ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            this.atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI;
            logger.info(String.format(" Unrecognized ARRAY-REDUCTION %s; defaulting to %s", value, this.atomicDoubleArrayImpl));
        }
        logger.fine(String.format("  PME using %s arrays.", this.atomicDoubleArrayImpl.toString()));
        if (!this.scfAlgorithm.isSupported(Platform.FFX)) {
            logger.fine(String.format(" SCF algorithm %s is not supported by FFX reference implementation; falling back to CG!", new Object[]{this.scfAlgorithm}));
            this.scfAlgorithm = SCFAlgorithm.CG;
        }
        this.pcgSolver = new PCGSolver(this.maxThreads, this.poleps, forceField, this.nAtoms);
        this.alchemicalParameters = new AlchemicalParameters(forceField, this.lambdaTerm, this.nnTerm, this.polarization);
        if (this.nnTerm) {
            this.initNN();
        }
        String polar = forceField.getString("POLARIZATION", "MUTUAL");
        if (elecForm == ForceField.ELEC_FORM.FIXED_CHARGE) {
            polar = "NONE";
        }
        this.polarization = !(polarizationTerm = forceField.getBoolean("POLARIZETERM", true)) || polar.equalsIgnoreCase("NONE") ? Polarization.NONE : (polar.equalsIgnoreCase("DIRECT") ? Polarization.DIRECT : Polarization.MUTUAL);
        if (this.lambdaTerm) {
            this.shareddEdLambda = new SharedDouble();
            this.sharedd2EdLambda2 = new SharedDouble();
        } else {
            this.shareddEdLambda = null;
            this.sharedd2EdLambda2 = null;
            this.lambdaGrad = null;
            this.lambdaTorque = null;
        }
        this.directRegion = new DirectRegion(this.maxThreads);
        this.sorRegion = new SORRegion(this.maxThreads, forceField);
        this.optRegion = new OPTRegion(this.maxThreads);
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n Electrostatics\n");
            sb.append(String.format("   Polarization:                       %8s\n", this.polarization.toString()));
            if (this.polarization == Polarization.MUTUAL) {
                sb.append(String.format("    SCF Convergence Criteria:         %8.3e\n", this.poleps));
                sb.append(String.format("    SCF Predictor:                     %8s\n", new Object[]{this.scfPredictorParameters.scfPredictor}));
                sb.append(String.format("    SCF Algorithm:                     %8s\n", new Object[]{this.scfAlgorithm}));
                if (this.scfAlgorithm == SCFAlgorithm.SOR) {
                    sb.append(String.format("    SOR Parameter:                     %8.3f\n", this.sorRegion.getSOR()));
                } else {
                    sb.append(String.format("    CG Preconditioner Cut-Off:         %8.3f\n", this.pcgSolver.getPreconditionerCutoff()));
                    sb.append(String.format("    CG Preconditioner Ewald Coeff.:    %8.3f\n", this.pcgSolver.getPreconditionerEwald()));
                    sb.append(String.format("    CG Preconditioner Scale:           %8.3f\n", this.pcgSolver.getPreconditionerScale()));
                    sb.append(String.format("    CG Preconditioner Mode:     %15s\n", this.pcgSolver.getPreconditionerMode()));
                }
            }
            if (this.ewaldParameters.aewald > 0.0) {
                sb.append("   Particle-mesh Ewald\n");
                sb.append(String.format("    Ewald Coefficient:                 %8.3f\n", this.ewaldParameters.aewald));
                sb.append(String.format("    Particle Cut-Off:                  %8.3f (A)", this.ewaldParameters.off));
            } else if (this.ewaldParameters.off != Double.POSITIVE_INFINITY) {
                sb.append(String.format("    Electrostatics Cut-Off:            %8.3f (A)\n", this.ewaldParameters.off));
            } else {
                sb.append("    Electrostatics Cut-Off:                NONE\n");
            }
            logger.info(sb.toString());
        }
        int realThreads = 1;
        try {
            realThreads = forceField.getInteger("PME_REAL_THREADS");
            if (realThreads >= this.maxThreads || realThreads < 1) {
                throw new Exception("pme-real-threads must be < ffx.nt and greater than 0");
            }
            concurrent = true;
        }
        catch (Exception e) {
            concurrent = false;
        }
        if (concurrent) {
            int sectionThreads = 2;
            int realSpaceThreads = realThreads;
            int reciprocalThreads = this.maxThreads - realThreads;
            this.sectionTeam = new ParallelTeam(sectionThreads);
            this.realSpaceTeam = new ParallelTeam(realSpaceThreads);
            this.fftTeam = new ParallelTeam(reciprocalThreads);
        } else {
            int sectionThreads = 1;
            this.sectionTeam = new ParallelTeam(sectionThreads);
            this.realSpaceTeam = parallelTeam;
            this.fftTeam = parallelTeam;
        }
        this.realSpaceNeighborParameters = new RealSpaceNeighborParameters(this.maxThreads);
        this.initializationRegion = new InitializationRegion(this, this.maxThreads, forceField);
        this.expandInducedDipolesRegion = new ExpandInducedDipolesRegion(this.maxThreads);
        this.initAtomArrays();
        if (this.ewaldParameters.aewald > 0.0 && this.reciprocalSpaceTerm) {
            this.reciprocalSpace = new ReciprocalSpace(this, crystal.getUnitCell(), forceField, atoms, this.ewaldParameters.aewald, this.fftTeam, parallelTeam);
            this.reciprocalEnergyRegion = new ReciprocalEnergyRegion(this.maxThreads, this.ewaldParameters.aewald, this.electric);
        } else {
            this.reciprocalSpace = null;
            this.reciprocalEnergyRegion = null;
        }
        this.permanentFieldRegion = new PermanentFieldRegion(this.realSpaceTeam, forceField, this.lambdaTerm);
        this.inducedDipoleFieldRegion = new InducedDipoleFieldRegion(this.realSpaceTeam, forceField, this.lambdaTerm);
        this.inducedDipoleFieldReduceRegion = new InducedDipoleFieldReduceRegion(this.maxThreads);
        this.realSpaceEnergyRegion = new RealSpaceEnergyRegion(elecForm, this.maxThreads, forceField, this.lambdaTerm, this.electric);
        this.reduceRegion = new ReduceRegion(this.maxThreads, forceField);
        this.pmeTimings = new PMETimings(this.maxThreads);
        if (this.lambdaTerm) {
            logger.info(this.alchemicalParameters.toString());
        }
        this.generalizedKirkwoodTerm = forceField.getBoolean("GKTERM", false);
        this.generalizedKirkwood = this.generalizedKirkwoodTerm || this.alchemicalParameters.doLigandGKElec ? new GeneralizedKirkwood(forceField, atoms, this, crystal, parallelTeam, gkCutoff) : null;
    }

    public ForceField.ELEC_FORM getElecForm() {
        return this.elecForm;
    }

    public boolean getLambdaTerm() {
        return this.lambdaTerm;
    }

    public AlchemicalParameters getAlchemicalParameters() {
        return this.alchemicalParameters;
    }

    public void computeInduceDipoleField() {
        this.expandInducedDipoles();
        if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
            this.reciprocalSpace.splineInducedDipoles(this.inducedDipole, this.inducedDipoleCR, this.use);
        }
        this.field.reset(this.parallelTeam);
        this.fieldCR.reset(this.parallelTeam);
        this.inducedDipoleFieldRegion.init(this.atoms, this.crystal, this.use, this.molecule, this.ipdamp, this.thole, this.coordinates, this.realSpaceNeighborParameters, this.inducedDipole, this.inducedDipoleCR, this.reciprocalSpaceTerm, this.reciprocalSpace, this.lambdaMode, this.ewaldParameters, this.field, this.fieldCR, this.pmeTimings);
        this.inducedDipoleFieldRegion.executeWith(this.sectionTeam);
        if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
            this.reciprocalSpace.computeInducedPhi(this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.fractionalInducedDipolePhi, this.fractionalInducedDipolePhiCR);
        }
        if (this.generalizedKirkwoodTerm) {
            this.pmeTimings.gkEnergyTotal = -System.nanoTime();
            this.generalizedKirkwood.computeInducedGKField();
            this.pmeTimings.gkEnergyTotal += System.nanoTime();
            logger.fine(String.format(" Computed GK induced field %8.3f (sec)", (double)this.pmeTimings.gkEnergyTotal * 1.0E-9));
        }
        this.inducedDipoleFieldReduceRegion.init(this.atoms, this.inducedDipole, this.inducedDipoleCR, this.generalizedKirkwoodTerm, this.generalizedKirkwood, this.ewaldParameters, this.soluteDielectric, this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.field, this.fieldCR);
        this.inducedDipoleFieldReduceRegion.executeWith(this.parallelTeam);
    }

    public void destroy() {
        if (this.fftTeam != null) {
            try {
                this.fftTeam.shutdown();
            }
            catch (Exception ex) {
                logger.warning(" Exception in shutting down fftTeam");
            }
        }
        if (this.sectionTeam != null) {
            try {
                this.sectionTeam.shutdown();
            }
            catch (Exception ex) {
                logger.warning(" Exception in shutting down sectionTeam");
            }
        }
        if (this.realSpaceTeam != null) {
            try {
                this.realSpaceTeam.shutdown();
            }
            catch (Exception ex) {
                logger.warning(" Exception in shutting down realSpaceTeam");
            }
        }
    }

    public double energy(boolean gradient, boolean print) {
        this.gradient = gradient;
        this.totalMultipoleEnergy = 0.0;
        this.permanentMultipoleEnergy = 0.0;
        this.permanentRealSpaceEnergy = 0.0;
        this.permanentSelfEnergy = 0.0;
        this.permanentReciprocalEnergy = 0.0;
        this.permanentChargeCorrectionEnergy = 0.0;
        this.polarizationEnergy = 0.0;
        this.inducedRealSpaceEnergy = 0.0;
        this.inducedSelfEnergy = 0.0;
        this.inducedReciprocalEnergy = 0.0;
        this.solvationEnergy = 0.0;
        this.interactions = 0;
        this.gkInteractions = 0;
        this.pmeTimings.init();
        this.permanentFieldRegion.initTimings();
        if (this.reciprocalSpace != null) {
            this.reciprocalSpace.initTimings();
        }
        if (this.lambdaTerm) {
            this.shareddEdLambda.set(0.0);
            this.sharedd2EdLambda2.set(0.0);
        }
        if (this.esvTerm) {
            this.extendedSystem.initEsvPermElec();
            this.extendedSystem.initEsvIndElec();
        }
        this.alchemicalParameters.doPermanentRealSpace = true;
        this.alchemicalParameters.permanentScale = 1.0;
        this.alchemicalParameters.doPolarization = true;
        this.alchemicalParameters.polarizationScale = 1.0;
        this.initializationRegion.init(this.lambdaTerm, this.alchemicalParameters, this.extendedSystem, this.atoms, this.coordinates, this.crystal, this.frame, this.axisAtom, this.globalMultipole, this.dMultipoledTirationESV, this.dMultipoledTautomerESV, this.polarizability, this.dPolardTitrationESV, this.dPolardTautomerESV, this.thole, this.ipdamp, this.use, this.neighborLists, this.realSpaceNeighborParameters.realSpaceLists, this.grad, this.torque, this.lambdaGrad, this.lambdaTorque);
        this.initializationRegion.executeWith(this.parallelTeam);
        if (this.generalizedKirkwoodTerm || this.alchemicalParameters.doLigandGKElec) {
            this.generalizedKirkwood.init();
        }
        if (!this.lambdaTerm) {
            this.lambdaMode = LambdaMode.OFF;
            double energy = this.computeEnergy(print);
            if (this.nnTerm) {
                this.lambdaMode = LambdaMode.VAPOR;
                double temp = energy;
                energy = this.nnElec();
                logger.fine(String.format(" Vacuum energy: %20.8f", energy - temp));
            }
        } else {
            this.lambdaMode = LambdaMode.CONDENSED;
            double energy = this.condensedEnergy();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(" Condensed energy: %20.8f", energy));
            }
            if (this.alchemicalParameters.mode == AlchemicalParameters.AlchemicalMode.OST) {
                this.lambdaMode = LambdaMode.CONDENSED_NO_LIGAND;
                double temp = energy;
                energy = this.condensedNoLigandSCF();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Condensed no ligand energy: %20.8f", energy - temp));
                }
                if (this.alchemicalParameters.doLigandVaporElec) {
                    this.lambdaMode = LambdaMode.VAPOR;
                    temp = energy;
                    energy = this.ligandElec();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format(" Vacuum energy: %20.8f", energy - temp));
                    }
                }
            }
        }
        if (gradient || this.lambdaTerm) {
            this.reduceRegion.init(this.lambdaTerm, gradient, this.atoms, this.coordinates, this.frame, this.axisAtom, this.grad, this.torque, this.lambdaGrad, this.lambdaTorque);
            this.reduceRegion.executeWith(this.parallelTeam);
        }
        if (logger.isLoggable(Level.FINE)) {
            this.pmeTimings.printRealSpaceTimings(this.maxThreads, this.permanentFieldRegion, this.realSpaceEnergyRegion);
            if (this.ewaldParameters.aewald > 0.0 && this.reciprocalSpaceTerm) {
                this.reciprocalSpace.printTimings();
            }
        }
        return this.permanentMultipoleEnergy + this.polarizationEnergy;
    }

    public void expandInducedDipoles() {
        if (this.nSymm > 1) {
            this.expandInducedDipolesRegion.init(this.atoms, this.crystal, this.inducedDipole, this.inducedDipoleCR);
            this.expandInducedDipolesRegion.executeWith(this.parallelTeam);
        }
    }

    public int[][] getAxisAtoms() {
        return this.axisAtom;
    }

    public double getCavitationEnergy() {
        return this.generalizedKirkwood.getCavitationEnergy();
    }

    public double[][][] getCoordinates() {
        return this.coordinates;
    }

    public double getDispersionEnergy() {
        return this.generalizedKirkwood.getDispersionEnergy();
    }

    public double getEwaldCoefficient() {
        return this.ewaldParameters.aewald;
    }

    public double getEwaldCutoff() {
        return this.ewaldParameters.off;
    }

    public GeneralizedKirkwood getGK() {
        return this.generalizedKirkwood;
    }

    public double getGKEnergy() {
        return this.generalizedKirkwood.getGeneralizedKirkwoordEnergy();
    }

    public int getGKInteractions() {
        return this.gkInteractions;
    }

    public int getInteractions() {
        return this.interactions;
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        assert (lambda >= 0.0 && lambda <= 1.0);
        if (!this.lambdaTerm) {
            return;
        }
        this.lambda = lambda;
        this.initSoftCore();
        this.alchemicalParameters.update(lambda);
        if (this.generalizedKirkwoodTerm) {
            this.generalizedKirkwood.setLambda(this.alchemicalParameters.polLambda);
            this.generalizedKirkwood.setLambdaFunction(this.alchemicalParameters.lPowPol, this.alchemicalParameters.dlPowPol, this.alchemicalParameters.d2lPowPol);
        }
    }

    public double getPermanentEnergy() {
        return this.permanentMultipoleEnergy;
    }

    public double getIndRealEnergy() {
        return this.inducedRealSpaceEnergy;
    }

    public double getIndRecipEnergy() {
        return this.inducedReciprocalEnergy;
    }

    public double getIndSelfEnergy() {
        return this.inducedSelfEnergy;
    }

    public double getPermSelfEnergy() {
        return this.permanentSelfEnergy;
    }

    public double getPermRealEnergy() {
        return this.permanentRealSpaceEnergy;
    }

    public double getPermRecipEnergy() {
        return this.permanentReciprocalEnergy;
    }

    public double getPermanentChargeCorrectionEnergy() {
        return this.permanentChargeCorrectionEnergy;
    }

    public double getPolarEps() {
        return this.poleps;
    }

    public int[][] getPolarization11() {
        return this.ip11;
    }

    public int[][] getPolarization12() {
        return this.ip12;
    }

    public int[][] getPolarization13() {
        return this.ip13;
    }

    public double getPolarizationEnergy() {
        return this.polarizationEnergy;
    }

    public Polarization getPolarizationType() {
        return this.polarization;
    }

    public ReciprocalSpace getReciprocalSpace() {
        return this.reciprocalSpace;
    }

    public double getScale14() {
        return this.scaleParameters.m14scale;
    }

    public double getSolvationEnergy() {
        return this.solvationEnergy;
    }

    public MultipoleType getMultipoleType(int i) {
        Atom atom = this.atoms[i];
        MultipoleType multipoleType = atom.getMultipoleType();
        if (this.esvTerm && this.extendedSystem.isTitrating(i)) {
            double[] multipole = multipoleType.getMultipole();
            double[] esvMultipole = new double[10];
            System.arraycopy(multipole, 0, esvMultipole, 0, multipole.length);
            double titrationLambda = this.extendedSystem.getTitrationLambda(i);
            double tautomerLambda = this.extendedSystem.getTautomerLambda(i);
            esvMultipole = this.extendedSystem.getTitrationUtils().getMultipole(atom, titrationLambda, tautomerLambda, esvMultipole);
            multipoleType = new MultipoleType(multipoleType, esvMultipole);
        }
        return multipoleType;
    }

    public PolarizeType getPolarizeType(int i) {
        Atom atom = this.atoms[i];
        PolarizeType polarizeType = atom.getPolarizeType();
        if (polarizeType != null && this.esvTerm && this.extendedSystem.isTitrating(i) && (this.extendedSystem.isTitratingHydrogen(i) || this.extendedSystem.isTitratingHeavy(i))) {
            double titrationLambda = this.extendedSystem.getTitrationLambda(i);
            double tautomerLambda = this.extendedSystem.getTautomerLambda(i);
            double esvPolarizability = this.extendedSystem.getTitrationUtils().getPolarizability(atom, titrationLambda, tautomerLambda, polarizeType.polarizability);
            polarizeType = new PolarizeType(polarizeType, esvPolarizability);
        }
        return polarizeType;
    }

    @Override
    public double getd2EdL2() {
        if (this.sharedd2EdLambda2 == null || !this.lambdaTerm) {
            return 0.0;
        }
        double d2EdL2 = this.sharedd2EdLambda2.get();
        if (this.generalizedKirkwoodTerm || this.alchemicalParameters.doLigandGKElec) {
            d2EdL2 += this.generalizedKirkwood.getd2EdL2();
        }
        return d2EdL2;
    }

    @Override
    public double getdEdL() {
        if (this.shareddEdLambda == null || !this.lambdaTerm) {
            return 0.0;
        }
        double dEdL = this.shareddEdLambda.get();
        if (this.generalizedKirkwoodTerm || this.alchemicalParameters.doLigandGKElec) {
            dEdL += this.generalizedKirkwood.getdEdL();
        }
        return dEdL;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
        if (this.lambdaGrad == null || !this.lambdaTerm) {
            return;
        }
        int index = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            int n = index++;
            gradient[n] = gradient[n] + this.lambdaGrad.getX(i);
            int n2 = index++;
            gradient[n2] = gradient[n2] + this.lambdaGrad.getY(i);
            int n3 = index++;
            gradient[n3] = gradient[n3] + this.lambdaGrad.getZ(i);
        }
    }

    public void setAtoms(Atom[] atoms, int[] molecule) {
        if (this.lambdaTerm && atoms.length != this.nAtoms) {
            logger.severe(" Changing the number of atoms is not compatible with use of Lambda.");
        }
        this.atoms = atoms;
        this.molecule = molecule;
        this.nAtoms = atoms.length;
        this.initAtomArrays();
        if (this.reciprocalSpace != null) {
            this.reciprocalSpace.setAtoms(atoms);
        }
        if (this.generalizedKirkwood != null) {
            this.generalizedKirkwood.setAtoms(atoms);
        }
    }

    public void setCrystal(Crystal crystal) {
        int nSymmNew = crystal.spaceGroup.getNumberOfSymOps();
        if (this.nSymm < nSymmNew) {
            this.coordinates = new double[nSymmNew][3][this.nAtoms];
            this.globalMultipole = new double[nSymmNew][this.nAtoms][10];
            this.fractionalMultipole = new double[nSymmNew][this.nAtoms][10];
            this.inducedDipole = new double[nSymmNew][this.nAtoms][3];
            this.inducedDipoleCR = new double[nSymmNew][this.nAtoms][3];
            if (this.generalizedKirkwood != null) {
                this.generalizedKirkwood.setAtoms(this.atoms);
            }
            this.realSpaceNeighborParameters.allocate(this.nAtoms, nSymmNew);
            this.pcgSolver.allocateLists(nSymmNew, this.nAtoms);
        }
        this.nSymm = nSymmNew;
        this.neighborLists = this.neighborList.getNeighborList();
        this.crystal = crystal;
        if (this.reciprocalSpace != null) {
            this.reciprocalSpace.setCrystal(crystal.getUnitCell());
        }
    }

    private void initAtomArrays() {
        int i;
        if (this.localMultipole == null || this.localMultipole.length < this.nAtoms) {
            this.localMultipole = new double[this.nAtoms][10];
            this.frame = new MultipoleType.MultipoleFrameDefinition[this.nAtoms];
            this.axisAtom = new int[this.nAtoms][];
            this.cartesianMultipolePhi = new double[this.nAtoms][tensorCount];
            this.fracMultipolePhi = new double[this.nAtoms][tensorCount];
            this.directDipole = new double[this.nAtoms][3];
            this.directDipoleCR = new double[this.nAtoms][3];
            this.directField = new double[this.nAtoms][3];
            this.directFieldCR = new double[this.nAtoms][3];
            this.vacuumDirectDipole = new double[this.nAtoms][3];
            this.vacuumDirectDipoleCR = new double[this.nAtoms][3];
            if (this.optRegion != null) {
                int optOrder = this.optRegion.optOrder;
                this.optRegion.optDipole = new double[optOrder + 1][this.nAtoms][3];
                this.optRegion.optDipoleCR = new double[optOrder + 1][this.nAtoms][3];
            }
            this.cartesianInducedDipolePhi = new double[this.nAtoms][tensorCount];
            this.cartesianInducedDipolePhiCR = new double[this.nAtoms][tensorCount];
            this.fractionalInducedDipolePhi = new double[this.nAtoms][tensorCount];
            this.fractionalInducedDipolePhiCR = new double[this.nAtoms][tensorCount];
            this.cartesianVacuumDipolePhi = new double[this.nAtoms][tensorCount];
            this.cartesianVacuumDipolePhiCR = new double[this.nAtoms][tensorCount];
            this.fractionalVacuumDipolePhi = new double[this.nAtoms][tensorCount];
            this.fractionalVacuumDipolePhiCR = new double[this.nAtoms][tensorCount];
            this.mask12 = new int[this.nAtoms][];
            this.mask13 = new int[this.nAtoms][];
            this.mask14 = new int[this.nAtoms][];
            this.mask15 = new int[this.nAtoms][];
            this.ip11 = new int[this.nAtoms][];
            this.ip12 = new int[this.nAtoms][];
            this.ip13 = new int[this.nAtoms][];
            this.thole = new double[this.nAtoms];
            this.ipdamp = new double[this.nAtoms];
            this.polarizability = new double[this.nAtoms];
            if (this.scfAlgorithm == SCFAlgorithm.CG) {
                this.pcgSolver.allocateVectors(this.nAtoms);
            }
            this.pcgSolver.allocateLists(this.nSymm, this.nAtoms);
            if (this.scfPredictorParameters.scfPredictor != SCFPredictor.NONE) {
                int predictorOrder = this.scfPredictorParameters.predictorOrder;
                if (this.lambdaTerm) {
                    this.scfPredictorParameters.predictorInducedDipole = new double[3][predictorOrder][this.nAtoms][3];
                    this.scfPredictorParameters.predictorInducedDipoleCR = new double[3][predictorOrder][this.nAtoms][3];
                } else {
                    this.scfPredictorParameters.predictorInducedDipole = new double[1][predictorOrder][this.nAtoms][3];
                    this.scfPredictorParameters.predictorInducedDipoleCR = new double[1][predictorOrder][this.nAtoms][3];
                }
            }
            this.grad = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.maxThreads);
            this.torque = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.maxThreads);
            this.field = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.maxThreads);
            this.fieldCR = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.maxThreads);
            this.lambdaGrad = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.maxThreads);
            this.lambdaTorque = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.maxThreads);
            this.isSoft = new boolean[this.nAtoms];
            this.use = new boolean[this.nAtoms];
            this.coordinates = new double[this.nSymm][3][this.nAtoms];
            this.globalMultipole = new double[this.nSymm][this.nAtoms][10];
            this.fractionalMultipole = new double[this.nSymm][this.nAtoms][10];
            this.inducedDipole = new double[this.nSymm][this.nAtoms][3];
            this.inducedDipoleCR = new double[this.nSymm][this.nAtoms][3];
            this.vacuumInducedDipole = new double[this.nSymm][this.nAtoms][3];
            this.vacuumInducedDipoleCR = new double[this.nSymm][this.nAtoms][3];
            this.realSpaceNeighborParameters.allocate(this.nAtoms, this.nSymm);
            this.lambdaFactors = new LambdaFactors[this.maxThreads];
            for (i = 0; i < this.maxThreads; ++i) {
                this.lambdaFactors[i] = this.lambdaTerm ? new LambdaFactorsOST(this) : this.LambdaDefaults;
            }
        }
        Arrays.fill(this.isSoft, false);
        Arrays.fill(this.use, true);
        this.assignMultipoles();
        if (this.elecForm == ForceField.ELEC_FORM.PAM) {
            this.assignPolarizationGroups();
        }
        for (i = 0; i < this.nAtoms; ++i) {
            Object a132;
            Atom ai = this.atoms[i];
            if (this.elecForm == ForceField.ELEC_FORM.PAM) {
                PolarizeType polarizeType = ai.getPolarizeType();
                int index = ai.getIndex() - 1;
                this.thole[index] = polarizeType.thole;
                this.ipdamp[index] = polarizeType.pdamp;
                this.ipdamp[index] = !(this.ipdamp[index] > 0.0) ? Double.POSITIVE_INFINITY : 1.0 / this.ipdamp[index];
                this.polarizability[index] = polarizeType.polarizability;
            }
            List<Atom> n12 = ai.get12List();
            this.mask12[i] = new int[n12.size()];
            int j = 0;
            for (Atom atom : n12) {
                this.mask12[i][j++] = atom.getIndex() - 1;
            }
            List<Atom> n13 = ai.get13List();
            this.mask13[i] = new int[n13.size()];
            j = 0;
            for (Object a132 : n13) {
                this.mask13[i][j++] = ((Atom)a132).getIndex() - 1;
            }
            List<Atom> list = ai.get14List();
            this.mask14[i] = new int[list.size()];
            j = 0;
            a132 = list.iterator();
            while (a132.hasNext()) {
                Atom a14 = (Atom)a132.next();
                this.mask14[i][j++] = a14.getIndex() - 1;
            }
            List<Atom> n15 = ai.get15List();
            this.mask15[i] = new int[n15.size()];
            j = 0;
            for (Atom a15 : n15) {
                this.mask15[i][j++] = a15.getIndex() - 1;
            }
        }
    }

    private void initSoftCore() {
        boolean rebuild = false;
        StringBuilder sb = new StringBuilder("\n Softcore Atoms:\n");
        int count = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom ai = this.atoms[i];
            boolean soft = ai.applyLambda();
            if (soft != this.isSoft[i]) {
                rebuild = true;
            }
            this.isSoft[i] = soft;
            if (!soft) continue;
            ++count;
            sb.append(ai).append("\n");
        }
        if (this.alchemicalParameters.doLigandVaporElec && this.alchemicalParameters.vaporCrystal == null) {
            rebuild = true;
        }
        if (!rebuild) {
            return;
        }
        if (count > 0 && logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Softcore atom count: %d", count));
            logger.fine(sb.toString());
        }
        if (this.alchemicalParameters.doLigandVaporElec) {
            double vacuumOff = this.getVacuumOff();
            this.alchemicalParameters.vaporCrystal = new Crystal(3.0 * vacuumOff, 3.0 * vacuumOff, 3.0 * vacuumOff, 90.0, 90.0, 90.0, "P1");
            this.alchemicalParameters.vaporCrystal.setAperiodic(true);
            NeighborList vacuumNeighborList = new NeighborList(this.alchemicalParameters.vaporCrystal, this.atoms, vacuumOff, 2.0, this.parallelTeam);
            vacuumNeighborList.setIntermolecular(false);
            this.alchemicalParameters.vaporLists = new int[1][this.nAtoms][];
            double[][] coords = new double[1][this.nAtoms * 3];
            for (int i = 0; i < this.nAtoms; ++i) {
                coords[0][i * 3] = this.atoms[i].getX();
                coords[0][i * 3 + 1] = this.atoms[i].getY();
                coords[0][i * 3 + 2] = this.atoms[i].getZ();
            }
            boolean print = logger.isLoggable(Level.FINE);
            vacuumNeighborList.buildList(coords, this.alchemicalParameters.vaporLists, this.isSoft, true, print);
            this.alchemicalParameters.vaporEwaldSchedule = this.alchemicalParameters.vaporPermanentSchedule = vacuumNeighborList.getPairwiseSchedule();
            this.alchemicalParameters.vacuumRanges = new Range[this.maxThreads];
            try {
                vacuumNeighborList.destroy();
            }
            catch (Exception ex) {
                logger.warning(" Exception in destroying vacuumNeighborList");
            }
        } else {
            this.alchemicalParameters.vaporCrystal = null;
            this.alchemicalParameters.vaporLists = null;
            this.alchemicalParameters.vaporPermanentSchedule = null;
            this.alchemicalParameters.vaporEwaldSchedule = null;
            this.alchemicalParameters.vacuumRanges = null;
        }
    }

    private double getVacuumOff() {
        double maxr = 10.0;
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom ai = this.atoms[i];
            if (!ai.applyLambda()) continue;
            for (int j = i + 1; j < this.nAtoms; ++j) {
                Atom aj = this.atoms[j];
                if (!aj.applyLambda()) continue;
                double dx = ai.getX() - aj.getX();
                double dy = ai.getY() - aj.getY();
                double dz = ai.getZ() - aj.getZ();
                double r = FastMath.sqrt((double)(dx * dx + dy * dy + dz * dz));
                maxr = FastMath.max((double)r, (double)maxr);
            }
        }
        double vacuumOff = 2.0 * maxr;
        return vacuumOff;
    }

    private void initNN() {
        StringBuilder sb = new StringBuilder("\n NN Atoms:\n");
        boolean[] nnAtoms = new boolean[this.nAtoms];
        int count = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom ai = this.atoms[i];
            nnAtoms[i] = ai.isNeuralNetwork();
            if (!nnAtoms[i]) continue;
            ++count;
            sb.append(ai).append("\n");
        }
        if (count > 0 && logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Neural network atom count: %d", count));
            logger.fine(sb.toString());
        }
        if (this.alchemicalParameters.doLigandVaporElec) {
            this.alchemicalParameters.vaporCrystal = new Crystal(10.0, 10.0, 10.0, 90.0, 90.0, 90.0, "P1");
            this.alchemicalParameters.vaporCrystal.setAperiodic(true);
            NeighborList vacuumNeighborList = new NeighborList(this.alchemicalParameters.vaporCrystal, this.atoms, Double.POSITIVE_INFINITY, 2.0, this.parallelTeam);
            vacuumNeighborList.setIntermolecular(false);
            this.alchemicalParameters.vaporLists = new int[1][this.nAtoms][];
            double[][] coords = new double[1][this.nAtoms * 3];
            for (int i = 0; i < this.nAtoms; ++i) {
                coords[0][i * 3] = this.atoms[i].getX();
                coords[0][i * 3 + 1] = this.atoms[i].getY();
                coords[0][i * 3 + 2] = this.atoms[i].getZ();
            }
            boolean print = logger.isLoggable(Level.FINE);
            vacuumNeighborList.buildList(coords, this.alchemicalParameters.vaporLists, nnAtoms, true, print);
            this.alchemicalParameters.vaporEwaldSchedule = this.alchemicalParameters.vaporPermanentSchedule = vacuumNeighborList.getPairwiseSchedule();
            this.alchemicalParameters.vacuumRanges = new Range[this.maxThreads];
            vacuumNeighborList.setDisableUpdates(this.forceField.getBoolean("DISABLE_NEIGHBOR_UPDATES", false));
        } else {
            this.alchemicalParameters.vaporCrystal = null;
            this.alchemicalParameters.vaporLists = null;
            this.alchemicalParameters.vaporPermanentSchedule = null;
            this.alchemicalParameters.vaporEwaldSchedule = null;
            this.alchemicalParameters.vacuumRanges = null;
        }
    }

    private double condensedEnergy() {
        if (this.alchemicalParameters.mode == AlchemicalParameters.AlchemicalMode.SCALE) {
            this.alchemicalParameters.polarizationScale = 1.0;
            this.alchemicalParameters.doPolarization = true;
        } else if (this.lambda < this.alchemicalParameters.polLambdaStart) {
            this.alchemicalParameters.polarizationScale = 0.0;
            this.alchemicalParameters.doPolarization = false;
        } else if (this.lambda <= this.alchemicalParameters.polLambdaEnd) {
            this.alchemicalParameters.polarizationScale = this.alchemicalParameters.lPowPol;
            this.alchemicalParameters.doPolarization = true;
        } else {
            this.alchemicalParameters.polarizationScale = 1.0;
            this.alchemicalParameters.doPolarization = true;
        }
        if (this.alchemicalParameters.mode == AlchemicalParameters.AlchemicalMode.SCALE) {
            this.alchemicalParameters.doPermanentRealSpace = true;
            this.alchemicalParameters.permanentScale = 1.0;
            this.alchemicalParameters.dEdLSign = 1.0;
        } else {
            this.alchemicalParameters.doPermanentRealSpace = true;
            this.alchemicalParameters.permanentScale = this.alchemicalParameters.lPowPerm;
            this.alchemicalParameters.dEdLSign = 1.0;
        }
        return this.computeEnergy(false);
    }

    private double condensedNoLigandSCF() {
        double energy;
        boolean skip = true;
        for (int i = 0; i < this.nAtoms; ++i) {
            if (this.atoms[i].applyLambda()) {
                this.use[i] = false;
                continue;
            }
            this.use[i] = true;
            skip = false;
        }
        this.alchemicalParameters.doPermanentRealSpace = false;
        this.alchemicalParameters.permanentScale = 1.0 - this.alchemicalParameters.lPowPerm;
        this.alchemicalParameters.dEdLSign = -1.0;
        if (this.lambda <= this.alchemicalParameters.polLambdaEnd && this.alchemicalParameters.doNoLigandCondensedSCF) {
            this.alchemicalParameters.doPolarization = true;
            this.alchemicalParameters.polarizationScale = 1.0 - this.alchemicalParameters.lPowPol;
        } else {
            this.alchemicalParameters.doPolarization = false;
            this.alchemicalParameters.polarizationScale = 0.0;
        }
        boolean gkBack = this.generalizedKirkwoodTerm;
        this.generalizedKirkwoodTerm = false;
        if (skip) {
            energy = this.permanentMultipoleEnergy + this.polarizationEnergy + this.solvationEnergy;
        } else {
            energy = this.computeEnergy(false);
            Arrays.fill(this.use, true);
        }
        this.generalizedKirkwoodTerm = gkBack;
        return energy;
    }

    private double ligandElec() {
        for (int i = 0; i < this.nAtoms; ++i) {
            this.use[i] = this.atoms[i].applyLambda();
        }
        this.alchemicalParameters.doPermanentRealSpace = true;
        this.alchemicalParameters.permanentScale = 1.0 - this.alchemicalParameters.lPowPerm;
        this.alchemicalParameters.dEdLSign = -1.0;
        double lAlphaBack = this.alchemicalParameters.lAlpha;
        double dlAlphaBack = this.alchemicalParameters.dlAlpha;
        double d2lAlphaBack = this.alchemicalParameters.d2lAlpha;
        this.alchemicalParameters.lAlpha = 0.0;
        this.alchemicalParameters.dlAlpha = 0.0;
        this.alchemicalParameters.d2lAlpha = 0.0;
        if (this.lambda <= this.alchemicalParameters.polLambdaEnd) {
            this.alchemicalParameters.doPolarization = true;
            this.alchemicalParameters.polarizationScale = 1.0 - this.alchemicalParameters.lPowPol;
        } else {
            this.alchemicalParameters.doPolarization = false;
            this.alchemicalParameters.polarizationScale = 0.0;
        }
        double offBack = this.ewaldParameters.off;
        double aewaldBack = this.ewaldParameters.aewald;
        this.ewaldParameters.setEwaldParameters(Double.MAX_VALUE, 0.0);
        IntegerSchedule permanentScheduleBack = this.permanentSchedule;
        IntegerSchedule ewaldScheduleBack = this.realSpaceNeighborParameters.realSpaceSchedule;
        Range[] rangesBack = this.realSpaceNeighborParameters.realSpaceRanges;
        this.permanentSchedule = this.alchemicalParameters.vaporPermanentSchedule;
        this.realSpaceNeighborParameters.realSpaceSchedule = this.alchemicalParameters.vaporEwaldSchedule;
        this.realSpaceNeighborParameters.realSpaceRanges = this.alchemicalParameters.vacuumRanges;
        Crystal crystalBack = this.crystal;
        int nSymmBack = this.nSymm;
        int[][][] listsBack = this.neighborLists;
        this.neighborLists = this.alchemicalParameters.vaporLists;
        this.crystal = this.alchemicalParameters.vaporCrystal;
        this.nSymm = 1;
        boolean gkBack = this.generalizedKirkwoodTerm;
        SCFAlgorithm scfBack = this.scfAlgorithm;
        this.scfAlgorithm = SCFAlgorithm.SOR;
        if (this.alchemicalParameters.doLigandGKElec) {
            this.generalizedKirkwoodTerm = true;
            this.generalizedKirkwood.setNeighborList(this.alchemicalParameters.vaporLists);
            this.generalizedKirkwood.setLambda(this.lambda);
            this.generalizedKirkwood.setCutoff(this.ewaldParameters.off);
            this.generalizedKirkwood.setCrystal(this.alchemicalParameters.vaporCrystal);
            this.generalizedKirkwood.setLambdaFunction(this.alchemicalParameters.polarizationScale, this.alchemicalParameters.dEdLSign * this.alchemicalParameters.dlPowPol, this.alchemicalParameters.dEdLSign * this.alchemicalParameters.d2lPowPol);
        } else {
            this.generalizedKirkwoodTerm = false;
        }
        double energy = this.computeEnergy(false);
        this.ewaldParameters.setEwaldParameters(offBack, aewaldBack);
        this.neighborLists = listsBack;
        this.crystal = crystalBack;
        this.nSymm = nSymmBack;
        this.permanentSchedule = permanentScheduleBack;
        this.realSpaceNeighborParameters.realSpaceSchedule = ewaldScheduleBack;
        this.realSpaceNeighborParameters.realSpaceRanges = rangesBack;
        this.alchemicalParameters.lAlpha = lAlphaBack;
        this.alchemicalParameters.dlAlpha = dlAlphaBack;
        this.alchemicalParameters.d2lAlpha = d2lAlphaBack;
        this.generalizedKirkwoodTerm = gkBack;
        this.scfAlgorithm = scfBack;
        Arrays.fill(this.use, true);
        return energy;
    }

    private double nnElec() {
        for (int i = 0; i < this.nAtoms; ++i) {
            this.use[i] = this.atoms[i].isNeuralNetwork();
        }
        this.alchemicalParameters.doPermanentRealSpace = true;
        this.alchemicalParameters.permanentScale = -1.0;
        this.alchemicalParameters.dEdLSign = 1.0;
        double lAlphaBack = this.alchemicalParameters.lAlpha;
        double dlAlphaBack = this.alchemicalParameters.dlAlpha;
        double d2lAlphaBack = this.alchemicalParameters.d2lAlpha;
        this.alchemicalParameters.lAlpha = 0.0;
        this.alchemicalParameters.dlAlpha = 0.0;
        this.alchemicalParameters.d2lAlpha = 0.0;
        this.alchemicalParameters.doPolarization = true;
        this.alchemicalParameters.polarizationScale = -1.0;
        double offBack = this.ewaldParameters.off;
        double aewaldBack = this.ewaldParameters.aewald;
        this.ewaldParameters.setEwaldParameters(Double.POSITIVE_INFINITY, 0.0);
        IntegerSchedule permanentScheduleBack = this.permanentSchedule;
        IntegerSchedule ewaldScheduleBack = this.realSpaceNeighborParameters.realSpaceSchedule;
        Range[] rangesBack = this.realSpaceNeighborParameters.realSpaceRanges;
        this.permanentSchedule = this.alchemicalParameters.vaporPermanentSchedule;
        this.realSpaceNeighborParameters.realSpaceSchedule = this.alchemicalParameters.vaporEwaldSchedule;
        this.realSpaceNeighborParameters.realSpaceRanges = this.alchemicalParameters.vacuumRanges;
        Crystal crystalBack = this.crystal;
        int nSymmBack = this.nSymm;
        int[][][] listsBack = this.neighborLists;
        this.neighborLists = this.alchemicalParameters.vaporLists;
        this.crystal = this.alchemicalParameters.vaporCrystal;
        this.nSymm = 1;
        boolean gkBack = this.generalizedKirkwoodTerm;
        SCFAlgorithm scfBack = this.scfAlgorithm;
        this.scfAlgorithm = SCFAlgorithm.SOR;
        this.generalizedKirkwoodTerm = false;
        double energy = this.computeEnergy(false);
        this.ewaldParameters.setEwaldParameters(offBack, aewaldBack);
        this.neighborLists = listsBack;
        this.crystal = crystalBack;
        this.nSymm = nSymmBack;
        this.permanentSchedule = permanentScheduleBack;
        this.realSpaceNeighborParameters.realSpaceSchedule = ewaldScheduleBack;
        this.realSpaceNeighborParameters.realSpaceRanges = rangesBack;
        this.alchemicalParameters.lAlpha = lAlphaBack;
        this.alchemicalParameters.dlAlpha = dlAlphaBack;
        this.alchemicalParameters.d2lAlpha = d2lAlphaBack;
        this.generalizedKirkwoodTerm = gkBack;
        this.scfAlgorithm = scfBack;
        Arrays.fill(this.use, true);
        return energy;
    }

    private double computeEnergy(boolean print) {
        this.permanentMultipoleField();
        if (this.generalizedKirkwoodTerm) {
            this.pmeTimings.bornRadiiTotal -= System.nanoTime();
            this.generalizedKirkwood.setUse(this.use);
            this.generalizedKirkwood.computeBornRadii();
            this.pmeTimings.bornRadiiTotal += System.nanoTime();
        }
        if (this.polarization != Polarization.NONE && this.alchemicalParameters.doPolarization) {
            if (this.generalizedKirkwoodTerm) {
                this.generalizedKirkwoodTerm = false;
                this.selfConsistentField(logger.isLoggable(Level.FINE));
                this.saveInducedDipolesToVacuumDipoles();
                this.generalizedKirkwoodTerm = true;
                this.permanentMultipoleField();
            }
            this.selfConsistentField(logger.isLoggable(Level.FINE));
            if (this.esvTerm && this.polarization != Polarization.NONE) {
                for (int i = 0; i < this.nAtoms; ++i) {
                    if (!this.extendedSystem.isTitrating(i) || !this.extendedSystem.isTitratingHydrogen(i) && !this.extendedSystem.isTitratingHeavy(i)) continue;
                    double dx = this.field.getX(i);
                    double dy = this.field.getY(i);
                    double dz = this.field.getZ(i);
                    double dxCR = this.fieldCR.getX(i);
                    double dyCR = this.fieldCR.getY(i);
                    double dzCR = this.fieldCR.getZ(i);
                    if (this.polarization == Polarization.MUTUAL) {
                        dx += this.directField[i][0];
                        dy += this.directField[i][1];
                        dz += this.directField[i][2];
                        dxCR += this.directFieldCR[i][0];
                        dyCR += this.directFieldCR[i][1];
                        dzCR += this.directFieldCR[i][2];
                    }
                    double fix = dx * this.dPolardTitrationESV[i] * dxCR;
                    double fiy = dy * this.dPolardTitrationESV[i] * dyCR;
                    double fiz = dz * this.dPolardTitrationESV[i] * dzCR;
                    double titrdUdL = fix + fiy + fiz;
                    double tautdUdL = 0.0;
                    if (this.extendedSystem.isTautomerizing(i)) {
                        fix = dx * this.dPolardTautomerESV[i] * dxCR;
                        fiy = dy * this.dPolardTautomerESV[i] * dyCR;
                        fiz = dz * this.dPolardTautomerESV[i] * dzCR;
                        tautdUdL = fix + fiy + fiz;
                    }
                    this.extendedSystem.addIndElecDeriv(i, titrdUdL * this.electric * -0.5, tautdUdL * this.electric * -0.5);
                }
            }
            if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0 && this.gradient && this.polarization == Polarization.DIRECT) {
                this.reciprocalSpace.splineInducedDipoles(this.inducedDipole, this.inducedDipoleCR, this.use);
                this.field.reset(this.parallelTeam);
                this.fieldCR.reset(this.parallelTeam);
                this.inducedDipoleFieldRegion.init(this.atoms, this.crystal, this.use, this.molecule, this.ipdamp, this.thole, this.coordinates, this.realSpaceNeighborParameters, this.inducedDipole, this.inducedDipoleCR, this.reciprocalSpaceTerm, this.reciprocalSpace, this.lambdaMode, this.ewaldParameters, this.field, this.fieldCR, this.pmeTimings);
                this.inducedDipoleFieldRegion.executeWith(this.sectionTeam);
                this.reciprocalSpace.computeInducedPhi(this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.fractionalInducedDipolePhi, this.fractionalInducedDipolePhiCR);
            }
            if (this.scfPredictorParameters.scfPredictor != SCFPredictor.NONE) {
                this.scfPredictorParameters.saveMutualInducedDipoles(this.lambdaMode, this.inducedDipole, this.inducedDipoleCR, this.directDipole, this.directDipoleCR);
            }
        }
        double[][][] inputDipole = this.inducedDipole;
        double[][][] inputDipoleCR = this.inducedDipoleCR;
        double[][] inputPhi = this.cartesianInducedDipolePhi;
        double[][] inputPhiCR = this.cartesianInducedDipolePhiCR;
        double[][] fracInputPhi = this.fractionalInducedDipolePhi;
        double[][] fracInputPhiCR = this.fractionalInducedDipolePhiCR;
        if (this.generalizedKirkwoodTerm) {
            inputDipole = this.vacuumInducedDipole;
            inputDipoleCR = this.vacuumInducedDipoleCR;
            inputPhi = this.cartesianVacuumDipolePhi;
            inputPhiCR = this.cartesianVacuumDipolePhiCR;
            fracInputPhi = this.fractionalVacuumDipolePhi;
            fracInputPhiCR = this.fractionalVacuumDipolePhiCR;
        }
        double eself = 0.0;
        double erecip = 0.0;
        double ecorrect = 0.0;
        double eselfi = 0.0;
        double erecipi = 0.0;
        if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
            this.reciprocalEnergyRegion.init(this.atoms, this.crystal, this.gradient, this.lambdaTerm, this.esvTerm, this.use, this.globalMultipole, this.fractionalMultipole, this.dMultipoledTirationESV, this.dMultipoledTautomerESV, this.cartesianMultipolePhi, this.fracMultipolePhi, this.polarization, inputDipole, inputDipoleCR, inputPhi, inputPhiCR, fracInputPhi, fracInputPhiCR, this.reciprocalSpace, this.alchemicalParameters, this.extendedSystem, this.grad, this.torque, this.lambdaGrad, this.lambdaTorque, this.shareddEdLambda, this.sharedd2EdLambda2);
            this.reciprocalEnergyRegion.executeWith(this.parallelTeam);
            eself = this.reciprocalEnergyRegion.getPermanentSelfEnergy();
            erecip = this.reciprocalEnergyRegion.getPermanentReciprocalEnergy();
            ecorrect = this.reciprocalEnergyRegion.getPermanentChargeCorrectionEnergy();
            eselfi = this.reciprocalEnergyRegion.getInducedDipoleSelfEnergy();
            erecipi = this.reciprocalEnergyRegion.getInducedDipoleReciprocalEnergy();
            this.interactions += this.nAtoms;
        }
        this.pmeTimings.realSpaceEnergyTotal -= System.nanoTime();
        this.realSpaceEnergyRegion.init(this.atoms, this.crystal, this.extendedSystem, this.esvTerm, this.coordinates, this.frame, this.axisAtom, this.globalMultipole, this.dMultipoledTirationESV, this.dMultipoledTautomerESV, inputDipole, inputDipoleCR, this.use, this.molecule, this.ip11, this.mask12, this.mask13, this.mask14, this.mask15, this.isSoft, this.ipdamp, this.thole, this.realSpaceNeighborParameters, this.gradient, this.lambdaTerm, this.nnTerm, this.lambdaMode, this.polarization, this.ewaldParameters, this.scaleParameters, this.alchemicalParameters, this.pmeTimings.realSpaceEnergyTime, this.grad, this.torque, this.lambdaGrad, this.lambdaTorque, this.shareddEdLambda, this.sharedd2EdLambda2);
        this.realSpaceEnergyRegion.executeWith(this.parallelTeam);
        double ereal = this.realSpaceEnergyRegion.getPermanentEnergy();
        double ereali = this.realSpaceEnergyRegion.getPolarizationEnergy();
        this.interactions += this.realSpaceEnergyRegion.getInteractions();
        this.pmeTimings.realSpaceEnergyTotal += System.nanoTime();
        if (this.generalizedKirkwoodTerm) {
            double eGK = 0.0;
            AlchemicalParameters alchemicalParametersGK = new AlchemicalParameters(this.forceField, false, false, this.polarization);
            alchemicalParametersGK.permanentScale = 0.0;
            alchemicalParametersGK.doPermanentRealSpace = false;
            alchemicalParametersGK.polarizationScale = -1.0;
            AtomicDoubleArray3D gradGK = this.generalizedKirkwood.getGrad();
            AtomicDoubleArray3D torqueGK = this.generalizedKirkwood.getTorque();
            if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                this.reciprocalEnergyRegion.init(this.atoms, this.crystal, this.gradient, false, this.esvTerm, this.use, this.globalMultipole, this.fractionalMultipole, this.dMultipoledTirationESV, this.dMultipoledTautomerESV, this.cartesianMultipolePhi, this.fracMultipolePhi, this.polarization, this.vacuumInducedDipole, this.vacuumInducedDipoleCR, this.cartesianVacuumDipolePhi, this.cartesianVacuumDipolePhiCR, this.fractionalVacuumDipolePhi, this.fractionalVacuumDipolePhiCR, this.reciprocalSpace, alchemicalParametersGK, this.extendedSystem, gradGK, torqueGK, null, null, this.shareddEdLambda, this.sharedd2EdLambda2);
                this.reciprocalEnergyRegion.executeWith(this.parallelTeam);
                eGK = this.reciprocalEnergyRegion.getInducedDipoleSelfEnergy() + this.reciprocalEnergyRegion.getInducedDipoleReciprocalEnergy();
            }
            this.pmeTimings.gkEnergyTotal -= System.nanoTime();
            this.realSpaceEnergyRegion.init(this.atoms, this.crystal, this.extendedSystem, this.esvTerm, this.coordinates, this.frame, this.axisAtom, this.globalMultipole, this.dMultipoledTirationESV, this.dMultipoledTautomerESV, this.vacuumInducedDipole, this.vacuumInducedDipoleCR, this.use, this.molecule, this.ip11, this.mask12, this.mask13, this.mask14, this.mask15, this.isSoft, this.ipdamp, this.thole, this.realSpaceNeighborParameters, this.gradient, false, this.nnTerm, this.lambdaMode, this.polarization, this.ewaldParameters, this.scaleParameters, alchemicalParametersGK, this.pmeTimings.realSpaceEnergyTime, gradGK, torqueGK, null, null, this.shareddEdLambda, this.sharedd2EdLambda2);
            this.realSpaceEnergyRegion.executeWith(this.parallelTeam);
            eGK += this.realSpaceEnergyRegion.getPolarizationEnergy();
            alchemicalParametersGK.polarizationScale = 1.0;
            if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                this.reciprocalEnergyRegion.init(this.atoms, this.crystal, this.gradient, false, this.esvTerm, this.use, this.globalMultipole, this.fractionalMultipole, this.dMultipoledTirationESV, this.dMultipoledTautomerESV, this.cartesianMultipolePhi, this.fracMultipolePhi, this.polarization, this.inducedDipole, this.inducedDipoleCR, this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.fractionalInducedDipolePhi, this.fractionalInducedDipolePhiCR, this.reciprocalSpace, alchemicalParametersGK, this.extendedSystem, gradGK, torqueGK, null, null, this.shareddEdLambda, this.sharedd2EdLambda2);
                this.reciprocalEnergyRegion.executeWith(this.parallelTeam);
                eGK += this.reciprocalEnergyRegion.getInducedDipoleSelfEnergy() + this.reciprocalEnergyRegion.getInducedDipoleReciprocalEnergy();
            }
            this.pmeTimings.gkEnergyTotal -= System.nanoTime();
            this.realSpaceEnergyRegion.init(this.atoms, this.crystal, this.extendedSystem, this.esvTerm, this.coordinates, this.frame, this.axisAtom, this.globalMultipole, this.dMultipoledTirationESV, this.dMultipoledTautomerESV, this.inducedDipole, this.inducedDipoleCR, this.use, this.molecule, this.ip11, this.mask12, this.mask13, this.mask14, this.mask15, this.isSoft, this.ipdamp, this.thole, this.realSpaceNeighborParameters, this.gradient, false, this.nnTerm, this.lambdaMode, this.polarization, this.ewaldParameters, this.scaleParameters, alchemicalParametersGK, this.pmeTimings.realSpaceEnergyTime, gradGK, torqueGK, null, null, this.shareddEdLambda, this.sharedd2EdLambda2);
            this.realSpaceEnergyRegion.executeWith(this.parallelTeam);
            this.solvationEnergy += this.generalizedKirkwood.solvationEnergy(eGK += this.realSpaceEnergyRegion.getPolarizationEnergy(), this.gradient, print);
            if (this.gradient) {
                this.generalizedKirkwood.reduce(this.grad, this.torque, this.lambdaGrad, this.lambdaTorque);
            }
            this.gkInteractions += this.generalizedKirkwood.getInteractions();
            this.pmeTimings.gkEnergyTotal += System.nanoTime();
        }
        this.permanentRealSpaceEnergy += ereal;
        this.permanentSelfEnergy += eself;
        this.permanentReciprocalEnergy += erecip;
        this.permanentChargeCorrectionEnergy += ecorrect;
        this.inducedRealSpaceEnergy += ereali;
        this.inducedSelfEnergy += eselfi;
        this.inducedReciprocalEnergy += erecipi;
        this.permanentMultipoleEnergy += eself + erecip + ereal + ecorrect;
        this.polarizationEnergy += eselfi + erecipi + ereali;
        this.totalMultipoleEnergy += ereal + eself + erecip + ereali + eselfi + erecipi;
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\n Global Cartesian PME, lambdaMode=%s\n", this.lambdaMode.toString()));
            sb.append(String.format(" Multipole Reciprocal:    %16.8f\n", erecip));
            sb.append(String.format(" Multipole Self-Energy:   %16.8f\n", eself));
            sb.append(String.format(" Multipole Correction:    %16.8f\n", ecorrect));
            sb.append(String.format(" Multipole Real Space:    %16.8f\n", ereal));
            sb.append(String.format(" Polarization Reciprocal: %16.8f\n", erecipi));
            sb.append(String.format(" Polarization Self-Energy:%16.8f\n", eselfi));
            sb.append(String.format(" Polarization Real Space: %16.8f\n", ereali));
            if (this.generalizedKirkwoodTerm) {
                sb.append(String.format(" Generalized Kirkwood:    %16.8f\n", this.solvationEnergy));
            }
            logger.info(sb.toString());
        }
        return this.permanentMultipoleEnergy + this.polarizationEnergy + this.solvationEnergy;
    }

    private void permanentMultipoleField() {
        try {
            if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                this.reciprocalSpace.computeBSplines();
                this.reciprocalSpace.splinePermanentMultipoles(this.globalMultipole, this.fractionalMultipole, this.use);
            }
            this.field.reset(this.parallelTeam);
            this.fieldCR.reset(this.parallelTeam);
            this.permanentFieldRegion.init(this.atoms, this.crystal, this.coordinates, this.globalMultipole, this.inducedDipole, this.inducedDipoleCR, this.neighborLists, this.scaleParameters, this.use, this.molecule, this.ipdamp, this.thole, this.ip11, this.mask12, this.mask13, this.mask14, this.lambdaMode, this.reciprocalSpaceTerm, this.reciprocalSpace, this.ewaldParameters, this.pcgSolver, this.permanentSchedule, this.realSpaceNeighborParameters, this.field, this.fieldCR);
            this.sectionTeam.execute((ParallelRegion)this.permanentFieldRegion);
            if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                this.reciprocalSpace.computePermanentPhi(this.cartesianMultipolePhi, this.fracMultipolePhi);
            }
        }
        catch (RuntimeException e) {
            String message = "Fatal exception computing the permanent multipole field.\n";
            logger.log(Level.WARNING, message, e);
            throw e;
        }
        catch (Exception e) {
            String message = "Fatal exception computing the permanent multipole field.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private void saveInducedDipolesToVacuumDipoles() {
        for (int i = 0; i < this.nAtoms; ++i) {
            System.arraycopy(this.directDipole[i], 0, this.vacuumDirectDipole[i], 0, 3);
            System.arraycopy(this.directDipoleCR[i], 0, this.vacuumDirectDipoleCR[i], 0, 3);
            System.arraycopy(this.inducedDipole[0][i], 0, this.vacuumInducedDipole[0][i], 0, 3);
            System.arraycopy(this.inducedDipoleCR[0][i], 0, this.vacuumInducedDipoleCR[0][i], 0, 3);
            System.arraycopy(this.cartesianInducedDipolePhi[i], 0, this.cartesianVacuumDipolePhi[i], 0, tensorCount);
            System.arraycopy(this.cartesianInducedDipolePhiCR[i], 0, this.cartesianVacuumDipolePhiCR[i], 0, tensorCount);
            System.arraycopy(this.fractionalInducedDipolePhi[i], 0, this.fractionalVacuumDipolePhi[i], 0, tensorCount);
            System.arraycopy(this.fractionalInducedDipolePhiCR[i], 0, this.fractionalVacuumDipolePhiCR[i], 0, tensorCount);
            if (this.nSymm <= 1) continue;
            for (int s = 1; s < this.nSymm; ++s) {
                System.arraycopy(this.inducedDipole[s][i], 0, this.vacuumInducedDipole[s][i], 0, 3);
                System.arraycopy(this.inducedDipoleCR[s][i], 0, this.vacuumInducedDipoleCR[s][i], 0, 3);
            }
        }
    }

    private int selfConsistentField(boolean print) {
        if (this.polarization == Polarization.NONE) {
            return -1;
        }
        long startTime = System.nanoTime();
        if (this.generalizedKirkwoodTerm) {
            this.pmeTimings.gkEnergyTotal = -System.nanoTime();
            this.generalizedKirkwood.computePermanentGKField();
            this.pmeTimings.gkEnergyTotal += System.nanoTime();
            logger.fine(String.format(" Computed GK permanent field %8.3f (sec)", (double)this.pmeTimings.gkEnergyTotal * 1.0E-9));
        }
        this.directRegion.init(this.atoms, this.polarizability, this.globalMultipole, this.cartesianMultipolePhi, this.field, this.fieldCR, this.generalizedKirkwoodTerm, this.generalizedKirkwood, this.ewaldParameters, this.soluteDielectric, this.inducedDipole, this.inducedDipoleCR, this.directDipole, this.directDipoleCR, this.directField, this.directFieldCR);
        this.directRegion.executeWith(this.parallelTeam);
        if (this.polarization != Polarization.MUTUAL) {
            this.expandInducedDipoles();
            return 0;
        }
        if (this.scfPredictorParameters.scfPredictor != SCFPredictor.NONE) {
            switch (this.scfPredictorParameters.scfPredictor) {
                case ASPC: {
                    this.scfPredictorParameters.aspcPredictor(this.lambdaMode, this.inducedDipole, this.inducedDipoleCR);
                    break;
                }
                case LS: {
                    this.scfPredictorParameters.leastSquaresPredictor(this.lambdaMode, this.inducedDipole, this.inducedDipoleCR);
                    break;
                }
                case POLY: {
                    this.scfPredictorParameters.polynomialPredictor(this.lambdaMode, this.inducedDipole, this.inducedDipoleCR);
                    break;
                }
            }
        }
        this.expandInducedDipoles();
        try {
            return switch (this.scfAlgorithm) {
                case SCFAlgorithm.SOR -> this.scfBySOR(print, startTime);
                case SCFAlgorithm.EPT -> this.scfByEPT(print, startTime);
                default -> {
                    this.pcgSolver.init(this.atoms, this.coordinates, this.polarizability, this.ipdamp, this.thole, this.use, this.crystal, this.inducedDipole, this.inducedDipoleCR, this.directDipole, this.directDipoleCR, this.field, this.fieldCR, this.ewaldParameters, this.soluteDielectric, this.parallelTeam, this.realSpaceNeighborParameters.realSpaceSchedule, this.pmeTimings);
                    yield this.pcgSolver.scfByPCG(print, startTime, this);
                }
            };
        }
        catch (EnergyException ex) {
            logger.warning(ex.toString());
            if (this.sorFallback) {
                SCFAlgorithm currentSCFAlgorithm = this.scfAlgorithm;
                this.scfAlgorithm = SCFAlgorithm.SOR;
                double currentPolarSOR = this.sorRegion.getPolarSOR();
                this.sorRegion.setPolarSOR(0.65);
                int ret = this.selfConsistentField(print);
                this.scfAlgorithm = currentSCFAlgorithm;
                this.sorRegion.setPolarSOR(currentPolarSOR);
                logger.info(" SOR induced dipoles computed due to SCF failure.");
                return ret;
            }
            if (this.directFallback) {
                this.polarization = Polarization.DIRECT;
                int ret = this.selfConsistentField(print);
                this.polarization = Polarization.MUTUAL;
                logger.info(" Direct induced dipoles computed due to SCF failure.");
                return ret;
            }
            throw ex;
        }
    }

    private int scfBySOR(boolean print, long startTime) {
        long directTime = System.nanoTime() - startTime;
        StringBuilder sb = null;
        if (print) {
            sb = new StringBuilder("\n Self-Consistent Field\n Iter  RMS Change (Debye)  Time\n");
        }
        int completedSCFCycles = 0;
        int maxSCFCycles = 1000;
        double eps = 100.0;
        boolean done = false;
        while (!done) {
            long cycleTime = -System.nanoTime();
            try {
                if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                    this.reciprocalSpace.splineInducedDipoles(this.inducedDipole, this.inducedDipoleCR, this.use);
                }
                this.field.reset(this.parallelTeam);
                this.fieldCR.reset(this.parallelTeam);
                this.inducedDipoleFieldRegion.init(this.atoms, this.crystal, this.use, this.molecule, this.ipdamp, this.thole, this.coordinates, this.realSpaceNeighborParameters, this.inducedDipole, this.inducedDipoleCR, this.reciprocalSpaceTerm, this.reciprocalSpace, this.lambdaMode, this.ewaldParameters, this.field, this.fieldCR, this.pmeTimings);
                this.inducedDipoleFieldRegion.executeWith(this.sectionTeam);
                if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                    this.reciprocalSpace.computeInducedPhi(this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.fractionalInducedDipolePhi, this.fractionalInducedDipolePhiCR);
                }
                if (this.generalizedKirkwoodTerm) {
                    this.pmeTimings.gkEnergyTotal = -System.nanoTime();
                    this.generalizedKirkwood.computeInducedGKField();
                    this.pmeTimings.gkEnergyTotal += System.nanoTime();
                    logger.fine(String.format(" Computed GK induced field %8.3f (sec)", (double)this.pmeTimings.gkEnergyTotal * 1.0E-9));
                }
                this.sorRegion.init(this.atoms, this.polarizability, this.inducedDipole, this.inducedDipoleCR, this.directDipole, this.directDipoleCR, this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.field, this.fieldCR, this.generalizedKirkwoodTerm, this.generalizedKirkwood, this.ewaldParameters);
                this.parallelTeam.execute((ParallelRegion)this.sorRegion);
                this.expandInducedDipoles();
            }
            catch (Exception e) {
                String message = "Exception computing mutual induced dipoles.";
                logger.log(Level.SEVERE, message, e);
            }
            ++completedSCFCycles;
            double previousEps = eps;
            eps = this.sorRegion.getEps();
            eps = 4.80321 * FastMath.sqrt((double)(eps / (double)this.nAtoms));
            cycleTime += System.nanoTime();
            if (print) {
                sb.append(String.format(" %4d     %15.10f %7.4f\n", completedSCFCycles, eps, (double)cycleTime * 1.0E-9));
            }
            if (eps > previousEps) {
                if (sb != null) {
                    logger.warning(sb.toString());
                }
                String message = String.format(" SCF convergence failure: (%10.5f > %10.5f)\n", eps, previousEps);
                throw new EnergyException(message);
            }
            if (completedSCFCycles >= maxSCFCycles) {
                if (sb != null) {
                    logger.warning(sb.toString());
                }
                String message = String.format(" Maximum SCF iterations reached: (%d)\n", completedSCFCycles);
                throw new EnergyException(message);
            }
            if (!(eps < this.poleps)) continue;
            done = true;
        }
        if (print) {
            sb.append(String.format(" Direct:                  %7.4f\n", 1.0E-9 * (double)directTime));
            startTime = System.nanoTime() - startTime;
            sb.append(String.format(" Total:                   %7.4f", (double)startTime * 1.0E-9));
            logger.info(sb.toString());
        }
        return completedSCFCycles;
    }

    private int scfByEPT(boolean print, long startTime) {
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.optRegion.optDipole[0][i][j] = this.directDipole[i][j];
                this.optRegion.optDipoleCR[0][i][j] = this.directDipoleCR[i][j];
            }
        }
        int optOrder = this.optRegion.optOrder;
        for (int currentOptOrder = 1; currentOptOrder <= optOrder; ++currentOptOrder) {
            try {
                if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                    this.reciprocalSpace.splineInducedDipoles(this.inducedDipole, this.inducedDipoleCR, this.use);
                }
                this.field.reset(this.parallelTeam);
                this.fieldCR.reset(this.parallelTeam);
                this.inducedDipoleFieldRegion.init(this.atoms, this.crystal, this.use, this.molecule, this.ipdamp, this.thole, this.coordinates, this.realSpaceNeighborParameters, this.inducedDipole, this.inducedDipoleCR, this.reciprocalSpaceTerm, this.reciprocalSpace, this.lambdaMode, this.ewaldParameters, this.field, this.fieldCR, this.pmeTimings);
                this.inducedDipoleFieldRegion.executeWith(this.sectionTeam);
                if (this.reciprocalSpaceTerm && this.ewaldParameters.aewald > 0.0) {
                    this.reciprocalSpace.computeInducedPhi(this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.fractionalInducedDipolePhi, this.fractionalInducedDipolePhiCR);
                }
                if (this.generalizedKirkwoodTerm) {
                    this.pmeTimings.gkEnergyTotal = -System.nanoTime();
                    this.generalizedKirkwood.computeInducedGKField();
                    this.pmeTimings.gkEnergyTotal += System.nanoTime();
                    logger.fine(String.format(" Computed GK induced field %8.3f (sec)", (double)this.pmeTimings.gkEnergyTotal * 1.0E-9));
                }
                this.optRegion.init(currentOptOrder, this.atoms, this.polarizability, this.inducedDipole, this.inducedDipoleCR, this.cartesianInducedDipolePhi, this.cartesianInducedDipolePhiCR, this.field, this.fieldCR, this.generalizedKirkwoodTerm, this.generalizedKirkwood, this.ewaldParameters, this.soluteDielectric);
                this.parallelTeam.execute((ParallelRegion)this.optRegion);
                this.expandInducedDipoles();
                continue;
            }
            catch (Exception e) {
                String message = "Exception computing opt induced dipoles.";
                logger.log(Level.SEVERE, message, e);
            }
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.inducedDipole[0][i][j] = 0.0;
                this.inducedDipoleCR[0][i][j] = 0.0;
                double sum = 0.0;
                double sump = 0.0;
                for (int k = 0; k <= optOrder; ++k) {
                    sump += this.optRegion.optDipoleCR[k][i][j];
                    double[] dArray = this.inducedDipole[0][i];
                    int n = j;
                    dArray[n] = dArray[n] + this.optRegion.optCoefficients[k] * (sum += this.optRegion.optDipole[k][i][j]);
                    double[] dArray2 = this.inducedDipoleCR[0][i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + this.optRegion.optCoefficients[k] * sump;
                }
            }
        }
        this.expandInducedDipoles();
        return optOrder;
    }

    public double getTotalMultipoleEnergy() {
        return this.permanentMultipoleEnergy + this.polarizationEnergy;
    }

    public void setPolarization(Polarization set) {
        this.polarization = set;
    }

    private void assignMultipoles() {
        if (this.forceField == null) {
            String message = "No force field is defined.\n";
            logger.log(Level.SEVERE, message);
            return;
        }
        if (this.forceField.getForceFieldTypeCount(ForceField.ForceFieldType.MULTIPOLE) < 1 && this.forceField.getForceFieldTypeCount(ForceField.ForceFieldType.CHARGE) < 1) {
            String message = "Force field has no permanent electrostatic types.\n";
            logger.log(Level.SEVERE, message);
            return;
        }
        if (this.nAtoms < 1) {
            String message = "No atoms are defined.\n";
            logger.log(Level.SEVERE, message);
            return;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            Atom atom = this.atoms[i];
            if (MultipoleType.assignMultipole(this.elecForm, atom, this.forceField, this.localMultipole[i], i, this.axisAtom, this.frame)) continue;
            logger.info(String.format("No MultipoleType could be assigned:\n %s --> %s", atom, atom.getAtomType()));
            StringBuilder sb = new StringBuilder();
            List<Bond> bonds = atom.getBonds();
            for (Bond bond12 : bonds) {
                Atom a2 = bond12.get1_2(atom);
                AtomType aType2 = a2.getAtomType();
                sb.append(String.format("\n  1-2 %s --> %s", a2, aType2));
            }
            for (Bond bond12 : bonds) {
                Atom atom2 = bond12.get1_2(atom);
                bonds = atom2.getBonds();
                for (Bond bond23 : bonds) {
                    Atom a2 = bond23.get1_2(atom2);
                    AtomType aType2 = a2.getAtomType();
                    sb.append(String.format("\n  1-3 %s --> %s", a2, aType2));
                }
            }
            List<MultipoleType> multipoleTypes = this.forceField.getMultipoleTypes(atom.getAtomType().getKey());
            if (multipoleTypes != null && !multipoleTypes.isEmpty()) {
                sb.append("\n Similar Multipole types:");
                for (MultipoleType multipoleType : multipoleTypes) {
                    sb.append(String.format("\n %s", multipoleType));
                }
            }
            logger.log(Level.SEVERE, sb.toString());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nAtoms; ++i) {
            int j;
            boolean flag = false;
            for (j = 0; j < 10; ++j) {
                if (!Double.isNaN(this.localMultipole[i][j])) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            sb.append("\n").append(this.atoms[i].toString()).append("\n");
            sb.append(String.format("%d", i + 1));
            for (j = 0; j < 10; ++j) {
                sb.append(String.format(" %8.3f", this.localMultipole[i][j]));
            }
            sb.append("\n");
        }
        if (!sb.isEmpty()) {
            String message = "Fatal exception: Error assigning multipoles. " + String.valueOf(sb);
            logger.log(Level.SEVERE, message);
        }
    }

    protected void assignPolarizationGroups() {
        Iterator iterator;
        int j;
        int i;
        ArrayList<Integer> group = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.nAtoms; ++i2) {
            Atom a = this.atoms[i2];
            if (a.getIndex() - 1 == i2) continue;
            logger.info(String.format(" PME Index: %d Atom Index: %d\n Atom: %s", i2, a.getIndex() - 1, a));
            logger.severe(" Atom indexing is not consistent in PME.");
        }
        for (Atom ai : this.atoms) {
            group.clear();
            int index = ai.getIndex() - 1;
            group.add(index);
            PolarizeType polarizeType = ai.getPolarizeType();
            if (polarizeType != null) {
                int k;
                Iterator iterator2;
                if (polarizeType.polarizationGroup != null) {
                    PolarizeType.growGroup(group, ai);
                    Collections.sort(group);
                    this.ip11[index] = new int[group.size()];
                    int j2 = 0;
                    iterator2 = group.iterator();
                    while (iterator2.hasNext()) {
                        k = (Integer)iterator2.next();
                        this.ip11[index][j2++] = k;
                    }
                    continue;
                }
                this.ip11[index] = new int[group.size()];
                int j3 = 0;
                iterator2 = group.iterator();
                while (iterator2.hasNext()) {
                    k = (Integer)iterator2.next();
                    this.ip11[index][j3++] = k;
                }
                continue;
            }
            String message = "The polarize keyword was not found for atom " + (index + 1) + " with type " + ai.getType();
            logger.severe(message);
        }
        int[] mask = new int[this.nAtoms];
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> keep = new ArrayList<Integer>();
        for (i = 0; i < this.nAtoms; ++i) {
            mask[i] = -1;
        }
        for (i = 0; i < this.nAtoms; ++i) {
            int j4;
            list.clear();
            for (int j5 : this.ip11[i]) {
                list.add(j5);
                mask[j5] = i;
            }
            keep.clear();
            Object index = list.iterator();
            while (index.hasNext()) {
                j4 = (Integer)index.next();
                Atom aj = this.atoms[j4];
                List<Bond> bonds = aj.getBonds();
                for (Bond b : bonds) {
                    Atom ak = b.get1_2(aj);
                    int k = ak.getIndex() - 1;
                    if (mask[k] == i) continue;
                    keep.add(k);
                }
            }
            list.clear();
            index = keep.iterator();
            while (index.hasNext()) {
                j4 = (Integer)index.next();
                for (int k : this.ip11[j4]) {
                    list.add(k);
                }
            }
            Collections.sort(list);
            this.ip12[i] = new int[list.size()];
            j = 0;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                this.ip12[i][j++] = k;
            }
        }
        for (i = 0; i < this.nAtoms; ++i) {
            mask[i] = -1;
        }
        for (i = 0; i < this.nAtoms; ++i) {
            for (int j6 : this.ip11[i]) {
                mask[j6] = i;
            }
            for (int j7 : this.ip12[i]) {
                mask[j7] = i;
            }
            list.clear();
            for (int j7 : this.ip12[i]) {
                for (int k : this.ip12[j7]) {
                    if (mask[k] == i || list.contains(k)) continue;
                    list.add(k);
                }
            }
            this.ip13[i] = new int[list.size()];
            Collections.sort(list);
            j = 0;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                this.ip13[i][j++] = k;
            }
        }
    }

    public double[] computeMoments(Atom[] activeAtoms, boolean forceEnergy) {
        double netchg = 0.0;
        double netdpl = 0.0;
        double xdpl = 0.0;
        double ydpl = 0.0;
        double zdpl = 0.0;
        double xxqdp = 0.0;
        double xyqdp = 0.0;
        double xzqdp = 0.0;
        double yxqdp = 0.0;
        double yyqdp = 0.0;
        double yzqdp = 0.0;
        double zxqdp = 0.0;
        double zyqdp = 0.0;
        double zzqdp = 0.0;
        double xmid = 0.0;
        double ymid = 0.0;
        double zmid = 0.0;
        double totalMass = 0.0;
        for (Atom atom : activeAtoms) {
            double m = atom.getMass();
            totalMass += m;
            xmid += atom.getX() * m;
            ymid += atom.getY() * m;
            zmid += atom.getZ() * m;
        }
        if (totalMass > 0.0) {
            xmid /= totalMass;
            ymid /= totalMass;
            zmid /= totalMass;
        }
        int n = activeAtoms.length;
        double[] xcm = new double[n];
        double[] ycm = new double[n];
        double[] zcm = new double[n];
        int k = 0;
        for (Atom atom : activeAtoms) {
            xcm[k] = atom.getX() - xmid;
            ycm[k] = atom.getY() - ymid;
            zcm[k] = atom.getZ() - zmid;
            ++k;
        }
        if (forceEnergy) {
            this.energy(false, false);
        }
        k = 0;
        for (Atom atom : activeAtoms) {
            int i = atom.getIndex() - 1;
            double[] globalMultipolei = this.globalMultipole[0][i];
            double[] inducedDipolei = this.inducedDipole[0][i];
            double ci = globalMultipolei[0];
            double dix = globalMultipolei[1];
            double diy = globalMultipolei[2];
            double diz = globalMultipolei[3];
            double uix = inducedDipolei[0];
            double uiy = inducedDipolei[1];
            double uiz = inducedDipolei[2];
            netchg += ci;
            xdpl += xcm[k] * ci + dix + uix;
            ydpl += ycm[k] * ci + diy + uiy;
            zdpl += zcm[k] * ci + diz + uiz;
            xxqdp += xcm[k] * xcm[k] * ci + 2.0 * xcm[k] * (dix + uix);
            xyqdp += xcm[k] * ycm[k] * ci + xcm[k] * (diy + uiy) + ycm[k] * (dix + uix);
            xzqdp += xcm[k] * zcm[k] * ci + xcm[k] * (diz + uiz) + zcm[k] * (dix + uix);
            yxqdp += ycm[k] * xcm[k] * ci + ycm[k] * (dix + uix) + xcm[k] * (diy + uiy);
            yyqdp += ycm[k] * ycm[k] * ci + 2.0 * ycm[k] * (diy + uiy);
            yzqdp += ycm[k] * zcm[k] * ci + ycm[k] * (diz + uiz) + zcm[k] * (diy + uiy);
            zxqdp += zcm[k] * xcm[k] * ci + zcm[k] * (dix + uix) + xcm[k] * (diz + uiz);
            zyqdp += zcm[k] * ycm[k] * ci + zcm[k] * (diy + uiy) + ycm[k] * (diz + uiz);
            zzqdp += zcm[k] * zcm[k] * ci + 2.0 * zcm[k] * (diz + uiz);
            ++k;
        }
        double qave = (xxqdp + yyqdp + zzqdp) / 3.0;
        xxqdp = 1.5 * (xxqdp - qave);
        xyqdp = 1.5 * xyqdp;
        xzqdp = 1.5 * xzqdp;
        yxqdp = 1.5 * yxqdp;
        yyqdp = 1.5 * (yyqdp - qave);
        yzqdp = 1.5 * yzqdp;
        zxqdp = 1.5 * zxqdp;
        zyqdp = 1.5 * zyqdp;
        zzqdp = 1.5 * (zzqdp - qave);
        for (Atom atom : activeAtoms) {
            int i = atom.getIndex() - 1;
            double[] globalMultipolei = this.globalMultipole[0][i];
            double qixx = globalMultipolei[4];
            double qiyy = globalMultipolei[5];
            double qizz = globalMultipolei[6];
            double qixy = globalMultipolei[7];
            double qixz = globalMultipolei[8];
            double qiyz = globalMultipolei[9];
            xxqdp += qixx;
            xyqdp += qixy;
            xzqdp += qixz;
            yxqdp += qixy;
            yyqdp += qiyy;
            yzqdp += qiyz;
            zxqdp += qixz;
            zyqdp += qiyz;
            zzqdp += qizz;
        }
        xdpl *= 4.80321;
        ydpl *= 4.80321;
        zdpl *= 4.80321;
        xxqdp *= 4.80321;
        xyqdp *= 4.80321;
        xzqdp *= 4.80321;
        yxqdp *= 4.80321;
        yyqdp *= 4.80321;
        yzqdp *= 4.80321;
        zxqdp *= 4.80321;
        zyqdp *= 4.80321;
        zzqdp *= 4.80321;
        netdpl = FastMath.sqrt((double)(xdpl * xdpl + ydpl * ydpl + zdpl * zdpl));
        double[][] a = new double[3][3];
        a[0][0] = xxqdp;
        a[0][1] = xyqdp;
        a[0][2] = xzqdp;
        a[1][0] = yxqdp;
        a[1][1] = yyqdp;
        a[1][2] = yzqdp;
        a[2][0] = zxqdp;
        a[2][1] = zyqdp;
        a[2][2] = zzqdp;
        EigenDecomposition e = new EigenDecomposition((RealMatrix)new Array2DRowRealMatrix(a));
        double[] netqdp = e.getRealEigenvalues();
        logger.info("\n Electric Moments\n");
        logger.info(String.format("  Total Electric Charge:    %13.5f Electrons\n", netchg));
        logger.info(String.format("  Dipole Moment Magnitude:  %13.5f Debye\n", netdpl));
        logger.info(String.format("  Dipole X,Y,Z-Components:  %13.5f %13.5f %13.5f\n", xdpl, ydpl, zdpl));
        logger.info(String.format("  Quadrupole Moment Tensor: %13.5f %13.5f %13.5f", xxqdp, xyqdp, xzqdp));
        logger.info(String.format("       (Buckinghams)        %13.5f %13.5f %13.5f", yxqdp, yyqdp, yzqdp));
        logger.info(String.format("                            %13.5f %13.5f %13.5f\n", zxqdp, zyqdp, zzqdp));
        logger.info(String.format("  Principal Axes Quadrupole %13.5f %13.5f %13.5f\n", netqdp[2], netqdp[1], netqdp[0]));
        return new double[]{netchg, netdpl, xdpl, ydpl, zdpl, xxqdp, xyqdp, xzqdp, yxqdp, yyqdp, yzqdp, zxqdp, zyqdp, zzqdp};
    }

    private void log(int i, int k, double r, double eij) {
        logger.info(String.format("%s %6d-%s %6d-%s %10.4f  %10.4f", "ELEC", this.atoms[i].getIndex(), this.atoms[i].getAtomType().name, this.atoms[k].getIndex(), this.atoms[k].getAtomType().name, r, eij));
    }

    public void attachExtendedSystem(ExtendedSystem system) {
        this.esvTerm = true;
        this.extendedSystem = system;
        this.setAtoms(this.extendedSystem.getExtendedAtoms(), this.extendedSystem.getExtendedMolecule());
        if (this.dMultipoledTirationESV == null || this.dMultipoledTirationESV.length != this.nSymm || this.dMultipoledTirationESV[0].length != this.nAtoms) {
            this.dMultipoledTirationESV = new double[this.nSymm][this.nAtoms][10];
            this.dMultipoledTautomerESV = new double[this.nSymm][this.nAtoms][10];
        }
        if (this.dPolardTitrationESV == null || this.dPolardTitrationESV.length != this.nAtoms) {
            this.dPolardTitrationESV = new double[this.nAtoms];
            this.dPolardTautomerESV = new double[this.nAtoms];
        }
        logger.info(String.format(" Attached extended system (%d variables) to PME.\n", this.extendedSystem.getNumberOfVariables()));
    }

    public class LambdaFactors {
        protected double lambdaProd;
        protected double lfAlpha;
        protected double dlfAlpha;
        protected double d2lfAlpha;
        protected double lfPowPerm;
        protected double dlfPowPerm;
        protected double d2lfPowPerm;
        protected double lfPowPol;
        protected double dlfPowPol;
        protected double d2lfPowPol;
        protected double dLpdL;
        protected double dLpdLi;
        protected double dLpdLk;
        protected int[] ik;
        final /* synthetic */ ParticleMeshEwald this$0;

        public LambdaFactors(ParticleMeshEwald this$0) {
            ParticleMeshEwald particleMeshEwald = this$0;
            Objects.requireNonNull(particleMeshEwald);
            this.this$0 = particleMeshEwald;
            this.lambdaProd = 1.0;
            this.lfAlpha = 0.0;
            this.dlfAlpha = 0.0;
            this.d2lfAlpha = 0.0;
            this.lfPowPerm = 1.0;
            this.dlfPowPerm = 0.0;
            this.d2lfPowPerm = 0.0;
            this.lfPowPol = 1.0;
            this.dlfPowPol = 0.0;
            this.d2lfPowPol = 0.0;
            this.dLpdL = 1.0;
            this.dLpdLi = 1.0;
            this.dLpdLk = 1.0;
            this.ik = new int[2];
        }

        public void print() {
            StringBuilder sb = new StringBuilder();
            if (this instanceof LambdaFactorsESV) {
                sb.append(String.format("  (QI-ESV)  i,k:%d,%d", this.ik[0], this.ik[1]));
            } else {
                sb.append("  (QI-OST)");
            }
            sb.append(String.format("  lambda:%.2f  lAlpha:%.2f,%.2f,%.2f  lPowPerm:%.2f,%.2f,%.2f  lPowPol:%.2f,%.2f,%.2f", this.lambdaProd, this.lfAlpha, this.dlfAlpha, this.d2lfAlpha, this.lfPowPerm, this.dlfPowPerm, this.d2lfPowPerm, this.lfPowPol, this.dlfPowPol, this.d2lfPowPol));
            sb.append(String.format("\n    permExp:%.2f  permAlpha:%.2f  permWindow:%.2f,%.2f  polExp:%.2f  polWindow:%.2f,%.2f", this.this$0.alchemicalParameters.permLambdaExponent, this.this$0.alchemicalParameters.permLambdaAlpha, this.this$0.alchemicalParameters.permLambdaStart, this.this$0.alchemicalParameters.permLambdaEnd, this.this$0.alchemicalParameters.polLambdaExponent, this.this$0.alchemicalParameters.polLambdaStart, this.this$0.alchemicalParameters.polLambdaEnd));
            logger.info(sb.toString());
        }

        public void setFactors(int i, int k, LambdaMode mode) {
        }

        public void setFactors() {
        }
    }

    public class LambdaFactorsOST
    extends LambdaFactors {
        final /* synthetic */ ParticleMeshEwald this$0;

        public LambdaFactorsOST(ParticleMeshEwald this$0) {
            ParticleMeshEwald particleMeshEwald = this$0;
            Objects.requireNonNull(particleMeshEwald);
            this.this$0 = particleMeshEwald;
            super(this$0);
        }

        @Override
        public void setFactors() {
            this.lambdaProd = this.this$0.lambda;
            this.lfAlpha = this.this$0.alchemicalParameters.lAlpha;
            this.dlfAlpha = this.this$0.alchemicalParameters.dlAlpha;
            this.d2lfAlpha = this.this$0.alchemicalParameters.d2lAlpha;
            this.lfPowPerm = this.this$0.alchemicalParameters.permanentScale;
            this.dlfPowPerm = this.this$0.alchemicalParameters.dlPowPerm * this.this$0.alchemicalParameters.dEdLSign;
            this.d2lfPowPerm = this.this$0.alchemicalParameters.d2lPowPerm * this.this$0.alchemicalParameters.dEdLSign;
            this.lfPowPol = this.this$0.alchemicalParameters.polarizationScale;
            this.dlfPowPol = this.this$0.alchemicalParameters.dlPowPol * this.this$0.alchemicalParameters.dEdLSign;
            this.d2lfPowPol = this.this$0.alchemicalParameters.d2lPowPol * this.this$0.alchemicalParameters.dEdLSign;
        }
    }

    public class LambdaFactorsESV
    extends LambdaFactors {
        final /* synthetic */ ParticleMeshEwald this$0;

        public LambdaFactorsESV(ParticleMeshEwald this$0) {
            ParticleMeshEwald particleMeshEwald = this$0;
            Objects.requireNonNull(particleMeshEwald);
            this.this$0 = particleMeshEwald;
            super(this$0);
        }

        @Override
        public void setFactors(int i, int k, LambdaMode mode) {
            logger.info(String.format("Invoked Qi setFactors() method with i,k=%d,%d", i, k));
            this.ik[0] = i;
            this.ik[1] = k;
            double L = this.this$0.lambda;
            this.lambdaProd = L * this.this$0.perAtomTitrationESV[i] * this.this$0.perAtomTitrationESV[k];
            double esvli = this.this$0.perAtomTitrationESV[i];
            double esvlk = this.this$0.perAtomTitrationESV[k];
            this.dLpdL = esvli * esvlk;
            this.dLpdLi = L * esvlk;
            this.dLpdLk = L * esvli;
            double permLambdaExponent = this.this$0.alchemicalParameters.permLambdaExponent;
            double permLambdaStart = this.this$0.alchemicalParameters.permLambdaStart;
            double permLambdaEnd = this.this$0.alchemicalParameters.permLambdaEnd;
            double permWindow = 1.0 / (permLambdaEnd - permLambdaStart);
            double permLambda = (this.lambdaProd - permLambdaStart) * permWindow;
            this.lfPowPerm = FastMath.pow((double)permLambda, (double)this.this$0.alchemicalParameters.permLambdaExponent);
            this.dlfPowPerm = permLambdaExponent < 1.0 ? 0.0 : permLambdaExponent * FastMath.pow((double)permLambda, (double)(permLambdaExponent - 1.0)) * permWindow;
            this.d2lfPowPerm = permLambdaExponent < 2.0 ? 0.0 : permLambdaExponent * (permLambdaExponent - 1.0) * FastMath.pow((double)permLambda, (double)(permLambdaExponent - 2.0)) * permWindow * permWindow;
            double polLambdaExponent = this.this$0.alchemicalParameters.polLambdaExponent;
            double polLambdaStart = this.this$0.alchemicalParameters.polLambdaStart;
            double polLambdaEnd = this.this$0.alchemicalParameters.polLambdaEnd;
            double polWindow = 1.0 / (polLambdaEnd - polLambdaStart);
            double polLambda = (this.lambdaProd - polLambdaStart) * polWindow;
            this.lfPowPol = FastMath.pow((double)polLambda, (double)polLambdaExponent);
            this.dlfPowPol = polLambdaExponent < 1.0 ? 0.0 : polLambdaExponent * FastMath.pow((double)polLambda, (double)(polLambdaExponent - 1.0)) * polWindow;
            this.d2lfPowPol = polLambdaExponent < 2.0 ? 0.0 : polLambdaExponent * (polLambdaExponent - 1.0) * FastMath.pow((double)polLambda, (double)(polLambdaExponent - 2.0)) * polWindow * polWindow;
            double permLambdaAlpha = this.this$0.alchemicalParameters.permLambdaAlpha;
            this.lfAlpha = permLambdaAlpha * (1.0 - permLambda) * (1.0 - permLambda);
            this.dlfAlpha = permLambdaAlpha * (1.0 - permLambda) * permWindow;
            this.d2lfAlpha = -permLambdaAlpha * permWindow * permWindow;
            switch (mode) {
                case CONDENSED: {
                    this.lfPowPerm = 1.0 - this.lfPowPerm;
                    this.dlfPowPerm = -this.dlfPowPerm;
                    this.d2lfPowPerm = -this.d2lfPowPerm;
                    if (this.this$0.polarization == Polarization.NONE || this.this$0.lambda < polLambdaStart) {
                        this.lfPowPol = 0.0;
                        this.dlfPowPol = 0.0;
                        this.d2lfPowPol = 0.0;
                        break;
                    }
                    if (this.this$0.lambda <= polLambdaEnd) break;
                    this.lfPowPol = 1.0;
                    this.dlfPowPol = 0.0;
                    this.d2lfPowPol = 0.0;
                    break;
                }
                case CONDENSED_NO_LIGAND: {
                    this.lfPowPerm = 1.0 - this.lfPowPerm;
                    this.dlfPowPerm = -this.dlfPowPerm;
                    this.d2lfPowPerm = -this.d2lfPowPerm;
                    if (this.this$0.polarization == Polarization.NONE) {
                        this.lfPowPol = 0.0;
                        this.dlfPowPol = 0.0;
                        this.d2lfPowPol = 0.0;
                        break;
                    }
                    if (this.this$0.lambda <= polLambdaEnd) {
                        this.lfPowPol = 1.0 - this.lfPowPol;
                        this.dlfPowPol = -this.dlfPowPol;
                        this.d2lfPowPol = -this.d2lfPowPol;
                        break;
                    }
                    this.lfPowPol = 0.0;
                    this.dlfPowPol = 0.0;
                    this.d2lfPowPol = 0.0;
                    break;
                }
                case VAPOR: {
                    this.lfPowPerm = 1.0 - this.lfPowPerm;
                    this.dlfPowPerm = -this.dlfPowPerm;
                    this.d2lfPowPerm = -this.d2lfPowPerm;
                    this.lfAlpha = 0.0;
                    this.dlfAlpha = 0.0;
                    this.d2lfAlpha = 0.0;
                    if (this.this$0.polarization == Polarization.NONE || this.lambdaProd > polLambdaEnd) {
                        this.lfPowPol = 0.0;
                        this.dlfPowPol = 0.0;
                        this.d2lfPowPol = 0.0;
                        break;
                    }
                    if (!(this.lambdaProd <= polLambdaEnd)) break;
                    this.lfPowPol = 1.0 - this.lfPowPol;
                    this.dlfPowPol = -this.dlfPowPol;
                    this.d2lfPowPol = -this.d2lfPowPol;
                    break;
                }
            }
        }
    }
}

