/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedBoolean;
import edu.rit.pj.reduction.SharedInteger;
import edu.rit.util.Range;
import ffx.crystal.Crystal;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.PairwiseSchedule;
import ffx.potential.utils.PotentialsUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class NeighborList
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(NeighborList.class.getName());
    private final DomainDecomposition domainDecomposition;
    private final double cutoff;
    private final double buffer;
    private final double motion2;
    private final double cutoffPlusBuffer;
    private final double cutoffPlusBuffer2;
    private final ParallelTeam parallelTeam;
    private final int threadCount;
    private boolean forceRebuild = false;
    private boolean print = false;
    private final SharedBoolean sharedMotion;
    private final MotionLoop[] motionLoops;
    private final ListInitBarrierAction listInitBarrierAction;
    private final AssignAtomsToCellsLoop[] assignAtomsToCellsLoops;
    private final VerletListLoop[] verletListLoop;
    private final GroupVerletListLoop[] groupVerletListLoop;
    private long motionTime;
    private long initTime;
    private long assignAtomsToCellsTime;
    private long verletListTime;
    private long groupingTime;
    private final SharedInteger sharedCount;
    private final Range[] ranges;
    private Crystal crystal;
    private int nSymm;
    private int nAtoms;
    private double[][] coordinates;
    private double[] previous;
    private int[][][] lists;
    private int M = -1;
    private int[][] mGroups;
    private int numGroups;
    private int[] mGroupID;
    private int[][][] groupLists;
    private int[] listCount;
    private PairwiseSchedule pairwiseSchedule;
    private int asymmetricUnitCount;
    private int symmetryMateCount;
    private int groupAsymmetricUnitCount;
    private int groupSymmetryMateCount;
    private boolean[] use;
    private Atom[] atoms;
    private long time;
    private boolean intermolecular = true;
    private final boolean includeInactivePairs = true;
    private boolean disableUpdates = false;
    private static final int XX = 0;
    private static final int YY = 1;
    private static final int ZZ = 2;

    public NeighborList(Crystal crystal, Atom[] atoms, double cutoff, double buffer, ParallelTeam parallelTeam) {
        this.crystal = crystal;
        this.cutoff = cutoff;
        this.buffer = buffer;
        this.parallelTeam = new ParallelTeam(parallelTeam.getThreadCount());
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.cutoffPlusBuffer = cutoff + buffer;
        this.cutoffPlusBuffer2 = this.cutoffPlusBuffer * this.cutoffPlusBuffer;
        this.motion2 = buffer / 2.0 * (buffer / 2.0);
        this.threadCount = parallelTeam.getThreadCount();
        this.sharedCount = new SharedInteger();
        this.ranges = new Range[this.threadCount];
        this.sharedMotion = new SharedBoolean();
        this.motionLoops = new MotionLoop[this.threadCount];
        this.listInitBarrierAction = new ListInitBarrierAction(this);
        this.assignAtomsToCellsLoops = new AssignAtomsToCellsLoop[this.threadCount];
        this.verletListLoop = new VerletListLoop[this.threadCount];
        this.groupVerletListLoop = new GroupVerletListLoop[this.threadCount];
        for (int i = 0; i < this.threadCount; ++i) {
            this.motionLoops[i] = new MotionLoop(this);
            this.verletListLoop[i] = new VerletListLoop(this);
            this.assignAtomsToCellsLoops[i] = new AssignAtomsToCellsLoop(this);
            this.groupVerletListLoop[i] = new GroupVerletListLoop(this);
        }
        boolean print = logger.isLoggable(Level.FINE);
        this.domainDecomposition = new DomainDecomposition(this.nAtoms, crystal, this.cutoffPlusBuffer);
        this.initNeighborList(print);
    }

    public void buildList(double[][] coordinates, int[][][] lists, boolean[] use, boolean forceRebuild, boolean print) {
        if (this.disableUpdates) {
            return;
        }
        this.coordinates = coordinates;
        this.lists = lists;
        this.use = use;
        this.forceRebuild = forceRebuild;
        this.print = print;
        try {
            this.parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = "Fatal exception building neighbor list.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void setGroupSize(int M) {
        this.M = M;
    }

    public void destroy() throws Exception {
        this.parallelTeam.shutdown();
    }

    public void finish() {
        int i;
        int iSymm;
        int i2;
        if (this.disableUpdates) {
            return;
        }
        if (!this.forceRebuild && !this.sharedMotion.get()) {
            return;
        }
        int atomsWithIteractions = 0;
        this.asymmetricUnitCount = 0;
        this.symmetryMateCount = 0;
        int[][] list = this.lists[0];
        for (i2 = 0; i2 < this.nAtoms; ++i2) {
            this.asymmetricUnitCount += list[i2].length;
            if (this.listCount[i2] <= 0) continue;
            ++atomsWithIteractions;
        }
        for (iSymm = 1; iSymm < this.nSymm; ++iSymm) {
            list = this.lists[iSymm];
            for (i = 0; i < this.nAtoms; ++i) {
                this.symmetryMateCount += list[i].length;
            }
        }
        this.groupAsymmetricUnitCount = 0;
        this.groupSymmetryMateCount = 0;
        if (this.M > 1) {
            list = this.groupLists[0];
            for (i2 = 0; i2 < this.numGroups; ++i2) {
                this.groupAsymmetricUnitCount += list[i2].length;
            }
            for (iSymm = 1; iSymm < this.nSymm; ++iSymm) {
                list = this.groupLists[iSymm];
                for (i = 0; i < this.numGroups; ++i) {
                    this.groupSymmetryMateCount += list[i].length;
                }
            }
        }
        if (this.print) {
            this.print();
        }
        long scheduleTime = -System.nanoTime();
        this.pairwiseSchedule.updateRanges(this.sharedCount.get(), atomsWithIteractions, this.listCount);
        scheduleTime += System.nanoTime();
        if (logger.isLoggable(Level.FINE)) {
            this.time = System.nanoTime() - this.time;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("   Motion Check:           %6.4f sec\n", (double)this.motionTime * 1.0E-9));
            sb.append(String.format("   List Initialization:    %6.4f sec\n", (double)this.initTime * 1.0E-9));
            sb.append(String.format("   Assign Atoms to Cells:  %6.4f sec\n", (double)this.assignAtomsToCellsTime * 1.0E-9));
            sb.append(String.format("   Create Vertlet Lists:   %6.4f sec\n", (double)this.verletListTime * 1.0E-9));
            sb.append(String.format("   Parallel Schedule:      %6.4f sec\n", (double)scheduleTime * 1.0E-9));
            if (this.M >= 1) {
                sb.append(String.format("   Group List Total:       %6.4f sec\n", (double)this.groupingTime * 1.0E-9));
            }
            sb.append(String.format("   Neighbor List Total:    %6.4f sec\n", (double)this.time * 1.0E-9));
            logger.fine(sb.toString());
        }
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public void setDisableUpdates(boolean disableUpdate) {
        this.disableUpdates = disableUpdate;
    }

    public int[][][] getNeighborList() {
        return this.lists;
    }

    public PairwiseSchedule getPairwiseSchedule() {
        return this.pairwiseSchedule;
    }

    public void run() {
        if (this.disableUpdates) {
            return;
        }
        int threadIndex = this.getThreadIndex();
        try {
            if (!this.forceRebuild) {
                if (threadIndex == 0) {
                    this.motionTime = -System.nanoTime();
                }
                this.execute(0, this.nAtoms - 1, this.motionLoops[threadIndex]);
                if (threadIndex == 0) {
                    this.motionTime += System.nanoTime();
                }
            }
            if (this.forceRebuild || this.sharedMotion.get()) {
                this.barrier(this.listInitBarrierAction);
                if (threadIndex == 0) {
                    this.assignAtomsToCellsTime = -System.nanoTime();
                }
                this.execute(0, this.nAtoms - 1, this.assignAtomsToCellsLoops[threadIndex]);
                if (threadIndex == 0) {
                    this.assignAtomsToCellsTime += System.nanoTime();
                }
                if (threadIndex == 0) {
                    this.verletListTime = -System.nanoTime();
                }
                this.execute(0, this.nAtoms - 1, this.verletListLoop[threadIndex]);
                if (threadIndex == 0) {
                    this.verletListTime += System.nanoTime();
                }
                if (this.M > 1) {
                    if (threadIndex == 0) {
                        this.groupingTime = -System.nanoTime();
                        this.mGroups = this.buildGroups();
                        this.numGroups = this.mGroups.length;
                        this.mGroupID = this.assignGroupID(this.mGroups);
                        this.groupLists = new int[this.nSymm][this.numGroups][];
                    }
                    this.barrier();
                    this.execute(0, this.mGroups.length - 1, this.groupVerletListLoop[threadIndex]);
                    if (threadIndex == 0) {
                        this.groupingTime += System.nanoTime();
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "Fatal exception building neighbor list in thread: " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private int[][] buildGroups() {
        int nA = this.domainDecomposition.nA;
        int nB = this.domainDecomposition.nB;
        int nC = this.domainDecomposition.nC;
        ArrayList<int[]> groupsList = new ArrayList<int[]>();
        int[] group = new int[this.M];
        for (int i = 0; i < nA; ++i) {
            for (int j = 0; j < nB; ++j) {
                PriorityQueue<AtomIndex> queue = new PriorityQueue<AtomIndex>();
                for (int k = 0; k < nC; ++k) {
                    Cell cell = this.domainDecomposition.getCell(i, j, k);
                    for (AtomIndex atomIndex : cell.list) {
                        if (atomIndex.iSymm != 0) continue;
                        queue.add(atomIndex);
                        while (queue.size() >= this.M) {
                            for (int m = 0; m < this.M; ++m) {
                                AtomIndex atom = (AtomIndex)queue.poll();
                                group[m] = atom.i;
                            }
                            groupsList.add(group);
                            group = new int[this.M];
                        }
                    }
                }
                if (queue.isEmpty()) continue;
                Arrays.fill(group, -1);
                for (int l = 0; l < this.M; ++l) {
                    if (queue.isEmpty()) continue;
                    AtomIndex atom = (AtomIndex)queue.poll();
                    group[l] = atom.i;
                }
                groupsList.add(group);
                group = new int[this.M];
            }
        }
        int numGroups = groupsList.size();
        int[][] groups = new int[groupsList.size()][];
        for (int i = 0; i < numGroups; ++i) {
            groups[i] = (int[])groupsList.get(i);
        }
        return groups;
    }

    private int[] assignGroupID(int[][] groups) {
        int nGroups = groups.length;
        int[] groupID = new int[this.nAtoms];
        for (int i = 0; i < nGroups; ++i) {
            int[] group;
            for (int atomIndex : group = groups[i]) {
                if (atomIndex < 0) continue;
                groupID[atomIndex] = i;
            }
        }
        return groupID;
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.initNeighborList(false);
    }

    public void setCrystal(Crystal crystal) {
        this.crystal = crystal;
        this.initNeighborList(false);
    }

    public void setIntermolecular(boolean intermolecular) {
        this.intermolecular = intermolecular;
    }

    public void start() {
        if (this.disableUpdates) {
            return;
        }
        this.time = System.nanoTime();
        this.motionTime = 0L;
        this.initTime = 0L;
        this.assignAtomsToCellsTime = 0L;
        this.verletListTime = 0L;
        this.sharedMotion.set(false);
    }

    private void initNeighborList(boolean print) {
        int newNSymm = this.crystal.spaceGroup.symOps.size();
        if (this.nSymm != newNSymm) {
            this.nSymm = newNSymm;
        }
        if (this.previous == null || this.previous.length < 3 * this.nAtoms) {
            this.previous = new double[3 * this.nAtoms];
            this.listCount = new int[this.nAtoms];
            this.pairwiseSchedule = new PairwiseSchedule(this.threadCount, this.nAtoms, this.ranges);
        } else {
            this.pairwiseSchedule.setAtoms(this.nAtoms);
        }
        double sphere = FastMath.min((double)FastMath.min((double)this.crystal.interfacialRadiusA, (double)this.crystal.interfacialRadiusB), (double)this.crystal.interfacialRadiusC);
        if (!this.crystal.aperiodic()) assert (sphere >= this.cutoffPlusBuffer);
        this.domainDecomposition.initDomainDecomposition(this.nAtoms, this.crystal);
        if (print) {
            this.domainDecomposition.log();
        }
    }

    private void print() {
        int num;
        StringBuilder sb = new StringBuilder(String.format("   Buffer:                                %5.2f (A)\n", this.buffer));
        sb.append(String.format("   Cut-off:                               %5.2f (A)\n", this.cutoff));
        sb.append(String.format("   Total:                                 %5.2f (A)\n", this.cutoffPlusBuffer));
        sb.append(String.format("   Neighbors in the asymmetric unit:%11d\n", this.asymmetricUnitCount));
        if (this.nSymm > 1) {
            sb.append(String.format("   Neighbors in symmetry mates:    %12d\n", this.symmetryMateCount));
            num = (this.asymmetricUnitCount + this.symmetryMateCount) * this.nSymm;
            sb.append(String.format("   Neighbors in the unit cell:     %12d\n", num));
        }
        if (this.M > 1) {
            sb.append(String.format("   Number of groups:                  %9d\n", this.numGroups));
            sb.append(String.format("   Group pairs in the asymmetric unit:%9d\n", this.groupAsymmetricUnitCount));
            if (this.nSymm > 1) {
                sb.append(String.format("   Group pairs in symmetry mates:  %12d\n", this.groupSymmetryMateCount));
                num = (this.groupAsymmetricUnitCount + this.groupSymmetryMateCount) * this.nSymm;
                sb.append(String.format("   Group pairs in the unit cell:   %12d\n", num));
            }
        }
        logger.info(sb.toString());
    }

    private boolean isIncludedInLowerIDList(int symOp, int smallerGroupIndex, int secondGroup) {
        if (smallerGroupIndex >= secondGroup) {
            return false;
        }
        for (int a = 0; a < this.M; ++a) {
            int[] neighborList;
            int atomID = this.mGroups[smallerGroupIndex][a];
            if (atomID == -1) continue;
            for (int value : neighborList = this.lists[symOp][atomID]) {
                int neighborGroupID = this.mGroupID[value];
                if (neighborGroupID != secondGroup) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        PotentialsUtils potentialsUtils = new PotentialsUtils();
        File xyzFile = new File("./examples/waterbox.xyz");
        if (!xyzFile.exists()) {
            System.out.println("File does not exist");
        }
        MolecularAssembly molecularAssembly = potentialsUtils.open(xyzFile);
        molecularAssembly.getPotentialEnergy().energy(null, true);
    }

    private class MotionLoop
    extends IntegerForLoop {
        final /* synthetic */ NeighborList this$0;

        private MotionLoop(NeighborList neighborList) {
            NeighborList neighborList2 = neighborList;
            Objects.requireNonNull(neighborList2);
            this.this$0 = neighborList2;
        }

        public void run(int lb, int ub) {
            double[] current = this.this$0.coordinates[0];
            for (int i = lb; i <= ub; ++i) {
                int i3 = i * 3;
                int iX = i3 + 0;
                double dx = this.this$0.previous[iX] - current[iX];
                int iY = i3 + 1;
                double dy = this.this$0.previous[iY] - current[iY];
                int iZ = i3 + 2;
                double dz = this.this$0.previous[iZ] - current[iZ];
                double dr2 = this.this$0.crystal.image(dx, dy, dz);
                if (!(dr2 > this.this$0.motion2)) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Motion detected for atom %d (%8.6f A).", i, FastMath.sqrt((double)dr2)));
                }
                this.this$0.sharedMotion.set(true);
            }
        }
    }

    private class ListInitBarrierAction
    extends BarrierAction {
        final /* synthetic */ NeighborList this$0;

        private ListInitBarrierAction(NeighborList neighborList) {
            NeighborList neighborList2 = neighborList;
            Objects.requireNonNull(neighborList2);
            this.this$0 = neighborList2;
        }

        public void run() {
            this.this$0.initTime = -System.nanoTime();
            this.this$0.sharedCount.set(0);
            this.this$0.domainDecomposition.clear();
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                if (this.this$0.lists[iSymm] != null && this.this$0.lists[iSymm].length >= this.this$0.nAtoms) continue;
                this.this$0.lists[iSymm] = new int[this.this$0.nAtoms][];
            }
            this.this$0.initTime += System.nanoTime();
        }
    }

    private class AssignAtomsToCellsLoop
    extends IntegerForLoop {
        private final double[] auCart;
        private final double[] cart;
        private final double[] frac;
        final /* synthetic */ NeighborList this$0;

        private AssignAtomsToCellsLoop(NeighborList neighborList) {
            NeighborList neighborList2 = neighborList;
            Objects.requireNonNull(neighborList2);
            this.this$0 = neighborList2;
            this.auCart = new double[3];
            this.cart = new double[3];
            this.frac = new double[3];
        }

        public void run(int lb, int ub) {
            double[] current = this.this$0.coordinates[0];
            for (int i = lb; i <= ub; ++i) {
                int i3 = i * 3;
                int iX = i3 + 0;
                int iY = i3 + 1;
                int iZ = i3 + 2;
                this.this$0.previous[iX] = current[iX];
                this.this$0.previous[iY] = current[iY];
                this.this$0.previous[iZ] = current[iZ];
            }
            double[] auXYZ = this.this$0.coordinates[0];
            double spCutoff2 = this.this$0.crystal.getSpecialPositionCutoff2();
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                double[] xyz = this.this$0.coordinates[iSymm];
                for (int i = lb; i <= ub; ++i) {
                    int i3 = i * 3;
                    this.cart[0] = xyz[i3 + 0];
                    this.cart[1] = xyz[i3 + 1];
                    this.cart[2] = xyz[i3 + 2];
                    if (iSymm != 0) {
                        this.auCart[0] = auXYZ[i3 + 0];
                        this.auCart[1] = auXYZ[i3 + 1];
                        this.auCart[2] = auXYZ[i3 + 2];
                        double dx = this.auCart[0] - this.cart[0];
                        double dy = this.auCart[1] - this.cart[1];
                        double dz = this.auCart[2] - this.cart[2];
                        double dr2 = this.this$0.crystal.image(dx, dy, dz);
                        if (dr2 < spCutoff2) {
                            int molecule = this.this$0.atoms[i].getMoleculeNumber();
                            if (this.this$0.atoms[i].isActive()) {
                                logger.info(String.format("   Active Atom %s at Special Position in Molecule %d with SymOp %d (%8.6f A).", this.this$0.atoms[i], molecule, iSymm, FastMath.sqrt((double)dr2)));
                            } else if (logger.isLoggable(Level.FINE)) {
                                logger.fine(String.format("   Atom %s at Special Position in Molecule %d with SymOp %d (%8.6f A).", this.this$0.atoms[i], molecule, iSymm, FastMath.sqrt((double)dr2)));
                            }
                            this.this$0.domainDecomposition.addSpecialPositionExclusion(molecule, iSymm);
                        }
                    }
                    this.this$0.crystal.toFractionalCoordinates(this.cart, this.frac);
                    this.this$0.domainDecomposition.addAtomToCell(i, iSymm, this.frac);
                }
            }
        }
    }

    private class VerletListLoop
    extends IntegerForLoop {
        private final IntegerSchedule schedule;
        private int n;
        private int iSymm;
        private int atomIndex;
        private boolean iactive;
        private int count;
        private double[] xyz;
        private int[] pairs;
        private Cell cellForCurrentAtom;
        private int[] pairCellAtoms;
        final /* synthetic */ NeighborList this$0;

        VerletListLoop(NeighborList neighborList) {
            NeighborList neighborList2 = neighborList;
            Objects.requireNonNull(neighborList2);
            this.this$0 = neighborList2;
            this.iactive = true;
            int len = 1000;
            this.pairs = new int[len];
            this.schedule = IntegerSchedule.dynamic((int)10);
            this.pairCellAtoms = new int[len];
        }

        public void finish() {
            this.this$0.sharedCount.addAndGet(this.count);
        }

        public void run(int lb, int ub) {
            int nEdge = this.this$0.domainDecomposition.nEdge;
            int nA = this.this$0.domainDecomposition.nA;
            int nB = this.this$0.domainDecomposition.nB;
            int nC = this.this$0.domainDecomposition.nC;
            this.iSymm = 0;
            while (this.iSymm < this.this$0.nSymm) {
                int[][] list = this.this$0.lists[this.iSymm];
                this.atomIndex = lb;
                while (this.atomIndex <= ub) {
                    this.n = 0;
                    if (this.iSymm == 0) {
                        this.this$0.listCount[this.atomIndex] = 0;
                        int molecule = this.this$0.atoms[this.atomIndex].getMoleculeNumber();
                        List<Integer> symOpList = this.this$0.domainDecomposition.getSpecialPositionSymOps(molecule);
                        this.this$0.atoms[this.atomIndex].setSpecialPositionSymOps(symOpList);
                    }
                    if (this.this$0.use == null || this.this$0.use[this.atomIndex]) {
                        int cStop;
                        this.iactive = this.this$0.atoms[this.atomIndex].isActive();
                        this.cellForCurrentAtom = this.this$0.domainDecomposition.getCellForAtom(this.atomIndex);
                        int a = this.cellForCurrentAtom.a;
                        int b = this.cellForCurrentAtom.b;
                        int c = this.cellForCurrentAtom.c;
                        int a1 = a + 1;
                        int b1 = b + 1;
                        int c1 = c + 1;
                        int aStart = nA == 1 ? a : a - nEdge;
                        int aStop = nA == 1 ? a : a + nEdge;
                        int bStart = nB == 1 ? b : b - nEdge;
                        int bStop = nB == 1 ? b : b + nEdge;
                        int cStart = nC == 1 ? c : c - nEdge;
                        int n = cStop = nC == 1 ? c : c + nEdge;
                        if (this.iSymm == 0) {
                            int ci;
                            int bi;
                            this.atomCellPairs(this.cellForCurrentAtom);
                            for (bi = b1; bi <= bStop; ++bi) {
                                this.atomCellPairs(this.this$0.domainDecomposition.image(a, bi, c));
                            }
                            for (bi = bStart; bi <= bStop; ++bi) {
                                for (ci = c1; ci <= cStop; ++ci) {
                                    this.atomCellPairs(this.this$0.domainDecomposition.image(a, bi, ci));
                                }
                            }
                            for (bi = bStart; bi <= bStop; ++bi) {
                                for (ci = cStart; ci <= cStop; ++ci) {
                                    for (int ai = a1; ai <= aStop; ++ai) {
                                        this.atomCellPairs(this.this$0.domainDecomposition.image(ai, bi, ci));
                                    }
                                }
                            }
                        } else {
                            for (int ai = aStart; ai <= aStop; ++ai) {
                                for (int bi = bStart; bi <= bStop; ++bi) {
                                    for (int ci = cStart; ci <= cStop; ++ci) {
                                        this.atomCellPairs(this.this$0.domainDecomposition.image(ai, bi, ci));
                                    }
                                }
                            }
                        }
                    }
                    list[this.atomIndex] = new int[this.n];
                    int n = this.atomIndex;
                    this.this$0.listCount[n] = this.this$0.listCount[n] + this.n;
                    this.count += this.n;
                    System.arraycopy(this.pairs, 0, list[this.atomIndex], 0, this.n);
                    ++this.atomIndex;
                }
                ++this.iSymm;
            }
        }

        public IntegerSchedule schedule() {
            return this.schedule;
        }

        public void start() {
            this.xyz = this.this$0.coordinates[0];
            this.count = 0;
        }

        private void atomCellPairs(Cell cell) {
            int num;
            if (this.pairCellAtoms.length < cell.getCount()) {
                this.pairCellAtoms = new int[cell.getCount()];
            }
            if ((num = cell.getSymOpAtoms(this.iSymm, this.pairCellAtoms)) == 0) {
                return;
            }
            int moleculeIndex = this.this$0.atoms[this.atomIndex].getMoleculeNumber();
            boolean logClosePairs = logger.isLoggable(Level.FINE);
            int i3 = this.atomIndex * 3;
            double xi = this.xyz[i3 + 0];
            double yi = this.xyz[i3 + 1];
            double zi = this.xyz[i3 + 2];
            double[] pair = this.this$0.coordinates[this.iSymm];
            for (int j = 0; j < num; ++j) {
                double zj;
                double zr;
                double yj;
                double yr;
                int aj3;
                double xj;
                double xr;
                double d2;
                int aj = this.pairCellAtoms[j];
                if (this.iSymm == 0 && cell == this.cellForCurrentAtom && aj <= this.atomIndex || this.this$0.use != null && !this.this$0.use[aj]) continue;
                int moleculeIndexJ = this.this$0.atoms[aj].getMoleculeNumber();
                if (!this.this$0.intermolecular && moleculeIndex != moleculeIndexJ) continue;
                if (this.iSymm != 0 && moleculeIndex == moleculeIndexJ && this.this$0.domainDecomposition.isSpecialPositionExclusion(moleculeIndex, this.iSymm)) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.finest(String.format("   Excluding Interaction for Atoms %d and %d in Molecule %d for SymOp %d.", this.atomIndex, aj, moleculeIndex, this.iSymm));
                    continue;
                }
                if (this.iSymm != 0 && aj < this.atomIndex || !((d2 = this.this$0.crystal.image(xr = xi - (xj = pair[(aj3 = aj * 3) + 0]), yr = yi - (yj = pair[aj3 + 1]), zr = zi - (zj = pair[aj3 + 2]))) <= this.this$0.cutoffPlusBuffer2)) continue;
                if (logClosePairs && d2 < this.this$0.crystal.getSpecialPositionCutoff2()) {
                    logger.fine(String.format(" Close interaction (%6.3f) between atoms (iSymm = %d):\n %s\n %s\n", FastMath.sqrt((double)d2), this.iSymm, this.this$0.atoms[this.atomIndex].toString(), this.this$0.atoms[aj].toString()));
                }
                try {
                    this.pairs[this.n++] = aj;
                    continue;
                }
                catch (Exception e) {
                    this.n = this.pairs.length;
                    this.pairs = Arrays.copyOf(this.pairs, this.n + 100);
                    this.pairs[this.n++] = aj;
                }
            }
        }
    }

    private class GroupVerletListLoop
    extends IntegerForLoop {
        private final IntegerSchedule schedule;
        final /* synthetic */ NeighborList this$0;

        private GroupVerletListLoop(NeighborList neighborList) {
            NeighborList neighborList2 = neighborList;
            Objects.requireNonNull(neighborList2);
            this.this$0 = neighborList2;
            this.schedule = IntegerSchedule.dynamic((int)10);
        }

        public IntegerSchedule schedule() {
            return this.schedule;
        }

        public void run(int lb, int ub) {
            ArrayList<Integer> neighborGroups = new ArrayList<Integer>();
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                for (int groupIndex = lb; groupIndex <= ub; ++groupIndex) {
                    for (int a = 0; a < this.this$0.M; ++a) {
                        int[] neighborList;
                        int atomIndex = this.this$0.mGroups[groupIndex][a];
                        if (atomIndex == -1) continue;
                        for (int value : neighborList = this.this$0.lists[iSymm][atomIndex]) {
                            int neighborGroupIndex = this.this$0.mGroupID[value];
                            if (neighborGroups.contains(neighborGroupIndex)) continue;
                            if (groupIndex <= neighborGroupIndex) {
                                neighborGroups.add(neighborGroupIndex);
                                continue;
                            }
                            if (neighborGroupIndex >= lb) {
                                int[] list = this.this$0.groupLists[iSymm][neighborGroupIndex];
                                boolean included = false;
                                for (int neighbor : list) {
                                    if (neighbor != groupIndex) continue;
                                    included = true;
                                    break;
                                }
                                if (included) continue;
                                neighborGroups.add(neighborGroupIndex);
                                continue;
                            }
                            if (this.this$0.isIncludedInLowerIDList(iSymm, neighborGroupIndex, groupIndex)) continue;
                            neighborGroups.add(neighborGroupIndex);
                        }
                    }
                    this.this$0.groupLists[iSymm][groupIndex] = neighborGroups.stream().mapToInt(Integer::intValue).toArray();
                    neighborGroups.clear();
                }
            }
        }
    }

    private static class DomainDecomposition {
        private Crystal crystal;
        private final double targetInterfacialRadius;
        private final int nEdge;
        private final int nSearch;
        private int nA;
        private int nB;
        private int nC;
        private int nAtoms;
        private int[] cellA;
        private int[] cellB;
        private int[] cellC;
        private Cell[][][] cells;
        private Map<Integer, List<Integer>> specialPositionExclusionMap;

        public DomainDecomposition(int nAtoms, Crystal crystal, double cutoffPlusBuffer) {
            this.nEdge = 2;
            this.nSearch = 2 * this.nEdge + 1;
            this.targetInterfacialRadius = cutoffPlusBuffer / (double)this.nEdge;
            this.initDomainDecomposition(nAtoms, crystal);
        }

        public void initDomainDecomposition(int nAtoms, Crystal crystal) {
            this.nAtoms = nAtoms;
            this.crystal = crystal;
            if (this.cellA == null || this.cellA.length < nAtoms) {
                this.cellA = new int[nAtoms];
                this.cellB = new int[nAtoms];
                this.cellC = new int[nAtoms];
            }
            int maxA = (int)FastMath.floor((double)(2.0 * crystal.interfacialRadiusA / this.targetInterfacialRadius));
            int maxB = (int)FastMath.floor((double)(2.0 * crystal.interfacialRadiusB / this.targetInterfacialRadius));
            int maxC = (int)FastMath.floor((double)(2.0 * crystal.interfacialRadiusC / this.targetInterfacialRadius));
            if (!crystal.aperiodic()) {
                assert (maxA >= this.nSearch - 1);
                assert (maxB >= this.nSearch - 1);
                assert (maxC >= this.nSearch - 1);
            }
            this.nA = maxA < this.nSearch ? 1 : maxA;
            this.nB = maxB < this.nSearch ? 1 : maxB;
            int n = this.nC = maxC < this.nSearch ? 1 : maxC;
            if (this.cells == null || this.cells.length != this.nA || this.cells[0].length != this.nB || this.cells[0][0].length != this.nC) {
                this.cells = new Cell[this.nA][this.nB][this.nC];
                for (int i = 0; i < this.nA; ++i) {
                    for (int j = 0; j < this.nB; ++j) {
                        for (int k = 0; k < this.nC; ++k) {
                            this.cells[i][j][k] = new Cell(i, j, k);
                        }
                    }
                }
            } else {
                this.clear();
            }
        }

        public void clear() {
            for (int i = 0; i < this.nA; ++i) {
                for (int j = 0; j < this.nB; ++j) {
                    for (int k = 0; k < this.nC; ++k) {
                        this.cells[i][j][k].clear();
                    }
                }
            }
        }

        public void addSpecialPositionExclusion(int molecule, int symOpIndex) {
            List<Integer> list;
            if (this.specialPositionExclusionMap == null) {
                this.specialPositionExclusionMap = new HashMap<Integer, List<Integer>>();
            }
            if ((list = this.specialPositionExclusionMap.get(molecule)) == null) {
                list = new ArrayList<Integer>();
                this.specialPositionExclusionMap.put(molecule, list);
            }
            if (!list.contains(symOpIndex)) {
                list.add(symOpIndex);
            }
        }

        public boolean isSpecialPositionExclusion(int molecule, int symOpIndex) {
            if (this.specialPositionExclusionMap == null) {
                return false;
            }
            List<Integer> list = this.specialPositionExclusionMap.get(molecule);
            if (list == null) {
                return false;
            }
            return list.contains(symOpIndex);
        }

        public List<Integer> getSpecialPositionSymOps(int molecule) {
            if (this.specialPositionExclusionMap == null) {
                return null;
            }
            if (this.specialPositionExclusionMap.containsKey(molecule)) {
                List<Integer> list = this.specialPositionExclusionMap.get(molecule);
                if (list.isEmpty()) {
                    return null;
                }
                return list;
            }
            return null;
        }

        public void log() {
            int nCells = this.nA * this.nB * this.nC;
            int nSymm = this.crystal.spaceGroup.getNumberOfSymOps();
            StringBuilder sb = new StringBuilder("  Neighbor List Builder\n");
            sb.append(String.format("   Total Cells:          %8d\n", nCells));
            if (nCells > 1) {
                sb.append(String.format("   Interfacial radius    %8.3f A\n", this.targetInterfacialRadius));
                int searchA = this.nA == 1 ? 1 : this.nSearch;
                int searchB = this.nB == 1 ? 1 : this.nSearch;
                int searchC = this.nC == 1 ? 1 : this.nSearch;
                sb.append(String.format("   Domain Decomposition: %8d %4d %4d\n", this.nA, this.nB, this.nC));
                sb.append(String.format("   Neighbor Search:      %8d x%3d x%3d\n", searchA, searchB, searchC));
                sb.append(String.format("   Mean Atoms per Cell:  %8d", this.nAtoms * nSymm / nCells));
            }
            logger.info(sb.toString());
        }

        public Cell image(int i, int j, int k) {
            if (i >= this.nA) {
                i -= this.nA;
            } else if (i < 0) {
                i += this.nA;
            }
            if (j >= this.nB) {
                j -= this.nB;
            } else if (j < 0) {
                j += this.nB;
            }
            if (k >= this.nC) {
                k -= this.nC;
            } else if (k < 0) {
                k += this.nC;
            }
            return this.cells[i][j][k];
        }

        public void addAtomToCell(int i, int iSymm, double[] frac) {
            double xu;
            double yu = frac[1];
            double zu = frac[2];
            for (xu = frac[0]; xu < 0.0; xu += 1.0) {
            }
            while (xu >= 1.0) {
                xu -= 1.0;
            }
            while (yu < 0.0) {
                yu += 1.0;
            }
            while (yu >= 1.0) {
                yu -= 1.0;
            }
            while (zu < 0.0) {
                zu += 1.0;
            }
            while (zu >= 1.0) {
                zu -= 1.0;
            }
            int a = (int)FastMath.floor((double)(xu * (double)this.nA));
            int b = (int)FastMath.floor((double)(yu * (double)this.nB));
            int c = (int)FastMath.floor((double)(zu * (double)this.nC));
            if (iSymm == 0) {
                this.cellA[i] = a;
                this.cellB[i] = b;
                this.cellC[i] = c;
            }
            this.cells[a][b][c].add(i, iSymm, zu);
        }

        public Cell getCellForAtom(int i) {
            return this.cells[this.cellA[i]][this.cellB[i]][this.cellC[i]];
        }

        public Cell getCell(int a, int b, int c) {
            if (a < 0 || a >= this.nA || b < 0 || b >= this.nB || c < 0 || c >= this.nC) {
                return null;
            }
            return this.cells[a][b][c];
        }
    }

    public static class Cell {
        final int a;
        final int b;
        final int c;
        final List<AtomIndex> list;
        final Set<Integer> groupList;

        public Cell(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.list = Collections.synchronizedList(new ArrayList());
            this.groupList = Collections.synchronizedSet(new HashSet());
        }

        public void add(int atomIndex, int symOpIndex, double z) {
            this.list.add(new AtomIndex(symOpIndex, atomIndex, z));
        }

        public void groupAdd(int groupIndex) {
            this.groupList.add(groupIndex);
        }

        public AtomIndex get(int index) {
            if (index >= this.list.size()) {
                return null;
            }
            return this.list.get(index);
        }

        public int getCount() {
            return this.list.size();
        }

        public int getGroupCount() {
            return this.groupList.size();
        }

        public int getSymOpAtoms(int symOpIndex, int[] index) {
            int count = 0;
            for (AtomIndex atomIndex : this.list) {
                if (atomIndex.iSymm != symOpIndex) continue;
                if (count >= index.length) {
                    throw new IndexOutOfBoundsException("Index out of bounds: count " + count + " " + index.length + " " + this.list.size());
                }
                index[count++] = atomIndex.i;
            }
            return count;
        }

        public void clear() {
            this.list.clear();
        }
    }

    public static class AtomIndex
    implements Comparable<AtomIndex> {
        public final int iSymm;
        public final int i;
        public final double z;

        public AtomIndex(int iSymm, int i, double z) {
            this.iSymm = iSymm;
            this.i = i;
            this.z = z;
        }

        @Override
        public int compareTo(AtomIndex o) {
            return Double.compare(this.z, o.z);
        }
    }
}

