/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import ffx.crystal.Crystal;
import ffx.crystal.SpaceGroup;
import ffx.crystal.SymOp;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.ForceField;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class NCSRestraint
implements LambdaInterface {
    private static final Logger logger = Logger.getLogger(NCSRestraint.class.getName());
    private final Atom[] atoms;
    private final double forceConstant = 10.0;
    private final double[][] transOp = new double[3][3];
    private final double[] a1 = new double[3];
    private final double[] a2 = new double[3];
    private final double[] dx = new double[3];
    private final double lambdaExp = 2.0;
    private final double[] lambdaGradient;
    private Crystal ncsCrystal;
    private SpaceGroup spaceGroup;
    private int nAtoms;
    private int nSymm;
    private double lambda = 1.0;
    private double lambdaPow = FastMath.pow((double)this.lambda, (double)2.0);
    private double dLambdaPow = 2.0 * FastMath.pow((double)this.lambda, (double)1.0);
    private double d2LambdaPow = 2.0 * FastMath.pow((double)this.lambda, (double)0.0);
    private double dEdL = 0.0;
    private double d2EdL2 = 0.0;
    private boolean lambdaTerm;

    public NCSRestraint(Atom[] atoms, ForceField forceField, Crystal crystal) {
        this.ncsCrystal = crystal;
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.spaceGroup = this.ncsCrystal.spaceGroup;
        this.nSymm = this.spaceGroup.getNumberOfSymOps();
        assert (this.nAtoms % this.nSymm == 0);
        this.lambdaTerm = forceField.getBoolean("LAMBDATERM", false);
        if (this.lambdaTerm) {
            this.lambdaGradient = new double[this.nAtoms * 3];
        } else {
            this.lambdaGradient = null;
            this.lambda = 1.0;
            this.lambdaPow = 1.0;
            this.dLambdaPow = 0.0;
            this.d2LambdaPow = 0.0;
        }
        logger.info(String.format("\n NCS Restraint%s", crystal));
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.lambdaTerm) {
            this.lambda = lambda;
            double lambdaWindow = 1.0;
            if (this.lambda < lambdaWindow) {
                double dldgl = 1.0 / lambdaWindow;
                double l = dldgl * this.lambda;
                double l2 = l * l;
                double l3 = l2 * l;
                double l4 = l2 * l2;
                double l5 = l4 * l;
                double c3 = 10.0;
                double c4 = -15.0;
                double c5 = 6.0;
                double threeC3 = 3.0 * c3;
                double sixC3 = 6.0 * c3;
                double fourC4 = 4.0 * c4;
                double twelveC4 = 12.0 * c4;
                double fiveC5 = 5.0 * c5;
                double twentyC5 = 20.0 * c5;
                this.lambdaPow = c3 * l3 + c4 * l4 + c5 * l5;
                this.dLambdaPow = (threeC3 * l2 + fourC4 * l3 + fiveC5 * l4) * dldgl;
                this.d2LambdaPow = (sixC3 * l + twelveC4 * l2 + twentyC5 * l3) * dldgl * dldgl;
            } else {
                this.lambdaPow = 1.0;
                this.dLambdaPow = 0.0;
                this.d2LambdaPow = 0.0;
            }
        } else {
            this.lambda = 1.0;
            this.lambdaPow = 1.0;
            this.dLambdaPow = 0.0;
            this.d2LambdaPow = 0.0;
        }
    }

    @Override
    public double getd2EdL2() {
        if (this.lambdaTerm) {
            return this.d2EdL2;
        }
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
        if (this.lambdaTerm) {
            int n3 = this.nAtoms * 3;
            for (int i = 0; i < n3; ++i) {
                int n = i;
                gradient[n] = gradient[n] + this.lambdaGradient[i];
            }
        }
    }

    public double residual(boolean gradient, boolean print) {
        if (this.nAtoms % this.nSymm != 0) {
            return 0.0;
        }
        if (this.lambdaTerm) {
            this.dEdL = 0.0;
            this.d2EdL2 = 0.0;
            Arrays.fill(this.lambdaGradient, 0.0);
        }
        double residual = 0.0;
        int nAsymmAtoms = this.nAtoms / this.nSymm;
        double fx2 = 20.0;
        for (int i = 1; i < this.nSymm; ++i) {
            SymOp symOp = this.spaceGroup.getSymOp(i);
            this.ncsCrystal.getTransformationOperator(symOp, this.transOp);
            int offset = nAsymmAtoms * i;
            for (int j = 0; j < nAsymmAtoms; ++j) {
                int oj3;
                int j3;
                Atom atom1 = this.atoms[j];
                atom1.getXYZ(this.a1);
                if (atom1.isHydrogen()) continue;
                this.ncsCrystal.applySymOp(this.a1, this.a1, symOp);
                Atom atom2 = this.atoms[offset + j];
                atom2.getXYZ(this.a2);
                this.dx[0] = this.a1[0] - this.a2[0];
                this.dx[1] = this.a1[1] - this.a2[1];
                this.dx[2] = this.a1[2] - this.a2[2];
                double r2 = DoubleMath.length2((double[])this.dx);
                residual += r2;
                if (!gradient && !this.lambdaTerm) continue;
                double dedx = this.dx[0] * fx2;
                double dedy = this.dx[1] * fx2;
                double dedz = this.dx[2] * fx2;
                atom2.addToXYZGradient(-this.lambdaPow * dedx, -this.lambdaPow * dedy, -this.lambdaPow * dedz);
                double dedx1 = dedx * this.transOp[0][0] + dedy * this.transOp[1][0] + dedz * this.transOp[2][0];
                double dedy1 = dedx * this.transOp[0][1] + dedy * this.transOp[1][1] + dedz * this.transOp[2][1];
                double dedz1 = dedx * this.transOp[0][2] + dedy * this.transOp[1][2] + dedz * this.transOp[2][2];
                atom1.addToXYZGradient(this.lambdaPow * dedx1, this.lambdaPow * dedy1, this.lambdaPow * dedz1);
                if (!this.lambdaTerm) continue;
                int n = j3 = j * 3;
                this.lambdaGradient[n] = this.lambdaGradient[n] + this.dLambdaPow * dedx1;
                int n2 = j3 + 1;
                this.lambdaGradient[n2] = this.lambdaGradient[n2] + this.dLambdaPow * dedy1;
                int n3 = j3 + 2;
                this.lambdaGradient[n3] = this.lambdaGradient[n3] + this.dLambdaPow * dedz1;
                int n4 = oj3 = (offset + j) * 3;
                this.lambdaGradient[n4] = this.lambdaGradient[n4] - this.dLambdaPow * dedx;
                int n5 = oj3 + 1;
                this.lambdaGradient[n5] = this.lambdaGradient[n5] - this.dLambdaPow * dedy;
                int n6 = oj3 + 2;
                this.lambdaGradient[n6] = this.lambdaGradient[n6] - this.dLambdaPow * dedz;
            }
        }
        if (this.lambdaTerm) {
            this.dEdL = this.dLambdaPow * 10.0 * residual;
            this.d2EdL2 = this.d2LambdaPow * 10.0 * residual;
        }
        return 10.0 * residual * this.lambdaPow;
    }
}

