/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.extended;

import edu.rit.pj.reduction.SharedDouble;
import ffx.numerics.Constraint;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.SystemState;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.constraint.ShakeChargeConstraint;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.PolarizeType;
import ffx.potential.parameters.TitrationUtils;
import ffx.potential.parsers.ESVFilter;
import ffx.utilities.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class ExtendedSystem
implements Potential {
    private static final double DISCR_BIAS = 1.0;
    private static final double LOG10 = FastMath.log((double)10.0);
    private static final double THETA_FRICTION = 0.5;
    private static final double THETA_MASS = 5.0;
    private static final int dDiscr_dTautIndex = 6;
    private static final int dDiscr_dTitrIndex = 3;
    private static final int dModel_dTautIndex = 8;
    private static final int dModel_dTitrIndex = 5;
    private static final int dPh_dTautIndex = 7;
    private static final int dPh_dTitrIndex = 4;
    private static final int discrBiasIndex = 0;
    private static final Logger logger = Logger.getLogger(ExtendedSystem.class.getName());
    private static final int modelBiasIndex = 2;
    private static final int pHBiasIndex = 1;
    public final boolean guessTitrState;
    public final AminoAcidUtils.AminoAcid3[] residueNames;
    public final int[] tautomerDirections;
    private final double[] ASH1toASH2 = new double[4];
    private final double[] ASHFmod = new double[4];
    private final double ASHrestraintConstant;
    private final double ASHtautBiasMag;
    private final double ASHtitrBiasMag;
    private final double[] CYSFmod = new double[4];
    private final double CYSrestraintConstant;
    private final double CYStitrBiasMag;
    private final double[] GLH1toGLH2 = new double[4];
    private final double[] GLHFmod = new double[4];
    private final double GLHrestraintConstant;
    private final double GLHtautBiasMag;
    private final double GLHtitrBiasMag;
    private final double[] HIDFmod = new double[4];
    private final double[] HIDtoHIEFmod = new double[4];
    private final double[] HIEFmod = new double[4];
    private final double HISrestraintConstant;
    private final double HIStautBiasMag;
    private final double HIStitrBiasMag;
    private final double[] LYSFmod = new double[4];
    private final double LYSrestraintConstant;
    private final double LYStitrBiasMag;
    private final List<Constraint> constraints;
    public final boolean useTotalChargeCorrection;
    private final boolean doBias;
    private final boolean doElectrostatics;
    private final boolean doPolarization;
    private final boolean doVDW;
    private final int[][][] esvHistogram;
    private final SharedDouble[] esvIndElecDerivs;
    private final SharedDouble[] esvPermElecDerivs;
    private final SystemState esvState;
    private final SharedDouble[] esvVdwDerivs;
    private final Atom[] extendedAtoms;
    private final double[] extendedLambdas;
    private final int[] extendedMolecules;
    private final List<Residue> extendedResidueList;
    private final ForceFieldEnergy forceFieldEnergy;
    private final boolean[] isTautomerizing;
    private final boolean[] isTitrating;
    private final boolean[] isTitratingHeavy;
    private final boolean[] isTitratingHydrogen;
    private final boolean lockStates;
    private final int nAtoms;
    private final int nESVs;
    private final int nTitr;
    private final ArrayList<Double> specialResiduePKAs;
    private final ArrayList<Double> specialResidues;
    private final ArrayList<Double> selectResidues;
    private final int[] tautomerIndexMap;
    private final double[] tautomerLambdas;
    private final List<Residue> tautomerizingResidueList;
    private final double thetaFriction;
    private final double thetaMass;
    private final List<Residue> titratingResidueList;
    private final int[] titrationIndexMap;
    private final double[] titrationLambdas;
    private final TitrationUtils titrationUtils;
    private final boolean useChargeConstraint;
    File restartFile;
    private boolean fixTautomerState;
    private boolean fixTitrationState;
    private ESVFilter esvFilter = null;
    private double constantSystemPh = 7.4;
    private double currentTemperature = 298.15;

    public ExtendedSystem(MolecularAssembly mola, double pH, File esvFile) {
        List<Atom> atomList;
        this.extendedAtoms = mola.getAtomArray();
        this.extendedMolecules = mola.getMoleculeNumbers();
        this.setConstantPh(pH);
        ForceField forceField = mola.getForceField();
        this.forceFieldEnergy = mola.getPotentialEnergy();
        if (this.forceFieldEnergy == null) {
            logger.severe("No potential energy found?");
        }
        CompositeConfiguration properties = mola.getProperties();
        this.titrationUtils = new TitrationUtils(forceField);
        this.doVDW = properties.getBoolean("esv.vdW", true);
        this.doElectrostatics = properties.getBoolean("esv.elec", true);
        this.doBias = properties.getBoolean("esv.bias", true);
        this.doPolarization = properties.getBoolean("esv.polarization", true);
        this.useTotalChargeCorrection = properties.getBoolean("esv.total.charge.correction", false);
        this.thetaFriction = properties.getDouble("esv.friction", 0.5);
        this.thetaMass = properties.getDouble("esv.mass", 5.0);
        this.lockStates = properties.getBoolean("lock.esv.states", false);
        double initialTitrationLambda = properties.getDouble("initial.titration.lambda", 0.5);
        double initialTautomerLambda = properties.getDouble("initial.tautomer.lambda", 0.5);
        this.guessTitrState = properties.getBoolean("guess.titration.state", false);
        this.specialResidues = this.getPropertyList(properties, "esv.special.residues");
        this.specialResiduePKAs = this.getPropertyList(properties, "esv.special.residues.pka");
        this.selectResidues = this.getPropertyList(properties, "esv.select.residues");
        this.initSpecialResidues(this.specialResidues, this.specialResiduePKAs, mola);
        this.fixTitrationState = properties.getBoolean("fix.titration.lambda", false);
        this.fixTautomerState = properties.getBoolean("fix.tautomer.lambda", false);
        this.useChargeConstraint = properties.getBoolean("esv.charge.constraint", false);
        int totalCharge = properties.getInt("esv.charge.constraint.value", 0);
        this.ASHFmod[3] = properties.getDouble("ASH.cubic", TitrationUtils.Titration.ASHtoASP.cubic);
        this.ASHFmod[2] = properties.getDouble("ASH.quadratic", TitrationUtils.Titration.ASHtoASP.quadratic);
        this.ASHFmod[1] = properties.getDouble("ASH.linear", TitrationUtils.Titration.ASHtoASP.linear);
        this.ASHFmod[0] = TitrationUtils.Titration.ASHtoASP.offset;
        this.ASH1toASH2[3] = properties.getDouble("ASH1toASH2.cubic", TitrationUtils.Titration.ASH1toASH2.cubic);
        this.ASH1toASH2[2] = properties.getDouble("ASH1toASH2.quadratic", TitrationUtils.Titration.ASH1toASH2.quadratic);
        this.ASH1toASH2[1] = properties.getDouble("ASH1toASH2.linear", TitrationUtils.Titration.ASH1toASH2.linear);
        this.ASH1toASH2[0] = TitrationUtils.Titration.ASH1toASH2.offset;
        this.ASHtitrBiasMag = properties.getDouble("ASH.titration.bias.magnitude", 1.0);
        this.ASHtautBiasMag = properties.getDouble("ASH.tautomer.bias.magnitude", 1.0);
        this.ASHrestraintConstant = properties.getDouble("ASH.restraint.constant", 0.0);
        this.GLHFmod[3] = properties.getDouble("GLH.cubic", TitrationUtils.Titration.GLHtoGLU.cubic);
        this.GLHFmod[2] = properties.getDouble("GLH.quadratic", TitrationUtils.Titration.GLHtoGLU.quadratic);
        this.GLHFmod[1] = properties.getDouble("GLH.linear", TitrationUtils.Titration.GLHtoGLU.linear);
        this.GLHFmod[0] = TitrationUtils.Titration.GLHtoGLU.offset;
        this.GLH1toGLH2[3] = properties.getDouble("GLH1toGLH2.cubic", TitrationUtils.Titration.GLH1toGLH2.cubic);
        this.GLH1toGLH2[2] = properties.getDouble("GLH1toGLH2.quadratic", TitrationUtils.Titration.GLH1toGLH2.quadratic);
        this.GLH1toGLH2[1] = properties.getDouble("GLH1toGLH2.linear", TitrationUtils.Titration.GLH1toGLH2.linear);
        this.GLH1toGLH2[0] = TitrationUtils.Titration.GLH1toGLH2.offset;
        this.GLHtitrBiasMag = properties.getDouble("GLH.titration.bias.magnitude", 1.0);
        this.GLHtautBiasMag = properties.getDouble("GLH.tautomer.bias.magnitude", 1.0);
        this.GLHrestraintConstant = properties.getDouble("GLH.restraint.constant", 0.0);
        this.LYSFmod[3] = properties.getDouble("LYS.cubic", TitrationUtils.Titration.LYStoLYD.cubic);
        this.LYSFmod[2] = properties.getDouble("LYS.quadratic", TitrationUtils.Titration.LYStoLYD.quadratic);
        this.LYSFmod[1] = properties.getDouble("LYS.linear", TitrationUtils.Titration.LYStoLYD.linear);
        this.LYSFmod[0] = TitrationUtils.Titration.LYStoLYD.offset;
        this.LYStitrBiasMag = properties.getDouble("LYS.titration.bias.magnitude", 1.0);
        this.LYSrestraintConstant = properties.getDouble("LYS.restraint.constant", 0.0);
        this.CYSFmod[3] = properties.getDouble("CYS.cubic", TitrationUtils.Titration.CYStoCYD.cubic);
        this.CYSFmod[2] = properties.getDouble("CYS.quadratic", TitrationUtils.Titration.CYStoCYD.quadratic);
        this.CYSFmod[1] = properties.getDouble("CYS.linear", TitrationUtils.Titration.CYStoCYD.linear);
        this.CYSFmod[0] = TitrationUtils.Titration.CYStoCYD.offset;
        this.CYStitrBiasMag = properties.getDouble("CYS.titration.bias.magnitude", 1.0);
        this.CYSrestraintConstant = properties.getDouble("CYS.restraint.constant", 0.0);
        this.HIDFmod[3] = properties.getDouble("HID.cubic", TitrationUtils.Titration.HIStoHID.cubic);
        this.HIDFmod[2] = properties.getDouble("HID.quadratic", TitrationUtils.Titration.HIStoHID.quadratic);
        this.HIDFmod[1] = properties.getDouble("HID.linear", TitrationUtils.Titration.HIStoHID.linear);
        this.HIDFmod[0] = TitrationUtils.Titration.HIStoHID.offset;
        this.HIEFmod[3] = properties.getDouble("HIE.cubic", TitrationUtils.Titration.HIStoHIE.cubic);
        this.HIEFmod[2] = properties.getDouble("HIE.quadratic", TitrationUtils.Titration.HIStoHIE.quadratic);
        this.HIEFmod[1] = properties.getDouble("HIE.linear", TitrationUtils.Titration.HIStoHIE.linear);
        this.HIEFmod[0] = TitrationUtils.Titration.HIStoHIE.offset;
        this.HIDtoHIEFmod[3] = properties.getDouble("HIDtoHIE.cubic", TitrationUtils.Titration.HIDtoHIE.cubic);
        this.HIDtoHIEFmod[2] = properties.getDouble("HIDtoHIE.quadratic", TitrationUtils.Titration.HIDtoHIE.quadratic);
        this.HIDtoHIEFmod[1] = properties.getDouble("HIDtoHIE.linear", TitrationUtils.Titration.HIDtoHIE.linear);
        this.HIDtoHIEFmod[0] = TitrationUtils.Titration.HIDtoHIE.offset;
        this.HIStitrBiasMag = properties.getDouble("HIS.titration.bias.magnitude", 1.0);
        this.HIStautBiasMag = properties.getDouble("HIS.tautomer.bias.magnitude", 1.0);
        this.HISrestraintConstant = properties.getDouble("HIS.restraint.constant", 0.0);
        logger.info("\n Titration bias magnitudes:");
        logger.info(" Lysine titration bias magnitude: " + this.LYStitrBiasMag);
        logger.info(" Cysteine titration bias magnitude: " + this.CYStitrBiasMag);
        logger.info(" Histidine titration bias magnitude: " + this.HIStitrBiasMag);
        logger.info(" Glutamic acid titration bias magnitude: " + this.GLHtitrBiasMag);
        logger.info(" Aspartic acid titration bias magnitude: " + this.ASHtitrBiasMag);
        logger.info("\n Tautomer bias magnitudes:");
        logger.info(" Histidine tautomer bias magnitude: " + this.HIStautBiasMag);
        logger.info(" Glutamic acid tautomer bias magnitude: " + this.GLHtautBiasMag);
        logger.info(" Aspartic acid tautomer bias magnitude: " + this.ASHtautBiasMag);
        logger.info("\n Titration model bias (Umod) terms:");
        logger.info(" Lysine cubic term: " + this.LYSFmod[3]);
        logger.info(" Lysine quadratic term: " + this.LYSFmod[2]);
        logger.info(" Lysine linear term: " + this.LYSFmod[1]);
        logger.info(" Cysteine cubic term: " + this.CYSFmod[3]);
        logger.info(" Cysteine quadratic term: " + this.CYSFmod[2]);
        logger.info(" Cysteine linear term: " + this.CYSFmod[1]);
        logger.info(" Histidine cubic term: " + this.HIDFmod[3]);
        logger.info(" HID quadratic term: " + this.HIDFmod[2]);
        logger.info(" HID linear term: " + this.HIDFmod[1]);
        logger.info(" HIE cubic term: " + this.HIEFmod[3]);
        logger.info(" HIE quadratic term: " + this.HIEFmod[2]);
        logger.info(" HIE linear term: " + this.HIEFmod[1]);
        logger.info(" HID-HIE cubic term: " + this.HIDtoHIEFmod[3]);
        logger.info(" HID-HIE quadratic term: " + this.HIDtoHIEFmod[2]);
        logger.info(" HID-HIE linear term: " + this.HIDtoHIEFmod[1]);
        logger.info(" Glutamic acid cubic term: " + this.GLHFmod[3]);
        logger.info(" Glutamic acid quadratic term: " + this.GLHFmod[2]);
        logger.info(" Glutamic acid linear term: " + this.GLHFmod[1]);
        logger.info(" Aspartic acid cubic term: " + this.ASHFmod[3]);
        logger.info(" Aspartic acid quadratic term: " + this.ASHFmod[2]);
        logger.info(" Aspartic acid linear term: " + this.ASHFmod[1] + "\n");
        this.titratingResidueList = new ArrayList<Residue>();
        this.tautomerizingResidueList = new ArrayList<Residue>();
        this.extendedResidueList = new ArrayList<Residue>();
        Atom[] atoms = mola.getAtomArray();
        this.nAtoms = atoms.length;
        this.isTitrating = new boolean[this.nAtoms];
        this.isTitratingHydrogen = new boolean[this.nAtoms];
        this.isTitratingHeavy = new boolean[this.nAtoms];
        this.isTautomerizing = new boolean[this.nAtoms];
        this.titrationLambdas = new double[this.nAtoms];
        this.tautomerLambdas = new double[this.nAtoms];
        this.titrationIndexMap = new int[this.nAtoms];
        this.tautomerIndexMap = new int[this.nAtoms];
        this.tautomerDirections = new int[this.nAtoms];
        this.residueNames = new AminoAcidUtils.AminoAcid3[this.nAtoms];
        Arrays.fill(this.isTitrating, false);
        Arrays.fill(this.isTitratingHydrogen, false);
        Arrays.fill(this.isTitratingHeavy, false);
        Arrays.fill(this.isTautomerizing, false);
        Arrays.fill(this.titrationLambdas, 1.0);
        Arrays.fill(this.tautomerLambdas, 0.0);
        Arrays.fill(this.titrationIndexMap, -1);
        Arrays.fill(this.tautomerIndexMap, -1);
        Arrays.fill(this.tautomerDirections, 0);
        Arrays.fill((Object[])this.residueNames, (Object)AminoAcidUtils.AminoAcid3.UNK);
        List<Residue> residueList = mola.getResidueList();
        ArrayList<Residue> preprocessList = new ArrayList<Residue>(residueList);
        for (Residue residue2 : preprocessList) {
            atomList = residue2.getSideChainAtoms();
            for (Atom atom : atomList) {
                if (atom.getAtomicNumber() != 16 || !BondedUtils.hasAttachedAtom(atom, 16)) continue;
                residueList.remove(residue2);
            }
        }
        residueList.removeIf(residue -> residue.getResidueType() == Residue.ResidueType.NA);
        for (Residue residue2 : residueList) {
            int atomIndex;
            if (!this.isTitratable(residue2) || !this.selectResidues.isEmpty() && !this.selectResidues.contains(residue2.getResidueNumber())) continue;
            this.titratingResidueList.add(residue2);
            atomList = residue2.getSideChainAtoms();
            for (Atom atom : atomList) {
                int titrationIndex;
                atomIndex = atom.getArrayIndex();
                this.residueNames[atomIndex] = residue2.getAminoAcid3();
                this.isTitrating[atomIndex] = true;
                this.titrationLambdas[atomIndex] = this.initialTitrationState(residue2, initialTitrationLambda, this.guessTitrState);
                this.titrationIndexMap[atomIndex] = titrationIndex = this.titratingResidueList.indexOf(residue2);
                this.isTitratingHydrogen[atomIndex] = TitrationUtils.isTitratingHydrogen(residue2.getAminoAcid3(), atom);
                this.isTitratingHeavy[atomIndex] = TitrationUtils.isTitratingHeavy(residue2.getAminoAcid3(), atom);
                if (!this.isTitratingHeavy(atomIndex) || atom.getPolarizeType() == null) continue;
                double deprotPolar = this.titrationUtils.getPolarizability(atom, 0.0, 0.0, atom.getPolarizeType().polarizability);
                double protPolar = this.titrationUtils.getPolarizability(atom, 1.0, 1.0, atom.getPolarizeType().polarizability);
                double avgPolar = 0.5 * deprotPolar + 0.5 * protPolar;
                PolarizeType esvPolarizingHeavyAtom = new PolarizeType(atom.getType(), avgPolar, atom.getPolarizeType().thole, atom.getPolarizeType().ddp, atom.getPolarizeType().polarizationGroup);
                atom.setPolarizeType(esvPolarizingHeavyAtom);
            }
            if (this.isTautomer(residue2)) {
                this.tautomerizingResidueList.add(residue2);
                for (Atom atom : atomList) {
                    int tautomerIndex;
                    atomIndex = atom.getArrayIndex();
                    this.isTautomerizing[atomIndex] = true;
                    this.tautomerLambdas[atomIndex] = initialTautomerLambda;
                    this.tautomerIndexMap[atomIndex] = tautomerIndex = this.tautomerizingResidueList.indexOf(residue2);
                    this.tautomerDirections[atomIndex] = TitrationUtils.getTitratingHydrogenDirection(residue2.getAminoAcid3(), atom);
                }
            }
            assert (this.titrationUtils.testResidueTypes(residue2));
        }
        this.extendedResidueList.addAll(this.titratingResidueList);
        this.extendedResidueList.addAll(this.tautomerizingResidueList);
        this.nESVs = this.extendedResidueList.size();
        this.nTitr = this.titratingResidueList.size();
        this.extendedLambdas = new double[this.nESVs];
        this.esvState = new SystemState(this.nESVs);
        this.esvHistogram = new int[this.nTitr][10][10];
        this.esvVdwDerivs = new SharedDouble[this.nESVs];
        this.esvPermElecDerivs = new SharedDouble[this.nESVs];
        this.esvIndElecDerivs = new SharedDouble[this.nESVs];
        for (int i = 0; i < this.nESVs; ++i) {
            this.esvVdwDerivs[i] = new SharedDouble(0.0);
            this.esvPermElecDerivs[i] = new SharedDouble(0.0);
            this.esvIndElecDerivs[i] = new SharedDouble(0.0);
        }
        if (this.useChargeConstraint) {
            this.constraints = new ArrayList<Constraint>();
            ShakeChargeConstraint chargeConstraint = new ShakeChargeConstraint(this.nTitr, totalCharge, 0.001);
            this.constraints.add(chargeConstraint);
        } else {
            this.constraints = Collections.emptyList();
        }
        Arrays.fill(this.esvState.getMass(), this.thetaMass);
        for (int i = 0; i < this.nESVs; ++i) {
            if (i < this.nTitr) {
                Residue residue2;
                residue2 = this.extendedResidueList.get(i);
                double initialTitrLambda = this.initialTitrationState(residue2, initialTitrationLambda, this.guessTitrState);
                this.initializeThetaArrays(i, initialTitrLambda);
                continue;
            }
            this.initializeThetaArrays(i, initialTautomerLambda);
        }
        if (this.esvFilter == null) {
            this.esvFilter = new ESVFilter(mola.getName());
        }
        if (esvFile == null) {
            String firstFileName = FilenameUtils.removeExtension((String)mola.getFile().getAbsolutePath());
            this.restartFile = new File(firstFileName + ".esv");
        } else {
            double[] thetaAccel;
            double[] thetaVelocity;
            double[] thetaPosition = this.esvState.x();
            if (!this.esvFilter.readESV(esvFile, thetaPosition, thetaVelocity = this.esvState.v(), thetaAccel = this.esvState.a(), this.esvHistogram)) {
                String message = " Could not load the restart file - dynamics terminated.";
                logger.log(Level.WARNING, message);
                throw new IllegalStateException(message);
            }
            this.restartFile = esvFile;
            this.updateLambdas();
        }
        logger.info("\n Extended System created for the following residues: " + String.valueOf(this.titratingResidueList));
    }

    private void initSpecialResidues(ArrayList<Double> specialResidues, ArrayList<Double> specialResiduePKAs, MolecularAssembly mola) {
        if (specialResidues.size() != specialResiduePKAs.size() && !specialResiduePKAs.isEmpty()) {
            logger.severe("The number of special residues and their associated values do not match.");
        } else if (!specialResidues.isEmpty()) {
            logger.info("\n Special residues and their associated values:");
            for (int i = 0; i < specialResidues.size(); ++i) {
                int resNum = (int)specialResidues.get(i).doubleValue() - mola.getResidueList().get(0).getResidueNumber();
                if (specialResiduePKAs.isEmpty()) continue;
                logger.info(" Residue: " + String.valueOf(specialResidues.get(i)) + "-" + mola.getResidueList().get(resNum).getName() + " Pka: " + String.valueOf(specialResiduePKAs.get(i)));
            }
            logger.info(" ");
        }
        logger.info(" Special residues: " + String.valueOf(specialResidues));
        logger.info(" Special residues pKa: " + String.valueOf(specialResiduePKAs));
        for (Residue res : mola.getResidueList()) {
            if (this.isTitratable(res) || !specialResidues.contains(res.getResidueNumber())) continue;
            logger.severe("Given special residue: " + String.valueOf(res) + " is not titratable.");
        }
    }

    public boolean isTitratable(Residue residue) {
        if (residue.getResidueType() == Residue.ResidueType.NA) {
            return false;
        }
        AminoAcidUtils.AminoAcid3 AA3 = residue.getAminoAcid3();
        return AA3.isConstantPhTitratable;
    }

    private ArrayList<Double> getPropertyList(CompositeConfiguration properties, String s) {
        String[] split;
        ArrayList<Double> list = new ArrayList<Double>();
        for (String s1 : split = properties.getString(s, "").trim().replace("[", "").replace("]", "").replace(",", " ").split(" ")) {
            if (s1.isEmpty()) continue;
            list.add(Double.parseDouble(s1));
        }
        return list;
    }

    private void initializeThetaArrays(int index, double lambda) {
        this.extendedLambdas[index] = lambda;
        double[] thetaPosition = this.esvState.x();
        double[] thetaVelocity = this.esvState.v();
        double[] thetaAccel = this.esvState.a();
        thetaPosition[index] = Math.asin(Math.sqrt(lambda));
        Random random = new Random();
        thetaVelocity[index] = random.nextGaussian() * FastMath.sqrt((double)(247.89570296023882 / this.thetaMass));
        double dUdL = this.getDerivatives()[index];
        double dUdTheta = dUdL * FastMath.sin((double)(2.0 * thetaPosition[index]));
        thetaAccel[index] = -418.4 * dUdTheta / this.thetaMass;
    }

    public double[] getDerivatives() {
        double[] esvDeriv = new double[this.nESVs];
        double[] biasDerivComponents = new double[9];
        for (Residue residue : this.titratingResidueList) {
            int resTautIndex;
            int resTitrIndex = this.titratingResidueList.indexOf(residue);
            if (this.doBias) {
                this.getBiasTerms(residue, biasDerivComponents);
                int n = resTitrIndex;
                esvDeriv[n] = esvDeriv[n] + (biasDerivComponents[3] + biasDerivComponents[4] + biasDerivComponents[5]);
                if (this.isTautomer(residue)) {
                    int n2 = resTautIndex = this.tautomerizingResidueList.indexOf(residue) + this.nTitr;
                    esvDeriv[n2] = esvDeriv[n2] + (biasDerivComponents[6] + biasDerivComponents[7] + biasDerivComponents[8]);
                }
            }
            if (this.doVDW) {
                int n = resTitrIndex;
                esvDeriv[n] = esvDeriv[n] + this.getVdwDeriv(resTitrIndex);
                if (this.isTautomer(residue)) {
                    int n3 = resTautIndex = this.tautomerizingResidueList.indexOf(residue) + this.nTitr;
                    esvDeriv[n3] = esvDeriv[n3] + this.getVdwDeriv(resTautIndex);
                }
            }
            if (!this.doElectrostatics) continue;
            int n = resTitrIndex;
            esvDeriv[n] = esvDeriv[n] + this.getPermElecDeriv(resTitrIndex);
            if (this.isTautomer(residue)) {
                int n4 = resTautIndex = this.tautomerizingResidueList.indexOf(residue) + this.nTitr;
                esvDeriv[n4] = esvDeriv[n4] + this.getPermElecDeriv(resTautIndex);
            }
            if (!this.doPolarization) continue;
            int n5 = resTitrIndex;
            esvDeriv[n5] = esvDeriv[n5] + this.getIndElecDeriv(resTitrIndex);
            if (!this.isTautomer(residue)) continue;
            int n6 = resTautIndex = this.tautomerizingResidueList.indexOf(residue) + this.nTitr;
            esvDeriv[n6] = esvDeriv[n6] + this.getIndElecDeriv(resTautIndex);
        }
        return esvDeriv;
    }

    private void getBiasTerms(Residue residue, double[] biasEnergyAndDerivs) {
        double dMod_dTitr;
        double modelBias;
        double dPh_dTaut;
        double dPh_dTitr;
        double pHBias;
        double dDiscr_dTaut;
        double dDiscr_dTitr;
        double discrBias;
        AminoAcidUtils.AminoAcid3 AA3 = residue.getAminoAcid3();
        double titrationLambda = this.getTitrationLambda(residue);
        double titrationLambdaSquared = titrationLambda * titrationLambda;
        double titrationLambdaCubed = titrationLambdaSquared * titrationLambda;
        if (!this.doBias) {
            AA3 = AminoAcidUtils.AminoAcid3.UNK;
        }
        double dMod_dTaut = switch (AA3) {
            case AminoAcidUtils.AminoAcid3.ASD, AminoAcidUtils.AminoAcid3.ASH, AminoAcidUtils.AminoAcid3.ASP -> {
                double pKa1;
                double tautomerLambda = this.getTautomerLambda(residue);
                discrBias = -4.0 * this.ASHtitrBiasMag * (titrationLambda - 0.5) * (titrationLambda - 0.5);
                discrBias += -4.0 * this.ASHtautBiasMag * (tautomerLambda - 0.5) * (tautomerLambda - 0.5);
                dDiscr_dTitr = -8.0 * this.ASHtitrBiasMag * (titrationLambda - 0.5);
                dDiscr_dTaut = -8.0 * this.ASHtautBiasMag * (tautomerLambda - 0.5);
                double pKa2 = pKa1 = TitrationUtils.Titration.ASHtoASP.pKa;
                pHBias = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (tautomerLambda * (pKa1 - this.constantSystemPh) + (1.0 - tautomerLambda) * (pKa2 - this.constantSystemPh));
                dPh_dTitr = LOG10 * 0.0019872042586408316 * this.currentTemperature * -1.0 * (tautomerLambda * (pKa1 - this.constantSystemPh) + (1.0 - tautomerLambda) * (pKa2 - this.constantSystemPh));
                dPh_dTaut = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (pKa1 - this.constantSystemPh - (pKa2 - this.constantSystemPh));
                double restraint = this.ASHrestraintConstant;
                double pHSignedSquared = (pKa1 - this.constantSystemPh) * Math.abs(pKa1 - this.constantSystemPh);
                pHBias += restraint * (1.0 - titrationLambda) * pHSignedSquared;
                dPh_dTitr += restraint * -1.0 * pHSignedSquared;
                double coeffA0 = this.ASH1toASH2[3];
                double coeffA1 = this.ASH1toASH2[2];
                double coeffA2 = this.ASH1toASH2[1];
                double coeffB0 = this.ASHFmod[3];
                double coeffB1 = this.ASHFmod[2];
                double coeffB2 = this.ASHFmod[1];
                double coeffC0 = this.ASHFmod[3];
                double coeffC1 = this.ASHFmod[2];
                double coeffC2 = this.ASHFmod[1];
                double tautomerLambdaSquared = tautomerLambda * tautomerLambda;
                double tautomerLambdaCubed = tautomerLambdaSquared * tautomerLambda;
                double oneMinusTitrationLambda = 1.0 - titrationLambda;
                double oneMinusTautomerLambda = 1.0 - tautomerLambda;
                double coeffBSum = coeffB0 + coeffB1 + coeffB2;
                double coeffCSum = coeffC0 + coeffC1 + coeffC2;
                modelBias = titrationLambda * (coeffA0 * tautomerLambdaCubed + coeffA1 * tautomerLambdaSquared + coeffA2 * tautomerLambda) + tautomerLambda * (coeffB0 * titrationLambdaCubed + coeffB1 * titrationLambdaSquared + coeffB2 * titrationLambda) + oneMinusTautomerLambda * (coeffC0 * titrationLambdaCubed + coeffC1 * titrationLambdaSquared + coeffC2 * titrationLambda) + oneMinusTitrationLambda * (coeffCSum - coeffBSum) * tautomerLambda;
                dMod_dTitr = coeffA0 * tautomerLambdaCubed + coeffA1 * tautomerLambdaSquared + coeffA2 * tautomerLambda + tautomerLambda * (3.0 * coeffB0 * titrationLambdaSquared + 2.0 * coeffB1 * titrationLambda + coeffB2) + oneMinusTautomerLambda * (3.0 * coeffC0 * titrationLambdaSquared + 2.0 * coeffC1 * titrationLambda + coeffC2) + -tautomerLambda * (coeffCSum - coeffBSum);
                yield titrationLambda * (3.0 * coeffA0 * tautomerLambdaSquared + 2.0 * coeffA1 * tautomerLambda + coeffA2) + (coeffB0 * titrationLambdaCubed + coeffB1 * titrationLambdaSquared + coeffB2 * titrationLambda) + -1.0 * (coeffC0 * titrationLambdaCubed + coeffC1 * titrationLambdaSquared + coeffC2 * titrationLambda) + oneMinusTautomerLambda * (coeffCSum - coeffBSum);
            }
            case AminoAcidUtils.AminoAcid3.GLD, AminoAcidUtils.AminoAcid3.GLH, AminoAcidUtils.AminoAcid3.GLU -> {
                double pKa1;
                double tautomerLambda = this.getTautomerLambda(residue);
                discrBias = -4.0 * this.GLHtitrBiasMag * (titrationLambda - 0.5) * (titrationLambda - 0.5);
                discrBias += -4.0 * this.GLHtautBiasMag * (tautomerLambda - 0.5) * (tautomerLambda - 0.5);
                dDiscr_dTitr = -8.0 * this.GLHtitrBiasMag * (titrationLambda - 0.5);
                dDiscr_dTaut = -8.0 * this.GLHtautBiasMag * (tautomerLambda - 0.5);
                double pKa2 = pKa1 = TitrationUtils.Titration.GLHtoGLU.pKa;
                pHBias = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (tautomerLambda * (pKa1 - this.constantSystemPh) + (1.0 - tautomerLambda) * (pKa2 - this.constantSystemPh));
                dPh_dTitr = LOG10 * 0.0019872042586408316 * this.currentTemperature * -1.0 * (tautomerLambda * (pKa1 - this.constantSystemPh) + (1.0 - tautomerLambda) * (pKa2 - this.constantSystemPh));
                dPh_dTaut = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (pKa1 - this.constantSystemPh - (pKa2 - this.constantSystemPh));
                double restraint = this.GLHrestraintConstant;
                double pHSignedSquared = (pKa1 - this.constantSystemPh) * Math.abs(pKa1 - this.constantSystemPh);
                pHBias += restraint * (1.0 - titrationLambda) * pHSignedSquared;
                dPh_dTitr += restraint * -1.0 * pHSignedSquared;
                double coeffA0 = this.GLH1toGLH2[3];
                double coeffA1 = this.GLH1toGLH2[2];
                double coeffA2 = this.GLH1toGLH2[1];
                double coeffB0 = this.GLHFmod[3];
                double coeffB1 = this.GLHFmod[2];
                double coeffB2 = this.GLHFmod[1];
                double coeffC0 = this.GLHFmod[3];
                double coeffC1 = this.GLHFmod[2];
                double coeffC2 = this.GLHFmod[1];
                double tautomerLambdaSquared = tautomerLambda * tautomerLambda;
                double tautomerLambdaCubed = tautomerLambdaSquared * tautomerLambda;
                double oneMinusTitrationLambda = 1.0 - titrationLambda;
                double oneMinusTautomerLambda = 1.0 - tautomerLambda;
                double coeffBSum = coeffB0 + coeffB1 + coeffB2;
                double coeffCSum = coeffC0 + coeffC1 + coeffC2;
                modelBias = titrationLambda * (coeffA0 * tautomerLambdaCubed + coeffA1 * tautomerLambdaSquared + coeffA2 * tautomerLambda) + tautomerLambda * (coeffB0 * titrationLambdaCubed + coeffB1 * titrationLambdaSquared + coeffB2 * titrationLambda) + oneMinusTautomerLambda * (coeffC0 * titrationLambdaCubed + coeffC1 * titrationLambdaSquared + coeffC2 * titrationLambda) + oneMinusTitrationLambda * (coeffCSum - coeffBSum) * tautomerLambda;
                dMod_dTitr = coeffA0 * tautomerLambdaCubed + coeffA1 * tautomerLambdaSquared + coeffA2 * tautomerLambda + tautomerLambda * (3.0 * coeffB0 * titrationLambdaSquared + 2.0 * coeffB1 * titrationLambda + coeffB2) + oneMinusTautomerLambda * (3.0 * coeffC0 * titrationLambdaSquared + 2.0 * coeffC1 * titrationLambda + coeffC2) + -tautomerLambda * (coeffCSum - coeffBSum);
                yield titrationLambda * (3.0 * coeffA0 * tautomerLambdaSquared + 2.0 * coeffA1 * tautomerLambda + coeffA2) + (coeffB0 * titrationLambdaCubed + coeffB1 * titrationLambdaSquared + coeffB2 * titrationLambda) + -1.0 * (coeffC0 * titrationLambdaCubed + coeffC1 * titrationLambdaSquared + coeffC2 * titrationLambda) + oneMinusTautomerLambda * (coeffCSum - coeffBSum);
            }
            case AminoAcidUtils.AminoAcid3.HIS, AminoAcidUtils.AminoAcid3.HID, AminoAcidUtils.AminoAcid3.HIE -> {
                double tautomerLambda = this.getTautomerLambda(residue);
                discrBias = -4.0 * this.HIStitrBiasMag * (titrationLambda - 0.5) * (titrationLambda - 0.5);
                discrBias += -4.0 * this.HIStautBiasMag * (tautomerLambda - 0.5) * (tautomerLambda - 0.5);
                dDiscr_dTitr = -8.0 * this.HIStitrBiasMag * (titrationLambda - 0.5);
                dDiscr_dTaut = -8.0 * this.HIStautBiasMag * (tautomerLambda - 0.5);
                double pKa1 = TitrationUtils.Titration.HIStoHIE.pKa;
                double pKa2 = TitrationUtils.Titration.HIStoHID.pKa;
                pHBias = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (tautomerLambda * (pKa1 - this.constantSystemPh) + (1.0 - tautomerLambda) * (pKa2 - this.constantSystemPh));
                dPh_dTitr = LOG10 * 0.0019872042586408316 * this.currentTemperature * -1.0 * (tautomerLambda * (pKa1 - this.constantSystemPh) + (1.0 - tautomerLambda) * (pKa2 - this.constantSystemPh));
                dPh_dTaut = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (pKa1 - this.constantSystemPh - (pKa2 - this.constantSystemPh));
                double restraint = this.HISrestraintConstant;
                double pH1SignedSquared = (pKa1 - this.constantSystemPh) * Math.abs(pKa1 - this.constantSystemPh);
                double pH2SignedSquared = (pKa2 - this.constantSystemPh) * Math.abs(pKa2 - this.constantSystemPh);
                pHBias += restraint * (1.0 - titrationLambda) * (tautomerLambda * pH1SignedSquared + (1.0 - tautomerLambda) * pH2SignedSquared);
                dPh_dTitr += restraint * -1.0 * (tautomerLambda * pH1SignedSquared + (1.0 - tautomerLambda) * pH2SignedSquared);
                dPh_dTaut += restraint * (1.0 - titrationLambda) * (pH1SignedSquared - pH2SignedSquared);
                double coeffA0 = this.HIDtoHIEFmod[3];
                double coeffA1 = this.HIDtoHIEFmod[2];
                double coeffA2 = this.HIDtoHIEFmod[1];
                double coeffB0 = this.HIEFmod[3];
                double coeffB1 = this.HIEFmod[2];
                double coeffB2 = this.HIEFmod[1];
                double coeffC0 = this.HIDFmod[3];
                double coeffC1 = this.HIDFmod[2];
                double coeffC2 = this.HIDFmod[1];
                double tautomerLambdaSquared = tautomerLambda * tautomerLambda;
                double tautomerLambdaCubed = tautomerLambdaSquared * tautomerLambda;
                double oneMinusTitrationLambda = 1.0 - titrationLambda;
                double oneMinusTautomerLambda = 1.0 - tautomerLambda;
                double coeffBSum = coeffB0 + coeffB1 + coeffB2;
                double coeffCSum = coeffC0 + coeffC1 + coeffC2;
                modelBias = oneMinusTitrationLambda * (coeffA0 * tautomerLambdaCubed + coeffA1 * tautomerLambdaSquared + coeffA2 * tautomerLambda) + tautomerLambda * (coeffB0 * titrationLambdaCubed + coeffB1 * titrationLambdaSquared + coeffB2 * titrationLambda) + oneMinusTautomerLambda * (coeffC0 * titrationLambdaCubed + coeffC1 * titrationLambdaSquared + coeffC2 * titrationLambda) + titrationLambda * (coeffCSum - coeffBSum) * tautomerLambda;
                dMod_dTitr = -(coeffA0 * tautomerLambdaCubed + coeffA1 * tautomerLambdaSquared + coeffA2 * tautomerLambda) + tautomerLambda * (3.0 * coeffB0 * titrationLambdaSquared + 2.0 * coeffB1 * titrationLambda + coeffB2) + oneMinusTautomerLambda * (3.0 * coeffC0 * titrationLambdaSquared + 2.0 * coeffC1 * titrationLambda + coeffC2) + tautomerLambda * (coeffCSum - coeffBSum);
                yield oneMinusTitrationLambda * (3.0 * coeffA0 * tautomerLambdaSquared + 2.0 * coeffA1 * tautomerLambda + coeffA2) + (coeffB0 * titrationLambdaCubed + coeffB1 * titrationLambdaSquared + coeffB2 * titrationLambda) + -1.0 * (coeffC0 * titrationLambdaCubed + coeffC1 * titrationLambdaSquared + coeffC2 * titrationLambda) + titrationLambda * (coeffCSum - coeffBSum);
            }
            case AminoAcidUtils.AminoAcid3.LYS, AminoAcidUtils.AminoAcid3.LYD -> {
                discrBias = -4.0 * this.LYStitrBiasMag * (titrationLambda - 0.5) * (titrationLambda - 0.5);
                dDiscr_dTitr = -8.0 * this.LYStitrBiasMag * (titrationLambda - 0.5);
                dDiscr_dTaut = 0.0;
                double pKa1 = TitrationUtils.Titration.LYStoLYD.pKa;
                pHBias = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (pKa1 - this.constantSystemPh);
                dPh_dTitr = LOG10 * 0.0019872042586408316 * this.currentTemperature * -1.0 * (pKa1 - this.constantSystemPh);
                dPh_dTaut = 0.0;
                double restraint = this.LYSrestraintConstant;
                double pHSignedSquared = (pKa1 - this.constantSystemPh) * Math.abs(pKa1 - this.constantSystemPh);
                pHBias += restraint * (1.0 - titrationLambda) * pHSignedSquared;
                dPh_dTitr += restraint * -1.0 * pHSignedSquared;
                double cubic = this.LYSFmod[3];
                double quadratic = this.LYSFmod[2];
                double linear = this.LYSFmod[1];
                modelBias = cubic * titrationLambdaCubed + quadratic * titrationLambdaSquared + linear * titrationLambda;
                dMod_dTitr = 3.0 * cubic * titrationLambdaSquared + 2.0 * quadratic * titrationLambda + linear;
                yield 0.0;
            }
            case AminoAcidUtils.AminoAcid3.CYS, AminoAcidUtils.AminoAcid3.CYD -> {
                discrBias = -4.0 * this.CYStitrBiasMag * (titrationLambda - 0.5) * (titrationLambda - 0.5);
                dDiscr_dTitr = -8.0 * this.CYStitrBiasMag * (titrationLambda - 0.5);
                dDiscr_dTaut = 0.0;
                double pKa1 = TitrationUtils.Titration.CYStoCYD.pKa;
                pHBias = LOG10 * 0.0019872042586408316 * this.currentTemperature * (1.0 - titrationLambda) * (pKa1 - this.constantSystemPh);
                dPh_dTitr = LOG10 * 0.0019872042586408316 * this.currentTemperature * -1.0 * (pKa1 - this.constantSystemPh);
                dPh_dTaut = 0.0;
                double restraint = this.CYSrestraintConstant;
                double pHSignedSquared = (pKa1 - this.constantSystemPh) * Math.abs(pKa1 - this.constantSystemPh);
                pHBias += restraint * (1.0 - titrationLambda) * pHSignedSquared;
                dPh_dTitr += restraint * -1.0 * pHSignedSquared;
                double cubic = this.CYSFmod[3];
                double quadratic = this.CYSFmod[2];
                double linear = this.CYSFmod[1];
                modelBias = cubic * titrationLambdaCubed + quadratic * titrationLambdaSquared + linear * titrationLambda;
                dMod_dTitr = 3.0 * cubic * titrationLambdaSquared + 2.0 * quadratic * titrationLambda + linear;
                yield 0.0;
            }
            default -> {
                discrBias = 0.0;
                pHBias = 0.0;
                modelBias = 0.0;
                dDiscr_dTitr = 0.0;
                dDiscr_dTaut = 0.0;
                dPh_dTitr = 0.0;
                dPh_dTaut = 0.0;
                dMod_dTitr = 0.0;
                yield 0.0;
            }
        };
        biasEnergyAndDerivs[0] = discrBias;
        biasEnergyAndDerivs[1] = pHBias;
        biasEnergyAndDerivs[2] = -modelBias;
        biasEnergyAndDerivs[3] = dDiscr_dTitr;
        biasEnergyAndDerivs[4] = dPh_dTitr;
        biasEnergyAndDerivs[5] = -dMod_dTitr;
        biasEnergyAndDerivs[6] = dDiscr_dTaut;
        biasEnergyAndDerivs[7] = dPh_dTaut;
        biasEnergyAndDerivs[8] = -dMod_dTaut;
    }

    public double getTitrationLambda(Residue residue) {
        if (this.titratingResidueList.contains(residue)) {
            int resIndex = this.titratingResidueList.indexOf(residue);
            return this.extendedLambdas[resIndex];
        }
        return 1.0;
    }

    public double getTautomerLambda(Residue residue) {
        if (this.tautomerizingResidueList.contains(residue)) {
            int resIndex = this.tautomerizingResidueList.indexOf(residue);
            return this.extendedLambdas[this.nTitr + resIndex];
        }
        return 1.0;
    }

    private double getVdwDeriv(int esvID) {
        return this.esvVdwDerivs[esvID].get();
    }

    private double getPermElecDeriv(int esvID) {
        return this.esvPermElecDerivs[esvID].get();
    }

    private double getIndElecDeriv(int esvID) {
        return this.esvIndElecDerivs[esvID].get();
    }

    public boolean isTautomer(Residue residue) {
        if (residue.getResidueType() == Residue.ResidueType.NA) {
            return false;
        }
        AminoAcidUtils.AminoAcid3 AA3 = residue.getAminoAcid3();
        return AA3.isConstantPhTautomer;
    }

    private void updateLambdas() {
        int i;
        if (this.lockStates) {
            return;
        }
        double[] thetaPosition = this.esvState.x();
        for (i = 0; i < this.nESVs; ++i) {
            if ((this.fixTitrationState || i >= this.nTitr) && (this.fixTautomerState || i < this.nTitr)) continue;
            double sinTheta = Math.sin(thetaPosition[i]);
            this.extendedLambdas[i] = sinTheta * sinTheta;
        }
        for (i = 0; i < this.nAtoms; ++i) {
            int mappedTitrationIndex = this.titrationIndexMap[i];
            int mappedTautomerIndex = this.tautomerIndexMap[i] + this.nTitr;
            if (this.isTitrating(i) && mappedTitrationIndex != -1) {
                this.titrationLambdas[i] = this.extendedLambdas[mappedTitrationIndex];
            }
            if (!this.isTautomerizing(i) || mappedTautomerIndex < this.nTitr) continue;
            this.tautomerLambdas[i] = this.extendedLambdas[mappedTautomerIndex];
        }
        this.setESVHistogram();
    }

    public boolean isTitrating(int atomIndex) {
        return this.isTitrating[atomIndex];
    }

    public boolean isTautomerizing(int atomIndex) {
        return this.isTautomerizing[atomIndex];
    }

    private void setESVHistogram() {
        for (Residue residue : this.titratingResidueList) {
            double titrLambda;
            int index = this.titratingResidueList.indexOf(residue);
            if (residue.getAminoAcid3().equals((Object)AminoAcidUtils.AminoAcid3.LYS)) {
                titrLambda = this.getTitrationLambda(residue);
                this.esvHistogram(index, titrLambda);
                continue;
            }
            titrLambda = this.getTitrationLambda(residue);
            double tautLambda = this.getTautomerLambda(residue);
            this.esvHistogram(index, titrLambda, tautLambda);
        }
    }

    private void esvHistogram(int esv, double lambda) {
        int value = (int)(lambda * 10.0);
        if (value == 10) {
            value = 9;
        }
        int[] nArray = this.esvHistogram[esv][value];
        nArray[0] = nArray[0] + 1;
    }

    private void esvHistogram(int esv, double titrLambda, double tautLambda) {
        int tautValue;
        int titrValue = (int)(titrLambda * 10.0);
        if (titrValue == 10) {
            titrValue = 9;
        }
        if ((tautValue = (int)(tautLambda * 10.0)) == 10) {
            tautValue = 9;
        }
        int[] nArray = this.esvHistogram[esv][titrValue];
        int n = tautValue;
        nArray[n] = nArray[n] + 1;
    }

    private double initialTitrationState(Residue residue, double initialLambda, boolean guessTitrState) {
        AminoAcidUtils.AminoAcid3 AA3 = residue.getAminoAcid3();
        double residueNumber = residue.getResidueNumber();
        double initialTitrationLambda = 0.0;
        if (this.specialResidues.contains(residueNumber)) {
            if (!this.specialResiduePKAs.isEmpty()) {
                initialTitrationLambda = this.constantSystemPh < this.specialResiduePKAs.get(this.specialResidues.indexOf(residueNumber)) ? 1.0 : 0.0;
            }
        } else if (!guessTitrState) {
            initialTitrationLambda = initialLambda;
        } else {
            initialTitrationLambda = switch (AA3) {
                case AminoAcidUtils.AminoAcid3.ASD -> {
                    if (this.constantSystemPh < TitrationUtils.Titration.ASHtoASP.pKa) {
                        yield 1.0;
                    }
                    yield 0.0;
                }
                case AminoAcidUtils.AminoAcid3.GLD -> {
                    if (this.constantSystemPh < TitrationUtils.Titration.GLHtoGLU.pKa) {
                        yield 1.0;
                    }
                    yield 0.0;
                }
                case AminoAcidUtils.AminoAcid3.HIS -> {
                    if (this.constantSystemPh < TitrationUtils.Titration.HIStoHID.pKa) {
                        yield 1.0;
                    }
                    yield 0.0;
                }
                case AminoAcidUtils.AminoAcid3.LYS -> {
                    if (this.constantSystemPh < TitrationUtils.Titration.LYStoLYD.pKa) {
                        yield 1.0;
                    }
                    yield 0.0;
                }
                case AminoAcidUtils.AminoAcid3.CYS -> {
                    if (this.constantSystemPh < TitrationUtils.Titration.CYStoCYD.pKa) {
                        yield 1.0;
                    }
                    yield 0.0;
                }
                default -> initialLambda;
            };
        }
        return initialTitrationLambda;
    }

    public boolean isTitratingHeavy(int atomIndex) {
        return this.isTitratingHeavy[atomIndex];
    }

    public ArrayList<Double> getSpecialResidueList() {
        return this.specialResidues;
    }

    public void setFixedTautomerState(boolean fixTautomerState) {
        this.fixTautomerState = fixTautomerState;
    }

    public void setFixedTitrationState(boolean fixTitrationState) {
        this.fixTitrationState = fixTitrationState;
    }

    public void reGuessLambdas() {
        logger.info(" Reinitializing lambdas to match pH");
        for (Residue residue : this.titratingResidueList) {
            double lambda = this.initialTitrationState(residue, 1.0, true);
            this.setTitrationLambda(residue, lambda);
            double tautomerLambda = (int)Math.round(FastMath.random());
            this.setTautomerLambda(residue, tautomerLambda);
        }
    }

    public void setTautomerLambda(Residue residue, double lambda) {
        this.setTautomerLambda(residue, lambda, true);
    }

    public void setTautomerLambda(Residue residue, double lambda, boolean changeThetas) {
        double[] thetaPosition = this.esvState.x();
        if (this.tautomerizingResidueList.contains(residue) && !this.lockStates) {
            int index = this.tautomerizingResidueList.indexOf(residue) + this.nTitr;
            this.extendedLambdas[index] = lambda;
            if (changeThetas) {
                thetaPosition[index] = Math.asin(Math.sqrt(lambda));
            }
            List<Atom> currentAtomList = residue.getSideChainAtoms();
            for (Atom atom : currentAtomList) {
                int atomIndex = atom.getArrayIndex();
                this.tautomerLambdas[atomIndex] = lambda;
            }
        }
    }

    public void setTitrationLambda(Residue residue, double lambda) {
        this.setTitrationLambda(residue, lambda, true);
    }

    public void setTitrationLambda(Residue residue, double lambda, boolean changeThetas) {
        double[] thetaPosition = this.esvState.x();
        if (this.titratingResidueList.contains(residue) && !this.lockStates) {
            int index = this.titratingResidueList.indexOf(residue);
            this.extendedLambdas[index] = lambda;
            if (changeThetas) {
                thetaPosition[index] = Math.asin(Math.sqrt(lambda));
            }
            List<Atom> currentAtomList = residue.getSideChainAtoms();
            for (Atom atom : currentAtomList) {
                int atomIndex = atom.getArrayIndex();
                this.titrationLambdas[atomIndex] = lambda;
            }
        }
    }

    public int[][] getESVHistogram(int[][] histogram) {
        for (int i = 0; i < this.titratingResidueList.size(); ++i) {
            int h = 0;
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    histogram[i][h++] = this.esvHistogram[i][j][k];
                }
            }
        }
        return histogram;
    }

    public void copyESVHistogramTo(int[][] histogram) {
        for (int i = 0; i < this.titratingResidueList.size(); ++i) {
            int h = 0;
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    this.esvHistogram[i][j][k] = histogram[i][h++];
                }
            }
        }
    }

    public void initEsvVdw() {
        for (int i = 0; i < this.nESVs; ++i) {
            this.esvVdwDerivs[i].set(0.0);
        }
    }

    public void initEsvPermElec() {
        for (int i = 0; i < this.nESVs; ++i) {
            this.esvPermElecDerivs[i].set(0.0);
        }
    }

    public void initEsvIndElec() {
        for (int i = 0; i < this.nESVs; ++i) {
            this.esvIndElecDerivs[i].set(0.0);
        }
    }

    public double getTitrationLambda(int atomIndex) {
        return this.titrationLambdas[atomIndex];
    }

    public int getTitrationESVIndex(int i) {
        return this.titrationIndexMap[i];
    }

    public double getTautomerLambda(int atomIndex) {
        return this.tautomerLambdas[atomIndex];
    }

    public int getTautomerESVIndex(int i) {
        return this.tautomerIndexMap[i];
    }

    public List<Residue> getTitratingResidueList() {
        return this.titratingResidueList;
    }

    public List<Residue> getTautomerizingResidueList() {
        return this.tautomerizingResidueList;
    }

    public List<Residue> getExtendedResidueList() {
        return this.extendedResidueList;
    }

    public double getThetaMass() {
        return this.thetaMass;
    }

    public double getThetaFriction() {
        return this.thetaFriction;
    }

    public double[] getExtendedLambdas() {
        double[] lambdas = new double[this.nESVs];
        System.arraycopy(this.extendedLambdas, 0, lambdas, 0, lambdas.length);
        return lambdas;
    }

    public String getLambdaList() {
        if (this.nESVs < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nESVs; ++i) {
            if (i == 0) {
                sb.append("\n  Titration Lambdas: ");
            }
            if (i > 0) {
                sb.append(", ");
            }
            if (i == this.nTitr) {
                sb.append("\n  Tautomer Lambdas: ");
            }
            sb.append(String.format("%6.4f", this.extendedLambdas[i]));
        }
        return sb.toString();
    }

    public Atom[] getExtendedAtoms() {
        return this.extendedAtoms;
    }

    public int[] getExtendedMolecule() {
        return this.extendedMolecules;
    }

    public double getBiasEnergy() {
        double totalBiasEnergy = 0.0;
        double[] biasEnergyComponents = new double[9];
        for (Residue residue : this.titratingResidueList) {
            this.getBiasTerms(residue, biasEnergyComponents);
            double biasEnergy = biasEnergyComponents[0] + biasEnergyComponents[1] + biasEnergyComponents[2];
            totalBiasEnergy += biasEnergy;
        }
        return totalBiasEnergy;
    }

    public String getBiasDecomposition() {
        double discrBias = 0.0;
        double phBias = 0.0;
        double modelBias = 0.0;
        double[] biasEnergyAndDerivs = new double[9];
        for (Residue residue : this.titratingResidueList) {
            this.getBiasTerms(residue, biasEnergyAndDerivs);
            discrBias += biasEnergyAndDerivs[0];
            phBias += biasEnergyAndDerivs[1];
            modelBias += biasEnergyAndDerivs[2];
        }
        return String.format("    %-16s %16.8f\n", "Discretizer", discrBias) + String.format("    %-16s %16.8f\n", "Acidostat", phBias) + String.format("    %-16s %16.8f\n", "Fmod", modelBias);
    }

    public void getVdwPrefactor(int atomIndex, double[] vdwPrefactorAndDerivs) {
        double prefactor = 1.0;
        double titrationDeriv = 0.0;
        double tautomerDeriv = 0.0;
        if (!this.isTitratingHydrogen(atomIndex) || !this.doVDW) {
            vdwPrefactorAndDerivs[0] = prefactor;
            vdwPrefactorAndDerivs[1] = titrationDeriv;
            vdwPrefactorAndDerivs[2] = tautomerDeriv;
            return;
        }
        AminoAcidUtils.AminoAcid3 AA3 = this.residueNames[atomIndex];
        switch (AA3) {
            case ASD: 
            case GLD: {
                if (this.tautomerDirections[atomIndex] == 1) {
                    prefactor = this.titrationLambdas[atomIndex] * this.tautomerLambdas[atomIndex];
                    titrationDeriv = this.tautomerLambdas[atomIndex];
                    tautomerDeriv = this.titrationLambdas[atomIndex];
                    break;
                }
                if (this.tautomerDirections[atomIndex] != -1) break;
                prefactor = this.titrationLambdas[atomIndex] * (1.0 - this.tautomerLambdas[atomIndex]);
                titrationDeriv = 1.0 - this.tautomerLambdas[atomIndex];
                tautomerDeriv = -this.titrationLambdas[atomIndex];
                break;
            }
            case HIS: {
                if (this.tautomerDirections[atomIndex] == 1) {
                    prefactor = (1.0 - this.titrationLambdas[atomIndex]) * this.tautomerLambdas[atomIndex] + this.titrationLambdas[atomIndex];
                    titrationDeriv = -this.tautomerLambdas[atomIndex] + 1.0;
                    tautomerDeriv = 1.0 - this.titrationLambdas[atomIndex];
                    break;
                }
                if (this.tautomerDirections[atomIndex] != -1) break;
                prefactor = (1.0 - this.titrationLambdas[atomIndex]) * (1.0 - this.tautomerLambdas[atomIndex]) + this.titrationLambdas[atomIndex];
                titrationDeriv = this.tautomerLambdas[atomIndex];
                tautomerDeriv = -(1.0 - this.titrationLambdas[atomIndex]);
                break;
            }
            case LYS: 
            case CYS: {
                prefactor = this.titrationLambdas[atomIndex];
                titrationDeriv = 1.0;
                tautomerDeriv = 0.0;
            }
        }
        vdwPrefactorAndDerivs[0] = prefactor;
        vdwPrefactorAndDerivs[1] = titrationDeriv;
        vdwPrefactorAndDerivs[2] = tautomerDeriv;
    }

    public boolean isTitratingHydrogen(int atomIndex) {
        return this.isTitratingHydrogen[atomIndex];
    }

    public void addVdwDeriv(int atomI, double vdwEnergy, double[] vdwPrefactorAndDerivI, double vdwPrefactorJ) {
        if (!this.isTitratingHydrogen(atomI)) {
            return;
        }
        int titrationEsvIndex = this.titrationIndexMap[atomI];
        int tautomerEsvIndex = this.tautomerIndexMap[atomI] + this.nTitr;
        double dTitr_dLambda = vdwPrefactorAndDerivI[1] * vdwPrefactorJ * vdwEnergy;
        double dTaut_dLambda = vdwPrefactorAndDerivI[2] * vdwPrefactorJ * vdwEnergy;
        this.esvVdwDerivs[titrationEsvIndex].addAndGet(dTitr_dLambda);
        if (tautomerEsvIndex >= this.nTitr) {
            this.esvVdwDerivs[tautomerEsvIndex].addAndGet(dTaut_dLambda);
        }
    }

    public void addPermElecDeriv(int atomI, double titrationEnergy, double tautomerEnergy) {
        int titrationEsvIndex = this.titrationIndexMap[atomI];
        int tautomerEsvIndex = this.tautomerIndexMap[atomI] + this.nTitr;
        this.esvPermElecDerivs[titrationEsvIndex].addAndGet(titrationEnergy);
        if (tautomerEsvIndex >= this.nTitr) {
            this.esvPermElecDerivs[tautomerEsvIndex].addAndGet(tautomerEnergy);
        }
    }

    public void addIndElecDeriv(int atomI, double titrationEnergy, double tautomerEnergy) {
        int titrationEsvIndex = this.titrationIndexMap[atomI];
        int tautomerEsvIndex = this.tautomerIndexMap[atomI] + this.nTitr;
        this.esvIndElecDerivs[titrationEsvIndex].addAndGet(titrationEnergy);
        if (tautomerEsvIndex >= this.nTitr) {
            this.esvIndElecDerivs[tautomerEsvIndex].addAndGet(tautomerEnergy);
        }
    }

    public double getConstantPh() {
        return this.constantSystemPh;
    }

    public void setConstantPh(double pH) {
        this.constantSystemPh = pH;
    }

    public TitrationUtils getTitrationUtils() {
        return this.titrationUtils;
    }

    public void setRestartFile(File esvFile) {
        this.restartFile = esvFile;
    }

    public boolean writeESVInfoTo(File esvFile) {
        logger.info("Writing pH Dynamics out to: " + esvFile.getParentFile().getName() + File.separator + esvFile.getName());
        double[] thetaPosition = this.esvState.x();
        double[] thetaVelocity = this.esvState.v();
        double[] thetaAccel = this.esvState.a();
        return this.esvFilter.writeESV(esvFile, thetaPosition, thetaVelocity, thetaAccel, this.titratingResidueList, this.esvHistogram, this.constantSystemPh);
    }

    public boolean readESVInfoFrom(File esvFile) {
        double[] thetaPosition = this.esvState.x();
        double[] thetaVelocity = this.esvState.v();
        double[] thetaAccel = this.esvState.a();
        return this.esvFilter.readESV(esvFile, thetaPosition, thetaVelocity, thetaAccel, this.esvHistogram);
    }

    public void setTemperature(double set) {
        this.currentTemperature = set;
    }

    public void preForce() {
        this.updateLambdas();
    }

    public void writeRestart() {
        double[] thetaAccel;
        double[] thetaVelocity;
        String esvName = FileUtils.relativePathTo((File)this.restartFile).toString();
        double[] thetaPosition = this.esvState.x();
        if (this.esvFilter.writeESV(this.restartFile, thetaPosition, thetaVelocity = this.esvState.v(), thetaAccel = this.esvState.a(), this.titratingResidueList, this.esvHistogram, this.constantSystemPh)) {
            logger.info(" Wrote PhDynamics restart file to " + esvName);
        } else {
            logger.info(" Writing PhDynamics restart file to " + esvName + " failed");
        }
    }

    public void writeLambdaHistogram(boolean printHistograms) {
        this.printProtonationRatios();
        if (printHistograms) {
            logger.info(this.esvFilter.getLambdaHistogram(this.titratingResidueList, this.esvHistogram, this.constantSystemPh));
        }
    }

    public void printProtonationRatios() {
        for (int i = 0; i < this.esvHistogram.length; ++i) {
            int[] rowSums = new int[this.esvHistogram[i].length];
            for (int j = 0; j < this.esvHistogram[i].length; ++j) {
                for (int k = 0; k < this.esvHistogram[i][j].length; ++k) {
                    int n = j;
                    rowSums[n] = rowSums[n] + this.esvHistogram[i][j][k];
                }
            }
            int i1 = rowSums[0] + rowSums[rowSums.length - 1];
            double buf = i1 == 0 ? 0.0 : 0.001;
            logger.info(" " + this.extendedResidueList.get(i).toString() + " Deprotonation Fraction at pH " + this.constantSystemPh + ": " + (double)rowSums[0] / ((double)i1 + buf));
            if (buf != 0.0) continue;
            logger.info(" Buffer required to avoid division by 0");
        }
    }

    public double[] getAcceleration(double[] acceleration) {
        return this.getThetaAccel();
    }

    public double[] getThetaAccel() {
        return this.esvState.a();
    }

    public double energyAndGradient(double[] x, double[] g) {
        double[] thetaPosition = this.esvState.x();
        System.arraycopy(x, 0, thetaPosition, 0, thetaPosition.length);
        this.updateLambdas();
        this.fillESVgradient(g);
        return this.energy(x);
    }

    public List<Constraint> getConstraints() {
        return this.constraints.isEmpty() ? Collections.emptyList() : new ArrayList<Constraint>(this.constraints);
    }

    public Potential.STATE getEnergyTermState() {
        return null;
    }

    private double[] fillESVgradient(double[] g) {
        double[] gradESV = this.postForce();
        System.arraycopy(gradESV, 0, g, 0, g.length);
        return g;
    }

    public void setEnergyTermState(Potential.STATE state) {
    }

    public double[] getMass() {
        return this.getThetaMassArray();
    }

    public double[] postForce() {
        double[] thetaPosition = this.esvState.x();
        double[] dEdL = this.getDerivatives();
        double[] dEdTheta = new double[dEdL.length];
        for (int i = 0; i < this.nESVs; ++i) {
            dEdTheta[i] = dEdL[i] * FastMath.sin((double)(2.0 * thetaPosition[i]));
        }
        return dEdTheta;
    }

    public double[] getThetaMassArray() {
        return this.esvState.getMass();
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        return new double[0];
    }

    public double energy(double[] x) {
        double[] coords = new double[this.forceFieldEnergy.getNumberOfVariables()];
        this.forceFieldEnergy.getCoordinates(coords);
        return this.forceFieldEnergy.energy(coords);
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        return new Potential.VARIABLE_TYPE[0];
    }

    public double[] getVelocity(double[] velocity) {
        return this.getThetaVelocity();
    }

    public double[] getThetaVelocity() {
        return this.esvState.v();
    }

    public void setAcceleration(double[] acceleration) {
    }

    public double[] getCoordinates(double[] parameters) {
        return this.getThetaPosition();
    }

    public void setCoordinates(double[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
    }

    public void setVelocity(double[] velocity) {
    }

    public SystemState getState() {
        return this.esvState;
    }

    public double[] getThetaPosition() {
        return this.esvState.x();
    }

    public int getNumberOfVariables() {
        return this.nESVs;
    }

    public double[] getScaling() {
        double[] scaling = new double[this.nESVs];
        Arrays.fill(scaling, 1.0);
        return scaling;
    }

    public void setScaling(double[] scaling) {
    }

    public double getTotalEnergy() {
        return 0.0;
    }
}

