/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.constraint;

import ffx.numerics.Constraint;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class SettleConstraint
implements Constraint {
    private static final Logger logger = Logger.getLogger(SettleConstraint.class.getName());
    private final int index0;
    private final int index1;
    private final int index2;
    private final double distance1;
    private final double distance2;

    private SettleConstraint(Angle a012) {
        Atom center = a012.getCentralAtom();
        this.index0 = center.getXyzIndex() - 1;
        Bond b01 = a012.getBond(0);
        Bond b02 = a012.getBond(1);
        assert (b01.bondType.distance == b02.bondType.distance);
        this.distance1 = b01.bondType.distance;
        Atom a1 = b01.get1_2(center);
        Atom a2 = b02.get1_2(center);
        this.index1 = a1.getXyzIndex() - 1;
        this.index2 = a2.getXyzIndex() - 1;
        double angVal = a012.angleType.angle[a012.nh];
        this.distance2 = SettleConstraint.lawOfCosines(this.distance1, this.distance1, angVal);
    }

    public static SettleConstraint settleFactory(Angle a012) {
        SettleConstraint newC = new SettleConstraint(a012);
        a012.setConstraint(newC);
        return newC;
    }

    static double lawOfCosines(double distAB, double distBC, double angABC) {
        double val = distAB * distAB;
        val += distBC * distBC;
        val -= 2.0 * distAB * distBC * FastMath.cos((double)FastMath.toRadians((double)angABC));
        val = FastMath.sqrt((double)val);
        return val;
    }

    public void applyConstraintToStep(double[] xPrior, double[] xNew, double[] masses, double tol) {
        int xi0 = 3 * this.index0;
        int xi1 = 3 * this.index1;
        int xi2 = 3 * this.index2;
        double[] apos0 = new double[3];
        double[] apos1 = new double[3];
        double[] apos2 = new double[3];
        double[] xp0 = new double[3];
        double[] xp1 = new double[3];
        double[] xp2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            apos0[i] = xPrior[xi0 + i];
            xp0[i] = xNew[xi0 + i] - apos0[i];
            apos1[i] = xPrior[xi1 + i];
            xp1[i] = xNew[xi1 + i] - apos1[i];
            apos2[i] = xPrior[xi2 + i];
            xp2[i] = xNew[xi2 + i] - apos2[i];
        }
        double m0 = masses[xi0];
        double m1 = masses[xi1];
        double m2 = masses[xi2];
        double xb0 = apos1[0] - apos0[0];
        double yb0 = apos1[1] - apos0[1];
        double zb0 = apos1[2] - apos0[2];
        double xc0 = apos2[0] - apos0[0];
        double yc0 = apos2[1] - apos0[1];
        double zc0 = apos2[2] - apos0[2];
        double invTotalMass = 1.0 / (m0 + m1 + m2);
        double xcom = (xp0[0] * m0 + (xb0 + xp1[0]) * m1 + (xc0 + xp2[0]) * m2) * invTotalMass;
        double ycom = (xp0[1] * m0 + (yb0 + xp1[1]) * m1 + (yc0 + xp2[1]) * m2) * invTotalMass;
        double zcom = (xp0[2] * m0 + (zb0 + xp1[2]) * m1 + (zc0 + xp2[2]) * m2) * invTotalMass;
        double xa1 = xp0[0] - xcom;
        double ya1 = xp0[1] - ycom;
        double za1 = xp0[2] - zcom;
        double xb1 = xb0 + xp1[0] - xcom;
        double yb1 = yb0 + xp1[1] - ycom;
        double zb1 = zb0 + xp1[2] - zcom;
        double xc1 = xc0 + xp2[0] - xcom;
        double yc1 = yc0 + xp2[1] - ycom;
        double zc1 = zc0 + xp2[2] - zcom;
        double xaksZd = yb0 * zc0 - zb0 * yc0;
        double yaksZd = zb0 * xc0 - xb0 * zc0;
        double zaksZd = xb0 * yc0 - yb0 * xc0;
        double xaksXd = ya1 * zaksZd - za1 * yaksZd;
        double yaksXd = za1 * xaksZd - xa1 * zaksZd;
        double zaksXd = xa1 * yaksZd - ya1 * xaksZd;
        double xaksYd = yaksZd * zaksXd - zaksZd * yaksXd;
        double yaksYd = zaksZd * xaksXd - xaksZd * zaksXd;
        double zaksYd = xaksZd * yaksXd - yaksZd * xaksXd;
        double axlng = FastMath.sqrt((double)(xaksXd * xaksXd + yaksXd * yaksXd + zaksXd * zaksXd));
        double aylng = FastMath.sqrt((double)(xaksYd * xaksYd + yaksYd * yaksYd + zaksYd * zaksYd));
        double azlng = FastMath.sqrt((double)(xaksZd * xaksZd + yaksZd * yaksZd + zaksZd * zaksZd));
        double trns11 = xaksXd / axlng;
        double trns21 = yaksXd / axlng;
        double trns31 = zaksXd / axlng;
        double trns12 = xaksYd / aylng;
        double trns22 = yaksYd / aylng;
        double trns32 = zaksYd / aylng;
        double trns13 = xaksZd / azlng;
        double trns23 = yaksZd / azlng;
        double trns33 = zaksZd / azlng;
        double xb0d = trns11 * xb0 + trns21 * yb0 + trns31 * zb0;
        double yb0d = trns12 * xb0 + trns22 * yb0 + trns32 * zb0;
        double xc0d = trns11 * xc0 + trns21 * yc0 + trns31 * zc0;
        double yc0d = trns12 * xc0 + trns22 * yc0 + trns32 * zc0;
        double za1d = trns13 * xa1 + trns23 * ya1 + trns33 * za1;
        double xb1d = trns11 * xb1 + trns21 * yb1 + trns31 * zb1;
        double yb1d = trns12 * xb1 + trns22 * yb1 + trns32 * zb1;
        double zb1d = trns13 * xb1 + trns23 * yb1 + trns33 * zb1;
        double xc1d = trns11 * xc1 + trns21 * yc1 + trns31 * zc1;
        double yc1d = trns12 * xc1 + trns22 * yc1 + trns32 * zc1;
        double zc1d = trns13 * xc1 + trns23 * yc1 + trns33 * zc1;
        double rc = 0.5 * this.distance2;
        double rb = FastMath.sqrt((double)(this.distance1 * this.distance1 - rc * rc));
        double ra = rb * (m1 + m2) * invTotalMass;
        rb -= ra;
        double sinphi = za1d / ra;
        double cosphi = FastMath.sqrt((double)(1.0 - sinphi * sinphi));
        double sinpsi = (zb1d - zc1d) / (2.0 * rc * cosphi);
        double cospsi = FastMath.sqrt((double)(1.0 - sinpsi * sinpsi));
        double ya2d = ra * cosphi;
        double xb2d = -rc * cospsi;
        double yb2d = -rb * cosphi - rc * sinpsi * sinphi;
        double yc2d = -rb * cosphi + rc * sinpsi * sinphi;
        double xb2d2 = xb2d * xb2d;
        double hh2 = 4.0 * xb2d2 + (yb2d - yc2d) * (yb2d - yc2d) + (zb1d - zc1d) * (zb1d - zc1d);
        double deltx = 2.0 * xb2d + FastMath.sqrt((double)(4.0 * xb2d2 - hh2 + this.distance2 * this.distance2));
        double alpha = (xb2d -= deltx * 0.5) * (xb0d - xc0d) + yb0d * yb2d + yc0d * yc2d;
        double beta = xb2d * (yc0d - yb0d) + xb0d * yb2d + xc0d * yc2d;
        double gamma = xb0d * yb1d - xb1d * yb0d + xc0d * yc1d - xc1d * yc0d;
        double al2be2 = alpha * alpha + beta * beta;
        double sintheta = (alpha * gamma - beta * FastMath.sqrt((double)(al2be2 - gamma * gamma))) / al2be2;
        double costheta = FastMath.sqrt((double)(1.0 - sintheta * sintheta));
        double xa3d = -ya2d * sintheta;
        double ya3d = ya2d * costheta;
        double za3d = za1d;
        double xb3d = xb2d * costheta - yb2d * sintheta;
        double yb3d = xb2d * sintheta + yb2d * costheta;
        double zb3d = zb1d;
        double xc3d = -xb2d * costheta - yc2d * sintheta;
        double yc3d = -xb2d * sintheta + yc2d * costheta;
        double zc3d = zc1d;
        double xa3 = trns11 * xa3d + trns12 * ya3d + trns13 * za3d;
        double ya3 = trns21 * xa3d + trns22 * ya3d + trns23 * za3d;
        double za3 = trns31 * xa3d + trns32 * ya3d + trns33 * za3d;
        double xb3 = trns11 * xb3d + trns12 * yb3d + trns13 * zb3d;
        double yb3 = trns21 * xb3d + trns22 * yb3d + trns23 * zb3d;
        double zb3 = trns31 * xb3d + trns32 * yb3d + trns33 * zb3d;
        double xc3 = trns11 * xc3d + trns12 * yc3d + trns13 * zc3d;
        double yc3 = trns21 * xc3d + trns22 * yc3d + trns23 * zc3d;
        double zc3 = trns31 * xc3d + trns32 * yc3d + trns33 * zc3d;
        xp0[0] = xcom + xa3;
        xp0[1] = ycom + ya3;
        xp0[2] = zcom + za3;
        xp1[0] = xcom + xb3 - xb0;
        xp1[1] = ycom + yb3 - yb0;
        xp1[2] = zcom + zb3 - zb0;
        xp2[0] = xcom + xc3 - xc0;
        xp2[1] = ycom + yc3 - yc0;
        xp2[2] = zcom + zc3 - zc0;
        for (int i = 0; i < 3; ++i) {
            xNew[xi0 + i] = xp0[i] + apos0[i];
            xNew[xi1 + i] = xp1[i] + apos1[i];
            xNew[xi2 + i] = xp2[i] + apos2[i];
        }
    }

    public void applyConstraintToVelocities(double[] x, double[] v, double[] masses, double tol) {
        int i;
        int xi0 = 3 * this.index0;
        int xi1 = 3 * this.index1;
        int xi2 = 3 * this.index2;
        double[] apos0 = new double[3];
        double[] apos1 = new double[3];
        double[] apos2 = new double[3];
        double[] v0 = new double[3];
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        for (i = 0; i < 3; ++i) {
            apos0[i] = x[xi0 + i];
            apos1[i] = x[xi1 + i];
            apos2[i] = x[xi2 + i];
        }
        for (i = 0; i < 3; ++i) {
            v0[i] = v[xi0 + i];
            v1[i] = v[xi1 + i];
            v2[i] = v[xi2 + i];
        }
        double mA = masses[xi0];
        double mB = masses[xi1];
        double mC = masses[xi2];
        double[] eAB = new double[3];
        double[] eBC = new double[3];
        double[] eCA = new double[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            eAB[i2] = apos1[i2] - apos0[i2];
            eBC[i2] = apos2[i2] - apos1[i2];
            eCA[i2] = apos0[i2] - apos2[i2];
        }
        DoubleMath.normalize((double[])eAB, (double[])eAB);
        DoubleMath.normalize((double[])eBC, (double[])eBC);
        DoubleMath.normalize((double[])eCA, (double[])eCA);
        double vAB = (v1[0] - v0[0]) * eAB[0] + (v1[1] - v0[1]) * eAB[1] + (v1[2] - v0[2]) * eAB[2];
        double vBC = (v2[0] - v1[0]) * eBC[0] + (v2[1] - v1[1]) * eBC[1] + (v2[2] - v1[2]) * eBC[2];
        double vCA = (v0[0] - v2[0]) * eCA[0] + (v0[1] - v2[1]) * eCA[1] + (v0[2] - v2[2]) * eCA[2];
        double cA = -(eAB[0] * eCA[0] + eAB[1] * eCA[1] + eAB[2] * eCA[2]);
        double cB = -(eAB[0] * eBC[0] + eAB[1] * eBC[1] + eAB[2] * eBC[2]);
        double cC = -(eBC[0] * eCA[0] + eBC[1] * eCA[1] + eBC[2] * eCA[2]);
        double s2A = 1.0 - cA * cA;
        double s2B = 1.0 - cB * cB;
        double s2C = 1.0 - cC * cC;
        double mABCinv = 1.0 / (mA * mB * mC);
        double denom = (((s2A * mB + s2B * mA) * mC + (s2A * mB * mB + 2.0 * (cA * cB * cC + 1.0) * mA * mB + s2B * mA * mA)) * mC + s2C * mA * mB * (mA + mB)) * mABCinv;
        double tab = ((cB * cC * mA - cA * mB - cA * mC) * vCA + (cA * cC * mB - cB * mC - cB * mA) * vBC + (s2C * mA * mA * mB * mB * mABCinv + (mA + mB + mC)) * vAB) / denom;
        double tbc = ((cA * cB * mC - cC * mB - cC * mA) * vCA + (s2A * mB * mB * mC * mC * mABCinv + (mA + mB + mC)) * vBC + (cA * cC * mB - cB * mA - cB * mC) * vAB) / denom;
        double tca = ((s2B * mA * mA * mC * mC * mABCinv + (mA + mB + mC)) * vCA + (cA * cB * mC - cC * mB - cC * mA) * vBC + (cB * cC * mA - cA * mB - cA * mC) * vAB) / denom;
        double invMA = 1.0 / mA;
        double invMB = 1.0 / mB;
        double invMC = 1.0 / mC;
        for (int i3 = 0; i3 < 3; ++i3) {
            int n = i3;
            v0[n] = v0[n] + (eAB[i3] * tab - eCA[i3] * tca) * invMA;
            int n2 = i3;
            v1[n2] = v1[n2] + (eBC[i3] * tbc - eAB[i3] * tab) * invMB;
            int n3 = i3;
            v2[n3] = v2[n3] + (eCA[i3] * tca - eBC[i3] * tbc) * invMC;
        }
        System.arraycopy(v0, 0, v, xi0, 3);
        System.arraycopy(v1, 0, v, xi1, 3);
        System.arraycopy(v2, 0, v, xi2, 3);
    }

    public int[] constrainedAtomIndices() {
        return new int[]{this.index0, this.index1, this.index2};
    }

    public boolean constraintSatisfied(double[] x, double tol) {
        return this.constraintSatisfied(x, null, tol, 0.0);
    }

    public boolean constraintSatisfied(double[] x, double[] v, double xTol, double vTol) {
        int xi0 = 3 * this.index0;
        int xi1 = 3 * this.index1;
        int xi2 = 3 * this.index2;
        double dist01 = 0.0;
        double dist02 = 0.0;
        double dist12 = 0.0;
        double[] x0 = new double[3];
        double[] x1 = new double[3];
        double[] x2 = new double[3];
        System.arraycopy(x, xi0, x0, 0, 3);
        System.arraycopy(x, xi1, x1, 0, 3);
        System.arraycopy(x, xi2, x2, 0, 3);
        for (int i = 0; i < 3; ++i) {
            double dx = x0[i] - x1[i];
            dx *= dx;
            dist01 += dx;
            dx = x0[i] - x2[i];
            dx *= dx;
            dist02 += dx;
            dx = x1[i] - x2[i];
            dx *= dx;
            dist12 += dx;
        }
        dist01 = FastMath.sqrt((double)dist01);
        dist02 = FastMath.sqrt((double)dist02);
        dist12 = FastMath.sqrt((double)dist12);
        double deltaIdeal = Math.abs((dist01 - this.distance1) / this.distance1);
        if (deltaIdeal > xTol) {
            logger.finer(" delId 01: " + deltaIdeal);
            return false;
        }
        deltaIdeal = Math.abs((dist02 - this.distance1) / this.distance1);
        if (deltaIdeal > xTol) {
            logger.finer(" delId 02: " + deltaIdeal);
            return false;
        }
        deltaIdeal = Math.abs((dist12 - this.distance2) / this.distance2);
        if (deltaIdeal > xTol) {
            logger.finer(" delId 12: " + deltaIdeal);
            return false;
        }
        if (v != null && vTol > 0.0) {
            double[] v0 = new double[3];
            double[] v1 = new double[3];
            double[] v2 = new double[3];
            System.arraycopy(v, xi0, v0, 0, 3);
            System.arraycopy(v, xi1, v1, 0, 3);
            System.arraycopy(v, xi2, v2, 0, 3);
            double[] v01 = new double[3];
            double[] v02 = new double[3];
            double[] v12 = new double[3];
            DoubleMath.sub((double[])v1, (double[])v0, (double[])v01);
            DoubleMath.sub((double[])v2, (double[])v0, (double[])v02);
            DoubleMath.sub((double[])v2, (double[])v1, (double[])v12);
            double[] x01 = new double[3];
            double[] x02 = new double[3];
            double[] x12 = new double[3];
            DoubleMath.sub((double[])x1, (double[])x0, (double[])x01);
            DoubleMath.sub((double[])x2, (double[])x0, (double[])x02);
            DoubleMath.sub((double[])x2, (double[])x1, (double[])x12);
            double xv01 = DoubleMath.dot((double[])v01, (double[])x01);
            double xv02 = DoubleMath.dot((double[])v02, (double[])x02);
            double xv12 = DoubleMath.dot((double[])v12, (double[])x12);
            if (FastMath.abs((double)xv01) > vTol) {
                return false;
            }
            if (FastMath.abs((double)xv02) > vTol) {
                return false;
            }
            if (FastMath.abs((double)xv12) > vTol) {
                return false;
            }
        }
        return true;
    }

    public int getNumDegreesFrozen() {
        return 3;
    }
}

