/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands.test;

import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.GradientOptions;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.utils.GradientUtils;
import ffx.utilities.FFXBinding;
import java.util.Collections;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" Test the potential energy gradient."}, name="test.Gradient")
public class Gradient
extends PotentialCommand {
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    GradientOptions gradientOptions;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"A PDB or XYZ coordinate file."})
    String filename = null;
    private ForceFieldEnergy energy;
    public int nFailures = 0;

    public Gradient() {
    }

    public Gradient(FFXBinding binding) {
        super(binding);
    }

    public Gradient(String[] args) {
        super(args);
    }

    public Gradient run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Testing the atomic coordinate gradient of " + this.filename + "\n");
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        this.energy = this.activeAssembly.getPotentialEnergy();
        GradientUtils gradientUtils = new GradientUtils((Potential)this.energy);
        this.nFailures = gradientUtils.testGradient(this.gradientOptions);
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.energy == null ? Collections.emptyList() : Collections.singletonList(this.energy);
        return potentials;
    }
}

