/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.utilities.FFXBinding;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="WriteRestraints", description={" Log position restraints for a PDB file."})
public class WriteRestraints
extends PotentialCommand {
    @CommandLine.Option(names={"--chain", "-c"}, description={"Single character chain name."})
    private String chain = null;
    @CommandLine.Option(names={"-k", "--forceConstant"}, defaultValue="100.0", paramLabel="100.0", description={"The force constant (kcal/mol/A^2)."})
    private double forceConstant = 100.0;
    @CommandLine.Option(names={"-d", "--flatBottom"}, defaultValue="0.0", paramLabel="0.0", description={"The flat bottom distance in Angstroms."})
    private double fbDistance = 0.0;
    @CommandLine.Option(names={"--eh", "--excludeHydrogen"}, defaultValue="false", paramLabel="false", description={"Exclude writing restraints for hydrogen atoms."})
    private boolean excludeHydrogen = false;
    @CommandLine.Option(names={"--ca", "--cAlphas"}, defaultValue="false", paramLabel="false", description={"Only write restraints for alpha carbons and/or phosphorus's."})
    private boolean onlyCalphas = false;
    @CommandLine.Option(names={"-s", "--select"}, defaultValue="1", paramLabel="1", description={"Select every ith matching restraint and ignore the rest."})
    private int select = 1;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in XYZ or PDB format."})
    private String filename = null;

    public WriteRestraints() {
    }

    public WriteRestraints(FFXBinding binding) {
        super(binding);
    }

    public WriteRestraints(String[] args) {
        super(args);
    }

    public WriteRestraints run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Writing restraints for " + this.filename + "\n");
        SystemFilter systemFilter = this.potentialFunctions.getFilter();
        int count = 0;
        if (systemFilter instanceof PDBFilter) {
            Polymer[] polymers;
            for (Polymer polymer : polymers = this.activeAssembly.getChains()) {
                if (this.chain != null && !this.chain.isEmpty()) {
                    char current;
                    char requested = Character.toUpperCase(this.chain.charAt(0));
                    Character chainID = polymer.getChainID();
                    char c = current = chainID == null ? (char)'?' : (char)Character.toUpperCase(chainID.charValue());
                    if (current != requested) {
                        logger.info(" Skipping chain " + current);
                        continue;
                    }
                    logger.info(" Restraints for chain " + current);
                }
                List<Residue> residues = polymer.getResidues();
                for (Residue residue : residues) {
                    if (this.onlyCalphas) {
                        Atom atom = residue.getAtomByName("CA", true);
                        if (atom == null) {
                            atom = residue.getAtomByName("P", true);
                        }
                        if (atom == null) continue;
                        if (count % this.select == 0) {
                            this.writeRestraints(atom);
                        }
                        ++count;
                        continue;
                    }
                    List<Atom> atoms = residue.getAtomList();
                    for (Atom atom : atoms) {
                        if (this.excludeHydrogen && atom.isHydrogen()) continue;
                        if (count % this.select == 0) {
                            this.writeRestraints(atom);
                        }
                        ++count;
                    }
                }
            }
        } else {
            Atom[] atoms;
            for (Atom atom : atoms = this.activeAssembly.getAtomArray()) {
                if (this.excludeHydrogen && atom.isHydrogen()) continue;
                if (count % this.select == 0) {
                    this.writeRestraints(atom);
                }
                ++count;
            }
        }
        return this;
    }

    private void writeRestraints(Atom atom) {
        double x = atom.getX();
        double y = atom.getY();
        double z = atom.getZ();
        logger.info(String.format("restrain-position %4d %19.15f %19.15f %19.15f %12.8f %12.8f", atom.getIndex(), x, y, z, this.forceConstant, this.fbDistance));
    }
}

