/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.cli.TimerOptions;
import ffx.utilities.FFXBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(name="Timer", description={" Time energy evaluations."})
public class Timer
extends PotentialCommand {
    @CommandLine.Mixin
    private TimerOptions timer = new TimerOptions();
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;
    private ForceFieldEnergy energy = null;

    public Timer() {
    }

    public Timer(FFXBinding binding) {
        super(binding);
    }

    public Timer(String[] args) {
        super(args);
    }

    public Timer run() {
        if (!this.init()) {
            return this;
        }
        if (this.timer.getThreads() > 0) {
            System.setProperty("pj.nt", Integer.toString(this.timer.getThreads()));
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        if (this.timer.getNoGradient()) {
            logger.info("\n Timing energy for " + this.filename);
        } else {
            logger.info("\n Timing energy and gradient for " + this.filename);
        }
        int nEvals = this.timer.getIterations();
        this.energy = this.activeAssembly.getPotentialEnergy();
        long minTime = Long.MAX_VALUE;
        double sumTime2 = 0.0;
        int halfnEvals = nEvals % 2 == 1 ? nEvals / 2 : nEvals / 2 - 1;
        for (int i = 0; i < nEvals; ++i) {
            long time = -System.nanoTime();
            double e = this.energy.energy(!this.timer.getNoGradient(), this.timer.getVerbose());
            time += System.nanoTime();
            if (!this.timer.getVerbose()) {
                logger.info(String.format(" %4d Energy %16.8f in %6.3f (sec)", i, e, (double)time * 1.0E-9));
            }
            minTime = Math.min(time, minTime);
            if (i < nEvals / 2) continue;
            double time2 = (double)time * 1.0E-9;
            sumTime2 += time2 * time2;
        }
        double rmsTime = FastMath.sqrt((double)(sumTime2 / (double)(++halfnEvals)));
        logger.info(String.format("\n Minimum time:           %6.3f (sec)", (double)minTime * 1.0E-9));
        logger.info(String.format(" RMS time (latter half): %6.3f (sec)", rmsTime));
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        if (this.energy == null) {
            return Collections.emptyList();
        }
        ArrayList<Potential> list = new ArrayList<Potential>(1);
        list.add((Potential)this.energy);
        return list;
    }
}

