/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.cli.SaveOptions;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XPHFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="SaveAsPDB", description={" Save the system as a PDB file."})
public class SaveAsPDB
extends PotentialCommand {
    @CommandLine.Mixin
    private SaveOptions saveOptions = new SaveOptions();
    @CommandLine.Option(names={"--fs", "--firstSnapshot"}, paramLabel="-1", defaultValue="-1", description={"First snapshot to write out (indexed from 0)."})
    private int firstSnapshot = -1;
    @CommandLine.Option(names={"--ls", "--lastSnapshot"}, paramLabel="-1", defaultValue="-1", description={"Last snapshot to write out (indexed from 0)."})
    private int lastSnapshot = -1;
    @CommandLine.Option(names={"--si", "--snapshotIncrement"}, paramLabel="1", defaultValue="1", description={"Increment between written snapshots."})
    private int snapshotIncrement = 1;
    @CommandLine.Option(names={"--wd", "--writeToDirectories"}, paramLabel="false", defaultValue="false", description={"Write snapshots to numbered subdirectories."})
    private boolean writeToDirectories = false;
    @CommandLine.Option(names={"--cp", "--copyProperties"}, paramLabel="true", defaultValue="true", description={"Copy the property file to numbered subdirectories (ignored if not writing to subdirectories)."})
    private boolean copyProperties = true;
    @CommandLine.Option(names={"--esv"}, paramLabel="file", defaultValue="", description={"PDB file to build extended system from."})
    private String extended = "";
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in XYZ or ARC format."})
    private String filename = null;

    public SaveAsPDB() {
    }

    public SaveAsPDB(FFXBinding binding) {
        super(binding);
    }

    public SaveAsPDB(String[] args) {
        super(args);
    }

    public SaveAsPDB run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        SystemFilter openFilter = this.potentialFunctions.getFilter();
        ExtendedSystem esvSystem = null;
        if (openFilter instanceof XYZFilter && this.extended != null && !this.extended.isEmpty()) {
            logger.info(" Building extended system from " + this.extended);
            this.activeAssembly = this.getActiveAssembly(this.extended);
            esvSystem = new ExtendedSystem(this.activeAssembly, 7.4, null);
            this.activeAssembly.setFile(new File(this.filename));
            openFilter = new XPHFilter(this.activeAssembly.getFile(), this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties(), esvSystem);
            openFilter.readFile();
            logger.info(" Reading ESV lambdas from XPH file");
        }
        logger.info("\n Saving PDB for " + this.filename);
        String dirString = this.getBaseDirString(this.filename);
        String name = FilenameUtils.removeExtension((String)FilenameUtils.getName((String)this.filename)) + ".pdb";
        File saveFile = new File(dirString + name);
        if (this.firstSnapshot >= 0) {
            PDBFilter snapshotFilter = new PDBFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            openFilter.readNext(true);
            boolean resetPosition = true;
            int counter = 0;
            int snapshotCounter = 0;
            logger.info(" Writing snapshots from " + this.firstSnapshot + " to " + this.lastSnapshot + " with increment " + this.snapshotIncrement);
            while (openFilter.readNext(resetPosition)) {
                resetPosition = false;
                int offset = counter - this.firstSnapshot;
                if (counter >= this.firstSnapshot && (this.lastSnapshot < 0 || counter <= this.lastSnapshot) && offset % this.snapshotIncrement == 0) {
                    File snapshotFile;
                    if (this.writeToDirectories) {
                        String propertyFile;
                        String subdirectory = FilenameUtils.concat((String)dirString, (String)Integer.toString(snapshotCounter));
                        snapshotFile = new File(FilenameUtils.concat((String)subdirectory, (String)name));
                        new File(subdirectory).mkdirs();
                        if (this.copyProperties && (propertyFile = this.activeAssembly.getProperties().getString("propertyFile")) != null) {
                            File copyOfPropFile = new File(FilenameUtils.concat((String)subdirectory, (String)FilenameUtils.getName((String)propertyFile)));
                            try {
                                Files.createDirectories(copyOfPropFile.getParentFile().toPath(), new FileAttribute[0]);
                                Files.copy(new File(propertyFile).toPath(), copyOfPropFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                logger.info(" Could not copy properties file: " + e.getMessage());
                            }
                        }
                    } else {
                        snapshotFile = new File(FilenameUtils.concat((String)dirString, (String)(FilenameUtils.removeExtension((String)name) + "." + counter + ".pdb")));
                    }
                    this.potentialFunctions.versionFile(snapshotFile);
                    this.saveOptions.preSaveOperations(this.activeAssembly);
                    logger.info(" Saving PDB to         " + String.valueOf(snapshotFile));
                    snapshotFilter.writeFile(snapshotFile, true, false, false);
                    try {
                        Files.writeString(snapshotFile.toPath(), (CharSequence)"END\n", StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++snapshotCounter;
                }
                ++counter;
            }
            return this;
        }
        saveFile = this.potentialFunctions.versionFile(saveFile);
        int numModels = openFilter.countNumModels();
        if (numModels == 1) {
            this.saveOptions.preSaveOperations(this.activeAssembly);
            this.potentialFunctions.saveAsPDB(this.activeAssembly, saveFile);
            return this;
        }
        try {
            Files.writeString(saveFile.toPath(), (CharSequence)"MODEL        1\n", new OpenOption[0]);
        }
        catch (IOException resetPosition) {
            // empty catch block
        }
        this.saveOptions.preSaveOperations(this.activeAssembly);
        this.potentialFunctions.saveAsPDB(this.activeAssembly, saveFile, false, true);
        try {
            Files.writeString(saveFile.toPath(), (CharSequence)"ENDMDL\n", StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException resetPosition) {
            // empty catch block
        }
        PDBFilter saveFilter = (PDBFilter)this.potentialFunctions.getFilter();
        saveFilter.setModelNumbering(1);
        if (openFilter instanceof XYZFilter || openFilter instanceof PDBFilter || openFilter instanceof XPHFilter) {
            try {
                while (openFilter.readNext(false)) {
                    if (esvSystem != null) {
                        for (Atom atom : this.activeAssembly.getAtomList()) {
                            int atomIndex = atom.getIndex() - 1;
                            atom.setOccupancy(esvSystem.getTitrationLambda(atomIndex));
                            atom.setTempFactor(esvSystem.getTautomerLambda(atomIndex));
                        }
                    }
                    this.saveOptions.preSaveOperations(this.activeAssembly);
                    saveFilter.writeFile(saveFile, true, true, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Files.writeString(saveFile.toPath(), (CharSequence)"END\n", StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this;
    }
}

