/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.crystal.Crystal;
import ffx.crystal.ReplicatesCrystal;
import ffx.crystal.SpaceGroup;
import ffx.crystal.SpaceGroupDefinitions;
import ffx.crystal.SpaceGroupInfo;
import ffx.crystal.SymOp;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.utilities.FFXBinding;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="PrepareSpaceGroups", description={" Create sub-directories for selected space groups."})
public class PrepareSpaceGroups
extends PotentialCommand {
    @CommandLine.Option(names={"-r", "--PDB"}, paramLabel="231", defaultValue="231", description={"Only consider space groups populated in the PDB above the specified rank (231 excludes none)."})
    private int rank = 231;
    @CommandLine.Option(names={"-p", "--CSD"}, paramLabel="1.0", defaultValue="0.0", description={"Only consider space groups populated above the specified percentage in the CSD."})
    private double percent = 0.0;
    @CommandLine.Option(names={"-c", "--chiral"}, paramLabel="false", defaultValue="false", description={"Only consider chiral space groups."})
    private boolean chiral = false;
    @CommandLine.Option(names={"-a", "--achiral"}, paramLabel="false", defaultValue="false", description={"Only consider achiral space groups."})
    private boolean achiral = false;
    @CommandLine.Option(names={"--rsym", "--randomSymOp"}, paramLabel="Arg", defaultValue="1.0", description={"Random Cartesian sym op will choose a translation in the range -Arg .. Arg (default of 1.0 A)."})
    private double symScalar = 1.0;
    @CommandLine.Option(names={"-d", "--density"}, paramLabel="1.0", defaultValue="1.0", description={"Random unit cell axes will be used to achieve the specified density (default of 1.0 g/cc)."})
    private double density = 1.0;
    @CommandLine.Option(names={"--sg", "--spacegroup"}, description={"Prepare a directory for a single spacegroup."})
    private String sg;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;
    public int numberCreated = 0;
    private ForceFieldEnergy energy;

    public PrepareSpaceGroups() {
    }

    public PrepareSpaceGroups(FFXBinding binding) {
        super(binding);
    }

    public PrepareSpaceGroups(String[] args) {
        super(args);
    }

    public PrepareSpaceGroups run() {
        if (!this.init()) {
            return this;
        }
        System.setProperty("mpoleterm", "false");
        System.setProperty("spacegroup", "P1");
        System.setProperty("a-axis", "10.0");
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Preparing space group directories for " + this.filename);
        this.energy = this.activeAssembly.getPotentialEnergy();
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        File propertyFile = new File(properties.getString("propertyFile"));
        Atom[] atoms = this.activeAssembly.getAtomArray();
        double mass = this.activeAssembly.getMass();
        if (this.density < 0.0) {
            this.density = 1.0;
        }
        String dirString = this.getBaseDirString(this.filename);
        String name = FilenameUtils.getName((String)this.filename);
        for (int num = 1; num <= 230; ++num) {
            SpaceGroup spacegroup2;
            SpaceGroup spacegroup = SpaceGroupDefinitions.spaceGroupFactory((int)num);
            if (this.sg != null && !this.sg.isEmpty()) {
                spacegroup2 = SpaceGroupDefinitions.spaceGroupFactory((String)this.sg);
                if (spacegroup2 == null) {
                    logger.info(String.format("\n Space group %s was not recognized.\n", this.sg));
                    PrepareSpaceGroups.clearProps();
                    return this;
                }
                if (spacegroup2.number != spacegroup.number) {
                    continue;
                }
            } else {
                spacegroup2 = spacegroup;
            }
            if (this.chiral && !spacegroup.respectsChirality() || this.achiral && spacegroup.respectsChirality() || SpaceGroupInfo.getCCDCPercent((int)num) < this.percent || SpaceGroupInfo.getPDBRank((SpaceGroup)spacegroup) > this.rank) continue;
            logger.info(String.format("\n Preparing %d %s (CSD percent: %7.4f, PDB Rank: %d)", num, spacegroup2.shortName, SpaceGroupInfo.getCCDCPercent((int)num), SpaceGroupInfo.getPDBRank((SpaceGroup)spacegroup)));
            String sgDirName = spacegroup2.shortName.replace('/', '_');
            File sgDir = new File(dirString + sgDirName);
            if (!sgDir.exists()) {
                logger.info("\n Creating space group directory: " + String.valueOf(sgDir));
                sgDir.mkdir();
            }
            double[] abc = spacegroup2.latticeSystem.resetUnitCellParams();
            Crystal crystal = new Crystal(abc[0], abc[1], abc[2], abc[3], abc[4], abc[5], spacegroup2.shortName);
            crystal.setDensity(this.density, mass);
            double cutoff2 = this.energy.getCutoffPlusBuffer() * 2.0;
            if (cutoff2 == Double.POSITIVE_INFINITY) {
                cutoff2 = 0.1;
            }
            crystal = ReplicatesCrystal.replicatesCrystalFactory((Crystal)crystal, (double)cutoff2);
            crystal.setSpecialPositionCutoff(0.0);
            crystal.getUnitCell().setSpecialPositionCutoff(0.0);
            this.energy.setCrystal(crystal);
            this.activeAssembly.moveAllIntoUnitCell();
            if (this.symScalar > 0.0) {
                SymOp symOp = SymOp.randomSymOpFactory((double)this.symScalar);
                logger.info(String.format("\n Applying random Cartesian SymOp:\n %s", symOp));
                double[] xyz = new double[3];
                for (Atom atom : atoms) {
                    atom.getXYZ(xyz);
                    SymOp.applyCartesianSymOp((double[])xyz, (double[])xyz, (SymOp)symOp);
                    atom.setXYZ(xyz);
                }
            }
            File sgFile = new File(sgDir.getAbsolutePath() + File.separator + name);
            logger.info(" Saving " + sgDirName + " coordinates to: " + String.valueOf(sgFile));
            this.potentialFunctions.save(this.activeAssembly, sgFile);
            File keyFile = new File(FilenameUtils.removeExtension((String)sgFile.getAbsolutePath()) + ".properties");
            logger.info(" Saving " + sgDirName + " properties to: " + String.valueOf(keyFile));
            ++this.numberCreated;
            try (BufferedReader keyReader = new BufferedReader(new FileReader(propertyFile));
                 PrintWriter keyWriter = new PrintWriter(new BufferedWriter(new FileWriter(keyFile)));){
                String line;
                while ((line = keyReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    String[] tokens = line.split(" +");
                    if (tokens.length > 1) {
                        String first = tokens[0].toLowerCase();
                        if (first.equals("a-axis") || first.equals("b-axis") || first.equals("c-axis") || first.equals("alpha") || first.equals("beta") || first.equals("gamma") || first.equals("spacegroup")) {
                            logger.fine(String.format(" Updating : %s", line));
                            continue;
                        }
                        if (first.equals("parameters")) {
                            if (tokens.length > 1) {
                                if (tokens[1].startsWith("/") || tokens[1].startsWith("\\")) {
                                    keyWriter.println(String.format("parameters %s", tokens[1]));
                                    continue;
                                }
                                keyWriter.println(String.format("parameters ../%s", tokens[1]));
                                continue;
                            }
                            logger.warning("Parameter file may not have been specified");
                            continue;
                        }
                        keyWriter.println(line);
                        continue;
                    }
                    keyWriter.println(line);
                }
                keyWriter.println(String.format("spacegroup %s", spacegroup2.shortName));
                Crystal unitCell = crystal.getUnitCell();
                keyWriter.println(String.format("a-axis %12.8f", unitCell.a));
                keyWriter.println(String.format("b-axis %12.8f", unitCell.b));
                keyWriter.println(String.format("c-axis %12.8f", unitCell.c));
                keyWriter.println(String.format("alpha  %12.8f", unitCell.alpha));
                keyWriter.println(String.format("beta   %12.8f", unitCell.beta));
                keyWriter.println(String.format("gamma  %12.8f", unitCell.gamma));
                continue;
            }
            catch (IOException ex) {
                logger.warning(" Exception writing keyfile." + String.valueOf(ex));
            }
        }
        PrepareSpaceGroups.clearProps();
        return this;
    }

    private static void clearProps() {
        System.clearProperty("mpoleterm");
        System.clearProperty("spacegroup");
        System.clearProperty("a-axis");
    }

    @Override
    public List<Potential> getPotentials() {
        if (this.energy == null) {
            return Collections.emptyList();
        }
        ArrayList<Potential> list = new ArrayList<Potential>();
        list.add((Potential)this.energy);
        return list;
    }
}

