/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Residue;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.utils.GetProteinFeatures;
import ffx.utilities.FFXBinding;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="FeatureMap", description={" Create a Feature Map for a given protein structure"})
public class FeatureMap
extends PotentialCommand {
    @CommandLine.Option(names={"-d", "--delimiter"}, paramLabel=",", description={"Delimiter of input variant list file"})
    private String delimiter = ",";
    @CommandLine.Option(names={"--iP", "--includePolarity"}, defaultValue="false", description={"Include polarity change in feature map."})
    private boolean includePolarity = false;
    @CommandLine.Option(names={"--iA", "--includeAcidity"}, defaultValue="false", description={"Include acidity change in feature map."})
    private boolean includeAcidity = false;
    @CommandLine.Option(names={"--iAng", "--includeAngles"}, defaultValue="false", description={"Include ramachandran angles in feature map."})
    private boolean includeAngles = false;
    @CommandLine.Option(names={"--iS", "--includeStructure"}, defaultValue="false", description={"Include secondary structure annotations in feature map."})
    private boolean includeStructure = false;
    @CommandLine.Option(names={"--iPPI", "--includePPI"}, defaultValue="false", description={"Mark residue as being part of an interaction interface."})
    private boolean includePPI = false;
    @CommandLine.Option(names={"--rR", "--reRun"}, defaultValue="false", description={"Reading in a CSV a second time. Specifically for gathering ppi information"})
    private boolean rerun = false;
    @CommandLine.Option(names={"--ddG", "--ddgFile"}, paramLabel="file", description={"Read in the folding free energy difference file"})
    private String ddgFile;
    @CommandLine.Option(names={"--mI", "--multiple isomers"}, defaultValue="false", description={"Set this flag if the variant list contains variants from multiple isomers. Isomer should be in name of pdb file"})
    private boolean multipleIsoforms = false;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format, variant list file, and a free energy file"})
    private List<String> filenames = null;
    private List<Residue> residues;

    public FeatureMap() {
    }

    public FeatureMap(FFXBinding binding) {
        super(binding);
    }

    public FeatureMap(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureMap run() {
        if (!this.init()) {
            return null;
        }
        System.setProperty("gkterm", "true");
        System.setProperty("cavmodel", "cav");
        System.setProperty("surface-tension", "1.0");
        this.activeAssembly = this.getActiveAssembly(this.filenames);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return null;
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
        int nVars = forceFieldEnergy.getNumberOfVariables();
        double[] x = new double[nVars];
        forceFieldEnergy.getCoordinates(x);
        forceFieldEnergy.energy(x);
        this.residues = this.activeAssembly.getResidueList();
        GetProteinFeatures getProteinFeatures = new GetProteinFeatures(this.activeAssembly);
        String fileIsoform = null;
        if (this.multipleIsoforms) {
            String baseName = new File(filename).getName();
            if ((baseName = baseName.replaceFirst("\\.pdb$", "")).toUpperCase().contains("ENS")) {
                geneSplit = baseName.split("_");
                if (geneSplit.length > 1) {
                    fileIsoform = geneSplit[1];
                }
            } else {
                geneSplit = baseName.split("_");
                int index = -1;
                for (int i = 0; i < geneSplit.length; ++i) {
                    if (!geneSplit[i].equalsIgnoreCase("NP")) continue;
                    index = i;
                }
                if (index >= 0 && index + 1 < geneSplit.length) {
                    fileIsoform = (geneSplit[index] + "_" + geneSplit[index + 1]).toUpperCase();
                }
            }
        }
        ArrayList<String[]> featureList = new ArrayList<String[]>();
        for (Residue residue : this.residues) {
            double residueSurfaceArea = forceFieldEnergy.getGK().getSurfaceAreaRegion().getResidueSurfaceArea(residue);
            featureList.add(getProteinFeatures.saveFeatures(residue, residueSurfaceArea, this.includeAngles, this.includeStructure, this.includePPI));
        }
        ArrayList<String> ddgunLines = new ArrayList<String>();
        ArrayList<String> npChanges = new ArrayList();
        List<Object> ddGun = new ArrayList();
        List<Object> polarityAndAcidityChange = new ArrayList();
        if (this.ddgFile != null) {
            try (BufferedReader txtReader = new BufferedReader(new FileReader(this.ddgFile));){
                String line;
                while ((line = txtReader.readLine()) != null) {
                    if (!line.contains(".pdb")) continue;
                    ddgunLines.add(line);
                }
            }
            catch (IOException e) {
                logger.warning(" Error reading ddG file: " + String.valueOf(e));
            }
            ddGun = getProteinFeatures.getDDGunValues(ddgunLines);
            npChanges = getProteinFeatures.ddgunToNPChange(ddgunLines);
            if (this.includePolarity || this.includeAcidity) {
                polarityAndAcidityChange = getProteinFeatures.getPolarityAndAcidityChange(npChanges, this.includePolarity, this.includeAcidity);
            }
        }
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String variantsCSV = this.filenames.get(1);
            File inputCSVFile = new File(variantsCSV);
            String inputCSVPath = inputCSVFile.getParent();
            if (inputCSVPath == null) {
                inputCSVPath = ".";
            }
            String newCSVFileName = "update_" + inputCSVFile.getName();
            File updatedFile = new File(inputCSVPath, newCSVFileName);
            br = new BufferedReader(new InputStreamReader(new FileInputStream(inputCSVFile)));
            bw = new BufferedWriter(new FileWriter(updatedFile, true));
            int i = 0;
            int npIndex = -1;
            int isoformIndex = -1;
            String line = br.readLine();
            while (line != null) {
                StringBuilder newCSVLine = new StringBuilder();
                if (i == 0) {
                    if (!this.rerun) {
                        if (updatedFile.length() == 0L) {
                            newCSVLine.append(line).append(this.delimiter).append("Surface Area").append(this.delimiter).append("Normalized SA").append(this.delimiter).append("Confidence Score");
                            if (this.ddgFile != null) {
                                newCSVLine.append(this.delimiter).append("ddG").append(this.delimiter).append("|ddG|");
                            }
                            if (this.includeAcidity) {
                                newCSVLine.append(this.delimiter).append("Acidity Change");
                            }
                            if (this.includePolarity) {
                                newCSVLine.append(this.delimiter).append("Polarity Change");
                            }
                            if (this.includeAngles) {
                                newCSVLine.append(this.delimiter).append("Phi").append(this.delimiter).append("Psi").append(this.delimiter).append("Omega");
                            }
                            if (this.includeStructure) {
                                newCSVLine.append(this.delimiter).append("Secondary Structure Annotation");
                            }
                            if (this.includePPI) {
                                newCSVLine.append(this.delimiter).append("Interface Residue");
                            }
                            bw.write(newCSVLine.toString());
                        } else {
                            bw.write(line);
                            bw.newLine();
                        }
                    }
                } else {
                    String isofU;
                    String[] splits = line.split(this.delimiter, -1);
                    if (i == 1) {
                        for (int j = 0; j < splits.length; ++j) {
                            String sj;
                            String sju;
                            if (splits[j].contains("p.")) {
                                npIndex = j;
                            }
                            if (!this.multipleIsoforms || !(sju = (sj = splits[j]).toUpperCase()).contains("NP") && !sju.contains("XP") && !sju.contains("ENS")) continue;
                            isoformIndex = j;
                        }
                    }
                    int length = splits.length;
                    String npChange = npIndex >= 0 && npIndex < splits.length ? splits[npIndex] : "";
                    Object[] feat = featureList.isEmpty() ? new String[]{} : new String[((String[])featureList.get(0)).length];
                    Arrays.fill(feat, null);
                    String[] ddG = new String[]{"null", "null"};
                    String[] pA = new String[]{"null", "null"};
                    if (!npChange.contains("del") && !featureList.isEmpty()) {
                        int position = -1;
                        int pIndex = npChange.indexOf(112);
                        if (pIndex >= 0) {
                            String sub;
                            String proteinChange = npChange.substring(pIndex);
                            String[] parts = proteinChange.split("p\\.");
                            if (parts.length > 1 && (sub = parts[1]).length() >= 6) {
                                try {
                                    position = Integer.parseInt(sub.substring(3, sub.length() - 3));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (position > 0 && position <= this.residues.size()) {
                                int idx;
                                if (this.ddgFile != null && (idx = npChanges.indexOf(proteinChange)) != -1) {
                                    String[] pa;
                                    Double[] d = (Double[])ddGun.get(idx);
                                    if (d != null && d.length >= 2) {
                                        ddG = new String[]{String.valueOf(d[0]), String.valueOf(d[1])};
                                    }
                                    if ((this.includeAcidity || this.includePolarity) && (pa = (String[])polarityAndAcidityChange.get(idx)) != null && pa.length >= 2) {
                                        pA = new String[]{pa[0], pa[1]};
                                    }
                                }
                                feat = (String[])featureList.get(position - 1);
                            }
                        }
                    }
                    String isoform = null;
                    if (this.multipleIsoforms && isoformIndex >= 0 && isoformIndex < splits.length) {
                        String isoStr = splits[isoformIndex];
                        String string = isoform = isoStr.contains(":p.") ? isoStr.split(":")[0] : isoStr;
                    }
                    if (splits.length == length && (!this.multipleIsoforms || fileIsoform == null || (isofU = (isoform == null ? "" : isoform).toUpperCase()).contains(fileIsoform.toUpperCase()))) {
                        if (this.rerun) {
                            newCSVLine.append(line);
                        } else if (this.ddgFile != null) {
                            newCSVLine.append(line).append(this.delimiter).append(FeatureMap.safe((String[])feat, 0)).append(this.delimiter).append(FeatureMap.safe((String[])feat, 1)).append(this.delimiter).append(FeatureMap.safe((String[])feat, 2)).append(this.delimiter).append(ddG[0]).append(this.delimiter).append(ddG[1]);
                        } else {
                            newCSVLine.append(line).append(this.delimiter).append(FeatureMap.safe((String[])feat, 0)).append(this.delimiter).append(FeatureMap.safe((String[])feat, 1)).append(this.delimiter).append(FeatureMap.safe((String[])feat, 2));
                        }
                        if (this.includeAcidity && !this.rerun) {
                            newCSVLine.append(this.delimiter).append(pA[0]);
                        }
                        if (this.includePolarity && !this.rerun) {
                            newCSVLine.append(this.delimiter).append(pA[1]);
                        }
                        if (this.includeAngles && !this.rerun) {
                            newCSVLine.append(this.delimiter).append(FeatureMap.safe((String[])feat, 3)).append(this.delimiter).append(FeatureMap.safe((String[])feat, 4)).append(this.delimiter).append(FeatureMap.safe((String[])feat, 5));
                            if (this.includeStructure) {
                                newCSVLine.append(this.delimiter).append(FeatureMap.safe((String[])feat, 6));
                            }
                            if (this.includePPI) {
                                newCSVLine.append(this.delimiter).append(FeatureMap.safe((String[])feat, 7));
                            }
                        } else if (this.includeStructure && !this.rerun) {
                            newCSVLine.append(this.delimiter).append(FeatureMap.safe((String[])feat, 3));
                            if (this.includePPI) {
                                newCSVLine.append(this.delimiter).append(FeatureMap.safe((String[])feat, 4));
                            }
                        } else if (this.includePPI) {
                            newCSVLine.append(this.delimiter).append(FeatureMap.safe((String[])feat, 3));
                        }
                        bw.newLine();
                        bw.write(newCSVLine.toString());
                    }
                }
                line = br.readLine();
                ++i;
            }
        }
        catch (Exception e) {
            logger.warning(" Error updating CSV: " + String.valueOf(e));
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
        logger.info(" Wrote variants with feature data to update_" + (this.filenames != null && this.filenames.size() > 1 ? new File(this.filenames.get(1)).getName() : "variants.csv"));
        return this;
    }

    private static String safe(String[] arr, int idx) {
        if (arr == null || idx < 0 || idx >= arr.length) {
            return "";
        }
        return arr[idx] == null ? "" : arr[idx];
    }
}

