/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.utils.PotentialsUtils;
import ffx.utilities.FFXBinding;
import ffx.utilities.FilePathInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(name="ChainBreaks", description={" Fix chain breaks in a pdb file."})
public class ChainBreaks
extends PotentialCommand {
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;
    private List<double[]> newCoordinates;
    private final PotentialsUtils potentialsUtils = new PotentialsUtils();

    public ChainBreaks() {
    }

    public ChainBreaks(FFXBinding binding) {
        super(binding);
    }

    public ChainBreaks(String[] args) {
        super(args);
    }

    public ChainBreaks run() {
        if (!this.init()) {
            return null;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return null;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        FilePathInfo fileInfo = this.parseFilePath(this.filename);
        if (!fileInfo.extension().toLowerCase().contains("pdb")) {
            logger.info(String.format(" The file extension does not include 'pdb': %s", this.filename));
            return null;
        }
        logger.info(String.format("\n Fixing Chain Breaks for %s", this.filename));
        List<Residue> residues = this.activeAssembly.getResidueList();
        List<String> chainBreaks = this.findChainBreaks(residues, 3.0);
        this.saveByOriginalExtension(this.activeAssembly, this.filename);
        return this;
    }

    private List<String> findChainBreaks(List<Residue> residues, double cutoff) {
        String endAtName;
        String startAtName;
        ArrayList subChains = new ArrayList();
        ArrayList<String> chainBreaks = new ArrayList<String>();
        Residue.ResidueType rType = residues.get(0).getResidueType();
        switch (rType) {
            case AA: {
                startAtName = "N";
                endAtName = "C";
                break;
            }
            case NA: {
                boolean namedStar = residues.stream().flatMap(r -> r.getAtomList().stream()).anyMatch(a -> a.getName().equals("O5*"));
                if (namedStar) {
                    startAtName = "O5*";
                    endAtName = "O3*";
                    break;
                }
                startAtName = "O5'";
                endAtName = "O3'";
                break;
            }
            default: {
                logger.fine(" Not attempting to find chain breaks for chain with residue " + String.valueOf(residues.get(0)));
                return null;
            }
        }
        ArrayList<Residue> subChain = null;
        Residue previousResidue = null;
        Atom priorEndAtom = null;
        for (Residue residue : residues) {
            List<Atom> resAtoms = residue.getAtomList();
            if (priorEndAtom == null) {
                subChain = new ArrayList<Residue>();
                subChain.add(residue);
                subChains.add(subChain);
            } else {
                Atom startAtom = null;
                for (Atom a2 : resAtoms) {
                    if (!a2.getName().equalsIgnoreCase(startAtName)) continue;
                    startAtom = a2;
                    break;
                }
                if (startAtom == null) {
                    subChain.add(residue);
                    continue;
                }
                double r2 = DoubleMath.dist((double[])priorEndAtom.getXYZ(null), (double[])startAtom.getXYZ(null));
                if (r2 > cutoff) {
                    subChain = new ArrayList();
                    subChain.add(residue);
                    subChains.add(subChain);
                    chainBreaks.add("C " + String.valueOf(previousResidue) + " N " + String.valueOf(residue));
                    this.fixChainBreaks(priorEndAtom.getXYZ(null), startAtom.getXYZ(null));
                    priorEndAtom.setXYZ(this.newCoordinates.get(0));
                    startAtom.setXYZ(this.newCoordinates.get(1));
                } else {
                    subChain.add(residue);
                }
            }
            for (Atom a3 : resAtoms) {
                if (!a3.getName().equalsIgnoreCase(endAtName)) continue;
                priorEndAtom = a3;
                break;
            }
            previousResidue = residue;
        }
        return chainBreaks;
    }

    private void fixChainBreaks(double[] cCoordinates, double[] nCoordinates) {
        logger.info(" Generating new coordinates.");
        this.newCoordinates = new ArrayList<double[]>();
        double distance = DoubleMath.dist((double[])cCoordinates, (double[])nCoordinates);
        while (distance > 3.0) {
            double dx = FastMath.abs((double)((cCoordinates[0] - nCoordinates[0]) / 4.0));
            double dy = FastMath.abs((double)((cCoordinates[1] - nCoordinates[1]) / 4.0));
            double dz = FastMath.abs((double)((cCoordinates[2] - nCoordinates[2]) / 4.0));
            if (cCoordinates[0] > nCoordinates[0]) {
                cCoordinates[0] = cCoordinates[0] - dx;
                nCoordinates[0] = nCoordinates[0] + dx;
            } else if (cCoordinates[0] < nCoordinates[0]) {
                cCoordinates[0] = cCoordinates[0] + dx;
                nCoordinates[0] = nCoordinates[0] - dx;
            }
            if (cCoordinates[1] > nCoordinates[1]) {
                cCoordinates[1] = cCoordinates[1] - dy;
                nCoordinates[1] = nCoordinates[1] + dy;
            } else if (cCoordinates[1] < nCoordinates[1]) {
                cCoordinates[1] = cCoordinates[1] + dy;
                nCoordinates[1] = nCoordinates[1] - dy;
            }
            if (cCoordinates[2] > nCoordinates[2]) {
                cCoordinates[2] = cCoordinates[2] - dz;
                nCoordinates[2] = nCoordinates[2] + dz;
            } else if (cCoordinates[2] < nCoordinates[0]) {
                cCoordinates[2] = cCoordinates[2] + dz;
                nCoordinates[2] = nCoordinates[2] - dz;
            }
            distance = DoubleMath.dist((double[])cCoordinates, (double[])nCoordinates);
        }
        this.newCoordinates.add(cCoordinates);
        this.newCoordinates.add(nCoordinates);
    }
}

