/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.utilities.FFXBinding;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="Cart2Frac", description={" Convert from Cartesian to fractional coordinates."})
public class Cart2Frac
extends PotentialCommand {
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;
    private MolecularAssembly[] molecularAssemblies;
    private double[][][] cartCoordinates = null;
    private double[][][] fracCoordinates = null;

    public Cart2Frac() {
    }

    public Cart2Frac(FFXBinding binding) {
        super(binding);
    }

    public Cart2Frac(String[] args) {
        super(args);
    }

    public double[][][] getCart() {
        return this.cartCoordinates;
    }

    public double[][][] getFrac() {
        return this.fracCoordinates;
    }

    public Cart2Frac run() {
        if (!this.init()) {
            return this;
        }
        this.molecularAssemblies = this.getActiveAssemblies(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        int num = this.molecularAssemblies.length;
        this.cartCoordinates = new double[num][][];
        this.fracCoordinates = new double[num][][];
        for (int i = 0; i < num; ++i) {
            MolecularAssembly ma = this.molecularAssemblies[i];
            logger.info("\n Converting from Cartesian to fractional coordinates for " + String.valueOf(ma));
            Crystal crystal = ma.getCrystal().getUnitCell();
            Atom[] atoms = ma.getAtomArray();
            int nAtoms = atoms.length;
            this.fracCoordinates[i] = new double[nAtoms][3];
            this.cartCoordinates[i] = new double[nAtoms][3];
            double[] frac = new double[3];
            double[] cart = new double[3];
            for (int index = 0; index < nAtoms; ++index) {
                Atom atom = atoms[index];
                atom.getXYZ(cart);
                crystal.toFractionalCoordinates(cart, frac);
                boolean active = atom.isActive();
                atom.setActive(true);
                atom.moveTo(frac);
                atom.setActive(active);
                this.cartCoordinates[i][index][0] = cart[0];
                this.cartCoordinates[i][index][1] = cart[1];
                this.cartCoordinates[i][index][2] = cart[2];
                this.fracCoordinates[i][index][0] = frac[0];
                this.fracCoordinates[i][index][1] = frac[1];
                this.fracCoordinates[i][index][2] = frac[2];
            }
        }
        this.saveByOriginalExtension(this.molecularAssemblies, this.filename);
        this.binding.setVariable("cart", (Object)this.cartCoordinates);
        this.binding.setVariable("frac", (Object)this.fracCoordinates);
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }
}

