/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import ffx.potential.MolecularAssembly;
import ffx.potential.utils.PotentialsFunctions;
import java.io.File;
import picocli.CommandLine;

public class WriteoutOptions {
    @CommandLine.Option(names={"-F", "--fileFormat"}, paramLabel="XYZ", defaultValue="XYZ", description={"Choose file type to write [PDB/XYZ]."})
    public String fileType = "XYZ";

    public static String toArchiveExtension(String fileType) {
        return Extensions.nameToExt((String)fileType).archive;
    }

    public String getFileType() {
        return this.fileType;
    }

    public File saveFile(String baseFileName, PotentialsFunctions potentialsFunctions, MolecularAssembly molecularAssembly) {
        File outFile;
        Object outFileName = baseFileName;
        if (this.fileType.equalsIgnoreCase("XYZ")) {
            outFileName = (String)outFileName + ".xyz";
            outFile = potentialsFunctions.versionFile(new File((String)outFileName));
            potentialsFunctions.saveAsXYZ(molecularAssembly, outFile);
        } else {
            outFileName = (String)outFileName + ".pdb";
            outFile = potentialsFunctions.versionFile(new File((String)outFileName));
            potentialsFunctions.saveAsPDB(molecularAssembly, outFile);
        }
        return outFile;
    }

    private static enum Extensions {
        XYZ("xyz", "arc"),
        PDB("pdb", "pdb");

        private final String single;
        private final String archive;

        private Extensions(String single, String archive) {
            this.single = single;
            this.archive = archive;
        }

        static Extensions nameToExt(String name) {
            return switch (name.toUpperCase()) {
                case "PDB" -> PDB;
                default -> XYZ;
            };
        }
    }
}

