/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TorsionType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class Torsion
extends BondedTerm
implements LambdaInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Torsion.class.getName());
    public TorsionType torsionType = null;
    private double torsionScale = 1.0;
    private double lambda = 1.0;
    private double dEdL = 0.0;
    private boolean lambdaTerm = false;
    private final DoubleUnaryOperator lambdaMapper;
    private static final double TORSION_TOLERANCE = 1.0E-4;

    public Torsion(Bond b1, Bond b2, Bond b3) {
        this.bonds = new Bond[3];
        this.bonds[0] = b1;
        this.bonds[1] = b2;
        this.bonds[2] = b3;
        this.lambdaMapper = d -> d;
        this.initialize();
    }

    public static void logNoTorsionType(Atom a0, Atom a1, Atom a2, Atom a3, ForceField forceField) {
        AtomType atomType0 = a0.getAtomType();
        AtomType atomType1 = a1.getAtomType();
        AtomType atomType2 = a2.getAtomType();
        AtomType atomType3 = a3.getAtomType();
        int[] c = new int[]{atomType0.atomClass, atomType1.atomClass, atomType2.atomClass, atomType3.atomClass};
        String key = TorsionType.sortKey(c);
        StringBuilder sb = new StringBuilder(String.format("No TorsionType for key: %s\n %s -> %s\n %s -> %s\n %s -> %s\n %s -> %s", key, a0, atomType0, a1, atomType1, a2, atomType2, a3, atomType3));
        if (Torsion.matchTorsions(a0, a1, a2, a3, forceField, sb, true) <= 0) {
            Torsion.matchTorsions(a0, a1, a2, a3, forceField, sb, false);
        }
        logger.severe(sb.toString());
    }

    private static int matchTorsions(Atom a0, Atom a1, Atom a2, Atom a3, ForceField forceField, StringBuilder sb, boolean strict) {
        AtomType atomType0 = a0.getAtomType();
        AtomType atomType1 = a1.getAtomType();
        AtomType atomType2 = a2.getAtomType();
        AtomType atomType3 = a3.getAtomType();
        int c0 = atomType0.atomClass;
        int c1 = atomType1.atomClass;
        int c2 = atomType2.atomClass;
        int c3 = atomType3.atomClass;
        List<AtomType> types0 = forceField.getSimilarAtomTypes(atomType0);
        List<AtomType> types1 = forceField.getSimilarAtomTypes(atomType1);
        List<AtomType> types2 = forceField.getSimilarAtomTypes(atomType2);
        List<AtomType> types3 = forceField.getSimilarAtomTypes(atomType3);
        ArrayList<TorsionType> torsionTypes = new ArrayList<TorsionType>();
        boolean match = false;
        for (AtomType type1 : types1) {
            for (AtomType type2 : types2) {
                if ((type1.atomClass != c1 || type2.atomClass != c2) && (type1.atomClass != c2 || type2.atomClass != c1)) continue;
                for (AtomType type0 : types0) {
                    for (AtomType type3 : types3) {
                        TorsionType torsionType;
                        if (strict && type0.atomClass != c0 && type0.atomClass != c3 && type3.atomClass != c0 && type3.atomClass != c3 || (torsionType = forceField.getTorsionType(type0, type1, type2, type3)) == null || torsionTypes.contains(torsionType)) continue;
                        if (!match) {
                            match = true;
                            sb.append("\n Similar Torsion Types:");
                        }
                        torsionTypes.add(torsionType);
                        sb.append(String.format("\n  %s", torsionType));
                    }
                }
            }
        }
        return torsionTypes.size();
    }

    static Torsion torsionFactory(Bond bond1, Bond middleBond, Bond bond3, ForceField forceField) {
        Atom a0 = bond1.getOtherAtom(middleBond);
        Atom a1 = middleBond.getAtom(0);
        Atom a2 = middleBond.getAtom(1);
        Atom a3 = bond3.getOtherAtom(middleBond);
        TorsionType torsionType = forceField.getTorsionType(a0.getAtomType(), a1.getAtomType(), a2.getAtomType(), a3.getAtomType());
        if (torsionType == null) {
            Torsion.logNoTorsionType(a0, a1, a2, a3, forceField);
            return null;
        }
        Torsion torsion = new Torsion(bond1, middleBond, bond3);
        torsion.setTorsionType(torsionType);
        if (forceField.hasProperty("torsion-scale")) {
            boolean isTerminal;
            boolean bl = isTerminal = a0.isHydrogen() || a0.isHalogen() || a3.isHydrogen() || a3.isHalogen();
            if (!isTerminal) {
                double scale = forceField.getDouble("torsion-scale", 1.0);
                torsion.setTorsionScale(scale);
            }
        }
        return torsion;
    }

    public void setTorsionType(TorsionType torsionType) {
        this.torsionType = torsionType;
    }

    public void setTorsionScale(double torsionScale) {
        this.torsionScale = torsionScale;
    }

    public double getTorsionScale() {
        return this.torsionScale;
    }

    public boolean compare(Atom a0, Atom a1, Atom a2, Atom a3) {
        if (a0 == this.atoms[0] && a1 == this.atoms[1] && a2 == this.atoms[2] && a3 == this.atoms[3]) {
            return true;
        }
        return a0 == this.atoms[3] && a1 == this.atoms[2] && a2 == this.atoms[1] && a3 == this.atoms[0];
    }

    public double measure() {
        double angle = DoubleMath.dihedralAngle((double[])this.atoms[0].getXYZ(null), (double[])this.atoms[1].getXYZ(null), (double[])this.atoms[2].getXYZ(null), (double[])this.atoms[3].getXYZ(null));
        return FastMath.toDegrees((double)angle);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.energy = 0.0;
        this.value = 0.0;
        this.dEdL = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        Atom atomD = this.atoms[3];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vd = atomD.getXYZ();
        Double3 vba = vb.sub(va);
        Double3 vcb = vc.sub(vb);
        Double3 vdc = vd.sub(vc);
        Double3 vt = vba.X(vcb);
        Double3 vu = vcb.X(vdc);
        double rt2 = FastMath.max((double)vt.length2(), (double)1.0E-4);
        double ru2 = FastMath.max((double)vu.length2(), (double)1.0E-4);
        double rtru2 = rt2 * ru2;
        double rr = FastMath.sqrt((double)rtru2);
        double rcb = FastMath.max((double)vcb.length(), (double)1.0E-4);
        double cosine = vt.dot(vu) / rr;
        double sine = vcb.dot(vt.X(vu)) / (rcb * rr);
        this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
        if (sine < 0.0) {
            this.value = -this.value;
        }
        double[] amp = this.torsionType.amplitude;
        double[] tsin = this.torsionType.sine;
        double[] tcos = this.torsionType.cosine;
        this.energy = amp[0] * (1.0 + cosine * tcos[0] + sine * tsin[0]);
        double dedphi = amp[0] * (cosine * tsin[0] - sine * tcos[0]);
        double cosprev = cosine;
        double sinprev = sine;
        int n = this.torsionType.terms;
        for (int i = 1; i < n; ++i) {
            double cosn = cosine * cosprev - sine * sinprev;
            double sinn = sine * cosprev + cosine * sinprev;
            double phi = 1.0 + cosn * tcos[i] + sinn * tsin[i];
            double dphi = (1.0 + (double)i) * (cosn * tsin[i] - sinn * tcos[i]);
            this.energy += amp[i] * phi;
            dedphi += amp[i] * dphi;
            cosprev = cosn;
            sinprev = sinn;
        }
        this.dEdL = this.torsionScale * this.torsionType.torsionUnit * this.energy;
        this.energy = this.dEdL * this.lambda;
        if (gradient || this.lambdaTerm) {
            dedphi = this.torsionScale * this.torsionType.torsionUnit * dedphi;
            Double3 vca = vc.sub(va);
            Double3 vdb = vd.sub(vb);
            Double3 dedt = vt.X(vcb).scaleI(dedphi / (rt2 * rcb));
            Double3 dedu = vu.X(vcb).scaleI(-dedphi / (ru2 * rcb));
            Double3 ga = dedt.X(vcb);
            Double3 gb = vca.X(dedt).addI(dedu.X(vdc));
            Double3 gc = dedt.X(vba).addI(vdb.X(dedu));
            Double3 gd = dedu.X(vcb);
            int ia = atomA.getIndex() - 1;
            int ib = atomB.getIndex() - 1;
            int ic = atomC.getIndex() - 1;
            int id = atomD.getIndex() - 1;
            if (this.lambdaTerm) {
                lambdaGrad.add(threadID, ia, ga);
                lambdaGrad.add(threadID, ib, gb);
                lambdaGrad.add(threadID, ic, gc);
                lambdaGrad.add(threadID, id, gd);
            }
            if (gradient) {
                grad.add(threadID, ia, ga.scaleI(this.lambda));
                grad.add(threadID, ib, gb.scaleI(this.lambda));
                grad.add(threadID, ic, gc.scaleI(this.lambda));
                grad.add(threadID, id, gd.scaleI(this.lambda));
            }
        }
        return this.energy;
    }

    public Atom get1_4(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[3];
        }
        if (a == this.atoms[3]) {
            return this.atoms[0];
        }
        return null;
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.applyAllLambda()) {
            this.lambdaTerm = true;
        }
        this.lambda = this.lambdaTerm ? this.lambdaMapper.applyAsDouble(lambda) : 1.0;
    }

    @Override
    public double getd2EdL2() {
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
    }

    public void log() {
        logger.info(String.format(" %-8s %6d-%s %6d-%s %6d-%s %6d-%s %10.4f %10.4f %10.4f", "Torsional-Angle", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.atoms[3].getIndex(), this.atoms[3].getAtomType().name, this.value, this.energy, this.torsionScale));
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.1f,%7.2f,%7.2f)", this.id, this.value, this.energy, this.torsionScale);
    }

    private void initialize() {
        this.atoms = new Atom[4];
        this.atoms[1] = this.bonds[0].getCommonAtom(this.bonds[1]);
        this.atoms[0] = this.bonds[0].get1_2(this.atoms[1]);
        this.atoms[2] = this.bonds[1].get1_2(this.atoms[1]);
        this.atoms[3] = this.bonds[2].get1_2(this.atoms[2]);
        this.atoms[0].setTorsion(this);
        this.atoms[1].setTorsion(this);
        this.atoms[2].setTorsion(this);
        this.atoms[3].setTorsion(this);
        this.setID_Key(false);
        this.value = DoubleMath.dihedralAngle((double[])this.atoms[0].getXYZ(null), (double[])this.atoms[1].getXYZ(null), (double[])this.atoms[2].getXYZ(null), (double[])this.atoms[3].getXYZ(null));
    }
}

