/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.Atom;
import ffx.potential.bonded.MultiResidue;
import ffx.potential.bonded.Residue;
import ffx.potential.utils.Superpose;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResidueState {
    private static final Logger logger = Logger.getLogger(ResidueState.class.getName());
    private final Residue parent;
    private final Residue residue;
    private final HashMap<Atom, double[]> atomMap;
    private final Atom[] atoms;

    public ResidueState(Residue parent, Residue residue) {
        this.parent = parent;
        this.residue = residue;
        List<Atom> atomList = residue.getAtomList();
        int nAtoms = atomList.size();
        this.atomMap = new HashMap(nAtoms);
        this.atoms = new Atom[nAtoms];
        atomList.toArray(this.atoms);
        for (Atom atom : this.atoms) {
            double[] atXYZ = new double[3];
            atom.getXYZ(atXYZ);
            this.atomMap.put(atom, atXYZ);
        }
    }

    public ResidueState(Residue residue) {
        this(residue, residue);
        if (residue instanceof MultiResidue) {
            throw new IllegalArgumentException(String.format(" Residue %s is a MultiResidue: this ResidueState has been incorrectly constructed!", residue));
        }
    }

    public static void revertAllCoordinates(List<Residue> residueList, ResidueState[] states) {
        ResidueState.revertAllCoordinates(residueList.toArray(new Residue[0]), states);
    }

    public static void revertAtomicCoordinates(Atom[] atoms, double[][] coords) {
        int nAtoms = atoms.length;
        if (coords.length != nAtoms) {
            throw new IllegalArgumentException(String.format(" Length %d of atoms array does not match length %d of coordinates array", nAtoms, coords.length));
        }
        for (int i = 0; i < nAtoms; ++i) {
            atoms[i].setXYZ(coords[i]);
        }
    }

    public static ResidueState[] storeAllCoordinates(List<Residue> residueList) {
        return ResidueState.storeAllCoordinates(residueList.toArray(new Residue[0]));
    }

    public static ResidueState[] storeAllCoordinates(Residue[] residues) {
        int nResidues = residues.length;
        ResidueState[] states = new ResidueState[nResidues];
        for (int i = 0; i < nResidues; ++i) {
            states[i] = residues[i].storeState();
        }
        return states;
    }

    public static double[][] storeAtomicCoordinates(Atom[] atoms) {
        int nAtoms = atoms.length;
        double[][] coords = new double[nAtoms][3];
        for (int i = 0; i < nAtoms; ++i) {
            atoms[i].getXYZ(coords[i]);
        }
        return coords;
    }

    private static void revertAllCoordinates(Residue[] residueArray, ResidueState[] states) {
        int nResidues = residueArray.length;
        if (nResidues != states.length) {
            throw new IllegalArgumentException(String.format("Length of residue array %d and residue state array %d do not match.", nResidues, states.length));
        }
        for (int i = 0; i < nResidues; ++i) {
            Residue resi = residueArray[i];
            if (resi.equals(states[i].getParent())) {
                resi.revertState(states[i]);
                continue;
            }
            boolean matchFound = false;
            for (int j = 0; j < nResidues; ++j) {
                if (!resi.equals(states[j].getParent())) continue;
                matchFound = true;
                resi.revertState(states[j]);
                break;
            }
            if (matchFound) continue;
            throw new IllegalArgumentException(String.format("Could not find match for residue %s among residue states array.", resi));
        }
    }

    public double compareTo(ResidueState residueState) {
        logger.info("Comparing rotamers using the compareTo method in ResidueState");
        double[][] tempx1 = new double[this.atoms.length][3];
        double[][] tempx2 = new double[residueState.atoms.length][3];
        double[] x1 = new double[this.atoms.length * 3];
        double[] x2 = new double[residueState.atoms.length * 3];
        Atom[] x1atoms = this.atoms;
        Atom[] x2atoms = residueState.atoms;
        for (int atomCount = 0; atomCount < x1atoms.length; ++atomCount) {
            Atom exampleAtom = x1atoms[atomCount];
            tempx1[atomCount] = this.atomMap.get(exampleAtom);
        }
        int x1count = 0;
        for (Object coordSet : (Atom)tempx1) {
            for (int coordCount = 0; coordCount < 3; ++coordCount) {
                x1[x1count] = (double)coordSet[coordCount];
                ++x1count;
            }
        }
        for (int atomCount = 0; atomCount < x2atoms.length; ++atomCount) {
            Atom exampleAtom = x2atoms[atomCount];
            tempx2[atomCount] = residueState.atomMap.get(exampleAtom);
        }
        int x2count = 0;
        for (double[] coordSet : tempx2) {
            for (int coordCount = 0; coordCount < 3; ++coordCount) {
                x2[x2count] = coordSet[coordCount];
                ++x2count;
            }
        }
        double[] mass = new double[x1.length];
        Arrays.fill(mass, 1.0);
        return Superpose.rmsd(x1, x2, mass);
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Residue getParent() {
        return this.parent;
    }

    public String toString() {
        return String.format(" ResidueState with parent residue %s, state residue %s, number of atoms %d", this.parent, this.residue, this.atoms.length);
    }

    Residue getStateResidue() {
        return this.residue;
    }

    double[] getAtomCoords(Atom atom) {
        double[] xyz = new double[3];
        if (!this.atomMap.containsKey(atom)) {
            logger.info(String.format(" Illegal call to ResidueState.getAtomCoords: atom %s not found: hashcode %d", atom, atom.hashCode()));
            for (Atom ratom : this.residue.getAtomList()) {
                logger.info(String.format(" Atoms in residue: %s hashcode: %d", ratom, ratom.hashCode()));
            }
            for (Atom matom : this.atomMap.keySet()) {
                logger.info(String.format(" Atoms in ResidueState atom cache: %s hashcode: %d", matom, matom.hashCode()));
            }
            logger.log(Level.SEVERE, " Error in ResidueState.getAtomCoords.", new IllegalStateException());
        }
        System.arraycopy(this.atomMap.get(atom), 0, xyz, 0, 3);
        return xyz;
    }
}

