/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Molecule;
import ffx.potential.bonded.NamingUtils;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.PDBFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class PolymerUtils {
    private static final Logger logger = Logger.getLogger(PolymerUtils.class.getName());
    private static final double DEFAULT_AA_CHAINBREAK = 3.0;
    private static final double DEFAULT_NA_CHAINBREAK_MULT = 2.0;

    public static List<Bond> assignAtomTypes(MolecularAssembly molecularAssembly, PDBFilter.PDBFileStandard fileStandard) {
        List<MSNode> water;
        List<MSNode> ions;
        ArrayList<Bond> bondList = new ArrayList<Bond>();
        ForceField forceField = molecularAssembly.getForceField();
        CompositeConfiguration properties = molecularAssembly.getProperties();
        boolean standardizeAtomNames = properties.getBoolean("standardizeAtomNames", true);
        Polymer[] polymers = molecularAssembly.getChains();
        if (polymers != null) {
            logger.info(String.format("\n Assigning atom types for %d chains.", polymers.length));
            for (Polymer polymer : polymers) {
                List<Residue> residues = polymer.getResidues();
                boolean isProtein = true;
                for (Residue residue : residues) {
                    HashMap<String, AtomType> types;
                    String name = residue.getName().toUpperCase();
                    boolean aa = false;
                    for (Object amino : AminoAcidUtils.aminoAcidList) {
                        if (!amino.toString().equalsIgnoreCase(name)) continue;
                        aa = true;
                        if (!standardizeAtomNames) break;
                        NamingUtils.checkHydrogenAtomNames(residue, fileStandard);
                        break;
                    }
                    if (aa) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(" Checking for non-standard amino acid patch " + name);
                    }
                    if ((types = forceField.getAtomTypes(name)).isEmpty()) {
                        isProtein = false;
                        break;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine(" Patch found for non-standard amino acid " + name);
                }
                if (isProtein) {
                    try {
                        logger.info(String.format(" Amino acid chain %s", polymer.getName()));
                        double dist = properties.getDouble("chainbreak", 3.0);
                        List<List<Residue>> subChains = PolymerUtils.findChainBreaks(residues, dist);
                        for (List<Residue> subChain : subChains) {
                            AminoAcidUtils.assignAminoAcidAtomTypes(subChain, forceField, bondList);
                        }
                        continue;
                    }
                    catch (BondedUtils.MissingHeavyAtomException missingHeavyAtomException) {
                        logger.log(Level.INFO, Utilities.stackTraceToString(missingHeavyAtomException));
                        logger.severe(missingHeavyAtomException.toString());
                        continue;
                    }
                    catch (BondedUtils.MissingAtomTypeException missingAtomTypeException) {
                        logger.log(Level.INFO, Utilities.stackTraceToString(missingAtomTypeException));
                        logger.severe(missingAtomTypeException.toString());
                        continue;
                    }
                }
                boolean isNucleicAcid = true;
                for (Residue residue3 : residues) {
                    String currentName = residue3.getName().toUpperCase();
                    Iterator<List<Residue>> name = switch (currentName) {
                        case "A" -> NucleicAcidUtils.NucleicAcid3.ADE.toString();
                        case "C" -> NucleicAcidUtils.NucleicAcid3.CYT.toString();
                        case "G" -> NucleicAcidUtils.NucleicAcid3.GUA.toString();
                        case "T" -> NucleicAcidUtils.NucleicAcid3.THY.toString();
                        case "U" -> NucleicAcidUtils.NucleicAcid3.URI.toString();
                        case "YG" -> NucleicAcidUtils.NucleicAcid3.YYG.toString();
                        case "DA" -> NucleicAcidUtils.NucleicAcid3.DAD.toString();
                        case "DC" -> NucleicAcidUtils.NucleicAcid3.DCY.toString();
                        case "DG" -> NucleicAcidUtils.NucleicAcid3.DGU.toString();
                        case "DT" -> NucleicAcidUtils.NucleicAcid3.DTY.toString();
                        default -> currentName;
                    };
                    residue3.setName((String)((Object)name));
                    NucleicAcidUtils.NucleicAcid3 nucleicAcid = null;
                    for (NucleicAcidUtils.NucleicAcid3 nucleic : NucleicAcidUtils.nucleicAcidList) {
                        Object nuc3 = nucleic.toString();
                        if (!((String)(nuc3 = ((String)nuc3).substring(((String)nuc3).length() - 3))).equalsIgnoreCase((String)((Object)name))) continue;
                        nucleicAcid = nucleic;
                        break;
                    }
                    if (nucleicAcid != null) continue;
                    logger.info(String.format("Nucleic acid was not recognized %s.", name));
                    isNucleicAcid = false;
                    break;
                }
                if (!isNucleicAcid) continue;
                try {
                    logger.info(String.format(" Nucleic acid chain %s", polymer.getName()));
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format(" EXPERIMENTAL: Finding chain breaks for possible nucleic acid chain %s", polymer.getName()));
                    }
                    double d = properties.getDouble("chainbreak", 3.0);
                    List<List<Residue>> subChains = PolymerUtils.findChainBreaks(residues, d *= 2.0);
                    for (List<Residue> subChain : subChains) {
                        NucleicAcidUtils.assignNucleicAcidAtomTypes(subChain, forceField, bondList);
                    }
                }
                catch (BondedUtils.MissingAtomTypeException | BondedUtils.MissingHeavyAtomException exception) {
                    logger.log(Level.INFO, Utilities.stackTraceToString(exception));
                    logger.severe(exception.toString());
                }
            }
        }
        if ((ions = molecularAssembly.getIons()) != null && !ions.isEmpty()) {
            logger.info(String.format(" Assigning atom types for %d ions.", ions.size()));
            for (MSNode m : ions) {
                Molecule ion = (Molecule)m;
                String name = ion.getResidueName().toUpperCase();
                NamingUtils.HetAtoms hetatm = NamingUtils.HetAtoms.parse(name);
                Atom atom = ion.getAtomList().get(0);
                if (ion.getAtomList().size() != 1) {
                    logger.severe(String.format(" Check residue %s of chain %s.", ion, ion.getChainID()));
                }
                try {
                    switch (hetatm) {
                        case NA: {
                            atom.setAtomType(BondedUtils.findAtomType(2004, forceField));
                            break;
                        }
                        case K: {
                            atom.setAtomType(BondedUtils.findAtomType(2005, forceField));
                            break;
                        }
                        case MG: 
                        case MG2: {
                            atom.setAtomType(BondedUtils.findAtomType(2008, forceField));
                            break;
                        }
                        case CA: 
                        case CA2: {
                            atom.setAtomType(BondedUtils.findAtomType(2009, forceField));
                            break;
                        }
                        case ZN: 
                        case ZN2: {
                            atom.setAtomType(BondedUtils.findAtomType(2016, forceField));
                            break;
                        }
                        case CL: {
                            atom.setAtomType(BondedUtils.findAtomType(2013, forceField));
                            break;
                        }
                        case BR: {
                            atom.setAtomType(BondedUtils.findAtomType(2012, forceField));
                            break;
                        }
                        case I: {
                            atom.setAtomType(BondedUtils.findAtomType(2015, forceField));
                            break;
                        }
                        default: {
                            logger.severe(String.format(" Check residue %s of chain %s.", ion, ion.getChainID()));
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, Utilities.stackTraceToString(exception));
                    String message = "Error assigning atom types.";
                    logger.log(Level.SEVERE, message, exception);
                }
            }
        }
        if ((water = molecularAssembly.getWater()) != null && !water.isEmpty()) {
            logger.info(String.format(" Assigning atom types for %d water.", water.size()));
            for (MSNode m : water) {
                Molecule wat = (Molecule)m;
                try {
                    Atom O = BondedUtils.buildHeavy(wat, "O", null, 2001, forceField, bondList);
                    Atom H1 = BondedUtils.buildH(wat, "H1", O, 0.96, null, 109.5, null, 120.0, 0, 2002, forceField, bondList);
                    Atom atom = BondedUtils.buildH(wat, "H2", O, 0.96, H1, 109.5, null, 120.0, 0, 2002, forceField, bondList);
                    O.setHetero(true);
                    H1.setHetero(true);
                    atom.setHetero(true);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, Utilities.stackTraceToString(e));
                    String message = " Error assigning atom types to a water.";
                    logger.log(Level.SEVERE, message, e);
                }
            }
        }
        List<MSNode> molecules = molecularAssembly.getMolecules();
        for (MSNode m : molecules) {
            Molecule molecule = (Molecule)m;
            String moleculeName = molecule.getResidueName();
            logger.info(" Attempting to patch " + moleculeName);
            List<Atom> list = molecule.getAtomList();
            boolean patched = true;
            HashMap<String, AtomType> types = forceField.getAtomTypes(moleculeName);
            for (Atom atom : list) {
                String atomName2 = atom.getName().toUpperCase();
                AtomType atomType = types.get(atomName2);
                if (atomType == null) {
                    logger.info(" No atom type was found for " + atomName2 + " of " + moleculeName + ".");
                    patched = false;
                    break;
                }
                logger.fine(" " + String.valueOf(atom) + " -> " + String.valueOf(atomType));
                atom.setAtomType(atomType);
                types.remove(atomName2);
            }
            if (patched && !types.isEmpty()) {
                for (AtomType type : types.values()) {
                    if (type.atomicNumber == 1) continue;
                    logger.info(" Missing heavy atom " + type.name);
                    patched = false;
                    break;
                }
            }
            if (patched) {
                for (Atom atom : list) {
                    String atomName = atom.getName();
                    String[] bonds = forceField.getBonds(moleculeName, atomName);
                    if (bonds == null) continue;
                    for (String name : bonds) {
                        Atom atom2 = molecule.getAtom(name);
                        if (atom2 == null || atom.isBonded(atom2)) continue;
                        BondedUtils.buildBond(atom, atom2, forceField, bondList);
                    }
                }
            }
            if (patched && !types.isEmpty()) {
                HashMap<String, Atom> atomMap = new HashMap<String, Atom>();
                for (Atom atom : list) {
                    atomMap.put(atom.getName().toUpperCase(), atom);
                }
                for (String atomName : types.keySet()) {
                    Bond bond;
                    AtomType type = types.get(atomName);
                    String[] bonds = forceField.getBonds(moleculeName, atomName.toUpperCase());
                    if (bonds == null || bonds.length != 1) {
                        patched = false;
                        logger.info(" Check biotype for hydrogen " + type.name + ".");
                        break;
                    }
                    Atom ia = (Atom)atomMap.get(bonds[0].toUpperCase());
                    Atom hydrogen = new Atom(0, atomName, ia.getAltLoc(), new double[3], ia.getResidueName(), ia.getResidueNumber(), ia.getChainID(), ia.getOccupancy(), ia.getTempFactor(), ia.getSegID());
                    logger.fine(" Created hydrogen " + atomName + ".");
                    hydrogen.setAtomType(type);
                    hydrogen.setHetero(true);
                    molecule.addMSNode(hydrogen);
                    int valence = ia.getAtomType().valence;
                    List<Bond> aBonds = ia.getBonds();
                    int numBonds = aBonds.size();
                    Atom ib = null;
                    Atom ic = null;
                    Atom id = null;
                    if (numBonds > 0) {
                        bond = aBonds.get(0);
                        ib = bond.get1_2(ia);
                    }
                    if (numBonds > 1) {
                        bond = aBonds.get(1);
                        ic = bond.get1_2(ia);
                    }
                    if (numBonds > 2) {
                        bond = aBonds.get(2);
                        id = bond.get1_2(ia);
                    }
                    logger.fine(" Bonding " + atomName + " to " + ia.getName() + " (" + numBonds + " of " + valence + ").");
                    block38 : switch (valence) {
                        case 4: {
                            switch (numBonds) {
                                case 3: {
                                    double[] b = ib.getXYZ(null);
                                    double[] c = ic.getXYZ(null);
                                    double[] d = id.getXYZ(null);
                                    double[] a = new double[]{(b[0] + c[0] + d[0]) / 3.0, (b[1] + c[1] + d[1]) / 3.0, (b[2] + c[2] + d[2]) / 3.0};
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, ic, 109.5, 1);
                                    double[] e1 = new double[3];
                                    hydrogen.getXYZ(e1);
                                    double[] ret = new double[3];
                                    DoubleMath.sub((double[])a, (double[])e1, (double[])ret);
                                    double l1 = DoubleMath.length((double[])ret);
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, ic, 109.5, -1);
                                    double[] e2 = new double[3];
                                    hydrogen.getXYZ(e2);
                                    DoubleMath.sub((double[])a, (double[])e2, (double[])ret);
                                    double l2 = DoubleMath.length((double[])ret);
                                    if (!(l1 > l2)) break block38;
                                    hydrogen.setXYZ(e1);
                                    break;
                                }
                                case 2: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, ic, 109.5, 0);
                                    break;
                                }
                                case 1: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, null, 0.0, 0);
                                    break;
                                }
                                case 0: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                    break;
                                }
                                default: {
                                    logger.info(" Check biotype for hydrogen " + atomName + ".");
                                    patched = false;
                                    break;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (numBonds) {
                                case 2: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 120.0, ic, 0.0, 0);
                                    break block38;
                                }
                                case 1: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 120.0, null, 0.0, 0);
                                    break block38;
                                }
                                case 0: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                    break block38;
                                }
                            }
                            logger.info(" Check biotype for hydrogen " + atomName + ".");
                            patched = false;
                            break;
                        }
                        case 2: {
                            switch (numBonds) {
                                case 1: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 120.0, null, 0.0, 0);
                                    break block38;
                                }
                                case 0: {
                                    BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                    break block38;
                                }
                            }
                            logger.info(" Check biotype for hydrogen " + atomName + ".");
                            patched = false;
                            break;
                        }
                        case 1: {
                            if (numBonds == 0) {
                                BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                break;
                            }
                            logger.info(" Check biotype for hydrogen " + atomName + ".");
                            patched = false;
                            break;
                        }
                        default: {
                            logger.info(" Check biotype for hydrogen " + atomName + ".");
                            patched = false;
                        }
                    }
                    if (!patched) break;
                    BondedUtils.buildBond(ia, hydrogen, forceField, bondList);
                }
            }
            if (!patched) {
                logger.log(Level.INFO, String.format(" Deleting unrecognized molecule %s.", m));
                molecularAssembly.deleteMolecule((Molecule)m);
                continue;
            }
            logger.info(" Patch for " + moleculeName + " succeeded.");
        }
        PolymerUtils.resolvePolymerLinks(molecules, molecularAssembly, bondList);
        return bondList;
    }

    public static void buildDisulfideBonds(List<Bond> ssBondList, MolecularAssembly molecularAssembly, List<Bond> bondList) {
        StringBuilder sb = new StringBuilder(" Disulfide Bonds:");
        ForceField forceField = molecularAssembly.getForceField();
        for (Bond bond : ssBondList) {
            Atom a1 = bond.getAtom(0);
            Atom a2 = bond.getAtom(1);
            BondType bondType = forceField.getBondType(a1.getAtomType(), a2.getAtomType());
            if (bondType == null) {
                Bond.logNoBondType(a1, a2, forceField);
            } else {
                bond.setBondType(bondType);
            }
            double d = DoubleMath.dist((double[])a1.getXYZ(null), (double[])a2.getXYZ(null));
            Polymer c1 = molecularAssembly.getChain(a1.getSegID());
            Polymer c2 = molecularAssembly.getChain(a2.getSegID());
            Residue r1 = c1.getResidue(a1.getResidueNumber());
            Residue r2 = c2.getResidue(a2.getResidueNumber());
            sb.append(String.format("\n S-S distance of %6.2f for %s and %s.", d, r1.toString(), r2.toString()));
            bondList.add(bond);
        }
        if (!ssBondList.isEmpty()) {
            logger.info(sb.toString());
        }
    }

    public static int buildMissingResidues(int xyzIndex, MolecularAssembly molecularAssembly, Map<Character, String[]> seqres, Map<Character, int[]> dbref) {
        Polymer[] polymers;
        CompositeConfiguration properties = molecularAssembly.getProperties();
        if (!properties.getBoolean("buildLoops", false)) {
            return xyzIndex;
        }
        block0: for (Polymer polymer : polymers = molecularAssembly.getChains()) {
            Character chainID = polymer.getChainID();
            String[] resNames = seqres.get(chainID);
            int[] seqRange = dbref.get(chainID);
            if (resNames == null || seqRange == null) continue;
            int seqBegin = seqRange[0];
            int seqEnd = seqRange[1];
            logger.info(String.format("\n Checking for missing residues in chain %s between residues %d and %d.", polymer, seqBegin, seqEnd));
            int firstResID = polymer.getFirstResidue().getResidueNumber();
            for (int i = 0; i < resNames.length; ++i) {
                int currentID = seqBegin + i;
                Residue currentResidue = polymer.getResidue(currentID);
                if (currentResidue != null) continue;
                if (currentID <= firstResID) {
                    logger.info(String.format(" Residue %d is missing, but is at the beginning of the chain.", currentID));
                    continue;
                }
                Residue previousResidue = polymer.getResidue(currentID - 1);
                if (previousResidue == null) {
                    logger.info(String.format(" Residue %d is missing, but could not be build (previous residue missing).", currentID));
                    continue;
                }
                Residue nextResidue = null;
                for (int j = currentID + 1; j <= seqEnd && (nextResidue = polymer.getResidue(j)) == null; ++j) {
                }
                if (nextResidue == null) {
                    logger.info(String.format(" Residue %d is missing, but is at the end of the chain.", currentID));
                    continue block0;
                }
                Atom C = (Atom)previousResidue.getAtomNode("C");
                Atom N = (Atom)nextResidue.getAtomNode("N");
                if (C == null || N == null) {
                    logger.info(String.format(" Residue %d is missing, but bonding atoms are missing (C or N).", currentID));
                    continue;
                }
                currentResidue = polymer.getResidue(resNames[i], currentID, true);
                double[] vector = new double[3];
                int count = 3 * (nextResidue.getResidueNumber() - previousResidue.getResidueNumber());
                DoubleMath.sub((double[])N.getXYZ(null), (double[])C.getXYZ(null), (double[])vector);
                DoubleMath.scale((double[])vector, (double)(1.0 / (double)count), (double[])vector);
                double[] nXYZ = new double[3];
                DoubleMath.add((double[])C.getXYZ(null), (double[])vector, (double[])nXYZ);
                nXYZ[0] = nXYZ[0] + (FastMath.random() - 0.5);
                nXYZ[1] = nXYZ[1] + (FastMath.random() - 0.5);
                nXYZ[2] = nXYZ[2] + (FastMath.random() - 0.5);
                Atom newN = new Atom(xyzIndex++, "N", C.getAltLoc(), nXYZ, resNames[i], currentID, chainID, 1.0, C.getTempFactor(), C.getSegID(), true);
                currentResidue.addMSNode(newN);
                double[] caXYZ = new double[3];
                DoubleMath.scale((double[])vector, (double)2.0, (double[])vector);
                DoubleMath.add((double[])C.getXYZ(null), (double[])vector, (double[])caXYZ);
                caXYZ[0] = caXYZ[0] + (Math.random() - 0.5);
                caXYZ[1] = caXYZ[1] + (Math.random() - 0.5);
                caXYZ[2] = caXYZ[2] + (Math.random() - 0.5);
                Atom newCA = new Atom(xyzIndex++, "CA", C.getAltLoc(), caXYZ, resNames[i], currentID, chainID, 1.0, C.getTempFactor(), C.getSegID(), true);
                currentResidue.addMSNode(newCA);
                double[] cXYZ = new double[3];
                DoubleMath.scale((double[])vector, (double)1.5, (double[])vector);
                DoubleMath.add((double[])C.getXYZ(null), (double[])vector, (double[])cXYZ);
                cXYZ[0] = cXYZ[0] + (Math.random() - 0.5);
                cXYZ[1] = cXYZ[1] + (Math.random() - 0.5);
                cXYZ[2] = cXYZ[2] + (Math.random() - 0.5);
                Atom newC = new Atom(xyzIndex++, "C", C.getAltLoc(), cXYZ, resNames[i], currentID, chainID, 1.0, C.getTempFactor(), C.getSegID(), true);
                currentResidue.addMSNode(newC);
                double[] oXYZ = new double[3];
                vector[0] = Math.random() - 0.5;
                vector[1] = Math.random() - 0.5;
                vector[2] = Math.random() - 0.5;
                DoubleMath.add((double[])cXYZ, (double[])vector, (double[])oXYZ);
                Atom newO = new Atom(xyzIndex++, "O", C.getAltLoc(), oXYZ, resNames[i], currentID, chainID, 1.0, C.getTempFactor(), C.getSegID(), true);
                currentResidue.addMSNode(newO);
                logger.info(String.format(" Building residue %8s.", currentResidue));
            }
        }
        return xyzIndex;
    }

    public static List<List<Residue>> findChainBreaks(List<Residue> residues, double cutoff) {
        ArrayList<List<Residue>> subChains = new ArrayList<List<Residue>>();
        Residue.ResidueType rType = residues.get(0).getResidueType();
        String startAtName = null;
        String endAtName = null;
        switch (rType) {
            case AA: {
                startAtName = "N";
                endAtName = "C";
                break;
            }
            case NA: {
                boolean namedStar = residues.stream().flatMap(r -> r.getAtomList().stream()).anyMatch(a -> a.getName().equals("O5*"));
                if (namedStar) {
                    startAtName = "O5*";
                    endAtName = "O3*";
                    break;
                }
                startAtName = "O5'";
                endAtName = "O3'";
                break;
            }
            case UNK: {
                logger.fine(" Not attempting to find chain breaks for chain with residue " + residues.get(0).toString());
                ArrayList<List<Residue>> retList = new ArrayList<List<Residue>>();
                retList.add(residues);
                return retList;
            }
        }
        ArrayList<Residue> subChain = null;
        Residue previousResidue = null;
        Atom priorEndAtom = null;
        StringBuilder sb = new StringBuilder(" Chain Breaks:");
        for (Residue residue : residues) {
            List<Atom> resAtoms = residue.getAtomList();
            if (priorEndAtom == null) {
                subChain = new ArrayList<Residue>();
                subChain.add(residue);
                subChains.add(subChain);
            } else {
                Atom startAtom = null;
                for (Atom a2 : resAtoms) {
                    if (!a2.getName().equalsIgnoreCase(startAtName)) continue;
                    startAtom = a2;
                    break;
                }
                if (startAtom == null) {
                    subChain.add(residue);
                    continue;
                }
                double r2 = DoubleMath.dist((double[])priorEndAtom.getXYZ(null), (double[])startAtom.getXYZ(null));
                if (r2 > cutoff) {
                    subChain = new ArrayList();
                    subChain.add(residue);
                    subChains.add(subChain);
                    char ch1 = previousResidue.getChainID().charValue();
                    char ch2 = residue.getChainID().charValue();
                    sb.append(String.format("\n C-N distance of %6.2f A for %c-%s and %c-%s.", r2, Character.valueOf(ch1), previousResidue, Character.valueOf(ch2), residue));
                } else {
                    subChain.add(residue);
                }
            }
            for (Atom a3 : resAtoms) {
                if (!a3.getName().equalsIgnoreCase(endAtName)) continue;
                priorEndAtom = a3;
                break;
            }
            previousResidue = residue;
        }
        if (subChains.size() > 1) {
            logger.info(sb.toString());
        }
        return subChains;
    }

    public static List<Bond> locateDisulfideBonds(List<String> ssbonds, MolecularAssembly molecularAssembly, Map<String, String> pdbToNewResMap) {
        ArrayList<Bond> ssBondList = new ArrayList<Bond>();
        for (String ssbond : ssbonds) {
            try {
                char c1ch = ssbond.charAt(15);
                char c2ch = ssbond.charAt(29);
                Polymer c1 = molecularAssembly.getChain(String.format("%c", Character.valueOf(c1ch)));
                Polymer c2 = molecularAssembly.getChain(String.format("%c", Character.valueOf(c2ch)));
                Polymer[] chains = molecularAssembly.getChains();
                if (c1 == null) {
                    c1 = chains[0];
                }
                if (c2 == null) {
                    c2 = chains[0];
                }
                String origResNum1 = ssbond.substring(17, 21).trim();
                char insChar1 = ssbond.charAt(21);
                String origResNum2 = ssbond.substring(31, 35).trim();
                char insChar2 = ssbond.charAt(35);
                String pdbResNum1 = String.format("%c%s%c", Character.valueOf(c1ch), origResNum1, Character.valueOf(insChar1));
                String pdbResNum2 = String.format("%c%s%c", Character.valueOf(c2ch), origResNum2, Character.valueOf(insChar2));
                String resnum1 = pdbToNewResMap.get(pdbResNum1);
                String resnum2 = pdbToNewResMap.get(pdbResNum2);
                if (resnum1 == null) {
                    logger.warning(String.format(" Could not find residue %s for SS-bond %s", pdbResNum1, ssbond));
                    continue;
                }
                if (resnum2 == null) {
                    logger.warning(String.format(" Could not find residue %s for SS-bond %s", pdbResNum2, ssbond));
                    continue;
                }
                Residue r1 = c1.getResidue(Integer.parseInt(resnum1.substring(1)));
                Residue r2 = c2.getResidue(Integer.parseInt(resnum2.substring(1)));
                List<Atom> atoms1 = r1.getAtomList();
                List<Atom> atoms2 = r2.getAtomList();
                Atom SG1 = null;
                Atom SG2 = null;
                for (Atom atom : atoms1) {
                    if (!atom.getName().equalsIgnoreCase("SG")) continue;
                    SG1 = atom;
                    break;
                }
                for (Atom atom : atoms2) {
                    if (!atom.getName().equalsIgnoreCase("SG")) continue;
                    SG2 = atom;
                    break;
                }
                if (SG1 == null) {
                    logger.warning(String.format(" SG atom 1 of SS-bond %s is null", ssbond));
                }
                if (SG2 == null) {
                    logger.warning(String.format(" SG atom 2 of SS-bond %s is null", ssbond));
                }
                if (SG1 == null || SG2 == null) continue;
                double d = DoubleMath.dist((double[])SG1.getXYZ(null), (double[])SG2.getXYZ(null));
                if (d < 5.0) {
                    r1.setName("CYX");
                    r2.setName("CYX");
                    for (Atom atom : atoms1) {
                        atom.setResName("CYX");
                    }
                    for (Atom atom : atoms2) {
                        atom.setResName("CYX");
                    }
                    Bond bond = new Bond(SG1, SG2);
                    ssBondList.add(bond);
                    continue;
                }
                String message = String.format("Ignoring [%s]\n due to distance %8.3f A.", ssbond, d);
                logger.log(Level.WARNING, message);
            }
            catch (Exception e) {
                String message = String.format("Ignoring [%s]", ssbond);
                logger.log(Level.WARNING, message, e);
            }
        }
        return ssBondList;
    }

    public static void resolvePolymerLinks(List<MSNode> molecules, MolecularAssembly molecularAssembly, List<Bond> bondList) {
        ForceField forceField = molecularAssembly.getForceField();
        CompositeConfiguration properties = molecularAssembly.getProperties();
        for (String polyLink : properties.getStringArray("polymerlink")) {
            logger.info(" Experimental: linking a cyclic hetero group: " + polyLink);
            String[] toks = polyLink.split("\\s+");
            String resName = toks[0];
            String name1 = toks[1];
            String name2 = toks[2];
            int cyclicLen = 0;
            if (toks.length > 3) {
                cyclicLen = Integer.parseInt(toks[3]);
            }
            ArrayList<Molecule> matches = new ArrayList<Molecule>();
            for (MSNode node : molecules) {
                Molecule m = (Molecule)node;
                if (!m.getResidueName().equalsIgnoreCase(resName)) continue;
                matches.add(m);
            }
            for (int i = 0; i < matches.size(); ++i) {
                Molecule next;
                Molecule mi = (Molecule)matches.get(i);
                int ii = i + 1;
                if (cyclicLen < 1) {
                    logger.severe(" No current support for polymeric, non-cyclic hetero groups");
                    continue;
                }
                if (ii % cyclicLen == 0) {
                    next = (Molecule)matches.get(ii - cyclicLen);
                    logger.info(String.format(" Cyclizing molecule %s to %s", mi, next));
                } else {
                    next = (Molecule)matches.get(ii);
                    logger.info(String.format(" Extending chain from %s to %s.", mi, next));
                }
                Atom from = mi.getAtomByName(name1, true);
                Atom to = next.getAtomByName(name2, true);
                BondedUtils.buildBond(from, to, forceField, bondList);
            }
        }
    }
}

