/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.Joint;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.MultiResidue;
import ffx.potential.bonded.NucleicAcidUtils;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.vecmath.Color3f;

public class Polymer
extends MSGroup {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, Color3f> polymerColor = new HashMap<Integer, Color3f>();
    private static int count = 0;
    public static final String CHAIN_IDS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz";
    private boolean link = false;
    private final int polymerNumber;
    private Character chainID;

    public Polymer(Character chainID, String segID) {
        super(segID);
        this.chainID = chainID;
        this.polymerNumber = ++count;
    }

    public Polymer(Character chainID, String segID, boolean link) {
        this(chainID, segID);
        this.link = link;
    }

    public Polymer(Character chainID, String segID, MSNode residues) {
        super(segID, residues);
        this.chainID = chainID;
        this.polymerNumber = ++count;
    }

    @Override
    public MSNode addMSNode(MSNode msNode) {
        int n;
        assert (msNode instanceof Residue);
        Residue residue = (Residue)msNode;
        int resNumber = residue.getResidueNumber();
        MSNode residueNode = this.getAtomNode();
        int childIndex = n = residueNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            Residue current = (Residue)residueNode.getChildAt(i);
            if (current.getResidueNumber() <= resNumber) continue;
            childIndex = i;
            break;
        }
        residueNode.insert(residue, childIndex);
        residue.setChainID(this.chainID);
        return msNode;
    }

    public void setChainID(Character chainID) {
        this.chainID = chainID;
        for (Residue residue : this.getResidues()) {
            residue.setChainID(chainID);
        }
    }

    public void setSegID(String segID) {
        this.setName(segID);
        for (Residue residue : this.getResidues()) {
            residue.setSegID(segID);
        }
    }

    public void addMultiResidue(MultiResidue multiResidue) {
        Residue residue = multiResidue.getActive();
        MSNode residueNode = this.getAtomNode();
        int index = residueNode.getIndex(residue);
        if (index < 0) {
            System.err.println("WARNING!  Polymer::addMultiResidue did not find a corresponding Residue on Polymer.");
            residueNode.add(multiResidue);
        } else {
            residue.removeFromParent();
            residueNode.insert(multiResidue, index);
            multiResidue.add(residue);
        }
    }

    public Joint createJoint(Residue residue1, Residue residue2, ForceField forceField) {
        Joint joint = null;
        double[] da = new double[3];
        double[] db = new double[3];
        Enumeration<TreeNode> e = residue1.getAtomNode().children();
        while (e.hasMoreElements()) {
            Atom a1 = (Atom)e.nextElement();
            a1.getXYZ(da);
            Enumeration<TreeNode> e2 = residue2.getAtomNode().children();
            while (e2.hasMoreElements()) {
                double d2;
                Atom a2 = (Atom)e2.nextElement();
                a2.getXYZ(db);
                double d1 = DoubleMath.dist((double[])da, (double[])db);
                if (!(d1 < (d2 = (double)0.7f + a1.getVDWR() / 2.0 + a2.getVDWR() / 2.0))) continue;
                Bond b = new Bond(a1, a2);
                Joint newJoint = this.createJoint(b, residue1, residue2, forceField);
                if (joint != null) {
                    joint.merge(newJoint);
                    continue;
                }
                joint = newJoint;
            }
        }
        return joint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polymer polymer = (Polymer)o;
        return this.polymerNumber == polymer.polymerNumber && Objects.equals(this.getName(), polymer.getName());
    }

    @Override
    public void finalize(boolean finalizeGroups, ForceField forceField) {
        List<MSNode> residues = this.getAtomNodeList();
        this.setFinalized(false);
        if (finalizeGroups) {
            for (MSNode node : residues) {
                Residue residue = (Residue)node;
                residue.finalize(true, forceField);
            }
        }
        if (this.link) {
            Residue residue = this.getFirstResidue();
            if (residue.residueType == Residue.ResidueType.AA) {
                this.getAtomNode().setName("Amino Acids (" + residues.size() + ")");
            } else if (residue.residueType == Residue.ResidueType.NA) {
                this.getAtomNode().setName("Nucleic Acids (" + residues.size() + ")");
            } else {
                this.getAtomNode().setName("Residues (" + residues.size() + ")");
            }
            MSNode joints = this.getTermNode();
            joints.removeAllChildren();
            List<Atom> atoms = this.getAtomList();
            for (Atom a : atoms) {
                if (a.getNumBonds() <= 0) continue;
                for (Bond b : a.getBonds()) {
                    if (b.sameGroup() || b.getParent() != null) continue;
                    Residue r1 = a.getMSNode(Residue.class);
                    Residue r2 = b.get1_2(a).getMSNode(Residue.class);
                    Joint j = this.createJoint(b, r1, r2, forceField);
                    joints.add(j);
                }
            }
            if (residue.residueType == Residue.ResidueType.AA) {
                this.getTermNode().setName("Peptide Bonds (" + joints.getChildCount() + ")");
            } else {
                this.getTermNode().setName("Linkages (" + joints.getChildCount() + ")");
            }
        } else {
            this.getAtomNode().setName("Sub-Groups (" + residues.size() + ")");
            if (this.getTermNode().getParent() != null) {
                this.removeChild(this.getTermNode());
            }
        }
        this.removeLeaves();
        this.setFinalized(true);
    }

    public Character getChainID() {
        return this.chainID;
    }

    public Residue getFirstResidue() {
        MSNode atomNode = this.getAtomNode();
        if (atomNode == null) {
            return null;
        }
        return (Residue)atomNode.getChildAt(0);
    }

    public boolean getLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public List<List<Torsion>> getPhiPsiList() {
        ArrayList<List<Torsion>> phiPsi = new ArrayList<List<Torsion>>();
        ArrayList<Torsion> phi = new ArrayList<Torsion>();
        ArrayList<Torsion> psi = new ArrayList<Torsion>();
        phiPsi.add(phi);
        phiPsi.add(psi);
        for (Residue residue : this.getResidues()) {
            for (Torsion torsion : residue.getTorsionList()) {
                Atom[] atoms = torsion.atoms;
                StringBuilder s = new StringBuilder(atoms[0].getName());
                for (int i = 1; i < 4; ++i) {
                    s.append("-").append(atoms[i].getName());
                }
                if (s.toString().equals("C-N-CA-C") || s.toString().equals("C-CA-N-C")) {
                    phi.add(torsion);
                    continue;
                }
                if (!s.toString().equals("N-C-CA-N") && !s.toString().equals("N-CA-C-N")) continue;
                psi.add(torsion);
            }
        }
        return phiPsi;
    }

    public Residue getResidue(int resNum) {
        Residue r;
        if (resNum > 0 && this.getAtomNode().getChildCount() >= resNum && (r = (Residue)this.getAtomNode().getChildAt(resNum - 1)).getResidueNumber() == resNum) {
            return r;
        }
        Enumeration<TreeNode> e = this.getAtomNode().children();
        while (e.hasMoreElements()) {
            Residue r2 = (Residue)e.nextElement();
            if (r2.getResidueNumber() != resNum) continue;
            return r2;
        }
        return null;
    }

    public Residue getResidue(String resName, int resNum, boolean create) {
        return this.getResidue(resName, resNum, create, Residue.ResidueType.UNK);
    }

    public Residue getResidue(String resName, int resNum, boolean create, Residue.ResidueType defaultRT) {
        Enumeration<TreeNode> e = this.getAtomNode().children();
        while (e.hasMoreElements()) {
            Residue r = (Residue)e.nextElement();
            if (r.getResidueNumber() == resNum && r.getName().equalsIgnoreCase(resName)) {
                return r;
            }
            if (!resName.equals(AminoAcidUtils.AminoAcid3.UNK.name()) || resNum != r.getResidueNumber()) continue;
            return r;
        }
        if (!create) {
            return null;
        }
        Residue residue = null;
        if ((resName = resName.toUpperCase()).length() == 1) {
            try {
                NucleicAcidUtils.NucleicAcid1.valueOf(resName);
                residue = new Residue(resName, resNum, Residue.ResidueType.NA, this.chainID, this.getName());
            }
            catch (Exception e2) {
                try {
                    AminoAcidUtils.AminoAcid1.valueOf(resName);
                    residue = new Residue(resName, resNum, Residue.ResidueType.AA, this.chainID, this.getName());
                }
                catch (Exception exception) {}
            }
        } else if (resName.length() >= 2) {
            try {
                NucleicAcidUtils.NucleicAcid3.valueOf(resName);
                residue = new Residue(resName, resNum, Residue.ResidueType.NA, this.chainID, this.getName());
            }
            catch (Exception e3) {
                try {
                    AminoAcidUtils.AminoAcid3.valueOf(resName);
                    residue = new Residue(resName, resNum, Residue.ResidueType.AA, this.chainID, this.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (residue == null) {
            residue = new Residue(resName, resNum, defaultRT, this.chainID, this.getName());
        }
        this.addMSNode(residue);
        return residue;
    }

    public List<Residue> getResidues() {
        ArrayList<Residue> residues = new ArrayList<Residue>();
        Enumeration<TreeNode> e = this.getAtomNode().children();
        while (e.hasMoreElements()) {
            Residue r = (Residue)e.nextElement();
            residues.add(r);
        }
        return residues;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.polymerNumber, this.getName());
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (newColorModel == RendererCache.ColorModel.POLYMER) {
            int index = this.polymerNumber % 10;
            color = polymerColor.get(index);
            mat = RendererCache.materialFactory(color);
        }
        for (MSNode node : this.getAtomNodeList()) {
            MSGroup atomGroup = (MSGroup)node;
            atomGroup.setColor(newColorModel, color, mat);
        }
        Enumeration<TreeNode> e = this.getTermNode().children();
        while (e.hasMoreElements()) {
            Joint joint = (Joint)e.nextElement();
            joint.setColor(newColorModel);
        }
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        for (MSNode node : this.getAtomNodeList()) {
            MSGroup atomGroup = (MSGroup)node;
            atomGroup.setView(newViewModel, newShapes);
        }
        Enumeration<TreeNode> e = this.getTermNode().children();
        while (e.hasMoreElements()) {
            Joint joint = (Joint)e.nextElement();
            joint.setView(newViewModel, newShapes);
        }
    }

    static {
        polymerColor.put(0, RendererCache.RED);
        polymerColor.put(1, RendererCache.ORANGE);
        polymerColor.put(2, RendererCache.YELLOW);
        polymerColor.put(3, RendererCache.GREEN);
        polymerColor.put(4, RendererCache.BLUE);
        polymerColor.put(5, RendererCache.MAGENTA);
        polymerColor.put(6, RendererCache.CYAN);
        polymerColor.put(7, RendererCache.WHITE);
        polymerColor.put(8, RendererCache.GRAY);
        polymerColor.put(9, RendererCache.PINK);
    }
}

