/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.OutOfPlaneBendType;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class OutOfPlaneBend
extends BondedTerm {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(OutOfPlaneBend.class.getName());
    public OutOfPlaneBendType outOfPlaneBendType = null;

    public OutOfPlaneBend(Angle angle, Atom atom) {
        this.atoms = new Atom[4];
        this.atoms[0] = angle.atoms[0];
        this.atoms[1] = angle.atoms[1];
        this.atoms[2] = angle.atoms[2];
        this.atoms[3] = atom;
        this.bonds = new Bond[3];
        this.bonds[0] = angle.bonds[0];
        this.bonds[1] = angle.bonds[1];
        this.bonds[2] = this.atoms[1].getBond(atom);
        this.setID_Key(false);
    }

    public Atom getFourthAtom() {
        return this.atoms[3];
    }

    public Atom getTrigonalAtom() {
        return this.atoms[1];
    }

    public Atom getFirstAngleAtom() {
        return this.atoms[0];
    }

    public Atom getLastAngleAtom() {
        return this.atoms[2];
    }

    public static OutOfPlaneBend outOfPlaneBendFactory(Angle angle, ForceField forceField) {
        Atom centralAtom = angle.atoms[1];
        if (centralAtom.isTrigonal()) {
            Atom fourthAtom = angle.getFourthAtomOfTrigonalCenter();
            Atom[] atoms = angle.atoms;
            OutOfPlaneBendType outOfPlaneBendType = forceField.getOutOfPlaneBendType(fourthAtom.getAtomType(), atoms[0].getAtomType(), atoms[1].getAtomType(), atoms[2].getAtomType());
            if (outOfPlaneBendType != null) {
                if (angle.getAngleMode() == AngleType.AngleMode.IN_PLANE) {
                    angle.setInPlaneAtom(fourthAtom);
                }
                OutOfPlaneBend outOfPlaneBend = new OutOfPlaneBend(angle, fourthAtom);
                outOfPlaneBend.setOutOfPlaneBendType(outOfPlaneBendType);
                return outOfPlaneBend;
            }
        }
        return null;
    }

    @Override
    public int compareTo(BondedTerm o) {
        int a1;
        if (o == null) {
            throw new NullPointerException();
        }
        if (o == this) {
            return 0;
        }
        if (!o.getClass().isInstance(this)) {
            return super.compareTo(o);
        }
        int this1 = this.atoms[1].getIndex();
        if (this1 < (a1 = o.atoms[1].getIndex())) {
            return -1;
        }
        if (this1 > a1) {
            return 1;
        }
        int this3 = this.atoms[3].getIndex();
        int a3 = o.atoms[3].getIndex();
        return Integer.compare(this3, a3);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.energy = 0.0;
        this.value = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        Atom atomD = this.atoms[3];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vd = atomD.getXYZ();
        Double3 vab = va.sub(vb);
        Double3 vcb = vc.sub(vb);
        Double3 vdb = vd.sub(vb);
        Double3 vad = va.sub(vd);
        Double3 vcd = vc.sub(vd);
        double rdb2 = vdb.length2();
        double rad2 = vad.length2();
        double rcd2 = vcd.length2();
        Double3 vp = vcb.X(vdb);
        double ee = vab.dot(vp);
        double rac2 = vad.dot(vcd);
        double cc = rad2 * rcd2 - rac2 * rac2;
        if (rdb2 != 0.0 && cc != 0.0) {
            double bkk2 = rdb2 - ee * ee / cc;
            double cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)FastMath.sqrt((double)(bkk2 / rdb2))));
            double dv = this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
            double dv2 = dv * dv;
            double dv3 = dv2 * dv;
            double dv4 = dv2 * dv2;
            this.energy = this.outOfPlaneBendType.opBendUnit * this.outOfPlaneBendType.forceConstant * dv2 * (1.0 + this.outOfPlaneBendType.cubic * dv + this.outOfPlaneBendType.quartic * dv2 + this.outOfPlaneBendType.pentic * dv3 + this.outOfPlaneBendType.sextic * dv4);
            if (gradient) {
                double deddt = this.outOfPlaneBendType.opBendUnit * this.outOfPlaneBendType.forceConstant * dv * FastMath.toDegrees((double)(2.0 + 3.0 * this.outOfPlaneBendType.cubic * dv + 4.0 * this.outOfPlaneBendType.quartic * dv2 + 5.0 * this.outOfPlaneBendType.pentic * dv3 + 6.0 * this.outOfPlaneBendType.sextic * dv4));
                double dedcos = 0.0;
                dedcos = ee != 0.0 ? -deddt * FastMath.signum((double)ee) / FastMath.sqrt((double)(cc * bkk2)) : -deddt / FastMath.sqrt((double)(cc * bkk2));
                double term = ee / cc;
                Double3 svad = vad.scale(rcd2);
                Double3 svcd = vcd.scale(rac2);
                Double3 dcda = svad.sub(svcd).scaleI(term);
                svad = vad.scale(rac2);
                svcd = vcd.scale(rad2);
                Double3 dadc = svcd.sub(svad).scaleI(term);
                Double3 dcdd = dcda.add(dadc).scaleI(-1.0);
                Double3 deda = vdb.X(vcb);
                Double3 dedc = vab.X(vdb);
                Double3 dedd = vcb.X(vab);
                dedd.addI(vdb.scaleI(ee / rdb2));
                Double3 ga = dcda.add(deda).scaleI(dedcos);
                Double3 gc = dadc.add(dedc).scaleI(dedcos);
                Double3 gd = dcdd.add(dedd).scaleI(dedcos);
                Double3 gb = ga.add(gc).addI(gd).scaleI(-1.0);
                int ia = atomA.getIndex() - 1;
                int ib = atomB.getIndex() - 1;
                int ic = atomC.getIndex() - 1;
                int id = atomD.getIndex() - 1;
                grad.add(threadID, ia, ga);
                grad.add(threadID, ib, gb);
                grad.add(threadID, ic, gc);
                grad.add(threadID, id, gd);
            }
        }
        return this.energy;
    }

    public void log() {
        logger.info(String.format(" %s %6d-%s %6d-%s %6.4f %10.4f", "Out-of-Plane Bend", this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[3].getIndex(), this.atoms[3].getAtomType().name, this.value, this.energy));
    }

    public void setOutOfPlaneBendType(OutOfPlaneBendType a) {
        this.outOfPlaneBendType = a;
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.1f,%7.2f)", this.id, this.value, this.energy);
    }
}

