/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.Atom;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.MSNode;
import ffx.potential.parameters.ForceField;
import java.util.Objects;
import java.util.logging.Logger;

public class Molecule
extends MSGroup {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Molecule.class.getName());
    private int residueNum;
    private String residueName;
    private Character chainID;
    private final String segID;

    public Molecule(String name) {
        super(name);
        this.residueName = name;
        this.residueNum = -1;
        this.chainID = Character.valueOf('A');
        this.segID = "A";
    }

    public Molecule(String name, int residueNum, Character chainID, String segID) {
        super(name + "-" + residueNum + " " + segID);
        this.residueName = name;
        this.residueNum = residueNum;
        this.chainID = chainID;
        this.segID = segID;
    }

    public void setChainID(Character c) {
        this.chainID = c;
        for (Atom atom : this.getAtomList()) {
            atom.setChainID(c);
        }
    }

    public void setResidueNum(int residueNum) {
        this.residueNum = residueNum;
        for (Atom atom : this.getAtomList()) {
            atom.setResidueNumber(residueNum);
        }
    }

    @Override
    public MSNode addMSNode(MSNode o) {
        Atom currentAtom = null;
        if (o instanceof Atom) {
            Atom newAtom = (Atom)o;
            Character newAlt = newAtom.getAltLoc();
            MSNode atoms = this.getAtomNode();
            currentAtom = (Atom)atoms.contains(newAtom);
            if (currentAtom == null) {
                currentAtom = newAtom;
                atoms.add(newAtom);
                this.setFinalized(false);
            } else {
                Character currentAlt = currentAtom.getAltLoc();
                if ((currentAlt.equals(Character.valueOf(' ')) || currentAlt.equals(Character.valueOf('A'))) && !newAlt.equals(Character.valueOf(' ')) && !newAlt.equals(Character.valueOf('A'))) {
                    newAtom.setXyzIndex(currentAtom.getXyzIndex());
                    atoms.remove(currentAtom);
                    currentAtom = newAtom;
                    atoms.add(currentAtom);
                    this.setFinalized(false);
                }
            }
        } else {
            logger.warning(" Only an Atom can be added to a Residue.");
        }
        return currentAtom;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Molecule molecule = (Molecule)o;
        return this.residueNum == molecule.residueNum && Objects.equals(this.residueName, molecule.residueName) && Objects.equals(this.segID, molecule.segID);
    }

    @Override
    public void finalize(boolean finalizeGeometry, ForceField forceField) {
        this.setFinalized(false);
        this.getAtomNode().setName("Atoms (" + this.getAtomList().size() + ")");
        if (finalizeGeometry) {
            this.assignBondedTerms(forceField);
            this.removeLeaves();
        }
        this.setCenter(this.getMultiScaleCenter(false));
        this.setFinalized(true);
    }

    public Atom getAtom(String name) {
        for (Atom a : this.getAtomList()) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            return a;
        }
        return null;
    }

    public Character getChainID() {
        return this.chainID;
    }

    public String getKey() {
        return this.residueNum + this.residueName + this.segID;
    }

    public String getResidueName() {
        return this.residueName;
    }

    public int getResidueNumber() {
        return this.residueNum;
    }

    public String getSegID() {
        return this.segID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.residueNum, this.residueName, this.segID);
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            if (this.segID != null) {
                super.setName(name + "-" + this.residueNum + " " + this.segID);
            } else {
                super.setName(name);
            }
            this.residueName = name;
        }
    }
}

