/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.Constraint;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedEnergy;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.StretchBend;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.bonded.Torsion;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.bonded.UreyBradley;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.vecmath.Color3f;

public abstract class BondedTerm
extends MSNode
implements BondedEnergy,
Comparable<BondedTerm> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BondedTerm.class.getName());
    private static final StringBuilder idTemp = new StringBuilder();
    private static final BondedComparator bondedComparator = new BondedComparator();
    protected String id;
    protected Atom[] atoms;
    protected Bond[] bonds;
    protected double value;
    protected double energy;
    private boolean isConstrained = false;

    public BondedTerm() {
        super("", 1);
        this.setAllowsChildren(false);
    }

    public BondedTerm(String i) {
        this();
        this.id = i;
    }

    public boolean applyLambda() {
        for (Atom atom : this.atoms) {
            if (!atom.applyLambda()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(BondedTerm t) {
        return Objects.compare(this, t, bondedComparator);
    }

    public boolean containsHydrogen() {
        for (Atom atom : this.atoms) {
            if (!atom.isHydrogen()) continue;
            return true;
        }
        return false;
    }

    public boolean isNeuralNetwork() {
        for (Atom atom : this.atoms) {
            if (!atom.isNeuralNetwork()) continue;
            return true;
        }
        return false;
    }

    public static <T extends BondedTerm> void removeNeuralNetworkTerms(List<T> list) {
        ArrayList<BondedTerm> removeList = new ArrayList<BondedTerm>();
        for (BondedTerm term : list) {
            if (!term.isNeuralNetwork()) continue;
            removeList.add(term);
        }
        list.removeAll(removeList);
    }

    public boolean containsResolution(Atom.Resolution resolution) {
        for (Atom atom : this.atoms) {
            if (atom.getResolution() != resolution) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean destroy() {
        super.destroy();
        this.id = null;
        this.value = 0.0;
        return true;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BondedTerm other = (BondedTerm)object;
        return this.getID().equals(other.getID());
    }

    public Atom getAtom(int index) {
        if (index >= 0 && index < this.atoms.length) {
            return this.atoms[index];
        }
        return null;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom[] getAtomArray() {
        return this.getAtomArray(true);
    }

    public Atom[] getAtomArray(boolean returnCopy) {
        if (returnCopy) {
            int nAtoms = this.atoms.length;
            Atom[] retAtoms = new Atom[nAtoms];
            System.arraycopy(this.atoms, 0, retAtoms, 0, nAtoms);
            return retAtoms;
        }
        return this.atoms;
    }

    public Bond getBond(int index) {
        if (index >= 0 && index < this.atoms.length) {
            return this.bonds[index];
        }
        return null;
    }

    public String getID() {
        return this.id;
    }

    public boolean getUse() {
        for (Atom atom : this.atoms) {
            if (!atom.getUse()) continue;
            return true;
        }
        return false;
    }

    public void setID(String i) {
        this.id = i;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double v) {
        this.value = v;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getID());
    }

    public boolean isConstrained() {
        return this.isConstrained;
    }

    public boolean isLambdaScaled() {
        return false;
    }

    @Override
    public void print() {
        logger.info(this.toString());
    }

    public void setAtoms(Atom[] a) {
        this.atoms = a;
    }

    public void setBonds(Bond[] b) {
        this.bonds = b;
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (this.atoms == null) {
            return;
        }
        for (Atom atom : this.atoms) {
            atom.setColor(newColorModel, color, mat);
        }
    }

    public void setConstraint(Constraint c) {
        this.isConstrained = c != null;
    }

    public final void setID_Key(boolean reverse) {
        if (this.atoms == null) {
            return;
        }
        idTemp.delete(0, idTemp.length());
        for (int i = 0; i < this.atoms.length; ++i) {
            Atom a;
            Atom atom = a = reverse ? this.atoms[this.atoms.length - 1 - i] : this.atoms[i];
            if (i != 0) {
                idTemp.append("  ");
            }
            idTemp.append(a.describe(Atom.Descriptions.XyzIndex_Name));
        }
        this.id = idTemp.toString().intern();
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        if (this.atoms == null) {
            return;
        }
        for (Atom atom : this.atoms) {
            atom.setSelected(b);
        }
        if (!(this instanceof Bond)) {
            if (this.bonds == null) {
                return;
            }
            for (MSNode mSNode : this.bonds) {
                ((BondedTerm)mSNode).setSelected(b);
            }
        }
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        if (this.atoms == null) {
            return;
        }
        for (Atom atom : this.atoms) {
            atom.setView(newViewModel, newShapes);
        }
        if (this.bonds == null) {
            return;
        }
        for (MSNode mSNode : this.bonds) {
            ((Bond)mSNode).setView(newViewModel, newShapes);
        }
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.2f,%7.2f)", this.id, this.value, this.energy);
    }

    boolean applyAllLambda() {
        for (Atom atom : this.atoms) {
            if (atom.applyLambda()) continue;
            return false;
        }
        return true;
    }

    boolean containsAtom(Atom atom) {
        for (Atom a : this.atoms) {
            if (!a.equals(atom)) continue;
            return true;
        }
        return false;
    }

    public static class BondedComparator
    implements Comparator<BondedTerm> {
        private static final List<Class<? extends BondedTerm>> naturalOrder = new ArrayList<Class<? extends BondedTerm>>(){
            {
                this.add(Bond.class);
                this.add(Angle.class);
                this.add(StretchBend.class);
                this.add(UreyBradley.class);
                this.add(OutOfPlaneBend.class);
                this.add(Torsion.class);
                this.add(ImproperTorsion.class);
                this.add(PiOrbitalTorsion.class);
                this.add(StretchTorsion.class);
                this.add(AngleTorsion.class);
                this.add(TorsionTorsion.class);
            }
        };

        private BondedComparator() {
        }

        @Override
        public int compare(BondedTerm bondedTerm1, BondedTerm bondedTerm2) {
            Class<?> class1 = bondedTerm2.getClass();
            Class<?> class2 = bondedTerm1.getClass();
            int order1 = naturalOrder.indexOf(bondedTerm1.getClass());
            int order2 = naturalOrder.indexOf(bondedTerm2.getClass());
            if (order1 >= 0 && order2 >= 0) {
                return Integer.compare(order1, order2);
            }
            return String.CASE_INSENSITIVE_ORDER.compare(class2.toString(), class1.toString());
        }
    }
}

