/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.RendererCache;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Vector3d;

public class Bond
extends BondedTerm {
    private static final long serialVersionUID = 1L;
    static final float BUFF = 0.7f;
    private static final Logger logger = Logger.getLogger(Bond.class.getName());
    private static final float[] a0col = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] f4a = new float[]{0.0f, 0.0f, 0.0f, 0.9f};
    private static final float[] f4b = new float[]{0.0f, 0.0f, 0.0f, 0.9f};
    private static final float[] f16 = new float[]{0.0f, 0.0f, 0.0f, 0.9f, 0.0f, 0.0f, 0.0f, 0.9f, 0.0f, 0.0f, 0.0f, 0.9f, 0.0f, 0.0f, 0.0f, 0.9f};
    private static final double[] a13d = new double[3];
    private static final double[] a23d = new double[3];
    private static final double[] mid = new double[3];
    private static final double[] diff3d = new double[3];
    private static final double[] sum3d = new double[3];
    private static final double[] coord = new double[12];
    private static final double[] y = new double[]{0.0, 1.0, 0.0};
    private static final AxisAngle4d axisAngle = new AxisAngle4d();
    private static final double[] bcross = new double[4];
    private static final double[] cstart = new double[3];
    private static final Vector3d pos3d = new Vector3d();
    private final ArrayList<Bond> formsAngleWith = new ArrayList();
    public BondType bondType = null;
    private double rigidScale = 1.0;
    private RendererCache.ViewModel viewModel = RendererCache.ViewModel.INVISIBLE;
    private BranchGroup branchGroup;
    private TransformGroup cy1tg;
    private TransformGroup cy2tg;
    private Transform3D cy1t3d;
    private Transform3D cy2t3d;
    private Shape3D cy1;
    private Shape3D cy2;
    private Vector3d scale;
    private int detail = 3;
    private LineArray la;
    private int lineIndex;
    private boolean wireVisible = true;

    public Bond(String n) {
        super(n);
    }

    public Bond(Atom a1, Atom a2) {
        this.atoms = new Atom[2];
        int i1 = a1.getIndex();
        int i2 = a2.getIndex();
        if (i1 < i2) {
            this.atoms[0] = a1;
            this.atoms[1] = a2;
        } else {
            this.atoms[0] = a2;
            this.atoms[1] = a1;
        }
        this.setID_Key(false);
        this.viewModel = RendererCache.ViewModel.WIREFRAME;
        a1.setBond(this);
        a2.setBond(this);
    }

    public static void logNoBondType(Atom a1, Atom a2, ForceField forceField) {
        AtomType atomType1 = a1.getAtomType();
        AtomType atomType2 = a2.getAtomType();
        int[] c = new int[]{atomType1.atomClass, atomType2.atomClass};
        String key = BondType.sortKey(c);
        StringBuilder sb = new StringBuilder(String.format(" No BondType for key: %s\n %s -> %s\n %s -> %s", key, a1, atomType1, a2, atomType2));
        int c1 = atomType1.atomClass;
        int c2 = atomType2.atomClass;
        List<AtomType> types1 = forceField.getSimilarAtomTypes(atomType1);
        List<AtomType> types2 = forceField.getSimilarAtomTypes(atomType2);
        ArrayList<BondType> bondTypes = new ArrayList<BondType>();
        boolean match = false;
        for (AtomType type1 : types1) {
            for (AtomType type2 : types2) {
                BondType bondType;
                if (type1.atomClass != c1 && type1.atomClass != c2 && type2.atomClass != c1 && type2.atomClass != c2 || (bondType = forceField.getBondType(type1, type2)) == null || bondTypes.contains(bondType)) continue;
                if (!match) {
                    match = true;
                    sb.append("\n Similar Bond Types:");
                }
                bondTypes.add(bondType);
                sb.append(String.format("\n  %s", bondType));
            }
        }
        logger.severe(sb.toString());
    }

    @Override
    public int compareTo(BondedTerm b) {
        int a0;
        if (b == null) {
            throw new NullPointerException();
        }
        if (b == this) {
            return 0;
        }
        if (!b.getClass().isInstance(this)) {
            return super.compareTo(b);
        }
        int this0 = this.atoms[0].getIndex();
        if (this0 < (a0 = b.atoms[0].getIndex())) {
            return -1;
        }
        if (this0 > a0) {
            return 1;
        }
        int this1 = this.atoms[1].getIndex();
        int a1 = b.atoms[1].getIndex();
        return Integer.compare(this1, a1);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.value = 0.0;
        this.energy = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vab = va.sub(vb);
        this.value = vab.length();
        double prefactor = this.bondType.bondUnit * this.rigidScale * this.bondType.forceConstant;
        double dv = this.value - this.bondType.distance;
        if (this.bondType.bondFunction.hasFlatBottom()) {
            if (dv > 0.0) {
                dv = FastMath.max((double)0.0, (double)(dv - this.bondType.flatBottomRadius));
            } else if (dv < 0.0) {
                dv = FastMath.min((double)0.0, (double)(dv + this.bondType.flatBottomRadius));
            }
        }
        double dv2 = dv * dv;
        this.energy = prefactor * dv2 * (1.0 + this.bondType.cubic * dv + this.bondType.quartic * dv2);
        if (gradient) {
            double dedr = 2.0 * prefactor * dv * (1.0 + 1.5 * this.bondType.cubic * dv + 2.0 * this.bondType.quartic * dv2);
            double de = 0.0;
            if (this.value > 0.0) {
                de = dedr / this.value;
            }
            Double3 ga = vab.scale(de);
            int ia = atomA.getIndex() - 1;
            int ib = atomB.getIndex() - 1;
            grad.add(threadID, ia, ga);
            grad.sub(threadID, ib, ga);
        }
        this.value = dv;
        return this.energy;
    }

    public Atom get1_2(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[1];
        }
        if (a == this.atoms[1]) {
            return this.atoms[0];
        }
        return null;
    }

    public double getCurrentDistance() {
        double[] x1 = new double[3];
        x1 = this.atoms[0].getXYZ(x1);
        double[] x2 = new double[3];
        x2 = this.atoms[1].getXYZ(x2);
        return DoubleMath.dist((double[])x1, (double[])x2);
    }

    public void log() {
        logger.info(String.format(" %-8s %6d-%s %6d-%s %6.4f  %6.4f  %10.4f", "Bond", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.bondType.distance, this.value, this.energy));
    }

    @Override
    public void removeFromParent() {
        super.removeFromParent();
        this.cy1 = null;
        this.cy2 = null;
        this.cy1tg = null;
        this.cy2tg = null;
        if (this.cy1t3d != null) {
            RendererCache.poolTransform3D(this.cy1t3d);
            RendererCache.poolTransform3D(this.cy2t3d);
            this.cy1t3d = null;
            this.cy2t3d = null;
        }
        if (this.branchGroup != null) {
            this.branchGroup.detach();
            this.branchGroup.setUserData(null);
            RendererCache.poolDoubleCylinder(this.branchGroup);
            this.branchGroup = null;
        }
    }

    public void setBondType(BondType bondType) {
        this.bondType = bondType;
    }

    public BondType getBondType() {
        return this.bondType;
    }

    public void setColor(Atom a) {
        if (this.viewModel != RendererCache.ViewModel.INVISIBLE && this.viewModel != RendererCache.ViewModel.WIREFRAME && this.branchGroup != null) {
            if (a == this.atoms[0]) {
                this.cy1.setAppearance(a.getAtomAppearance());
            } else if (a == this.atoms[1]) {
                this.cy2.setAppearance(a.getAtomAppearance());
            }
        }
        this.setWireVisible(this.wireVisible);
    }

    public void setRigidScale(double rigidScale) {
        this.rigidScale = rigidScale;
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        switch (newViewModel) {
            case WIREFRAME: {
                this.viewModel = RendererCache.ViewModel.WIREFRAME;
                this.setWireVisible(true);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case SPACEFILL: 
            case INVISIBLE: 
            case RMIN: {
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setWireVisible(false);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case RESTRICT: {
                if (this.atoms[0].isSelected() && this.atoms[1].isSelected()) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setWireVisible(false);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case BALLANDSTICK: 
            case TUBE: {
                this.viewModel = newViewModel;
                double len = this.getValue() / 2.0;
                double rad = this.viewModel == RendererCache.ViewModel.BALLANDSTICK ? 0.1 * RendererCache.radius : 0.2 * RendererCache.radius;
                if (this.scale == null) {
                    this.scale = new Vector3d();
                }
                this.scale.set(rad, len, rad);
                this.setWireVisible(false);
                this.setCylinderVisible(true, newShapes);
                break;
            }
            case DETAIL: {
                double newRadius;
                int res = RendererCache.detail;
                if (res != this.detail) {
                    this.detail = res;
                    if (this.branchGroup != null) {
                        Geometry geom1 = RendererCache.getCylinderGeom(0, this.detail);
                        Geometry geom2 = RendererCache.getCylinderGeom(1, this.detail);
                        Geometry geom3 = RendererCache.getCylinderGeom(2, this.detail);
                        this.cy1.removeAllGeometries();
                        this.cy2.removeAllGeometries();
                        this.cy1.addGeometry(geom1);
                        this.cy1.addGeometry(geom2);
                        this.cy1.addGeometry(geom3);
                        this.cy2.addGeometry(geom1);
                        this.cy2.addGeometry(geom2);
                        this.cy2.addGeometry(geom3);
                    }
                }
                if (this.scale == null) {
                    this.scale = new Vector3d();
                }
                if (this.viewModel == RendererCache.ViewModel.BALLANDSTICK) {
                    newRadius = 0.1 * RendererCache.radius;
                } else {
                    if (this.viewModel != RendererCache.ViewModel.TUBE) break;
                    newRadius = 0.2 * RendererCache.radius;
                }
                if (newRadius == this.scale.x) break;
                this.scale.x = newRadius;
                this.scale.y = newRadius;
                if (this.branchGroup == null) break;
                this.setView(this.viewModel, newShapes);
                break;
            }
            case SHOWHYDROGEN: {
                if (this.atoms[0].getAtomicNumber() != 1 && this.atoms[1].getAtomicNumber() != 1) break;
                this.setView(this.viewModel, newShapes);
                break;
            }
            case HIDEHYDROGEN: {
                if (this.atoms[0].getAtomicNumber() != 1 && this.atoms[1].getAtomicNumber() != 1) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setWireVisible(false);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case FILL: 
            case POINTS: 
            case LINES: {
                if (this.branchGroup == null || this.viewModel == RendererCache.ViewModel.INVISIBLE) break;
                this.cy1.setAppearance(this.atoms[0].getAtomAppearance());
                this.cy2.setAppearance(this.atoms[1].getAtomAppearance());
            }
        }
    }

    public void setWire(LineArray l, int i) {
        this.la = l;
        this.lineIndex = i;
    }

    @Override
    public void update() {
        this.atoms[0].getXYZ(a13d);
        this.atoms[1].getXYZ(a23d);
        DoubleMath.sub((double[])a13d, (double[])a23d, (double[])diff3d);
        double d = DoubleMath.length((double[])diff3d);
        this.setValue(d);
        DoubleMath.add((double[])a13d, (double[])a23d, (double[])sum3d);
        DoubleMath.scale((double[])sum3d, (double)0.5, (double[])mid);
        if (this.la != null) {
            for (int i = 0; i < 3; ++i) {
                Bond.coord[i] = a13d[i];
                Bond.coord[3 + i] = mid[i];
                Bond.coord[6 + i] = mid[i];
                Bond.coord[9 + i] = a23d[i];
            }
            this.la.setCoordinates(this.lineIndex, coord);
        }
        if (this.branchGroup != null) {
            DoubleMath.normalize((double[])diff3d, (double[])diff3d);
            this.scale.y = d / 2.0;
            this.setBondTransform3d(this.cy1t3d, mid, diff3d, d, true);
            DoubleMath.scale((double[])diff3d, (double)-1.0, (double[])diff3d);
            this.setBondTransform3d(this.cy2t3d, mid, diff3d, d, false);
            this.cy1tg.setTransform(this.cy1t3d);
            this.cy2tg.setTransform(this.cy2t3d);
        }
    }

    boolean formsAngleWith(Bond b) {
        for (Bond bond : this.formsAngleWith) {
            if (b != bond) continue;
            return true;
        }
        return false;
    }

    Atom getCommonAtom(Bond b) {
        if (b == this || b == null) {
            return null;
        }
        if (b.atoms[0] == this.atoms[0]) {
            return this.atoms[0];
        }
        if (b.atoms[0] == this.atoms[1]) {
            return this.atoms[1];
        }
        if (b.atoms[1] == this.atoms[0]) {
            return this.atoms[0];
        }
        if (b.atoms[1] == this.atoms[1]) {
            return this.atoms[1];
        }
        return null;
    }

    Atom getOtherAtom(Bond b) {
        if (b == this || b == null) {
            return null;
        }
        if (b.atoms[0] == this.atoms[0]) {
            return this.atoms[1];
        }
        if (b.atoms[0] == this.atoms[1]) {
            return this.atoms[0];
        }
        if (b.atoms[1] == this.atoms[0]) {
            return this.atoms[1];
        }
        if (b.atoms[1] == this.atoms[1]) {
            return this.atoms[0];
        }
        return null;
    }

    boolean sameGroup() {
        return this.atoms[0].getParent() == this.atoms[1].getParent();
    }

    void setAngleWith(Bond b) {
        this.formsAngleWith.add(b);
    }

    private void initJ3D(List<BranchGroup> newShapes) {
        this.detail = RendererCache.detail;
        this.branchGroup = RendererCache.doubleCylinderFactory(this.atoms[0], this.atoms[1], this.detail);
        this.cy1tg = (TransformGroup)this.branchGroup.getChild(0);
        this.cy2tg = (TransformGroup)this.branchGroup.getChild(1);
        this.cy1 = (Shape3D)this.cy1tg.getChild(0);
        this.cy2 = (Shape3D)this.cy2tg.getChild(0);
        newShapes.add(this.branchGroup);
        this.cy1t3d = RendererCache.transform3DFactory();
        this.cy2t3d = RendererCache.transform3DFactory();
        this.update();
    }

    private void setBondTransform3d(Transform3D t3d, double[] pos, double[] orient, double len, boolean newRot) {
        if (newRot) {
            double angle = DoubleMath.angle((double[])orient, (double[])y);
            DoubleMath.X((double[])y, (double[])orient, (double[])bcross);
            Bond.bcross[3] = angle - Math.PI;
            axisAngle.set(bcross);
        }
        DoubleMath.scale((double[])orient, (double)(len / 4.0), (double[])cstart);
        DoubleMath.add((double[])cstart, (double[])pos, (double[])cstart);
        pos3d.set(cstart);
        t3d.setTranslation(pos3d);
        t3d.setRotation(axisAngle);
        t3d.setScale(this.scale);
    }

    private void setCylinderVisible(boolean visible, List<BranchGroup> newShapes) {
        if (!visible) {
            if (this.branchGroup != null) {
                this.cy1.setPickable(false);
                this.cy1.setAppearance(RendererCache.nullAp);
                this.cy2.setPickable(false);
                this.cy2.setAppearance(RendererCache.nullAp);
            }
        } else if (this.branchGroup == null) {
            this.initJ3D(newShapes);
        } else {
            this.cy1t3d.setScale(this.scale);
            this.cy1tg.setTransform(this.cy1t3d);
            this.cy2t3d.setScale(this.scale);
            this.cy2tg.setTransform(this.cy2t3d);
            this.cy1.setAppearance(this.atoms[0].getAtomAppearance());
            this.cy2.setAppearance(this.atoms[1].getAtomAppearance());
        }
    }

    private void setWireVisible(boolean visible) {
        if (!visible) {
            this.wireVisible = false;
            this.la.setColors(this.lineIndex, a0col);
        } else {
            this.wireVisible = true;
            float[] cols = f16;
            float[] col1 = f4a;
            float[] col2 = f4b;
            this.atoms[0].getAtomColor().get(col1);
            this.atoms[1].getAtomColor().get(col2);
            for (int i = 0; i < 3; ++i) {
                cols[i] = col1[i];
                cols[4 + i] = col1[i];
                cols[8 + i] = col2[i];
                cols[12 + i] = col2[i];
            }
            this.la.setColors(this.lineIndex, cols);
        }
    }
}

