/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.math.Double3;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.Residue;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class AminoAcidUtils {
    private static final Logger logger = Logger.getLogger(AminoAcidUtils.class.getName());
    public static final int[] AAPATTERN = new int[]{7, 6, 6};
    static final HashMap<AminoAcid3, AminoAcid1> AA3toAA1 = new HashMap();
    public static final HashMap<AminoAcid1, AminoAcid3> AA1toAA3 = new HashMap();
    public static final List<AminoAcid1> aminoAcid1List = Arrays.asList(AminoAcid1.values());
    public static final List<AminoAcid3> aminoAcidList = Arrays.asList(AminoAcid3.values());
    public static final HashMap<String, String> sidechainStoichiometry = new HashMap();
    public static final int[][] AA_N;
    public static final int[][] AA_CA;
    public static final int[][] AA_C;
    public static final int[][] AA_HN;
    public static final int[][] AA_O;
    public static final int[][] AA_HA;
    public static final int[] AA_CB;

    public static String[] getNames(Class<? extends Enum<?>> e) {
        return (String[])Arrays.stream(e.getEnumConstants()).map(Enum::name).toArray(String[]::new);
    }

    private AminoAcidUtils() {
    }

    public static void assignAminoAcidAtomTypes(List<Residue> residues, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        int numberOfResidues = residues.size();
        for (int residueNumber = 0; residueNumber < numberOfResidues; ++residueNumber) {
            Residue residue = residues.get(residueNumber);
            Residue previousResidue = null;
            Residue nextResidue = null;
            if (residueNumber > 0) {
                previousResidue = residues.get(residueNumber - 1);
            }
            if (residueNumber < numberOfResidues - 1) {
                nextResidue = residues.get(residueNumber + 1);
            }
            AminoAcidUtils.assignAminoAcidAtomTypes(residue, previousResidue, nextResidue, forceField, bondList);
        }
    }

    public static void assignAminoAcidAtomTypes(Residue residue, Residue previousResidue, Residue nextResidue, ForceField forceField, List<Bond> bondList) throws BondedUtils.MissingHeavyAtomException, BondedUtils.MissingAtomTypeException {
        String residueName = residue.getName().toUpperCase();
        ResiduePosition position = ResiduePosition.MIDDLE_RESIDUE;
        if (previousResidue == null && nextResidue == null) {
            position = ResiduePosition.SINGLE_RESIDUE;
        } else if (previousResidue == null) {
            position = ResiduePosition.FIRST_RESIDUE;
        } else if (nextResidue == null) {
            position = ResiduePosition.LAST_RESIDUE;
            Atom N = (Atom)residue.getAtomNode("N");
            if (residue.getAtomNodeList().size() == 1 && N != null) {
                residueName = "NH2";
                residue.setName(residueName);
            }
        }
        AminoAcid3 aminoAcid = AminoAcidUtils.getAminoAcid(residueName);
        int aminoAcidNumber = AminoAcidUtils.getAminoAcidNumber(residueName);
        boolean nonStandard = false;
        if (aminoAcid == AminoAcid3.UNK) {
            aminoAcidNumber = AminoAcidUtils.getAminoAcidNumber("ALA");
            nonStandard = true;
        }
        if (nextResidue != null) {
            AminoAcidUtils.removeOXT_OT2(residue);
        }
        if (previousResidue != null) {
            AminoAcidUtils.removeH1_H2_H3(aminoAcid, residue);
        }
        if (!nonStandard) {
            try {
                AminoAcidUtils.checkForMissingHeavyAtoms(aminoAcid, residue);
            }
            catch (BondedUtils.MissingHeavyAtomException e) {
                logger.log(Level.INFO, " {0} could not be parsed.", residue.toString());
                throw e;
            }
        }
        Atom pC = null;
        Atom pCA = null;
        if (previousResidue != null) {
            pC = (Atom)previousResidue.getAtomNode("C");
            pCA = (Atom)previousResidue.getAtomNode("CA");
        }
        boolean neutralNTerminus = false;
        Atom N = (Atom)residue.getAtomNode("N");
        if (N != null) {
            N.setAtomType(BondedUtils.findAtomType(AA_N[position.ordinal()][aminoAcidNumber], forceField));
            if (position != ResiduePosition.FIRST_RESIDUE && position != ResiduePosition.SINGLE_RESIDUE) {
                BondedUtils.buildBond(pC, N, forceField, bondList);
            } else {
                neutralNTerminus = forceField.getBoolean("neutral-nterminus", false);
                if (neutralNTerminus) {
                    N.setAtomType(BondedUtils.findAtomType(762, forceField));
                }
            }
        }
        Atom CA = null;
        Atom C = null;
        Atom O = null;
        if (position != ResiduePosition.LAST_RESIDUE || aminoAcid != AminoAcid3.NH2) {
            CA = aminoAcid == AminoAcid3.ACE || aminoAcid == AminoAcid3.NME ? BondedUtils.buildHeavy(residue, "CH3", N, AA_CA[position.ordinal()][aminoAcidNumber], forceField, bondList) : BondedUtils.buildHeavy(residue, "CA", N, AA_CA[position.ordinal()][aminoAcidNumber], forceField, bondList);
            if (position != ResiduePosition.LAST_RESIDUE || aminoAcid != AminoAcid3.NME) {
                C = BondedUtils.buildHeavy(residue, "C", CA, AA_C[position.ordinal()][aminoAcidNumber], forceField, bondList);
                O = (Atom)residue.getAtomNode("O");
                if (O == null) {
                    O = (Atom)residue.getAtomNode("OT1");
                }
                if (O == null) {
                    double psi = 135.0;
                    if (nextResidue != null && N != null) {
                        Atom nextN = (Atom)nextResidue.getAtomNode("N");
                        psi = FastMath.toDegrees((double)DoubleMath.dihedralAngle((double[])N.getXYZ(null), (double[])CA.getXYZ(null), (double[])C.getXYZ(null), (double[])nextN.getXYZ(null)));
                    }
                    O = BondedUtils.buildHeavy(residue, "O", C, 1.25, CA, 117.0, N, psi - 180.0, 0, AA_O[position.ordinal()][aminoAcidNumber], forceField, bondList);
                } else {
                    AtomType atomType = BondedUtils.findAtomType(AA_O[position.ordinal()][aminoAcidNumber], forceField);
                    O.setAtomType(atomType);
                    BondedUtils.buildBond(C, O, forceField, bondList);
                }
            }
        }
        AtomType atomType = BondedUtils.findAtomType(AA_HN[position.ordinal()][aminoAcidNumber], forceField);
        block1 : switch (position.ordinal()) {
            case 0: 
            case 3: {
                switch (aminoAcid.ordinal()) {
                    case 10: {
                        List<Atom> resAtoms = residue.getAtomList();
                        Optional<Atom> H1 = resAtoms.stream().filter(a -> a.getName().equals("H1")).findAny();
                        Optional<Atom> H2 = resAtoms.stream().filter(a -> a.getName().equals("H2")).findAny();
                        Optional<Atom> H3 = resAtoms.stream().filter(a -> a.getName().equals("H3")).findAny();
                        if (H1.isPresent() && H2.isPresent() && H3.isPresent()) {
                            residue.deleteAtom(H1.get());
                        } else if (H1.isPresent()) {
                            if (H2.isPresent()) {
                                H1.get().setName("H3");
                            } else {
                                H1.get().setName("H2");
                            }
                        }
                        BondedUtils.buildHydrogenAtom(residue, "H2", N, 1.02, CA, 109.5, C, 0.0, 0, atomType, forceField, bondList);
                        BondedUtils.buildHydrogenAtom(residue, "H3", N, 1.02, CA, 109.5, C, -120.0, 0, atomType, forceField, bondList);
                        break block1;
                    }
                    case 32: {
                        BondedUtils.buildHydrogenAtom(residue, "H", N, 1.02, CA, 109.5, C, -60.0, 0, atomType, forceField, bondList);
                        break block1;
                    }
                    case 35: {
                        break block1;
                    }
                }
                if (neutralNTerminus) {
                    atomType = BondedUtils.findAtomType(763, forceField);
                    Atom h1 = (Atom)residue.getAtomNode("H1");
                    Atom h2 = (Atom)residue.getAtomNode("H2");
                    Atom h3 = (Atom)residue.getAtomNode("H3");
                    if (h3 == null) {
                        h3 = (Atom)residue.getAtomNode("H");
                    }
                    if (h1 != null && h2 != null && h3 != null) {
                        residue.deleteAtom(h3);
                    } else if (h3 != null) {
                        if (h1 == null) {
                            h3.setName("H1");
                        } else {
                            h3.setName("H2");
                        }
                    }
                    BondedUtils.buildHydrogenAtom(residue, "H1", N, 1.02, CA, 109.5, C, 180.0, 0, atomType, forceField, bondList);
                    BondedUtils.buildHydrogenAtom(residue, "H2", N, 1.02, CA, 109.5, C, 60.0, 0, atomType, forceField, bondList);
                    break;
                }
                BondedUtils.buildHydrogenAtom(residue, "H1", N, 1.02, CA, 109.5, C, 180.0, 0, atomType, forceField, bondList);
                BondedUtils.buildHydrogenAtom(residue, "H2", N, 1.02, CA, 109.5, C, 60.0, 0, atomType, forceField, bondList);
                BondedUtils.buildHydrogenAtom(residue, "H3", N, 1.02, CA, 109.5, C, -60.0, 0, atomType, forceField, bondList);
                break;
            }
            case 2: {
                switch (aminoAcid.ordinal()) {
                    case 37: {
                        BondedUtils.buildHydrogenAtom(residue, "H1", N, 1.02, pC, 119.0, pCA, 0.0, 0, atomType, forceField, bondList);
                        BondedUtils.buildHydrogenAtom(residue, "H2", N, 1.02, pC, 119.0, pCA, 180.0, 0, atomType, forceField, bondList);
                        break block1;
                    }
                    case 38: {
                        BondedUtils.buildHydrogenAtom(residue, "H", N, 1.02, pC, 118.0, CA, 121.0, 1, atomType, forceField, bondList);
                        break block1;
                    }
                }
                BondedUtils.buildHydrogenAtom(residue, "H", N, 1.02, pC, 119.0, CA, 119.0, 1, atomType, forceField, bondList);
                break;
            }
            default: {
                BondedUtils.buildHydrogenAtom(residue, "H", N, 1.02, pC, 119.0, CA, 119.0, 1, atomType, forceField, bondList);
            }
        }
        String haName = "HA";
        if (aminoAcid == AminoAcid3.GLY) {
            haName = "HA2";
        }
        atomType = BondedUtils.findAtomType(AA_HA[position.ordinal()][aminoAcidNumber], forceField);
        block14 : switch (position.ordinal()) {
            case 0: {
                switch (aminoAcid.ordinal()) {
                    case 34: {
                        BondedUtils.buildHydrogenAtom(residue, "H", C, 1.12, O, 0.0, null, 0.0, 0, atomType, forceField, bondList);
                        break block14;
                    }
                    case 35: {
                        BondedUtils.buildHydrogenAtom(residue, "H1", CA, 1.1, C, 109.5, O, 180.0, 0, atomType, forceField, bondList);
                        BondedUtils.buildHydrogenAtom(residue, "H2", CA, 1.1, C, 109.5, O, 60.0, 0, atomType, forceField, bondList);
                        BondedUtils.buildHydrogenAtom(residue, "H3", CA, 1.1, C, 109.5, O, -60.0, 0, atomType, forceField, bondList);
                        break block14;
                    }
                }
                BondedUtils.buildHydrogenAtom(residue, haName, CA, 1.1, N, 109.5, C, 109.5, -1, atomType, forceField, bondList);
                break;
            }
            case 2: {
                if (aminoAcid == AminoAcid3.NME) {
                    BondedUtils.buildHydrogenAtom(residue, "H1", CA, 1.1, N, 109.5, pC, 180.0, 0, atomType, forceField, bondList);
                    BondedUtils.buildHydrogenAtom(residue, "H2", CA, 1.1, N, 109.5, pC, 60.0, 0, atomType, forceField, bondList);
                    BondedUtils.buildHydrogenAtom(residue, "H3", CA, 1.1, N, 109.5, pC, -60.0, 0, atomType, forceField, bondList);
                    break;
                }
                BondedUtils.buildHydrogenAtom(residue, haName, CA, 1.1, N, 109.5, C, 109.5, -1, atomType, forceField, bondList);
                break;
            }
            default: {
                BondedUtils.buildHydrogenAtom(residue, haName, CA, 1.1, N, 109.5, C, 109.0, -1, atomType, forceField, bondList);
            }
        }
        AminoAcidUtils.assignAminoAcidSideChain(position, aminoAcid, residue, CA, N, C, forceField, bondList);
        if ((position == ResiduePosition.LAST_RESIDUE || position == ResiduePosition.SINGLE_RESIDUE) && aminoAcid != AminoAcid3.NH2 && aminoAcid != AminoAcid3.NME) {
            atomType = BondedUtils.findAtomType(AA_O[2][aminoAcidNumber], forceField);
            Atom OXT = (Atom)residue.getAtomNode("OXT");
            if (OXT == null && (OXT = (Atom)residue.getAtomNode("OT2")) != null) {
                OXT.setName("OXT");
            }
            boolean neutralCTerminus = false;
            if (OXT == null) {
                List<Atom> oxygen = BondedUtils.findBondedAtoms(C, 8);
                for (Atom atom : oxygen) {
                    String name = atom.getName();
                    if (!name.equalsIgnoreCase("OH")) continue;
                    neutralCTerminus = true;
                }
            }
            if (OXT == null) {
                String resName = C.getResidueName();
                int resSeq = C.getResidueNumber();
                Character chainID = C.getChainID();
                Character altLoc = C.getAltLoc();
                String segID = C.getSegID();
                double occupancy = C.getOccupancy();
                double tempFactor = C.getTempFactor();
                OXT = new Atom(0, "OXT", altLoc, new double[3], resName, resSeq, chainID, occupancy, tempFactor, segID);
                OXT.setAtomType(atomType);
                residue.addMSNode(OXT);
                BondedUtils.intxyz(OXT, C, 1.25, CA, 117.0, O, 126.0, 1);
            } else if (neutralCTerminus) {
                C.setAtomType(BondedUtils.findAtomType(771, forceField));
                O.setAtomType(BondedUtils.findAtomType(772, forceField));
                OXT.setAtomType(BondedUtils.findAtomType(773, forceField));
                Atom HO = (Atom)residue.getAtomNode("HO");
                atomType = BondedUtils.findAtomType(774, forceField);
                if (HO == null) {
                    BondedUtils.buildHydrogenAtom(residue, "HO", OXT, 1.02, C, 120.0, O, 180.0, 0, atomType, forceField, bondList);
                } else {
                    HO.setAtomType(BondedUtils.findAtomType(774, forceField));
                    BondedUtils.buildBond(OXT, HO, forceField, bondList);
                }
            } else {
                OXT.setAtomType(atomType);
            }
            BondedUtils.buildBond(C, OXT, forceField, bondList);
        }
        List<Atom> resAtoms = residue.getAtomList();
        for (Atom atom : resAtoms) {
            int numberOfBonds;
            atomType = atom.getAtomType();
            if (atomType == null) {
                String protonEq = atom.getName().replaceFirst("D", "H");
                Atom correspH = (Atom)residue.getAtomNode(protonEq);
                if (correspH == null || correspH.getAtomType() == null) {
                    BondedUtils.MissingAtomTypeException missingAtomTypeException = new BondedUtils.MissingAtomTypeException(residue, atom);
                    throw missingAtomTypeException;
                }
                correspH.setName(atom.getName());
                atom.removeFromParent();
                atom = correspH;
                atomType = atom.getAtomType();
            }
            if ((numberOfBonds = atom.getNumBonds()) == atomType.valence || atom == C && numberOfBonds == atomType.valence - 1 && position != ResiduePosition.LAST_RESIDUE) continue;
            logger.warning(String.format(" An atom for residue %s has the wrong number of bonds:\n %s", residueName, atom));
            logger.info(String.format(" Expected: %d Actual: %d.", atomType.valence, numberOfBonds));
            for (Bond bond : atom.getBonds()) {
                logger.info(" " + bond.toString());
            }
        }
    }

    public static Residue buildAIB(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB1 = BondedUtils.buildHeavy((MSGroup)res, AIB.CB1, CA, 1.54, N, 109.5, C, 107.8, -1, ff, bonds);
        Atom CB2 = BondedUtils.buildHeavy((MSGroup)res, AIB.CB2, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom HB11 = BondedUtils.buildH(res, AIB.HB11, CB1, 1.11, CA, 109.4, N, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, AIB.HB12, CB1, 1.11, CA, 109.4, HB11, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, AIB.HB13, CB1, 1.11, CA, 109.4, HB11, 109.4, -1, ff, bonds);
        Atom HB21 = BondedUtils.buildH(res, AIB.HB21, CB2, 1.11, CA, 109.4, N, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, AIB.HB22, CB2, 1.11, CA, 109.4, HB21, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, AIB.HB23, CB2, 1.11, CA, 109.4, HB21, 109.4, -1, ff, bonds);
        return res;
    }

    public static Residue buildGlycine(Residue res, Atom CA, Atom N, Atom C, ResiduePosition position, ForceField ff, List<Bond> bonds) {
        int iCB = AA_CB[AminoAcid3.GLY.ordinal()];
        int k = switch (position.ordinal()) {
            case 0 -> AA_HA[0][iCB];
            case 2 -> AA_HA[2][iCB];
            default -> AA_HA[1][iCB];
        };
        BondedUtils.buildH(res, "HA3", CA, 1.1, N, 109.5, C, 109.5, 1, k, ff, bonds);
        return res;
    }

    public static Residue buildAlanine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ALA.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom HB1 = BondedUtils.buildH(res, ALA.HB1, CB, 1.11, CA, 109.4, N, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ALA.HB2, CB, 1.11, CA, 109.4, HB1, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ALA.HB3, CB, 1.11, CA, 109.4, HB1, 109.4, -1, ff, bonds);
        return res;
    }

    public static Residue buildArginine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ARG.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, ARG.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, ARG.CD, CG, 1.54, CB, 109.5, CA, 180.0, 0, ff, bonds);
        Atom NE = BondedUtils.buildHeavy((MSGroup)res, ARG.NE, CD, 1.45, CG, 109.5, CB, 180.0, 0, ff, bonds);
        Atom CZ = BondedUtils.buildHeavy((MSGroup)res, ARG.CZ, NE, 1.35, CD, 120.0, CG, 180.0, 0, ff, bonds);
        Atom NH1 = BondedUtils.buildHeavy((MSGroup)res, ARG.NH1, CZ, 1.35, NE, 120.0, CD, 180.0, 0, ff, bonds);
        Atom NH2 = BondedUtils.buildHeavy((MSGroup)res, ARG.NH2, CZ, 1.35, NE, 120.0, NH1, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, ARG.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ARG.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, ARG.HG2, CG, 1.11, CB, 109.4, CD, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ARG.HG3, CG, 1.11, CB, 109.4, CD, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, ARG.HD2, CD, 1.11, CG, 109.4, NE, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ARG.HD3, CD, 1.11, CG, 109.4, NE, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, ARG.HE, NE, 1.02, CD, 120.0, CZ, 120.0, 1, ff, bonds);
        Atom HH11 = BondedUtils.buildH(res, ARG.HH11, NH1, 1.02, CZ, 120.0, NE, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ARG.HH12, NH1, 1.02, CZ, 120.0, HH11, 120.0, 1, ff, bonds);
        Atom HH21 = BondedUtils.buildH(res, ARG.HH21, NH2, 1.02, CZ, 120.0, NE, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ARG.HH22, NH2, 1.02, CZ, 120.0, HH21, 120.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildAsparagine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ASN.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, ASN.CG, CB, 1.51, CA, 107.8, N, 180.0, 0, ff, bonds);
        Atom OD1 = BondedUtils.buildHeavy((MSGroup)res, ASN.OD1, CG, 1.22, CB, 122.5, CA, 180.0, 0, ff, bonds);
        Atom ND2 = BondedUtils.buildHeavy((MSGroup)res, ASN.ND2, CG, 1.34, CB, 112.7, OD1, 124.0, 1, ff, bonds);
        BondedUtils.buildH(res, ASN.HB2, CB, 1.11, CA, 109.4, CG, 107.9, 1, ff, bonds);
        BondedUtils.buildH(res, ASN.HB3, CB, 1.11, CA, 109.4, CG, 107.9, -1, ff, bonds);
        Atom HD21 = BondedUtils.buildH(res, ASN.HD21, ND2, 1.02, CG, 119.0, CB, 0.0, 0, ff, bonds);
        BondedUtils.buildH(res, ASN.HD22, ND2, 1.02, CG, 119.0, HD21, 120.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildAspartate(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ASP.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, ASP.CG, CB, 1.51, CA, 107.8, N, 180.0, 0, ff, bonds);
        Atom OD1 = BondedUtils.buildHeavy((MSGroup)res, ASP.OD1, CG, 1.25, CB, 117.0, CA, 0.0, 0, ff, bonds);
        BondedUtils.buildHeavy((MSGroup)res, ASP.OD2, CG, 1.25, CB, 117.0, OD1, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, ASP.HB2, CB, 1.11, CA, 109.4, CG, 107.9, 1, ff, bonds);
        BondedUtils.buildH(res, ASP.HB3, CB, 1.11, CA, 109.4, CG, 107.9, -1, ff, bonds);
        return res;
    }

    public static Residue buildCysteine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, CYS.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom SG = BondedUtils.buildHeavy((MSGroup)res, CYS.SG, CB, 1.82, CA, 109.0, N, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, CYS.HB2, CB, 1.11, CA, 109.4, SG, 112.0, 1, ff, bonds);
        BondedUtils.buildH(res, CYS.HB3, CB, 1.11, CA, 109.4, SG, 112.0, -1, ff, bonds);
        BondedUtils.buildH(res, CYS.HG, SG, 1.34, CB, 96.0, CA, 180.0, 0, ff, bonds);
        return res;
    }

    public static Residue buildCystine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, CYX.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom SG = BondedUtils.buildHeavy((MSGroup)res, CYX.SG, CB, 1.82, CA, 109.0, N, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, CYX.HB2, CB, 1.11, CA, 109.4, SG, 112.0, 1, ff, bonds);
        BondedUtils.buildH(res, CYX.HB3, CB, 1.11, CA, 109.4, SG, 112.0, -1, ff, bonds);
        List<Atom> resAtoms = res.getAtomList();
        for (Atom atom : resAtoms) {
            atom.setResName("CYS");
        }
        res.setName("CYS");
        return res;
    }

    public static Residue buildDeprotonatedCysteine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, CYD.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom SG = BondedUtils.buildHeavy((MSGroup)res, CYD.SG, CB, 1.82, CA, 109.0, N, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, CYD.HB2, CB, 1.11, CA, 109.4, SG, 112.0, 1, ff, bonds);
        BondedUtils.buildH(res, CYD.HB3, CB, 1.11, CA, 109.4, SG, 112.0, -1, ff, bonds);
        return res;
    }

    public static Residue buildDeprotonatedLysine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, LYD.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, LYD.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, LYD.CD, CG, 1.54, CB, 109.5, CA, 180.0, 0, ff, bonds);
        Atom CE = BondedUtils.buildHeavy((MSGroup)res, LYD.CE, CD, 1.54, CG, 109.5, CB, 180.0, 0, ff, bonds);
        Atom NZ = BondedUtils.buildHeavy((MSGroup)res, LYD.NZ, CE, 1.5, CD, 109.5, CG, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, LYD.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LYD.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, LYD.HG2, CG, 1.11, CB, 109.4, CD, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LYD.HG3, CG, 1.11, CB, 109.4, CD, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, LYD.HD2, CD, 1.11, CG, 109.4, CE, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LYD.HD3, CD, 1.11, CG, 109.4, CE, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, LYD.HE2, CE, 1.11, CD, 109.4, NZ, 108.8, 1, ff, bonds);
        BondedUtils.buildH(res, LYD.HE3, CE, 1.11, CD, 109.4, NZ, 108.8, -1, ff, bonds);
        Atom HZ1 = BondedUtils.buildH(res, LYD.HZ1, NZ, 1.02, CE, 109.5, CD, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, LYD.HZ2, NZ, 1.02, CE, 109.5, HZ1, 109.5, 1, ff, bonds);
        return res;
    }

    public static Residue buildDeprotonatedTyrosine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, TYD.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, TYD.CG, CB, 1.5, CA, 109.5, N, 62.0, 0, ff, bonds);
        Atom CD1 = BondedUtils.buildHeavy((MSGroup)res, TYD.CD1, CG, 1.39, CB, 120.0, CA, 90.0, 0, ff, bonds);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, TYD.CD2, CG, 1.39, CB, 120.0, CD1, 120.0, 1, ff, bonds);
        Atom CE1 = BondedUtils.buildHeavy((MSGroup)res, TYD.CE1, CD1, 1.39, CG, 120.0, CB, 180.0, 0, ff, bonds);
        Atom CE2 = BondedUtils.buildHeavy((MSGroup)res, TYD.CE2, CD2, 1.39, CG, 120.0, CB, 180.0, 0, ff, bonds);
        Atom CZ = BondedUtils.buildHeavy((MSGroup)res, TYD.CZ, CE1, 1.39, CD1, 120.0, CG, 0.0, 0, ff, bonds);
        BondedUtils.buildBond(CE2, CZ, ff, bonds);
        BondedUtils.buildHeavy((MSGroup)res, TYD.OH, CZ, 1.36, CE2, 120.0, CE1, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYD.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, TYD.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, TYD.HD1, CD1, 1.1, CG, 120.0, CE1, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYD.HD2, CD2, 1.1, CG, 120.0, CE2, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYD.HE1, CE1, 1.1, CD1, 120.0, CZ, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYD.HE2, CE2, 1.1, CD2, 120.0, CZ, 120.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildGlutamate(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, GLU.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, GLU.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, GLU.CD, CG, 1.51, CB, 107.8, CA, 180.0, 0, ff, bonds);
        Atom OE1 = BondedUtils.buildHeavy((MSGroup)res, GLU.OE1, CD, 1.25, CG, 117.0, CB, 180.0, 0, ff, bonds);
        BondedUtils.buildHeavy((MSGroup)res, GLU.OE2, CD, 1.25, CG, 117.0, OE1, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, GLU.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, GLU.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, GLU.HG2, CG, 1.11, CB, 109.4, CD, 107.9, 1, ff, bonds);
        BondedUtils.buildH(res, GLU.HG3, CG, 1.11, CB, 109.4, CD, 107.9, -1, ff, bonds);
        return res;
    }

    public static Residue buildGlutamine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, GLN.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, GLN.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, GLN.CD, CG, 1.51, CB, 107.8, CA, 180.0, 0, ff, bonds);
        Atom OE1 = BondedUtils.buildHeavy((MSGroup)res, GLN.OE1, CD, 1.22, CG, 122.5, CB, 180.0, 0, ff, bonds);
        Atom NE2 = BondedUtils.buildHeavy((MSGroup)res, GLN.NE2, CD, 1.34, CG, 112.7, OE1, 124.0, 1, ff, bonds);
        BondedUtils.buildH(res, GLN.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, GLN.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, GLN.HG2, CG, 1.11, CB, 109.4, CD, 107.9, 1, ff, bonds);
        BondedUtils.buildH(res, GLN.HG3, CG, 1.11, CB, 109.4, CD, 107.9, -1, ff, bonds);
        Atom HE21 = BondedUtils.buildH(res, GLN.HE21, NE2, 1.02, CD, 119.0, CG, 0.0, 0, ff, bonds);
        BondedUtils.buildH(res, GLN.HE22, NE2, 1.02, CD, 119.0, HE21, 120.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildHistidine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, HIS.CB, CA, 1.54, N, 109.5, C, 109.5, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, HIS.CG, CB, 1.5, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom ND1 = BondedUtils.buildHeavy((MSGroup)res, HIS.ND1, CG, 1.35, CB, 126.0, CA, 180.0, 0, ff, bonds);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, HIS.CD2, CG, 1.35, CB, 126.0, ND1, 108.0, 1, ff, bonds);
        Atom CE1 = BondedUtils.buildHeavy((MSGroup)res, HIS.CE1, ND1, 1.35, CG, 108.0, CD2, 0.0, 0, ff, bonds);
        Atom NE2 = BondedUtils.buildHeavy((MSGroup)res, HIS.NE2, CD2, 1.35, CG, 108.0, ND1, 0.0, 0, ff, bonds);
        BondedUtils.buildBond(NE2, CE1, ff, bonds);
        BondedUtils.buildH(res, HIS.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, HIS.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, HIS.HD1, ND1, 1.02, CG, 126.0, CB, 0.0, 0, ff, bonds);
        BondedUtils.buildH(res, HIS.HD2, CD2, 1.1, CG, 126.0, NE2, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, HIS.HE1, CE1, 1.1, ND1, 126.0, NE2, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, HIS.HE2, NE2, 1.02, CD2, 126.0, CE1, 126.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildIsoleucine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ILE.CB, CA, 1.54, N, 109.5, C, 109.5, 1, ff, bonds);
        Atom CG1 = BondedUtils.buildHeavy((MSGroup)res, ILE.CG1, CB, 1.54, CA, 109.5, N, 0.0, 0, ff, bonds);
        Atom CG2 = BondedUtils.buildHeavy((MSGroup)res, ILE.CG2, CB, 1.54, CA, 109.5, CG1, 109.5, 1, ff, bonds);
        Atom CD1 = BondedUtils.buildHeavy((MSGroup)res, ILE.CD1, CG1, 1.54, CB, 109.5, CA, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ILE.HB, CB, 1.11, CA, 109.4, CG2, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ILE.HG12, CG1, 1.11, CB, 109.4, CD1, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ILE.HG13, CG1, 1.11, CB, 109.4, CD1, 109.4, -1, ff, bonds);
        Atom HG21 = BondedUtils.buildH(res, ILE.HG21, CG2, 1.11, CB, 110.0, CG1, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ILE.HG22, CG2, 1.11, CB, 110.0, HG21, 109.0, 1, ff, bonds);
        BondedUtils.buildH(res, ILE.HG23, CG2, 1.11, CB, 110.0, HG21, 109.0, -1, ff, bonds);
        Atom HD11 = BondedUtils.buildH(res, ILE.HD11, CD1, 1.11, CG1, 110.0, CB, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ILE.HD12, CD1, 1.11, CG1, 110.0, HD11, 109.0, 1, ff, bonds);
        BondedUtils.buildH(res, ILE.HD13, CD1, 1.11, CG1, 110.0, HD11, 109.0, -1, ff, bonds);
        return res;
    }

    public static Residue buildLeucine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, LEU.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, LEU.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD1 = BondedUtils.buildHeavy((MSGroup)res, LEU.CD1, CG, 1.54, CB, 109.5, CA, 180.0, 0, ff, bonds);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, LEU.CD2, CG, 1.54, CB, 109.5, CD1, 109.5, -1, ff, bonds);
        BondedUtils.buildH(res, LEU.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LEU.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, LEU.HG, CG, 1.11, CB, 109.4, CD1, 109.4, 1, ff, bonds);
        Atom HD11 = BondedUtils.buildH(res, LEU.HD11, CD1, 1.11, CG, 109.4, CB, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, LEU.HD12, CD1, 1.11, CG, 109.4, HD11, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LEU.HD13, CD1, 1.11, CG, 109.4, HD11, 109.4, -1, ff, bonds);
        Atom HD21 = BondedUtils.buildH(res, LEU.HD21, CD2, 1.11, CG, 109.4, CB, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, LEU.HD22, CD2, 1.11, CG, 109.4, HD21, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LEU.HD23, CD2, 1.11, CG, 109.4, HD21, 109.4, -1, ff, bonds);
        return res;
    }

    public static Residue buildLysine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, LYS.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, LYS.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, LYS.CD, CG, 1.54, CB, 109.5, CA, 180.0, 0, ff, bonds);
        Atom CE = BondedUtils.buildHeavy((MSGroup)res, LYS.CE, CD, 1.54, CG, 109.5, CB, 180.0, 0, ff, bonds);
        Atom NZ = BondedUtils.buildHeavy((MSGroup)res, LYS.NZ, CE, 1.5, CD, 109.5, CG, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, LYS.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LYS.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, LYS.HG2, CG, 1.11, CB, 109.4, CD, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LYS.HG3, CG, 1.11, CB, 109.4, CD, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, LYS.HD2, CD, 1.11, CG, 109.4, CE, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, LYS.HD3, CD, 1.11, CG, 109.4, CE, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, LYS.HE2, CE, 1.11, CD, 109.4, NZ, 108.8, 1, ff, bonds);
        BondedUtils.buildH(res, LYS.HE3, CE, 1.11, CD, 109.4, NZ, 108.8, -1, ff, bonds);
        Atom HZ1 = BondedUtils.buildH(res, LYS.HZ1, NZ, 1.02, CE, 109.5, CD, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, LYS.HZ2, NZ, 1.02, CE, 109.5, HZ1, 109.5, 1, ff, bonds);
        BondedUtils.buildH(res, LYS.HZ3, NZ, 1.02, CE, 109.5, HZ1, 109.5, -1, ff, bonds);
        return res;
    }

    public static Residue buildMethionine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bond) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, MET.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bond);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, MET.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bond);
        Atom SD = BondedUtils.buildHeavy((MSGroup)res, MET.SD, CG, 1.82, CB, 109.0, CA, 180.0, 0, ff, bond);
        Atom CE = BondedUtils.buildHeavy((MSGroup)res, MET.CE, SD, 1.82, CG, 96.3, CB, 180.0, 0, ff, bond);
        BondedUtils.buildH(res, MET.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bond);
        BondedUtils.buildH(res, MET.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bond);
        BondedUtils.buildH(res, MET.HG2, CG, 1.11, CB, 109.4, SD, 112.0, 1, ff, bond);
        BondedUtils.buildH(res, MET.HG3, CG, 1.11, CB, 109.4, SD, 112.0, -1, ff, bond);
        Atom HE1 = BondedUtils.buildH(res, MET.HE1, CE, 1.11, SD, 112.0, CG, 180.0, 0, ff, bond);
        BondedUtils.buildH(res, MET.HE2, CE, 1.11, SD, 112.0, HE1, 109.4, 1, ff, bond);
        BondedUtils.buildH(res, MET.HE3, CE, 1.11, SD, 112.0, HE1, 109.4, -1, ff, bond);
        return res;
    }

    public static Residue buildNeutralAsparticAcid(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ASH.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, ASH.CG, CB, 1.51, CA, 107.8, N, 180.0, 0, ff, bonds);
        Atom OD1 = BondedUtils.buildHeavy((MSGroup)res, ASH.OD1, CG, 1.25, CB, 117.0, CA, 0.0, 0, ff, bonds);
        Atom OD2 = BondedUtils.buildHeavy((MSGroup)res, ASH.OD2, CG, 1.25, CB, 117.0, OD1, 126.0, 1, ff, bonds);
        Atom HB2 = BondedUtils.buildH(res, ASH.HB2, CB, 1.11, CA, 109.4, CG, 107.9, 1, ff, bonds);
        Atom HB3 = BondedUtils.buildH(res, ASH.HB3, CB, 1.11, CA, 109.4, CG, 107.9, -1, ff, bonds);
        Atom HD2 = BondedUtils.buildH(res, ASH.HD2, OD2, 0.98, CG, 108.7, OD1, 0.0, 0, ff, bonds);
        return res;
    }

    public static Residue buildTwoProtonAsparticAcid(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ASD.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, ASD.CG, CB, 1.51, CA, 107.8, N, 180.0, 0, ff, bonds);
        Atom OD1 = BondedUtils.buildHeavy((MSGroup)res, ASD.OD1, CG, 1.25, CB, 117.0, CA, 0.0, 0, ff, bonds);
        Atom OD2 = BondedUtils.buildHeavy((MSGroup)res, ASD.OD2, CG, 1.25, CB, 117.0, OD1, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, ASD.HB2, CB, 1.11, CA, 109.4, CG, 107.9, 1, ff, bonds);
        BondedUtils.buildH(res, ASD.HB3, CB, 1.11, CA, 109.4, CG, 107.9, -1, ff, bonds);
        BondedUtils.buildH(res, ASD.HD1, OD1, 0.98, CG, 108.7, OD2, 0.0, 0, ff, bonds);
        BondedUtils.buildH(res, ASD.HD2, OD2, 0.98, CG, 108.7, OD1, 0.0, 0, ff, bonds);
        return res;
    }

    public static Residue buildNeutralGlutamicAcid(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, GLH.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, GLH.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, GLH.CD, CG, 1.51, CB, 107.8, CA, 180.0, 0, ff, bonds);
        Atom OE1 = BondedUtils.buildHeavy((MSGroup)res, GLH.OE1, CD, 1.25, CG, 117.0, CB, 180.0, 0, ff, bonds);
        Atom OE2 = BondedUtils.buildHeavy((MSGroup)res, GLH.OE2, CD, 1.25, CG, 117.0, OE1, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, GLH.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, GLH.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, GLH.HG2, CG, 1.11, CB, 109.4, CD, 107.9, 1, ff, bonds);
        BondedUtils.buildH(res, GLH.HG3, CG, 1.11, CB, 109.4, CD, 107.9, -1, ff, bonds);
        BondedUtils.buildH(res, GLH.HE2, OE2, 0.98, CD, 108.7, OE1, 0.0, 0, ff, bonds);
        return res;
    }

    public static Residue buildTwoProtonGlutamicAcid(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, GLD.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, GLD.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, GLD.CD, CG, 1.51, CB, 107.8, CA, 180.0, 0, ff, bonds);
        Atom OE1 = BondedUtils.buildHeavy((MSGroup)res, GLD.OE1, CD, 1.25, CG, 117.0, CB, 180.0, 0, ff, bonds);
        Atom OE2 = BondedUtils.buildHeavy((MSGroup)res, GLD.OE2, CD, 1.25, CG, 117.0, OE1, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, GLD.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, GLD.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, GLD.HG2, CG, 1.11, CB, 109.4, CD, 107.9, 1, ff, bonds);
        BondedUtils.buildH(res, GLD.HG3, CG, 1.11, CB, 109.4, CD, 107.9, -1, ff, bonds);
        BondedUtils.buildH(res, GLD.HE1, OE1, 0.98, CD, 108.7, OE2, 0.0, 0, ff, bonds);
        BondedUtils.buildH(res, GLD.HE2, OE2, 0.98, CD, 108.7, OE1, 0.0, 0, ff, bonds);
        return res;
    }

    public static Residue buildNeutralHistidineD(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, HID.CB, CA, 1.54, N, 109.5, C, 109.5, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, HID.CG, CB, 1.5, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom ND1 = BondedUtils.buildHeavy((MSGroup)res, HID.ND1, CG, 1.35, CB, 126.0, CA, 180.0, 0, ff, bonds);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, HID.CD2, CG, 1.35, CB, 126.0, ND1, 108.0, 1, ff, bonds);
        Atom CE1 = BondedUtils.buildHeavy((MSGroup)res, HID.CE1, ND1, 1.35, CG, 108.0, CD2, 0.0, 0, ff, bonds);
        Atom NE2 = BondedUtils.buildHeavy((MSGroup)res, HID.NE2, CD2, 1.35, CG, 108.0, ND1, 0.0, 0, ff, bonds);
        BondedUtils.buildBond(NE2, CE1, ff, bonds);
        BondedUtils.buildH(res, HID.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, HID.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, HID.HD1, ND1, 1.02, CG, 126.0, CB, 0.0, 0, ff, bonds);
        BondedUtils.buildH(res, HID.HD2, CD2, 1.1, CG, 126.0, NE2, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, HID.HE1, CE1, 1.1, ND1, 126.0, NE2, 126.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildNeutralHistidineE(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, HIE.CB, CA, 1.54, N, 109.5, C, 109.5, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, HIE.CG, CB, 1.5, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom ND1 = BondedUtils.buildHeavy((MSGroup)res, HIE.ND1, CG, 1.35, CB, 126.0, CA, 180.0, 0, ff, bonds);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, HIE.CD2, CG, 1.35, CB, 126.0, ND1, 108.0, 1, ff, bonds);
        Atom CE1 = BondedUtils.buildHeavy((MSGroup)res, HIE.CE1, ND1, 1.35, CG, 108.0, CD2, 0.0, 0, ff, bonds);
        Atom NE2 = BondedUtils.buildHeavy((MSGroup)res, HIE.NE2, CD2, 1.35, CG, 108.0, ND1, 0.0, 0, ff, bonds);
        BondedUtils.buildBond(NE2, CE1, ff, bonds);
        BondedUtils.buildH(res, HIE.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, HIE.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, HIE.HD2, CD2, 1.1, CG, 126.0, NE2, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, HIE.HE1, CE1, 1.1, ND1, 126.0, NE2, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, HIE.HE2, NE2, 1.02, CD2, 126.0, CE1, 126.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildOrnithine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, ORN.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, ORN.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, ORN.CD, CG, 1.54, CB, 109.5, CA, 180.0, 0, ff, bonds);
        Atom NE = BondedUtils.buildHeavy((MSGroup)res, ORN.NE, CD, 1.5, CG, 109.5, CB, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ORN.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ORN.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, ORN.HG2, CG, 1.11, CB, 109.4, CD, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ORN.HG3, CG, 1.11, CB, 109.4, CD, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, ORN.HD2, CD, 1.11, CG, 109.4, NE, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, ORN.HD3, CD, 1.11, CG, 109.4, NE, 109.4, -1, ff, bonds);
        Atom HE1 = BondedUtils.buildH(res, ORN.HE1, NE, 1.02, CD, 109.5, CG, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, ORN.HE2, NE, 1.02, CD, 109.5, HE1, 109.5, 1, ff, bonds);
        BondedUtils.buildH(res, ORN.HE3, NE, 1.02, CD, 109.5, HE1, 109.5, -1, ff, bonds);
        return res;
    }

    public static Residue buildPCA(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, PCA.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, PCA.CG, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD = BondedUtils.buildHeavy((MSGroup)res, PCA.CD, CG, 1.54, CB, 109.5, CA, 180.0, 0, ff, bonds);
        BondedUtils.buildHeavy((MSGroup)res, PCA.OE, CD, 1.22, N, 126.0, CG, 126.0, 1, ff, bonds);
        BondedUtils.buildH(res, PCA.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, PCA.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, PCA.HG2, CG, 1.11, CB, 109.4, CD, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, PCA.HG3, CG, 1.11, CB, 109.4, CD, 109.4, -1, ff, bonds);
        BondedUtils.buildBond(N, CD, ff, bonds);
        return res;
    }

    public static Residue buildPhenylalanine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, PHE.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, PHE.CG, CB, 1.5, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CD1 = BondedUtils.buildHeavy((MSGroup)res, PHE.CD1, CG, 1.39, CB, 120.0, CA, 180.0, 0, ff, bonds);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, PHE.CD2, CG, 1.39, CB, 120.0, CD1, 120.0, 1, ff, bonds);
        Atom CE1 = BondedUtils.buildHeavy((MSGroup)res, PHE.CE1, CD1, 1.39, CG, 120.0, CB, 180.0, 0, ff, bonds);
        Atom CE2 = BondedUtils.buildHeavy((MSGroup)res, PHE.CE2, CD2, 1.39, CG, 120.0, CB, 180.0, 0, ff, bonds);
        Atom CZ = BondedUtils.buildHeavy((MSGroup)res, PHE.CZ, CE1, 1.39, CD1, 120.0, CG, 0.0, 0, ff, bonds);
        BondedUtils.buildBond(CE2, CZ, ff, bonds);
        BondedUtils.buildH(res, PHE.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, PHE.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, PHE.HD1, CD1, 1.11, CG, 120.0, CE1, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, PHE.HD2, CD2, 1.11, CG, 120.0, CE2, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, PHE.HE1, CE1, 1.11, CD1, 120.0, CZ, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, PHE.HE2, CE2, 1.11, CD2, 120.0, CZ, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, PHE.HZ, CZ, 1.11, CE1, 120.0, CE2, 120.0, 1, ff, bonds);
        return res;
    }

    public static Residue buildProline(Residue res, Atom CA, Atom N, Atom C, ResiduePosition position, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, PRO.CB, CA, 1.5247, N, 104.0, C, 109.5, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, PRO.CG, CB, 1.5247, CA, 104.0, N, 30.0, 0, ff, bonds);
        int cdKey = position == ResiduePosition.FIRST_RESIDUE ? 469 : PRO.CD.getType();
        Atom CD = BondedUtils.buildHeavy(res, PRO.CD.name(), N, 1.5247, CA, 104.0, CB, 0.0, 0, cdKey, ff, bonds);
        BondedUtils.buildBond(CD, CG, ff, bonds);
        BondedUtils.buildH(res, PRO.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, PRO.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, PRO.HG2, CG, 1.11, CB, 109.4, CD, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, PRO.HG3, CG, 1.11, CB, 109.4, CD, 109.4, -1, ff, bonds);
        if (position == ResiduePosition.FIRST_RESIDUE) {
            BondedUtils.buildH(res, PRO.HD2.name(), CD, 1.11, CG, 109.4, N, 109.4, 1, 470, ff, bonds);
            BondedUtils.buildH(res, PRO.HD3.name(), CD, 1.11, CG, 109.4, N, 109.4, -1, 470, ff, bonds);
        } else {
            BondedUtils.buildH(res, PRO.HD2, CD, 1.11, CG, 109.4, N, 109.4, 1, ff, bonds);
            BondedUtils.buildH(res, PRO.HD3, CD, 1.11, CG, 109.4, N, 109.4, -1, ff, bonds);
        }
        return res;
    }

    public static Residue buildSerine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, SER.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom OG = BondedUtils.buildHeavy((MSGroup)res, SER.OG, CB, 1.41, CA, 107.5, N, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, SER.HB2, CB, 1.11, CA, 109.4, OG, 106.7, 1, ff, bonds);
        BondedUtils.buildH(res, SER.HB3, CB, 1.11, CA, 109.4, OG, 106.7, -1, ff, bonds);
        BondedUtils.buildH(res, SER.HG, OG, 0.94, CB, 106.9, CA, 180.0, 0, ff, bonds);
        return res;
    }

    public static Residue buildThreonine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, THR.CB, CA, 1.54, N, 109.5, C, 109.5, 1, ff, bonds);
        Atom OG1 = BondedUtils.buildHeavy((MSGroup)res, THR.OG1, CB, 1.41, CA, 107.5, N, 180.0, 0, ff, bonds);
        Atom CG2 = BondedUtils.buildHeavy((MSGroup)res, THR.CG2, CB, 1.54, CA, 109.5, OG1, 107.7, 1, ff, bonds);
        BondedUtils.buildH(res, THR.HB, CB, 1.11, CA, 109.4, OG1, 106.7, -1, ff, bonds);
        BondedUtils.buildH(res, THR.HG1, OG1, 0.94, CB, 106.9, CA, 180.0, 0, ff, bonds);
        Atom HG21 = BondedUtils.buildH(res, THR.HG21, CG2, 1.11, CB, 110.0, CA, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, THR.HG22, CG2, 1.11, CB, 110.0, HG21, 109.0, 1, ff, bonds);
        BondedUtils.buildH(res, THR.HG23, CG2, 1.11, CB, 110.0, HG21, 109.0, -1, ff, bonds);
        return res;
    }

    public static Residue buildTryptophan(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bond) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, TRP.CB, CA, 1.54, N, 109.5, C, 109.5, 1, ff, bond);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, TRP.CG, CB, 1.5, CA, 109.5, N, 62.0, 0, ff, bond);
        Atom CD1 = BondedUtils.buildHeavy((MSGroup)res, TRP.CD1, CG, 1.35, CB, 126.0, CA, -90.0, 0, ff, bond);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, TRP.CD2, CG, 1.35, CB, 126.0, CD1, 108.0, 1, ff, bond);
        Atom NE1 = BondedUtils.buildHeavy((MSGroup)res, TRP.NE1, CD1, 1.35, CG, 108.0, CD2, 0.0, 0, ff, bond);
        Atom CE2 = BondedUtils.buildHeavy((MSGroup)res, TRP.CE2, NE1, 1.35, CD1, 108.0, CG, 0.0, 0, ff, bond);
        BondedUtils.buildBond(CE2, CD2, ff, bond);
        Atom CE3 = BondedUtils.buildHeavy((MSGroup)res, TRP.CE3, CD2, 1.35, CE2, 120.0, NE1, 180.0, 0, ff, bond);
        Atom CZ2 = BondedUtils.buildHeavy((MSGroup)res, TRP.CZ2, CE2, 1.35, CD2, 120.0, CE3, 0.0, 0, ff, bond);
        Atom CZ3 = BondedUtils.buildHeavy((MSGroup)res, TRP.CZ3, CE3, 1.35, CD2, 120.0, CE2, 0.0, 0, ff, bond);
        Atom CH2 = BondedUtils.buildHeavy((MSGroup)res, TRP.CH2, CZ2, 1.35, CE2, 120.0, CD2, 0.0, 0, ff, bond);
        BondedUtils.buildBond(CH2, CZ3, ff, bond);
        BondedUtils.buildH(res, TRP.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bond);
        BondedUtils.buildH(res, TRP.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bond);
        BondedUtils.buildH(res, TRP.HD1, CD1, 1.1, CG, 126.0, NE1, 126.0, 1, ff, bond);
        BondedUtils.buildH(res, TRP.HE1, NE1, 1.05, CD1, 126.0, CE2, 126.0, 1, ff, bond);
        BondedUtils.buildH(res, TRP.HE3, CE3, 1.1, CD1, 120.0, CZ3, 120.0, 1, ff, bond);
        BondedUtils.buildH(res, TRP.HZ2, CZ2, 1.1, CE2, 120.0, CH2, 120.0, 1, ff, bond);
        BondedUtils.buildH(res, TRP.HZ3, CZ3, 1.1, CE3, 120.0, CH2, 120.0, 1, ff, bond);
        BondedUtils.buildH(res, TRP.HH2, CH2, 1.1, CZ2, 120.0, CZ3, 120.0, 1, ff, bond);
        return res;
    }

    public static Residue buildTyrosine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, TYR.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG = BondedUtils.buildHeavy((MSGroup)res, TYR.CG, CB, 1.5, CA, 109.5, N, 62.0, 0, ff, bonds);
        Atom CD1 = BondedUtils.buildHeavy((MSGroup)res, TYR.CD1, CG, 1.39, CB, 120.0, CA, 90.0, 0, ff, bonds);
        Atom CD2 = BondedUtils.buildHeavy((MSGroup)res, TYR.CD2, CG, 1.39, CB, 120.0, CD1, 120.0, 1, ff, bonds);
        Atom CE1 = BondedUtils.buildHeavy((MSGroup)res, TYR.CE1, CD1, 1.39, CG, 120.0, CB, 180.0, 0, ff, bonds);
        Atom CE2 = BondedUtils.buildHeavy((MSGroup)res, TYR.CE2, CD2, 1.39, CG, 120.0, CB, 180.0, 0, ff, bonds);
        Atom CZ = BondedUtils.buildHeavy((MSGroup)res, TYR.CZ, CE1, 1.39, CD1, 120.0, CG, 0.0, 0, ff, bonds);
        BondedUtils.buildBond(CE2, CZ, ff, bonds);
        Atom OH = BondedUtils.buildHeavy((MSGroup)res, TYR.OH, CZ, 1.36, CE2, 120.0, CE1, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYR.HB2, CB, 1.11, CA, 109.4, CG, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, TYR.HB3, CB, 1.11, CA, 109.4, CG, 109.4, -1, ff, bonds);
        BondedUtils.buildH(res, TYR.HD1, CD1, 1.1, CG, 120.0, CE1, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYR.HD2, CD2, 1.1, CG, 120.0, CE2, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYR.HE1, CE1, 1.1, CD1, 120.0, CZ, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYR.HE2, CE2, 1.1, CD2, 120.0, CZ, 120.0, 1, ff, bonds);
        BondedUtils.buildH(res, TYR.HH, OH, 0.97, CZ, 108.0, CE2, 0.0, 0, ff, bonds);
        return res;
    }

    public static Residue buildValine(Residue res, Atom CA, Atom N, Atom C, ForceField ff, List<Bond> bonds) {
        Atom CB = BondedUtils.buildHeavy((MSGroup)res, VAL.CB, CA, 1.54, N, 109.5, C, 107.8, 1, ff, bonds);
        Atom CG1 = BondedUtils.buildHeavy((MSGroup)res, VAL.CG1, CB, 1.54, CA, 109.5, N, 180.0, 0, ff, bonds);
        Atom CG2 = BondedUtils.buildHeavy((MSGroup)res, VAL.CG2, CB, 1.54, CA, 109.5, CG1, 109.5, -1, ff, bonds);
        BondedUtils.buildH(res, VAL.HB, CB, 1.11, CA, 109.4, CG1, 109.4, 1, ff, bonds);
        Atom HG11 = BondedUtils.buildH(res, VAL.HG11, CG1, 1.11, CB, 109.4, CA, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, VAL.HG12, CG1, 1.11, CB, 109.4, HG11, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, VAL.HG13, CG1, 1.11, CB, 109.4, HG11, 109.4, -1, ff, bonds);
        Atom HG21 = BondedUtils.buildH(res, VAL.HG21, CG2, 1.11, CB, 109.4, CA, 180.0, 0, ff, bonds);
        BondedUtils.buildH(res, VAL.HG22, CG2, 1.11, CB, 109.4, HG21, 109.4, 1, ff, bonds);
        BondedUtils.buildH(res, VAL.HG23, CG2, 1.11, CB, 109.4, HG21, 109.4, -1, ff, bonds);
        return res;
    }

    public static void copyResidue(Residue fromResidue, Residue toResidue) {
        String resName = fromResidue.getName();
        AminoAcid3 res = AminoAcid3.valueOf(resName);
        ArrayList<String> atomNames = new ArrayList<String>();
        switch (res.ordinal()) {
            case 1: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ALA.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 20: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ASD.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 19: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ASH.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 21: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ASN.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 18: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ASP.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 29: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ARG.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 7: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(CYS.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 9: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(CYD.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 8: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(CYX.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 24: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(GLD.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 23: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(GLH.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 25: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(GLN.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 22: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(GLU.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 0: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(GLY.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(GlycineBackboneAtoms.class)));
                break;
            }
            case 16: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(HID.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 17: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(HIE.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 15: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(HIS.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 4: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ILE.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 3: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(LEU.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 28: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(LYD.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 27: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(LYS.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 26: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(MET.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 11: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(PHE.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 10: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(PRO.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(ProlineBackboneAtoms.class)));
                break;
            }
            case 5: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(SER.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 6: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(THR.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 14: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(TRP.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 13: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(TYD.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 12: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(TYR.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            case 2: {
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(VAL.class)));
                atomNames.addAll(Arrays.asList(AminoAcidUtils.getNames(AminoAcidBackboneAtoms.class)));
                break;
            }
            default: {
                atomNames = null;
            }
        }
        for (String atomName : atomNames) {
            AminoAcidUtils.copyCoordinates(fromResidue, toResidue, atomName);
        }
    }

    public static void removeH1_H2_H3(AminoAcid3 aminoAcid, Residue residue) {
        if (aminoAcid != AminoAcid3.NME) {
            Atom H3;
            if (aminoAcid != AminoAcid3.NH2) {
                Atom H2;
                Atom H1 = (Atom)residue.getAtomNode("H1");
                if (H1 != null) {
                    residue.deleteAtom(H1);
                }
                if ((H2 = (Atom)residue.getAtomNode("H2")) != null) {
                    residue.deleteAtom(H2);
                }
            }
            if ((H3 = (Atom)residue.getAtomNode("H3")) != null) {
                residue.deleteAtom(H3);
            }
        }
    }

    public static void removeOXT_OT2(Residue residue) {
        Atom OT2;
        Atom OXT = (Atom)residue.getAtomNode("OXT");
        if (OXT != null) {
            residue.deleteAtom(OXT);
        }
        if ((OT2 = (Atom)residue.getAtomNode("OT2")) != null) {
            residue.deleteAtom(OT2);
        }
    }

    private static void assignAminoAcidSideChain(ResiduePosition position, AminoAcid3 aminoAcid, Residue residue, Atom CA, Atom N, Atom C, ForceField forceField, List<Bond> bondList) {
        block0 : switch (aminoAcid.ordinal()) {
            case 1: {
                AminoAcidUtils.buildAlanine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 0: {
                AminoAcidUtils.buildGlycine(residue, CA, N, C, position, forceField, bondList);
                break;
            }
            case 2: {
                AminoAcidUtils.buildValine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 3: {
                AminoAcidUtils.buildLeucine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 4: {
                AminoAcidUtils.buildIsoleucine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 5: {
                AminoAcidUtils.buildSerine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 6: {
                AminoAcidUtils.buildThreonine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 7: {
                AminoAcidUtils.buildCysteine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 8: {
                AminoAcidUtils.buildCystine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 9: {
                AminoAcidUtils.buildDeprotonatedCysteine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 10: {
                AminoAcidUtils.buildProline(residue, CA, N, C, position, forceField, bondList);
                break;
            }
            case 11: {
                AminoAcidUtils.buildPhenylalanine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 12: {
                AminoAcidUtils.buildTyrosine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 13: {
                AminoAcidUtils.buildDeprotonatedTyrosine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 14: {
                AminoAcidUtils.buildTryptophan(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 15: {
                AminoAcidUtils.buildHistidine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 16: {
                AminoAcidUtils.buildNeutralHistidineD(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 17: {
                AminoAcidUtils.buildNeutralHistidineE(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 18: {
                AminoAcidUtils.buildAspartate(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 19: {
                AminoAcidUtils.buildNeutralAsparticAcid(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 20: {
                AminoAcidUtils.buildTwoProtonAsparticAcid(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 21: {
                AminoAcidUtils.buildAsparagine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 22: {
                AminoAcidUtils.buildGlutamate(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 23: {
                AminoAcidUtils.buildNeutralGlutamicAcid(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 24: {
                AminoAcidUtils.buildTwoProtonGlutamicAcid(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 25: {
                AminoAcidUtils.buildGlutamine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 26: {
                AminoAcidUtils.buildMethionine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 27: {
                AminoAcidUtils.buildLysine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 28: {
                AminoAcidUtils.buildDeprotonatedLysine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 29: {
                AminoAcidUtils.buildArginine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 30: {
                AminoAcidUtils.buildOrnithine(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 31: {
                AminoAcidUtils.buildAIB(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 32: {
                AminoAcidUtils.buildPCA(residue, CA, N, C, forceField, bondList);
                break;
            }
            case 39: {
                String residueName = residue.getName();
                logger.log(Level.INFO, " Patching side-chain {0}", residueName);
                HashMap<String, AtomType> types = forceField.getAtomTypes(residueName);
                if (!types.isEmpty()) {
                    AtomType type;
                    boolean patched = true;
                    List<Atom> residueAtoms = residue.getAtomList();
                    for (Atom atom : residueAtoms) {
                        String atomName2 = atom.getName().toUpperCase();
                        type = atom.getAtomType();
                        if (type != null) continue;
                        type = types.get(atomName2);
                        atom.setAtomType(type);
                        types.remove(atomName2);
                    }
                    for (Atom atom : residueAtoms) {
                        String atomName = atom.getName();
                        String[] bonds = forceField.getBonds(residueName, atomName);
                        if (bonds == null) continue;
                        for (String name : bonds) {
                            Atom atom2 = (Atom)residue.getAtomNode(name);
                            if (atom2 == null || atom.isBonded(atom2)) continue;
                            BondedUtils.buildBond(atom, atom2, forceField, bondList);
                        }
                    }
                    if (!types.isEmpty()) {
                        HashMap<String, Atom> atomMap = new HashMap<String, Atom>();
                        for (Atom atom : residueAtoms) {
                            atomMap.put(atom.getName().toUpperCase(), atom);
                        }
                        for (String atomName : types.keySet()) {
                            Bond bond;
                            type = types.get(atomName);
                            String[] bonds = forceField.getBonds(residueName, atomName.toUpperCase());
                            if (bonds == null || bonds.length != 1) {
                                patched = false;
                                logger.log(Level.INFO, " Check biotype for hydrogen {0}.", type.name);
                                break;
                            }
                            Atom ia = (Atom)atomMap.get(bonds[0].toUpperCase());
                            Atom hydrogen = new Atom(0, atomName, ia.getAltLoc(), new double[3], ia.getResidueName(), ia.getResidueNumber(), ia.getChainID(), ia.getOccupancy(), ia.getTempFactor(), ia.getSegID());
                            logger.log(Level.FINE, " Created hydrogen {0}.", atomName);
                            hydrogen.setAtomType(type);
                            hydrogen.setHetero(true);
                            residue.addMSNode(hydrogen);
                            int valence = ia.getAtomType().valence;
                            List<Bond> aBonds = ia.getBonds();
                            int numBonds = aBonds.size();
                            Atom ib = null;
                            Atom ic = null;
                            Atom id = null;
                            if (numBonds > 0) {
                                bond = aBonds.get(0);
                                ib = bond.get1_2(ia);
                            }
                            if (numBonds > 1) {
                                bond = aBonds.get(1);
                                ic = bond.get1_2(ia);
                            }
                            if (numBonds > 2) {
                                bond = aBonds.get(2);
                                id = bond.get1_2(ia);
                            }
                            logger.log(Level.FINE, " Bonding {0} to {1} ({2} of {3}).", new Object[]{atomName, ia.getName(), numBonds, valence});
                            block36 : switch (valence) {
                                case 4: {
                                    switch (numBonds) {
                                        case 3: {
                                            Double3 b = ib.getXYZ();
                                            Double3 c = ic.getXYZ();
                                            Double3 d = id.getXYZ();
                                            Double3 a = b.add(c).addI(d).scaleI(0.3333333333333333);
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, ic, 109.5, 0);
                                            Double3 e1 = hydrogen.getXYZ();
                                            Double3 ret = a.sub(e1);
                                            double l1 = ret.length();
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, ic, 109.5, 1);
                                            Double3 e2 = hydrogen.getXYZ();
                                            ret = a.sub(e2);
                                            double l2 = ret.length();
                                            if (!(l1 > l2)) break block36;
                                            hydrogen.setXYZ(e1.get());
                                            break;
                                        }
                                        case 2: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, ic, 109.5, 0);
                                            break;
                                        }
                                        case 1: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 109.5, null, 0.0, 0);
                                            break;
                                        }
                                        case 0: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                            break;
                                        }
                                        default: {
                                            logger.log(Level.INFO, " Check biotype for hydrogen {0}.", atomName);
                                            patched = false;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 3: {
                                    switch (numBonds) {
                                        case 2: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 120.0, ic, 180.0, 0);
                                            break block36;
                                        }
                                        case 1: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 120.0, null, 0.0, 0);
                                            break block36;
                                        }
                                        case 0: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                            break block36;
                                        }
                                    }
                                    logger.log(Level.INFO, " Check biotype for hydrogen {0}.", atomName);
                                    patched = false;
                                    break;
                                }
                                case 2: {
                                    switch (numBonds) {
                                        case 1: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, ib, 120.0, null, 0.0, 0);
                                            break block36;
                                        }
                                        case 0: {
                                            BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                            break block36;
                                        }
                                    }
                                    logger.log(Level.INFO, " Check biotype for hydrogen {0}.", atomName);
                                    patched = false;
                                    break;
                                }
                                case 1: {
                                    if (numBonds == 0) {
                                        BondedUtils.intxyz(hydrogen, ia, 1.0, null, 0.0, null, 0.0, 0);
                                        break;
                                    }
                                    logger.log(Level.INFO, " Check biotype for hydrogen {0}.", atomName);
                                    patched = false;
                                    break;
                                }
                                default: {
                                    logger.log(Level.INFO, " Check biotype for hydrogen {0}.", atomName);
                                    patched = false;
                                }
                            }
                            if (!patched) break;
                            BondedUtils.buildBond(ia, hydrogen, forceField, bondList);
                        }
                    }
                    if (!patched) {
                        logger.log(Level.SEVERE, String.format(" Could not patch %s.", residueName));
                        break;
                    }
                    logger.log(Level.INFO, " Patch for {0} succeeded.", residueName);
                    residueAtoms = residue.getAtomList();
                    for (Atom atom : residueAtoms) {
                        logger.info(atom.toString() + " -> " + atom.getAtomType().toString());
                    }
                    break;
                }
                switch (position.ordinal()) {
                    case 0: {
                        BondedUtils.buildH(residue, "HA2", CA, 1.1, N, 109.5, C, 109.5, 1, 355, forceField, bondList);
                        break block0;
                    }
                    case 2: {
                        BondedUtils.buildH(residue, "HA2", CA, 1.1, N, 109.5, C, 109.5, 1, 506, forceField, bondList);
                        break block0;
                    }
                }
                BondedUtils.buildH(residue, "HA2", CA, 1.1, N, 109.5, C, 109.5, 1, 6, forceField, bondList);
            }
        }
    }

    private static void checkForMissingHeavyAtoms(AminoAcid3 aminoAcid, Residue residue) throws BondedUtils.MissingHeavyAtomException {
        int expected = aminoAcid.heavyAtoms;
        if (aminoAcid != AminoAcid3.GLY && expected >= 4) {
            int actual = 0;
            List<Atom> resAtoms = residue.getAtomList();
            for (Atom atom : resAtoms) {
                String label = atom.getName().toUpperCase();
                if (label.equalsIgnoreCase("OXT") || label.equalsIgnoreCase("OT2") || label.startsWith("H") || label.startsWith("D")) continue;
                ++actual;
            }
            if (actual != expected) {
                Atom N = (Atom)residue.getAtomNode("N");
                if (N == null) {
                    BondedUtils.MissingHeavyAtomException e = new BondedUtils.MissingHeavyAtomException("N", null, null);
                    logger.warning(String.format(" Residue %c-%s is missing its N-terminal amide nitrogen", residue.getChainID(), residue));
                    throw e;
                }
                Atom CA = (Atom)residue.getAtomNode("CA");
                if (CA == null) {
                    BondedUtils.MissingHeavyAtomException e = new BondedUtils.MissingHeavyAtomException("CA", null, null);
                    logger.warning(String.format(" Residue %c-%s is missing its alpha carbon", residue.getChainID(), residue));
                    throw e;
                }
                Atom C = (Atom)residue.getAtomNode("C");
                if (C == null) {
                    BondedUtils.MissingHeavyAtomException e = new BondedUtils.MissingHeavyAtomException("C", null, null);
                    logger.warning(String.format(" Residue %c-%s is missing its C-terminal carboxyl carbon", residue.getChainID(), residue));
                    throw e;
                }
            }
        }
    }

    private static void copyCoordinates(Residue fromResidue, Residue toResidue, String atomName) {
        Atom fromAtom = fromResidue.getAtomNode(atomName) != null ? (Atom)fromResidue.getAtomNode(atomName) : (Atom)fromResidue.getAtomNode("H1");
        Atom toAtom = (Atom)toResidue.getAtomNode(atomName);
        toAtom.setXYZ(fromAtom.getXYZ(null));
    }

    public static AminoAcid3 getAminoAcid(String residueName) {
        for (AminoAcid3 aminoAcid : aminoAcidList) {
            if (!aminoAcid.toString().equalsIgnoreCase(residueName)) continue;
            return aminoAcid;
        }
        return AminoAcid3.UNK;
    }

    public static AminoAcid3 getAminoAcid3From1(String residueName) {
        for (AminoAcid1 aminoAcid : aminoAcid1List) {
            if (!aminoAcid.toString().equalsIgnoreCase(residueName)) continue;
            int position = AminoAcid1.valueOf(residueName).ordinal();
            return AminoAcid3.values()[position];
        }
        return AminoAcid3.UNK;
    }

    public static int getAminoAcidNumber(String residueName) {
        int aminoAcidNumber = -1;
        for (AminoAcid3 aminoAcid : aminoAcidList) {
            ++aminoAcidNumber;
            if (!aminoAcid.toString().equalsIgnoreCase(residueName)) continue;
            break;
        }
        return aminoAcidNumber;
    }

    static {
        sidechainStoichiometry.put("S1C3", "MET");
        sidechainStoichiometry.put("S1C1", "CYS");
        sidechainStoichiometry.put("O1C1", "SER");
        sidechainStoichiometry.put("O1C2", "THR");
        sidechainStoichiometry.put("O1C7", "TYR");
        sidechainStoichiometry.put("O2C2", "ASP");
        sidechainStoichiometry.put("O2C3", "GLU");
        sidechainStoichiometry.put("O1N1C2", "ASN");
        sidechainStoichiometry.put("O1N1C3", "GLN");
        sidechainStoichiometry.put("N3C4", "ARG");
        sidechainStoichiometry.put("N2C4", "HIS");
        sidechainStoichiometry.put("N1C9", "TRP");
        sidechainStoichiometry.put("N1C4", "LYS");
        sidechainStoichiometry.put("C7", "PHE");
        sidechainStoichiometry.put("H", "GLY");
        sidechainStoichiometry.put("C1", "ALA");
        sidechainStoichiometry.put("O2N3C6", "DC");
        sidechainStoichiometry.put("O1N5C7", "DA");
        sidechainStoichiometry.put("O3N2C7", "DT");
        sidechainStoichiometry.put("O3N5C7", "G");
        sidechainStoichiometry.put("O3N3C6", "C");
        sidechainStoichiometry.put("O4N2C6", "U");
        sidechainStoichiometry.put("C3", "1");
        sidechainStoichiometry.put("C4", "2");
        sidechainStoichiometry.put("O2N5C7", "3");
        AminoAcid1[] aa1 = AminoAcid1.values();
        AminoAcid3[] aa3 = AminoAcid3.values();
        for (int i = 0; i < AminoAcid1.values().length; ++i) {
            AA1toAA3.put(aa1[i], aa3[i]);
            AA3toAA1.put(aa3[i], aa1[i]);
        }
        AA_N = new int[][]{{403, 409, 415, 421, 427, 433, 439, 445, 451, 457, 463, 471, 477, 483, 489, 495, 501, 507, 513, 519, 519, 525, 531, 537, 537, 543, 549, 555, 561, 567, 573, 579, 391, 762, 0, 0, 0, 0, 0, 403}, {1, 7, 15, 27, 41, 55, 65, 77, 87, 96, 105, 116, 131, 147, 162, 185, 202, 218, 234, 244, 244, 256, 268, 280, 280, 294, 308, 321, 337, 353, 370, 384, 391, 0, 0, 0, 0, 0, 0, 1}, {584, 590, 596, 602, 608, 614, 620, 626, 632, 638, 644, 649, 655, 661, 667, 673, 679, 685, 691, 697, 697, 703, 709, 715, 715, 721, 727, 733, 739, 745, 751, 757, 0, 0, 0, 0, 773, 775, 777, 584}, {403, 409, 415, 421, 427, 433, 439, 445, 451, 457, 463, 471, 477, 483, 489, 495, 501, 507, 513, 519, 519, 525, 531, 537, 537, 543, 549, 555, 561, 567, 573, 579, 391, 762, 0, 0, 0, 0, 0, 403}};
        AA_CA = new int[][]{{404, 410, 416, 422, 428, 434, 440, 446, 452, 458, 464, 472, 478, 484, 490, 496, 502, 508, 514, 520, 520, 526, 532, 538, 538, 544, 550, 556, 562, 568, 574, 580, 392, 0, 0, 767, 0, 0, 0, 404}, {2, 8, 16, 28, 42, 56, 66, 78, 88, 97, 106, 117, 132, 148, 163, 186, 203, 219, 235, 245, 245, 257, 269, 281, 281, 295, 309, 322, 338, 354, 371, 385, 392, 0, 0, 0, 0, 0, 0, 2}, {585, 591, 597, 603, 609, 615, 621, 627, 633, 639, 645, 650, 656, 662, 668, 674, 680, 686, 692, 698, 698, 704, 710, 716, 716, 722, 728, 734, 740, 746, 752, 758, 0, 0, 0, 0, 0, 0, 779, 585}, {2, 8, 16, 28, 42, 56, 66, 78, 88, 97, 106, 117, 132, 148, 163, 186, 203, 219, 235, 245, 245, 257, 269, 281, 281, 295, 309, 322, 338, 354, 371, 385, 392, 0, 0, 0, 0, 0, 0, 2}};
        AA_C = new int[][]{{405, 411, 417, 423, 429, 435, 441, 447, 453, 459, 465, 473, 479, 485, 491, 497, 503, 509, 515, 521, 521, 527, 533, 539, 539, 545, 551, 557, 563, 569, 575, 581, 393, 0, 764, 769, 0, 0, 0, 405}, {3, 9, 17, 29, 43, 57, 67, 79, 89, 98, 107, 118, 133, 149, 164, 187, 204, 220, 236, 246, 246, 258, 270, 282, 282, 296, 310, 323, 339, 355, 372, 386, 393, 0, 0, 0, 0, 0, 0, 3}, {586, 592, 598, 604, 610, 616, 622, 628, 634, 640, 646, 651, 657, 663, 669, 675, 681, 687, 693, 699, 699, 705, 711, 717, 717, 723, 729, 735, 741, 747, 753, 759, 0, 0, 0, 0, 771, 0, 0, 586}, {586, 592, 598, 604, 610, 616, 622, 628, 634, 640, 646, 651, 657, 663, 669, 675, 681, 687, 693, 699, 699, 705, 711, 717, 717, 723, 729, 735, 741, 747, 753, 759, 0, 0, 0, 0, 771, 0, 0, 586}};
        AA_HN = new int[][]{{406, 412, 418, 424, 430, 436, 442, 448, 454, 460, 466, 474, 480, 486, 492, 498, 504, 510, 516, 522, 522, 528, 534, 540, 540, 546, 552, 558, 564, 570, 576, 582, 394, 763, 0, 0, 0, 0, 0, 406}, {4, 10, 18, 30, 44, 58, 68, 80, 90, 99, 0, 119, 134, 150, 165, 188, 205, 221, 237, 247, 247, 259, 271, 283, 283, 297, 311, 324, 340, 356, 373, 387, 394, 0, 0, 0, 0, 0, 0, 4}, {587, 593, 599, 605, 611, 617, 623, 629, 635, 641, 0, 652, 658, 664, 670, 676, 682, 688, 694, 700, 700, 706, 712, 718, 718, 724, 730, 736, 742, 748, 754, 760, 0, 0, 0, 0, 774, 776, 778, 587}, {406, 412, 418, 424, 430, 436, 442, 448, 454, 460, 466, 474, 480, 486, 492, 498, 504, 510, 516, 522, 522, 528, 534, 540, 540, 546, 552, 558, 564, 570, 576, 582, 394, 763, 0, 0, 0, 0, 0, 406}};
        AA_O = new int[][]{{407, 413, 419, 425, 431, 437, 443, 449, 455, 461, 467, 475, 481, 487, 493, 499, 505, 511, 517, 523, 523, 529, 535, 541, 541, 547, 553, 559, 565, 571, 577, 583, 395, 0, 766, 770, 0, 0, 0, 407}, {5, 11, 19, 31, 45, 59, 69, 81, 91, 100, 108, 120, 135, 151, 166, 189, 206, 222, 238, 248, 248, 260, 272, 284, 284, 298, 312, 325, 341, 357, 374, 388, 395, 0, 0, 0, 0, 0, 0, 5}, {588, 594, 600, 606, 612, 618, 624, 630, 636, 642, 647, 653, 659, 665, 671, 677, 683, 689, 695, 701, 701, 707, 713, 719, 719, 725, 731, 737, 743, 749, 755, 761, 0, 0, 0, 0, 772, 0, 0, 588}, {588, 594, 600, 606, 612, 618, 624, 630, 636, 642, 647, 653, 659, 665, 671, 677, 683, 689, 695, 701, 701, 707, 713, 719, 719, 725, 731, 737, 743, 749, 755, 761, 0, 0, 0, 0, 772, 0, 0, 588}};
        AA_HA = new int[][]{{408, 414, 420, 426, 432, 438, 444, 450, 456, 462, 468, 476, 482, 488, 494, 500, 506, 512, 518, 524, 524, 530, 536, 542, 542, 548, 554, 560, 566, 572, 578, 0, 396, 0, 765, 768, 0, 0, 0, 408}, {6, 12, 20, 32, 46, 60, 70, 82, 92, 101, 109, 121, 136, 152, 167, 190, 207, 223, 239, 249, 249, 261, 273, 285, 285, 299, 313, 326, 342, 358, 375, 0, 396, 0, 0, 0, 0, 0, 0, 6}, {589, 595, 601, 607, 613, 619, 625, 631, 637, 643, 648, 654, 660, 666, 672, 678, 684, 690, 696, 702, 702, 708, 714, 720, 720, 726, 732, 738, 744, 750, 756, 0, 0, 0, 0, 0, 0, 0, 780, 589}, {6, 12, 20, 32, 46, 60, 70, 82, 92, 101, 109, 121, 136, 152, 167, 190, 207, 223, 239, 249, 249, 261, 273, 285, 285, 299, 313, 326, 342, 358, 375, 0, 396, 0, 0, 0, 0, 0, 0, 6}};
        AA_CB = new int[]{0, 13, 21, 33, 47, 61, 71, 83, 93, 102, 110, 122, 137, 153, 168, 191, 208, 224, 240, 250, 806, 262, 274, 286, 817, 300, 314, 327, 343, 359, 376, 389, 397, 0, 0, 0, 0, 0, 0, 0};
    }

    public static enum ResiduePosition {
        FIRST_RESIDUE,
        MIDDLE_RESIDUE,
        LAST_RESIDUE,
        SINGLE_RESIDUE;

    }

    public static enum AminoAcid3 {
        GLY(4),
        ALA(5, true),
        VAL(7, true),
        LEU(8, true),
        ILE(8, true),
        SER(6),
        THR(7),
        CYS(6, false, true, false, false),
        CYX(6),
        CYD(6, false, false, false, false),
        PRO(7),
        PHE(11, true),
        TYR(12, true, false, false, false),
        TYD(12, true, false, false, false),
        TRP(14, true),
        HIS(10, true, true, true, false),
        HID(10, true, false, false, false),
        HIE(10, true, false, false, false),
        ASP(8, true, false, false, false),
        ASH(8, true, false, false, false),
        ASD(8, true, true, true, true),
        ASN(8, true),
        GLU(9, true, false, false, false),
        GLH(9, true, false, false, false),
        GLD(9, true, true, true, true),
        GLN(9, true),
        MET(8, true),
        LYS(9, true, true, false, false),
        LYD(9, true, false, false, false),
        ARG(11, true),
        ORN(8),
        AIB(6),
        PCA(8),
        H2N(0),
        FOR(0),
        ACE(0),
        COH(0),
        NH2(0),
        NME(0),
        UNK(0);

        public final int heavyAtoms;
        public final boolean useWithMultiResidue;
        public final boolean isConstantPhTitratable;
        public final boolean isConstantPhTautomer;
        public final boolean nonStandardProtonation;

        private AminoAcid3(int heavyAtoms) {
            this.heavyAtoms = heavyAtoms;
            this.useWithMultiResidue = false;
            this.isConstantPhTitratable = false;
            this.isConstantPhTautomer = false;
            this.nonStandardProtonation = false;
        }

        private AminoAcid3(int heavyAtoms, boolean useWithMultiResidue) {
            this.heavyAtoms = heavyAtoms;
            this.useWithMultiResidue = useWithMultiResidue;
            this.isConstantPhTitratable = false;
            this.isConstantPhTautomer = false;
            this.nonStandardProtonation = false;
        }

        private AminoAcid3(int heavyAtoms, boolean useWithMultiResidue, boolean isConstantPhTitratable, boolean isConstantPhTautomer, boolean nonStandardProtonation) {
            this.heavyAtoms = heavyAtoms;
            this.useWithMultiResidue = useWithMultiResidue;
            this.isConstantPhTitratable = isConstantPhTitratable;
            this.isConstantPhTautomer = isConstantPhTautomer;
            this.nonStandardProtonation = nonStandardProtonation;
            if (nonStandardProtonation && !this.isConstantPhTitratable) {
                throw new IllegalArgumentException(String.format(" Amino acid class %s cannot be both nonstandard and non-titratable!", new Object[]{this}));
            }
        }
    }

    public static enum AIB implements SideChainType
    {
        CB1(0),
        CB2(0),
        HB11(1),
        HB12(1),
        HB13(1),
        HB21(1),
        HB22(1),
        HB23(1);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private AIB(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.AIB.ordinal()];
        }
    }

    public static interface SideChainType {
        public String name();

        public int getType();
    }

    public static enum ALA implements SideChainType
    {
        CB(0),
        HB1(1),
        HB2(1),
        HB3(1);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ALA(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ALA.ordinal()];
        }
    }

    public static enum ARG implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        HD2(5),
        HD3(5),
        NE(6),
        HE(7),
        CZ(8),
        NH1(9),
        HH11(10),
        HH12(10),
        NH2(9),
        HH21(10),
        HH22(10);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ARG(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ARG.ordinal()];
        }
    }

    public static enum ASN implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        OD1(3),
        ND2(4),
        HD21(5),
        HD22(5);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ASN(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ASN.ordinal()];
        }
    }

    public static enum ASP implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        OD1(3),
        OD2(3);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ASP(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ASP.ordinal()];
        }
    }

    public static enum CYS implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        SG(2),
        HG(3);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private CYS(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.CYS.ordinal()];
        }
    }

    public static enum CYX implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        SG(2);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private CYX(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.CYX.ordinal()];
        }
    }

    public static enum CYD implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        SG(2);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private CYD(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.CYD.ordinal()];
        }
    }

    public static enum LYD implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        HD2(5),
        HD3(5),
        CE(6),
        HE2(7),
        HE3(7),
        NZ(8),
        HZ1(9),
        HZ2(9);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private LYD(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.LYD.ordinal()];
        }
    }

    public static enum TYD implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        CD1(3),
        HD1(4),
        CD2(3),
        HD2(4),
        CE1(5),
        HE1(6),
        CE2(5),
        HE2(6),
        CZ(7),
        OH(8);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private TYD(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.TYD.ordinal()];
        }
    }

    public static enum GLU implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        OE1(5),
        OE2(5);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private GLU(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.GLU.ordinal()];
        }
    }

    public static enum GLN implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        OE1(5),
        NE2(6),
        HE21(7),
        HE22(7);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private GLN(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.GLN.ordinal()];
        }
    }

    public static enum HIS implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        ND1(3),
        HD1(4),
        CD2(5),
        HD2(6),
        CE1(7),
        HE1(8),
        NE2(9),
        HE2(10);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private HIS(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.HIS.ordinal()];
        }
    }

    public static enum ILE implements SideChainType
    {
        CB(0),
        HB(1),
        CG1(2),
        HG12(3),
        HG13(3),
        CG2(4),
        HG21(5),
        HG22(5),
        HG23(5),
        CD1(6),
        HD11(7),
        HD12(7),
        HD13(7);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ILE(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ILE.ordinal()];
        }
    }

    public static enum LEU implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG(3),
        CD1(4),
        HD11(5),
        HD12(5),
        HD13(5),
        CD2(6),
        HD21(7),
        HD22(7),
        HD23(7);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private LEU(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.LEU.ordinal()];
        }
    }

    public static enum LYS implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        HD2(5),
        HD3(5),
        CE(6),
        HE2(7),
        HE3(7),
        NZ(8),
        HZ1(9),
        HZ2(9),
        HZ3(9);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private LYS(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.LYS.ordinal()];
        }
    }

    public static enum MET implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        SD(4),
        CE(5),
        HE1(6),
        HE2(6),
        HE3(6);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private MET(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.MET.ordinal()];
        }
    }

    public static enum ASH implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        OD1(3),
        OD2(4),
        HD2(5);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ASH(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ASH.ordinal()];
        }
    }

    public static enum ASD implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        OD1(3),
        OD2(3),
        HD1(4),
        HD2(4);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ASD(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ASD.ordinal()];
        }
    }

    public static enum GLH implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        OE1(5),
        OE2(6),
        HE2(7);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private GLH(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.GLH.ordinal()];
        }
    }

    public static enum GLD implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        OE1(5),
        OE2(5),
        HE1(6),
        HE2(6);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private GLD(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.GLD.ordinal()];
        }
    }

    public static enum HID implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        ND1(3),
        HD1(4),
        CD2(5),
        HD2(6),
        CE1(7),
        HE1(8),
        NE2(9);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private HID(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.HID.ordinal()];
        }
    }

    public static enum HIE implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        ND1(3),
        CD2(4),
        HD2(5),
        CE1(6),
        HE1(7),
        NE2(8),
        HE2(9);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private HIE(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.HIE.ordinal()];
        }
    }

    public static enum ORN implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(2),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        HD2(5),
        HD3(5),
        NE(6),
        HE1(7),
        HE2(7),
        HE3(7);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private ORN(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.ORN.ordinal()];
        }
    }

    public static enum PCA implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        OE(5);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private PCA(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.PCA.ordinal()];
        }
    }

    public static enum PHE implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        CD1(3),
        HD1(4),
        CD2(3),
        HD2(4),
        CE1(5),
        HE1(6),
        CE2(5),
        HE2(6),
        CZ(7),
        HZ(8);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private PHE(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.PHE.ordinal()];
        }
    }

    public static enum PRO implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        HG2(3),
        HG3(3),
        CD(4),
        HD2(5),
        HD3(5);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private PRO(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.PRO.ordinal()];
        }
    }

    public static enum SER implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        OG(2),
        HG(3);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private SER(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.SER.ordinal()];
        }
    }

    public static enum THR implements SideChainType
    {
        CB(0),
        HB(1),
        OG1(2),
        HG1(3),
        CG2(4),
        HG21(5),
        HG22(5),
        HG23(5);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private THR(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.THR.ordinal()];
        }
    }

    public static enum TRP implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        CD1(3),
        HD1(4),
        CD2(5),
        NE1(6),
        HE1(7),
        CE2(8),
        CE3(9),
        HE3(10),
        CZ2(11),
        HZ2(12),
        CZ3(13),
        HZ3(14),
        CH2(15),
        HH2(16);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private TRP(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.TRP.ordinal()];
        }
    }

    public static enum TYR implements SideChainType
    {
        CB(0),
        HB2(1),
        HB3(1),
        CG(2),
        CD1(3),
        HD1(4),
        CD2(3),
        HD2(4),
        CE1(5),
        HE1(6),
        CE2(5),
        HE2(6),
        CZ(7),
        OH(8),
        HH(9);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private TYR(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.TYR.ordinal()];
        }
    }

    public static enum VAL implements SideChainType
    {
        CB(0),
        HB(1),
        CG1(2),
        HG11(3),
        HG12(3),
        HG13(3),
        CG2(4),
        HG21(5),
        HG22(5),
        HG23(5);

        private final int biotype;

        @Override
        public int getType() {
            return this.biotype;
        }

        private VAL(int offset) {
            this.biotype = offset + AA_CB[AminoAcid3.VAL.ordinal()];
        }
    }

    public static enum AminoAcidBackboneAtoms {
        N,
        H,
        CA,
        HA,
        C,
        O;

    }

    public static enum GLY {
        HA2;

    }

    public static enum GlycineBackboneAtoms {
        N,
        H,
        CA,
        HA2,
        HA3,
        C,
        O;

    }

    public static enum ProlineBackboneAtoms {
        N,
        CA,
        HA,
        C,
        O;

    }

    public static enum AminoAcid1 {
        G,
        A,
        V,
        L,
        I,
        S,
        T,
        C,
        X,
        c,
        P,
        F,
        Y,
        y,
        W,
        H,
        U,
        Z,
        D,
        d,
        p,
        N,
        E,
        e,
        q,
        Q,
        M,
        K,
        k,
        R,
        O,
        B,
        J,
        t,
        f,
        a,
        o,
        n,
        m,
        x;

    }

    public static enum AA {
        GLYCINE,
        ALANINE,
        VALINE,
        LEUCINE,
        ISOLEUCINE,
        SERINE,
        THREONINE,
        CYSTEINE,
        PROLINE,
        PHENYLALANINE,
        TYROSINE,
        TRYPTOPHAN,
        ASPARTATE,
        ASPARAGINE,
        GLUTAMATE,
        GLUTAMINE,
        METHIONINE,
        LYSINE,
        ARGININE,
        HISTIDINE;

    }
}

