/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.DualTopologyEnergy;
import ffx.potential.Utilities;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.utils.EnergyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.logging.Logger;

public class QuadTopologyEnergy
implements CrystalPotential,
LambdaInterface {
    private static final Logger logger = Logger.getLogger(QuadTopologyEnergy.class.getName());
    private final DualTopologyEnergy dualTopA;
    private final DualTopologyEnergy dualTopB;
    private final LambdaInterface linterA;
    private final LambdaInterface linterB;
    private final int nVarA;
    private final int nVarB;
    private final int nShared;
    private final int uniqueA;
    private final int uniqueB;
    private final int nVarTot;
    private final int[] indexAToGlobal;
    private final int[] indexBToGlobal;
    private final int[] indexGlobalToA;
    private final int[] indexGlobalToB;
    private final double[] mass;
    private final double[] xA;
    private final double[] xB;
    private final double[] gA;
    private final double[] gB;
    private final double[] tempA;
    private final double[] tempB;
    private final EnergyRegion region;
    private Potential.STATE state = Potential.STATE.BOTH;
    private double lambda;
    private double totalEnergy;
    private double energyA;
    private double energyB;
    private double dEdL;
    private double dEdL_A;
    private double dEdL_B;
    private double d2EdL2;
    private double d2EdL2_A;
    private double d2EdL2_B;
    private boolean inParallel = false;
    private ParallelTeam team;
    private double[] scaling;
    private Potential.VARIABLE_TYPE[] types = null;

    public QuadTopologyEnergy(DualTopologyEnergy dualTopologyA, DualTopologyEnergy dualTopologyB) {
        this(dualTopologyA, dualTopologyB, null, null);
    }

    public QuadTopologyEnergy(DualTopologyEnergy dualTopologyA, DualTopologyEnergy dualTopologyB, List<Integer> uniqueAList, List<Integer> uniqueBList) {
        int destIndex;
        int i;
        int uniqueIndex;
        int commonIndex;
        int i2;
        int nCommon;
        this.dualTopA = dualTopologyA;
        this.dualTopB = dualTopologyB;
        this.dualTopB.setCrystal(this.dualTopA.getCrystal());
        this.dualTopB.reloadCommonMasses(true);
        this.linterA = dualTopologyA;
        this.linterB = dualTopologyB;
        this.nVarA = this.dualTopA.getNumberOfVariables();
        this.nVarB = this.dualTopB.getNumberOfVariables();
        LinkedHashSet<Integer> uniqueASet = new LinkedHashSet<Integer>();
        if (uniqueAList != null) {
            uniqueASet.addAll(uniqueAList);
        }
        for (int i3 = nCommon = this.dualTopA.getNumSharedVariables(); i3 < this.nVarA; ++i3) {
            uniqueASet.add(i3);
        }
        uniqueAList = new ArrayList<Integer>(uniqueASet);
        this.uniqueA = uniqueAList.size();
        int[] uniquesA = new int[this.uniqueA];
        for (int i4 = 0; i4 < this.uniqueA; ++i4) {
            uniquesA[i4] = uniqueAList.get(i4);
        }
        LinkedHashSet<Integer> uniqueBSet = new LinkedHashSet<Integer>();
        if (uniqueBList != null) {
            uniqueBSet.addAll(uniqueBList);
        }
        for (int i5 = nCommon = this.dualTopB.getNumSharedVariables(); i5 < this.nVarB; ++i5) {
            uniqueBSet.add(i5);
        }
        uniqueBList = new ArrayList<Integer>(uniqueBSet);
        this.uniqueB = uniqueBList.size();
        int[] uniquesB = new int[this.uniqueB];
        for (i2 = 0; i2 < this.uniqueB; ++i2) {
            uniquesB[i2] = uniqueBList.get(i2);
        }
        this.nShared = this.nVarA - this.uniqueA;
        assert (this.nShared == this.nVarB - this.uniqueB);
        this.nVarTot = this.nShared + this.uniqueA + this.uniqueB;
        this.indexAToGlobal = new int[this.nVarA];
        this.indexBToGlobal = new int[this.nVarB];
        this.indexGlobalToA = new int[this.nVarTot];
        this.indexGlobalToB = new int[this.nVarTot];
        Arrays.fill(this.indexGlobalToA, -1);
        Arrays.fill(this.indexGlobalToB, -1);
        if (this.uniqueA > 0) {
            commonIndex = 0;
            uniqueIndex = 0;
            for (i = 0; i < this.nVarA; ++i) {
                if (uniqueIndex < this.uniqueA && i == uniquesA[uniqueIndex]) {
                    this.indexAToGlobal[i] = destIndex = this.nShared + uniqueIndex;
                    this.indexGlobalToA[destIndex] = i;
                    ++uniqueIndex;
                    continue;
                }
                this.indexAToGlobal[i] = commonIndex;
                this.indexGlobalToA[commonIndex++] = i;
            }
        } else {
            for (i2 = 0; i2 < this.nVarA; ++i2) {
                this.indexAToGlobal[i2] = i2;
                this.indexGlobalToA[i2] = i2;
            }
        }
        if (this.uniqueB > 0) {
            commonIndex = 0;
            uniqueIndex = 0;
            for (i = 0; i < this.nVarB; ++i) {
                if (uniqueIndex < this.uniqueB && i == uniquesB[uniqueIndex]) {
                    this.indexBToGlobal[i] = destIndex = this.nVarA + uniqueIndex;
                    this.indexGlobalToB[destIndex] = i;
                    ++uniqueIndex;
                    continue;
                }
                this.indexBToGlobal[i] = commonIndex;
                this.indexGlobalToB[commonIndex++] = i;
            }
        } else {
            for (i2 = 0; i2 < this.nVarB; ++i2) {
                this.indexBToGlobal[i2] = i2;
                this.indexGlobalToB[i2] = i2;
            }
        }
        this.xA = new double[this.nVarA];
        this.xB = new double[this.nVarB];
        this.gA = new double[this.nVarA];
        this.gB = new double[this.nVarB];
        this.tempA = new double[this.nVarA];
        this.tempB = new double[this.nVarB];
        this.mass = new double[this.nVarTot];
        this.doublesFromFunction(this.mass, this.dualTopA.getMass(), this.dualTopB.getMass(), Math::max);
        this.region = new EnergyRegion(this);
        this.team = new ParallelTeam(1);
    }

    @Override
    public boolean dEdLZeroAtEnds() {
        return this.dualTopA.dEdLZeroAtEnds() && this.dualTopB.dEdLZeroAtEnds();
    }

    public boolean destroy() {
        boolean dtADestroy = this.dualTopA.destroy();
        boolean dtBDestroy = this.dualTopB.destroy();
        try {
            if (this.team != null) {
                this.team.shutdown();
            }
            return dtADestroy && dtBDestroy;
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception in shutting down QuadTopologyEnergy: %s", ex));
            logger.info(Utilities.stackTraceToString(ex));
            return false;
        }
    }

    public double energy(double[] x) {
        return this.energy(x, false);
    }

    public double energy(double[] x, boolean verbose) {
        this.region.setX(x);
        this.region.setVerbose(verbose);
        try {
            this.team.execute((ParallelRegion)this.region);
        }
        catch (Exception ex) {
            throw new EnergyException(String.format(" Exception in calculating quad-topology energy: %s", ex));
        }
        if (verbose) {
            logger.info(String.format(" Total quad-topology energy: %12.4f", this.totalEnergy));
        }
        return this.totalEnergy;
    }

    public double energyAndGradient(double[] x, double[] g) {
        return this.energyAndGradient(x, g, false);
    }

    public double energyAndGradient(double[] x, double[] g, boolean verbose) {
        assert (Arrays.stream(x).allMatch(Double::isFinite));
        this.region.setX(x);
        this.region.setG(g);
        this.region.setVerbose(verbose);
        try {
            this.team.execute((ParallelRegion)this.region);
        }
        catch (Exception ex) {
            throw new EnergyException(String.format(" Exception in calculating quad-topology energy: %s", ex));
        }
        if (verbose) {
            logger.info(String.format(" Total quad-topology energy: %12.4f", this.totalEnergy));
        }
        return this.totalEnergy;
    }

    public double[] getAcceleration(double[] acceleration) {
        this.doublesFrom(acceleration, this.dualTopA.getAcceleration(this.tempA), this.dualTopB.getAcceleration(this.tempB));
        return acceleration;
    }

    public double[] getCoordinates(double[] x) {
        this.dualTopA.getCoordinates(this.xA);
        this.dualTopB.getCoordinates(this.xB);
        this.doublesFrom(x, this.xA, this.xB);
        return x;
    }

    public Crystal getCrystal() {
        return this.dualTopA.getCrystal();
    }

    public void setCrystal(Crystal crystal) {
        this.dualTopA.setCrystal(crystal);
        this.dualTopB.setCrystal(crystal);
    }

    public DualTopologyEnergy getDualTopA() {
        return this.dualTopA;
    }

    public DualTopologyEnergy getDualTopB() {
        return this.dualTopB;
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
        this.dualTopA.setEnergyTermState(state);
        this.dualTopB.setEnergyTermState(state);
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (!Double.isFinite(lambda) || lambda > 1.0 || lambda < 0.0) {
            throw new ArithmeticException(String.format(" Attempted to set invalid lambda value of %10.6g", lambda));
        }
        this.lambda = lambda;
        this.dualTopA.setLambda(lambda);
        this.dualTopB.setLambda(lambda);
    }

    public double[] getMass() {
        return this.mass;
    }

    public int getNumSharedVariables() {
        return this.nShared;
    }

    public int getNumberOfVariables() {
        return this.nVarTot;
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        this.doublesFrom(previousAcceleration, this.dualTopA.getPreviousAcceleration(this.tempA), this.dualTopB.getPreviousAcceleration(this.tempB));
        return previousAcceleration;
    }

    public double[] getScaling() {
        return this.scaling;
    }

    public void setScaling(double[] scaling) {
        this.scaling = scaling;
        if (scaling != null) {
            double[] scaleA = new double[this.nVarA];
            double[] scaleB = new double[this.nVarB];
            this.doublesTo(scaling, scaleA, scaleB);
            this.dualTopA.setScaling(scaleA);
            this.dualTopB.setScaling(scaleB);
        } else {
            this.dualTopA.setScaling(null);
            this.dualTopB.setScaling(null);
        }
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public List<Potential> getUnderlyingPotentials() {
        ArrayList<Potential> under = new ArrayList<Potential>(6);
        under.add((Potential)this.dualTopA);
        under.add((Potential)this.dualTopB);
        under.addAll(this.dualTopA.getUnderlyingPotentials());
        under.addAll(this.dualTopB.getUnderlyingPotentials());
        return under;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        if (this.types == null) {
            Potential.VARIABLE_TYPE[] typesA = this.dualTopA.getVariableTypes();
            Potential.VARIABLE_TYPE[] typesB = this.dualTopB.getVariableTypes();
            if (typesA != null && typesB != null) {
                this.types = new Potential.VARIABLE_TYPE[this.nVarTot];
                this.copyFrom(this.types, this.dualTopA.getVariableTypes(), this.dualTopB.getVariableTypes());
            } else {
                logger.fine(" Variable types array remaining null due to null variable types in either A or B dual topology");
            }
        }
        return this.types;
    }

    public double[] getVelocity(double[] velocity) {
        this.doublesFrom(velocity, this.dualTopA.getVelocity(this.tempA), this.dualTopB.getVelocity(this.tempB));
        return velocity;
    }

    @Override
    public double getd2EdL2() {
        return this.d2EdL2;
    }

    @Override
    public double getdEdL() {
        return this.dEdL;
    }

    @Override
    public void getdEdXdL(double[] g) {
        this.dualTopA.getdEdXdL(this.tempA);
        this.dualTopB.getdEdXdL(this.tempB);
        this.addDoublesFrom(g, this.tempA, this.tempB);
    }

    public void setAcceleration(double[] acceleration) {
        this.doublesTo(acceleration, this.tempA, this.tempB);
        this.dualTopA.setVelocity(this.tempA);
        this.dualTopB.setVelocity(this.tempB);
    }

    public void setParallel(boolean parallel) {
        this.inParallel = parallel;
        if (this.team != null) {
            try {
                this.team.shutdown();
            }
            catch (Exception e) {
                logger.severe(String.format(" Exception in shutting down old ParallelTeam for DualTopologyEnergy: %s", e));
            }
        }
        this.team = parallel ? new ParallelTeam(2) : new ParallelTeam(1);
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        this.doublesTo(previousAcceleration, this.tempA, this.tempB);
        this.dualTopA.setPreviousAcceleration(this.tempA);
        this.dualTopB.setPreviousAcceleration(this.tempB);
    }

    public void setPrintOnFailure(boolean onFail, boolean override) {
        this.dualTopA.setPrintOnFailure(onFail, override);
        this.dualTopB.setPrintOnFailure(onFail, override);
    }

    public void setCoordinates(double[] coordinates) {
        this.doublesTo(coordinates, this.tempA, this.tempB);
        this.dualTopA.setCoordinates(this.tempA);
        this.dualTopB.setCoordinates(this.tempB);
    }

    public void setVelocity(double[] velocity) {
        this.doublesTo(velocity, this.tempA, this.tempB);
        this.dualTopA.setVelocity(this.tempA);
        this.dualTopB.setVelocity(this.tempB);
    }

    private <T> void copyFrom(T[] to, T[] fromA, T[] fromB) {
        int index;
        int i;
        if (to == null) {
            to = Arrays.copyOf(fromA, this.nVarTot);
        }
        for (i = 0; i < this.nVarA; ++i) {
            index = this.indexAToGlobal[i];
            to[index] = fromA[i];
        }
        for (i = 0; i < this.nVarB; ++i) {
            index = this.indexBToGlobal[i];
            assert (index >= this.nShared || to[index].equals(fromB[i]));
            to[index] = fromB[i];
        }
    }

    private void doublesTo(double[] from, double[] toA, double[] toB) {
        toA = toA == null ? new double[this.nVarA] : toA;
        toB = toB == null ? new double[this.nVarB] : toB;
        for (int i = 0; i < this.nVarTot; ++i) {
            int index = this.indexGlobalToA[i];
            if (index >= 0) {
                toA[index] = from[i];
            }
            if ((index = this.indexGlobalToB[i]) < 0) continue;
            toB[index] = from[i];
        }
    }

    private void doublesFrom(double[] to, double[] fromA, double[] fromB) {
        int i;
        to = to == null ? new double[this.nVarTot] : to;
        for (i = 0; i < this.nVarA; ++i) {
            to[this.indexAToGlobal[i]] = fromA[i];
        }
        for (i = 0; i < this.nVarB; ++i) {
            int index = this.indexBToGlobal[i];
            assert (index >= this.nShared || to[index] == fromB[i]);
            to[index] = fromB[i];
        }
    }

    private void doublesFromFunction(double[] to, double[] fromA, double[] fromB, DoubleBinaryOperator funct) {
        int i;
        to = to == null ? new double[this.nVarTot] : to;
        for (i = 0; i < this.nVarA; ++i) {
            to[this.indexAToGlobal[i]] = fromA[i];
        }
        for (i = 0; i < this.nVarB; ++i) {
            int index = this.indexBToGlobal[i];
            if (index < this.nShared) {
                double current = to[index];
                logger.finer(String.format(" Current %g, i %d, index %d", current, i, index));
                to[index] = funct.applyAsDouble(current, fromB[i]);
                logger.finer(String.format(" New: %g", to[index]));
                continue;
            }
            logger.finer(String.format(" Applying %g to i %d index %d, current %g", fromB[i], i, index, to[index]));
            to[index] = fromB[i];
        }
    }

    private void addDoublesFrom(double[] to, double[] fromA, double[] fromB) {
        int i;
        to = to == null ? new double[this.nVarTot] : to;
        Arrays.fill(to, 0.0);
        for (i = 0; i < this.nVarA; ++i) {
            to[this.indexAToGlobal[i]] = fromA[i];
        }
        for (i = 0; i < this.nVarB; ++i) {
            int n = this.indexBToGlobal[i];
            to[n] = to[n] + fromB[i];
        }
    }

    private class EnergyRegion
    extends ParallelRegion {
        private final EnergyASection sectA;
        private final EnergyBSection sectB;
        private double[] x;
        private double[] g;
        private boolean gradient;
        final /* synthetic */ QuadTopologyEnergy this$0;

        EnergyRegion(QuadTopologyEnergy quadTopologyEnergy) {
            QuadTopologyEnergy quadTopologyEnergy2 = quadTopologyEnergy;
            Objects.requireNonNull(quadTopologyEnergy2);
            this.this$0 = quadTopologyEnergy2;
            this.gradient = false;
            this.sectA = new EnergyASection(quadTopologyEnergy);
            this.sectB = new EnergyBSection(quadTopologyEnergy);
        }

        public void finish() {
            this.this$0.totalEnergy = this.this$0.energyA + this.this$0.energyB;
            if (this.gradient) {
                this.this$0.addDoublesFrom(this.g, this.this$0.gA, this.this$0.gB);
                this.this$0.dEdL = this.this$0.dEdL_A + this.this$0.dEdL_B;
                this.this$0.d2EdL2 = this.this$0.d2EdL2_A + this.this$0.d2EdL2_B;
            }
            this.gradient = false;
        }

        public void run() throws Exception {
            this.execute(this.sectA, this.sectB);
        }

        public void setG(double[] g) {
            this.g = g;
            this.setGradient(true);
        }

        public void setGradient(boolean gradient) {
            this.gradient = gradient;
            this.sectA.setGradient(gradient);
            this.sectB.setGradient(gradient);
        }

        public void setVerbose(boolean verbose) {
            this.sectA.setVerbose(verbose);
            this.sectB.setVerbose(verbose);
        }

        public void setX(double[] x) {
            this.x = x;
        }

        public void start() {
            this.this$0.doublesTo(this.x, this.this$0.xA, this.this$0.xB);
        }
    }

    private class EnergyBSection
    extends ParallelSection {
        private boolean verbose;
        private boolean gradient;
        final /* synthetic */ QuadTopologyEnergy this$0;

        private EnergyBSection(QuadTopologyEnergy quadTopologyEnergy) {
            QuadTopologyEnergy quadTopologyEnergy2 = quadTopologyEnergy;
            Objects.requireNonNull(quadTopologyEnergy2);
            this.this$0 = quadTopologyEnergy2;
            this.verbose = false;
            this.gradient = false;
        }

        public void run() throws Exception {
            if (this.gradient) {
                this.this$0.energyB = this.this$0.dualTopB.energyAndGradient(this.this$0.xB, this.this$0.gB, this.verbose);
                this.this$0.dEdL_B = this.this$0.linterB.getdEdL();
                this.this$0.d2EdL2_B = this.this$0.linterB.getd2EdL2();
            } else {
                this.this$0.energyB = this.this$0.dualTopB.energy(this.this$0.xB, this.verbose);
            }
            this.verbose = false;
            this.gradient = false;
        }

        public void setGradient(boolean gradient) {
            this.gradient = gradient;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }
    }

    private class EnergyASection
    extends ParallelSection {
        private boolean verbose;
        private boolean gradient;
        final /* synthetic */ QuadTopologyEnergy this$0;

        private EnergyASection(QuadTopologyEnergy quadTopologyEnergy) {
            QuadTopologyEnergy quadTopologyEnergy2 = quadTopologyEnergy;
            Objects.requireNonNull(quadTopologyEnergy2);
            this.this$0 = quadTopologyEnergy2;
            this.verbose = false;
            this.gradient = false;
        }

        public void run() throws Exception {
            if (this.gradient) {
                this.this$0.energyA = this.this$0.dualTopA.energyAndGradient(this.this$0.xA, this.this$0.gA, this.verbose);
                this.this$0.dEdL_A = this.this$0.linterA.getdEdL();
                this.this$0.d2EdL2_A = this.this$0.linterA.getd2EdL2();
            } else {
                this.this$0.energyA = this.this$0.dualTopA.energy(this.this$0.xA, this.verbose);
            }
            this.verbose = false;
            this.gradient = false;
        }

        public void setGradient(boolean gradient) {
            this.gradient = gradient;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }
    }
}

